/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.StringTokenizer;
import jv.object.PsConfig;
import jv.object.PsDebug;

public class PvScenegraph
extends Panel
implements MouseListener,
MouseMotionListener,
AdjustmentListener {
    protected static final int PREF_WIDTH = 200;
    protected static final int PREF_HEIGHT = 300;
    protected static final int YINCR = 16;
    public static int BGCOLOR = 6;
    public static int TXTCOLOR = 2;
    public static int HBGCOLOR = 2;
    public static int HTXTCOLOR = TXTCOLOR;
    public static int HTXTBGCOLOR = 5;
    public static int OUTLINE = 10;
    protected static final int[][] COLOR = new int[][]{{255, 255, 255}, {150, 150, 150}, {0, 0, 0}, {120, 190, 190}, {150, 220, 220}, {200, 200, 200}, {90, 160, 160}, {247, 156, 57}, {27, 162, 67}, {248, 168, 77}, {63, 63, 63}, {127, 127, 127}, {0, 0, 0}};
    protected Color[] m_color;
    protected int m_bgColor;
    protected int m_txtColor;
    protected int m_hbgColor;
    protected int m_htxtColor;
    protected int m_htxtbgColor;
    protected static final int FIELD_NONE = -3;
    protected static final int FIELD_APPLET = -2;
    protected static final int FIELD_IMAGE = -1;
    protected static final int FIELD_GRAPH = 0;
    protected static final int FIELD_ICON = 1;
    protected static final int FIELD_LABEL = 2;
    protected static final int FIELD_LINK = 3;
    protected static final int NODE_FIRST = 0;
    protected static final int NODE_DIR = 1;
    protected static final int NODE_LEAF = 2;
    protected static final int NODE_DIR_CLOSE = 0;
    protected static final int NODE_DIR_OPEN = 1;
    protected static final int FIELD_EMPHASIZE_NOT = 0;
    protected static final int FIELD_EMPHASIZE_LABEL = 1;
    protected static final int FIELD_EMPHASIZE_LINK = 2;
    protected static final int FIELD_OUTLINE_NOT = 0;
    protected static final int FIELD_OUTLINE_LABEL = 3;
    protected static final int FIELD_OUTLINE_LINK = 4;
    protected static final int POS_NAME = 0;
    protected static final int POS_LABEL = 5;
    protected static final int POS_URL = 1;
    protected static final int POS_TARGET = 2;
    protected static final int POS_HELP_URL = 3;
    protected static final int POS_HELP_TARGET = 4;
    protected static final int POS_PARENT_IND = 0;
    protected static final int POS_NODE_TYPE = 1;
    protected static final int POS_NODE_ICON = 2;
    protected static final int POS_LINK_ICON = 4;
    protected static final int POS_NODE_OPEN_ICON = 6;
    protected static final int POS_NODE_STATUS = 3;
    protected static final int POS_NODE_EMPHASIZE = 5;
    protected static final int POS_NODE_OUTLINE = 7;
    protected static final int ICON_OFF = -1;
    protected static final int ICON_FIRST_NODE = 0;
    protected static final int ICON_DIR = 1;
    protected static final int ICON_FILE = 2;
    protected static final int ICON_HELP = 3;
    protected static final int ICON_DIR_OPEN = 4;
    protected static final int ICON_DIR_OPEN2 = 5;
    protected static final int ICON_DIR2 = 6;
    protected static final int ICON_CHECKED = 7;
    protected static final int ICON_UNCHECKED = 8;
    protected static final int PARENT_ROOT = 0;
    protected String m_title;
    protected String[][] m_nodeText;
    protected int[][] m_nodeIcon;
    protected int m_numNodes;
    protected int m_numParents;
    protected String[] m_parent;
    protected int m_titleFont;
    protected int m_nodeFont;
    protected Font[] m_font;
    protected Image[] m_nodeImg;
    protected int m_width;
    protected int m_height;
    protected int[][] m_field;
    protected int m_fieldCount;
    protected int m_fieldType;
    private Image m_image;
    private Graphics m_g;
    protected Scrollbar m_vScrollbar;
    protected Scrollbar m_hScrollbar;
    protected int m_xScroll;
    protected int m_yScroll;
    protected int m_xLargestPix;
    protected int m_yLargeNumLines;
    protected int m_leftInset = 21;
    protected int m_rightInset = 2;
    protected int m_topInset = 40;
    protected int m_bottomInset = 2;
    protected boolean m_bShowOpen = true;
    protected int[][] m_switchArea = new int[2][4];
    public int m_nodeInd = -1;
    public int m_iconInd;
    public static final int MODE_PANEL = 0;
    public static final int MODE_OVERLAY = 1;
    public int m_panelMode;
    private boolean m_bBeenHere = false;

    public PvScenegraph() {
        this.init();
    }

    public void init() {
        this.m_title = "Scene Graph";
        this.m_titleFont = 0;
        this.m_nodeFont = 1;
        this.m_font = new Font[2];
        this.m_font[this.m_titleFont] = PsConfig.getFont(4);
        this.m_font[this.m_nodeFont] = PsConfig.getFont(0);
        this.m_color = new Color[COLOR.length];
        for (int i = 0; i < COLOR.length; ++i) {
            this.m_color[i] = new Color(COLOR[i][0], COLOR[i][1], COLOR[i][2]);
        }
        this.m_bgColor = BGCOLOR;
        this.m_txtColor = TXTCOLOR;
        this.m_hbgColor = HBGCOLOR;
        this.m_htxtColor = HTXTCOLOR;
        this.m_htxtbgColor = HTXTBGCOLOR;
        this.setLayout(new BorderLayout());
        this.m_vScrollbar = new Scrollbar(1, 0, 1, 0, 20);
        this.m_vScrollbar.setBlockIncrement(1);
        this.m_vScrollbar.addAdjustmentListener(this);
        this.add("East", this.m_vScrollbar);
        this.m_hScrollbar = new Scrollbar(0, 0, 1, 0, 10);
        this.m_hScrollbar.setBlockIncrement(1);
        this.m_hScrollbar.addAdjustmentListener(this);
        this.add("South", this.m_hScrollbar);
        this.m_hScrollbar.setVisible(false);
        this.m_vScrollbar.setVisible(false);
        this.m_xScroll = 0;
        this.m_yScroll = 0;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.validate();
    }

    public int getPanelMode() {
        return this.m_panelMode;
    }

    public void setPanelMode(int n) {
        this.m_panelMode = n;
    }

    public Dimension getPreferredSize() {
        return new Dimension(200, 300);
    }

    public void setParent() {
    }

    public int getNodeInd() {
        return this.m_nodeInd;
    }

    public int getIconInd() {
        return this.m_iconInd;
    }

    public String getNodeID() {
        return this.m_nodeText[this.m_nodeInd][0];
    }

    public String getNodeStatus() {
        return this.m_nodeIcon[this.m_nodeInd][3] == 1 ? "1" : "0";
    }

    public void setTitle(String string) {
        this.m_title = string;
    }

    public void setColors(Color[] colorArray) {
        this.m_color = colorArray;
    }

    public void selectColors(int n, int n2, int n3, int n4) {
        this.m_bgColor = n;
        this.m_txtColor = n2;
        this.m_hbgColor = n3;
        this.m_htxtColor = n4;
    }

    public void setFonts(Font[] fontArray) {
        this.m_font = fontArray;
    }

    public void selectFonts(int n, int n2) {
        this.m_titleFont = n;
        this.m_nodeFont = n2;
    }

    public void setNodeIcons(Image[] imageArray, int n) {
        this.m_nodeImg = imageArray;
    }

    public void setNodeParms(int n, String[] stringArray, int n2) {
        int n3;
        this.m_numNodes = n2;
        this.m_field = new int[3 * this.m_numNodes][6];
        this.m_fieldCount = 0;
        for (n3 = 0; n3 < this.m_numNodes; ++n3) {
            this.m_field[n3][0] = -1;
        }
        this.m_nodeText = new String[this.m_numNodes][6];
        this.m_nodeIcon = new int[this.m_numNodes][8];
        this.m_parent = new String[this.m_numNodes];
        if (this.m_numNodes > 0) {
            this.m_parent[0] = "ROOT";
            this.m_numParents = 1;
        } else {
            this.m_numParents = 0;
        }
        for (n3 = 0; n3 < this.m_numNodes; ++n3) {
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[n3], "|");
            String string = "";
            if (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
            }
            if (stringTokenizer.hasMoreTokens()) {
                this.m_nodeText[n3][0] = stringTokenizer.nextToken();
            }
            if (n > 100) {
                if (stringTokenizer.hasMoreTokens()) {
                    this.m_nodeText[n3][5] = stringTokenizer.nextToken();
                }
            } else {
                this.m_nodeText[n3][5] = this.m_nodeText[n3][0];
            }
            if (stringTokenizer.hasMoreTokens()) {
                this.m_nodeIcon[n3][1] = Integer.parseInt(stringTokenizer.nextToken());
            }
            if (stringTokenizer.hasMoreTokens()) {
                this.m_nodeText[n3][1] = stringTokenizer.nextToken();
            }
            if (stringTokenizer.hasMoreTokens()) {
                this.m_nodeText[n3][2] = stringTokenizer.nextToken();
            }
            if (stringTokenizer.hasMoreTokens()) {
                this.m_nodeText[n3][3] = stringTokenizer.nextToken();
            }
            if (stringTokenizer.hasMoreTokens()) {
                this.m_nodeText[n3][4] = stringTokenizer.nextToken();
            }
            if (stringTokenizer.hasMoreTokens()) {
                this.m_nodeIcon[n3][2] = Integer.parseInt(stringTokenizer.nextToken());
            }
            this.m_nodeIcon[n3][4] = stringTokenizer.hasMoreTokens() ? Integer.parseInt(stringTokenizer.nextToken()) : -1;
            this.m_nodeIcon[n3][6] = stringTokenizer.hasMoreTokens() ? Integer.parseInt(stringTokenizer.nextToken()) : this.m_nodeIcon[n3][2];
            this.m_nodeIcon[n3][3] = stringTokenizer.hasMoreTokens() ? Integer.parseInt(stringTokenizer.nextToken()) : 1;
            this.m_nodeIcon[n3][5] = stringTokenizer.hasMoreTokens() ? Integer.parseInt(stringTokenizer.nextToken()) : 0;
            int n4 = -1;
            for (int i = 0; i < this.m_numParents; ++i) {
                if (!string.equalsIgnoreCase(this.m_parent[i])) continue;
                n4 = i;
                break;
            }
            if (n4 != -1) {
                this.m_nodeIcon[n3][0] = n4;
                continue;
            }
            this.m_parent[this.m_numParents] = string;
            this.m_nodeIcon[n3][0] = this.m_numParents++;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        boolean bl = (n & 4) == 1;
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        int n4 = -3;
        int n5 = -1;
        for (int i = 0; i < this.m_fieldCount; ++i) {
            if (n2 <= this.m_field[i][1] || n2 >= this.m_field[i][3] || n3 <= this.m_field[i][2] || n3 >= this.m_field[i][4]) continue;
            n5 = this.m_field[i][5];
            n4 = this.m_field[i][0];
            break;
        }
        if (n5 != -1) {
            this.m_nodeInd = n5;
            this.m_iconInd = n4;
            mouseEvent.consume();
            if (!bl) {
                return;
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        boolean bl = (n & 0x10) != 0;
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        if (n2 > this.m_switchArea[0][0] && n2 < this.m_switchArea[0][2] && n3 > this.m_switchArea[0][1] && n3 < this.m_switchArea[0][3]) {
            this.m_bShowOpen = true;
            this.globalEffect(this.m_bShowOpen);
        } else if (n2 > this.m_switchArea[1][0] && n2 < this.m_switchArea[1][2] && n3 > this.m_switchArea[1][1] && n3 < this.m_switchArea[1][3]) {
            this.m_bShowOpen = false;
            this.globalEffect(this.m_bShowOpen);
        } else {
            int n4 = -3;
            int n5 = -1;
            for (int i = 0; i < this.m_fieldCount; ++i) {
                if (n2 <= this.m_field[i][1] || n2 >= this.m_field[i][3] || n3 <= this.m_field[i][2] || n3 >= this.m_field[i][4]) continue;
                n5 = this.m_field[i][5];
                n4 = this.m_field[i][0];
                if (!bl) break;
                this.showDoc(n5, this.m_field[i][0]);
                break;
            }
            if (n5 != -1) {
                this.m_nodeInd = n5;
                this.m_iconInd = n4;
                mouseEvent.consume();
                this.m_nodeIcon[this.m_nodeInd][7] = 0;
                if (!bl) {
                    return;
                }
            }
            if (n4 == 0 || n4 == 1) {
                this.m_nodeIcon[this.m_nodeInd][3] = this.m_nodeIcon[this.m_nodeInd][3] == 0 ? 1 : 0;
            } else if (n4 == 2) {
                if (this.m_nodeInd > 2) {
                    this.m_nodeIcon[this.m_nodeInd][5] = 1;
                }
            } else if (n4 == 3) {
                this.m_nodeIcon[this.m_nodeInd][5] = 2;
            }
        }
        if (this.m_panelMode == 0) {
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n;
        if (this.m_field == null) {
            return;
        }
        if (this.m_fieldCount >= this.m_field.length) {
            return;
        }
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        for (n = 0; n < this.m_numNodes; ++n) {
            this.m_nodeIcon[n][7] = 0;
        }
        n = 0;
        boolean bl = false;
        do {
            if (n2 <= this.m_field[n][1] || n2 >= this.m_field[n][3] || n3 <= this.m_field[n][2] || n3 >= this.m_field[n][4]) continue;
            int n4 = this.m_field[n][5];
            int n5 = this.m_field[n][0];
            bl = true;
            if (this.m_nodeIcon[n4][1] != 2) break;
            switch (n5) {
                case 2: {
                    this.m_nodeIcon[n4][7] = 3;
                    break;
                }
                case 3: {
                    this.m_nodeIcon[n4][7] = 4;
                    this.m_bBeenHere = true;
                }
            }
        } while (!bl && ++n < this.m_fieldCount);
        if (bl || this.m_bBeenHere) {
            this.m_bBeenHere = bl;
            mouseEvent.consume();
        }
        if (this.m_panelMode == 0) {
            this.repaint();
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.m_width != dimension.width || this.m_height != dimension.height) {
            this.m_width = dimension.width;
            this.m_height = dimension.height;
            this.m_image = null;
            this.m_g = null;
        }
        if (this.m_height <= 0) {
            return;
        }
        if (this.m_width == 0) {
            PsDebug.warning("missing width of scenegraph panel");
            this.m_width = 200;
        }
        if (this.m_numNodes == 0) {
            return;
        }
        if (this.m_image == null) {
            this.m_image = this.createImage(this.m_width, this.m_height);
            this.m_g = this.m_image.getGraphics();
        }
        if (this.m_g == null) {
            PsDebug.warning("missing offscreen graphics, should not happen");
            return;
        }
        this.m_g.setColor(this.m_color[this.m_bgColor]);
        this.m_g.fillRect(0, 0, this.m_width, this.m_height);
        this.drawTree(this.m_g);
        this.drawBorder(this.m_g);
        graphics.drawImage(this.m_image, 0, 0, this);
    }

    public void paintOverlay(Graphics graphics, int n, int n2, int n3, int n4) {
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        if (this.m_numNodes == 0) {
            return;
        }
        this.m_leftInset = n;
        this.m_topInset = n2;
        this.m_width = n3;
        this.m_height = n4;
        this.drawHeader(graphics);
        this.drawTree(graphics);
    }

    private void drawHeader(Graphics graphics) {
        graphics.setColor(this.m_color[this.m_txtColor]);
        graphics.setFont(this.m_font[this.m_titleFont]);
        FontMetrics fontMetrics = graphics.getFontMetrics(this.m_font[this.m_titleFont]);
        int n = fontMetrics.getHeight();
        String string = this.m_title;
        graphics.drawString(string, 15, (40 + n) / 2);
    }

    private void drawBorder(Graphics graphics) {
        graphics.setColor(this.m_color[7]);
        int n = 1;
        graphics.drawLine(0, 0, this.m_width - 1, 0);
        graphics.drawLine(0, 0, 0, this.m_height - 1);
        graphics.drawLine(n, 30, this.m_width - 1 - n, 30);
        graphics.drawLine(this.m_width - 1 - n, n, this.m_width - 1 - n, 30);
        graphics.drawLine(n, this.m_height - 1 - n, this.m_width - 1 - n, this.m_height - 1 - n);
        graphics.drawLine(this.m_width - 1 - n, 30 + n, this.m_width - 1 - n, this.m_height - 1 - n);
        graphics.setColor(this.m_color[8]);
        graphics.drawLine(this.m_width - 1, 0, this.m_width - 1, this.m_height - 1);
        graphics.drawLine(0, this.m_height - 1, this.m_width - 1, this.m_height - 1);
        graphics.drawLine(n, n, this.m_width - 1 - n, n);
        graphics.drawLine(n, n, n, 30);
        graphics.drawLine(n, 30 + n, this.m_width - 1 - n, 30 + n);
        graphics.drawLine(n, 30 + n, n, this.m_height - 1 - n);
    }

    private void drawTree(Graphics graphics) {
        this.m_fieldCount = 0;
        this.m_xLargestPix = 0;
        this.m_yLargeNumLines = 0;
        int n = this.m_leftInset;
        int n2 = this.m_topInset + 16;
        int n3 = n - this.m_xScroll;
        int n4 = n2 - this.m_yScroll;
        graphics.setFont(this.m_font[this.m_nodeFont]);
        this.drawLeafs(graphics, 0, n3, n4);
        if (this.m_panelMode == 0) {
            this.checkScroll();
        }
    }

    private int drawLeafs(Graphics graphics, int n, int n2, int n3) {
        FontMetrics fontMetrics = graphics.getFontMetrics(this.m_font[this.m_nodeFont]);
        int n4 = n3 - 16;
        int n5 = -1;
        boolean bl = false;
        for (int i = 0; i < this.m_numNodes; ++i) {
            int n6;
            if (this.m_nodeIcon[i][0] != n) continue;
            ++this.m_yLargeNumLines;
            if (n3 > this.m_topInset && n3 + 4 <= this.m_height - 1) {
                graphics.setColor(this.m_color[11]);
                if (n5 == -1) {
                    if (n != 0) {
                        if (bl) {
                            graphics.setColor(Color.black);
                        }
                        graphics.drawLine(n2, n4, n2, n3 - 12);
                    }
                } else if (this.m_nodeIcon[n5][1] == 1) {
                    if (bl) {
                        graphics.setColor(Color.magenta);
                    }
                    graphics.drawLine(n2, n4 - 2, n2, n3 - 12);
                } else {
                    if (bl) {
                        graphics.setColor(Color.orange);
                    }
                    graphics.drawLine(n2, n4 - 7, n2, n3 - 12);
                }
                n4 = -1;
                if (bl) {
                    graphics.setColor(Color.yellow);
                }
                if (this.m_nodeIcon[i][1] == 1) {
                    graphics.drawRect(n2 - 4, n3 - 11, 8, 8);
                    this.addArea(0, n2 - 5, n3 - 12, n2 + 6, n3 - 2, i);
                    graphics.drawLine(n2 - 2, n3 - 7, n2 + 2, n3 - 7);
                    if (this.m_nodeIcon[i][3] == 0) {
                        graphics.drawLine(n2, n3 - 9, n2, n3 - 5);
                    }
                    graphics.drawLine(n2 + 5, n3 - 7, n2 + 8, n3 - 7);
                } else {
                    if (bl) {
                        graphics.setColor(Color.gray);
                    }
                    if (i != 0) {
                        graphics.drawLine(n2, n3 - 11, n2, n3 - 7);
                    }
                    graphics.drawLine(n2, n3 - 7, n2 + 8, n3 - 7);
                }
                if (this.m_nodeImg != null) {
                    if (this.m_nodeIcon[i][3] == 1) {
                        graphics.drawImage(this.m_nodeImg[this.m_nodeIcon[i][6]], n2 + 9, n3 - 12, this);
                    } else {
                        graphics.drawImage(this.m_nodeImg[this.m_nodeIcon[i][2]], n2 + 9, n3 - 12, this);
                    }
                }
                this.addArea(1, n2 + 8, n3 - 12, n2 + 24, n3 + 2, i);
                n6 = fontMetrics.stringWidth(this.m_nodeText[i][5]);
                if (this.m_nodeIcon[i][5] == 1) {
                    graphics.setColor(this.m_color[this.m_htxtbgColor]);
                    graphics.fillRect(n2 + 25, n3 - 13, n6 + 4, 16);
                }
                if (this.m_nodeIcon[i][7] == 3) {
                    graphics.setColor(this.m_color[OUTLINE]);
                    graphics.drawRect(n2 + 25, n3 - 13, n6 + 4, 16);
                    graphics.setColor(this.m_color[11]);
                    graphics.drawLine(n2 + 25, n3 + 3, n2 + 29 + n6, n3 + 3);
                    graphics.drawLine(n2 + 29 + n6, n3 + 3, n2 + 29 + n6, n3 - 13);
                }
                if (this.m_nodeIcon[i][5] == 1) {
                    graphics.setColor(this.m_color[this.m_htxtColor]);
                } else {
                    graphics.setColor(this.m_color[this.m_txtColor]);
                }
                graphics.drawString(this.m_nodeText[i][5], n2 + 28, n3);
                this.addArea(2, n2 + 25, n3 - 12, n2 + 25 + n6, n3 + 2, i);
                if (this.m_nodeIcon[i][4] != -1) {
                    if (this.m_nodeIcon[i][5] == 2) {
                        graphics.setColor(this.m_color[this.m_htxtbgColor]);
                        graphics.fillRect(n2 + 31 + n6, n3 - 13, 16, 16);
                    }
                    if (this.m_nodeIcon[i][7] == 4) {
                        graphics.setColor(this.m_color[OUTLINE]);
                        graphics.drawRect(n2 + 31 + n6, n3 - 13, 16, 16);
                        graphics.setColor(this.m_color[11]);
                        graphics.drawLine(n2 + 31 + n6, n3 + 3, n2 + 47 + n6, n3 + 3);
                        graphics.drawLine(n2 + 47 + n6, n3 - 13, n2 + 47 + n6, n3 + 3);
                    }
                    if (this.m_nodeImg != null) {
                        graphics.drawImage(this.m_nodeImg[this.m_nodeIcon[i][4]], n2 + 32 + n6, n3 - 12, this);
                    }
                    this.addArea(3, n2 + 31 + n6, n3 - 12, n2 + 47 + n6, n3 + 2, i);
                }
            } else if (n3 + 4 > this.m_height - 1) {
                n3 = Math.min(this.m_height - 1, n3);
                graphics.setColor(this.m_color[11]);
                if (bl) {
                    graphics.setColor(Color.black);
                }
                if (n5 == -1) {
                    if (n == 0) break;
                    if (bl) {
                        graphics.setColor(Color.black);
                    }
                    graphics.drawLine(n2, n4, n2, n3 - 12);
                    break;
                }
                if (this.m_nodeIcon[n5][1] == 1) {
                    if (bl) {
                        graphics.setColor(Color.magenta);
                    }
                    graphics.drawLine(n2, n4 - 2, n2, n3 - 12);
                    break;
                }
                if (bl) {
                    graphics.setColor(Color.orange);
                }
                graphics.drawLine(n2, n4 - 7, n2, n3 - 12);
                break;
            }
            n4 = n3;
            if (n4 < 0) {
                n4 = 0;
            }
            n3 += 16;
            if (this.m_nodeIcon[i][3] == 1) {
                n6 = 0;
                for (int j = 1; j < this.m_numParents; ++j) {
                    if (!this.m_nodeText[i][0].equals(this.m_parent[j])) continue;
                    n6 = j;
                    break;
                }
                if (n6 != 0) {
                    n3 = this.drawLeafs(graphics, n6, n2 + 16, n3);
                }
            }
            n5 = i;
        }
        return n3;
    }

    private void addArea(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.m_field == null) {
            return;
        }
        if (this.m_fieldCount >= this.m_field.length) {
            PsDebug.warning("too many field entries, m_fieldCount = " + this.m_fieldCount);
            return;
        }
        this.m_field[this.m_fieldCount][0] = n;
        this.m_field[this.m_fieldCount][1] = n2 - 1 - 20;
        this.m_field[this.m_fieldCount][2] = n3 - 1;
        this.m_field[this.m_fieldCount][3] = n4 + 1;
        this.m_field[this.m_fieldCount][4] = n5 + 1;
        this.m_field[this.m_fieldCount][5] = n6;
        ++this.m_fieldCount;
        this.m_xLargestPix = Math.max(this.m_xLargestPix, n4 + 6);
    }

    private void checkScroll() {
        int n;
        boolean bl;
        boolean bl2 = this.m_hScrollbar.isVisible();
        boolean bl3 = this.m_vScrollbar.isVisible();
        int n2 = this.m_width - 11;
        boolean bl4 = bl = this.m_xLargestPix + this.m_xScroll >= n2;
        if (bl2 != bl) {
            if (bl) {
                this.m_hScrollbar.setMaximum((this.m_xLargestPix + this.m_xScroll - 3 * this.m_width / 4 + 25) / 10);
            } else {
                this.m_xScroll = 0;
                this.m_hScrollbar.setValue(0);
            }
            this.m_hScrollbar.setVisible(bl);
            this.validate();
            this.repaint();
        }
        boolean bl5 = bl = this.m_yLargeNumLines >= (n = (this.m_height - this.m_topInset) / 16);
        if (bl3 != bl) {
            if (bl) {
                this.m_vScrollbar.setMaximum(this.m_yLargeNumLines - n + 1 + 1);
            } else {
                this.m_yScroll = 0;
                this.m_vScrollbar.setValue(0);
            }
            this.m_vScrollbar.setVisible(bl);
            this.validate();
            this.repaint();
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Object object = adjustmentEvent.getSource();
        if (this.m_vScrollbar.isVisible()) {
            this.m_yScroll = 16 * this.m_vScrollbar.getValue();
        }
        if (this.m_hScrollbar.isVisible()) {
            this.m_xScroll = 10 * this.m_hScrollbar.getValue();
        }
        if (object == this.m_vScrollbar || object == this.m_hScrollbar) {
            this.repaint();
        }
    }

    private void globalEffect(boolean bl) {
        for (int i = 0; i < this.m_numNodes; ++i) {
            if (this.m_nodeIcon[i][1] != 1) continue;
            this.m_nodeIcon[i][3] = bl ? 1 : 0;
        }
    }

    private void showDoc(int n, int n2) {
        if (n < 0 || n >= this.m_nodeIcon.length) {
            return;
        }
        String string = null;
        switch (n2) {
            case -2: {
                break;
            }
            case -1: {
                break;
            }
            case 0: 
            case 1: {
                if (this.m_nodeText[n][1].endsWith("index.html") && this.m_nodeText[n][1].endsWith("index.htm")) break;
                string = this.m_nodeText[n][1];
                break;
            }
            case 2: {
                if (this.m_nodeText[n][1] == null || (string = this.m_nodeText[n][1]).endsWith(".html") || string.endsWith(".htm")) break;
                if (this.m_bShowOpen) {
                    string = string + "applet.html";
                    break;
                }
                string = string + "preview.html";
                break;
            }
            case 3: {
                if (this.m_nodeText[n][3] == null || (string = this.m_nodeText[n][3]).endsWith(".html") || string.endsWith(".htm")) break;
                string = this.m_bShowOpen ? string + "applet.html" : string + "preview.html";
            }
        }
        if (string != null) {
            // empty if block
        }
    }
}

