/*
 * Decompiled with CFR 0.152.
 */
package jv.vecmath;

import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PuMath;

public class PuVectorGeom {
    public static double intersectionOfLineAndLine(PdVector pdVector, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4, PdVector pdVector5) {
        double d = PdVector.dot(pdVector3, pdVector5);
        double d2 = 1.0 - d * d;
        if (Math.abs(d2) < 1.0E-10) {
            return Double.MAX_VALUE;
        }
        double d3 = 0.0;
        for (int i = pdVector.getSize() - 1; i >= 0; --i) {
            d3 += (pdVector4.m_data[i] - pdVector2.m_data[i]) * (pdVector3.m_data[i] - d * pdVector5.m_data[i]);
        }
        pdVector.blendBase(pdVector2, d3 /= d2, pdVector3);
        return d3;
    }

    public static double intersectionOfLineAndPlane(PdVector pdVector, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4, PdVector pdVector5) {
        double d = PdVector.dot(pdVector5, pdVector3);
        if (Math.abs(d) < 1.0E-10) {
            return Double.MAX_VALUE;
        }
        double d2 = 0.0;
        for (int i = pdVector.getSize() - 1; i >= 0; --i) {
            d2 += (pdVector4.m_data[i] - pdVector2.m_data[i]) * pdVector5.m_data[i];
        }
        pdVector.blendBase(pdVector2, d2 /= d, pdVector3);
        return d2;
    }

    public static boolean intersectionOfPlaneAndPlane(PdVector pdVector, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4, PdVector pdVector5, PdVector pdVector6) {
        double d = PdVector.dot(pdVector4, pdVector6);
        double d2 = 1.0 - d * d;
        if (Math.abs(d2) < 1.0E-10) {
            return false;
        }
        pdVector2.cross(pdVector4, pdVector6);
        pdVector2.normalize();
        double d3 = PdVector.dot(pdVector4, pdVector3);
        double d4 = PdVector.dot(pdVector6, pdVector5);
        double d5 = (d3 - d4 * d) / d2;
        double d6 = (d4 - d3 * d) / d2;
        pdVector.blend(d5, pdVector4, d6, pdVector6);
        return true;
    }

    public static void distVectorOfPointToLine(PdVector pdVector, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4) {
        PuVectorGeom.projectPointToLine(pdVector, pdVector2, pdVector3, pdVector4);
        pdVector.sub(pdVector2);
    }

    public static void distVectorOfPointToPlane(PdVector pdVector, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4) {
        PuVectorGeom.projectPointToPlane(pdVector, pdVector2, pdVector3, pdVector4);
        pdVector.sub(pdVector2);
    }

    public static double distVectorOfLineToLine(PdVector pdVector, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4, PdVector pdVector5) {
        double d = PuVectorGeom.distOfLineToLine(pdVector2, pdVector3, pdVector4, pdVector5);
        pdVector.cross(pdVector3, pdVector5);
        pdVector.setLength(d);
        return d;
    }

    public static double distOfPointToLine(PdVector pdVector, PdVector pdVector2, PdVector pdVector3) {
        double d;
        if (Math.abs(pdVector3.sqrLength() - 1.0) > 1.0E-10) {
            PsDebug.warning("line dir not normalized");
            return Double.MAX_VALUE;
        }
        double d2 = pdVector.sqrDist(pdVector2);
        double d3 = d2 - (d = PdVector.dotDir(pdVector3, pdVector, pdVector2)) * d;
        if (d3 < 0.0) {
            PsDebug.warning("maybe line dir not normalized");
            return 0.0;
        }
        return Math.sqrt(d3);
    }

    public static double distOfPointToPlane(PdVector pdVector, PdVector pdVector2, PdVector pdVector3) {
        if (Math.abs(pdVector3.sqrLength() - 1.0) > 1.0E-10) {
            PsDebug.warning("normal to plane not normalized");
            return Double.MAX_VALUE;
        }
        double d = PdVector.dotDir(pdVector3, pdVector, pdVector2);
        return d;
    }

    public static double distOfLineToLine(PdVector pdVector, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4) {
        PdVector pdVector5 = PdVector.subNew(pdVector, pdVector3);
        PdVector pdVector6 = PdVector.crossNew(pdVector2, pdVector4);
        double d = pdVector6.length();
        if (d < 1.0E-10) {
            double d2 = pdVector2.sqrLength();
            double d3 = pdVector4.sqrLength();
            if (d2 < 1.0E-10 && d3 < 1.0E-10) {
                d = PdVector.dist(pdVector, pdVector3);
            } else if (d3 > 1.0E-10) {
                PdVector pdVector7;
                if (Math.abs(d3 - 1.0) > 1.0E-10) {
                    pdVector7 = PdVector.copyNew(pdVector4);
                    pdVector7.normalize();
                } else {
                    pdVector7 = pdVector4;
                }
                d = PuVectorGeom.distOfPointToLine(pdVector, pdVector3, pdVector7);
            } else if (d2 > 1.0E-10) {
                PdVector pdVector8;
                if (Math.abs(d2 - 1.0) > 1.0E-10) {
                    pdVector8 = PdVector.copyNew(pdVector2);
                    pdVector8.normalize();
                } else {
                    pdVector8 = pdVector4;
                }
                d = PuVectorGeom.distOfPointToLine(pdVector, pdVector3, pdVector8);
            }
        } else {
            d = Math.abs(PdVector.dot(pdVector5, pdVector6)) / d;
        }
        return d;
    }

    public static void projectPointToLine(PdVector pdVector, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4) {
        if (Math.abs(pdVector4.sqrLength() - 1.0) > 1.0E-10) {
            PsDebug.warning("line dir not normalized");
            return;
        }
        double d = 0.0;
        for (int i = pdVector.getSize() - 1; i >= 0; --i) {
            d += (pdVector2.m_data[i] - pdVector3.m_data[i]) * pdVector4.m_data[i];
        }
        pdVector.blendBase(pdVector3, d, pdVector4);
    }

    public static void projectPointToPlane(PdVector pdVector, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4) {
        if (Math.abs(pdVector4.sqrLength() - 1.0) > 1.0E-10) {
            PsDebug.warning("plane normal not normalized");
            return;
        }
        double d = 0.0;
        for (int i = pdVector.getSize() - 1; i >= 0; --i) {
            d += (pdVector2.m_data[i] - pdVector3.m_data[i]) * pdVector4.m_data[i];
        }
        pdVector.blendBase(pdVector2, -d, pdVector4);
    }

    public static void projectPointToCircle(PdVector pdVector, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4, double d) {
        if (Math.abs(pdVector4.sqrLength() - 1.0) > 1.0E-10) {
            PsDebug.warning("plane normal not normalized");
            return;
        }
        PuVectorGeom.projectPointToPlane(pdVector, pdVector2, pdVector3, pdVector4);
        double d2 = d / PdVector.dist(pdVector3, pdVector);
        pdVector.blend(d2, pdVector, 1.0 - d2, pdVector3);
    }

    public static void projectOntoLine(PdVector pdVector, PdVector pdVector2) {
        PuVectorGeom.projectOntoLine(pdVector, pdVector, pdVector2);
    }

    public static void projectOntoLine(PdVector pdVector, PdVector pdVector2, PdVector pdVector3) {
        if (Math.abs(pdVector3.sqrLength() - 1.0) > 1.0E-10) {
            PsDebug.warning("line dir not normalized", pdVector3);
            return;
        }
        double d = PdVector.dot(pdVector2, pdVector3);
        for (int i = 0; i < pdVector2.m_data.length; ++i) {
            pdVector.m_data[i] = d * pdVector3.m_data[i];
        }
    }

    public static void projectOntoPlane(PdVector pdVector, PdVector pdVector2) {
        PuVectorGeom.projectOntoPlane(pdVector, pdVector, pdVector2);
    }

    public static void projectOntoPlane(PdVector pdVector, PdVector pdVector2, PdVector pdVector3) {
        if (Math.abs(pdVector3.sqrLength() - 1.0) > 1.0E-10) {
            PsDebug.warning("plane normal not normalized", pdVector3);
            return;
        }
        double d = PdVector.dot(pdVector2, pdVector3);
        for (int i = 0; i < pdVector2.m_data.length; ++i) {
            pdVector.m_data[i] = pdVector2.m_data[i] - d * pdVector3.m_data[i];
        }
    }

    public static boolean circleThruPoints(PdVector pdVector, double d, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4) {
        double d2;
        double d3;
        PdVector pdVector5 = PdVector.subNew(pdVector3, pdVector2);
        PdVector pdVector6 = PdVector.subNew(pdVector4, pdVector2);
        double d4 = pdVector5.sqrLength();
        double d5 = 2.0 * (d4 * (d3 = pdVector6.sqrLength()) - (d2 = PdVector.dot(pdVector5, pdVector6)) * d2);
        if (d5 < 1.0E-10) {
            for (int i = 0; i < 3; ++i) {
                pdVector.m_data[i] = (pdVector2.m_data[i] + pdVector3.m_data[i] + pdVector4.m_data[i]) / 3.0;
            }
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            pdVector.m_data[i] = ((pdVector5.m_data[i] + pdVector6.m_data[i]) * d4 * d3 - (pdVector5.m_data[i] * d3 + pdVector6.m_data[i] * d4) * d2) / d5;
        }
        pdVector.add(pdVector2);
        return true;
    }

    public static boolean evalCircle(PdVector pdVector, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4, PdVector pdVector5, double d) {
        double d2;
        if (Math.abs(1.0 - d) < 1.0E-10) {
            pdVector.copy(pdVector5);
            return true;
        }
        if (Math.abs(d) < 1.0E-10) {
            pdVector.copy(pdVector4);
            return true;
        }
        if (PdVector.sqrDist(pdVector4, pdVector5) < 1.0E-10) {
            d2 = Math.PI * 2;
        } else {
            PdVector pdVector6 = PdVector.subNew(pdVector4, pdVector2);
            PdVector pdVector7 = PdVector.subNew(pdVector5, pdVector2);
            d2 = PdVector.angleWithOrientation(pdVector6, pdVector7, pdVector3);
        }
        return PuVectorGeom.rotatePointAroundLine(pdVector, pdVector4, pdVector2, pdVector3, d * d2);
    }

    public static boolean evalHelix(PdVector pdVector, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4, PdVector pdVector5, double d) {
        if (Math.abs(1.0 - d) < 1.0E-10) {
            pdVector.copy(pdVector5);
            return true;
        }
        if (Math.abs(d) < 1.0E-10) {
            pdVector.copy(pdVector4);
            return true;
        }
        if (PdVector.sqrDist(pdVector4, pdVector5) < 1.0E-10) {
            PsDebug.warning("axis has zero length");
            return false;
        }
        int n = pdVector.getSize();
        PdVector pdVector6 = new PdVector(n);
        PdVector pdVector7 = new PdVector(n);
        PuVectorGeom.distVectorOfPointToLine(pdVector6, pdVector4, pdVector2, pdVector3);
        PuVectorGeom.distVectorOfPointToLine(pdVector7, pdVector5, pdVector2, pdVector3);
        if (pdVector6.sqrLength() < 1.0E-10 || pdVector7.sqrLength() < 1.0E-10) {
            PsDebug.warning("wings of zero length occurred");
            return false;
        }
        if (Math.abs(pdVector6.sqrLength() - pdVector7.sqrLength()) > pdVector7.sqrLength() / 100.0) {
            PsDebug.warning("wings have different length");
        }
        pdVector3.normalize();
        double d2 = PdVector.angleWithOrientation(pdVector6, pdVector7, pdVector3);
        if (!PuVectorGeom.rotatePointAroundLine(pdVector, pdVector4, pdVector2, pdVector3, d2 *= d)) {
            return false;
        }
        PdVector pdVector8 = PdVector.subNew(pdVector5, pdVector4);
        double d3 = PdVector.dot(pdVector8, pdVector3);
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            pdVector.m_data[n2] = pdVector.m_data[n2] + d * (d3 * pdVector3.m_data[i]);
        }
        return true;
    }

    public static boolean rotatePointAroundVector(PdVector pdVector, PdVector pdVector2, PdVector pdVector3, double d) {
        if (Math.abs(pdVector3.sqrLength() - 1.0) > 1.0E-10) {
            PsDebug.warning("axis dir not normalized");
            pdVector.copy(pdVector2);
            return false;
        }
        PdVector pdVector4 = pdVector2.orthogonalPart(null, pdVector3);
        PdVector pdVector5 = PdVector.crossNew(pdVector3, pdVector2);
        for (int i = 0; i < pdVector2.m_data.length; ++i) {
            pdVector.m_data[i] = pdVector2.m_data[i] - pdVector4.m_data[i] + Math.cos(d) * pdVector4.m_data[i] + Math.sin(d) * pdVector5.m_data[i];
        }
        return true;
    }

    public static boolean rotatePointAroundLine(PdVector pdVector, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4, double d) {
        PdVector pdVector5 = PdVector.subNew(pdVector2, pdVector3);
        if (!PuVectorGeom.rotatePointAroundVector(pdVector, pdVector5, pdVector4, d)) {
            pdVector.copy(pdVector2);
            return false;
        }
        pdVector.add(pdVector3);
        return true;
    }

    public static double ctg(PdVector pdVector, PdVector pdVector2, PdVector pdVector3) {
        double d = pdVector.sqrDist(pdVector2) * pdVector.sqrDist(pdVector3);
        if (d <= 0.0) {
            PsDebug.warning("triangle length=0", pdVector);
            return 1.0E90;
        }
        double d2 = PdVector.dot(pdVector, pdVector2, pdVector3) / Math.sqrt(d);
        if (d2 >= 1.0) {
            PsDebug.warning("cos >= 1.", pdVector);
            return 1.0E90;
        }
        double d3 = Math.sqrt(1.0 - d2 * d2);
        if (d3 <= 0.0) {
            PsDebug.warning("sin <= 0.", pdVector);
            return 1.0E90;
        }
        return d2 / d3;
    }

    public static void ctg(double[] dArray, PdVector pdVector, PdVector pdVector2, PdVector pdVector3) {
        double d = PdVector.dist(pdVector2, pdVector3);
        double d2 = PdVector.dist(pdVector3, pdVector);
        double d3 = PdVector.dist(pdVector, pdVector2);
        PuMath.ctg(dArray, d, d2, d3);
    }

    public static double sphericalAngle(PdVector pdVector, PdVector pdVector2, PdVector pdVector3) {
        PdVector pdVector4 = PdVector.blendNew(1.0, pdVector2, -PdVector.dot(pdVector2, pdVector), pdVector);
        PdVector pdVector5 = PdVector.blendNew(1.0, pdVector3, -PdVector.dot(pdVector3, pdVector), pdVector);
        return PdVector.angle(pdVector4, pdVector5);
    }

    public static double sphericalArea(PdVector pdVector, PdVector pdVector2, PdVector pdVector3) {
        double d = PuVectorGeom.sphericalAngle(pdVector, pdVector2, pdVector3);
        double d2 = PuVectorGeom.sphericalAngle(pdVector2, pdVector, pdVector3);
        double d3 = PuVectorGeom.sphericalAngle(pdVector3, pdVector2, pdVector);
        return d + d2 + d3 - Math.PI;
    }

    public static double[] frameToStandardFrame(PdVector pdVector, PdVector pdVector2, PdVector pdVector3) {
        if (pdVector == null || pdVector2 == null || pdVector3 == null || pdVector.getSize() != 3 || pdVector2.getSize() != 3 || pdVector3.getSize() != 3) {
            PsDebug.warning("wrong argument(s)");
            return null;
        }
        PdVector pdVector4 = new PdVector(3);
        PdVector pdVector5 = new PdVector(3);
        PdVector pdVector6 = new PdVector(1.0, 0.0, 0.0);
        PdVector pdVector7 = new PdVector(0.0, 1.0, 0.0);
        PdVector pdVector8 = new PdVector(0.0, 0.0, 1.0);
        pdVector5.set(0.0, 1.0, 0.0);
        pdVector5.multScalar(-PdVector.dot(pdVector5, pdVector3));
        pdVector5.add(pdVector3);
        double d = PdVector.angleWithOrientation(pdVector5, pdVector8, pdVector7);
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double[] dArray = pdVector.m_data;
        pdVector4.set(d2 * dArray[0] + d3 * dArray[2], dArray[1], -d3 * dArray[0] + d2 * dArray[2]);
        dArray = pdVector3.m_data;
        pdVector5.set(d2 * dArray[0] + d3 * dArray[2], dArray[1], -d3 * dArray[0] + d2 * dArray[2]);
        double d4 = PdVector.angleWithOrientation(pdVector5, pdVector8, pdVector6);
        d2 = Math.cos(d4);
        d3 = Math.sin(d4);
        dArray = pdVector4.m_data;
        pdVector4.set(dArray[0], d2 * dArray[1] - d3 * dArray[2], d3 * dArray[1] + d2 * dArray[2]);
        dArray = pdVector5.m_data;
        pdVector5.set(dArray[0], d2 * dArray[1] - d3 * dArray[2], d3 * dArray[1] + d2 * dArray[2]);
        double d5 = PdVector.angleWithOrientation(pdVector4, pdVector6, pdVector8);
        double[] dArray2 = new double[]{d, d4, d5};
        return dArray2;
    }
}

