/*
 * Decompiled with CFR 0.152.
 */
package jv.object;

import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import jv.object.PsActionSupport;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsStackLayout;
import jv.object.PsUpdateIf;
import jv.object.PsUtil;
import jv.object.PsViewerIf;

public class PsDialog
extends Dialog
implements PsUpdateIf,
ActionListener,
ContainerListener,
KeyListener,
WindowListener {
    public static final int BUTTON_CANCEL = 1;
    public static final int BUTTON_HIDE = 2;
    public static final int BUTTON_OK = 4;
    public static final int BUTTON_RESET = 8;
    public static final int BUTTON_CLOSE = 16;
    public static final int BUTTON_SAVE = 32;
    public static final int BUTTON_CLEAR = 64;
    public static final int BUTTON_LOAD = 128;
    public static final int BUTTON_APPLY = 256;
    protected PsUpdateIf m_parent = null;
    private PsActionSupport m_actionSupport = null;
    protected int m_action = 1;
    protected Button m_bCancel;
    protected Button m_bHide;
    protected Button m_bOk;
    protected Button m_bReset;
    protected Button m_bClose;
    protected Button m_bLoad;
    protected Button m_bSave;
    protected Button m_bClear;
    protected Button m_bApply;
    protected Label m_lHeader;
    protected int m_insetSizeHor = 5;
    protected int m_insetSizeVer = 5;

    public PsDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        this.addKeyAndContainerListenerRecursively(this);
        this.addWindowListener(this);
        this.setLayout(new PsStackLayout(5));
        if (this.instanceOf("PsDialog")) {
            this.init();
        }
    }

    public PsDialog(Frame frame, boolean bl) {
        this(frame, null, bl);
    }

    public void init() {
        ((Component)this).setFont(PsConfig.getFont(0));
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        return new Insets(insets.top + this.m_insetSizeVer, insets.left + this.m_insetSizeHor, insets.bottom + this.m_insetSizeVer, insets.right + this.m_insetSizeHor);
    }

    public void setInsetSize(int n) {
        this.m_insetSizeHor = n;
        this.m_insetSizeVer = n;
    }

    public Panel getBottomButtons(int n) {
        Panel panel = new Panel(new FlowLayout(1));
        if (PsUtil.hasBits(n, 4)) {
            this.m_bOk = new Button(PsConfig.getMessage(24137));
            this.m_bOk.addActionListener(this);
            panel.add(this.m_bOk);
        }
        if (PsUtil.hasBits(n, 1)) {
            this.m_bCancel = new Button(PsConfig.getMessage(24138));
            this.m_bCancel.addActionListener(this);
            panel.add(this.m_bCancel);
        }
        if (PsUtil.hasBits(n, 8)) {
            this.m_bReset = new Button(PsConfig.getMessage(24104));
            this.m_bReset.addActionListener(this);
            panel.add(this.m_bReset);
        }
        if (PsUtil.hasBits(n, 2)) {
            this.m_bHide = new Button(PsConfig.getMessage(24139));
            this.m_bHide.addActionListener(this);
            panel.add(this.m_bHide);
        }
        if (PsUtil.hasBits(n, 16)) {
            this.m_bClose = new Button(PsConfig.getMessage(24140));
            this.m_bClose.addActionListener(this);
            panel.add(this.m_bClose);
        }
        if (PsUtil.hasBits(n, 128)) {
            this.m_bLoad = new Button(PsConfig.getMessage(24094));
            this.m_bLoad.addActionListener(this);
            this.m_bLoad.setEnabled(PsConfig.isApplication());
            panel.add(this.m_bLoad);
        }
        if (PsUtil.hasBits(n, 32)) {
            this.m_bSave = new Button(PsConfig.getMessage(24141));
            this.m_bSave.addActionListener(this);
            panel.add(this.m_bSave);
        }
        if (PsUtil.hasBits(n, 64)) {
            this.m_bClear = new Button(PsConfig.getMessage(24136));
            this.m_bClear.addActionListener(this);
            panel.add(this.m_bClear);
        }
        if (PsUtil.hasBits(n, 256)) {
            this.m_bApply = new Button(PsConfig.getMessage(true, 24000, "Apply"));
            this.m_bApply.addActionListener(this);
            panel.add(this.m_bApply);
        }
        return panel;
    }

    public Label setHeader(String string) {
        if (this.m_lHeader == null) {
            this.m_lHeader = new Label(string, 0);
            this.m_lHeader.setFont(PsConfig.getFont(3));
        } else {
            this.m_lHeader.setText(string);
        }
        return this.m_lHeader;
    }

    public final boolean instanceOf(String string) {
        String string2 = this.getClass().getName();
        return string2.endsWith(string);
    }

    public PsUpdateIf getFather() {
        return this.m_parent;
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        this.m_parent = psUpdateIf;
    }

    public boolean update(Object object) {
        if (object == null) {
            return true;
        }
        if (object == this.m_parent) {
            return true;
        }
        PsDebug.warning("could not handle event = " + object.toString() + "\n\tmissing implementation of update(Object)");
        return false;
    }

    public void reset() {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_bOk) {
            this.setUserAction(4);
            this.dispose();
        } else if (object == this.m_bClear) {
            this.setUserAction(64);
        } else if (object == this.m_bCancel) {
            this.setUserAction(1);
            this.dispose();
        } else if (object == this.m_bReset) {
            this.setUserAction(8);
            this.reset();
        } else if (object == this.m_bHide) {
            this.setUserAction(2);
            ((Component)this).setVisible(false);
        } else if (object == this.m_bClose) {
            this.setUserAction(16);
            this.dispose();
        } else if (object == this.m_bLoad) {
            this.setUserAction(128);
        } else if (object == this.m_bSave) {
            this.setUserAction(32);
        } else if (object == this.m_bApply) {
            this.setUserAction(256);
        }
    }

    public int getUserAction() {
        return this.m_action;
    }

    protected void setUserAction(int n) {
        this.m_action = n;
        this.fireAction(this.m_action, "");
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.setUserAction(1);
        this.dispose();
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.m_actionSupport == null) {
            this.m_actionSupport = new PsActionSupport();
        }
        this.m_actionSupport.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        if (this.m_actionSupport == null) {
            return;
        }
        this.removeActionListener(actionListener);
    }

    protected void fireAction(int n, String string) {
        if (this.m_actionSupport == null) {
            return;
        }
        this.m_actionSupport.fireAction(new ActionEvent(this, n, string));
    }

    public void componentAdded(ContainerEvent containerEvent) {
        this.addKeyAndContainerListenerRecursively(containerEvent.getChild());
    }

    public void componentRemoved(ContainerEvent containerEvent) {
        this.removeKeyAndContainerListenerRecursively(containerEvent.getChild());
    }

    private void addKeyAndContainerListenerRecursively(Component component) {
        component.removeKeyListener(this);
        component.addKeyListener(this);
        if (component instanceof Container) {
            Container container = (Container)component;
            container.removeContainerListener(this);
            container.addContainerListener(this);
            Component[] componentArray = container.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                this.addKeyAndContainerListenerRecursively(componentArray[i]);
            }
        }
    }

    private void removeKeyAndContainerListenerRecursively(Component component) {
        component.removeKeyListener(this);
        if (component instanceof Container) {
            Container container = (Container)component;
            container.removeContainerListener(this);
            Component[] componentArray = container.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                this.removeKeyAndContainerListenerRecursively(componentArray[i]);
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 27) {
            return;
        }
        PsViewerIf psViewerIf = PsConfig.getViewer();
        if (psViewerIf != null) {
            psViewerIf.keyPressed(keyEvent);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 27) {
            this.setUserAction(1);
            this.dispose();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

