/*
 * Decompiled with CFR 0.152.
 */
package jvApp.knotBook;

import jv.vecmath.PdVector;
import jvApp.knotBook.PgKnotArc;
import jvApp.knotBook.PgKnotBook;

public class ThreePageLink {
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    public static final int NOARC = -1;
    public static final int NOPAGE = -1;
    private int compleXity = 0;
    private int oldComplexity = 0;
    private int maX_Size = 0;
    private int numOfComponents = 0;
    private int lastVertex = -1;
    private static final int INITNUMCOMP = 10;
    private static final int NUMCOMPINC = 100;
    private int[][] stateOfComponents;
    private static final int NUMOFCFIELDS = 8;
    private static final int LENGTHF = 3;
    private static final int MAXLENF = 4;
    private static final int STARTVERTF = 5;
    private static final int STARTPAGEF = 6;
    private static final int ISTRIVIALF = 7;
    private int[] numArcs;
    private int[][] theDiagram;
    private static final int NUMOFVFIELDS = 8;
    private static final int NEXTF = 4;
    private static final int PREVF = 3;
    private static final int TYPEF = 5;
    private static final int AUXNUMF = 6;
    private static final int ONCOMPF = 7;
    private static final int VT_UNUSED = 0;
    private static final int VT_REGULAR = 1;
    private static final int VT_INTAIL = 2;
    private static final int VT_OUTTAIL = 3;
    private static final int VT_ONETAIL = 4;
    private static final int VT_NOTCONNECTED = -1;
    private static final int VT_REACHED_ONCE = -2;
    private static final int VT_REACHED_TWICE = -3;
    private static final int UNKNOWNCOMP = -1;
    private static final int VO_ATTACHIN = 0;
    private static final int VO_ATTACHOUT = 1;
    private static final int VO_ATTACH = 2;
    private static final int VO_DETACH = 3;
    private int freeSpaceEntry;
    private double[] x;
    private boolean isCoordinateSet = false;
    private boolean isVerticesOriented = false;
    private boolean isSimplifyFinished = false;
    private boolean isCellSearched;
    private boolean isInExMvApplicable;
    private int errorCode = 0;
    private int[] errorRegistry;
    private static final int STARTSIMPLIFY = 1;
    private static final int SIMPLIFYING_STEP = 11;
    private static final int SIMPLIFYING__TRIAL = 111;
    private static final int DELETING__PATH_ = 1111;
    private static final int DEL__PATH__ARC = 11111;
    private static final int CONTR__TRIV__ARC = 11112;
    private static final int MOVE__TRIV_COMP_R = 11113;
    private static final int CLOSING__LINK_ = 1112;
    private static final int SEARCHING__PATH__ = 11121;
    private static final int SEARCHING__ARCS__ = 11122;
    private static final int ADDING__PATH__ = 11123;
    private static final int RES__SELF__INTSCTN = 11124;
    private static final int CLEANING__UP__ = 11125;
    private static final int FINISHEDSIMPLIFY = 2;
    private static final int EXCHANGE__MOVE = 112;
    private int interruptLevel = 0;
    private int currMode = 1;
    private int lastMode = 0;
    private int subMode = 0;
    private long maxStepCounter = Long.MAX_VALUE;
    private long stepCounter = 0L;
    private int trialCounter = 0;
    private int currComp;
    private static final int maxTrialFactor = 1;
    private static final int maxCompFactor = 1;
    private int newTrivComponent;
    private int numOfNonTrivial = 0;
    private int compCounter = 0;
    private int pageOne;
    private int pageTwo;
    private int currPlane;
    private int pageThree;
    private int departVertex;
    private int departPage;
    private int arriveVertex;
    private int arrivePage;
    private int currVertex = 0;
    private int currPage;
    private int otherPage;
    private int currObst;
    private int prevV = 0;
    private int nextV = 0;
    private int fromVertex = 0;
    private int queuePointer = 0;
    private int queueLength = -1;
    private int[][] newVertexQueue;
    private int[][] newArcs;
    private int numOfNewArcs = 0;
    private int arcIdx;
    private static final int NUMOFQUEUEFIELDS = 4;
    private static final int Q_VERTEXF = 0;
    private static final int Q_PAGEF = 1;
    private static final int Q_WAITF = 2;
    private static final int Q_ARCIDXF = 3;
    private static final int NUMOFNEWARCFIELDS = 4;
    private static final int NA_BASEF = 0;
    private static final int NA_ENDF = 1;
    private static final int NA_PAGEF = 2;
    private static final int NA_OBSTF = 3;
    private static final int NOOBSTACLE = -1;
    private int[][] regIon;

    public ThreePageLink() {
        this.stateOfComponents = new int[10][8];
        this.numArcs = new int[4];
    }

    public void writeErrorMessage() {
        if (this.errorCode == 0) {
            return;
        }
        System.out.println(" ThreePageLink  errorCode: " + this.errorCode);
        int errorLen = this.errorRegistry.length;
        String errorString = " ThreePageLink  Errorregistry: ";
        int i = 0;
        while (i < errorLen) {
            errorString = String.valueOf(errorString) + this.errorRegistry[i] + "  ";
            ++i;
        }
        System.out.println(errorString);
    }

    private void doSetCoordinate() {
        this.isCoordinateSet = false;
        int v = this.lastVertex;
        int i = 0;
        while (i < this.compleXity) {
            if (i > 0 && v == this.lastVertex) {
                this.errorCode = 63;
                int[] er = new int[]{i, v};
                this.errorRegistry = er;
                return;
            }
            int u = v;
            if ((v = this.theDiagram[u][4]) < 0 || v >= this.maX_Size - 1) {
                this.errorCode = 64;
                int[] er = new int[]{i, v};
                this.errorRegistry = er;
                return;
            }
            if (this.theDiagram[v][5] == 0) {
                this.errorCode = 61;
                int[] er = new int[]{i, v};
                this.errorRegistry = er;
                return;
            }
            if (this.theDiagram[v][3] != u) {
                this.errorCode = 62;
                int[] er = new int[]{i, u, v};
                this.errorRegistry = er;
                return;
            }
            this.x[v] = i;
            ++i;
        }
        if (v != this.lastVertex) {
            this.errorCode = 60;
            int[] er = new int[]{this.compleXity, v, this.lastVertex};
            this.errorRegistry = er;
            return;
        }
        this.isCoordinateSet = true;
    }

    private void doDefrag() {
        int l;
        int k;
        int[] new_position = new int[this.maX_Size];
        int j = this.maX_Size - 2;
        int i = 0;
        while (i < this.maX_Size) {
            new_position[i] = i;
            ++i;
        }
        i = 0;
        while (i < j) {
            if (this.theDiagram[i][5] != 0) {
                ++i;
                continue;
            }
            if (this.theDiagram[j][5] == 0) {
                --j;
                continue;
            }
            new_position[i] = j;
            new_position[j] = i;
            this.x[i] = this.x[j];
            k = 0;
            while (k < 8) {
                l = this.theDiagram[i][k];
                this.theDiagram[i][k] = this.theDiagram[j][k];
                this.theDiagram[j][k] = l;
                ++k;
            }
        }
        if (j != this.compleXity) {
            this.errorCode = 221;
            int[] er = new int[]{j, this.compleXity};
            this.errorRegistry = er;
            return;
        }
        this.lastVertex = new_position[this.lastVertex];
        this.currVertex = new_position[this.lastVertex];
        this.departVertex = new_position[this.departVertex];
        this.arriveVertex = new_position[this.arriveVertex];
        this.fromVertex = new_position[this.fromVertex];
        this.nextV = new_position[this.nextV];
        this.prevV = new_position[this.prevV];
        this.freeSpaceEntry = new_position[this.freeSpaceEntry];
        i = 0;
        while (i < this.maX_Size) {
            if (this.theDiagram[i][5] > 0) {
                l = 0;
                while (l < 3) {
                    k = this.theDiagram[i][l];
                    if (k >= 0) {
                        this.theDiagram[i][l] = new_position[k];
                    }
                    ++l;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.maX_Size) {
            k = this.theDiagram[i][4];
            this.theDiagram[i][4] = new_position[k];
            k = this.theDiagram[i][3];
            this.theDiagram[i][3] = new_position[k];
            ++i;
        }
        i = 0;
        while (i < this.numOfComponents) {
            k = this.stateOfComponents[i][5];
            this.stateOfComponents[i][5] = new_position[k];
            ++i;
        }
        i = 0;
        while (i < this.queueLength) {
            k = this.newVertexQueue[i][0];
            this.newVertexQueue[i][0] = new_position[k];
            ++i;
        }
        i = 0;
        while (i < this.numOfNewArcs) {
            k = this.newArcs[i][0];
            this.newArcs[i][0] = new_position[k];
            k = this.newArcs[i][1];
            this.newArcs[i][1] = new_position[k];
            k = this.newArcs[i][3];
            if (k >= 0) {
                this.newArcs[i][3] = new_position[k];
            }
            ++i;
        }
    }

    private void setOrientation() {
        this.isVerticesOriented = false;
        int comp = 0;
        while (comp < this.numOfComponents) {
            int startv = this.stateOfComponents[comp][5];
            int page = this.stateOfComponents[comp][6];
            int len = this.stateOfComponents[comp][3];
            int v = startv;
            int i = 0;
            while (i < len) {
                if (page < 0 || page > 2) {
                    this.errorCode = 75;
                    int[] er = new int[]{comp, i, v};
                    this.errorRegistry = er;
                    return;
                }
                this.theDiagram[v][6] = page;
                if (i > 0 && v == startv) {
                    this.errorCode = 70;
                    int[] er = new int[]{i, v, len};
                    this.errorRegistry = er;
                    return;
                }
                if (this.theDiagram[v][7] != comp) {
                    this.errorCode = 73;
                    int[] er = new int[]{i, v, this.theDiagram[v][7]};
                    this.errorRegistry = er;
                    return;
                }
                if (this.theDiagram[v][5] != 1 && this.currMode < 1000) {
                    this.errorCode = 72;
                    int[] er = new int[]{i, v};
                    this.errorRegistry = er;
                    return;
                }
                int u = this.theDiagram[v][page];
                if (u < 0 || u >= this.maX_Size - 1) {
                    this.errorCode = 76;
                    int[] er = new int[]{i, v};
                    this.errorRegistry = er;
                    return;
                }
                if (this.theDiagram[u][page] != v) {
                    this.errorCode = 71;
                    int[] er = new int[]{i, v, u};
                    this.errorRegistry = er;
                    return;
                }
                v = u;
                if (this.theDiagram[v][(page + 1) % 3] == -1) {
                    page = (page + 2) % 3;
                } else if (this.theDiagram[v][(page + 2) % 3] == -1) {
                    page = (page + 1) % 3;
                } else if (this.currMode < 1000 || this.theDiagram[u][5] != 4) {
                    this.errorCode = 74;
                    int[] er = new int[]{comp, i, v};
                    this.errorRegistry = er;
                    return;
                }
                ++i;
            }
            ++comp;
        }
        this.isVerticesOriented = true;
    }

    private void doCreateEmptyDiagram(int size) {
        if (size <= 1) {
            this.errorCode = 51;
            int[] er = new int[]{size};
            this.errorRegistry = er;
            return;
        }
        this.maX_Size = 2 * size + 2;
        this.theDiagram = new int[this.maX_Size][8];
        this.x = new double[this.maX_Size];
        this.regIon = new int[this.maX_Size][3];
        int i = 0;
        while (i < this.maX_Size - 1) {
            this.theDiagram[i][4] = i + 1;
            this.theDiagram[i + 1][3] = i;
            this.theDiagram[i][5] = 0;
            ++i;
        }
        this.freeSpaceEntry = 0;
    }

    private int doAddComponent(int startvertex, int startpage) {
        if (this.stateOfComponents.length == this.numOfComponents) {
            int new_numComponents = this.numOfComponents + 100;
            int[][] newComponents = new int[new_numComponents][8];
            int i = 0;
            while (i < this.numOfComponents) {
                int j = 0;
                while (j < 8) {
                    newComponents[i][j] = this.stateOfComponents[i][j];
                    ++j;
                }
                ++i;
            }
            this.stateOfComponents = newComponents;
        }
        this.stateOfComponents[this.numOfComponents][5] = startvertex;
        this.stateOfComponents[this.numOfComponents][6] = startpage;
        ++this.numOfComponents;
        return this.numOfComponents - 1;
    }

    private int doInsertVertex(int prev_v, int oncomp) {
        int next_v;
        if (this.isVerticesOriented || this.isCoordinateSet) {
            this.errorCode = 3;
            int[] er = new int[2];
            if (this.isVerticesOriented) {
                er[1] = 1;
            }
            if (this.isCoordinateSet) {
                er[2] = 1;
            }
            this.errorRegistry = er;
            return -1;
        }
        if (this.compleXity + 1 == this.theDiagram.length) {
            this.errorCode = 1;
            int[] er = new int[]{this.compleXity, prev_v};
            this.errorRegistry = er;
            return -1;
        }
        if (this.theDiagram[this.freeSpaceEntry][5] != 0) {
            this.errorCode = 2;
            int[] er = new int[]{this.freeSpaceEntry, prev_v};
            this.errorRegistry = er;
            return -1;
        }
        int this_v = this.freeSpaceEntry;
        if (this.compleXity == 0) {
            next_v = this_v;
            prev_v = this_v;
            this.lastVertex = this_v;
        } else {
            next_v = this.theDiagram[prev_v][4];
        }
        this.freeSpaceEntry = this.theDiagram[this.freeSpaceEntry][4];
        this.theDiagram[prev_v][4] = this_v;
        this.theDiagram[this_v][3] = prev_v;
        this.theDiagram[this_v][4] = next_v;
        this.theDiagram[next_v][3] = this_v;
        this.theDiagram[this_v][6] = this.maX_Size;
        this.theDiagram[this_v][5] = -1;
        this.theDiagram[this_v][7] = oncomp;
        this.theDiagram[this_v][0] = -1;
        this.theDiagram[this_v][1] = -1;
        this.theDiagram[this_v][2] = -1;
        ++this.compleXity;
        return this_v;
    }

    private void doDeleteVertex(int deletedv) {
        if (this.isVerticesOriented || this.isCoordinateSet) {
            this.errorCode = 14;
            int[] er = new int[2];
            if (this.isVerticesOriented) {
                er[0] = 1;
            }
            if (this.isCoordinateSet) {
                er[1] = 1;
            }
            this.errorRegistry = er;
            return;
        }
        if (this.theDiagram[deletedv][0] != -1 || this.theDiagram[deletedv][1] != -1 || this.theDiagram[deletedv][2] != -1 || this.theDiagram[deletedv][5] != -1) {
            this.errorCode = 11;
            int[] er = new int[]{deletedv};
            this.errorRegistry = er;
            return;
        }
        int comp = this.theDiagram[deletedv][7];
        if (deletedv == this.stateOfComponents[comp][5]) {
            this.errorCode = 13;
            int[] er = new int[]{deletedv};
            this.errorRegistry = er;
            return;
        }
        if (this.compleXity <= 1) {
            this.errorCode = 12;
            int[] er = new int[]{deletedv, this.compleXity};
            this.errorRegistry = er;
            return;
        }
        if (deletedv == this.departVertex && this.currMode != 11113) {
            this.errorCode = 15;
            int[] er = new int[]{deletedv, this.arriveVertex};
            this.errorRegistry = er;
            return;
        }
        this.prevV = this.theDiagram[deletedv][3];
        this.nextV = this.theDiagram[deletedv][4];
        if (this.lastVertex == deletedv) {
            this.lastVertex = this.prevV;
        }
        this.theDiagram[deletedv][4] = this.freeSpaceEntry;
        this.theDiagram[this.freeSpaceEntry][3] = deletedv;
        this.theDiagram[deletedv][5] = 0;
        this.freeSpaceEntry = deletedv;
        this.theDiagram[this.prevV][4] = this.nextV;
        this.theDiagram[this.nextV][3] = this.prevV;
        --this.compleXity;
    }

    private void addToQueue(int vertex, int page, int newarc_idx) {
        if (this.queueLength >= this.newVertexQueue.length) {
            this.errorCode = 330;
            int[] er = new int[]{this.queueLength, vertex, page, newarc_idx};
            this.errorRegistry = er;
            return;
        }
        this.newVertexQueue[this.queueLength][0] = vertex;
        this.newVertexQueue[this.queueLength][1] = page;
        this.newVertexQueue[this.queueLength][2] = 0;
        this.newVertexQueue[this.queueLength][3] = newarc_idx;
        ++this.queueLength;
    }

    private void addToQueue(int newarc_idx) {
        if (this.queueLength >= this.newVertexQueue.length) {
            this.errorCode = 329;
            int[] er = new int[]{this.queueLength, newarc_idx};
            this.errorRegistry = er;
            return;
        }
        this.newVertexQueue[this.queueLength][0] = this.newArcs[newarc_idx][1];
        this.newVertexQueue[this.queueLength][2] = 1;
        this.newVertexQueue[this.queueLength][3] = newarc_idx;
        ++this.queueLength;
    }

    private int createNewArc(int base, int end, int page, int obst) {
        if (this.numOfNewArcs >= this.newArcs.length) {
            this.errorCode = 332;
            int[] er = new int[]{this.numOfNewArcs, base, end, page};
            this.errorRegistry = er;
            return -1;
        }
        this.newArcs[this.numOfNewArcs][0] = base;
        this.newArcs[this.numOfNewArcs][1] = end;
        this.newArcs[this.numOfNewArcs][2] = page;
        this.newArcs[this.numOfNewArcs][3] = obst;
        ++this.numOfNewArcs;
        return this.numOfNewArcs - 1;
    }

    private void tryAttachNewArc(int arc_idx) {
        int base = this.newArcs[arc_idx][0];
        int end = this.newArcs[arc_idx][1];
        int page = this.newArcs[arc_idx][2];
        int obst = this.newArcs[arc_idx][3];
        this.otherPage = this.currPlane - page;
        int len = this.theDiagram[base][6] + 1;
        if (obst != -1) {
            ++len;
        }
        int old_len = this.theDiagram[end][6];
        int old_type = this.theDiagram[end][5];
        if (old_len < len) {
            return;
        }
        int new_type = -2;
        if (this.theDiagram[base][5] == -3 || this.theDiagram[base][this.otherPage] != -1) {
            new_type = -3;
        }
        if (len == old_len) {
            if (old_type == -3) {
                return;
            }
            if (new_type == -2 && this.theDiagram[end][page] != -1) {
                return;
            }
        }
        if (end == this.arriveVertex && new_type == -2 && base != this.departVertex) {
            return;
        }
        this.theDiagram[end][page] = arc_idx;
        if (this.theDiagram[end][this.otherPage] != -1) {
            if (len != old_len) {
                this.errorCode = 335;
                int[] er = new int[]{len, old_len, end};
                this.errorRegistry = er;
                return;
            }
            new_type = -3;
        }
        this.theDiagram[end][6] = len;
        if (end != this.arriveVertex) {
            this.theDiagram[end][5] = new_type;
            this.addToQueue(end, this.otherPage, arc_idx);
            if (obst == this.theDiagram[end][3]) {
                this.addToQueue(end, page, arc_idx);
            }
        }
    }

    private void doCheckDiagram(int check_level) {
        int u;
        if (this.lastVertex < 0 || this.lastVertex >= this.maX_Size - 1) {
            this.errorCode = 200;
            int[] er = new int[]{this.lastVertex};
            this.errorRegistry = er;
            return;
        }
        this.doSetCoordinate();
        if (!this.isCoordinateSet) {
            return;
        }
        if (this.freeSpaceEntry < 0 || this.freeSpaceEntry >= this.maX_Size - 1) {
            this.errorCode = 202;
            int[] er = new int[]{this.freeSpaceEntry};
            this.errorRegistry = er;
            return;
        }
        int v = this.freeSpaceEntry;
        int j = this.maX_Size - this.compleXity - 1;
        int i = 0;
        while (i < j) {
            if (this.theDiagram[v][5] != 0) {
                this.errorCode = 203;
                int[] er = new int[]{i, j, v};
                this.errorRegistry = er;
                return;
            }
            u = this.theDiagram[v][4];
            if (this.theDiagram[u][3] != v) {
                this.errorCode = 205;
                int[] er = new int[]{v, u, this.theDiagram[u][3]};
                this.errorRegistry = er;
                return;
            }
            v = u;
            ++i;
        }
        if (v != this.maX_Size - 1) {
            this.errorCode = 204;
            int[] er = new int[]{j, v};
            this.errorRegistry = er;
            return;
        }
        if (check_level == 0) {
            return;
        }
        int page = 0;
        while (page < 3) {
            j = 0;
            i = 0;
            while (i < this.numOfComponents) {
                j += this.stateOfComponents[i][page];
                ++i;
            }
            if (j != this.numArcs[page]) {
                this.errorCode = 209;
                int[] er = new int[]{j, page};
                this.errorRegistry = er;
                return;
            }
            i = 0;
            while (i < this.numOfComponents) {
                j = 0;
                page = 0;
                while (page < 3) {
                    j += this.stateOfComponents[i][page];
                    ++page;
                }
                if (j != this.stateOfComponents[i][3]) {
                    this.errorCode = 210;
                    int[] er = new int[]{i, j};
                    this.errorRegistry = er;
                    return;
                }
                ++i;
            }
            if (this.numArcs[0] + this.numArcs[1] + this.numArcs[2] != this.numArcs[3]) {
                this.errorCode = 211;
                int[] er = this.numArcs;
                this.errorRegistry = er;
                return;
            }
            ++page;
        }
        if (check_level == 0) {
            return;
        }
        page = 0;
        while (page < 3) {
            v = this.theDiagram[this.lastVertex][4];
            i = 0;
            while (i < this.compleXity - 1) {
                if ((int)this.x[v] != i) {
                    this.errorCode = 201;
                    int[] er = new int[]{i, (int)this.x[i]};
                    this.errorRegistry = er;
                    return;
                }
                u = this.theDiagram[v][page];
                if (u != -1) {
                    if (u < 0 || u >= this.maX_Size - 1) {
                        this.errorCode = 206;
                        int[] er = new int[]{v, u, page};
                        this.errorRegistry = er;
                        return;
                    }
                    double x3 = this.x[u];
                    double x1 = this.x[v];
                    if (x3 > x1) {
                        j = v;
                        while (j != u) {
                            double x2;
                            if (this.x[j] > x3 || this.x[j] < x1) {
                                this.errorCode = 207;
                                int[] er = new int[]{v, u, j};
                                this.errorRegistry = er;
                                return;
                            }
                            int k = this.theDiagram[j][page];
                            if (k != -1 && ((x2 = this.x[k]) < x1 || x2 > x3)) {
                                this.errorCode = 208;
                                int[] er = new int[]{v, u, j, k, (int)x1, (int)x2, (int)x3};
                                this.errorRegistry = er;
                                return;
                            }
                            j = this.theDiagram[j][4];
                        }
                    }
                }
                v = this.theDiagram[v][4];
                ++i;
            }
            ++page;
        }
        if (check_level == 1) {
            return;
        }
        if (this.numArcs[3] != this.compleXity) {
            this.errorCode = 212;
            int[] er = new int[]{this.numArcs[3], this.compleXity};
            this.errorRegistry = er;
            return;
        }
        this.setOrientation();
    }

    private String myFormat(int k) {
        String outstring = new String();
        if (k >= 0 && k < 10) {
            outstring = "     " + k;
        }
        if (k >= 10 && k < 100) {
            outstring = "    " + k;
        }
        if (k >= 100 && k < 1000) {
            outstring = "   " + k;
        }
        if (k >= 1000 && k < 10000) {
            outstring = "  " + k;
        }
        if (k >= 10000) {
            outstring = " " + k;
        }
        if (k > -10 && k < 0) {
            outstring = "    " + k;
        }
        if (k > -100 && k <= -10) {
            outstring = "   " + k;
        }
        if (k > -1000 && k <= -100) {
            outstring = "  " + k;
        }
        if (k > -10000 && k <= -1000) {
            outstring = " " + k;
        }
        if (k <= -10000) {
            outstring = "" + k;
        }
        return outstring;
    }

    public void writeDiagramState() {
        int j;
        String outstring;
        System.out.println("  Number of vertices  " + this.compleXity);
        System.out.println("  Number of arcs  " + this.numArcs[0] + "  " + this.numArcs[1] + "  " + this.numArcs[2] + "  " + this.numArcs[3]);
        System.out.println();
        System.out.println("  lastVertex " + this.lastVertex);
        System.out.println("  freeSpaceEntry " + this.freeSpaceEntry);
        int i = 0;
        while (i < this.numOfComponents) {
            System.out.println();
            System.out.println("  Component " + i);
            outstring = " ";
            j = 0;
            while (j < 8) {
                outstring = String.valueOf(outstring) + this.myFormat(this.stateOfComponents[i][j]);
                ++j;
            }
            System.out.println(outstring);
            ++i;
        }
        this.doCheckDiagram(0);
        if (this.errorCode > 0) {
            this.writeErrorMessage();
        }
        System.out.println("      idx page0 page1 page2  prev  next  type  aux   compon  xcoord");
        if (!this.isCoordinateSet) {
            i = 0;
            while (i < this.maX_Size) {
                outstring = "  " + this.myFormat(i);
                j = 0;
                while (j < 8) {
                    outstring = String.valueOf(outstring) + this.myFormat(this.theDiagram[i][j]);
                    ++j;
                }
                outstring = String.valueOf(outstring) + "   " + this.x[i];
                System.out.println(outstring);
                ++i;
            }
        } else {
            int v = this.theDiagram[this.lastVertex][4];
            i = 0;
            while (i < this.compleXity) {
                outstring = "  " + this.myFormat(v);
                j = 0;
                while (j < 8) {
                    outstring = String.valueOf(outstring) + this.myFormat(this.theDiagram[v][j]);
                    ++j;
                }
                outstring = String.valueOf(outstring) + "   " + this.x[v];
                System.out.println(outstring);
                this.isCoordinateSet = false;
                ++i;
                v = this.theDiagram[v][4];
            }
        }
        System.out.println("  queue pointer " + this.queuePointer);
        System.out.println("     vert  page  wait  idx");
        i = this.queuePointer;
        while (i < this.queueLength) {
            outstring = "  ";
            j = 0;
            while (j < 4) {
                outstring = String.valueOf(outstring) + this.myFormat(this.newVertexQueue[i][j]);
                ++j;
            }
            System.out.println(outstring);
            ++i;
        }
        System.out.println("     base end  page  obst");
        i = 0;
        while (i < this.numOfNewArcs) {
            outstring = "  ";
            j = 0;
            while (j < 4) {
                outstring = String.valueOf(outstring) + this.myFormat(this.newArcs[i][j]);
                ++j;
            }
            System.out.println(outstring);
            ++i;
        }
    }

    private void doChangeVertexState(int v, int page, int op_code) {
        block0 : switch (op_code) {
            case 0: {
                if (this.theDiagram[v][page] != -1) {
                    this.errorCode = 31;
                    int[] er = new int[]{v, page};
                    this.errorRegistry = er;
                    return;
                }
                switch (this.theDiagram[v][5]) {
                    case -1: {
                        this.theDiagram[v][5] = 2;
                        break block0;
                    }
                    case 3: {
                        this.theDiagram[v][5] = 1;
                        break block0;
                    }
                }
                this.errorCode = 32;
                int[] er = new int[]{v, page};
                this.errorRegistry = er;
                break;
            }
            case 1: {
                if (this.theDiagram[v][page] != -1) {
                    this.errorCode = 33;
                    int[] er = new int[]{v, page};
                    this.errorRegistry = er;
                    return;
                }
                switch (this.theDiagram[v][5]) {
                    case -1: {
                        this.theDiagram[v][5] = 3;
                        break block0;
                    }
                    case 2: {
                        this.theDiagram[v][5] = 1;
                        break block0;
                    }
                }
                this.errorCode = 34;
                int[] er = new int[]{v, page};
                this.errorRegistry = er;
                break;
            }
            case 2: {
                if (this.theDiagram[v][page] != -1) {
                    this.errorCode = 35;
                    int[] er = new int[]{v, page};
                    this.errorRegistry = er;
                    return;
                }
                switch (this.theDiagram[v][5]) {
                    case -1: {
                        this.theDiagram[v][5] = 4;
                        break block0;
                    }
                    case 4: {
                        this.theDiagram[v][5] = 1;
                        break block0;
                    }
                    case -2: {
                        this.theDiagram[v][5] = 4;
                        break block0;
                    }
                    case -3: {
                        this.theDiagram[v][5] = 4;
                        break block0;
                    }
                }
                this.errorCode = 36;
                int[] er = new int[]{v, page};
                this.errorRegistry = er;
                break;
            }
            case 3: {
                switch (this.theDiagram[v][5]) {
                    case 1: {
                        this.theDiagram[v][5] = 4;
                        break block0;
                    }
                    case 4: {
                        this.theDiagram[v][5] = -1;
                        break block0;
                    }
                }
                this.errorCode = 38;
                int[] er = new int[]{v, page};
                this.errorRegistry = er;
                break;
            }
            default: {
                this.errorCode = 37;
                int[] er = new int[]{v, page, op_code};
                this.errorRegistry = er;
            }
        }
    }

    private int doDeleteArc(int base, int page) {
        if (this.isVerticesOriented) {
            this.errorCode = 80;
            int[] er = new int[]{};
            this.errorRegistry = er;
            return -1;
        }
        int comp = this.theDiagram[base][7];
        int end = this.theDiagram[base][page];
        if (comp < 0 || comp > this.numOfComponents) {
            this.errorCode = 81;
            int[] er = new int[]{base, comp};
            this.errorRegistry = er;
            return -1;
        }
        if (end < 0 || end > this.maX_Size - 2) {
            this.errorCode = 82;
            int[] er = new int[]{base, page, end};
            this.errorRegistry = er;
            return -1;
        }
        if (base == this.departVertex) {
            this.departVertex = this.theDiagram[this.departVertex][this.departPage];
            this.departPage = (this.departPage + 1) % 3;
            if (this.theDiagram[this.departVertex][this.departPage] == -1) {
                this.departPage = (this.departPage + 1) % 3;
            }
            if (this.theDiagram[this.departVertex][this.departPage] == -1 && this.currMode != 11113) {
                this.errorCode = 305;
                int[] er = new int[]{this.currVertex, this.currPage, this.currPlane, this.pageThree, this.departVertex, this.departPage};
                this.errorRegistry = er;
                return -1;
            }
        } else if (base == this.arriveVertex) {
            this.arriveVertex = this.theDiagram[this.arriveVertex][this.arrivePage];
            this.arrivePage = (this.arrivePage + 1) % 3;
            if (this.theDiagram[this.arriveVertex][this.arrivePage] == -1) {
                this.arrivePage = (this.arrivePage + 1) % 3;
            }
            if (this.theDiagram[this.arriveVertex][this.arrivePage] == -1 && this.currMode != 11113) {
                this.errorCode = 302;
                int[] er = new int[]{this.currVertex, this.currPage, this.currPlane, this.pageThree, this.arriveVertex, this.arrivePage};
                this.errorRegistry = er;
                return -1;
            }
        }
        if (base == this.stateOfComponents[comp][5] && page == this.stateOfComponents[comp][6] && this.theDiagram[end][5] == 1) {
            if (this.theDiagram[end][(page + 1) % 3] == -1) {
                this.stateOfComponents[comp][6] = (page + 2) % 3;
            }
            if (this.theDiagram[end][(page + 2) % 3] == -1) {
                this.stateOfComponents[comp][6] = (page + 1) % 3;
            }
            this.stateOfComponents[comp][5] = end;
        }
        if (end == this.stateOfComponents[comp][5] && page == this.stateOfComponents[comp][6] && this.theDiagram[base][5] == 1) {
            if (this.theDiagram[base][(page + 1) % 3] == -1) {
                this.stateOfComponents[comp][6] = (page + 2) % 3;
            }
            if (this.theDiagram[base][(page + 2) % 3] == -1) {
                this.stateOfComponents[comp][6] = (page + 1) % 3;
            }
            this.stateOfComponents[comp][5] = base;
        }
        this.doChangeVertexState(base, page, 3);
        if (this.errorCode > 0) {
            return -1;
        }
        this.doChangeVertexState(end, page, 3);
        if (this.errorCode > 0) {
            return -1;
        }
        this.theDiagram[base][page] = -1;
        this.theDiagram[end][page] = -1;
        int n = page;
        this.numArcs[n] = this.numArcs[n] - 1;
        int[] nArray = this.stateOfComponents[comp];
        int n2 = page;
        nArray[n2] = nArray[n2] - 1;
        this.numArcs[3] = this.numArcs[3] - 1;
        int[] nArray2 = this.stateOfComponents[comp];
        nArray2[3] = nArray2[3] - 1;
        return end;
    }

    private void doPutArc(int base, int end, int page) {
        int comp;
        if (this.theDiagram[end][7] != this.theDiagram[base][7]) {
            this.errorCode = 41;
            int[] er = new int[]{base, end, page};
            this.errorRegistry = er;
            return;
        }
        if (this.isVerticesOriented) {
            this.doChangeVertexState(base, page, 1);
            if (this.errorCode > 0) {
                return;
            }
            this.doChangeVertexState(end, page, 0);
            if (this.errorCode > 0) {
                return;
            }
        } else {
            this.doChangeVertexState(base, page, 2);
            if (this.errorCode > 0) {
                return;
            }
            this.doChangeVertexState(end, page, 2);
            if (this.errorCode > 0) {
                return;
            }
        }
        this.theDiagram[base][page] = end;
        this.theDiagram[end][page] = base;
        if (this.isVerticesOriented) {
            this.theDiagram[base][6] = page;
        }
        if ((comp = this.theDiagram[end][7]) != -1) {
            int[] nArray = this.stateOfComponents[comp];
            int n = page;
            nArray[n] = nArray[n] + 1;
            int[] nArray2 = this.stateOfComponents[comp];
            nArray2[3] = nArray2[3] + 1;
            int len = nArray2[3];
            int maxlen = this.stateOfComponents[comp][4];
            if (len > maxlen) {
                this.stateOfComponents[comp][4] = len;
            }
        }
        int n = page;
        this.numArcs[n] = this.numArcs[n] + 1;
        this.numArcs[3] = this.numArcs[3] + 1;
    }

    public void setInterruptLevel(int lev) {
        this.interruptLevel = lev;
    }

    public void setMaxStepCounter(int msc) {
        this.maxStepCounter = msc;
    }

    public void kNotSimplyFire() {
        this.stepCounter = 0L;
        block31: while (!this.isSimplifyFinished) {
            ++this.stepCounter;
            if (this.currMode <= this.lastMode) {
                switch (this.interruptLevel) {
                    case 0: {
                        if (this.stepCounter < this.maxStepCounter) break;
                        this.stepCounter = 0L;
                        return;
                    }
                    case 1: {
                        if (this.currMode < 100) {
                            this.lastMode = -1;
                            return;
                        }
                    }
                    case 2: {
                        if (this.currMode < 1000) {
                            this.lastMode = -1;
                            return;
                        }
                    }
                    case 3: {
                        if (this.currMode < 10000) {
                            this.lastMode = -1;
                            return;
                        }
                    }
                    case 4: {
                        this.lastMode = -1;
                        return;
                    }
                }
            }
            this.lastMode = this.currMode;
            this.isCoordinateSet = false;
            this.isVerticesOriented = false;
            switch (this.currMode) {
                case 1: {
                    if (this.compleXity < 2) {
                        this.currMode = 2;
                        break;
                    }
                    this.newVertexQueue = new int[(int)Math.log(this.maX_Size) * 4 * this.maX_Size][4];
                    this.newArcs = new int[(int)Math.log(this.maX_Size) * 4 * this.maX_Size][4];
                    this.currComp = 0;
                    this.numOfNonTrivial = this.numOfComponents;
                    this.currMode = 11;
                    this.stepCounter = 0L;
                    break;
                }
                case 11: {
                    this.oldComplexity = this.compleXity;
                    this.compCounter = 0;
                    this.trialCounter = 0;
                    this.currMode = 111;
                    break;
                }
                case 111: {
                    int[] er;
                    int i;
                    if (this.compCounter >= this.numOfNonTrivial * 1) {
                        this.currMode = 112;
                        break;
                    }
                    int currmaxlen = this.stateOfComponents[this.currComp][4];
                    if (this.trialCounter > 1 * currmaxlen || this.stateOfComponents[this.currComp][7] == 1) {
                        this.trialCounter = 0;
                        ++this.compCounter;
                        i = 0;
                        do {
                            ++this.currComp;
                            this.currComp %= this.numOfComponents;
                            if (++i <= this.numOfComponents) continue;
                            this.errorCode = 307;
                            er = new int[]{this.numOfNonTrivial, this.numOfComponents, this.currComp, i};
                            this.errorRegistry = er;
                            return;
                        } while (this.stateOfComponents[this.currComp][7] == 1);
                        this.stateOfComponents[this.currComp][4] = this.stateOfComponents[this.currComp][3];
                    }
                    ++this.trialCounter;
                    this.arriveVertex = this.departVertex = this.stateOfComponents[this.currComp][5];
                    this.departPage = this.stateOfComponents[this.currComp][6];
                    if (this.theDiagram[this.arriveVertex][(this.departPage + 1) % 3] == -1) {
                        this.arrivePage = (this.departPage + 2) % 3;
                    }
                    if (this.theDiagram[this.arriveVertex][(this.departPage + 2) % 3] == -1) {
                        this.arrivePage = (this.departPage + 1) % 3;
                    }
                    this.currPlane = this.departPage + this.arrivePage;
                    this.pageOne = this.arrivePage;
                    this.pageThree = 3 - this.currPlane;
                    this.currMode = 1111;
                    break;
                }
                case 1111: {
                    int[] er;
                    if (this.departVertex != this.stateOfComponents[this.currComp][5] || this.departPage != this.stateOfComponents[this.currComp][6]) {
                        this.errorCode = 301;
                        er = new int[]{this.departVertex, this.currComp};
                        this.errorRegistry = er;
                        return;
                    }
                    if (this.departPage != this.pageThree) {
                        this.currVertex = this.departVertex;
                        this.currPage = this.departPage;
                        this.currMode = 11111;
                        break;
                    }
                    if (this.arrivePage != this.pageThree) {
                        this.pageOne = this.arrivePage;
                        this.currVertex = this.arriveVertex;
                        this.currPage = this.arrivePage;
                        this.currMode = 11111;
                        break;
                    }
                    this.pageTwo = this.currPlane - this.pageOne;
                    this.currMode = 1112;
                    break;
                }
                case 11111: {
                    int[] er;
                    if (this.theDiagram[this.departVertex][this.departPage] == this.arriveVertex && this.departPage != this.pageThree) {
                        if (this.theDiagram[this.arriveVertex][this.arrivePage] != this.departVertex) {
                            this.errorCode = 303;
                            er = new int[]{this.arriveVertex, this.departVertex};
                            this.errorRegistry = er;
                            return;
                        }
                        if (this.stateOfComponents[this.currComp][3] != 1) {
                            this.errorCode = 304;
                            er = new int[]{this.arriveVertex, this.departVertex};
                            this.errorRegistry = er;
                            return;
                        }
                        this.newTrivComponent = this.currComp;
                        this.currMode = 11113;
                        break;
                    }
                    int v = this.doDeleteArc(this.currVertex, this.currPage);
                    if (this.errorCode > 0) {
                        return;
                    }
                    if (v != this.arriveVertex && v != this.departVertex) {
                        this.errorCode = 306;
                        er = new int[]{this.currVertex, v, this.arriveVertex, this.departVertex};
                        this.errorRegistry = er;
                        return;
                    }
                    if (this.currVertex != this.arriveVertex) {
                        this.doDeleteVertex(this.currVertex);
                        if (this.errorCode > 0) {
                            return;
                        }
                        this.currMode = 11112;
                        break;
                    }
                    this.currPage = this.arrivePage;
                    break;
                }
                case 11112: {
                    int[] er;
                    if (this.theDiagram[this.prevV][this.pageThree] != this.nextV) {
                        this.currMode = 1111;
                        break;
                    }
                    if (this.theDiagram[this.nextV][this.pageThree] != this.prevV) {
                        this.errorCode = 306;
                        er = new int[]{this.prevV, this.nextV, this.pageThree, this.currVertex};
                        this.errorRegistry = er;
                        return;
                    }
                    if (this.theDiagram[this.nextV][5] == 4) {
                        if (this.theDiagram[this.nextV][7] != this.currComp) {
                            this.errorCode = 308;
                            er = new int[]{this.currComp, this.nextV};
                            this.errorRegistry = er;
                            return;
                        }
                        if (this.theDiagram[this.prevV][5] == 4) {
                            if (this.theDiagram[this.prevV][7] != this.currComp) {
                                this.errorCode = 309;
                                er = new int[]{this.currComp, this.prevV};
                                this.errorRegistry = er;
                                return;
                            }
                            this.newTrivComponent = this.currComp;
                            this.currMode = 11113;
                            break;
                        }
                        this.doDeleteArc(this.nextV, this.pageThree);
                        if (this.errorCode > 0) {
                            return;
                        }
                        this.doDeleteVertex(this.nextV);
                        if (this.errorCode > 0) {
                            return;
                        }
                        this.currMode = 1111;
                        break;
                    }
                    if (this.theDiagram[this.prevV][5] == 4) {
                        if (this.theDiagram[this.prevV][7] != this.currComp) {
                            this.errorCode = 309;
                            er = new int[]{this.currComp, this.prevV};
                            this.errorRegistry = er;
                            return;
                        }
                        this.doDeleteArc(this.prevV, this.pageThree);
                        if (this.errorCode > 0) {
                            return;
                        }
                        this.doDeleteVertex(this.prevV);
                        if (this.errorCode > 0) {
                            return;
                        }
                        this.currMode = 1111;
                        break;
                    }
                    if (this.theDiagram[this.prevV][5] != 1 || this.theDiagram[this.nextV][5] != 1) {
                        this.errorCode = 311;
                        er = new int[]{this.prevV};
                        this.errorRegistry = er;
                        return;
                    }
                    if (this.theDiagram[this.prevV][this.currPage] == -1) {
                        this.currPage = this.currPlane - this.currPage;
                    }
                    if (this.theDiagram[this.prevV][this.currPage] == -1) {
                        this.errorCode = 312;
                        er = new int[]{this.prevV, this.pageThree, this.currPage};
                        this.errorRegistry = er;
                        return;
                    }
                    this.currVertex = this.doDeleteArc(this.prevV, this.pageThree);
                    this.currVertex = this.doDeleteArc(this.prevV, this.currPage);
                    if (this.errorCode > 0) {
                        return;
                    }
                    if (this.currVertex == this.nextV) {
                        this.newTrivComponent = this.theDiagram[this.nextV][7];
                        this.currMode = 11113;
                        break;
                    }
                    this.doDeleteVertex(this.prevV);
                    if (this.errorCode > 0) {
                        return;
                    }
                    int v = this.theDiagram[this.nextV][this.currPage];
                    if (v == -1) {
                        this.doPutArc(this.currVertex, this.nextV, this.currPage);
                        if (this.errorCode > 0) {
                            return;
                        }
                        this.currMode = 1111;
                        break;
                    }
                    v = this.doDeleteArc(this.nextV, this.currPage);
                    if (this.errorCode > 0) {
                        return;
                    }
                    this.doDeleteVertex(this.nextV);
                    if (this.errorCode > 0) {
                        return;
                    }
                    this.doPutArc(this.currVertex, v, this.currPage);
                    this.currMode = 11112;
                    break;
                }
                case 11113: {
                    int[] er;
                    this.currVertex = this.stateOfComponents[this.newTrivComponent][5];
                    this.currPage = this.stateOfComponents[this.newTrivComponent][6];
                    int v = this.doInsertVertex(this.lastVertex, this.newTrivComponent);
                    if (this.errorCode > 0) {
                        return;
                    }
                    int i = this.doInsertVertex(v, this.newTrivComponent);
                    if (this.errorCode > 0) {
                        return;
                    }
                    this.stateOfComponents[this.newTrivComponent][5] = i;
                    this.stateOfComponents[this.newTrivComponent][6] = 0;
                    this.doPutArc(i, v, 0);
                    if (this.errorCode > 0) {
                        return;
                    }
                    this.doPutArc(i, v, 1);
                    if (this.errorCode > 0) {
                        return;
                    }
                    this.lastVertex = i;
                    v = this.doDeleteArc(this.currVertex, this.currPage);
                    if (this.errorCode > 0) {
                        return;
                    }
                    this.doDeleteVertex(v);
                    if (this.errorCode > 0) {
                        return;
                    }
                    this.doDeleteVertex(this.currVertex);
                    if (this.errorCode > 0) {
                        return;
                    }
                    if (this.stateOfComponents[this.newTrivComponent][3] != 2) {
                        this.errorCode = 313;
                        er = new int[]{this.prevV, this.pageThree, this.currPage};
                        this.errorRegistry = er;
                        return;
                    }
                    --this.numOfNonTrivial;
                    this.stateOfComponents[this.newTrivComponent][7] = 1;
                    if (this.currComp == this.newTrivComponent) {
                        this.currMode = 11;
                        break;
                    }
                    this.currMode = 11112;
                    break;
                }
                case 1112: {
                    int i = this.departVertex;
                    this.departVertex = this.arriveVertex;
                    this.arriveVertex = i;
                    this.theDiagram[this.departVertex][6] = 0;
                    this.theDiagram[this.arriveVertex][6] = this.compleXity;
                    this.queuePointer = 0;
                    this.numOfNewArcs = 0;
                    this.queueLength = 0;
                    this.addToQueue(this.departVertex, this.pageTwo, -1);
                    this.addToQueue(this.departVertex, this.pageOne, -1);
                    this.currMode = 11121;
                    break;
                }
                case 11121: {
                    int page;
                    int[] er;
                    int i;
                    if (this.queuePointer >= this.queueLength) {
                        this.errorCode = 331;
                        er = new int[]{this.queuePointer, this.queueLength};
                        this.errorRegistry = er;
                        return;
                    }
                    this.fromVertex = this.newVertexQueue[this.queuePointer][0];
                    this.currPage = this.newVertexQueue[this.queuePointer][1];
                    int shall_wait = this.newVertexQueue[this.queuePointer][2];
                    this.arcIdx = this.newVertexQueue[this.queuePointer][3];
                    ++this.queuePointer;
                    if (shall_wait == 1) {
                        this.tryAttachNewArc(this.arcIdx);
                        break;
                    }
                    this.otherPage = this.currPlane - this.currPage;
                    if (this.fromVertex != this.departVertex) {
                        page = this.newArcs[this.arcIdx][2];
                        if (this.theDiagram[this.fromVertex][page] == -1) {
                            this.errorCode = 333;
                            er = new int[]{this.arcIdx, this.queuePointer - 1};
                            this.errorRegistry = er;
                            return;
                        }
                        if (this.theDiagram[this.fromVertex][page] != this.arcIdx) continue block31;
                    }
                    if ((i = this.theDiagram[this.fromVertex][this.currPage]) != -1 && this.newArcs[i][3] == -1 && (this.theDiagram[this.fromVertex][4] != this.arriveVertex || this.theDiagram[this.fromVertex][this.otherPage] == -1)) continue block31;
                    this.currVertex = this.theDiagram[this.fromVertex][4];
                    this.isCellSearched = false;
                    this.currMode = 11122;
                    this.subMode = 0;
                    break;
                }
                case 11122: {
                    int[] er;
                    this.otherPage = this.currPlane - this.currPage;
                    int i = 0;
                    while (!this.isCellSearched) {
                        if (i > this.compleXity) {
                            System.out.println("Halted");
                            return;
                        }
                        ++i;
                        switch (this.subMode) {
                            case 0: {
                                if (this.currVertex == this.arriveVertex) {
                                    this.subMode = 1;
                                    break;
                                }
                                if (this.theDiagram[this.currVertex][5] != 1) {
                                    this.errorCode = 334;
                                    er = new int[]{this.currVertex, this.arriveVertex, this.departVertex};
                                    this.errorRegistry = er;
                                    return;
                                }
                                if (this.theDiagram[this.currVertex][this.currPage] == -1) {
                                    this.subMode = 3;
                                    break;
                                }
                                if (this.theDiagram[this.currVertex][this.otherPage] == -1) {
                                    this.currVertex = this.theDiagram[this.currVertex][this.currPage];
                                    this.subMode = this.theDiagram[this.currVertex][this.otherPage] == -1 ? 3 : 12;
                                    break;
                                }
                                this.subMode = 7;
                                break;
                            }
                            case 1: {
                                this.arcIdx = this.createNewArc(this.fromVertex, this.arriveVertex, this.currPage, -1);
                                if (this.errorCode > 0) {
                                    return;
                                }
                                this.isCellSearched = true;
                                this.tryAttachNewArc(this.arcIdx);
                                if (this.theDiagram[this.arriveVertex][this.currPage] == this.arcIdx) {
                                    this.currVertex = this.arriveVertex;
                                    this.subMode = 0;
                                    this.otherPage = this.currPlane - this.currPage;
                                    this.currObst = -1;
                                    this.theDiagram[this.arriveVertex][this.currPage] = -1;
                                    this.isCellSearched = true;
                                    this.currMode = 11123;
                                    break;
                                }
                                --this.numOfNewArcs;
                                this.prevV = this.theDiagram[this.arriveVertex][3];
                                if (this.theDiagram[this.prevV][5] == 1) {
                                    this.prevV = this.doInsertVertex(this.prevV, this.currComp);
                                    if (this.errorCode > 0) {
                                        return;
                                    }
                                    this.arcIdx = this.createNewArc(this.fromVertex, this.prevV, this.currPage, -1);
                                    if (this.errorCode > 0) {
                                        return;
                                    }
                                    this.tryAttachNewArc(this.arcIdx);
                                    if (this.errorCode > 0) {
                                        return;
                                    }
                                }
                                this.isCellSearched = true;
                                this.currMode = 11121;
                                break;
                            }
                            case 3: {
                                this.nextV = this.theDiagram[this.currVertex][4];
                                if (this.nextV == this.arriveVertex) {
                                    this.subMode = 1;
                                    break;
                                }
                                if (this.nextV == this.fromVertex) {
                                    this.currMode = 11121;
                                    this.isCellSearched = true;
                                    break;
                                }
                                if (this.theDiagram[this.nextV][5] == 1) {
                                    this.currVertex = this.doInsertVertex(this.currVertex, this.currComp);
                                    if (this.errorCode > 0) {
                                        return;
                                    }
                                } else {
                                    this.currVertex = this.nextV;
                                }
                                this.arcIdx = this.createNewArc(this.fromVertex, this.currVertex, this.currPage, -1);
                                if (this.errorCode > 0) {
                                    return;
                                }
                                this.tryAttachNewArc(this.arcIdx);
                                if (this.errorCode > 0) {
                                    return;
                                }
                                this.currVertex = this.theDiagram[this.currVertex][4];
                                this.subMode = 0;
                                break;
                            }
                            case 7: {
                                this.nextV = this.theDiagram[this.currVertex][4];
                                if (this.nextV != this.departVertex) {
                                    if (this.theDiagram[this.nextV][5] > 0) {
                                        this.nextV = this.doInsertVertex(this.currVertex, this.currComp);
                                        if (this.errorCode > 0) {
                                            return;
                                        }
                                    }
                                    this.arcIdx = this.createNewArc(this.fromVertex, this.nextV, this.currPage, this.currVertex);
                                    if (this.errorCode > 0) {
                                        return;
                                    }
                                    this.addToQueue(this.arcIdx);
                                    if (this.errorCode > 0) {
                                        return;
                                    }
                                }
                                this.currVertex = this.theDiagram[this.currVertex][this.currPage];
                                if (this.theDiagram[this.currVertex][this.otherPage] == -1) {
                                    this.subMode = 3;
                                    break;
                                }
                                this.subMode = 12;
                                break;
                            }
                            case 12: {
                                this.prevV = this.theDiagram[this.currVertex][3];
                                if (this.prevV != this.departVertex) {
                                    if (this.theDiagram[this.prevV][5] > 0) {
                                        this.prevV = this.doInsertVertex(this.prevV, this.currComp);
                                        if (this.errorCode > 0) {
                                            return;
                                        }
                                    }
                                    this.arcIdx = this.createNewArc(this.fromVertex, this.prevV, this.currPage, this.currVertex);
                                    if (this.errorCode > 0) {
                                        return;
                                    }
                                    this.addToQueue(this.arcIdx);
                                }
                                this.subMode = 3;
                            }
                        }
                    }
                    continue block31;
                }
                case 11123: {
                    int v;
                    int[] er;
                    if (this.currObst == -1) {
                        if (this.fromVertex == this.departVertex) {
                            this.doPutArc(this.fromVertex, this.currVertex, this.currPage);
                            this.currMode = 11124;
                            if (this.theDiagram[this.arriveVertex][this.currPage] == -1) {
                                this.currPage = this.otherPage;
                            }
                            this.fromVertex = this.theDiagram[this.arriveVertex][this.currPage];
                            break;
                        }
                        this.arcIdx = this.theDiagram[this.fromVertex][this.otherPage];
                        if (this.arcIdx != -1) {
                            this.theDiagram[this.fromVertex][0] = -1;
                            this.theDiagram[this.fromVertex][1] = -1;
                            this.theDiagram[this.fromVertex][2] = -1;
                            this.doPutArc(this.fromVertex, this.currVertex, this.currPage);
                            this.currPage = this.otherPage;
                            this.otherPage = this.currPlane - this.currPage;
                            this.currVertex = this.fromVertex;
                            this.fromVertex = this.newArcs[this.arcIdx][0];
                            this.currObst = this.newArcs[this.arcIdx][3];
                            break;
                        }
                        this.arcIdx = this.theDiagram[this.fromVertex][this.currPage];
                        this.currObst = this.newArcs[this.arcIdx][3];
                        if (this.theDiagram[this.currObst][4] != this.fromVertex) {
                            this.errorCode = 336;
                            er = new int[]{this.currObst, this.fromVertex, this.currVertex, this.currPage};
                            this.errorRegistry = er;
                            return;
                        }
                        this.fromVertex = this.newArcs[this.arcIdx][0];
                        break;
                    }
                    int comp = this.theDiagram[this.currObst][7];
                    if (this.currObst == this.theDiagram[this.currVertex][4]) {
                        this.prevV = this.theDiagram[this.currVertex][3];
                        this.prevV = this.doInsertVertex(this.prevV, comp);
                        if (this.errorCode > 0) {
                            return;
                        }
                        v = this.doDeleteArc(this.currObst, this.currPage);
                        this.doPutArc(v, this.prevV, this.currPage);
                        this.doPutArc(this.prevV, this.currObst, this.pageThree);
                        this.currObst = -1;
                        break;
                    }
                    if (this.currObst == this.theDiagram[this.currVertex][3]) {
                        this.nextV = this.doInsertVertex(this.currVertex, comp);
                        if (this.errorCode > 0) {
                            return;
                        }
                        v = this.doDeleteArc(this.currObst, this.currPage);
                        this.doPutArc(v, this.nextV, this.currPage);
                        this.doPutArc(this.nextV, this.currObst, this.pageThree);
                        this.currObst = -1;
                        break;
                    }
                    v = this.doDeleteArc(this.currObst, this.currPage);
                    this.nextV = this.doInsertVertex(this.currVertex, comp);
                    this.doPutArc(v, this.nextV, this.currPage);
                    this.prevV = this.theDiagram[this.currVertex][3];
                    this.prevV = this.doInsertVertex(this.prevV, comp);
                    this.doPutArc(this.prevV, this.nextV, this.pageThree);
                    this.doPutArc(this.currObst, this.prevV, this.currPage);
                    this.currObst = -1;
                    break;
                }
                case 11124: {
                    int i = this.theDiagram[this.arriveVertex][3];
                    int v = this.theDiagram[this.arriveVertex][4];
                    if (this.theDiagram[v][this.pageThree] != i) {
                        this.currMode = 11125;
                        break;
                    }
                    int comp = this.theDiagram[v][7];
                    this.doDeleteArc(i, this.pageThree);
                    int base = this.doDeleteArc(i, this.currPage);
                    if (this.errorCode > 0) {
                        return;
                    }
                    int end = this.doDeleteArc(v, this.currPage);
                    if (this.errorCode > 0) {
                        return;
                    }
                    this.prevV = this.theDiagram[this.fromVertex][3];
                    this.prevV = this.doInsertVertex(this.prevV, comp);
                    if (this.errorCode > 0) {
                        return;
                    }
                    this.nextV = this.doInsertVertex(this.fromVertex, comp);
                    if (this.errorCode > 0) {
                        return;
                    }
                    this.doPutArc(this.prevV, end, this.currPage);
                    if (this.errorCode > 0) {
                        return;
                    }
                    this.doPutArc(this.nextV, base, this.currPage);
                    if (this.errorCode > 0) {
                        return;
                    }
                    this.doPutArc(this.prevV, this.nextV, this.pageThree);
                    if (this.errorCode > 0) {
                        return;
                    }
                    this.doDeleteVertex(i);
                    if (this.errorCode > 0) {
                        return;
                    }
                    this.doDeleteVertex(v);
                    if (this.errorCode <= 0) continue block31;
                    return;
                }
                case 11125: {
                    int[] er;
                    int i = 0;
                    while (i < this.queueLength) {
                        this.currVertex = this.newVertexQueue[i][0];
                        if (this.theDiagram[this.currVertex][5] != 1 && this.theDiagram[this.currVertex][5] != 0) {
                            this.theDiagram[this.currVertex][0] = -1;
                            this.theDiagram[this.currVertex][1] = -1;
                            this.theDiagram[this.currVertex][2] = -1;
                            this.theDiagram[this.currVertex][5] = -1;
                            this.doDeleteVertex(this.currVertex);
                            if (this.errorCode > 0) {
                                return;
                            }
                        }
                        ++i;
                    }
                    if (this.compleXity > this.oldComplexity) {
                        this.errorCode = 337;
                        er = new int[]{this.compleXity, this.oldComplexity};
                        this.errorRegistry = er;
                        return;
                    }
                    this.currMode = this.compleXity < this.oldComplexity ? 11 : 111;
                    break;
                }
                case 112: {
                    int end;
                    int page;
                    int[] er;
                    int i;
                    this.currMode = 2;
                    int reg = 0;
                    this.currVertex = this.lastVertex;
                    do {
                        page = 0;
                        while (page < 3) {
                            this.regIon[this.currVertex][page] = -1;
                            ++page;
                        }
                        this.currVertex = this.theDiagram[this.currVertex][4];
                    } while (this.currVertex != this.lastVertex);
                    page = 0;
                    while (page < 3) {
                        do {
                            this.currVertex = this.theDiagram[this.currVertex][4];
                            if (this.regIon[this.currVertex][page] != -1) continue;
                            this.prevV = this.currVertex;
                            do {
                                this.regIon[this.prevV][page] = reg;
                                this.nextV = this.theDiagram[this.prevV][4];
                                int n = this.prevV = this.theDiagram[this.nextV][page] == -1 ? this.nextV : this.theDiagram[this.nextV][page];
                            } while (this.prevV != this.currVertex);
                            ++reg;
                        } while (this.currVertex != this.lastVertex);
                        ++page;
                    }
                    if (reg != this.compleXity + 3) {
                        this.errorCode = 400;
                        er = new int[]{reg, this.compleXity};
                        this.errorRegistry = er;
                        this.writeErrorMessage();
                    }
                    int base = this.lastVertex;
                    this.isInExMvApplicable = false;
                    do {
                        end = this.theDiagram[base][4];
                        while (end != this.lastVertex && !this.isInExMvApplicable) {
                            i = 0;
                            page = 0;
                            while (page < 3) {
                                if (this.regIon[base][page] == this.regIon[end][page]) {
                                    ++i;
                                } else {
                                    this.pageThree = page;
                                }
                                ++page;
                            }
                            if (i == 2) {
                                this.isInExMvApplicable = true;
                            }
                            end = this.theDiagram[end][4];
                        }
                    } while ((base = this.theDiagram[base][4]) != this.lastVertex && !this.isInExMvApplicable);
                    this.doSetCoordinate();
                    if (!this.isInExMvApplicable) continue block31;
                    this.setOrientation();
                    if (!this.isVerticesOriented) {
                        System.out.println("  orientation not set ");
                    }
                    i = this.theDiagram[base][3];
                    int v = this.theDiagram[end][3];
                    reg = this.regIon[i][this.pageThree];
                    this.prevV = end;
                    while (this.regIon[this.prevV][this.pageThree] != reg) {
                        this.prevV = this.theDiagram[this.prevV][4];
                    }
                    this.nextV = v;
                    while (this.regIon[this.nextV][this.pageThree] != reg) {
                        this.nextV = this.theDiagram[this.nextV][3];
                    }
                    this.nextV = this.theDiagram[this.nextV][4];
                    if (this.theDiagram[this.prevV][this.pageThree] != this.nextV) {
                        this.errorCode = 401;
                        er = new int[]{this.prevV, this.nextV};
                        this.errorRegistry = er;
                        this.writeErrorMessage();
                    }
                    this.theDiagram[i][4] = end;
                    this.theDiagram[end][3] = i;
                    this.theDiagram[v][4] = base;
                    this.theDiagram[base][3] = v;
                    i = this.theDiagram[this.prevV][4];
                    v = this.theDiagram[this.nextV][3];
                    this.theDiagram[this.prevV][4] = this.nextV;
                    this.theDiagram[this.nextV][3] = this.prevV;
                    this.theDiagram[v][4] = i;
                    this.theDiagram[i][3] = v;
                    this.currComp = this.theDiagram[this.prevV][7];
                    this.stateOfComponents[this.currComp][5] = this.prevV;
                    this.stateOfComponents[this.currComp][6] = this.theDiagram[this.prevV][6];
                    this.currMode = 11;
                    break;
                }
                case 2: {
                    this.isSimplifyFinished = true;
                    return;
                }
                default: {
                    this.errorCode = 300;
                    int[] er = new int[]{this.currMode};
                    this.errorRegistry = er;
                    return;
                }
            }
        }
    }

    public void kb_to_3P(PgKnotBook ext_kb) {
        int page;
        int j;
        int l = 0;
        int numPages = ext_kb.getNumPages();
        if (numPages != 3) {
            this.errorCode = 102;
            return;
        }
        int in_complexity = ext_kb.getNumVertices();
        if (in_complexity < 2) {
            this.errorCode = 103;
            int[] er = new int[]{in_complexity};
            this.errorRegistry = er;
            this.writeErrorMessage();
            return;
        }
        if (in_complexity != ext_kb.getNumArcs()) {
            this.errorCode = 104;
            int[] er = new int[]{in_complexity, ext_kb.getNumArcs()};
            this.errorRegistry = er;
            this.writeErrorMessage();
            return;
        }
        this.doCreateEmptyDiagram(in_complexity);
        PdVector[] vertices = ext_kb.getVertices();
        this.x[0] = vertices[0].getEntry(0);
        this.doInsertVertex(0, -1);
        if (this.errorCode > 0) {
            return;
        }
        int i = 1;
        while (i < in_complexity) {
            if (i != this.compleXity) {
                this.errorCode = 106;
                int[] er = new int[]{i, this.compleXity, in_complexity};
                this.errorRegistry = er;
                this.writeErrorMessage();
                return;
            }
            this.x[i] = vertices[i].getEntry(0);
            boolean isNotPlaced = true;
            j = 0;
            while (isNotPlaced && j < this.compleXity) {
                int k = this.theDiagram[j][4];
                l = j;
                isNotPlaced = this.x[j] < this.x[k] & this.x[k] < this.x[i];
                isNotPlaced = this.x[k] < this.x[i] & this.x[i] < this.x[j] || isNotPlaced;
                isNotPlaced = this.x[i] < this.x[j] & this.x[j] < this.x[k] || isNotPlaced;
                ++j;
            }
            if (isNotPlaced) {
                this.errorCode = 101;
                int[] er = new int[]{i, j, this.compleXity, in_complexity};
                this.errorRegistry = er;
                this.writeErrorMessage();
                return;
            }
            int iv = this.doInsertVertex(l, -1);
            if (iv != i) {
                this.errorCode = 105;
                int[] er = new int[]{i, j};
                this.errorRegistry = er;
                this.writeErrorMessage();
                return;
            }
            ++i;
        }
        if (this.compleXity != in_complexity) {
            this.errorCode = 107;
            int[] er = new int[]{this.compleXity, in_complexity};
            this.errorRegistry = er;
            this.writeErrorMessage();
            return;
        }
        PgKnotArc anArc = new PgKnotArc();
        this.isVerticesOriented = true;
        i = 0;
        while (i < this.compleXity) {
            anArc = ext_kb.getArc(i);
            int base = anArc.getBase();
            int end = anArc.getEnd();
            page = anArc.getPage();
            if (base < 0 || base >= this.compleXity) {
                this.errorCode = 120;
                int[] er = new int[]{this.compleXity, base, end, page};
                this.errorRegistry = er;
                this.writeErrorMessage();
                return;
            }
            if (end < 0 || end >= this.compleXity) {
                this.errorCode = 121;
                int[] er = new int[]{this.compleXity, base, end, page};
                this.errorRegistry = er;
                this.writeErrorMessage();
                return;
            }
            if (page < 0 || page >= 3) {
                this.errorCode = 122;
                int[] er = new int[]{this.compleXity, base, end, page};
                this.errorRegistry = er;
                this.writeErrorMessage();
                return;
            }
            this.doPutArc(base, end, page);
            if (this.errorCode > 0) {
                return;
            }
            ++i;
        }
        i = 0;
        while (i < this.compleXity) {
            if (this.theDiagram[i][7] == -1) {
                j = i;
                page = this.theDiagram[i][6];
                int comp = this.doAddComponent(i, page);
                do {
                    page = this.theDiagram[j][6];
                    this.theDiagram[j][7] = comp;
                    int[] nArray = this.stateOfComponents[comp];
                    int n = page;
                    nArray[n] = nArray[n] + 1;
                    int[] nArray2 = this.stateOfComponents[comp];
                    nArray2[3] = nArray2[3] + 1;
                    int len = nArray2[3];
                    if (len <= this.compleXity) continue;
                    this.errorCode = 110;
                    int[] er = this.stateOfComponents[comp];
                    this.errorRegistry = er;
                    this.writeErrorMessage();
                    return;
                } while ((j = this.theDiagram[j][page]) != i);
                this.stateOfComponents[comp][4] = this.stateOfComponents[comp][3];
                j = this.stateOfComponents[comp][0];
                j += this.stateOfComponents[comp][1];
                if ((j += this.stateOfComponents[comp][2]) != this.stateOfComponents[comp][3]) {
                    this.errorCode = 111;
                    int[] er = this.stateOfComponents[comp];
                    this.errorRegistry = er;
                    this.writeErrorMessage();
                    return;
                }
            }
            ++i;
        }
        this.lastVertex = this.theDiagram[0][3];
        j = 0;
        i = 0;
        while (i < this.numOfComponents) {
            j += this.stateOfComponents[i][3];
            ++i;
        }
        if (j != this.compleXity) {
            this.errorCode = 112;
            int[] er = new int[]{j, this.compleXity};
            this.errorRegistry = er;
            this.writeErrorMessage();
            return;
        }
    }

    public PgKnotBook back_to_kb() {
        PgKnotBook local_kb = new PgKnotBook();
        local_kb.setNumPages(3);
        if (this.errorCode > 0) {
            this.writeErrorMessage();
            return null;
        }
        PgKnotArc[] an_arc = new PgKnotArc[this.compleXity];
        int check_level = 2;
        if (this.currMode > 2) {
            check_level = 1;
        }
        this.doCheckDiagram(check_level);
        if (this.errorCode > 0) {
            this.writeErrorMessage();
            return null;
        }
        this.doDefrag();
        if (this.errorCode > 0) {
            this.writeErrorMessage();
            return null;
        }
        this.setOrientation();
        local_kb.setNumVertices(this.compleXity, 1);
        PdVector[] kb_v = new PdVector[this.compleXity];
        int i = 0;
        while (i < this.compleXity) {
            kb_v[i] = new PdVector(this.x[i]);
            ++i;
        }
        local_kb.setVertices(kb_v);
        if (!this.isVerticesOriented) {
            this.errorCode = 220;
            int[] er = new int[]{};
            this.errorRegistry = er;
            this.writeErrorMessage();
            return null;
        }
        local_kb.setNumArcs(this.numArcs[3]);
        int base = this.lastVertex;
        int j = 0;
        base = 0;
        while (base < this.compleXity) {
            int page = this.theDiagram[base][6];
            if (page != -1) {
                int end = this.theDiagram[base][page];
                an_arc[base] = new PgKnotArc();
                an_arc[base].setBase(base);
                an_arc[base].setEnd(end);
                an_arc[base].setPage(page);
                local_kb.setArc(j, an_arc[base]);
                ++j;
            }
            ++base;
        }
        return local_kb;
    }
}

