/*
 * Decompiled with CFR 0.152.
 */
package jvApp.knotBook;

import java.awt.Color;
import java.util.Date;
import jv.loader.PsXmlLoader;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.rsrc.PsXmlNode;
import jv.rsrc.PsXmlSrc;
import jv.vecmath.PdVector;
import jvApp.knotBook.PgKnotArc;
import jvApp.knotBook.PgKnotBook;

public class PsJkbLoader {
    public static PgKnotBook read(String fileName) {
        PsXmlSrc src = PsXmlLoader.read((String)fileName);
        if (src == null) {
            PsDebug.warning((String)("failed to parse XML in file = " + fileName));
            return null;
        }
        PgKnotBook geom = PsJkbLoader.parseRsrcTree(src);
        if (geom == null) {
            PsDebug.warning((String)("failed to interpret content of JKB file = " + fileName));
            return null;
        }
        return geom;
    }

    public static String write(PgKnotBook geom) {
        if (geom == null) {
            PsDebug.warning((String)"missing geometries.");
            return null;
        }
        PsXmlSrc src = PsJkbLoader.fillRsrcTree(null, geom);
        if (src == null) {
            PsDebug.warning((String)"failed to generate XML tree");
            return null;
        }
        return PsXmlSrc.write((PsXmlSrc)src);
    }

    protected static PgKnotBook parseRsrcTree(PsXmlSrc src) {
        PsXmlNode model = src.getRootNode();
        if (model == null) {
            PsDebug.warning((String)"missing root model.");
            return null;
        }
        PsXmlNode geometries = PsXmlSrc.getRsrcNode((PsXmlNode)model, (String)"geometries");
        String[] attr = new String[]{"tag"};
        if (geometries != null) {
            PsXmlNode[] geometry = PsXmlSrc.getRsrcNodes((PsXmlNode)geometries, (String)"geometry");
            if (geometry == null || geometry.length == 0) {
                PsDebug.warning((String)"no geometry.");
                return null;
            }
            int i = 0;
            while (i < geometry.length) {
                PsXmlNode knotBook2 = PsXmlSrc.getRsrcNode((PsXmlNode)model, (String)"knotBook");
                if (knotBook2 != null) {
                    PsXmlNode pages;
                    PsXmlNode arcs;
                    Color[] cList;
                    PsXmlNode colors;
                    Color c;
                    PgKnotBook geom = new PgKnotBook();
                    geom.setName(geometry[i].getAttribute("name"));
                    PsXmlNode points = PsXmlSrc.getRsrcNode((PsXmlNode)knotBook2, (String)"points");
                    if (points != null) {
                        double d;
                        PdVector[] vertex = PsXmlLoader.parseDoubleList((PsXmlNode)points, (String)"p", (String[])attr);
                        if (vertex != null) {
                            geom.setNumVertices(vertex.length, vertex[0].getSize());
                            geom.setVertices(vertex);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)points, (String)"size")) != 0.0) {
                            geom.setGlobalVertexSize(d);
                        }
                        if ((c = PsXmlLoader.parseColorRGB((PsXmlNode)points, (String)"color")) != null) {
                            geom.setGlobalVertexColor(c);
                        }
                        if ((c = PsXmlLoader.parseColorRGB((PsXmlNode)points, (String)"colorTag")) != null) {
                            geom.setGlobalVertexTagColor(c);
                        }
                    }
                    if ((colors = PsXmlSrc.getRsrcNode((PsXmlNode)knotBook2, (String)"colors")) != null && (cList = PsXmlLoader.parseColorList((PsXmlNode)colors, (String)"c")) != null) {
                        geom.setVertexColors(cList);
                    }
                    if ((arcs = PsXmlSrc.getRsrcNode((PsXmlNode)knotBook2, (String)"arcs")) != null) {
                        PsXmlNode[] arc = PsXmlSrc.getRsrcNodes((PsXmlNode)arcs, (String)"arc");
                        geom.setNumArcs(arc.length);
                        i = 0;
                        while (i < arc.length) {
                            int base = PsXmlSrc.getRsrcAsInteger((PsXmlNode)arc[i], (String)"base");
                            int end = PsXmlSrc.getRsrcAsInteger((PsXmlNode)arc[i], (String)"end");
                            int page = PsXmlSrc.getRsrcAsInteger((PsXmlNode)arc[i], (String)"onpage");
                            geom.getArc(i).set(base, end, page);
                            c = PsXmlLoader.parseColorRGB((PsXmlNode)arc[i], (String)"color");
                            if (c != null) {
                                geom.setArcColor(i, c);
                            }
                            ++i;
                        }
                        c = PsXmlLoader.parseColorRGB((PsXmlNode)arcs, (String)"color");
                        if (c != null) {
                            geom.setGlobalArcColor(c);
                        }
                    }
                    if ((pages = PsXmlSrc.getRsrcNode((PsXmlNode)knotBook2, (String)"pages")) != null) {
                        PsXmlNode[] page = PsXmlSrc.getRsrcNodes((PsXmlNode)pages, (String)"page");
                        if (page != null && page.length > 0) {
                            geom.setNumPages(page.length);
                            i = 0;
                            while (i < page.length) {
                                double angle = PsXmlSrc.getRsrcAsDouble((PsXmlNode)pages, (String)"angle");
                                geom.setPageAngle(i, angle);
                                c = PsXmlLoader.parseColorRGB((PsXmlNode)page[i], (String)"color");
                                if (c != null) {
                                    geom.setPageColor(i, c);
                                }
                                ++i;
                            }
                        }
                        if ((c = PsXmlLoader.parseColorRGB((PsXmlNode)pages, (String)"color")) != null) {
                            geom.setGlobalPageColor(c);
                        }
                    }
                    return geom;
                }
                ++i;
            }
        }
        return null;
    }

    protected static PsXmlSrc fillRsrcTree(PsXmlSrc src, PgKnotBook m_geom) {
        PsXmlNode root;
        if (m_geom == null) {
            return null;
        }
        if (src == null) {
            src = new PsXmlSrc();
        }
        if ((root = src.getRootNode()) == null) {
            root = new PsXmlNode("jkb-model");
            src.setRootNode(root);
        }
        PsXmlNode[] meta = new PsXmlNode[2];
        meta[0] = root.addChild("meta");
        meta[0].addAttribute("generator", String.valueOf(PsConfig.getProgram()) + "v." + PsConfig.getVersion());
        meta[1] = root.addChild("meta");
        meta[1].addAttribute("date", new Date().toString());
        if (m_geom.getName() != null) {
            root.addChild("title", m_geom.getName());
        }
        PsXmlNode geometries = root.addChild("geometries");
        PsXmlNode geometry = geometries.addChild("geometry");
        if (m_geom.getName() != null) {
            geometry.addAttribute("name", m_geom.getName());
        }
        PsXmlNode knotBook2 = geometry.addChild("knotBook");
        knotBook2.addAttribute("view", "3dbook");
        PsXmlNode points = knotBook2.addChild("points");
        PdVector[] vertices = m_geom.getVertices();
        int i = 0;
        while (i < vertices.length) {
            PsXmlNode p = points.addChild("p");
            p.setContent(String.valueOf(vertices[i].getEntry(0)));
            ++i;
        }
        PsXmlNode pages = knotBook2.addChild("pages");
        int numPages = m_geom.getNumPages();
        int i2 = 0;
        while (i2 < numPages) {
            PsXmlNode page = pages.addChild("page");
            page.setContent(String.valueOf(360 / numPages * i2));
            ++i2;
        }
        PsXmlNode arcs = knotBook2.addChild("arcs");
        PgKnotArc[] t_arcs = m_geom.getArcs();
        int i3 = 0;
        while (i3 < t_arcs.length) {
            PsXmlNode arc = arcs.addChild("arc");
            PsXmlNode base = arc.addChild("base");
            base.setContent(String.valueOf(t_arcs[i3].getBase()));
            PsXmlNode end = arc.addChild("end");
            end.setContent(String.valueOf(t_arcs[i3].getEnd()));
            PsXmlNode onpage = arc.addChild("onpage");
            onpage.setContent(String.valueOf(t_arcs[i3].getPage()));
            ++i3;
        }
        return src;
    }
}

