/*
 * Decompiled with CFR 0.152.
 */
package jvApp.knotBook;

import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class PlaneParser {
    private boolean maybeDataCorrect = true;
    private Vector crossings = new Vector();
    private double[][][] polinoms;
    private Vector basePointsPol = new Vector();
    private Hashtable polCross = new Hashtable();
    private int[] component_polinom_rel;

    public boolean getDataCorrectness() {
        return this.maybeDataCorrect;
    }

    public PlaneParser(String data) {
        if (data == null || data.equals("")) {
            return;
        }
        StringTokenizer st = new StringTokenizer(data);
        int lenght = st.countTokens();
        if (lenght % 3 != 0 || lenght == 0) {
            System.out.println("incorrect input data");
            this.maybeDataCorrect = false;
            return;
        }
        this.polinoms = new double[lenght / 3][2][3];
        this.component_polinom_rel = new int[lenght / 3];
        int currentComponent = -1;
        int prevCompLength = 0;
        while (!data.equals("")) {
            int ind = data.indexOf("\n\n");
            if (ind != -1) {
                st = new StringTokenizer(data.substring(0, ind));
                data = data.substring(ind + 1).trim();
                ++currentComponent;
                lenght = st.countTokens();
            } else {
                st = new StringTokenizer(data);
                lenght = st.countTokens();
                ++currentComponent;
                data = "";
            }
            double[] base = new double[3];
            double[] start_base = new double[3];
            try {
                start_base[0] = base[0] = Double.valueOf(st.nextToken()).doubleValue();
                start_base[1] = base[1] = Double.valueOf(st.nextToken()).doubleValue();
                start_base[2] = base[2] = Double.valueOf(st.nextToken()).doubleValue();
            }
            catch (NumberFormatException nfe) {
                System.out.println("incorrect input data");
                this.maybeDataCorrect = false;
                return;
            }
            int i = 3;
            while (i < lenght + 3) {
                this.polinoms[(i + prevCompLength - 3) / 3][0][i % 3] = base[i % 3];
                if (i < lenght) {
                    try {
                        base[i % 3] = Double.valueOf(st.nextToken());
                    }
                    catch (NumberFormatException nfe) {
                        System.out.println("incorrect input data");
                        this.maybeDataCorrect = false;
                        return;
                    }
                    this.polinoms[(i + prevCompLength) / 3 - 1][1][i % 3] = base[i % 3];
                } else {
                    this.polinoms[(i + prevCompLength) / 3 - 1][1][(i - lenght) % 3] = start_base[(i - lenght) % 3];
                }
                this.component_polinom_rel[(i + prevCompLength) / 3 - 1] = currentComponent;
                ++i;
            }
            prevCompLength += lenght;
        }
        this.initData();
    }

    private void initData() {
        this.correctInput();
        this.setCrossing();
    }

    private void correctInput() {
        int i = 0;
        while (i < this.polinoms.length) {
            double[][] i_crossing = this.polinoms[i];
            int j = i + 1;
            while (j < this.polinoms.length) {
                double[][] j_crossing = this.polinoms[j];
                double x1base = i_crossing[0][0];
                double y1base = i_crossing[0][1];
                double x1end = i_crossing[1][0];
                double y1end = i_crossing[1][1];
                double x2base = j_crossing[0][0];
                double y2base = j_crossing[0][1];
                double x2end = j_crossing[1][0];
                double y2end = j_crossing[1][1];
                if (x1base == x2end && y1base == y2end || x2base == x1end && y2base == y1end) break;
                if (x1base == x2base && y1base == y2base) {
                    j_crossing[0][0] = x2end;
                    j_crossing[0][1] = y2end;
                    j_crossing[1][0] = x2base;
                    j_crossing[1][1] = y2base;
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    private boolean setCrossing() {
        int crossCount = -1;
        int i = 0;
        while (i < this.polinoms.length) {
            double[][] polinom = this.polinoms[i];
            double x1 = polinom[0][0];
            double x2 = polinom[1][0];
            double y1 = polinom[0][1];
            double y2 = polinom[1][1];
            double z1 = polinom[0][2];
            double z2 = polinom[1][2];
            String key = String.valueOf(polinom[0][0]) + polinom[0][1] + polinom[0][2];
            this.basePointsPol.addElement(key);
            this.basePointsPol.addElement(new Integer(i));
            int j = i + 1;
            while (j < this.polinoms.length) {
                double[][] t_polinom = this.polinoms[j];
                double x3 = t_polinom[0][0];
                double x4 = t_polinom[1][0];
                double y3 = t_polinom[0][1];
                double y4 = t_polinom[1][1];
                double z3 = t_polinom[0][2];
                double z4 = t_polinom[1][2];
                if (!((x1 - x2) * (x3 - x4) + (y1 - y2) * (y3 - y4) == 0.0 || x1 == x3 && y1 == y3 || x1 == x4 && y1 == y4 || x2 == x3 && y2 == y3 || x2 == x4 && y2 == y4)) {
                    double cx12 = x1 - x2;
                    double cx43 = x4 - x3;
                    double cy12 = y1 - y2;
                    double cy43 = y4 - y3;
                    double y = x3 - x2 + y2 * cx12 / cy12 - y3 * cx43 / cy43;
                    double x = y3 - y2 + x2 * cy12 / cx12 - x3 * cy43 / cx43;
                    double z = (z1 - z2) * ((x /= cy12 / cx12 - cy43 / cx43) - x2) / (x1 - x2) + z2;
                    double t_z = (z3 - z4) * (x - x4) / (x3 - x4) + z4;
                    if (Math.min(x1, x2) < x && x < Math.max(x1, x2) && Math.min(x3, x4) < x && x < Math.max(x3, x4) && Math.min(y1, y2) < (y /= cx12 / cy12 - cx43 / cy43) && y < Math.max(y1, y2) && Math.min(y3, y4) < y && y < Math.max(y3, y4) && (x != x1 || y != y1) && (x != x2 || y != y2) && (x != x3 || y != y3) && (x != x4 || y != y4)) {
                        int[] c;
                        ++crossCount;
                        if (t_z < z) {
                            c = new int[]{crossCount, i, j};
                            this.crossings.addElement(c);
                        } else if (t_z > z) {
                            c = new int[]{crossCount, j, i};
                            this.crossings.addElement(c);
                        } else {
                            System.out.println("ERROR: incorrect crossing");
                            return false;
                        }
                        Integer i_i = new Integer(i);
                        Integer i_j = new Integer(j);
                        Vector<Object> i_crossName = (Vector<Object>)this.polCross.get(i_i);
                        Vector<Object> j_crossName = (Vector<Object>)this.polCross.get(i_j);
                        if (i_crossName == null) {
                            i_crossName = new Vector<Object>();
                        }
                        if (j_crossName == null) {
                            j_crossName = new Vector<Object>();
                        }
                        double[] cross_point = new double[]{x, y};
                        i_crossName.addElement(cross_point);
                        j_crossName.addElement(cross_point);
                        i_crossName.addElement(new Integer(crossCount));
                        j_crossName.addElement(new Integer(crossCount));
                        this.polCross.put(i_i, i_crossName);
                        this.polCross.put(i_j, j_crossName);
                    }
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public String getGC() {
        int c_polinom;
        Vector<String[]> v_GCs = new Vector<String[]>();
        int crossNum = this.crossings.size();
        if (crossNum == 0) {
            return "Trivial Knot";
        }
        int crossLeave = 0;
        int firstInComponent = c_polinom = 0;
        int currentComponentNum = this.component_polinom_rel[c_polinom];
        int[] comp_s_ind = null;
        Hashtable<String, Integer> already_been = new Hashtable<String, Integer>();
        block0: while (true) {
            int t_ind;
            int i;
            double[][] polinom = this.polinoms[c_polinom];
            String key = String.valueOf(polinom[1][0]) + polinom[1][1] + polinom[1][2];
            double x1 = polinom[0][0];
            double x2 = polinom[1][0];
            double y1 = polinom[0][1];
            double y2 = polinom[1][1];
            Object o_cross = this.polCross.get(new Integer(c_polinom));
            if (o_cross != null) {
                Vector v_crosses = (Vector)o_cross;
                v_crosses = this.crossingsSorted(v_crosses, c_polinom);
                i = 1;
                while (i < v_crosses.size()) {
                    int c_cross = (Integer)v_crosses.elementAt(i);
                    int[] crossing = (int[])this.crossings.elementAt(c_cross);
                    String[] c_GC = new String[]{"", "", String.valueOf(crossing[0])};
                    int cross_polinom_ind = -1;
                    if (crossing[1] == c_polinom) {
                        cross_polinom_ind = crossing[2];
                        c_GC[0] = "+";
                    } else {
                        cross_polinom_ind = crossing[1];
                        c_GC[0] = "-";
                    }
                    Object o_tmp = already_been.get(String.valueOf(crossing[0]));
                    if (o_tmp != null) {
                        int i_tmp = (Integer)o_tmp;
                        String[] tmp_GCs = (String[])v_GCs.elementAt(i_tmp);
                        double[][] tmp_polinom = this.polinoms[cross_polinom_ind];
                        double v_mul = (x2 - x1) * (tmp_polinom[1][1] - tmp_polinom[0][1]) - (y2 - y1) * (tmp_polinom[1][0] - tmp_polinom[0][0]);
                        if (v_mul < 0.0) {
                            c_GC[1] = ">";
                            tmp_GCs[1] = "<";
                        } else {
                            c_GC[1] = "<";
                            tmp_GCs[1] = ">";
                        }
                        v_GCs.setElementAt(tmp_GCs, i_tmp);
                    }
                    already_been.put(String.valueOf(crossing[0]), new Integer(crossLeave));
                    v_GCs.addElement(c_GC);
                    if (++crossLeave >= 2 * crossNum) break;
                    i += 2;
                }
                if (crossLeave >= 2 * crossNum) break;
            }
            if ((c_polinom = ((Integer)this.basePointsPol.elementAt((t_ind = this.basePointsPol.indexOf(key)) + 1)).intValue()) != firstInComponent) continue;
            i = 0;
            while (true) {
                if (i >= this.component_polinom_rel.length) continue block0;
                if (this.component_polinom_rel[i] == currentComponentNum + 1) {
                    currentComponentNum = this.component_polinom_rel[i];
                    int t_l = 0;
                    if (comp_s_ind != null) {
                        t_l = comp_s_ind.length;
                    }
                    int[] i_tmp = new int[t_l + 1];
                    int j = 0;
                    while (j < t_l) {
                        i_tmp[j] = comp_s_ind[j];
                        ++j;
                    }
                    i_tmp[t_l] = v_GCs.size();
                    comp_s_ind = i_tmp;
                    firstInComponent = c_polinom = i;
                    continue block0;
                }
                ++i;
            }
            break;
        }
        return this.makeStringGC(v_GCs, comp_s_ind);
    }

    private String makeStringGC(Vector v, int[] comp_s_ind) {
        int i;
        String result = "";
        if (comp_s_ind != null) {
            int compNum = 0;
            i = 0;
            while (i < comp_s_ind.length) {
                String[] comp = new String[]{"", "Component", ""};
                v.insertElementAt(comp, comp_s_ind[i] + compNum);
                ++compNum;
                ++i;
            }
        }
        int length = v.size();
        i = 0;
        while (i < length) {
            String[] s_crossing = (String[])v.elementAt(i);
            result = String.valueOf(result) + s_crossing[0] + s_crossing[1] + s_crossing[2] + "\n";
            ++i;
        }
        return result;
    }

    private Vector crossingsSorted(Vector v_crosses, int c_polinom) {
        double[][] polinom = this.polinoms[c_polinom];
        double x1 = polinom[0][0];
        double x2 = polinom[1][0];
        double y1 = polinom[0][1];
        double y2 = polinom[1][1];
        Vector<Object> tmp = new Vector<Object>();
        Object o = new Object();
        int i = 0;
        while (i < v_crosses.size()) {
            tmp.addElement(v_crosses.elementAt(i));
            tmp.addElement(v_crosses.elementAt(i + 1));
            double[] cr = (double[])v_crosses.elementAt(i);
            int j = 0;
            while (j < tmp.size()) {
                if (i != j) {
                    int tmp_size;
                    double[] t_cr = (double[])v_crosses.elementAt(j);
                    if (x1 > x2 && cr[0] > t_cr[0]) {
                        tmp.insertElementAt(cr, j);
                        o = v_crosses.elementAt(i + 1);
                        tmp.insertElementAt(o, j + 1);
                        v_crosses.insertElementAt(cr, j);
                        v_crosses.removeElementAt(i + 1);
                        v_crosses.insertElementAt(o, j + 1);
                        v_crosses.removeElementAt(i + 2);
                        tmp_size = tmp.size();
                        tmp.removeElementAt(tmp_size - 1);
                        tmp.removeElementAt(tmp_size - 2);
                        break;
                    }
                    if (x1 < x2 && cr[0] < t_cr[0]) {
                        tmp.insertElementAt(cr, j);
                        tmp.insertElementAt(v_crosses.elementAt(i + 1), j + 1);
                        v_crosses.insertElementAt(cr, j);
                        v_crosses.removeElementAt(i + 1);
                        v_crosses.insertElementAt(o, j + 1);
                        v_crosses.removeElementAt(i + 2);
                        tmp_size = tmp.size();
                        tmp.removeElementAt(tmp_size - 1);
                        tmp.removeElementAt(tmp_size - 2);
                        break;
                    }
                    if (x1 == x2) {
                        if (y1 < y2 && cr[1] < t_cr[1]) {
                            tmp.insertElementAt(cr, j);
                            tmp.insertElementAt(v_crosses.elementAt(i + 1), j + 1);
                            v_crosses.insertElementAt(cr, j);
                            v_crosses.removeElementAt(i + 1);
                            v_crosses.insertElementAt(o, j + 1);
                            v_crosses.removeElementAt(i + 2);
                            tmp_size = tmp.size();
                            tmp.removeElementAt(tmp_size - 1);
                            tmp.removeElementAt(tmp_size - 2);
                            break;
                        }
                        if (y1 > y2 && cr[1] > t_cr[1]) {
                            tmp.insertElementAt(cr, j);
                            tmp.setElementAt(v_crosses.elementAt(i + 1), j + 1);
                            v_crosses.insertElementAt(cr, j);
                            v_crosses.removeElementAt(i + 1);
                            v_crosses.insertElementAt(o, j + 1);
                            v_crosses.removeElementAt(i + 2);
                            tmp_size = tmp.size();
                            tmp.removeElementAt(tmp_size - 1);
                            tmp.removeElementAt(tmp_size - 2);
                            break;
                        }
                        if (y1 == y2) {
                            System.out.println("ERROR: impossible situation in PlaneParser");
                        }
                    }
                }
                j += 2;
            }
            i += 2;
        }
        return tmp;
    }
}

