/*
 * Decompiled with CFR 0.152.
 */
package jvApp.knotBook;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import jv.loader.PsCategoryList_IP;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsDialog;
import jv.object.PsUpdateIf;
import jv.project.PjProject_IP;
import jvApp.knotBook.PjKnotBook;

public class PjKnotBook_IP
extends PjProject_IP
implements ItemListener,
ActionListener {
    protected PjKnotBook dp;
    protected Panel mainPanel;
    protected Label modelLabel;
    protected Button butSelectModel;
    protected Button butInputKnot;
    protected Button butReset;
    protected Button butSaveJKB;
    protected CheckboxGroup viewType;
    protected Checkbox view2D;
    protected Checkbox view3D;
    protected Checkbox viewFree3D;
    protected PuInteger arcDisc;
    protected PuInteger upPageIndex;
    protected PuInteger downPageIndex;
    protected Button butSimplify;
    protected Button butPermutate;
    protected Label processLabel;
    protected Label numVerticesLabel;
    protected Label numComponentsLabel;
    protected Frame inputFrame;
    protected CheckboxGroup knotType;
    protected Checkbox knotGC;
    protected Checkbox knot3D;
    protected TextArea inputArea;
    protected Label doc1;
    protected Label doc2;
    protected Label doc3;
    protected Button loadGcButton;
    protected Button saveGcButton;
    protected Button decodeGcButton;
    protected Button clearButton;
    protected Button canscelButton;
    protected String[] cat = new String[]{"jkb", "gc", "txt"};
    protected String[][] entry;
    static /* synthetic */ Class class$0;

    public PjKnotBook_IP() {
        this.setTitle("Booknoot Project");
        this.mainPanel = new Panel();
        this.mainPanel.setLayout(new GridLayout(20, 1, 2, 2));
        Label mslabel = new Label("Set Model:");
        this.mainPanel.add(mslabel);
        this.modelLabel = new Label("");
        Panel fileNamePanel = new Panel();
        fileNamePanel.setLayout(new GridLayout(1, 1));
        fileNamePanel.setBackground(Color.white);
        fileNamePanel.add(this.modelLabel);
        this.mainPanel.add(fileNamePanel);
        Panel pModel = new Panel();
        pModel.setLayout(new GridLayout(1, 2, 2, 2));
        this.butSelectModel = new Button("Choose Knot");
        this.butSelectModel.addActionListener(this);
        this.butInputKnot = new Button("Edit New Knot");
        this.butInputKnot.addActionListener(this);
        pModel.add(this.butSelectModel);
        pModel.add(this.butInputKnot);
        this.mainPanel.add(pModel);
        Panel saveModel = new Panel();
        saveModel.setLayout(new GridLayout(1, 2));
        this.butReset = new Button("Reset");
        this.butReset.addActionListener(this);
        this.butSaveJKB = new Button("Save Present Knot");
        this.butSaveJKB.addActionListener(this);
        saveModel.add(this.butReset);
        saveModel.add(this.butSaveJKB);
        this.mainPanel.add(saveModel);
        this.mainPanel.add(new Panel());
        Panel pView = new Panel();
        pView.setLayout(new GridLayout(1, 4));
        this.viewType = new CheckboxGroup();
        this.view2D = new Checkbox("2D", this.viewType, false);
        this.view2D.addItemListener(this);
        this.view3D = new Checkbox("3D", this.viewType, true);
        this.view3D.addItemListener(this);
        this.viewFree3D = new Checkbox("Free", this.viewType, false);
        this.viewFree3D.addItemListener(this);
        pView.add(new Label("View Mode:"));
        pView.add(this.view2D);
        pView.add(this.view3D);
        pView.add(this.viewFree3D);
        this.mainPanel.add(pView);
        this.upPageIndex = new PuInteger("Upper Page", (PsUpdateIf)this);
        this.downPageIndex = new PuInteger("Lower Page", (PsUpdateIf)this);
        this.arcDisc = new PuInteger("Edges per Arc", (PsUpdateIf)this);
        this.mainPanel.add((Component)this.arcDisc.getInfoPanel());
        this.mainPanel.add((Component)this.upPageIndex.getInfoPanel());
        this.mainPanel.add((Component)this.downPageIndex.getInfoPanel());
        Panel pMoves = new Panel();
        pMoves.setLayout(new GridLayout(1, 2, 2, 2));
        this.butSimplify = new Button("Simplify");
        this.butSimplify.addActionListener(this);
        this.butPermutate = new Button("Vertex Permutation");
        this.butPermutate.addActionListener(this);
        pMoves.add(this.butSimplify);
        pMoves.add(this.butPermutate);
        this.mainPanel.add(pMoves);
        this.processLabel = new Label();
        this.mainPanel.add(this.processLabel);
        this.numVerticesLabel = new Label();
        this.mainPanel.add(this.numVerticesLabel);
        this.numComponentsLabel = new Label();
        this.mainPanel.add(this.numComponentsLabel);
        this.inputFrame = new Frame("Type Knot");
        this.inputFrame.setLayout(new CardLayout());
        this.inputFrame.setBackground(Color.lightGray);
        Panel inputPanel = new Panel();
        inputPanel.setLayout(new BorderLayout());
        inputPanel.setBackground(Color.lightGray);
        this.inputFrame.add((Component)inputPanel, "Input");
        Panel typePanel = new Panel();
        this.knotType = new CheckboxGroup();
        this.knotGC = new Checkbox("Gauss Code", this.knotType, false);
        this.knotGC.addItemListener(this);
        this.knot3D = new Checkbox("3D Polygon", this.knotType, true);
        this.knot3D.addItemListener(this);
        typePanel.add(this.knotGC);
        typePanel.add(this.knot3D);
        inputPanel.add((Component)typePanel, "North");
        this.inputArea = new TextArea("");
        this.inputArea.setName("New Knot");
        inputPanel.add((Component)this.inputArea, "Center");
        Panel controlPanel = new Panel();
        controlPanel.setLayout(new BorderLayout());
        controlPanel.setBackground(Color.lightGray);
        Panel controlDocPanel = new Panel();
        controlDocPanel.setBackground(new Color(230, 230, 230));
        controlDocPanel.setLayout(new FlowLayout(1));
        controlDocPanel.setLayout(new GridLayout(3, 1));
        this.doc1 = new Label();
        this.doc2 = new Label();
        this.doc3 = new Label();
        this.doc1.setText("3D Polygon:  Type 3D coordinates sequentially according the knot");
        this.doc2.setText("             orientation. Separate coordinates by spaces, vertices");
        this.doc3.setText("             by a newline, and knot components by a blank line.");
        controlDocPanel.add(this.doc1);
        controlDocPanel.add(this.doc2);
        controlDocPanel.add(this.doc3);
        controlPanel.add((Component)controlDocPanel, "North");
        Panel controlLeftPanel = new Panel();
        controlLeftPanel.setBackground(Color.lightGray);
        controlLeftPanel.setLayout(new FlowLayout(0));
        this.loadGcButton = new Button("Load");
        this.loadGcButton.addActionListener(this);
        this.saveGcButton = new Button("Save");
        this.saveGcButton.addActionListener(this);
        controlLeftPanel.add(this.loadGcButton);
        controlLeftPanel.add(this.saveGcButton);
        controlPanel.add((Component)controlLeftPanel, "West");
        Panel controlRigthPanel = new Panel();
        controlRigthPanel.setBackground(Color.lightGray);
        controlRigthPanel.setLayout(new FlowLayout(2));
        this.decodeGcButton = new Button("Ok");
        this.decodeGcButton.addActionListener(this);
        this.clearButton = new Button("Clear");
        this.clearButton.addActionListener(this);
        this.canscelButton = new Button("Cancel");
        this.canscelButton.addActionListener(this);
        controlRigthPanel.add(this.decodeGcButton);
        controlRigthPanel.add(this.clearButton);
        controlRigthPanel.add(this.canscelButton);
        controlPanel.add((Component)controlRigthPanel, "East");
        inputPanel.add((Component)controlPanel, "South");
        this.inputFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                PjKnotBook_IP.this.cancelInput();
            }
        });
        this.inputFrame.pack();
        this.inputFrame.setSize(400, 400);
        this.inputFrame.setLocation(10, 10);
        this.inputFrame.setVisible(false);
        ((Container)((Object)this)).add(this.mainPanel);
        Class<?> clazz = this.getClass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("jvApp.knotBook.PjKnotBook_IP");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.upPageIndex.setEnabled(false);
        this.downPageIndex.setEnabled(false);
    }

    public void setParent(PsUpdateIf parent) {
        super.setParent(parent);
        this.dp = (PjKnotBook)parent;
        if (this.dp != null) {
            this.modelLabel.setText(this.dp.getDefaultKnotFileName());
            this.upPageIndex.setDefValue(this.dp.getBKView().getUpPage());
            this.upPageIndex.setDefBounds(0, this.dp.getNumPages() - 1, 1, 1);
            this.upPageIndex.init();
            this.downPageIndex.setDefValue(this.dp.getBKView().getDownPage());
            this.downPageIndex.setDefBounds(0, this.dp.getNumPages() - 1, 1, 1);
            this.downPageIndex.init();
            this.arcDisc.setDefValue(this.dp.getBKView().getArcDisc());
            this.arcDisc.setDefBounds(2, 30, 1, 2);
            this.arcDisc.init();
            this.setTitle(this.dp.getName());
            this.setNumVerticesLabelText();
            this.setNumComponentsLabelText();
        }
    }

    public boolean update(Object event) {
        if (this.dp == null) {
            PsDebug.warning((String)"PjKnotBook_IP.update(): missing parent, setParent not called");
            return false;
        }
        if (event == this.dp) {
            return true;
        }
        if (event == this.arcDisc) {
            this.dp.getBKView().setArcDisc(this.arcDisc.getValue());
            return this.dp.update(this);
        }
        if (event == this.upPageIndex) {
            this.dp.getBKView().setUpPage(this.upPageIndex.getValue());
            return this.dp.update(this);
        }
        if (event == this.downPageIndex) {
            this.dp.getBKView().setDownPage(this.downPageIndex.getValue());
            return this.dp.update(this);
        }
        return true;
    }

    public void actionPerformed(ActionEvent ae) {
        String modelDir;
        if (this.dp == null) {
            return;
        }
        Object source = ae.getSource();
        if (source == this.butSelectModel) {
            boolean isAppletMode;
            String model;
            if (this.dp.getViewer().getFrame() == null) {
                modelDir = this.dp.getFileDir();
                model = this.getEntry(-1);
                if (model == null || model.equals("")) {
                    return;
                }
                isAppletMode = true;
            } else {
                String[] modelDate = this.dp.selectModel(0);
                if (modelDate == null || (String.valueOf(modelDate[0]) + modelDate[1]).equals("")) {
                    return;
                }
                modelDir = modelDate[0];
                model = modelDate[1];
                isAppletMode = false;
            }
            if (model.endsWith(".jkb")) {
                String string = modelDir = isAppletMode ? String.valueOf(modelDir) + "jkb/" : modelDir;
                if (this.dp.readAndSetJKB(modelDir, model)) {
                    this.modelLabel.setText(model);
                    this.setNumVerticesLabelText();
                    this.setNumComponentsLabelText();
                    this.dp.update(this);
                }
            }
            if (model.endsWith(".gc")) {
                String string = modelDir = isAppletMode ? String.valueOf(modelDir) + "gc/" : modelDir;
                if (this.dp.readAndSetGC(modelDir, model)) {
                    this.modelLabel.setText(model);
                    this.setNumVerticesLabelText();
                    this.setNumComponentsLabelText();
                    this.dp.update(this);
                }
            }
            if (model.endsWith(".txt")) {
                String string = modelDir = isAppletMode ? String.valueOf(modelDir) + "poly3D/" : modelDir;
                if (this.dp.readAndSet3D(modelDir, model)) {
                    this.modelLabel.setText(model);
                    this.setNumVerticesLabelText();
                    this.setNumComponentsLabelText();
                    this.dp.update(this);
                }
            }
        }
        if (source == this.butSimplify) {
            this.dp.simplify();
            this.setNumVerticesLabelText();
            this.setNumComponentsLabelText();
            this.dp.update(this);
            return;
        }
        if (source == this.butPermutate) {
            this.dp.permutateVertices();
            this.dp.update(this);
            return;
        }
        if (source == this.butSaveJKB) {
            boolean isAppletMode = this.dp.getViewer().getFrame() == null;
            this.dp.exportJkb(isAppletMode);
        }
        if (source == this.butReset) {
            String name = this.dp.getCurrentKnotFileName();
            if (name == null || name.equals("")) {
                return;
            }
            if (name.equals("New Knot")) {
                if (this.dp.decode(this.inputArea.getText(), "New Knot")) {
                    this.setNumVerticesLabelText();
                    this.setNumComponentsLabelText();
                    this.dp.update(this);
                }
                return;
            }
            String model = name.substring(Math.max(name.lastIndexOf("\\"), name.lastIndexOf("/")) + 1);
            String defDir = name.substring(0, Math.max(name.lastIndexOf("\\"), name.lastIndexOf("/")) + 1);
            if (model.endsWith(".jkb") && this.dp.readAndSetJKB(defDir, model)) {
                this.setNumVerticesLabelText();
                this.setNumComponentsLabelText();
                this.dp.update(this);
            }
            if (model.endsWith(".gc") && this.dp.readAndSetGC(defDir, model)) {
                this.setNumVerticesLabelText();
                this.setNumComponentsLabelText();
                this.dp.update(this);
            }
            if (model.endsWith(".txt") && this.dp.readAndSet3D(defDir, model)) {
                this.setNumVerticesLabelText();
                this.setNumComponentsLabelText();
                this.dp.update(this);
            }
        }
        if (source == this.butInputKnot) {
            CardLayout cl = (CardLayout)this.inputFrame.getLayout();
            cl.show(this.inputFrame, "Input");
            this.inputFrame.setVisible(true);
            return;
        }
        if (source == this.loadGcButton) {
            if (this.knotGC.getState()) {
                String model;
                if (this.dp.getViewer().getFrame() == null) {
                    modelDir = String.valueOf(this.dp.getFileDir()) + "gc/";
                    model = this.getEntry(1);
                } else {
                    String[] modelDate = this.dp.selectModel(2);
                    if (modelDate == null) {
                        return;
                    }
                    modelDir = modelDate[0];
                    model = modelDate[1];
                }
                if (model == null || model.equals("") || modelDir == null || modelDir.equals("")) {
                    return;
                }
                String gc = this.dp.readFile(modelDir, model);
                if (gc == null || gc.equals("")) {
                    return;
                }
                this.inputArea.setText(gc);
            } else {
                String model;
                if (this.dp.getViewer().getFrame() == null) {
                    modelDir = String.valueOf(this.dp.getFileDir()) + "poly3D/";
                    model = this.getEntry(2);
                } else {
                    String[] modelDate = this.dp.selectModel(3);
                    if (modelDate == null) {
                        return;
                    }
                    modelDir = modelDate[0];
                    model = modelDate[1];
                }
                if (model == null || model.equals("") || modelDir == null || modelDir.equals("")) {
                    return;
                }
                String coord = this.dp.readFile(modelDir, model);
                if (coord == null || coord.equals("")) {
                    return;
                }
                this.inputArea.setText(coord);
            }
            return;
        }
        if (source == this.decodeGcButton) {
            this.okDecode();
            return;
        }
        if (source == this.saveGcButton) {
            boolean isAppletMode;
            boolean bl = isAppletMode = this.dp.getViewer().getFrame() == null;
            if (this.knotGC.getState()) {
                this.dp.exportGk(this.inputArea.getText(), isAppletMode);
            } else {
                this.dp.export3D(this.inputArea.getText(), isAppletMode);
            }
            return;
        }
        if (source == this.clearButton) {
            this.inputArea.setText("");
            return;
        }
        if (source == this.canscelButton) {
            this.cancelInput();
            return;
        }
    }

    public void itemStateChanged(ItemEvent event) {
        if (this.dp == null) {
            return;
        }
        Object source = event.getSource();
        if (source == this.view2D) {
            this.dp.setViewMode(1);
            this.upPageIndex.setEnabled(true);
            this.downPageIndex.setEnabled(true);
            this.dp.update(this);
            return;
        }
        if (source == this.view3D) {
            this.dp.setViewMode(2);
            this.upPageIndex.setEnabled(false);
            this.downPageIndex.setEnabled(false);
            this.dp.update(this);
            return;
        }
        if (source == this.viewFree3D) {
            this.dp.setViewMode(3);
            this.upPageIndex.setEnabled(false);
            this.downPageIndex.setEnabled(false);
            this.dp.update(this);
            return;
        }
        if (source == this.knotGC) {
            this.doc1.setText("Gauss Code:  see Documentation.");
            this.doc2.setText("");
            this.doc3.setText("");
        }
        if (source == this.knot3D) {
            this.doc1.setText("3D Polygon:  Type 3D coordinates sequentially according the knot");
            this.doc2.setText("             orientation. Separate coordinates by spaces, vertices");
            this.doc3.setText("             by a newline, and knot components by a blank line.");
        }
    }

    public void setProcessStatusLabel(String text) {
        this.processLabel.setText("Status: " + text);
    }

    private void setNumVerticesLabelText() {
        if (this.dp == null) {
            return;
        }
        int num = this.dp.getNumVertices();
        if (num > 0) {
            this.numVerticesLabel.setText("Number of Vertices: " + num);
        } else {
            this.numVerticesLabel.setText("no Vertices");
        }
    }

    private void setNumComponentsLabelText() {
        if (this.dp == null) {
            return;
        }
        int num = this.dp.getNumComponents();
        if (num >= 0) {
            this.numComponentsLabel.setText("Number of Components: " + num);
        } else {
            this.numComponentsLabel.setText("no Components");
        }
    }

    protected void cancelInput() {
        this.inputFrame.setVisible(false);
    }

    private void okDecode() {
        if (this.knotGC.getState() && this.dp.decode(this.inputArea.getText(), "New Knot")) {
            this.modelLabel.setText("New Knot");
            this.dp.setCurrentKnotFileName("New Knot");
            this.setNumVerticesLabelText();
            this.setNumComponentsLabelText();
            this.dp.update(this);
        }
        if (this.knot3D.getState()) {
            String gc = this.dp.getGCfrom3D(this.inputArea.getText());
            if (gc != null && !gc.equals("")) {
                this.inputArea.setText(gc);
                this.knotGC.setState(true);
                this.dp.update(this);
            }
            return;
        }
    }

    private void setCategoriesEntry(String[] new_cat) {
        String[] files = this.dp.getKnotFileNames();
        int fileLen = files.length;
        int[] numEntries = new int[new_cat.length];
        this.entry = new String[new_cat.length][0];
        int i = 0;
        while (i < fileLen) {
            int catInd = 0;
            while (catInd < new_cat.length) {
                if (files[i].endsWith(new_cat[catInd])) {
                    int n = catInd;
                    numEntries[n] = numEntries[n] + 1;
                }
                ++catInd;
            }
            ++i;
        }
        int catInd = 0;
        while (catInd < new_cat.length) {
            this.entry[catInd] = new String[numEntries[catInd]];
            int lockInd = 0;
            int i2 = 0;
            while (i2 < fileLen) {
                if (files[i2].endsWith(new_cat[catInd])) {
                    this.entry[catInd][lockInd] = files[i2];
                    ++lockInd;
                }
                ++i2;
            }
            ++catInd;
        }
    }

    private String getEntry(int categoryInd) {
        PsCategoryList_IP projIP = new PsCategoryList_IP();
        switch (categoryInd) {
            case 0: {
                String[] new_cat = new String[]{this.cat[0]};
                this.setCategoriesEntry(new_cat);
                projIP.setCategories(new_cat, this.entry);
                break;
            }
            case 1: {
                String[] new_cat = new String[]{this.cat[1]};
                this.setCategoriesEntry(new_cat);
                projIP.setCategories(new_cat, this.entry);
                break;
            }
            case 2: {
                String[] new_cat = new String[]{this.cat[2]};
                this.setCategoriesEntry(new_cat);
                projIP.setCategories(new_cat, this.entry);
                break;
            }
            default: {
                this.setCategoriesEntry(this.cat);
                projIP.setCategories(this.cat, this.entry);
            }
        }
        projIP.setTitle("New geometry replaces current scene");
        PsDialog dialog = new PsDialog(PsConfig.getFrame(), "Select New Knot", true);
        dialog.setLayout(new BorderLayout());
        dialog.add("Center", (Component)projIP);
        dialog.add("South", dialog.getBottomButtons(5));
        dialog.setLocation(10, 10);
        dialog.setSize(300, 330);
        dialog.validate();
        dialog.setVisible(true);
        int userAction = dialog.getUserAction();
        if (userAction != 4) {
            return "";
        }
        String selectedProj = projIP.getSelectedEntry();
        return selectedProj;
    }
}

