/*
 * Decompiled with CFR 0.152.
 */
package jvApp.knotBook;

import java.awt.FileDialog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;
import jv.geom.PgElementSet;
import jv.geom.PgPolygonSet;
import jv.loader.PgLoader;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jvApp.knotBook.BooknotView;
import jvApp.knotBook.DecoderGC;
import jvApp.knotBook.GoeritzMaker;
import jvApp.knotBook.JvxMaker;
import jvApp.knotBook.PgKnotBook;
import jvApp.knotBook.PjKnotBook_IP;
import jvApp.knotBook.PlaneParser;
import jvApp.knotBook.PsJkbLoader;
import jvApp.knotBook.ThreePageLink;

public class PjKnotBook
extends PjProject {
    private PgKnotBook m_knotbook;
    private BooknotView m_bkview;
    private PgElementSet pages;
    private PgPolygonSet knot;
    static final int VIEW_2D = 1;
    static final int VIEW_3D = 2;
    static final int VIEW_FREE = 3;
    protected int m_viewMode = 2;
    private String fileDir;
    private String defaultKnotFileName;
    private String currentKnotFileName;
    private boolean doNotFitDisplay = false;

    public PjKnotBook(String fileDir, String defaultKnotFileName) {
        super("PjKnotBook");
        this.fileDir = fileDir;
        this.defaultKnotFileName = defaultKnotFileName;
        this.knot = new PgPolygonSet();
        this.knot.setName("Knot");
        this.knot.setGlobalPolygonSize(0.1);
        this.knot.showVertices(false);
        this.knot.showPolygonColors(true);
        this.knot.showPolygonEndArrow(true);
        this.pages = new PgElementSet();
        this.pages.setName("Book");
        this.pages.showElements(false);
        this.addGeometry((PgGeometryIf)this.knot);
        this.addGeometry((PgGeometryIf)this.pages);
        this.m_bkview = new BooknotView();
        this.readAndSetJKB(String.valueOf(fileDir) + "jkb/", defaultKnotFileName);
    }

    public void init() {
        super.init();
        this.computeView();
    }

    public void start() {
        this.setCameraMode(this.m_viewMode);
        if (this.m_knotbook == null) {
            this.setProcessStatusLabel("Knot not found");
        } else {
            this.setProcessStatusLabel("no process.");
        }
        super.start();
    }

    public boolean update(Object event) {
        if (event == this.getInfoPanel()) {
            this.computeView();
        }
        return super.update(event);
    }

    public String getDefaultKnotFileName() {
        return this.defaultKnotFileName;
    }

    public String getFileDir() {
        return this.fileDir;
    }

    public String getCurrentKnotFileName() {
        return this.currentKnotFileName;
    }

    public void setCurrentKnotFileName(String name) {
        this.currentKnotFileName = name;
    }

    public void setViewMode(int mode) {
        switch (mode) {
            case 1: 
            case 2: 
            case 3: {
                this.m_viewMode = mode;
                this.setCameraMode(this.m_viewMode);
            }
        }
    }

    protected void setCameraMode(int mode) {
        PvDisplayIf disp = this.getDisplay();
        if (disp != null) {
            switch (mode) {
                case 1: {
                    disp.selectCamera(1);
                    disp.setMajorMode(6);
                    break;
                }
                case 2: 
                case 3: {
                    disp.selectCamera(0);
                    disp.setMajorMode(0);
                }
            }
        }
    }

    private void fitDisplay() {
        if (this.doNotFitDisplay) {
            this.doNotFitDisplay = false;
            return;
        }
        PvDisplayIf disp = this.getDisplay();
        if (disp != null) {
            disp.fit();
        }
    }

    protected void computeView() {
        if (this.m_knotbook == null) {
            this.setProcessStatusLabel("Knot not found");
        } else {
            this.setProcessStatusLabel("Drawing the Knot");
            switch (this.m_viewMode) {
                case 1: {
                    this.m_bkview.compute2DView(this.m_knotbook, this.knot, this.pages);
                    this.fitDisplay();
                    break;
                }
                case 2: {
                    this.m_bkview.compute3DView(this.m_knotbook, this.knot, this.pages, false);
                    this.fitDisplay();
                    break;
                }
                case 3: {
                    this.m_bkview.compute3DView(this.m_knotbook, this.knot, this.pages, true);
                    this.fitDisplay();
                }
            }
            this.setProcessStatusLabel("no process");
        }
    }

    public BooknotView getBKView() {
        return this.m_bkview;
    }

    public int getNumPages() {
        if (this.m_knotbook == null) {
            return 0;
        }
        return this.m_knotbook.getNumPages();
    }

    public int getNumVertices() {
        if (this.m_knotbook == null) {
            return 0;
        }
        return this.m_knotbook.getNumVertices();
    }

    public int getNumComponents() {
        if (this.m_knotbook == null) {
            return 0;
        }
        return this.m_knotbook.getNumComponents();
    }

    public void simplify() {
        if (this.m_knotbook == null) {
            this.setProcessStatusLabel("missing knot");
            return;
        }
        this.setProcessStatusLabel("Knot simplifier running...");
        ThreePageLink tpl = new ThreePageLink();
        tpl.kb_to_3P(this.m_knotbook);
        tpl.kNotSimplyFire();
        if (tpl.back_to_kb() == null) {
            this.setProcessStatusLabel("Simplifier failed");
            return;
        }
        this.m_knotbook = tpl.back_to_kb();
        this.setProcessStatusLabel("Simplifying completed");
    }

    public void permutateVertices() {
        if (this.m_knotbook == null) {
            this.setProcessStatusLabel("missing knot");
            return;
        }
        this.setProcessStatusLabel("Vertex Permutation in process");
        this.m_knotbook.permutateVertices();
        this.setProcessStatusLabel("Vertex Permutation completed");
        this.doNotFitDisplay = true;
    }

    public boolean decode(String text, String name) {
        this.setProcessStatusLabel("Decoding Knot in process");
        DecoderGC decoder = new DecoderGC();
        PgKnotBook tmp = decoder.decode(text, name);
        if (tmp != null) {
            this.m_knotbook = tmp;
            this.setProcessStatusLabel("Decoding Knot completed");
            this.init();
            return true;
        }
        this.setProcessStatusLabel("Decoding Knot failed: " + decoder.getStatus());
        return false;
    }

    public String getGCfrom3D(String data) {
        this.setProcessStatusLabel("Generating GC in process");
        PlaneParser pp = new PlaneParser(data);
        if (!pp.getDataCorrectness()) {
            this.setProcessStatusLabel("Generating GC failed, no process");
            return "";
        }
        String gc = pp.getGC();
        if (gc == null || gc == "") {
            this.setProcessStatusLabel("Generating GC failed, no process");
            return "";
        }
        return gc;
    }

    protected void setProcessStatusLabel(String text) {
        PjKnotBook_IP ip = (PjKnotBook_IP)this.getInfoPanel();
        if (ip != null) {
            ip.setProcessStatusLabel(text);
        }
    }

    public String readFile(String defDir, String defFile) {
        if (defDir == null || defDir.equals("") || defFile == null || defFile.equals("")) {
            return null;
        }
        String fileName = String.valueOf(defDir) + defFile;
        LineNumberReader in = new LineNumberReader(PsUtil.open((String)fileName));
        String text = "";
        String line = "";
        while (line != null) {
            try {
                line = in.readLine();
                text = line != null ? String.valueOf(text) + line + "\n" : text;
            }
            catch (IOException ioe) {
                this.setProcessStatusLabel("Can't read the file " + fileName);
                return null;
            }
        }
        return text;
    }

    public boolean readAndSetJKB(String defDir, String defFile) {
        if (defDir == null || defDir.equals("") || defFile == null || defFile.equals("")) {
            return false;
        }
        if (!defFile.endsWith(".jkb")) {
            return false;
        }
        PgKnotBook kb = PsJkbLoader.read(String.valueOf(defDir) + defFile);
        if (kb == null) {
            return false;
        }
        this.m_knotbook = kb;
        this.currentKnotFileName = String.valueOf(defDir) + defFile;
        this.init();
        return true;
    }

    public boolean readAndSetGC(String defDir, String defFile) {
        String gc = this.readFile(defDir, defFile);
        if (gc == null || gc.equals("")) {
            return false;
        }
        if (!defFile.endsWith(".gc")) {
            return false;
        }
        if (this.decode(gc, defFile)) {
            this.currentKnotFileName = String.valueOf(defDir) + defFile;
            this.init();
            return true;
        }
        return false;
    }

    public boolean readAndSet3D(String defDir, String defFile) {
        String coord = this.readFile(defDir, defFile);
        if (coord == null || coord.equals("")) {
            return false;
        }
        if (!defFile.endsWith(".txt")) {
            return false;
        }
        String gc = this.getGCfrom3D(coord);
        if (gc == null || gc.equals("")) {
            return false;
        }
        if (this.decode(gc, defFile)) {
            this.currentKnotFileName = String.valueOf(defDir) + defFile;
            this.init();
            return true;
        }
        return false;
    }

    protected boolean export(String text, String defDir, String defFile) {
        FileDialog dialog = new FileDialog(this.getViewer().getFrame(), "", 1);
        if (!defDir.equals("")) {
            dialog.setDirectory(defDir);
        }
        if (!defFile.equals("")) {
            dialog.setFile(defFile);
        }
        dialog.setVisible(true);
        if (dialog.getFile() == null) {
            return false;
        }
        String fileName = String.valueOf(dialog.getDirectory()) + dialog.getFile();
        PgLoader loader = new PgLoader();
        return loader.saveString(text, fileName);
    }

    protected String getSavingFileName(String defDir, String defFile) {
        FileDialog dialog = new FileDialog(this.getViewer().getFrame(), "", 1);
        if (!defDir.equals("")) {
            dialog.setDirectory(defDir);
        }
        if (!defFile.equals("")) {
            dialog.setFile(defFile);
        }
        dialog.setVisible(true);
        if (dialog.getFile() == null) {
            return null;
        }
        return String.valueOf(dialog.getDirectory()) + dialog.getFile();
    }

    public boolean exportJkb(boolean isAppletMode) {
        String data = PsJkbLoader.write(this.m_knotbook);
        String c_dir = String.valueOf(this.fileDir.substring(PsConfig.getCodeBase().length())) + "jkb/";
        c_dir = isAppletMode ? String.valueOf(c_dir) + "*.jkb" : this.getSavingFileName(c_dir.replace('/', '\\'), "*.jkb");
        PgLoader loader = new PgLoader();
        return loader.saveString(data, c_dir);
    }

    public boolean exportGk(String text, boolean isAppletMode) {
        String c_dir = String.valueOf(this.fileDir.substring(PsConfig.getCodeBase().length())) + "gc/";
        c_dir = isAppletMode ? String.valueOf(c_dir) + "*.gc" : this.getSavingFileName(c_dir.replace('/', '\\'), "*.gc");
        PgLoader loader = new PgLoader();
        return loader.saveString(text, c_dir);
    }

    public boolean export3D(String text, boolean isAppletMode) {
        String c_dir = String.valueOf(this.fileDir.substring(PsConfig.getCodeBase().length())) + "poly3D/";
        c_dir = isAppletMode ? String.valueOf(c_dir) + "*.txt" : this.getSavingFileName(c_dir.replace('/', '\\'), "*.txt");
        PgLoader loader = new PgLoader();
        return loader.saveString(text, c_dir);
    }

    public String[] selectModel(int fileEndsWith) {
        FileDialog dialog = new FileDialog(this.getViewer().getFrame(), "", 0);
        String c_dir = this.fileDir.substring(PsConfig.getCodeBase().length()).replace('/', '\\');
        String v_fileEndsWith = "";
        String v_file = "*.*";
        switch (fileEndsWith) {
            case 0: {
                break;
            }
            case 1: {
                c_dir = String.valueOf(c_dir) + "jkb\\";
                v_fileEndsWith = ".jkb";
                v_file = "*.jkb";
                break;
            }
            case 2: {
                c_dir = String.valueOf(c_dir) + "gc\\";
                v_fileEndsWith = ".gc";
                v_file = "*.gc";
                break;
            }
            case 3: {
                c_dir = String.valueOf(c_dir) + "poly3D\\";
                v_fileEndsWith = ".txt";
                v_file = "*.txt";
                break;
            }
            default: {
                return null;
            }
        }
        dialog.setDirectory(c_dir);
        dialog.setFile(v_file);
        dialog.setVisible(true);
        String[] will_return = new String[]{"", ""};
        if (dialog.getFile() == null) {
            return will_return;
        }
        will_return[0] = dialog.getDirectory();
        will_return[1] = dialog.getFile();
        if (will_return[1].endsWith(v_fileEndsWith)) {
            return will_return;
        }
        return null;
    }

    public String[] getKnotFileNames() {
        BufferedReader in2;
        String content;
        block5: {
            content = "";
            in2 = PsUtil.open((String)(String.valueOf(this.fileDir) + "/_modelList.txts"));
            if (in2 != null) break block5;
            return null;
        }
        try {
            String tmp = "";
            while (tmp != null) {
                tmp = in2.readLine();
                content = String.valueOf(content) + tmp + "\n";
            }
        }
        catch (Exception in2) {
            // empty catch block
        }
        StringTokenizer st = new StringTokenizer(content);
        int l = st.countTokens();
        String[] res = new String[l];
        int i = 0;
        while (i < l) {
            res[i] = st.nextToken();
            ++i;
        }
        return res;
    }

    private String[] parseKnotPlotPage(String html) {
        try {
            URL url = new URL(html);
            URLConnection con = url.openConnection();
            InputStream is = con.getInputStream();
            byte[] b_data = new byte[is.available()];
            is.read(b_data);
            is.close();
            String content = new String(b_data).toLowerCase();
            int baseInd = content.indexOf("<title>");
            int endInd = content.indexOf("</title>") - 1;
            baseInd = content.indexOf("for", baseInd) + 4;
            String s_fileName = content.substring(baseInd, endInd);
            content = content.substring(endInd + 7);
            baseInd = content.indexOf("<pre>") + 6;
            endInd = content.indexOf("</pre>");
            content = content.substring(baseInd, endInd);
            return new String[]{s_fileName, content};
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    protected int parseKnotPlotSite() {
        int count = 0;
        this.setProcessStatusLabel("process");
        int i = 2;
        while (i < 385) {
            String url = "http://www.pims.math.ca/knotplot/KnotServer/ms-coord/" + i + ".html";
            String[] data = this.parseKnotPlotPage(url);
            if (data != null && !data[0].equals("") && !data[1].equals("")) {
                PgGeometry[] link;
                PgLoader loader;
                data[0] = String.valueOf(this.fileDir.substring(PsConfig.getCodeBase().length()).replace('/', '\\')) + "jvx\\" + "knot-" + data[0] + ".jvx";
                PgPolygonSet pknot = JvxMaker.make(data[1]);
                if (pknot == null) {
                    PsDebug.warning((String)"  ups..");
                }
                if ((loader = new PgLoader()).saveGeometry(link = new PgGeometry[]{pknot}, data[0])) {
                    PsDebug.warning((String)("i = " + i));
                }
                this.setProcessStatusLabel("Complete " + ++count + " knots");
            }
            ++i;
        }
        this.setProcessStatusLabel("Complete all. " + count + " Knots upload.");
        return count;
    }

    protected int parseGoeritzKnots() {
        int count = 0;
        this.setProcessStatusLabel("process");
        String dir = String.valueOf(this.fileDir.substring(PsConfig.getCodeBase().length()).replace('/', '\\')) + "gcBig\\";
        String goeritz = new String();
        int m = 40;
        while (m < 300) {
            int n = 41;
            while (n < 300) {
                String gc = GoeritzMaker.make(m, n);
                if (gc == null || gc.equals("")) {
                    return count;
                }
                String _m = String.valueOf(m);
                _m = _m.length() == 1 ? "00" + _m : _m;
                _m = _m.length() == 2 ? "0" + _m : _m;
                String _n = String.valueOf(n);
                _n = _n.length() == 1 ? "00" + _n : _n;
                _n = _n.length() == 2 ? "0" + _n : _n;
                String fileName = "goeritz_" + _m + "_" + _n + ".gc";
                try {
                    PgLoader loader = new PgLoader();
                    loader.saveString(gc, String.valueOf(dir) + fileName);
                    goeritz = String.valueOf(goeritz) + fileName + "\t\n";
                    ++count;
                }
                catch (Exception e) {
                    System.out.println("process failed");
                }
                this.setProcessStatusLabel("Complete " + count + " knots");
                n += 21;
            }
            m += 19;
        }
        PgLoader loader = new PgLoader();
        loader.saveString(goeritz, String.valueOf(dir) + "_goeritzList.txts");
        this.setProcessStatusLabel("process completed, " + count + " Goeritz Knots saved.");
        return count;
    }
}

