/*
 * Decompiled with CFR 0.152.
 */
package jvApp.knotBook;

import java.awt.Color;
import jv.number.PdColor;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.project.PvGeometryIf;
import jv.vecmath.PdVector;
import jv.vecmath.PuData;
import jvApp.knotBook.PgKnotArc;

public class PgKnotBook
extends PgGeometry {
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    public static final int UNKNOWN = -1;
    public static final boolean[] BOOLEAN;
    protected int m_numVertices = 0;
    protected int m_numComponents = 0;
    protected PdVector[] m_vertex;
    protected Color[] m_vertexColor;
    protected int m_bShowVertices = -1;
    protected double m_globalVertexSize;
    protected Color m_globalVertexColor;
    protected Color m_globalVertexTagColor;
    protected int m_bShowIndices = -1;
    protected int m_numArcs;
    protected PgKnotArc[] m_arc;
    protected int[] m_components;
    protected Color[] m_arcColor;
    protected Color m_globalArcColor;
    protected int m_numPages;
    protected double[] m_pageAngle;
    protected Color[] m_pageColor;
    protected Color m_globalPageColor;

    static {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        BOOLEAN = blArray;
    }

    public PgKnotBook() {
        super(1);
        this.init();
    }

    public void init() {
        super.init();
        this.m_numComponents = 0;
        this.m_numVertices = 0;
        this.m_vertex = null;
        this.m_vertexColor = null;
        this.m_bShowVertices = -1;
        this.m_globalVertexSize = 0.0;
        this.m_globalVertexColor = null;
        this.m_globalVertexTagColor = null;
        this.m_bShowIndices = -1;
        this.m_numArcs = 0;
        this.m_arc = null;
        this.m_components = null;
        this.m_arcColor = null;
        this.m_globalArcColor = null;
        this.m_numPages = 0;
        this.m_pageAngle = null;
        this.m_pageColor = null;
        this.m_globalPageColor = null;
    }

    public void paint(PvGeometryIf dc) {
        super.paint(dc);
        dc.setState(70, false);
        dc.setState(69, false);
        dc.setGlobalVertexSize(2.0);
        dc.setGlobalVertexColor(Color.red);
        dc.setNumVertices(this.m_numVertices);
        dc.setVertices(this.m_vertex);
        if (this.m_vertexColor == null) {
            dc.setState(91, true);
        } else {
            dc.setState(91, false);
        }
        dc.setVertexColors(this.m_vertexColor);
        dc.setState(60, false);
    }

    public int getNumVertices() {
        return this.m_numVertices;
    }

    public int getNumComponents() {
        this.setComponents();
        return this.m_numComponents;
    }

    public PdVector[] getVertices() {
        return this.m_vertex;
    }

    public boolean setVertex(int anIndex, PdVector aVertex) {
        if (anIndex < 0 || anIndex > this.m_numVertices - 1) {
            PsDebug.warning((String)("index=" + anIndex + " out of range"));
            return false;
        }
        if (aVertex == null) {
            PsDebug.warning((String)"missing argument");
            return false;
        }
        this.m_vertex[anIndex].copy(aVertex);
        return true;
    }

    public void setNumVertices(int aNumVertices, int dim) {
        if (this.m_numVertices == aNumVertices) {
            return;
        }
        this.m_vertex = PdVector.realloc((PdVector[])this.m_vertex, (int)aNumVertices, (int)this.m_dim);
        if (this.m_vertexColor != null) {
            this.m_vertexColor = PdColor.realloc((Color[])this.m_vertexColor, (int)aNumVertices);
        }
        this.m_numVertices = aNumVertices;
    }

    public Color getGlobalVertexColor() {
        return this.m_globalVertexColor;
    }

    public Color getGlobalVertexTagColor() {
        return this.m_globalVertexTagColor;
    }

    public double getGlobalVertexSize() {
        return this.m_globalVertexSize;
    }

    public void setGlobalVertexColor(Color color) {
        this.m_globalVertexColor = color;
    }

    public void setGlobalVertexTagColor(Color color) {
        this.m_globalVertexTagColor = color;
    }

    public void setGlobalVertexSize(double size) {
        this.m_globalVertexSize = size;
    }

    public void setVertices(PdVector[] aVertexList) {
        if (aVertexList == null || aVertexList.length == 0 || aVertexList.length < this.m_numVertices) {
            PsDebug.warning((String)"void length of argument vertex array");
            return;
        }
        int dimSav = aVertexList[0].getSize();
        int i = 0;
        while (i < this.m_numVertices) {
            int dim = aVertexList[i].getSize();
            this.m_vertex[i].setSize(dim);
            if (dimSav != -1 && dim != dimSav) {
                dimSav = -1;
            }
            ++i;
        }
        this.m_dim = dimSav;
        PdVector.copy((PdVector[])this.m_vertex, (int)0, (PdVector[])aVertexList, (int)0, (int)this.m_numVertices);
    }

    public void assureVertexColors() {
        if (this.m_vertexColor == null || this.m_vertexColor.length != this.m_numVertices) {
            this.m_vertexColor = PdColor.realloc((Color[])this.m_vertexColor, (int)this.m_numVertices);
        }
    }

    public Color[] getVertexColors() {
        return this.m_vertexColor;
    }

    public void setVertexColors(Color[] aVertexColorList) {
        if (aVertexColorList == null || aVertexColorList.length < this.m_numVertices) {
            PsDebug.warning((String)"void length of argument array");
            return;
        }
        this.assureVertexColors();
        PdColor.copy((Color[])this.m_vertexColor, (int)0, (Color[])aVertexColorList, (int)0, (int)this.m_numVertices);
    }

    public Color getVertexColor(int anIndex) {
        if (anIndex < 0 || anIndex >= this.m_numVertices) {
            return null;
        }
        return this.m_vertexColor[anIndex];
    }

    public void setVertexColor(int anIndex, Color aVertex) {
        if (anIndex < 0 || aVertex == null) {
            PsDebug.warning((String)"index out of range, corrupt argument");
            return;
        }
        if (this.m_vertexColor == null || anIndex >= this.m_vertexColor.length) {
            this.assureVertexColors();
        }
        this.m_vertexColor[anIndex] = aVertex;
    }

    public int getNumArcs() {
        return this.m_numArcs;
    }

    public void setNumArcs(int aNumArcs) {
        if (this.m_numArcs == aNumArcs) {
            return;
        }
        int oldNumArcs = this.m_numArcs;
        this.m_numArcs = aNumArcs;
        PgKnotArc[] oldArcs = this.m_arc;
        int commonNumArcs = Math.min(oldNumArcs, this.m_numArcs);
        this.m_arc = new PgKnotArc[this.m_numArcs];
        int i = 0;
        while (i < commonNumArcs) {
            this.m_arc[i] = oldArcs[i];
            ++i;
        }
        i = commonNumArcs;
        while (i < aNumArcs) {
            this.m_arc[i] = new PgKnotArc();
            ++i;
        }
        if (this.m_arcColor != null) {
            this.m_arcColor = PdColor.realloc((Color[])this.m_arcColor, (int)this.m_numArcs);
        }
    }

    public PgKnotArc getArc(int index) {
        return this.m_arc[index];
    }

    public void setArc(int index, PgKnotArc anArc) {
        this.m_arc[index].copy(anArc);
    }

    public PgKnotArc[] getArcs() {
        return this.m_arc;
    }

    public void setArcs(PgKnotArc[] anArcArray) {
        this.setNumArcs(anArcArray.length);
        int i = 0;
        while (i < anArcArray.length) {
            this.m_arc[i].copy(anArcArray[i]);
            ++i;
        }
    }

    public Color getArcColor(int index) {
        return this.m_arcColor[index];
    }

    public void setArcColor(int index, Color aColor) {
        if (this.m_arcColor == null) {
            this.assureArcColors();
        }
        this.m_arcColor[index] = aColor;
    }

    public void assureArcColors() {
        if (this.m_arcColor == null || this.m_arcColor.length != this.m_numArcs) {
            this.m_arcColor = PdColor.realloc((Color[])this.m_arcColor, (int)this.m_numArcs);
        }
    }

    public Color[] getArcColors() {
        return this.m_arcColor;
    }

    public void setArcColors(Color[] arcColors) {
        if (arcColors == null || arcColors.length < this.m_numArcs) {
            PsDebug.warning((String)"void length of argument array");
            return;
        }
        this.assureArcColors();
        PdColor.copy((Color[])this.m_arcColor, (int)0, (Color[])arcColors, (int)0, (int)this.m_numArcs);
    }

    public Color getGlobalArcColor() {
        return this.m_globalArcColor;
    }

    public void setGlobalArcColor(Color color) {
        this.m_globalArcColor = color;
    }

    public int[] getComponents() {
        this.setComponents();
        return this.m_components;
    }

    private void setComponents() {
        this.m_components = new int[this.m_arc.length];
        int number = 0;
        int arc_index = 0;
        int lastComponent = 0;
        boolean flag = true;
        int i = 0;
        while (i < this.m_components.length) {
            this.m_components[i] = -1;
            ++i;
        }
        while (flag) {
            this.m_components[arc_index] = number;
            int index = 0;
            while (index < this.m_arc.length && this.m_arc[index].getBase() != this.m_arc[arc_index].getEnd()) {
                ++index;
            }
            arc_index = index;
            if (arc_index == this.m_components.length) {
                i = 0;
                while (i < this.m_components.length) {
                    this.m_components[i] = 0;
                    ++i;
                }
                return;
            }
            if (this.m_components[arc_index] < 0) continue;
            while (lastComponent < this.m_components.length && this.m_components[lastComponent] >= 0) {
                ++lastComponent;
            }
            arc_index = lastComponent;
            flag = arc_index != this.m_components.length;
            ++number;
        }
        this.m_numComponents = number;
    }

    public int getNumPages() {
        return this.m_numPages;
    }

    public void setNumPages(int num) {
        if (this.m_numPages == num) {
            return;
        }
        this.m_numPages = num;
        this.m_pageAngle = PuData.realloc((double[])this.m_pageAngle, (int)this.m_numPages);
        if (this.m_pageColor != null) {
            this.m_pageColor = PdColor.realloc((Color[])this.m_pageColor, (int)this.m_numPages);
        }
    }

    public double getPageAngle(int ind) {
        return this.m_pageAngle[ind];
    }

    public void setPageAngle(int ind, double angle) {
        this.m_pageAngle[ind] = angle;
    }

    public Color getPageColor(int ind) {
        return this.m_pageColor[ind];
    }

    public void setPageColor(int ind, Color aColor) {
        if (this.m_pageColor == null) {
            this.assurePageColors();
        }
        this.m_pageColor[ind] = aColor;
    }

    public Color[] getPageColors() {
        return this.m_pageColor;
    }

    public void setPageColors(Color[] pageColors) {
        if (pageColors == null || pageColors.length < this.m_numArcs) {
            PsDebug.warning((String)"void length of argument array");
            return;
        }
        this.assurePageColors();
        PdColor.copy((Color[])this.m_pageColor, (int)0, (Color[])pageColors, (int)0, (int)this.m_numPages);
    }

    public void assurePageColors() {
        if (this.m_pageColor == null || this.m_pageColor.length != this.m_numPages) {
            this.m_pageColor = PdColor.realloc((Color[])this.m_pageColor, (int)this.m_numPages);
        }
    }

    public void setGlobalPageColor(Color color) {
        this.m_globalPageColor = color;
    }

    public Color getGlobalPageColor() {
        return this.m_globalPageColor;
    }

    public int isShowingIndices() {
        return this.m_bShowIndices;
    }

    public int isShowingVertices() {
        return this.m_bShowVertices;
    }

    public void showIndices(int flag) {
        this.m_bShowIndices = flag;
    }

    public void showVertices(int flag) {
        this.m_bShowVertices = flag;
    }

    public void permutateVertices() {
        double i_entry;
        if (this.m_numVertices == 0) {
            return;
        }
        double max = i_entry = this.m_vertex[0].getEntry(0);
        double min = i_entry;
        int minInd = 0;
        int i = 0;
        while (i < this.m_numVertices) {
            i_entry = this.m_vertex[i].getEntry(0);
            if (max < i_entry) {
                max = i_entry;
            }
            if (min > i_entry) {
                min = i_entry;
                minInd = i;
            }
            this.m_vertex[i].setEntry(0, i_entry - 1.0);
            ++i;
        }
        this.m_vertex[minInd].setEntry(0, max);
    }
}

