/*
 * Decompiled with CFR 0.152.
 */
package jvApp.knotBook;

import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import jv.vecmath.PdVector;
import jvApp.knotBook.PgKnotArc;
import jvApp.knotBook.PgKnotBook;

public class DecoderGC {
    private Vector s_data = new Vector();
    private Hashtable m_planeKnot;
    private String status = "ok";
    Vector t_point = new Vector();
    Vector s_point = new Vector();
    Vector rel_s_point = new Vector();
    Vector deleted = new Vector();

    public PgKnotBook decode(String text, String name) {
        if (text.equals("Trivial Knot")) {
            return this.makeKnotBook("Trivial Knot");
        }
        String elementSeparator = "component";
        String element = text = text.toLowerCase();
        boolean isInputRight = true;
        int allCrossingsLength = 0;
        while (element.length() != 0) {
            int indexOfNewElement;
            int indexSeparator = element.indexOf(elementSeparator);
            if (indexSeparator == -1) {
                indexSeparator = element.length();
            }
            if (!(element = element.substring(0, indexSeparator)).equals("")) {
                StringTokenizer st_element = new StringTokenizer(element, " \t\n");
                int cross_num = st_element.countTokens();
                String[][] crossings = new String[cross_num][3];
                int i = 0;
                while (i < cross_num) {
                    String tmp = st_element.nextToken();
                    if (tmp.length() < 3) {
                        this.status = "incorrect data format";
                        return null;
                    }
                    crossings[i][0] = tmp.substring(0, 1);
                    crossings[i][1] = tmp.substring(1, 2);
                    crossings[i][2] = tmp.substring(2);
                    ++i;
                }
                allCrossingsLength += crossings.length;
                this.s_data.addElement(crossings);
            }
            text = (indexOfNewElement = text.indexOf("\n", indexSeparator)) > 0 ? text.substring(indexOfNewElement) : "";
            element = text;
        }
        isInputRight = this.checkInputData(allCrossingsLength);
        if (!isInputRight) {
            this.status = "incorrect gauss code";
            return null;
        }
        this.m_planeKnot = this.makePlaneRepresentation();
        boolean bl = isInputRight = isInputRight && this.checkPlaneRepresentation(this.m_planeKnot);
        if (!isInputRight) {
            return null;
        }
        return this.makeKnotBook(name);
    }

    private boolean checkInputData(int allCrossingsLength) {
        int sum_num_cross = 0;
        int s_size = this.s_data.size();
        int crossings_length = 0;
        String[][] data = new String[allCrossingsLength][3];
        int k = 0;
        while (k < s_size) {
            String[][] t_data = (String[][])this.s_data.elementAt(k);
            int i = 0;
            while (i < t_data.length) {
                data[i + crossings_length] = (String[])t_data[i].clone();
                ++i;
            }
            crossings_length += t_data.length;
            ++k;
        }
        int i = 0;
        while (i < data.length) {
            int cross_num = 0;
            if (!data[i][0].equals("+") && !data[i][0].equals("-")) {
                return false;
            }
            if (!data[i][1].equals(">") && !data[i][1].equals("<")) {
                return false;
            }
            int j = i + 1;
            while (j < data.length) {
                if (data[i][2].equals(data[j][2])) {
                    if (data[i][0].equals(data[j][0]) || data[i][1].equals(data[j][1])) {
                        return false;
                    }
                    if (++cross_num > 1) {
                        return false;
                    }
                }
                ++j;
            }
            sum_num_cross += cross_num;
            ++i;
        }
        return 2 * sum_num_cross == crossings_length;
    }

    private Hashtable makePlaneRepresentation() {
        Hashtable<String, String[]> planeKnot = new Hashtable<String, String[]>();
        int element_num = this.s_data.size();
        int j = 0;
        while (j < element_num) {
            String[][] element = (String[][])this.s_data.elementAt(j);
            int cross_num = element.length;
            String[] prev_cross = new String[12];
            prev_cross[0] = element[cross_num - 1][2];
            int i = 0;
            while (i < cross_num) {
                int next = i + 1;
                if (i == cross_num - 1) {
                    next = 0;
                }
                String[] cross = (String[])planeKnot.get(element[i][2]);
                String[] next_cross = (String[])planeKnot.get(element[next][2]);
                if (cross == null) {
                    cross = new String[12];
                    cross[0] = element[i][2];
                }
                if (next_cross == null) {
                    next_cross = new String[12];
                    next_cross[0] = element[next][2];
                }
                if (element[i][1].equals("<")) {
                    if (element[next][1].equals("<")) {
                        cross[3] = "4";
                        cross[4] = element[next][2];
                        next_cross[7] = "2";
                        next_cross[8] = element[i][2];
                    } else {
                        cross[3] = "1";
                        cross[4] = element[next][2];
                        next_cross[1] = "2";
                        next_cross[2] = element[i][2];
                    }
                    cross[11] = "4";
                } else {
                    if (element[next][1].equals("<")) {
                        cross[5] = "4";
                        cross[6] = element[next][2];
                        next_cross[7] = "3";
                        next_cross[8] = element[i][2];
                    } else {
                        cross[5] = "1";
                        cross[6] = element[next][2];
                        next_cross[1] = "3";
                        next_cross[2] = element[i][2];
                    }
                    cross[11] = "1";
                }
                cross[9] = element[i][0];
                cross[10] = element[i][1];
                if (next_cross[0].equals(cross[0])) {
                    int ii = 0;
                    while (ii < cross.length) {
                        if (cross[ii] != null) {
                            next_cross[ii] = cross[ii];
                        }
                        ++ii;
                    }
                }
                planeKnot.put(cross[0], cross);
                planeKnot.put(next_cross[0], next_cross);
                prev_cross = cross;
                ++i;
            }
            ++j;
        }
        return planeKnot;
    }

    private boolean checkPlaneRepresentation(Hashtable planeKnot) {
        int loops_num = 0;
        int allCross_num = 0;
        Hashtable<String, byte[]> loops = new Hashtable<String, byte[]>();
        int element_num = this.s_data.size();
        int j = 0;
        while (j < element_num) {
            String[][] crosses = (String[][])this.s_data.elementAt(j);
            int cross_num = crosses.length;
            allCross_num += cross_num;
            int i = 0;
            while (i < cross_num) {
                String currentCross = crosses[i][2];
                int k = 0;
                while (k < 4) {
                    byte[] loop;
                    int c_point = k + 1;
                    while (true) {
                        if ((loop = (byte[])loops.get(currentCross)) != null) {
                            if (loop[c_point] > 0) break;
                            if (currentCross.equals(crosses[i][2]) && k + 1 == c_point) {
                                ++loops_num;
                            }
                            loop[c_point] = 1;
                        } else {
                            if (currentCross.equals(crosses[i][2]) && k + 1 == c_point) {
                                ++loops_num;
                            }
                            loop = new byte[5];
                            loop[c_point] = 1;
                        }
                        loops.put(currentCross, loop);
                        String nextCrossName = ((String[])planeKnot.get(currentCross))[2 * c_point];
                        c_point = this.getLoopsIndex(String.valueOf(c_point), ((String[])planeKnot.get(currentCross))[2 * c_point - 1], c_point);
                        if (c_point == -1) {
                            System.out.println("Error in check planar representation");
                            return false;
                        }
                        currentCross = nextCrossName;
                    }
                    int n = c_point;
                    loop[n] = (byte)(loop[n] + 1);
                    ++k;
                }
                ++i;
            }
            ++j;
        }
        double g = 0.5 * (0.5 * (double)allCross_num - (double)loops_num) + 1.0;
        if (g == 0.0) {
            return true;
        }
        this.status = "genus " + g;
        return false;
    }

    private byte getLoopsIndex(String hvost_one, String hvost_two, int i) {
        if (hvost_one.equals(hvost_two)) {
            return -1;
        }
        if (hvost_one.equals("1") && hvost_two.equals("2") || hvost_one.equals("2") && hvost_two.equals("1")) {
            if (i == 1) {
                return 3;
            }
            if (i == 3) {
                return 1;
            }
            if (i == 2) {
                return 2;
            }
        }
        if (hvost_one.equals("1") && hvost_two.equals("3") || hvost_one.equals("3") && hvost_two.equals("1")) {
            if (i == 2) {
                return 3;
            }
            if (i == 3) {
                return 2;
            }
            if (i == 1) {
                return 4;
            }
            if (i == 4) {
                return 1;
            }
        }
        if (hvost_one.equals("1") && hvost_two.equals("4") || hvost_one.equals("4") && hvost_two.equals("1")) {
            if (i == 1) {
                return 1;
            }
            if (i == 2) {
                return 4;
            }
            if (i == 4) {
                return 2;
            }
        }
        if (hvost_one.equals("2") && hvost_two.equals("3") || hvost_one.equals("3") && hvost_two.equals("2")) {
            if (i == 2) {
                return 4;
            }
            if (i == 4) {
                return 2;
            }
            if (i == 3) {
                return 3;
            }
        }
        if (hvost_one.equals("2") && hvost_two.equals("4") || hvost_one.equals("4") && hvost_two.equals("2")) {
            if (i == 1) {
                return 2;
            }
            if (i == 2) {
                return 1;
            }
            if (i == 3) {
                return 4;
            }
            if (i == 4) {
                return 3;
            }
        }
        if (hvost_one.equals("3") && hvost_two.equals("4") || hvost_one.equals("4") && hvost_two.equals("3")) {
            if (i == 1) {
                return 3;
            }
            if (i == 3) {
                return 1;
            }
            if (i == 4) {
                return 4;
            }
        }
        return -1;
    }

    private PgKnotBook makeKnotBook(String name) {
        if (name.equals("Trivial Knot")) {
            return this.doReversePlanerTranslate(name);
        }
        int currentIndex = 0;
        int element_num = this.s_data.size();
        int j = 0;
        while (j < element_num) {
            currentIndex = this.intitialisation((String[][])this.s_data.elementAt(j));
            if (currentIndex == 1) break;
            ++j;
        }
        if (currentIndex == -1) {
            this.status = "can't intialize translation";
            System.out.println("Initialisatin faled");
            return null;
        }
        while (true) {
            boolean step1conditional;
            String c_name = (String)this.s_point.elementAt(currentIndex);
            String[] crossing = (String[])this.m_planeKnot.get(c_name);
            int[] c_point = (int[])this.t_point.elementAt(currentIndex);
            boolean step2conditional = crossing[9].equals("-") && crossing[11].equals(this.rel_s_point.elementAt(currentIndex)) && c_point[6] == 2 || crossing[9].equals("+") && !crossing[11].equals(this.rel_s_point.elementAt(currentIndex)) && c_point[6] == 2;
            boolean step3conditional = crossing[9].equals("-") && crossing[11].equals(this.rel_s_point.elementAt(currentIndex)) && c_point[6] == 1 || crossing[9].equals("+") && !crossing[11].equals(this.rel_s_point.elementAt(currentIndex)) && c_point[6] == 1;
            boolean step4conditional = crossing[9].equals("+") && crossing[11].equals(this.rel_s_point.elementAt(currentIndex)) && c_point[6] == 1 || crossing[9].equals("-") && !crossing[11].equals(this.rel_s_point.elementAt(currentIndex)) && c_point[6] == 1;
            boolean step5conditional = crossing[9].equals("+") && crossing[11].equals(this.rel_s_point.elementAt(currentIndex)) && c_point[6] == 2 || crossing[9].equals("-") && !crossing[11].equals(this.rel_s_point.elementAt(currentIndex)) && c_point[6] == 2;
            boolean bl = step1conditional = this.deleted.contains(c_name) || c_point[6] == 0;
            if (step1conditional) {
                if ((currentIndex = this.step1(currentIndex)) == -1) break;
                continue;
            }
            if (step2conditional) {
                currentIndex = this.step2(currentIndex);
                continue;
            }
            if (step3conditional) {
                currentIndex = this.step3(currentIndex);
                continue;
            }
            if (step4conditional) {
                currentIndex = this.step4(currentIndex);
                continue;
            }
            if (!step5conditional) continue;
            currentIndex = this.step5(currentIndex);
        }
        return this.doReversePlanerTranslate(name);
    }

    private int step1(int currentIndex) {
        int[] c_point = (int[])this.t_point.elementAt(currentIndex);
        return c_point[1];
    }

    private int step2(int currentIndex) {
        return this.step24(currentIndex, 1);
    }

    private int step4(int currentIndex) {
        return this.step24(currentIndex, 2);
    }

    private int step3(int currentIndex) {
        return this.step35(currentIndex, 1);
    }

    private int step5(int currentIndex) {
        return this.step35(currentIndex, 2);
    }

    private int step35(int currentIndex, int page) {
        int i_page = -1;
        if (page == 1) {
            i_page = 2;
        }
        if (page == 2) {
            i_page = 1;
        }
        int lastIndex = this.t_point.size() - 1;
        int[] c_point = (int[])this.t_point.elementAt(currentIndex);
        int[] lll_point = (int[])this.t_point.elementAt(c_point[2]);
        lll_point[4] = lastIndex + 1;
        this.t_point.setElementAt(lll_point, c_point[2]);
        if (c_point[2] != -1) {
            int[] l_point = (int[])c_point.clone();
            int[] ll_point = (int[])this.t_point.elementAt(c_point[0]);
            ll_point[1] = lastIndex + 1;
            this.t_point.setElementAt(ll_point, c_point[0]);
            l_point[1] = currentIndex;
            l_point[4] = currentIndex;
            l_point[5] = i_page;
            this.t_point.addElement(l_point);
            c_point[0] = lastIndex + 1;
        } else if (c_point[4] != -1) {
            int[] r_point = (int[])c_point.clone();
            int[] rr_point = (int[])this.t_point.elementAt(c_point[1]);
            rr_point[0] = lastIndex + 1;
            this.t_point.setElementAt(rr_point, c_point[1]);
            r_point[0] = currentIndex;
            r_point[2] = currentIndex;
            r_point[3] = i_page;
            this.t_point.addElement(r_point);
            c_point[1] = lastIndex + 1;
        }
        c_point[2] = lastIndex + 1;
        c_point[3] = i_page;
        c_point[6] = i_page;
        this.t_point.setElementAt(c_point, currentIndex);
        this.s_point.addElement("");
        this.rel_s_point.addElement("-1");
        return this.step24(currentIndex, page);
    }

    private int step24(int currentIndex, int page) {
        int[] t_cross;
        int k;
        int length;
        int rel_index;
        int[] c_point = (int[])this.t_point.elementAt(currentIndex);
        String c_name = (String)this.s_point.elementAt(currentIndex);
        String[] crossing = (String[])this.m_planeKnot.get(c_name);
        int lastIndex = this.t_point.size() - 1;
        int[] ll_point = (int[])this.t_point.elementAt(c_point[0]);
        if (c_point[1] != -1) {
            int[] rr_point = (int[])this.t_point.elementAt(c_point[1]);
            rr_point[0] = lastIndex + 2;
            this.t_point.setElementAt(rr_point, c_point[1]);
        }
        ll_point[1] = lastIndex + 1;
        this.t_point.setElementAt(ll_point, c_point[0]);
        int[] l_point = new int[]{c_point[0], currentIndex, -1, -1, -1, -1, -1};
        int[] nArray = new int[7];
        nArray[0] = currentIndex;
        nArray[1] = c_point[1];
        nArray[2] = -1;
        nArray[3] = -1;
        nArray[4] = -1;
        nArray[6] = -1;
        int[] r_point = nArray;
        c_point[0] = lastIndex + 1;
        c_point[1] = lastIndex + 2;
        int i86 = 8;
        int i42 = 4;
        int i64 = 6;
        boolean flag = true;
        if (((String)this.rel_s_point.elementAt(currentIndex)).equals("1")) {
            l_point[6] = 0;
            r_point[6] = page;
            l_point[3] = 0;
            l_point[4] = lastIndex + 2;
            l_point[5] = page;
            r_point[2] = lastIndex + 1;
            r_point[3] = page;
            r_point[5] = 0;
        }
        if (((String)this.rel_s_point.elementAt(currentIndex)).equals("4")) {
            flag = false;
            l_point[6] = page;
            r_point[6] = 0;
            i86 = 6;
            i42 = 2;
            i64 = 4;
            l_point[2] = lastIndex + 2;
            l_point[3] = page;
            l_point[5] = 0;
            r_point[3] = 0;
            r_point[4] = lastIndex + 1;
            r_point[5] = page;
        }
        if (this.deleted.contains(crossing[i86]) || c_name.equals(crossing[i86])) {
            rel_index = i86 / 2;
            length = this.t_point.size();
            k = 0;
            while (k < length) {
                if (((String)this.s_point.elementAt(k)).equals(crossing[0]) && ((String)this.rel_s_point.elementAt(k)).equals(String.valueOf(rel_index))) {
                    t_cross = (int[])this.t_point.elementAt(k);
                    if (flag) {
                        l_point[2] = k;
                        t_cross[4] = lastIndex + 1;
                        t_cross[5] = 0;
                    } else {
                        l_point[4] = k;
                        t_cross[2] = lastIndex + 1;
                        t_cross[3] = 0;
                    }
                    this.t_point.setElementAt(t_cross, k);
                }
                ++k;
            }
        }
        if (this.deleted.contains(crossing[i42]) || c_name.equals(crossing[i42])) {
            rel_index = i42 / 2;
            length = this.t_point.size();
            k = 0;
            while (k < length) {
                if (((String)this.s_point.elementAt(k)).equals(crossing[0]) && ((String)this.rel_s_point.elementAt(k)).equals(String.valueOf(rel_index))) {
                    t_cross = (int[])this.t_point.elementAt(k);
                    if (flag) {
                        r_point[4] = k;
                        t_cross[2] = lastIndex + 2;
                        t_cross[3] = 0;
                    } else {
                        r_point[2] = k;
                        t_cross[4] = lastIndex + 2;
                        t_cross[5] = 0;
                    }
                    this.t_point.setElementAt(t_cross, k);
                }
                ++k;
            }
        }
        this.t_point.addElement(l_point);
        this.t_point.addElement(r_point);
        this.s_point.addElement(crossing[i86]);
        this.s_point.addElement(crossing[i42]);
        this.rel_s_point.addElement(crossing[i86 - 1]);
        this.rel_s_point.addElement(crossing[i42 - 1]);
        if (!this.deleted.contains(crossing[i64]) && !c_name.equals(crossing[i64])) {
            this.s_point.setElementAt(crossing[i64], currentIndex);
            this.rel_s_point.setElementAt(crossing[i64 - 1], currentIndex);
        } else {
            rel_index = i64 / 2;
            length = this.t_point.size();
            k = 0;
            while (k < length) {
                if (((String)this.s_point.elementAt(k)).equals(crossing[0]) && ((String)this.rel_s_point.elementAt(k)).equals(String.valueOf(rel_index))) {
                    t_cross = (int[])this.t_point.elementAt(k);
                    t_cross[2] = currentIndex;
                    t_cross[3] = 0;
                    this.t_point.setElementAt(t_cross, k);
                    c_point[4] = k;
                    c_point[5] = 0;
                }
                ++k;
            }
        }
        this.t_point.setElementAt(c_point, currentIndex);
        this.deleted.addElement(c_name);
        return lastIndex + 1;
    }

    private int intitialisation(String[][] crossings) {
        int[] nArray = new int[7];
        nArray[1] = -1;
        nArray[3] = 1;
        nArray[4] = -1;
        nArray[6] = 1;
        int[] i_right = nArray;
        int[] nArray2 = new int[7];
        nArray2[0] = -1;
        nArray2[1] = 1;
        nArray2[2] = -1;
        nArray2[4] = 1;
        nArray2[5] = 1;
        int[] i_left = nArray2;
        this.t_point.addElement(i_left);
        this.t_point.addElement(i_right);
        int length = crossings.length;
        int i = 0;
        while (i < length) {
            String r2;
            String r3;
            String r4;
            String[] rc;
            String r1;
            String[] lc = (String[])this.m_planeKnot.get(crossings[i][2]);
            String l_name = lc[0];
            String l1 = lc[2];
            String l2 = lc[4];
            String l3 = lc[6];
            String l4 = lc[8];
            if (l2.equals(l3) && (r1 = (rc = (String[])this.m_planeKnot.get(l3))[2]).equals(r4 = rc[8]) && r1.equals(l_name)) {
                this.s_point.addElement(r1);
                this.rel_s_point.addElement("2");
                this.s_point.addElement(l2);
                this.rel_s_point.addElement("1");
                return 1;
            }
            if (l3.equals(l4) && (r3 = (rc = (String[])this.m_planeKnot.get(l3))[6]).equals(r4 = rc[8]) && r3.equals(l_name)) {
                this.s_point.addElement(r4);
                this.rel_s_point.addElement("3");
                this.s_point.addElement(l3);
                this.rel_s_point.addElement("4");
                return 1;
            }
            if (l2.equals(l1) && (r1 = (rc = (String[])this.m_planeKnot.get(l2))[2]).equals(r2 = rc[4]) && r1.equals(l_name)) {
                this.s_point.addElement(r1);
                this.rel_s_point.addElement("2");
                this.s_point.addElement(l2);
                this.rel_s_point.addElement("1");
                return 1;
            }
            ++i;
        }
        return -1;
    }

    private PgKnotBook doReversePlanerTranslate(String name) {
        PgKnotArc t_arc;
        int[] c_point;
        PgKnotBook geom = new PgKnotBook();
        geom.setName(name);
        geom.setNumPages(3);
        if (name.equals("Trivial Knot")) {
            geom.setNumVertices(2, 1);
            geom.setNumArcs(2);
            PdVector vert = new PdVector(0.0);
            geom.setVertex(0, vert);
            vert = new PdVector(1.0);
            geom.setVertex(1, vert);
            PgKnotArc t_arc2 = new PgKnotArc();
            t_arc2.setBase(0);
            t_arc2.setEnd(1);
            t_arc2.setPage(0);
            geom.setArc(0, t_arc2);
            t_arc2 = new PgKnotArc();
            t_arc2.setBase(1);
            t_arc2.setEnd(0);
            t_arc2.setPage(1);
            geom.setArc(1, t_arc2);
            return geom;
        }
        int t_numPoints = this.t_point.size();
        double t_dim = 1.0;
        geom.setNumVertices(t_numPoints, 1);
        PdVector[] t_vert = new PdVector[t_numPoints];
        Vector<PgKnotArc> v_vect = new Vector<PgKnotArc>();
        int c_index = 0;
        int pointsCounter = 0;
        int[] indexHash = new int[t_numPoints];
        int[] indexReverseHash = new int[t_numPoints];
        do {
            c_point = (int[])this.t_point.elementAt(c_index);
            indexHash[pointsCounter] = c_index;
            indexReverseHash[c_index] = pointsCounter++;
        } while ((c_index = c_point[1]) != -1);
        int i = 0;
        while (i < t_numPoints) {
            t_vert[i] = new PdVector((double)i * t_dim);
            int[] c_point2 = (int[])this.t_point.elementAt(indexHash[i]);
            t_arc = new PgKnotArc();
            t_arc.setBase(i);
            t_arc.setEnd(indexReverseHash[c_point2[4]]);
            t_arc.setPage(c_point2[5]);
            v_vect.addElement(t_arc);
            ++i;
        }
        geom.setVertices(t_vert);
        int t_numarcs = v_vect.size();
        geom.setNumArcs(t_numarcs);
        int i2 = 0;
        while (i2 < t_numarcs) {
            t_arc = (PgKnotArc)v_vect.elementAt(i2);
            geom.setArc(i2, t_arc);
            ++i2;
        }
        return geom;
    }

    public String getStatus() {
        return this.status;
    }
}

