/*
 * Decompiled with CFR 0.152.
 */
package jvApp.knotBook;

import java.awt.Color;
import jv.geom.PgElementSet;
import jv.geom.PgPolygonSet;
import jv.number.PdColor;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvApp.knotBook.PgKnotArc;
import jvApp.knotBook.PgKnotBook;

public class BooknotView {
    private int iNumPages = 3;
    private int m_ipageUp = 0;
    private int m_ipageDown = 2;
    private int dimCircl = 10;
    private double[] dPageAngle;
    private double[] dPageCos;
    private double[] dPageSin;
    private double[] dCircleCos;
    private double[] dCircleSin;

    private void preparingView(PgKnotBook kb) {
        this.iNumPages = kb.getNumPages();
        this.dPageAngle = new double[this.iNumPages];
        this.dPageCos = new double[this.iNumPages];
        this.dPageSin = new double[this.iNumPages];
        this.dCircleCos = new double[this.dimCircl + 1];
        this.dCircleSin = new double[this.dimCircl + 1];
        int i = 0;
        while (i < this.iNumPages) {
            this.dPageAngle[i] = Math.PI * 2 * (double)i / (double)this.iNumPages;
            this.dPageCos[i] = Math.cos(this.dPageAngle[i]);
            this.dPageSin[i] = Math.sin(this.dPageAngle[i]);
            ++i;
        }
        i = 0;
        while (i <= this.dimCircl) {
            this.dCircleCos[i] = Math.cos((double)i * Math.PI / (double)this.dimCircl);
            this.dCircleSin[i] = Math.sin((double)i * Math.PI / (double)this.dimCircl);
            ++i;
        }
    }

    protected void set2DArc(PgKnotBook kb, PgPolygonSet knot, PgKnotArc cArc, Color aColor, int arcInd) {
        int indArcBase = (this.dimCircl + 1) * arcInd;
        double base = kb.getVertices()[cArc.getBase()].getEntry(0);
        double end = kb.getVertices()[cArc.getEnd()].getEntry(0);
        double dDistance = (end - base) / 2.0;
        int isign = cArc.getPage() == this.m_ipageUp ? 1 : -1;
        double dRadius = Math.abs(dDistance) * (double)isign;
        double dCenter = base + dDistance;
        int i = 0;
        while (i <= this.dimCircl) {
            knot.setVertex(indArcBase + i, dCenter - this.dCircleCos[i] * dDistance, this.dCircleSin[i] * dRadius, 0.0);
            ++i;
        }
        int[] pre_arc = new int[this.dimCircl + 1];
        int i2 = 0;
        while (i2 <= this.dimCircl) {
            pre_arc[i2] = indArcBase + i2;
            ++i2;
        }
        PiVector v_arc = new PiVector(pre_arc);
        knot.setPolygon(arcInd, v_arc);
        knot.setPolygonColor(arcInd, aColor);
    }

    public void compute2DView(PgKnotBook kb, PgPolygonSet knot, PgElementSet pages) {
        if (kb == null || knot == null || pages == null) {
            PsDebug.warning((String)"in BooknotView.compute2DView(..) some parameter = null");
            return;
        }
        this.iNumPages = kb.getNumPages();
        pages.setNumVertices(6);
        pages.setNumElements(2);
        this.preparingView(kb);
        double[] maxmin = this.getMaxMinCoord(kb);
        double dStart = maxmin[0] - 1.0;
        double dEnd = maxmin[1] + 1.0;
        double dRadius = Math.abs(dEnd - dStart) * 0.5;
        pages.setVertex(0, dStart, 0.0, 0.0);
        pages.setVertex(1, dEnd, 0.0, 0.0);
        pages.setVertex(2, dStart, dRadius, 0.0);
        pages.setVertex(3, dEnd, dRadius, 0.0);
        pages.setVertex(4, dStart, -dRadius, 0.0);
        pages.setVertex(5, dEnd, -dRadius, 0.0);
        PiVector pUp = new PiVector(0, 2, 3, 1);
        PiVector pDown = new PiVector(0, 4, 5, 1);
        pages.setElement(0, pUp);
        if (this.m_ipageUp != this.m_ipageDown) {
            pages.setElement(1, pDown);
        }
        pages.makeVertexNormals();
        pages.makeNeighbour();
        pages.showEdges(true);
        pages.showVertices(true);
        PgKnotArc[] arcs = kb.getArcs();
        int iArcNum = kb.getNumArcs();
        int iVisArcNum = 0;
        int i = 0;
        while (i < iArcNum) {
            if (arcs[i].getPage() == this.m_ipageUp || arcs[i].getPage() == this.m_ipageDown) {
                ++iVisArcNum;
            }
            ++i;
        }
        knot.setNumVertices(iVisArcNum * (this.dimCircl + 1));
        knot.setNumPolygons(iVisArcNum);
        int[] components = kb.getComponents();
        int numComp = kb.getNumComponents();
        Color[] compColor = new Color[numComp];
        int i2 = 0;
        while (i2 < numComp) {
            compColor[i2] = PdColor.hsv2rgb((int)((int)((double)i2 * 255.0 / (double)numComp)), (int)255, (int)255);
            ++i2;
        }
        int arcInd = 0;
        int i3 = 0;
        while (i3 < iArcNum) {
            PgKnotArc cArc = arcs[i3];
            int iArcPage = cArc.getPage();
            if (iArcPage == this.m_ipageUp || iArcPage == this.m_ipageDown) {
                this.set2DArc(kb, knot, cArc, compColor[components[i3]], arcInd);
                ++arcInd;
            }
            ++i3;
        }
        knot.update((Object)knot);
        pages.update((Object)pages);
    }

    protected void setFreeArc(PgKnotBook kb, PgPolygonSet knot, PgKnotArc cArc, PgKnotArc cPreArc, PgKnotArc cNextArc, Color aColor) {
        double vecLen;
        double dZ;
        double dY;
        int cPage = cArc.getPage();
        int cPrePage = cPreArc.getPage();
        int cNextPage = cNextArc.getPage();
        int indArc = cArc.getBase();
        int indArcBase = this.dimCircl * indArc;
        int indArcEnd = this.dimCircl * cArc.getEnd();
        double Base = kb.getVertices()[cArc.getBase()].getEntry(0);
        double dDistance = (kb.getVertices()[cArc.getEnd()].getEntry(0) - Base) / 2.0;
        double dAbsDistance = Math.abs(dDistance);
        double dCenter = Base + dDistance;
        double dPreDistance = Math.abs(Base - kb.getVertices()[cPreArc.getBase()].getEntry(0)) / 2.0;
        double dNextDistance = Math.abs(Base + 2.0 * dDistance - kb.getVertices()[cNextArc.getEnd()].getEntry(0)) / 2.0;
        int arcCenter = this.dimCircl / 2;
        double uY = -this.dPageCos[3 - (cPage + cPrePage)];
        double uZ = -this.dPageSin[3 - (cPage + cPrePage)];
        double y0 = 2.0 * dAbsDistance * uY;
        double z0 = 2.0 * dAbsDistance * uZ;
        double c = (dAbsDistance - dPreDistance) / dPreDistance;
        double aY = c * -this.dPageSin[cPage] / (-this.dPageSin[cPage] * this.dPageCos[cPrePage] + this.dPageCos[cPage] * this.dPageSin[cPrePage]);
        double aZ = c * this.dPageCos[cPage] / (-this.dPageSin[cPage] * this.dPageCos[cPrePage] + this.dPageCos[cPage] * this.dPageSin[cPrePage]);
        int i = 0;
        while (i < arcCenter) {
            dY = this.dCircleSin[i] * this.dPageCos[cPage] * dAbsDistance;
            dZ = this.dCircleSin[i] * this.dPageSin[cPage] * dAbsDistance;
            vecLen = this.computeSqrt((1.0 + aY * this.dPageCos[cPrePage]) * uY + aZ * this.dPageCos[cPrePage] * uZ, (1.0 + aY * this.dPageCos[cPrePage]) * dY + aZ * this.dPageCos[cPrePage] * dZ - y0, aY * this.dPageSin[cPrePage] * uY + (1.0 + aZ * this.dPageSin[cPrePage]) * uZ, aY * this.dPageSin[cPrePage] * dY + (1.0 + aZ * this.dPageSin[cPrePage]) * dZ - z0, 3.0 * dAbsDistance * dAbsDistance);
            knot.setVertex(indArcBase + i, dCenter - this.dCircleCos[i] * dDistance, dY += vecLen * uY, dZ += vecLen * uZ);
            ++i;
        }
        uY = -this.dPageCos[3 - (cPage + cNextPage)];
        uZ = -this.dPageSin[3 - (cPage + cNextPage)];
        y0 = 2.0 * dAbsDistance * uY;
        z0 = 2.0 * dAbsDistance * uZ;
        c = (dAbsDistance - dNextDistance) / dNextDistance;
        aY = c * -this.dPageSin[cPage] / (-this.dPageSin[cPage] * this.dPageCos[cNextPage] + this.dPageCos[cPage] * this.dPageSin[cNextPage]);
        aZ = c * this.dPageCos[cPage] / (-this.dPageSin[cPage] * this.dPageCos[cNextPage] + this.dPageCos[cPage] * this.dPageSin[cNextPage]);
        i = arcCenter;
        while (i < this.dimCircl) {
            dY = this.dCircleSin[i] * this.dPageCos[cPage] * dAbsDistance;
            dZ = this.dCircleSin[i] * this.dPageSin[cPage] * dAbsDistance;
            vecLen = this.computeSqrt((1.0 + aY * this.dPageCos[cNextPage]) * uY + aZ * this.dPageCos[cNextPage] * uZ, (1.0 + aY * this.dPageCos[cNextPage]) * dY + aZ * this.dPageCos[cNextPage] * dZ - y0, aY * this.dPageSin[cNextPage] * uY + (1.0 + aZ * this.dPageSin[cNextPage]) * uZ, aY * this.dPageSin[cNextPage] * dY + (1.0 + aZ * this.dPageSin[cNextPage]) * dZ - z0, 3.0 * dAbsDistance * dAbsDistance);
            knot.setVertex(indArcBase + i, dCenter - this.dCircleCos[i] * dDistance, dY += vecLen * uY, dZ += vecLen * uZ);
            ++i;
        }
        int[] pre_arc = new int[this.dimCircl + 1];
        int i2 = 0;
        while (i2 < this.dimCircl) {
            pre_arc[i2] = indArcBase + i2;
            ++i2;
        }
        pre_arc[this.dimCircl] = indArcEnd;
        PiVector v_arc = new PiVector(pre_arc);
        knot.setPolygon(indArc, v_arc);
        knot.setPolygonColor(indArc, aColor);
    }

    private double computeSqrt(double a1, double a2, double b1, double b2, double c1) {
        double x2;
        double b = a1 * a2 + b1 * b2;
        double a = a1 * a1 + b1 * b1;
        double c = a2 * a2 + b2 * b2 - c1;
        double det = b * b - a * c;
        if (det < 0.0) {
            PsDebug.warning((String)"Computing of the knot arcs failed.");
            return 0.0;
        }
        double x1 = (-b - Math.sqrt(det)) / a;
        x1 = Math.min(x1, x2 = (-b + Math.sqrt(det)) / a) >= 0.0 ? Math.min(x1, x2) : 0.0;
        return x1;
    }

    protected void set3DArc(PgKnotBook kb, PgPolygonSet knot, PgKnotArc cArc, Color aColor) {
        int cPage = cArc.getPage();
        int indArc = cArc.getBase();
        int indArcBase = this.dimCircl * indArc;
        int indArcEnd = this.dimCircl * cArc.getEnd();
        double Base = kb.getVertices()[cArc.getBase()].getEntry(0);
        double dDistance = (kb.getVertices()[cArc.getEnd()].getEntry(0) - Base) / 2.0;
        double dAbsDistance = Math.abs(dDistance);
        double dCenter = Base + dDistance;
        knot.setVertex(indArcBase, Base, 0.0, 0.0);
        int i = 1;
        while (i < this.dimCircl) {
            knot.setVertex(indArcBase + i, dCenter - this.dCircleCos[i] * dDistance, this.dCircleSin[i] * this.dPageCos[cPage] * dAbsDistance, this.dCircleSin[i] * this.dPageSin[cPage] * dAbsDistance);
            ++i;
        }
        int[] pre_arc = new int[this.dimCircl + 1];
        int i2 = 0;
        while (i2 < this.dimCircl) {
            pre_arc[i2] = indArcBase + i2;
            ++i2;
        }
        pre_arc[this.dimCircl] = indArcEnd;
        PiVector v_arc = new PiVector(pre_arc);
        knot.setPolygon(indArc, v_arc);
        knot.setPolygonColor(indArc, aColor);
    }

    public void compute3DView(PgKnotBook kb, PgPolygonSet knot, PgElementSet pages, boolean showFree3D) {
        if (kb == null || knot == null || pages == null) {
            PsDebug.warning((String)"in BooknotView.compute3DView(..) some parameter == null");
            return;
        }
        this.iNumPages = kb.getNumPages();
        this.preparingView(kb);
        double[] maxmin = this.getMaxMinCoord(kb);
        double dStart = maxmin[0] - 1.0;
        double dEnd = maxmin[1] + 1.0;
        double dRadius = Math.abs(dEnd - dStart) * 0.5;
        double dX = 0.0;
        pages.setNumElements(this.iNumPages);
        pages.setNumVertices(2 + this.iNumPages * 2);
        pages.setVertex(this.iNumPages * 2, dStart + dX, 0.0, 0.0);
        pages.setVertex(this.iNumPages * 2 + 1, dEnd + dX, 0.0, 0.0);
        int i = 0;
        while (i < this.iNumPages) {
            double dY = dRadius * Math.cos(this.dPageAngle[i]);
            double dZ = dRadius * Math.sin(this.dPageAngle[i]);
            pages.setVertex(i * 2, dStart + dX, dY, dZ);
            pages.setVertex(i * 2 + 1, dEnd + dX, dY, dZ);
            PiVector page = new PiVector(this.iNumPages * 2, i * 2, i * 2 + 1, this.iNumPages * 2 + 1);
            pages.setElement(i, page);
            ++i;
        }
        pages.makeVertexNormals();
        pages.makeNeighbour();
        PgKnotArc[] arcs = kb.getArcs();
        int iArcNum = kb.getNumArcs();
        int[] components = kb.getComponents();
        int numComp = kb.getNumComponents();
        Color[] compColor = new Color[numComp];
        int i2 = 0;
        while (i2 < numComp) {
            compColor[i2] = PdColor.hsv2rgb((int)((int)((double)i2 * 255.0 / (double)numComp)), (int)255, (int)255);
            ++i2;
        }
        knot.setNumVertices(iArcNum * this.dimCircl);
        knot.setNumPolygons(iArcNum);
        if (!showFree3D) {
            pages.showEdges(true);
            pages.showVertices(true);
            i2 = 0;
            while (i2 < iArcNum) {
                PgKnotArc cArc = arcs[i2];
                this.set3DArc(kb, knot, cArc, compColor[components[i2]]);
                ++i2;
            }
        } else {
            pages.showEdges(false);
            pages.showVertices(false);
            PgKnotArc cPreArc = new PgKnotArc();
            PgKnotArc cNextArc = new PgKnotArc();
            int i3 = 0;
            while (i3 < iArcNum) {
                PgKnotArc cArc = arcs[i3];
                int j = 0;
                while (j < iArcNum) {
                    if (arcs[j].getEnd() == cArc.getBase()) {
                        cPreArc = arcs[j];
                    }
                    if (arcs[j].getBase() == cArc.getEnd()) {
                        cNextArc = arcs[j];
                    }
                    ++j;
                }
                this.setFreeArc(kb, knot, cArc, cPreArc, cNextArc, compColor[components[i3]]);
                ++i3;
            }
        }
        knot.update((Object)knot);
        pages.update((Object)pages);
    }

    protected double[] getMaxMinCoord(PgKnotBook kb) {
        PdVector[] vertices = kb.getVertices();
        double[] ret = new double[2];
        int numVert = kb.getNumVertices();
        if (numVert == 0) {
            return ret;
        }
        ret[0] = vertices[0].getEntry(0);
        ret[1] = vertices[0].getEntry(0);
        int i = 1;
        while (i < numVert) {
            ret[0] = ret[0] > vertices[i].getEntry(0) ? vertices[i].getEntry(0) : ret[0];
            ret[1] = ret[1] < vertices[i].getEntry(0) ? vertices[i].getEntry(0) : ret[1];
            ++i;
        }
        return ret;
    }

    public void setArcDisc(int disc) {
        this.dimCircl = disc;
    }

    public void setUpPage(int m_ipageUp) {
        this.m_ipageUp = m_ipageUp;
    }

    public void setDownPage(int m_ipageDown) {
        this.m_ipageDown = m_ipageDown;
    }

    public int getArcDisc() {
        return this.dimCircl;
    }

    public int getUpPage() {
        return this.m_ipageUp;
    }

    public int getDownPage() {
        return this.m_ipageDown;
    }

    public int getNumPages() {
        return this.iNumPages;
    }
}

