package vgp.tutor.transformAmbient;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.project.PjProject_IP;

/**
 * Info panel of space form transformations with sliders.
 * 
 * @author		Konrad Polthier
 * @version		09.06.06, 1.00 created (kp) Based on PjTransform_IP.<br>
 */
public class PjTransformAmbient_IP extends PjProject_IP implements ActionListener {
	protected	PjTransformAmbient	m_pjTransformAmbient;
	protected	PsPanel					m_pBounds;
	protected	Button					m_bReset;

	public PjTransformAmbient_IP() {
		super();
		if (getClass() == PjTransformAmbient_IP.class) {
			init();
		}
	}
	public void init() {
		super.init();
		addTitle("");

		// draw a separator
		addLine(1);

		m_pBounds = new PsPanel();
		addSubTitle("Rotation Angles");
		m_pBounds.setLayout(new GridLayout(3, 1));
		add(m_pBounds);

		// draw a separator
		addLine(1);

		// buttons at bottom
		Panel m_pBottomButtons = new Panel();
		m_pBottomButtons.setLayout(new FlowLayout(FlowLayout.CENTER));
		add(m_pBottomButtons);
		m_bReset = new Button("Reset");
		m_bReset.addActionListener(this);
		m_pBottomButtons.add(m_bReset);
	}
	public void start() {
		
	}
	/**
	 * Set parent of panel which supplies the data inspected by the panel.
	 */
	public void setParent(PsUpdateIf parent) {
		super.setParent(parent);
		m_pjTransformAmbient = (PjTransformAmbient)parent;
		m_pBounds.add(m_pjTransformAmbient.m_angleXW.newInspector(PsPanel.INFO_EXT));
		m_pBounds.add(m_pjTransformAmbient.m_angleYW.newInspector(PsPanel.INFO_EXT));
		m_pBounds.add(m_pjTransformAmbient.m_angleZW.newInspector(PsPanel.INFO_EXT));
	}
	/**
	 * Update the panel whenever the parent has changed somewhere else.
	 * Method is invoked from the parent or its superclasses.
	 */
	public boolean update(Object event) {
		if (m_pjTransformAmbient == event) {
			setTitle(m_pjTransformAmbient.getName());
			return true;
		}
		return super.update(event);
	}
	/**
	 * Handle action events invoked from buttons, menu items, text fields.
	 */
	public void actionPerformed(ActionEvent event) {
		if (m_pjTransformAmbient==null)
			return;
		Object source = event.getSource();
		if (source == m_bReset) {
			m_pjTransformAmbient.init();
			m_pjTransformAmbient.m_surface.update(m_pjTransformAmbient.m_surface);
		}
	}
}

