package vgp.tutor.key;

import java.awt.TextArea;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PjProject_IP;

/**
 * Info panel of keyframe animation of precomputed models.
 * 
 * @author		Konrad Polthier
 * @version		00.00.99, 1.10 revised (kp) <br>
 *					00.00.99, 1.00 created (kp)
 */
public class PjKeyframe_IP extends PjProject_IP {
	protected	PgGeometry				m_geom;

	public PjKeyframe_IP() {
		super();
		if (getClass() == PjKeyframe_IP.class) {
			init();
		}
	}
	public void init() {
		super.init();
		addTitle("Keyframe Panel");

		// say some words
		TextArea explanation = new TextArea(9, 20);
		explanation.setEditable(false);
		explanation.setText("Demo project showing a simple Keyframe.\n");
		explanation.append("Press F4 or Strg-A to display\nthe Keyframe panel\n\n");
		explanation.append("and press the START button in the panel.\n\n");
		explanation.append("While geometry animates, interaction in the viewer\n");
		explanation.append("is simultaneously possible.");
		add(explanation);
	}
	public void setParent(PsUpdateIf parent) {
		super.setParent(parent);
		m_geom = (PgGeometry)m_project.getGeometry();
	}
	/**
	* Here we arrive from outside world of this panel, e.g. if
	* parent has changed somewhere else.
	*/
	public boolean update(Object event) {
		if (m_project==null) {
			if (PsDebug.WARNING) PsDebug.warning("missing parent, setParent not called");
			return false;
		}
		if (event == m_project) {
			m_geom = (PgGeometry)m_project.getGeometry();
			if (m_geom != null)
				setTitle("Keyframe of "+m_geom.getName());
			return true;
		}
		return super.update(event);
	}
}

