(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     37794,       1004]*)
(*NotebookOutlinePosition[     39609,       1057]*)
(*  CellTagsIndexPosition[     39565,       1053]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  "Events from a ",
  StyleBox["JavaView",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " Slider\n",
  StyleBox["\tby Konrad Polthier\n\t",
    FontSize->16],
  StyleBox["(v. 1.03, 14.11.04)",
    FontSize->16,
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}]
}], "Chapter",
  CellGroupingRules->"SectionGrouping",
  TextAlignment->Left],

Cell[TextData[{
  "When the JavaView display is opened, drag the slider to modify, first, the \
shape of a sine curve and, second, radius of the torus. The update events of \
the slider are caught by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to initiate a recomputation of the geometry."
}], "Text"],

Cell[CellGroupData[{

Cell["Frequency of a Sine Curve", "Subsection"],

Cell["\<\
This notebook demonstrates the update listener class \
\"jvx.math.MathUpdateListener\" of JavaView. This listener operates \
asynchronously by starting another thread for the event handling. This avoids \
delays during the rotation and user perceiption of the ongoing event \
handling.\
\>", "Text"],

Cell[TextData[{
  "Load Java runtime into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and load JavaView."
}], "MathCaption"],

Cell[BoxData[{
    \(<< JavaView`JLink`\), "\n", 
    \(\(viewer = InstallJavaView[];\)\)}], "Input",
  CellLabel->"In[55]:="],

Cell["Create a JavaView slider and its info panel.", "MathCaption"],

Cell[BoxData[{
    \(\(slider = 
        JavaNew["\<jv.number.PuInteger\>", "\<Frequency\>"];\)\), "\n", 
    \(\(sliderIP = slider[getInfoPanel[]];\)\)}], "Input",
  CellLabel->"In[57]:=",
  PageWidth->WindowWidth,
  ShowSpecialCharacters->False],

Cell["\<\
We used the JavaView class PsMainFrame since it allows to dispose itself by \
clicking on the window dispose button (since the Java class java.awt.Frame \
would not react on such a click).\
\>", "Text"],

Cell["Show the slider panel in a new frame.", "MathCaption"],

Cell[BoxData[{
    \(\(frame = 
        JavaNew["\<jv.object.PsMainFrame\>", "\<Slider Frame\>"];\)\), "\n", 
    \(\(frame[add["\<Center\>", sliderIP]];\)\), "\n", 
    \(\(frame[setSize[400, 70]];\)\), "\n", 
    \(\(JavaShow[frame];\)\)}], "Input",
  CellLabel->"In[59]:="],

Cell["\<\
Before installing an event handler for the slider, we open the display and \
draw an initial curve.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    StyleBox[\(\(sinCurve = Plot[Sin[x], {x, 0, 5}];\)\[IndentingNewLine]
      \(JavaView[sinCurve];\)\),
      "InlineInput"]], "Input",
  CellLabel->"In[63]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.190476 0.309017 0.294303 [
[.21429 .29652 -3 -9 ]
[.21429 .29652 3 0 ]
[.40476 .29652 -3 -9 ]
[.40476 .29652 3 0 ]
[.59524 .29652 -3 -9 ]
[.59524 .29652 3 0 ]
[.78571 .29652 -3 -9 ]
[.78571 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.01131 .01471 -12 -4.5 ]
[.01131 .01471 0 4.5 ]
[.01131 .16187 -24 -4.5 ]
[.01131 .16187 0 4.5 ]
[.01131 .45617 -18 -4.5 ]
[.01131 .45617 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .30902 m
.21429 .31527 L
s
[(1)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(2)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(3)] .59524 .29652 0 1 Mshowa
.78571 .30902 m
.78571 .31527 L
s
[(4)] .78571 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(5)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.0619 .30902 m
.0619 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.1381 .30902 m
.1381 .31277 L
s
.17619 .30902 m
.17619 .31277 L
s
.25238 .30902 m
.25238 .31277 L
s
.29048 .30902 m
.29048 .31277 L
s
.32857 .30902 m
.32857 .31277 L
s
.36667 .30902 m
.36667 .31277 L
s
.44286 .30902 m
.44286 .31277 L
s
.48095 .30902 m
.48095 .31277 L
s
.51905 .30902 m
.51905 .31277 L
s
.55714 .30902 m
.55714 .31277 L
s
.63333 .30902 m
.63333 .31277 L
s
.67143 .30902 m
.67143 .31277 L
s
.70952 .30902 m
.70952 .31277 L
s
.74762 .30902 m
.74762 .31277 L
s
.82381 .30902 m
.82381 .31277 L
s
.8619 .30902 m
.8619 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.9381 .30902 m
.9381 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 .01471 m
.03006 .01471 L
s
[(-1)] .01131 .01471 1 0 Mshowa
.02381 .16187 m
.03006 .16187 L
s
[(-0.5)] .01131 .16187 1 0 Mshowa
.02381 .45617 m
.03006 .45617 L
s
[(0.5)] .01131 .45617 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04414 m
.02756 .04414 L
s
.02381 .07357 m
.02756 .07357 L
s
.02381 .103 m
.02756 .103 L
s
.02381 .13244 m
.02756 .13244 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .22073 m
.02756 .22073 L
s
.02381 .25016 m
.02756 .25016 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .4856 m
.02756 .4856 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .3683 L
.10458 .43011 L
.14415 .48283 L
.18221 .52651 L
.20342 .54719 L
.22272 .56346 L
.24299 .57773 L
.26171 .58821 L
.28086 .59614 L
.29094 .59916 L
.29653 .60048 L
.30164 .60147 L
.30646 .60221 L
.31105 .60274 L
.31356 .60296 L
.31589 .60311 L
.31721 .60318 L
.31845 .60324 L
.31913 .60326 L
.31988 .60328 L
.32117 .60331 L
.32232 .60332 L
.32338 .60332 L
.32455 .60331 L
.32581 .60329 L
.32712 .60325 L
.32837 .6032 L
.33071 .60308 L
.33289 .60292 L
.33491 .60275 L
.33947 .60222 L
.34411 .60152 L
.3491 .60056 L
.35814 .59833 L
.36889 .59482 L
.37874 .59081 L
.39766 .581 L
.41837 .5672 L
.45893 .53152 L
.49797 .48765 L
.53947 .43287 L
.57945 .37453 L
.61792 .31565 L
.65884 .25277 L
.69824 .19464 L
.73613 .14331 L
.77647 .09589 L
.81529 .05922 L
.83504 .04445 L
Mistroke
.85657 .0316 L
.86656 .02683 L
.8772 .02261 L
.88724 .01944 L
.89633 .01726 L
.90122 .01637 L
.90638 .01563 L
.91078 .01517 L
.91328 .01498 L
.91561 .01485 L
.91691 .0148 L
.91759 .01477 L
.91832 .01475 L
.91895 .01474 L
.91965 .01473 L
.92088 .01472 L
.92207 .01472 L
.92335 .01473 L
.92457 .01475 L
.92567 .01479 L
.92698 .01484 L
.92818 .0149 L
.93093 .01508 L
.9336 .01532 L
.93645 .01563 L
.94156 .01636 L
.94627 .01722 L
.9569 .01981 L
.96628 .02284 L
.97619 .0268 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[63]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X0000gR000`400?l00000o`00003oo`3ooomY
0?ooo`00o`3ooomY0?ooo`00o`3ooomY0?ooo`00o`3ooomY0?ooo`00o`3ooomY0?ooo`00o`3ooomY
0?ooo`00o`3ooomY0?ooo`00o`3ooomY0?ooo`008P3oool00`000000oooo0?ooo`3o0?oood@0oooo
000R0?ooo`030000003oool0oooo0?l0ooooA03oool001L0oooo00<0c8/00000000000000P000000
0`00Gjh0oooo0?ooo`030?ooo`030000003oool0oooo0?l0ooooA03oool001T0oooo00<0olb;05n^
iP3oool01P3oool00`000000oooo0?ooo`3o0?oood@0oooo000I0?ooo`030?o<R`1O[^H0oooo00H0
oooo00<000000?ooo`3oool0o`3ooom40?ooo`003P3oool00`3ool`0R`0000000003000000030000
R`3<ool0oooo0080oooo00<0olb;05n^iP3oool01P3oool300000?l0oooo8P3oool>000001@0oooo
000I0?ooo`030?o<R`1O[^H0oooo00H0oooo00<000000?ooo`3oool0o`3ooolM0?ooo`D000003P3o
ool300000140oooo000I0?ooo`030?o<R`1O[^H0oooo00H0oooo00<000000?ooo`3oool0o`3ooolK
0?ooo`8000005P3oool3000000h0oooo000G0?ooo`040>J^G`00Rl`0olb;05n^iPL0oooo00<00000
0?ooo`3oool0o`3ooolI0?ooo`8000006`3oool3000000/0oooo000H0?ooo`030<b;00000000GjkV
00L0oooo00<000000?ooo`3oool0o`3ooolE0?ooo`@00000803oool3000000P0oooo000R0?ooo`03
0000003oool0oooo0?l0oooo4`3oool2000002l0oooo000R0?ooo`030000003oool0oooo0?l0oooo
4@3oool200000340oooo000R0?ooo`030000003oool0oooo0?l0oooo403oool00`000000oooo0?oo
o`0a0?ooo`008P3oool00`000000oooo0?ooo`3o0?ooo`l0oooo00<000000?ooo`3oool0<P3oool0
0280oooo00<000000?ooo`3oool0o`3oool=0?ooo`800000=@3oool00280oooo0P00003o0?ooo`d0
oooo00<000000?ooo`3oool0=@3oool00280oooo00<000000?ooo`3oool0o`3oool:0?ooo`800000
>03oool00280oooo00<000000?ooo`3oool0o`3oool90?ooo`030000003oool0oooo03P0oooo000R
0?ooo`030000003oool0oooo0?l0oooo203oool00`000000oooo0?ooo`0i0?ooo`008P3oool00`00
0000oooo0?ooo`3o0?ooo`H0oooo0P00000l0?ooo`008P3oool00`000000oooo0?ooo`3o0?ooo`D0
oooo00<000000?ooo`3oool0?03oool00280oooo00<000000?ooo`3oool0o`3oool40?ooo`030000
003oool0oooo03d0oooo000R0?ooo`030000003oool0oooo0?l0oooo0`3oool00`000000oooo0?oo
o`0n0?ooo`008P3oool00`000000oooo0?ooo`3o0?ooo`80oooo00<000000?ooo`3oool0?`3oool0
0280oooo0P00003o0?ooo`80oooo00<000000?ooo`3oool0@03oool00280oooo00<000000?ooo`3o
ool0o`3oool00`000000oooo0?ooo`110?ooo`008P3oool00`000000oooo0?ooo`3m0?ooo`800000
A03oool00280oooo00<000000?ooo`3oool0o03oool00`000000oooo0?ooo`140?ooo`008P3oool0
0`000000oooo0?ooo`3k0?ooo`030000003oool0oooo04D0oooo000R0?ooo`030000003oool0oooo
0?X0oooo00<000000?ooo`3oool0AP3oool00280oooo00<000000?ooo`3oool0n@3oool00`000000
oooo0?ooo`170?ooo`008P3oool00`000000oooo0?ooo`3h0?ooo`030000003oool0oooo04P0oooo
000R0?ooo`030000003oool0oooo0?L0oooo00<000000?ooo`3oool0B@3oool00280oooo00<00000
0?ooo`3oool0mP3oool00`000000oooo0?ooo`1:0?ooo`008P3oool200000?H0oooo00<000000?oo
o`3oool0B`3oool00280oooo00<000000?ooo`3oool0m@3oool00`000000oooo0?ooo`1;0?ooo`00
8P3oool00`000000oooo0?ooo`3d0?ooo`030000003oool0oooo04`0oooo000R0?ooo`030000003o
ool0oooo0?<0oooo00<000000?ooo`3oool0C@3oool00280oooo00<000000?ooo`3oool0lP3oool0
0`000000oooo0?ooo`1>0?ooo`008P3oool00`000000oooo0?ooo`3a0?ooo`030000003oool0oooo
04l0oooo000R0?ooo`030000003oool0oooo0?00oooo00<000000?ooo`3oool0D03oool00280oooo
00<000000?ooo`3oool0l03oool00`000000oooo0?ooo`1@0?ooo`008P3oool00`000000oooo0?oo
o`3_0?ooo`030000003oool0oooo0540oooo000R0?ooo`030000003oool0oooo0>h0oooo00<00000
0?ooo`3oool0DP3oool00280oooo0P00003^0?ooo`030000003oool0oooo05<0oooo000R0?ooo`03
0000003oool0oooo0>`0oooo00<000000?ooo`3oool0E03oool00280oooo00<000000?ooo`3oool0
k03oool00`000000oooo0?ooo`1D0?ooo`008P3oool00`000000oooo0?ooo`3[0?ooo`030000003o
ool0oooo05D0oooo000R0?ooo`030000003oool0oooo0>X0oooo00<000000?ooo`3oool0EP3oool0
0280oooo00<000000?ooo`3oool0j@3oool00`000000oooo0?ooo`1G0?ooo`008P3oool00`000000
oooo0?ooo`3X0?ooo`030000003oool0oooo05P0oooo00080?ooo`040:iO000000000000002;c0@0
oooo00@0ooo<08/0000008/0c?oo103oool0102^G`00000000000000Gjh60?ooo`030000003oool0
oooo0>P0oooo00<000000?ooo`3oool0F03oool000L0oooo00H0onJ^08^^iP3oool0oooo0<b;002;
c?l30?ooo`040?ooc02;0000002;0<coo`<0oooo00H0[Ul005n^iP3oool0oooo0>J^G`00Rl`50?oo
o`030000003oool0oooo0>L0oooo00<000000?ooo`3oool0F@3oool000L0oooo00H0c8/008_<o`3o
ool0oooo0?oV[P1ORl`>0?ooo`030?ooc02;Gjh0oooo00@0oooo00<000000?ooo`3oool0iP3oool0
0`000000oooo0?ooo`1J0?ooo`00100000001@0008/0c?oo0?ooo`3<Rel0[^Ko0080oooo00<0onJ^
05mO[P3oool03@3oool00`3oc8/008_<0?ooo`040?ooo`<00000i@3oool00`000000oooo0?ooo`1K
0?ooo`001`3oool01P3<Rel0[^Ko0?ooo`3oool0onJ^05mO[PX0oooo00H0onJ^05l0000000000000
0000R`3<ool50?ooo`030000003oool0oooo0>D0oooo00<000000?ooo`3oool0F`3oool000L0oooo
00H0c8]O0:kVo`3oool0oooo0?oV[P1ORl`:0?ooo`030?oV[P1ORl`0oooo00P0oooo00<000000?oo
o`3oool0i03oool00`000000oooo0?ooo`1L0?ooo`001`3oool01P3oc8/005n^0?ooo`3oool0c8/0
08_<o`X0oooo00<0onJ^05n;c03oool0203oool00`000000oooo0?ooo`3S0?ooo`030000003oool0
oooo05d0oooo00080?ooo`040>J^G`0000000000002;c0/0oooo00H0onJ^05l00000000000000000
R`3<ool50?ooo`030000003oool0oooo0>80oooo00<000000?ooo`3oool0GP3oool00280oooo00<0
00000?ooo`3oool0hP3oool00`000000oooo0?ooo`1N0?ooo`008P3oool00`000000oooo0?ooo`3Q
0?ooo`030000003oool0oooo05l0oooo000R0?ooo`030000003oool0oooo0>00oooo00<000000?oo
o`3oool0H03oool00280oooo00<000000?ooo`3oool0g`3oool00`000000oooo0?ooo`1Q0?ooo`00
8P3oool00`000000oooo0?ooo`3O0?ooo`030000003oool0oooo0640oooo000R0?ooo`800000g`3o
ool00`000000oooo0?ooo`1R0?ooo`008P3oool00`000000oooo0?ooo`3M0?ooo`030000003oool0
oooo06<0oooo000R0?ooo`030000003oool0oooo0=`0oooo00<000000?ooo`3oool0I03oool00280
oooo00<000000?ooo`3oool0g03oool00`000000oooo0?ooo`1T0?ooo`008P3oool00`000000oooo
0?ooo`3K0?ooo`030000003oool0oooo06D0oooo000R0?ooo`030000003oool0oooo0=X0oooo00<0
00000?ooo`3oool0IP3oool00280oooo00<000000?ooo`3oool0fP3oool00`000000oooo0?ooo`1V
0?ooo`008P3oool00`000000oooo0?ooo`3I0?ooo`030000003oool0oooo06L0oooo000R0?ooo`03
0000003oool0oooo0=P0oooo00<000000?ooo`3oool0J03oool00280oooo0P00003I0?ooo`030000
003oool0oooo06P0oooo000R0?ooo`030000003oool0oooo0=L0oooo00<000000?ooo`3oool0J@3o
ool00280oooo00<000000?ooo`3oool0eP3oool00`000000oooo0?ooo`1Z0?ooo`008P3oool00`00
0000oooo0?ooo`3E0?ooo`030000003oool0oooo06/0oooo000R0?ooo`030000003oool0oooo0=D0
oooo00<000000?ooo`3oool0J`3oool00280oooo00<000000?ooo`3oool0e03oool00`000000oooo
0?ooo`1/0?ooo`008P3oool00`000000oooo0?ooo`3C0?ooo`030000003oool0oooo06d0oooo000R
0?ooo`030000003oool0oooo0=<0oooo00<000000?ooo`3oool0K@3oool00280oooo00<000000?oo
o`3oool0dP3oool00`000000oooo0?ooo`1^0?ooo`008P3oool00`000000oooo0?ooo`3A0?ooo`03
0000003oool0oooo06l0oooo000R0?ooo`800000dP3oool00`000000oooo0?ooo`1_0?ooo`008P3o
ool00`000000oooo0?ooo`3@0?ooo`030000003oool0oooo0700oooo000R0?ooo`030000003oool0
oooo0<l0oooo00<000000?ooo`3oool0L@3oool00280oooo00<000000?ooo`3oool0c`3oool00`00
0000oooo0?ooo`1a0?ooo`008P3oool00`000000oooo0?ooo`3>0?ooo`030000003oool0oooo0780
oooo000R0?ooo`030000003oool0oooo03T0oooo00<0c8/00000000000000P0000000`00Gjh0oooo
0?ooo`0f0?ooo`030?oV[P1O0000000000<0000000<0Rlco0?ooo`3oool0>03oool01@3ool`0R`00
00000000000005n^0100oooo00<000000?ooo`3oool0:@3oool0103<R`0000000000001O[^Hk0?oo
o`040:iO000000000000001O[PL0oooo000R0?ooo`030000003oool0oooo03/0oooo00<0olb;05n^
iP3oool0>P3oool00`3<R`0005n^0?ooo`0m0?ooo`060:iO002;c?l0oooo0?ooo`3<R`0008_<3`3o
ool00`000000oooo0?ooo`0Z0?ooo`030?oV[P1ORl`0oooo03X0oooo00H0[Ul005n^iP3oool0oooo
0>J^G`00Rl`60?ooo`008P3oool00`000000oooo0?ooo`0k0?ooo`030?o<R`1O[^H0oooo03/0oooo
00<0iZiO0000G`2^i_l0@03oool00`3ool`0Ren^0?ooo`0=0?ooo`030000003oool0oooo02/0oooo
00<0onJ^05n;c03oool0?P3oool00`3ool`0Ren^0?ooo`050?ooo`008P3oool00`000000oooo0?oo
o`0k0?ooo`030?o<R`1O[^H0oooo03`0oooo00<0onJ^05l0002;c?l0?`3oool00`3<R`00GjkV0?oo
o`0<0?ooo`030000003oool0oooo02T0oooo00<0c8/00000000000000P0000000`1O[^H0oooo0?oo
o`0l0?ooo`030?o<R`00Rl`0oooo00D0oooo000R0?ooo`030000003oool0oooo03/0oooo00<0olb;
05n^iP3oool0?@3oool00`3ool`0Ren^0?ooo`0k0?ooo`040?ooc02;00000000001O[Ph0oooo00<0
00000?ooo`3oool0:@3oool01@3V[Ul008_<0?ooo`3oiZh0Gh_<03/0oooo00H0onJ^05l000000000
00000000R`3<ool60?ooo`008P3oool2000003`0oooo00<0olb;05n^iP3oool0?P3oool00`3V[Ul0
Rlco0?ooo`0m0?ooo`030>J^G`1O[^H0oooo00/0oooo00<000000?ooo`3oool0:`3oool0103<R`00
GjkV0?oV[P1ORl`k0?ooo`030?oV[P1ORl`0oooo00T0oooo000R0?ooo`030000003oool0oooo03T0
oooo00@0iZiO002;c03oc8/0GjkV>`3oool01P3<R`00GjkV0?ooo`3ool`0R`0008_<ocX0oooo00H0
c8/0001O[P3oool0oooo0>J^G`1O[^H;0?ooo`030000003oool0oooo02d0oooo00<0[Ul008^^[P1O
Rl`0>`3oool00`3oiZh0Gh_<0?ooo`090?ooo`008P3oool00`000000oooo0?ooo`0j0?ooo`030<b;
00000000GjkV03`0oooo00@0[Ul0000000000000GjkV?03oool0103V[Ul0000000000000Gjh<0?oo
o`030000003oool0oooo02d0oooo00<0ooo<08/00000Rl`0>`3oool01P3oiZh0G`00000000000000
002;0<coo`H0oooo000R0?ooo`030000003oool0oooo0<P0oooo00<000000?ooo`3oool0N03oool0
0280oooo00<000000?ooo`3oool0a`3oool00`000000oooo0?ooo`1i0?ooo`008P3oool00`000000
oooo0?ooo`370?ooo`030000003oool0oooo07T0oooo000R0?ooo`030000003oool0oooo0<H0oooo
00<000000?ooo`3oool0NP3oool00280oooo00<000000?ooo`3oool0a@3oool00`000000oooo0?oo
o`1k0?ooo`008P3oool00`000000oooo0?ooo`350?ooo`030000003oool0oooo07/0oooo000R0?oo
o`030000003oool0oooo0<@0oooo00<000000?ooo`3oool0O03oool001X0ooooo`00001?00000000
8P3oool2000000X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00D0oooo00D000000?ooo`3oool0oooo0000000<0?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`060?ooo`008P3oool2000003d0oooo
00<000000?ooo`3oool0?03oool00`000000oooo0?ooo`0m0?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool0=@3oool00`000000oooo0?ooo`0m0?ooo`030000003oool0oooo00H0oooo
000R0?ooo`030000003oool000000<40oooo00<000000?ooo`3oool0O`3oool00280oooo00@00000
0?ooo`3oool00000`03oool00`000000oooo0?ooo`1o0?ooo`008P3oool010000000oooo0?ooo`00
002o0?ooo`030000003oool0oooo0800oooo000R0?ooo`050000003oool0oooo0?ooo`000000_P3o
ool00`000000oooo0?ooo`200?ooo`008P3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo0;X0oooo00<000000?ooo`3oool0P@3oool00280oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`2i0?ooo`030000003oool0oooo0880oooo000R0?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool0^03oool00`000000oooo0?ooo`220?ooo`008P3oool2000000@0oooo
00<000000?ooo`3oool0]`3oool00`000000oooo0?ooo`230?ooo`008P3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo0;H0oooo00<000000?ooo`3oool0P`3oool00280oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`2d0?ooo`030000003oool0oooo08@0oooo000R0?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool0/`3oool00`000000oooo0?ooo`250?oo
o`008P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0;80oooo00<000000?ooo`3o
ool0Q@3oool00280oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`2`0?ooo`030000
003oool0oooo08H0oooo000R0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0/03o
ool00`000000oooo0?ooo`260?ooo`008P3oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo0:h0oooo00<000000?ooo`3oool0Q`3oool00280oooo00<000000?ooo`3oool02@3oool00`00
0000oooo0?ooo`2/0?ooo`030000003oool0oooo08P0oooo000R0?ooo`8000002P3oool00`000000
oooo0?ooo`2/0?ooo`030000003oool0oooo08P0oooo000R0?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool0ZP3oool00`000000oooo0?ooo`290?ooo`008P3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo0:T0oooo00<000000?ooo`3oool0R@3oool00280oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`2X0?ooo`030000003oool0oooo08X0oooo000R0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool0YP3oool00`000000oooo0?ooo`2;0?oo
o`008P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0:D0oooo00<000000?ooo`3o
ool0R`3oool00280oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`2T0?ooo`030000
003oool0oooo08`0oooo000R0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0XP3o
ool00`000000oooo0?ooo`2=0?ooo`008P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0
oooo0:00oooo00<000000?ooo`3oool0SP3oool00280oooo00<000000?ooo`3oool0403oool00`00
0000oooo0?ooo`2O0?ooo`030000003oool0oooo08h0oooo000R0?ooo`8000004@3oool00`000000
oooo0?ooo`2N0?ooo`030000003oool0oooo08l0oooo000R0?ooo`030000003oool0oooo0140oooo
00<000000?ooo`3oool0W03oool00`000000oooo0?ooo`2@0?ooo`008P3oool00`000000oooo0?oo
o`0B0?ooo`030000003oool0oooo09X0oooo00<000000?ooo`3oool0T@3oool00280oooo00<00000
0?ooo`3oool04P3oool00`000000oooo0?ooo`2J0?ooo`030000003oool0oooo0940oooo000R0?oo
o`030000003oool0oooo01<0oooo00<000000?ooo`3oool0V03oool00`000000oooo0?ooo`2B0?oo
o`008P3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo09H0oooo00<000000?ooo`3o
ool0T`3oool00280oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`2E0?ooo`030000
003oool0oooo09@0oooo000R0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0U03o
ool00`000000oooo0?ooo`2D0?ooo`008P3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0
oooo0980oooo00<000000?ooo`3oool0U@3oool00280oooo00<000000?ooo`3oool05`3oool00`00
0000oooo0?ooo`2@0?ooo`030000003oool0oooo09H0oooo000R0?ooo`800000603oool00`000000
oooo0?ooo`2?0?ooo`030000003oool0oooo09L0oooo000R0?ooo`030000003oool0oooo01P0oooo
00<000000?ooo`3oool0SP3oool00`000000oooo0?ooo`2G0?ooo`008P3oool00`000000oooo0?oo
o`0I0?ooo`030000003oool0oooo08`0oooo00<000000?ooo`3oool0V03oool00280oooo00<00000
0?ooo`3oool06@3oool00`000000oooo0?ooo`2;0?ooo`030000003oool0oooo09T0oooo000R0?oo
o`030000003oool0oooo01X0oooo00<000000?ooo`3oool0R@3oool00`000000oooo0?ooo`2J0?oo
o`008P3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo08P0oooo00<000000?ooo`3o
ool0VP3oool00280oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`260?ooo`030000
003oool0oooo09/0oooo00080?ooo`040:iO000000000000002;c0@0oooo00@0ooo<08/0000008/0
c?oo103oool0102^G`00000000000000Gjh60?ooo`030000003oool0oooo01`0oooo00<000000?oo
o`3oool0Q@3oool00`000000oooo0?ooo`2L0?ooo`001`3oool01P3oiZh0RjkV0?ooo`3oool0c8/0
08_<o`<0oooo00@0ooo<08/0000008/0c?oo0`3oool01P2^G`00GjkV0?ooo`3oool0iZiO002;c0D0
oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`230?ooo`030000003oool0oooo09d0
oooo00070?ooo`060<b;002;c?l0oooo0?ooo`3oiZh0Gh_<3P3oool00`3ool`0Ren^0?ooo`040?oo
o`030000003oool0oooo01h0oooo00<000000?ooo`3oool0PP3oool00`000000oooo0?ooo`2M0?oo
o`001`3oool01P3<Rel0[^Ko0?ooo`3oool0onJ^05mO[Ph0oooo00<0olb;002;c03oool0103oool3
000001h0oooo00<000000?ooo`3oool0P@3oool00`000000oooo0?ooo`2N0?ooo`001`3oool01P3<
Rel0[^Ko0?ooo`3oool0onJ^05mO[PX0oooo00H0onJ^05l00000000000000000R`3<ool50?ooo`03
0000003oool0oooo01l0oooo00<000000?ooo`3oool0O`3oool00`000000oooo0?ooo`2O0?ooo`00
1`3oool01P3<Rel0[^Ko0?ooo`3oool0onJ^05n;c0X0oooo00<0onJ^05n;c03oool0203oool00`00
0000oooo0?ooo`0P0?ooo`030000003oool0oooo07d0oooo00<000000?ooo`3oool0X03oool000L0
oooo00H0olb;001O[P3oool0oooo0<b;002;c?l:0?ooo`030?oV[P1ORl`0oooo00P0oooo00<00000
0?ooo`3oool08@3oool00`000000oooo0?ooo`1k0?ooo`030000003oool0oooo0:40oooo00080?oo
o`040>J^G`0000000000002;c0/0oooo00H0onJ^05l00000000000000000R`3<ool50?ooo`030000
003oool0oooo0240oooo00<000000?ooo`3oool0N`3oool00`000000oooo0?ooo`2Q0?ooo`008P3o
ool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo07T0oooo00<000000?ooo`3oool0XP3o
ool00280oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`1g0?ooo`030000003oool0
oooo0:<0oooo000R0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0M@3oool00`00
0000oooo0?ooo`2T0?ooo`008P3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo07D0
oooo00<000000?ooo`3oool0Y03oool00280oooo00<000000?ooo`3oool09@3oool00`000000oooo
0?ooo`1c0?ooo`030000003oool0oooo0:D0oooo000R0?ooo`8000009`3oool00`000000oooo0?oo
o`1a0?ooo`030000003oool0oooo0:H0oooo000R0?ooo`030000003oool0oooo02L0oooo00<00000
0?ooo`3oool0K`3oool00`000000oooo0?ooo`2W0?ooo`008P3oool00`000000oooo0?ooo`0X0?oo
o`030000003oool0oooo06d0oooo00<000000?ooo`3oool0Z03oool00280oooo00<000000?ooo`3o
ool0:03oool00`000000oooo0?ooo`1/0?ooo`030000003oool0oooo0:T0oooo000R0?ooo`030000
003oool0oooo02T0oooo00<000000?ooo`3oool0J`3oool00`000000oooo0?ooo`2Y0?ooo`008P3o
ool00`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo06T0oooo00<000000?ooo`3oool0ZP3o
ool00280oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`1W0?ooo`030000003oool0
oooo0:/0oooo000R0?ooo`030000003oool0oooo02`0oooo00<000000?ooo`3oool0I@3oool00`00
0000oooo0?ooo`2/0?ooo`008P3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo06<0
oooo00<000000?ooo`3oool0[@3oool00280oooo0P00000_0?ooo`030000003oool0oooo0640oooo
00<000000?ooo`3oool0[P3oool00280oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?oo
o`1P0?ooo`030000003oool0oooo0:l0oooo000R0?ooo`030000003oool0oooo02l0oooo00<00000
0?ooo`3oool0GP3oool00`000000oooo0?ooo`2`0?ooo`008P3oool00`000000oooo0?ooo`0`0?oo
o`030000003oool0oooo05d0oooo00<000000?ooo`3oool0/03oool00280oooo00<000000?ooo`3o
ool0<@3oool00`000000oooo0?ooo`1K0?ooo`030000003oool0oooo0;40oooo000R0?ooo`030000
003oool0oooo0380oooo00<000000?ooo`3oool0F@3oool00`000000oooo0?ooo`2b0?ooo`008P3o
ool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo05L0oooo00<000000?ooo`3oool0/`3o
ool00280oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`1E0?ooo`030000003oool0
oooo0;@0oooo000R0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool0D`3oool00`00
0000oooo0?ooo`2e0?ooo`008P3oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo0540
oooo00<000000?ooo`3oool0]P3oool00280oooo0P00000h0?ooo`030000003oool0oooo04l0oooo
00<000000?ooo`3oool0]`3oool00280oooo00<000000?ooo`3oool0>03oool00`000000oooo0?oo
o`1=0?ooo`030000003oool0oooo0;P0oooo000R0?ooo`030000003oool0oooo03T0oooo0P00001;
0?ooo`800000^`3oool00280oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`170?oo
o`030000003oool0oooo0;/0oooo000R0?ooo`030000003oool0oooo03`0oooo00<000000?ooo`3o
ool0A@3oool00`000000oooo0?ooo`2l0?ooo`008P3oool00`000000oooo0?ooo`0m0?ooo`800000
A03oool00`000000oooo0?ooo`2m0?ooo`008P3oool00`000000oooo0?ooo`0o0?ooo`030000003o
ool0oooo0400oooo00<000000?ooo`3oool0_P3oool00280oooo00<000000?ooo`3oool0@03oool2
000003l0oooo00<000000?ooo`3oool0_`3oool00280oooo00<000000?ooo`3oool0@P3oool00`00
0000oooo0?ooo`0k0?ooo`030000003oool0oooo0<00oooo000R0?ooo`030000003oool0oooo04<0
oooo00<000000?ooo`3oool0>03oool200000<<0oooo000R0?ooo`800000A@3oool2000003H0oooo
0P0000350?ooo`008P3oool00`000000oooo0?ooo`160?ooo`030000003oool0oooo0340oooo0P00
00370?ooo`008P3oool00`000000oooo0?ooo`170?ooo`800000<03oool00`000000oooo0?ooo`37
0?ooo`008P3oool00`000000oooo0?ooo`190?ooo`030000003oool0oooo02/0oooo0P00003:0?oo
o`008P3oool00`000000oooo0?ooo`1:0?ooo`800000:P3oool00`000000oooo0?ooo`3:0?ooo`00
8P3oool00`000000oooo0?ooo`1<0?ooo`8000009P3oool200000<d0oooo000R0?ooo`030000003o
ool0oooo04h0oooo0`00000Q0?ooo`800000c`3oool001L0oooo00<0c8/00000000000000P000000
0`00Gjh0oooo0?ooo`030?ooo`030000003oool0oooo0540oooo0`00000J0?ooo`@00000d@3oool0
01T0oooo00<0olb;05n^iP3oool01P3oool00`000000oooo0?ooo`1D0?ooo`<00000503oool30000
0=D0oooo000I0?ooo`030?o<R`1O[^H0oooo00H0oooo00<000000?ooo`3oool0E`3oool5000000X0
oooo1@00003H0?ooo`006@3oool00`3oc8/0GjkV0?ooo`060?ooo`<00000G03oool:00000=d0oooo
000I0?ooo`030?o<R`1O[^H0oooo00H0oooo00<000000?ooo`3oool0o`3ooom40?ooo`006@3oool0
0`3oc8/0GjkV0?ooo`060?ooo`030000003oool0oooo0?l0ooooA03oool001L0oooo00@0iZiO002;
c03oc8/0GjkV1`3oool00`000000oooo0?ooo`3o0?oood@0oooo000H0?ooo`030<b;00000000GjkV
00L0oooo00<000000?ooo`3oool0o`3ooom40?ooo`008P3oool00`000000oooo0?ooo`3o0?oood@0
oooo003o0?ooofT0oooo003o0?ooofT0oooo003o0?ooofT0oooo003o0?ooofT0oooo003o0?ooofT0
oooo003o0?ooofT0oooo003o0?ooofT0oooo0000\
\>"],
  ImageRangeCache->{{{0, 359}, {221.375, 0}} -> {-0.538963, -1.13025, \
0.0197214, 0.0127639}}],

Cell[BoxData[
    \(Null\^2\)], "Output",
  CellLabel->"Out[63]="]
}, Open  ]],

Cell["\<\
The following function is an event handler and will be called a listener when \
the slider is modified. The argument evt is the slider object which is then \
queried for its current value. Here we interpret the value as frequency of a \
sine curve. When the sine curve is recomputed, the method geom@update[geom] \
ensures that the display and other panels depending on the curve are updated.
Replace the body of the event handler method with your own calculations.\
\>", "Text"],

Cell["Compute a sine curve using the current value of the slider.", \
"MathCaption"],

Cell[BoxData[
    RowBox[{
      StyleBox[\(evalSinCurve[evt_, message_]\),
        "InlineInput"], 
      StyleBox[":=",
        "InlineInput"], 
      StyleBox["\[IndentingNewLine]",
        "InlineInput"], 
      StyleBox["\t",
        "InlineInput"], 
      RowBox[{
        StyleBox["JavaBlock",
          "InlineInput"], 
        StyleBox["[",
          "InlineInput"], 
        StyleBox["\[IndentingNewLine]",
          "InlineInput"], "\t\t", 
        StyleBox[\(\(val = evt@getValue[];\)\[IndentingNewLine]
          \t\t\(sinCurve = Plot[Sin[val*x], {x, 0, 5}];\)\[IndentingNewLine]
          \t\t\(JavaView[sinCurve];\)\),
          "InlineInput"], 
        StyleBox["\[IndentingNewLine]",
          "InlineInput"], "\t\t", \( (*\ ReleaseObject[evt]\ *) \), 
        "\[IndentingNewLine]", 
        StyleBox["\t",
          "InlineInput"], 
        StyleBox["]",
          "InlineInput"]}]}]], "Input",
  CellLabel->"In[64]:="],

Cell["\<\
Register a listener to receive update events whenever the slider changes its \
state.\
\>", "MathCaption"],

Cell[BoxData[{
    \(\(listenerSin = 
        JavaNew["\<jvx.math.MathUpdateListener\>"];\)\), \
"\[IndentingNewLine]", 
    \(\(listenerSin@
        setHandler["\<update\>", "\<evalSinCurve\>"];\)\), "\
\[IndentingNewLine]", 
    \(\(slider@addUpdateListener[listenerSin];\)\)}], "Input",
  CellLabel->"In[65]:="],

Cell[TextData[{
  "The JavaView and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " thread must run at the same time, if a JavaView event shall be processed \
by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". Therefore, ShareKernel[] must be invoked before the slider has any \
effect. After invoking ShareKernel[] change the value of the slider and see \
how the torus changes in size."
}], "Text"],

Cell["\<\
Share the kernel to allow further interaction with the slider and display. \
After invoking ShareKernel[] change the value of the slider and see how the \
torus changes in size.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ShareKernel[]\)], "Input",
  CellLabel->"In[68]:="],

Cell[BoxData[
    \(4\)], "Output",
  CellLabel->"Out[68]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "When done with interaction, then call UnshareKernel[]. After calling \
UnshareKernel[] ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " will no longer receive events from ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " unless ShareKernel[] is called again."
}], "MathCaption"],

Cell[BoxData[
    \(UnshareKernel[]\)], "Input",
  CellLabel->"(sharing) In[69]:="]
}, Open  ]],

Cell[CellGroupData[{

Cell["Changing the Radius of a Torus", "Subsection"],

Cell[TextData[{
  "In the above example the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics was always recreated and the JavaView display cleared before \
adding the new version of the graphics as a new JavaView geometry. The next \
example creates a more permanent JavaView geometry first and recalculates it \
whenever the slider sends an update event. Note, the geometry remains the \
same, only its coordinates are changed."
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[{
  "Load Java runtime into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and load JavaView."
}], "MathCaption"],

Cell[BoxData[{
    \(<< JavaView`JLink`\), "\n", 
    \(\(viewer = InstallJavaView[];\)\)}], "Input",
  CellLabel->"In[70]:="]
}, Open  ]],

Cell["Create a JavaView slider and its info panel.", "MathCaption"],

Cell["\<\
slider = JavaNew[\"jv.number.PuInteger\", \"Radius\"];
sliderIP = slider@getInfoPanel[];\
\>", "Input",
  CellLabel->"In[72]:=",
  PageWidth->WindowWidth,
  ShowSpecialCharacters->False],

Cell["\<\
We used the JavaView class PsMainFrame since it allows to dispose itself by \
clicking on the window dispose button (since the Java class java.awt.Frame \
would not react on such a click).\
\>", "Text"],

Cell["Show the slider panel in a new frame.", "MathCaption"],

Cell[BoxData[{
    \(\(frame = 
        JavaNew["\<jv.object.PsMainFrame\>", "\<Slider Frame\>"];\)\), "\
\[IndentingNewLine]", 
    \(\(frame@add["\<Center\>", sliderIP];\)\), "\[IndentingNewLine]", 
    \(\(frame@setSize[400, 70];\)\), "\[IndentingNewLine]", 
    \(\(JavaShow[frame];\)\)}], "Input",
  CellLabel->"In[74]:="],

Cell["Create a sample, permanent geometry and show it.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{\(geom\  = \ 
        JavaNew["\<jv.geom.PgElementSet\>", 
          3];\), "\[IndentingNewLine]", \(geom@
        setName["\<Dynamic Torus\>"];\), "\[IndentingNewLine]", \(geom@
        computeTorus[10, 10, 2. , 1. ];\), "\[IndentingNewLine]", 
    RowBox[{
      StyleBox["JavaView",
        FontSlant->"Plain"], "[", "geom", "]"}]}], "Input",
  CellLabel->"In[78]:="],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]JavaObject[
          "jv.geom.PgElementSet"] \[RightGuillemet]\),
      JLink`Objects`JavaObject80178315265]], "Output",
  CellLabel->"Out[81]="]
}, Open  ]],

Cell[CellGroupData[{

Cell["Possibly switch display to 3D perspective mode.", "SubsubsectionIcon"],

Cell["\<\
If this is example is executed right after the sine-curve example then the \
display might still be in xy-projection mode. Here we switch to a perspective \
camera. Also we switch off axes and enable depthcue.\
\>", "Text"],

Cell["Switch to perspective camera.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(disp = viewer@getDisplay[];\)\), "\[IndentingNewLine]", 
    \(\(LoadClass["\<jv.project.PvCameraIf\>"];\)\), "\[IndentingNewLine]", 
    \(\(disp@
        selectCamera[
          PvCameraIf`CAMERAUPERSPECTIVE];\)\), "\[IndentingNewLine]", 
    \(\(disp@showAxes[False];\)\), "\[IndentingNewLine]", 
    \(\(disp@showDepthcue[True];\)\), "\[IndentingNewLine]", 
    \(disp@update[disp]\)}], "Input",
  CellLabel->"In[82]:="],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[87]="]
}, Open  ]]
}, Closed]],

Cell["\<\
The following function is an event handler and will be called a listener when \
the slider is modified. The argument evt is the slider object which is then \
queried for its current value. Here we interpret the value as radius of a \
torus geometry. When the torus is recomputed, the method geom@update[geom] \
ensures that the display and other panels depending on the torus are updated.
Replace the body of the event handler method with your own calculations.\
\>", "Text"],

Cell["Compute a torus using the current value of the slider.", "MathCaption"],

Cell[BoxData[
    RowBox[{
      StyleBox[\(evalTorus[evt_, message_]\),
        "InlineInput"], 
      StyleBox[":=",
        "InlineInput"], 
      StyleBox["\[IndentingNewLine]",
        "InlineInput"], 
      StyleBox["\t",
        "InlineInput"], 
      RowBox[{
        StyleBox["JavaBlock",
          "InlineInput"], 
        StyleBox["[",
          "InlineInput"], 
        StyleBox["\[IndentingNewLine]",
          "InlineInput"], "\t\t", 
        RowBox[{
          StyleBox[\(val = evt@getValue[]\),
            "InlineInput"], 
          StyleBox[";",
            "InlineInput"], 
          StyleBox["\[IndentingNewLine]",
            "InlineInput"], "\t\t", \(geom@computeTorus[10, 10, val, 1. ]\), 
          ";", "\[IndentingNewLine]", "\t\t", \(geom@update[geom]\), ";"}], 
        "\[IndentingNewLine]", "\t\t", \( (*\ ReleaseObject[evt]\ *) \), 
        "\[IndentingNewLine]", 
        StyleBox["\t",
          "InlineInput"], 
        StyleBox["]",
          "InlineInput"]}]}]], "Input",
  CellLabel->"In[88]:="],

Cell["\<\
Register a listener to receive update events whenever the slider changes its \
state.\
\>", "MathCaption"],

Cell[BoxData[{
    \(\(listenerTorus = 
        JavaNew["\<jvx.math.MathUpdateListener\>"];\)\), \
"\[IndentingNewLine]", 
    \(\(listenerTorus@
        setHandler["\<update\>", "\<evalTorus\>"];\)\), \
"\[IndentingNewLine]", 
    \(\(slider@addUpdateListener[listenerTorus];\)\)}], "Input",
  CellLabel->"In[89]:="],

Cell[TextData[{
  "The JavaView and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " thread must run at the same time, if a JavaView event shall be processed \
by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". Therefore, ShareKernel[] must be invoked before the slider has any \
effect. After invoking ShareKernel[] change the value of the slider and see \
how the torus changes in size."
}], "Text"],

Cell["\<\
Start sharing the kernel. After invoking ShareKernel[] change the value of \
the slider and see how the torus changes in size.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ShareKernel[]\)], "Input",
  CellLabel->"In[92]:="],

Cell[BoxData[
    \(5\)], "Output",
  CellLabel->"Out[92]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "When done with interaction, then call UnshareKernel[]. After calling \
UnshareKernel[] ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " will no longer receive events from ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " unless ShareKernel[] is called again."
}], "MathCaption"],

Cell[BoxData[
    \(UnshareKernel[]\)], "Input",
  CellLabel->"(sharing) In[52]:="]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1400}, {0, 998}},
AutoGeneratedPackage->None,
ScreenStyleEnvironment->"Brackets",
CellGrouping->Manual,
WindowSize->{737, 899},
WindowMargins->{{Automatic, 0}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Inherited, Cell[ 
        TextData[ {"Konrad Polthier"}], "PageHeader"]}, {Cell[ 
        TextData[ {"The ", 
          StyleBox[ "JavaView", FontSlant -> "Italic"], " Packages"}], 
        "PageHeader"], Inherited, Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"]}},
PageFooters->{{Inherited, Cell[ 
        TextData[ {
          "\[Copyright]1999 Wolfram Research, Inc. All rights reserved."}], 
        "PageFooter"], Inherited}, {Inherited, Cell[ 
        TextData[ {
          "\[Copyright]1999 Wolfram Research, Inc. All rights reserved."}], 
        "PageFooter"], Inherited}},
PageFooterLines->{True, True},
PrintingOptions->{"PrintingMargins"->{{57.375, 57.375}, {57.375, 57.375}},
"PrintCellBrackets"->True,
"PrintRegistrationMarks"->False,
"PrintMultipleHorizontalPages"->False,
"FacingPages"->True},
CellLabelAutoDelete->False,
Magnification->1.25,
StyleDefinitions -> "HelpBrowser.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 406, 14, 124, "Chapter",
  CellGroupingRules->"SectionGrouping"],
Cell[2126, 65, 316, 7, 48, "Text"],

Cell[CellGroupData[{
Cell[2467, 76, 47, 0, 56, "Subsection"],
Cell[2517, 78, 309, 6, 67, "Text"],
Cell[2829, 86, 139, 5, 36, "MathCaption"],
Cell[2971, 93, 126, 3, 54, "Input"],
Cell[3100, 98, 67, 0, 36, "MathCaption"],
Cell[3170, 100, 247, 6, 54, "Input"],
Cell[3420, 108, 212, 4, 48, "Text"],
Cell[3635, 114, 60, 0, 36, "MathCaption"],
Cell[3698, 116, 276, 6, 96, "Input"],
Cell[3977, 124, 123, 3, 29, "Text"],

Cell[CellGroupData[{
Cell[4125, 131, 177, 4, 54, "Input"],
Cell[4305, 137, 23571, 538, 230, 4224, 294, "GraphicsData", "PostScript", \
"Graphics"],
Cell[27879, 677, 66, 2, 27, "Output"]
}, Open  ]],
Cell[27960, 682, 489, 7, 113, "Text"],
Cell[28452, 691, 84, 1, 36, "MathCaption"],
Cell[28539, 694, 938, 28, 159, "Input"],
Cell[29480, 724, 116, 3, 36, "MathCaption"],
Cell[29599, 729, 314, 8, 75, "Input"],
Cell[29916, 739, 423, 11, 67, "Text"],
Cell[30342, 752, 208, 4, 55, "MathCaption"],

Cell[CellGroupData[{
Cell[30575, 760, 71, 2, 33, "Input"],
Cell[30649, 764, 60, 2, 27, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[30758, 772, 313, 9, 55, "MathCaption"],
Cell[31074, 783, 83, 2, 50, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[31194, 790, 52, 0, 56, "Subsection"],
Cell[31249, 792, 460, 9, 86, "Text"],

Cell[CellGroupData[{
Cell[31734, 805, 139, 5, 36, "MathCaption"],
Cell[31876, 812, 126, 3, 54, "Input"]
}, Open  ]],
Cell[32017, 818, 67, 0, 36, "MathCaption"],
Cell[32087, 820, 196, 6, 59, "Input"],
Cell[32286, 828, 212, 4, 48, "Text"],
Cell[32501, 834, 60, 0, 36, "MathCaption"],
Cell[32564, 836, 327, 7, 96, "Input"],
Cell[32894, 845, 71, 0, 36, "MathCaption"],

Cell[CellGroupData[{
Cell[32990, 849, 384, 8, 96, "Input"],
Cell[33377, 859, 200, 4, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[33614, 868, 76, 0, 30, "SubsubsectionIcon"],
Cell[33693, 870, 233, 4, 48, "Text"],
Cell[33929, 876, 52, 0, 36, "MathCaption"],

Cell[CellGroupData[{
Cell[34006, 880, 447, 9, 155, "Input"],
Cell[34456, 891, 63, 2, 70, "Output"]
}, Open  ]]
}, Closed]],
Cell[34546, 897, 485, 7, 107, "Text"],
Cell[35034, 906, 77, 0, 36, "MathCaption"],
Cell[35114, 908, 1032, 31, 159, "Input"],
Cell[36149, 941, 116, 3, 36, "MathCaption"],
Cell[36268, 946, 317, 8, 75, "Input"],
Cell[36588, 956, 423, 11, 67, "Text"],
Cell[37014, 969, 157, 3, 55, "MathCaption"],

Cell[CellGroupData[{
Cell[37196, 976, 71, 2, 33, "Input"],
Cell[37270, 980, 60, 2, 27, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[37379, 988, 313, 9, 55, "MathCaption"],
Cell[37695, 999, 83, 2, 50, "Input"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

