(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      8838,        285]*)
(*NotebookOutlinePosition[     10541,        335]*)
(*  CellTagsIndexPosition[     10497,        331]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  "Timer Events from ",
  StyleBox["JavaView",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  "\n",
  StyleBox["\tby Konrad Polthier\n\t",
    FontSize->16],
  StyleBox["(v. 1.03, 14.11.04)",
    FontSize->16,
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}]
}], "Chapter",
  CellGroupingRules->"SectionGrouping",
  TextAlignment->Left],

Cell[TextData[{
  "In this notebook ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " catches timer events issued from the JavaView animation class to \
recompute the position of a satellite orbiting around a torus."
}], "Text"],

Cell[TextData[{
  "To check performance of the event handling we provide two alternative \
methods to let the satellite move.\n1. A simple loop in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is used to trigger the event handling routine directly without any event \
handling in between.\n2. The standard event handling mechanism. The animation \
may be started either by button press in animation panel of JavaView, or in \
share-kernel mode by issueing a command from this notebook. See below."
}], "Text"],

Cell["\<\
Usage: First execute the upper command group with the outer bracket. Then \
scroll down the notebook and execute the commands following the upper outer \
bracket successively.\
\>", "Text"],

Cell[CellGroupData[{

Cell[TextData[{
  "Load Java runtime into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and load JavaView."
}], "MathCaption"],

Cell[BoxData[{
    \(<< JavaView`JLink`\), "\n", 
    \(\(viewer = InstallJavaView[];\)\)}], "Input",
  CellLabel->"(sharing) In[127]:="],

Cell["Create an empty geometry to become the world.", "MathCaption"],

Cell[BoxData[
    \(\(\(geom\  = \ 
        JavaNew["\<jv.geom.PgElementSet\>", 3];\)\(\ \)\)\)], "Input",
  CellLabel->"(sharing) In[129]:="],

Cell["\<\
Compute a sample torus geometry and register it inside the display.\
\>", "MathCaption"],

Cell[BoxData[{\(innerRadius\  = 2. ;\), "\[IndentingNewLine]", \(tubeRadius = 
        1. ;\), "\[IndentingNewLine]", \(geom@
        computeTorus[20, 15, innerRadius, 
          tubeRadius];\), "\[IndentingNewLine]", \(geom@
        setName["\<Torus World\>"];\), "\[IndentingNewLine]", \(geom@
        showTransparency[True];\), "\[IndentingNewLine]", 
    RowBox[{
      RowBox[{
        StyleBox["JavaView",
          FontSlant->"Plain"], "[", "geom", "]"}], ";"}]}], "Input",
  CellLabel->"(sharing) In[130]:="],

Cell["\<\
Get the active JavaView 3d-display to be able to register the satellite \
additionally to the torus geometry.\
\>", "MathCaption"],

Cell[BoxData[
    \(\(disp = viewer@getDisplay[];\)\)], "Input",
  CellLabel->"(sharing) In[136]:="],

Cell["Create another empty geometry to become a satellite.", "MathCaption"],

Cell[BoxData[
    \(\(sat\  = \ JavaNew["\<jv.geom.PgElementSet\>"];\)\)], "Input",
  CellLabel->"(sharing) In[137]:="],

Cell["Compute the satellite and register it inside the display.", \
"MathCaption"],

Cell[BoxData[{
    \(\(LoadClass["\<jvx.geom.PwPlatonic\>"];\)\), "\[IndentingNewLine]", 
    \(\(PwPlatonic`getSolid[sat, 
        PwPlatonic`DODECAHEDRON];\)\), "\[IndentingNewLine]", 
    \(\(sat@setName["\<Satellite\>"];\)\), "\[IndentingNewLine]", 
    \(sat@
      setGlobalElementColor[
        JavaNew["\<java.awt.Color\>", \ 255, 150, 
          0]]\), "\[IndentingNewLine]", 
    \(\(sat@scale[1. /5. ];\)\), "\[IndentingNewLine]", 
    \(\(sat@showVertexNormals[True];\)\), "\[IndentingNewLine]", 
    \(\(sat@showVertices[False];\)\), "\[IndentingNewLine]", 
    \(\(disp@addGeometry[sat];\)\), "\[IndentingNewLine]", 
    \(\(sat@update[sat];\)\)}], "Input",
  CellLabel->"(sharing) In[138]:="],

Cell["\<\
Event handler command invoked from JavaView upon timer events. This method \
calls setTime[time] to do the work.\
\>", "MathCaption"],

Cell["\<\
setTime[evt_,message_] :=
\tJavaBlock[
\t\tsetTime[N[evt]];
\t\tReleaseObject[evt]
\t]
\t
(* Keep this variable outside to avoid frequent allocations. *)
center = JavaNew[\"jv.vecmath.PdVector\",3];
(* Initial number of time steps per flight. (Pending) Should be overwritten \
by settings in the animation panel. *)
numTics = 100;
(* This function will be called upon timer events, or it may be invoked \
directly from Mathematica, see below. *)
setTime[time_] :=
\tJavaBlock[
\t\tir = innerRadius;
\t\ttr = tubeRadius;
\t\theight = tubeRadius/3.; (* Height of Satellite over Torus. *)
\t\tnumUWindings = 1;
\t\tnumZWindings = 13;
\t\tu = time*2.*Pi*numUWindings/(numTics-1.);
\t\tv = time*2.*Pi*numZWindings/(numTics-1.);
\t\tcenter@set[
\t\t\tN[Cos[u]*((tr+tubeRadius/3.)*Cos[v]+ir)],
\t\t\tN[Sin[u]*((tr+tubeRadius/3.)*Cos[v]+ir)],
\t\t\tN[(tr+tubeRadius/3.)*Sin[v]]];
\t\tPwPlatonic`setSolid[sat,PwPlatonic`DODECAHEDRON];
\t\tsat@scale[1./5.];
\t\tsat@translate[center];
\t\tsat@update[Null];
\t]\
\>", "Input",
  CellLabel->"(sharing) In[147]:=",
  PageWidth->WindowWidth,
  ShowSpecialCharacters->False],

Cell[TextData[{
  "The animation panel often appears behind the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " notebook and must be brought to font manually."
}], "Text"],

Cell["Register a listener of timer events.", "MathCaption"],

Cell[BoxData[{
    \(\(listener = 
        JavaNew["\<jvx.math.MathTimerListener\>"];\)\), \
"\[IndentingNewLine]", 
    \(\(listener@
        setHandler["\<setTime\>", "\<setTime\>"];\)\), "\[IndentingNewLine]", \

    \(\(anim\  = \ 
        JavaNew["\<jv.anim.PsAnimation\>"];\)\), "\[IndentingNewLine]", 
    \(\(anim@setName["\<Satellite Animation\>"];\)\), "\[IndentingNewLine]", 
    \(\(anim@addTimeListener[listener];\)\), "\[IndentingNewLine]", 
    \(\(JavaShow[anim@getAnimationPanel[]];\)\)}], "Input",
  CellLabel->"(sharing) In[155]:="],

Cell["\<\
Share the kernel to allow further interaction with the geometry and \
display.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ShareKernel[]\)], "Input",
  CellLabel->"(sharing) In[161]:="],

Cell[BoxData[
    \(7\)], "Output",
  CellLabel->"Out[161]="]
}, Open  ]],

Cell["\<\
When sharing the kernel we can control the animation from this notebook.\
\>", "MathCaption"],

Cell[BoxData[
    \(anim@start[]\)], "Input",
  CellLabel->"(sharing) In[164]:="]
}, Open  ]],

Cell[BoxData[
    \(anim@stop[]\)], "Input",
  CellLabel->"(sharing) In[165]:="],

Cell[CellGroupData[{

Cell["\<\
It is also possible to use a direct invocation of the event handler from a \
Mathematica loop.\
\>", "MathCaption"],

Cell[BoxData[
    \(For[i = 0. , i < numTics, \(i++\), setTime[i]]\)], "Input",
  CellLabel->"(sharing) In[168]:="]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "When done with interaction, then call UnshareKernel[]. After calling \
UnshareKernel[] ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " will no longer receive events from ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " unless ShareKernel[] is called again."
}], "MathCaption"],

Cell[BoxData[
    \(UnshareKernel[]\)], "Input",
  CellLabel->"(sharing) In[169]:="]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1400}, {0, 998}},
ScreenStyleEnvironment->"Brackets",
CellGrouping->Manual,
WindowSize->{814, 917},
WindowMargins->{{Automatic, 9}, {Automatic, 2}},
PageHeaders->{{Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Inherited, Cell[ 
        TextData[ {"Konrad Polthier"}], "PageHeader"]}, {Cell[ 
        TextData[ {"The ", 
          StyleBox[ "JavaView", FontSlant -> "Italic"], " Packages"}], 
        "PageHeader"], Inherited, Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"]}},
PageFooters->{{Inherited, Cell[ 
        TextData[ {
          "\[Copyright]1999 Wolfram Research, Inc. All rights reserved."}], 
        "PageFooter"], Inherited}, {Inherited, Cell[ 
        TextData[ {
          "\[Copyright]1999 Wolfram Research, Inc. All rights reserved."}], 
        "PageFooter"], Inherited}},
PageFooterLines->{True, True},
PrintingOptions->{"PrintingMargins"->{{56.6875, 56.6875}, {56.6875, \
56.6875}},
"PrintCellBrackets"->True,
"PrintRegistrationMarks"->False,
"PrintMultipleHorizontalPages"->False,
"FacingPages"->True},
Magnification->1.25,
StyleDefinitions -> "HelpBrowser.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 403, 14, 124, "Chapter",
  CellGroupingRules->"SectionGrouping"],
Cell[2123, 65, 237, 6, 48, "Text"],
Cell[2363, 73, 522, 9, 102, "Text"],
Cell[2888, 84, 199, 4, 48, "Text"],

Cell[CellGroupData[{
Cell[3112, 92, 139, 5, 36, "MathCaption"],
Cell[3254, 99, 137, 3, 71, "Input"],
Cell[3394, 104, 68, 0, 36, "MathCaption"],
Cell[3465, 106, 142, 3, 50, "Input"],
Cell[3610, 111, 98, 2, 36, "MathCaption"],
Cell[3711, 115, 516, 10, 155, "Input"],
Cell[4230, 127, 140, 3, 36, "MathCaption"],
Cell[4373, 132, 100, 2, 50, "Input"],
Cell[4476, 136, 75, 0, 36, "MathCaption"],
Cell[4554, 138, 119, 2, 50, "Input"],
Cell[4676, 142, 82, 1, 36, "MathCaption"],
Cell[4761, 145, 707, 14, 218, "Input"],
Cell[5471, 161, 143, 3, 55, "MathCaption"],
Cell[5617, 166, 1119, 35, 743, "Input"],
Cell[6739, 203, 182, 5, 29, "Text"],
Cell[6924, 210, 59, 0, 36, "MathCaption"],
Cell[6986, 212, 551, 12, 155, "Input"],
Cell[7540, 226, 109, 3, 36, "MathCaption"],

Cell[CellGroupData[{
Cell[7674, 233, 82, 2, 50, "Input"],
Cell[7759, 237, 61, 2, 27, "Output"]
}, Open  ]],
Cell[7835, 242, 103, 2, 36, "MathCaption"],
Cell[7941, 246, 81, 2, 50, "Input"]
}, Open  ]],
Cell[8037, 251, 80, 2, 50, "Input"],

Cell[CellGroupData[{
Cell[8142, 257, 125, 3, 36, "MathCaption"],
Cell[8270, 262, 115, 2, 50, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8422, 269, 313, 9, 55, "MathCaption"],
Cell[8738, 280, 84, 2, 50, "Input"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

