(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6706,        224]*)
(*NotebookOutlinePosition[      8409,        274]*)
(*  CellTagsIndexPosition[      8365,        270]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  "Listener for 3D Pick Events from ",
  StyleBox["JavaView",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  "\n",
  StyleBox["\tby Konrad Polthier\n\t",
    FontSize->16],
  StyleBox["(v. 0.91, 14.11.04)",
    FontSize->16,
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}]
}], "Chapter",
  CellGroupingRules->"SectionGrouping",
  TextAlignment->Left],

Cell[TextData[{
  "In this notebook ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " catches 3D pick events issued from the JavaView display when a point on a \
geometry is picked while keeping the key-i pressed. The picked point may lie \
in the inside of triangles or polygons."
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[{
  "Load Java runtime into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and load JavaView."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(<< JavaView`JLink`\), "\n", 
    \(\(viewer = InstallJavaView[];\)\)}], "Input",
  CellLabel->"In[1]:="],

Cell[BoxData[
    \("JavaView CodeBase = C:/Programme/Wolfram \
Research/Mathematica/4.0/AddOns/Applications/JavaView/"\)], "Print",
  CellLabel->"From In[1]:="],

Cell["\<\
Get the active JavaView 3d-display to be able to register this notebook as \
pick listener.\
\>", "MathCaption"],

Cell[BoxData[
    \(\(disp = viewer@getDisplay[];\)\)], "Input",
  CellLabel->"In[3]:="],

Cell[CellGroupData[{

Cell["\<\
Compute a sample torus geometry and register it inside the display.\
\>", "MathCaption"],

Cell[BoxData[{
    RowBox[{\(geom\  = \ JavaNew["\<jv.geom.PgElementSet\>", 3];\), 
      " "}], "\[IndentingNewLine]", \(innerRadius\  = 
        2. ;\), "\[IndentingNewLine]", \(tubeRadius = 
        1. ;\), "\[IndentingNewLine]", \(geom@
        computeTorus[20, 15, innerRadius, 
          tubeRadius];\), "\[IndentingNewLine]", \(geom@
        setName["\<Torus World\>"];\), "\[IndentingNewLine]", 
    RowBox[{
      RowBox[{
        StyleBox["JavaView",
          FontSlant->"Plain"], "[", "geom", "]"}], ";"}]}], "Input",
  CellLabel->"In[4]:="]
}, Closed]],

Cell[CellGroupData[{

Cell["Compute the satellite and register it inside the display.", \
"MathCaption"],

Cell[BoxData[{
    \(\(sat\  = \ 
        JavaNew["\<jv.geom.PgElementSet\>"];\)\), "\[IndentingNewLine]", 
    \(\(LoadClass["\<jvx.geom.PwPlatonic\>"];\)\), "\[IndentingNewLine]", 
    \(\(PwPlatonic`getSolid[sat, 
        PwPlatonic`DODECAHEDRON];\)\), "\[IndentingNewLine]", 
    \(\(sat@setName["\<Satellite\>"];\)\), "\[IndentingNewLine]", 
    \(sat@
      setGlobalElementColor[
        JavaNew["\<java.awt.Color\>", \ 255, 150, 
          0]]\), "\[IndentingNewLine]", 
    \(\(sat@scale[1. /5. ];\)\), "\[IndentingNewLine]", 
    \(\(sat@showVertices[false];\)\), "\[IndentingNewLine]", 
    \(\(sat@showVertexNormals[True];\)\), "\[IndentingNewLine]", 
    \(\(disp@addGeometry[sat];\)\), "\[IndentingNewLine]", 
    \(\(sat@update[sat];\)\)}], "Input",
  CellLabel->"In[10]:="]
}, Closed]],

Cell["\<\
This function will be called upon initial-pick events, which are issued when \
the i-key is being pressed while picking a point on the torus geometry with a \
mouse.\
\>", "MathCaption"],

Cell["\<\
pickInitial[pos_,message_]:=
\tJavaBlock[
\t\tIf [pos@getGeometry[] =!= geom, Return[Null]];
\t\tPwPlatonic`setSolid[sat,PwPlatonic`DODECAHEDRON];
\t\tsat@scale[1./5.];
\t\tsat@translate[pos@getVertex[]];
\t\tsat@update[sat];
\t]\
\>", "Input",
  CellLabel->"(sharing) In[28]:=",
  PageWidth->WindowWidth,
  ShowSpecialCharacters->False],

Cell["\<\
Register a listener of pick events. See the documentation of the class \
jvx.math.MathPickListener for further methods, like dragInitial for receiving \
events while the mouse is dragged (while keeping i-key pressed).\
\>", "MathCaption"],

Cell[BoxData[{
    \(\(listener = 
        JavaNew["\<jvx.math.MathPickListener\>"];\)\), "\[IndentingNewLine]", \

    \(\(listener@
        setHandler["\<pickInitial\>", "\<pickInitial\>"];\)\), "\
\[IndentingNewLine]", 
    \(\(listener@
        setHandler["\<dragInitial\>", "\<pickInitial\>"];\)\), "\
\[IndentingNewLine]", 
    \(\(disp@addPickListener[listener];\)\)}], "Input",
  CellLabel->"(sharing) In[24]:="],

Cell["\<\
Share the kernel to allow further interaction with the geometry and \
display.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ShareKernel[]\)], "Input",
  CellLabel->"In[23]:="],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[23]="]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "When done with interaction, then call UnshareKernel[]. After calling \
UnshareKernel[] ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " will no longer receive events from ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " unless ShareKernel[] is called again."
}], "MathCaption"],

Cell[BoxData[
    \(UnshareKernel[]\)], "Input",
  CellLabel->"(sharing) In[29]:="]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1400}, {0, 998}},
ScreenStyleEnvironment->"Brackets",
CellGrouping->Manual,
WindowSize->{950, 934},
WindowMargins->{{Automatic, 9}, {Automatic, 2}},
PageHeaders->{{Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Inherited, Cell[ 
        TextData[ {"Konrad Polthier"}], "PageHeader"]}, {Cell[ 
        TextData[ {"The ", 
          StyleBox[ "JavaView", FontSlant -> "Italic"], " Packages"}], 
        "PageHeader"], Inherited, Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"]}},
PageFooters->{{Inherited, Cell[ 
        TextData[ {
          "\[Copyright]1999 Wolfram Research, Inc. All rights reserved."}], 
        "PageFooter"], Inherited}, {Inherited, Cell[ 
        TextData[ {
          "\[Copyright]1999 Wolfram Research, Inc. All rights reserved."}], 
        "PageFooter"], Inherited}},
PageFooterLines->{True, True},
PrintingOptions->{"PrintingMargins"->{{56.6875, 56.6875}, {56.6875, \
56.6875}},
"PrintCellBrackets"->True,
"PrintRegistrationMarks"->False,
"PrintMultipleHorizontalPages"->False,
"FacingPages"->True},
Magnification->1.25,
StyleDefinitions -> "HelpBrowser.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 418, 14, 124, "Chapter",
  CellGroupingRules->"SectionGrouping"],
Cell[2138, 65, 302, 7, 48, "Text"],

Cell[CellGroupData[{
Cell[2465, 76, 139, 5, 36, "MathCaption"],

Cell[CellGroupData[{
Cell[2629, 85, 125, 3, 54, "Input"],
Cell[2757, 90, 161, 3, 48, "Print"],
Cell[2921, 95, 122, 3, 36, "MathCaption"],
Cell[3046, 100, 88, 2, 33, "Input"],

Cell[CellGroupData[{
Cell[3159, 106, 98, 2, 36, "MathCaption"],
Cell[3260, 110, 553, 12, 138, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[3850, 127, 82, 1, 23, "MathCaption"],
Cell[3935, 130, 789, 16, 222, "Input"]
}, Closed]],
Cell[4739, 149, 196, 4, 42, "MathCaption"],
Cell[4938, 155, 347, 12, 214, "Input"],
Cell[5288, 169, 248, 4, 55, "MathCaption"],
Cell[5539, 175, 420, 11, 113, "Input"],
Cell[5962, 188, 109, 3, 36, "MathCaption"],

Cell[CellGroupData[{
Cell[6096, 195, 71, 2, 33, "Input"],
Cell[6170, 199, 60, 2, 27, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[6291, 208, 313, 9, 55, "MathCaption"],
Cell[6607, 219, 83, 2, 50, "Input"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

