(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    138965,       4410]*)
(*NotebookOutlinePosition[    140116,       4449]*)
(*  CellTagsIndexPosition[    139982,       4442]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " Packages for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "Chapter",
  CellGroupingRules->"SectionGrouping",
  TextAlignment->Center,
  TextJustification->0],

Cell[TextData[StyleBox["Overview", "Text"]], "Text",
  CellGroupingRules->"SectionGrouping",
  TextAlignment->Center,
  TextJustification->0,
  FontSize->14],

Cell[CellGroupData[{

Cell[TextData[StyleBox["\nKonrad Polthier\n17.09.2006, v1.15", "SB"]],
  TextAlignment->Center],

Cell[TextData[{
  "\n\n\n\n\nCopyright (C) 2001-2006 by Konrad Polthier. All rights reserved.\
\n",
  StyleBox["Mathematica", "TI"],
  " and ",
  StyleBox["J/Link", "TI"],
  " are trademarks of Wolfram Research.\nJava and JDK are trademarks of Sun \
Microsystems, Inc.\nUse of the software is bound by the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " license agreement, which is available from the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " website at ",
  ButtonBox["http://www.javaview.de",
    ButtonData:>{
      URL[ "http://www.javaview.de"], None},
    ButtonStyle->"Hyperlink"],
  ".\n[17.09.2006] Typo in Section RunThrough corrected which prevented \
geometry to load, additional quotes around pathname with blanks."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Introduction", "Section"],

Cell[TextData[{
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " is an interactive geometry viewer and a visualization toolkit. Its main \
focus is to supply visualization tools simultaneously for local applications \
as well as interactive online publications. These notes describe how to use \
",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " as an integrated viewer for ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "graphics, as an online publication tool, and as a geometric toolbox to \
enhance ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics. ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " can be used either as an external program using the JavaView`RunThrough` \
package, or fully integrated with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " via J/Link using the JavaView`JLink` package."
}], "Text"],

Cell[TextData[{
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " is designed for end-users and developers. End-users may work with the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " control panels and dialogs, or steer ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " from ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "by calling documented commands from a notebook. Developers may \
additionally access the full functionality of the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " user interface and algorithms via the open programming API of ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " either from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " or from Java. Using ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " requires only little familiarity with Java like the notion of classes and \
methods."
}], "Text"],

Cell[BoxData[
    FormBox[
      StyleBox[
        FrameBox[
          StyleBox[GridBox[{
                {"\<\"\[FilledSmallSquare]  View Mathematica graphics in an \
interactive 3D JavaView display \"\>"},
                {\(\[FilledSmallSquare]\ \ Apply\ transparency, \ 
                  smooth\ shading\ and\ texture\ images\ to\ Mathematica\ \
graphics\)},
                {"\<\"\[FilledSmallSquare]  Write Mathematica programs that \
use pick information from the JavaView display\"\>"},
                {"\<\"\[FilledSmallSquare]  Export Mathematica graphics to a \
variety of file formats (e.g. VRML, Maple, JavaView JVX, STL, OBJ, ...) \
\"\>"},
                {"\<\"\[FilledSmallSquare]  Apply advanced geometry \
algorithms and visualization operations on Mathematica graphics\"\>"},
                {"\<\"\[FilledSmallSquare]  Create webpages and \
webMathematica services with interactive Mathematica graphics \"\>"}
                },
              ColumnAlignments->{Left}],
            GridBoxOptions->{RowLines->False}]],
        "1ColumnBox"], TraditionalForm]], "Text",
  PageWidth->PaperWidth,
  CellMargins->{{Inherited, Inherited}, {2, Inherited}},
  CellFrameMargins->8,
  TextAlignment->Left,
  TextJustification->0,
  FormatType->StandardForm],

Cell[TextData[{
  "Some uses for ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  StyleBox[".",
    FontSlant->"Italic"]
}], "Caption"],

Cell[TextData[{
  "J/Link is an add-on package of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " developed by Todd Gayley allowing realtime interaction between ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and Java programs. It is a great achievement for the seemless integration \
of mathematical software, and I am very excited about the diversity of its \
applications."
}], "Text"],

Cell[TextData[{
  "The two ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " packages JavaView`RunThrough` and JavaView`JLink` extend ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " with interactive 3D visualization functionality and the integration of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics into online publications. The main focus here lies on the \
package JavaView`JLink` which provides simple commands for viewing and \
modifying ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics by making use of the 2-way connection between ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " provided by J/Link. The simpler package JavaView`RunThrough` restricts to \
utility commands to export and view ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics in the classical way via files; it does not need a J/Link \
installation."
}], "Text"],

Cell[TextData[{
  "Note, the commands in both packages are provided as a convenience to \
simplify calling ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  ". For example, experts may directly access the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " classes and methods using J/Link as described in more detail in the \
notebook ",
  ButtonBox["Applications.nb",
    ButtonData:>{"Applications.nb", None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text"],

Cell[TextData[{
  "These tutorial paragraphs are user's notes and provide first steps to use \
",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " as 3D viewer of ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "graphics. The basic ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " keyboard shortcuts are listed at the end of this document."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Requirements", "Section"],

Cell[TextData[{
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " requires ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  ". J/Link is an add-on package of ",
  StyleBox["Mathematica", "TI"],
  " 4.0 or later which is available from Wolfram Research and which is \
compatible with all platforms on which ",
  StyleBox["Mathematica", "TI"],
  " is available. ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " has the same requirements as ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  "Requirements for ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ":"
}], "MathCaption"],

Cell[TextData[{
  "1. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 4.0 or higher."
}], "NumberedEquation"],

Cell[TextData[{
  "2. ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " 2.21 or higher (",
  StyleBox["jv_math.zip",
    FontFamily->"Courier New"],
  " from www.javaview.de/download/ )."
}], "NumberedEquation"],

Cell[TextData[{
  "3. ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " (add-on component, pre-installed with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 4.2 and later)."
}], "NumberedEquation"],

Cell[TextData[{
  "4. Java runtime 1.1 or higher (pre-installed with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 4.2 and later)."
}], "NumberedEquation"],

Cell[TextData[{
  "The ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " package ",
  StyleBox["JavaView`JLink`",
    FontWeight->"Bold"],
  " provides a full integration of ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " with ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "via ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  ". This package requires ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 4.0 or higher and ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " to be installed. ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " must be installed in the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " installation before installing ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  ". ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " comes pre-installed with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 4.2 and higher, and it may be downloaded for version 4.0 and 4.1 for free \
from Wolfram Research. The newest version of ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " can always be obtained from ",
  ButtonBox["http://www.wolfram.com/solutions/mathlink/jlink",
    ButtonData:>{
      URL[ "http://www.wolfram.com/solutions/mathlink/jlink"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text"],

Cell[TextData[{
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " requires a Java runtime that is version 1.1 or later. A Java runtime is \
included in all ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " distributions since ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 4.2. Users of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 4.0 and 4.1 should read the section ",
  ButtonBox["Obtaining Java",
    ButtonData:>"Sect_Obtaining Java",
    ButtonStyle->"Hyperlink"],
  " below to get Java."
}], "Text"],

Cell[TextData[{
  "The ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " package ",
  StyleBox["JavaView`RunThrough`",
    FontWeight->"Bold"],
  " provides only a partial integration of ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " but has the advantage that it runs already with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 3.0 and that it does not require a ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " installation. When using this package then JavaView is able to display ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics but not to provide feedback into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". Although this package does not need an installation of ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " it still requires a Java runtime."
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[{
  "Obtaining Java for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 4.0 and 4.1"
}], "Subsection",
  CellTags->"Sect_Obtaining Java"],

Cell[CellGroupData[{

Cell["Note on Microsoft Windows Java Runtime", "Subsubsection"],

Cell[TextData[{
  "Until end of 2003 most users of Microsoft Windows had a Java runtime \
installed as part their Microsoft Windows operating system. Previous versions \
of the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " packages (before ",
  "JavaView`",
  "JLink` v1.00) used that Microsoft Java runtime by default in order to \
avoid a separate installation process for Java."
}], "Text"],

Cell[TextData[{
  "Since Microsoft dropped all support for their Java runtime and no longer \
delivers a Java runtime with their operating system we decided to drop \
support too. Therefore the command InstallJavaView[] no longer launches the \
Microsoft Java runtime by default but now fully relies on the default \
settings of ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " respectively on the settings of a user."
}], "Text"],

Cell[TextData[{
  "Users who still want to use the Microsoft Java runtime are advised to \
follow the comments given in section ",
  ButtonBox["Using Microsoft Java",
    ButtonData:>"Sect_Using Microsoft Java",
    ButtonStyle->"Hyperlink"],
  "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Obtaining Java (copied from ",
    FontWeight->"Bold"],
  StyleBox["J/Link",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" User Guide, version 2.1.0)",
    FontWeight->"Bold"]
}], "Subsubsection"],

Cell[TextData[{
  "This information about obtaining a Java runtime is primarily for users \
with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 4.0 and 4.1. Beginning with version 4.2, the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " distribution includes its own Java runtime for use by ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  ". An exception to this is the Macintosh, which already has a Java runtime \
suitable for ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell["\<\
Here are some useful links to help you obtain a suitable Java runtime or full \
JDK (Java Development Kit) for your platform. Many systems already have a \
recent Java runtime installed. Try the following command line to see if you \
have Java installed and, if so, what version it is:\
\>", "Text"],

Cell["java -version", "Program"],

Cell["\<\
It is strongly recommended that you get the latest version of Java available \
for your platform. In particular, the jump from the 1.1 to the 1.2 version of \
Java was very significant. You should be using a 1.3 or later version if at \
all possible.\
\>", "Text"],

Cell["\<\
You will sometimes see the abbreviations JRE and JDK when dealing with Java \
distributions. JRE stands for Java Runtime Environment, and JDK stands for \
Java Development Kit. A JRE has just the tools needed to run existing Java \
programs, not compile new ones. If you want to write your own Java language \
programs, you will need the full JDK.\
\>", "Text"],

Cell[TextData[{
  "Java Development Kits are available for free on all platforms that ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " supports."
}], "Text"],

Cell["Microsoft Windows", "Subsubsection"],

Cell[TextData[{
  "Sun and IBM both have excellent Java distributions. Before you download \
one, try the ",
  StyleBox["java -version", "MR"],
  " command; you may already have at least a JRE installed on your machine \
somewhere. ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " has been tested most extensively on Sun\[CloseCurlyQuote]s Java, which is \
currently at version 1.4 and can be obtained from ",
  ButtonBox["http://java.sun.com/j2se",
    ButtonData:>{
      URL[ "http://java.sun.com/j2se"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text"],

Cell["Macintosh", "Subsubsection"],

Cell[TextData[{
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " is available in a native version for Mac OS X. The current version of ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " is not supported on System 8 or 9, although older versions of ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " work. All OS X users already have an appropriate Java installation to run \
",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell["Linux", "Subsubsection"],

Cell[TextData[{
  "Java distributions are available from Blackdown, IBM, and Sun. Some very \
recent Linux distributions include Java, but many users will have to download \
it. Sun\[CloseCurlyQuote]s 1.4 version for Linux is available at ",
  ButtonBox["http://java.sun.com/j2se",
    ButtonData:>{
      URL[ "http://java.sun.com/j2se"], None},
    ButtonStyle->"Hyperlink"],
  ". IBM has an excellent Java for Linux, available at ",
  ButtonBox["http://www.ibm.com/developerworks/java/jdk/index.html",
    ButtonData:>{
      URL[ "http://www.ibm.com/developerworks/java/jdk/index.html"], None},
    ButtonStyle->"Hyperlink"],
  ". The Blackdown version is also popular, and can be obtained from ",
  ButtonBox["http://www.blackdown.org",
    ButtonData:>{
      URL[ "http://www.blackdown.org"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text"],

Cell["Solaris", "Subsubsection"],

Cell[TextData[{
  "Java can be obtained from ",
  ButtonBox["http://www.sun.com/software/solaris/java",
    ButtonData:>{
      URL[ "http://www.sun.com/software/solaris/java"], None},
    ButtonStyle->"Hyperlink"],
  ". The 1.4 version is available now."
}], "Text"],

Cell["AIX", "Subsubsection"],

Cell[TextData[{
  "Java can be obtained from ",
  ButtonBox["http://www.ibm.com/developerworks/java/jdk/aix",
    ButtonData:>{
      URL[ "http://www.ibm.com/developerworks/java/jdk/aix"], None},
    ButtonStyle->"Hyperlink"],
  ". Java versions 1.2.2 and later are available for AIX 4.3.3 and later."
}], "Text"],

Cell["HP-UX", "Subsubsection"],

Cell[TextData[{
  "Java can be obtained from ",
  ButtonBox["http://www.hp.com/products1/unix/java",
    ButtonData:>{
      URL[ "http://www.hp.com/products1/unix/java"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text"],

Cell["HP Tru64 Unix", "Subsubsection"],

Cell[TextData[{
  "Java can be obtained from ",
  ButtonBox["http://www.hp.com/java",
    ButtonData:>{
      URL[ "http://www.hp.com/java"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text"]
}, Closed]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Installing JavaView", "Section"],

Cell[TextData[{
  "The ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " packages for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " include the standard ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " libraries and some documentary notebooks which must be downloaded from \
the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " homepage ",
  ButtonBox["http://www.javaview.de",
    ButtonData:>{
      URL[ "http://www.javaview.de"], None},
    ButtonStyle->"Hyperlink"],
  " and copied to the installation directory of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  "The required libraries for the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " system consists of two Java archives javaview.jar and jvx.jar. If ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " runs within ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", then two initialization files RunThrough.m and JLink.m plus this \
Overview.nb notebook must be available. Optionally, some models, localization \
files, and a tutorial directory with source code for Java programming may be \
downloaded."
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[{
  "Installation of ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ":"
}], "MathCaption"],

Cell["1. Goto http://www.javaview.de/.", "NumberedEquation"],

Cell["2. Goto menu \"Download\".", "NumberedEquation"],

Cell["\<\
3. Download the archive \"jv_math.zip\" to a temporary place, say c:\\tmp.\
\>", "NumberedEquation"],

Cell["\<\
4. Uncompress the archive to a new directory of your choice, say c:\\tmp. \
This will generate a new directory c:\\tmp\\JavaView including \
subdirectories. Assure that uncompression keeps the directory structure and \
is case sensitive on filenames.\
\>", "NumberedEquation"],

Cell[TextData[{
  "5. Move the whole directory c:\\tmp\\",
  "JavaView",
  " to <path to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " dir>\\AddOns\\Applications."
}], "NumberedEquation"]
}, Open  ]],

Cell[TextData[{
  "The directory <path to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " dir>\\AddOns\\Applications\\JavaView\\Java will then contain the",
  StyleBox[" ",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " jar-archives. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " will locate the",
  StyleBox[" ",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " jar-archives automatically, i.e. there is no need to worry about \
classpath settings."
}], "Text"],

Cell[TextData[{
  "Note on uncompression: on MS Windows you may use the program ",
  StyleBox["winzip",
    FontSlant->"Italic"],
  ". On Unix, use the shell command \"unzip -U javaview.zip\" where the \
argument -U ensures that decompression works case sensitive on filenames."
}], "Text"],

Cell[TextData[{
  "Note, for the display of precomputed geometries there exists an additional \
version ",
  StyleBox["jvLite",
    FontSlant->"Italic"],
  " of ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " which is optimized for fast download and startup time (about 150KB). This \
version includes the full display functionality and a number of file loaders \
such as the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " parser, but it does not include the control window, dialogs, or more \
sophisticated geometry classes and algorithms. ",
  StyleBox["jvLite",
    FontSlant->"Italic"],
  " is intended to run as applet showing precomputed geometries inside web \
pages. ",
  StyleBox["jvLite",
    FontSlant->"Italic"],
  " is included with the installation of ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Using Microsoft Java",
  FontWeight->"Bold"]], "Subsection",
  CellTags->"Sect_Using Microsoft Java"],

Cell[TextData[{
  "Previous to ",
  "JavaView`",
  "JLink` 1.00 the default configuration provided by JavaView`JLink` was set \
up to use the Java virtual machine provided by Microsoft. Beginning with ",
  "JavaView`",
  "JLink` 1.00 the default configuration is better synchronized with the \
installation suggested by ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  ". That means, the command ",
  StyleBox["InstallJavaView",
    FontFamily->"Courier New"],
  " calls the ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " command ",
  StyleBox["InstallJava", "MR"],
  " with no arguments and relies on the settings a user has done before \
calling ",
  StyleBox["InstallJavaView",
    FontFamily->"Courier New"],
  ". Especially ",
  StyleBox["InstallJavaView",
    FontFamily->"Courier New"],
  " no longer launches the Microsoft virtual machine by default. "
}], "Text"],

Cell[TextData[{
  "If you determine that you need to use any of the options to ",
  StyleBox["InstallJava", "MR"],
  " on a regular basis, you should put a ",
  StyleBox["SetOptions", "MR"],
  " command in your Mathematica ",
  StyleBox["init.m", "MR"],
  " file. Here are example lines for an ",
  StyleBox["init.m",
    FontFamily->"Courier New"],
  " file for a Windows user who wants to use the Microsoft Java runtime ( the \
file init.m is located in <path to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " dir>\\Configuration\\Kernel\\ ):"
}], "Text"],

Cell["\<\
<<JLink`
SetOptions[InstallJava, ClassPath->None]
SetOptions[InstallJava, CommandLine->wjview]
SetOptions[InstallJava, MicrosoftJava->True]
SetOptions[InstallJava, Java1->True]\
\>", "Program"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Running ",
    FontWeight->"Bold"],
  StyleBox["JavaView",
    FontSlant->"Italic"],
  StyleBox[" via RunThrough",
    FontWeight->"Bold"]
}], "Subsection"],

Cell[TextData[{
  "The package JavaView`RunThrough` accesses ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " by invoking an executable file (MS-Windows) or shell script (Unix) called \
\"javaview\". Using RunThrough simplifies the Java setup since it does not \
use J/Link but it does not provide any feedback from ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " back to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell["\<\
Access to the JavaView executable can be accomplished in different ways:\
\>", "Text"],

Cell[TextData[{
  "If a Microsoft Java runtime is available then the preferred way on MS \
Windows is to use the executable version <path to ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " dir>\\bin\\javaview.exe. Include this executable in your path or move the \
file, for example, into the windows directory (c:\\windows or c:\\winnt). \
Then ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " may be invoked either from the DOS prompt to view models, or from inside \
",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "using RunJavaView[g]. JavaView may also be associated with geometry file \
extensions such as *.mgs using the Windows file association mechanism."
}], "Text"],

Cell[TextData[{
  "An alternative method is the usage of a shell skript respectively batch \
file called \"javaview\" respectively \"javaview.bat\". Either file must be \
in the path such that ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is able to find and launch ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " from within ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". Sample skript and batch files are provided in <path to ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " dir>\\bin both for Unix and MS Windows. Further, you need to edit the \
classpath in these files such that the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " archives are found by the virtual machine."
}], "Text"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Trouble Shooting a ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " Installation"
}], "Section"],

Cell[TextData[{
  "Different reasons may lead to a failure of a ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " installation. Some are related to the installation of the Java runtime \
system, some to the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " package J/Link, and finally some to the installation of ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  ". Here we provide some step by step directions to locate the source of \
trouble. Note, failures appearing in step 1 and 2 of this section are not \
related to ",
  StyleBox["JavaView.",
    FontSlant->"Italic"]
}], "Text"],

Cell[CellGroupData[{

Cell["1. Test Java", "Section"],

Cell[TextData[{
  "This information about obtaining a Java runtime is primarily for users \
with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 4.0 and 4.1. Beginning with version 4.2, the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " distribution includes its own Java runtime. An exception to this is the \
Macintosh, which already has a Java runtime."
}], "Text"],

Cell["\<\
Many systems already have a recent Java runtime installed. Try the following \
command line to see if you have Java installed and, if so, what version it \
is:\
\>", "Text"],

Cell["\<\
From the command line in a DOS window or Unix shell try the following \
command.\
\>", "MathCaption"],

Cell["java -version", "Program"],

Cell[TextData[{
  "If you see a message that ",
  StyleBox["java", "MR"],
  " cannot be found, then you do not have the Java binaries directory on your \
system path. You can either add it to your path in the usual way for your \
platform, or later use the ",
  StyleBox["CommandLine", "MR"],
  " option to ",
  StyleBox["InstallJava", "MR"],
  " to point at the runtime:"
}], "Text"],

Cell[TextData[{
  "If ",
  StyleBox["java -version", "MR"],
  " succeeds, it will print out some version information. This proves that \
the system can find the Java runtime. The version number of Java should be at \
least 1.2. If it is 1.1.x, obtain and install the latest version of Java from \
your operating system vendor. It is strongly recommended that you get the \
latest version of Java available for your platform. In particular, the jump \
from the 1.1 to the 1.2 version of Java was very significant. You should be \
using a 1.3 or later version if at all possible."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["2. Test the J/Link Installation", "Section"],

Cell[TextData[{
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " is a package of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " which provides the link between JavaView and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". J/Link is pre-installed with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 4.2 and later, and it must be obtained and installed separately when \
using the previous versions 4.0 or 4.1 of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell["2.1  Loading the J/Link Package", "Subsection"],

Cell[TextData[{
  "The first step is to load the ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " package file. If you have installed ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  ", you will be able to load the package with the following line:"
}], "Text"],

Cell[BoxData[
    \(Needs["\<JLink`\>"]\)], "Input",
  CellLabel->"In[1]:="]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.2  Version Information", "Subsection"],

Cell[TextData[{
  StyleBox["Check the version number of ",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["J/Link",
    FontSlant->"Italic"],
  ". You must need J/Link v2.0.0 or higher.",
  " "
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox["JLink`Information`$Version",
              "MR"], 
            StyleBox[\(a\ string\ giving\ full\ version\ information\),
              "Text"]}
          }], TextForm]], "DefinitionBox",
  FormatType->StandardForm],

Cell[TextData[{
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " version information."
}], "Caption"],

Cell["Check the version number of J/Link.", "MathCaption"],

Cell[BoxData[
    \(JLink`Information`$Version\)], "Input",
  CellLabel->"In[1]:="]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.3 InstallJava", "Subsection"],

Cell[TextData[{
  "The next step is to launch the Java runtime and \
\[OpenCurlyDoubleQuote]install\[CloseCurlyDoubleQuote] it into ",
  StyleBox["Mathematica", "TI"],
  ". The function for this is ",
  StyleBox["InstallJava", "MR"],
  StyleBox[".", "MR",
    FontFamily->"Arial"]
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[\(InstallJava[]\),
              "MR"], Cell[TextData[{
              "launch the Java runtime and prepare it for use from ",
              StyleBox["Mathematica",
                FontSlant->"Italic"]
            }], "Text",
              CellTags->"jlug:5.2.2.1"]}
          }], TextForm]], "DefinitionBox"],

Cell["Launching the Java runtime.", "Caption"],

Cell["Check if J/Link can be loaded.", "MathCaption"],

Cell[BoxData[
    \(InstallJava[]\)], "Input",
  CellLabel->"In[2]:="],

Cell[TextData[{
  "If ",
  StyleBox["InstallJava", "MR"],
  " succeeds, it will return a ",
  StyleBox["LinkObject", "MR"],
  ". The most common failure mode is that ",
  StyleBox["InstallJava", "MR"],
  " does not return. If this happens, use the ",
  StyleBox["Kernel/Abort Evaluation", "SR"],
  " menu command to abort the call. If you have ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 4.2 or later, then ",
  StyleBox["InstallJava[]", "MR"],
  " should work when called with the default options. If it fails, make sure \
that you have not altered the default installation of ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " by, for example, moving files out of the ",
  StyleBox["JLink", "MR"],
  " directory tree.\nIf ",
  StyleBox["InstallJava", "MR"],
  " fails with an error message that the class ",
  StyleBox["com.wolfram.jlink\\Install", "MR"],
  StyleBox[" cannot be found then you probably use v4.0 or v4.0 and the \
classpath does not include jlink.jar. Please, consult the installation \
section in of J/Link.",
    FontVariations->{"CompatibilityType"->0}]
}], "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3. Test the JavaView Installation", "Section"],

Cell[TextData[{
  StyleBox["The package ",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["JavaView`",
    FontSlant->"Italic"],
  "JLink` is an Add-On component of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " which must be installed separately after a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " installation. Since ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " relies on a working Java runtime and J/Link installation, the following \
steps assume that step 1 and 2 of this section have been checked."
}], "Text"],

Cell[CellGroupData[{

Cell["3.1  Loading the JavaView Package", "Subsection"],

Cell[TextData[{
  "The first step is to load the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " package file. If you have installed ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  ", you will be able to load the package with the following line:"
}], "Text"],

Cell[BoxData[
    \(<< JavaView`JLink`\)], "Input",
  CellLabel->"In[1]:="]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.2 Invoking JavaView", "Subsection"],

Cell[TextData[{
  "The next step is to launch the Java runtime and \
\[OpenCurlyDoubleQuote]install\[CloseCurlyDoubleQuote] it into ",
  StyleBox["Mathematica", "TI"],
  ". The function for this is ",
  StyleBox["InstallJava", "MR"],
  StyleBox[".", "MR",
    FontFamily->"Arial"]
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[\(InstallJavaView[]\),
              "MR"], 
            RowBox[{
              RowBox[{Cell[TextData[{
                  
                  "launch the Java runtime and prepare JavaView for use from \
",
                  StyleBox["Mathematica",
                    FontSlant->"Italic"]
                }], "Text",
                  CellTags->"jlug:5.2.2.1"], 
                StyleBox[".",
                  FontSlant->"Plain"], 
                StyleBox[" ",
                  FontSlant->"Plain"], 
                StyleBox["The",
                  FontSlant->"Plain"]}], 
              StyleBox[" ",
                FontSlant->"Plain"], 
              StyleBox["command",
                FontSlant->"Plain"], 
              StyleBox[" ",
                FontSlant->"Plain"], 
              StyleBox["returns",
                FontSlant->"Plain"], 
              StyleBox[" ",
                FontSlant->"Plain"], 
              StyleBox["the",
                FontSlant->"Plain"], 
              StyleBox[" ",
                FontSlant->"Plain"], 
              StyleBox["viewer",
                FontSlant->"Plain"], 
              StyleBox[" ",
                FontSlant->"Plain"], 
              StyleBox["manager",
                FontSlant->"Plain"], 
              StyleBox[" ",
                FontSlant->"Plain"], 
              StyleBox["of",
                FontSlant->"Plain"], 
              StyleBox[" ",
                FontSlant->"Plain"], 
              RowBox[{
                StyleBox["JavaView",
                  FontSlant->"Italic"], 
                StyleBox[".",
                  FontSlant->"Plain"]}]}]}
          }], TextForm]], "DefinitionBox"],

Cell["Launching the Java runtime.", "Caption"],

Cell["Check if JavaView can be loaded.", "MathCaption"],

Cell[BoxData[
    \(viewer = InstallJavaView[]\)], "Input",
  CellLabel->"In[2]:="]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.3 Show the JavaView Display", "Subsection"],

Cell[TextData[{
  "If the installation steps above worked fine, then the command JavaView[g] \
opens a JavaView display showing the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics as an interactive 3D geometry."
}], "Text"],

Cell["Create a sample geometry and view it in a JavaView display.", \
"MathCaption"],

Cell[BoxData[{\(<< 
      Graphics`Polyhedra`\), "\n", \(dode = \ 
        Graphics3D[Dodecahedron[]];\), "\[IndentingNewLine]", 
    RowBox[{
      StyleBox["JavaView",
        FontSlant->"Plain"], "[", "dode", "]"}]}], "Input",
  CellLabel->"In[3]:="]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Using JavaView`RunThrough`", "Section"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " can launch external programs using the RunThrough[] command and feed them \
with data via the pipe mechanism. For example, this allows to launch the \
JavaView system and pass a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics object or animation to JavaView. JavaView then starts reading \
the data from stdin."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["RunJavaView",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                FormBox["g",
                  "TraditionalForm"],
                "TI"], 
              StyleBox["]",
                
                "MR"]}], \(invoke\ JavaView\ as\ external\ program\ to\ view\ \
a\ Mathematica\ \(\(graphics\)\(.\)\)\)},
          {
            RowBox[{
              StyleBox["RunJavaView",
                FontFamily->"Courier"], 
              StyleBox["[",
                FontFamily->"Courier"], 
              RowBox[{"{", 
                RowBox[{
                  StyleBox[\(g\_1\),
                    "InlineFormula",
                    FontSlant->"Italic"], 
                  StyleBox[",",
                    FontSlant->"Italic"], 
                  StyleBox[\(g\_2\),
                    "InlineFormula",
                    FontSlant->"Italic"], ",", " ", "..."}], " ", "}"}], 
              StyleBox["]",
                
                FontFamily->
                  "Courier"]}], \(show\ several\ Mathematica\ graphics\ \
together\ in\ \(\(JavaView\)\(.\)\)\)},
          {
            RowBox[{
              StyleBox["RunJavaView",
                FontFamily->"Courier"], 
              StyleBox["[",
                FontFamily->"Courier"], 
              RowBox[{
                RowBox[{
                  StyleBox["{",
                    FontSlant->"Italic"], 
                  RowBox[{
                    StyleBox[\(g\_1\),
                      "InlineFormula",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      FontSlant->"Italic"], 
                    StyleBox[\(g\_2\),
                      "InlineFormula",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      FontSlant->"Italic"], 
                    StyleBox[" ",
                      FontSlant->"Italic"], 
                    StyleBox["...",
                      FontSlant->"Italic"]}], 
                  StyleBox[" ",
                    FontSlant->"Italic"], 
                  StyleBox["}",
                    FontSlant->"Italic"]}], 
                StyleBox[",",
                  FontSlant->"Italic"], 
                StyleBox["\n",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontSlant->"Italic"], 
                StyleBox[\(Animatable -> True\),
                  FontSlant->"Italic"]}], 
              StyleBox["]",
                FontFamily->"Courier",
                FontSlant->"Italic"]}], 
            RowBox[{
            "show", " ", "a", " ", "list", " ", "of", " ", "geometries", " ", 
              
              RowBox[{"{", 
                RowBox[{
                  StyleBox[\(g\_1\),
                    "InlineFormula",
                    FontSlant->"Italic"], 
                  StyleBox[",",
                    FontSlant->"Italic"], 
                  StyleBox[\(g\_2\),
                    "InlineFormula",
                    FontSlant->"Italic"], 
                  StyleBox[",",
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    FontSlant->"Italic"], 
                  StyleBox["...",
                    FontSlant->"Italic"]}], "}"}], " ", "as", " ", "smooth", 
              " ", "animation", " ", "in", " ", 
              RowBox[{"JavaView", 
                StyleBox[" ",
                  FontSlant->"Italic"], 
                StyleBox[".",
                  FontSlant->"Italic"]}]}]},
          {
            RowBox[{
              StyleBox["WriteMgs",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                FormBox[\(g, \ file\),
                  "TraditionalForm"],
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            
            StyleBox[\(save\ a\ Mathematica\ graphics\ to\ a\ \(\(file\)\(.\)\
\)\),
              "Text"]},
          {
            RowBox[{
              StyleBox["WriteMgs",
                FontFamily->"Courier"], 
              StyleBox["[",
                FontFamily->"Courier"], 
              RowBox[{
                RowBox[{
                  StyleBox["{",
                    FontSlant->"Italic"], 
                  RowBox[{
                    StyleBox[\(g\_1\),
                      "InlineFormula",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      FontSlant->"Italic"], 
                    StyleBox[\(g\_2\),
                      "InlineFormula",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      FontSlant->"Italic"], 
                    StyleBox[" ",
                      FontSlant->"Italic"], 
                    StyleBox["...",
                      FontSlant->"Italic"]}], 
                  StyleBox[" ",
                    FontSlant->"Italic"], 
                  StyleBox["}",
                    FontSlant->"Italic"]}], 
                StyleBox[",",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontSlant->"Italic"], 
                StyleBox["file",
                  FontSlant->"Italic"]}], 
              StyleBox["]",
                
                FontFamily->
                  "Courier"]}], \(save\ several\ graphics\ to\ a\ \
\(\(file\)\(.\)\)\)},
          {
            RowBox[{
              StyleBox["WriteAnim",
                FontFamily->"Courier"], 
              StyleBox["[",
                FontFamily->"Courier"], 
              RowBox[{
                RowBox[{
                  StyleBox["{",
                    FontSlant->"Italic"], 
                  RowBox[{
                    StyleBox[\(g\_1\),
                      "InlineFormula",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      FontSlant->"Italic"], 
                    StyleBox[\(g\_2\),
                      "InlineFormula",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      FontSlant->"Italic"], 
                    StyleBox[" ",
                      FontSlant->"Italic"], 
                    StyleBox["...",
                      FontSlant->"Italic"]}], 
                  StyleBox[" ",
                    FontSlant->"Italic"], 
                  StyleBox["}",
                    FontSlant->"Italic"]}], 
                StyleBox[",",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontSlant->"Italic"], 
                StyleBox["file",
                  FontSlant->"Italic"]}], 
              StyleBox["]",
                FontFamily->"Courier",
                FontColor->GrayLevel[
                0]]}], \(save\ a\ list\ of\ graphics\ as\ animation\ to\ a\ \
\(\(file\)\(.\)\)\)},
          {
            RowBox[{
              StyleBox["WriteHtml",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[\(g, \ file\),
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            
            StyleBox[\(create\ an\ Html\ page\ to\ show\ a\ Mathematica\ \
graphics\ in\ a\ JavaView\ \(\(applet\)\(.\)\)\),
              "Text"]},
          {
            RowBox[{
              StyleBox["FormatGraphics",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["g",
                FontSlant->"Italic"], 
              StyleBox["]",
                
                "MR"]}], \(internal\ helper\ routine\ to\ format\ a\ \
Mathematica\ graphics\ into\ a\ \(\(string\)\(.\)\)\)}
          }], NotebookDefault]], "DefinitionBox",
  TextAlignment->Left,
  GridBoxOptions->{ColumnAlignments->{Right, Left}}],

Cell["Invoking JavaView via RunThrough.", "Caption"],

Cell[TextData[{
  "A drawback of using RunThrough is the missing feedback ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is able to obtain from user interaction in ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  ". Further, on some operating systems the RunThrough[] command blocks the \
kernel until ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " exists.\nWe provide the RunThrough mechanism because of its simplicity \
but encourage advanced users to use our J/Link-based package JavaView`JLink`. \
The commands in the package JavaView`RunThrough` are available in the package \
JavaView`JLink` too."
}], "Text"],

Cell["Load the package JavaView`RunThrough`. ", "MathCaption"],

Cell[BoxData[
    \(<< JavaView`RunThrough`\)], "Input",
  CellLabel->"In[1]:="],

Cell["Show a sample cube in a JavaView display. ", "MathCaption"],

Cell[BoxData[{
    \(\(cube\  = \ Graphics3D[Cuboid[{0, 0, 0}, {5, 2, 1}]];\)\), "\n", 
    \(RunJavaView[cube]\)}], "Input",
  CellLabel->"In[4]:="],

Cell["Some options. ", "MathCaption"],

Cell[BoxData[
    \(Options[RunJavaView]\)], "Input",
  CellLabel->"In[6]:="],

Cell[TextData[{
  "A list of geometries of the same type are displayed in ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " either as a collection of individual geometries or as an animation of a \
single geometry."
}], "Text"],

Cell[TextData[{
  "Display a list of cuboids in an external ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " display as a set of individual ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " geometries."
}], "MathCaption"],

Cell[BoxData[{
    \(\(randCube\  := \ 
        Cuboid[10 {Random[], Random[], 
              Random[]}];\)\), "\[IndentingNewLine]", 
    \(\(cubes\  = \ 
        Table[Graphics3D[randCube], {20}];\)\), "\[IndentingNewLine]", 
    \(\(RunJavaView[cubes];\)\)}], "Input",
  CellLabel->"In[7]:="],

Cell["\<\
Display the same list of cuboids as an animation of a single cube.\
\>", "MathCaption"],

Cell[BoxData[
    \(\(RunJavaView[cubes, \ Animatable \[Rule] True];\)\)], "Input",
  CellLabel->"In[10]:="],

Cell["\<\
Here is the smooth animation of a catenoid deforming into a helicoid.\
\>", "MathCaption"],

Cell[BoxData[{
    \(\(numFrames\  = \ 2;\)\), "\[IndentingNewLine]", 
    \(anim = 
      Table[\ ParametricPlot3D[\[IndentingNewLine]{Cos[t]\ Cos[x]\ Cosh[y] + 
              Sin[t]\ Sin[x]\ Sinh[y], \[IndentingNewLine]\(-Cos[t]\)\ Sin[
                  x]\ Cosh[y] + 
              Sin[t]\ Cos[x]\ Sinh[y], \[IndentingNewLine]Cos[t]\ y + 
              Sin[t]\ x}, {x, \(-Pi\), Pi}, {y, \(-Pi\)/2, 
            Pi/2}, \[IndentingNewLine]AspectRatio -> Automatic, 
          Boxed -> False, Axes -> False, 
          PlotPoints\  -> \ {13, 
              7}, \[IndentingNewLine]PlotRange -> {{\(-3\), 3}, {\(-3\), 
                3}, {\(-4\), 4}}], {t, 0. , 
          Pi/2. , \(Pi/2. \)/\((numFrames - 1)\)}]\)}], "Input",
  CellLabel->"In[11]:=",
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity],

Cell["Show a list of surfaces as smooth animation.", "MathCaption"],

Cell[BoxData[
    \(RunJavaView[anim, \ Animatable \[Rule] True]\)], "Input",
  CellLabel->"In[13]:="],

Cell[CellGroupData[{

Cell["Command RunJavaView[g]", "Subsection"],

Cell[TextData[{
  "The command RunJavaView[g] launches",
  StyleBox[" ",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " to display a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics object. The graphics object may be of type Graphics, Graphics3D, \
SurfaceGraphics, and others. \nOn some operating systems, this command blocks \
further execution of the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernel until ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " exits. In this case, during the life time of the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " process the kernel is waiting for ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " to exit."
}], "Text"],

Cell[TextData[{
  "Create a sample ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics and invoke ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " for display. "
}], "MathCaption"],

Cell[BoxData[
    \(\(geom\  = \ 
        Plot3D[Sin[x*\ y], \ {x, 0, Pi}, \ {y, \ 0, Pi}];\)\)], "Input",
  CellLabel->"In[27]:="],

Cell[BoxData[
    \(RunJavaView[geom]\)], "Input",
  CellLabel->"In[28]:="],

Cell[TextData[{
  StyleBox["RunJavaView",
    FontFamily->"Courier New"],
  " invokes the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " command ",
  StyleBox["RunThrough",
    FontFamily->"Courier New"],
  " which launches \"javaview\" as an external process using a Java \
installation. Therefore, the path to the 'java' exectuable must be set such \
that ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is able to find it. Further, the command ",
  StyleBox["RunJavaView",
    FontFamily->"Courier New"],
  " converts a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics into InputForm and replaces the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " specific floating point representation of numbers with conventional C \
form to simplify the parsing process in ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  StyleBox["The ",
    FontFamily->"Courier New"],
  StyleBox["JavaView",
    FontFamily->"Courier New",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontFamily->"Courier New"],
  "archives ",
  StyleBox["./Java/*.jar",
    FontSlant->"Italic"],
  " are searched relative to the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " installation directory:"
}], "MathCaption"],

Cell[BoxData[
    \(GetInstallationPath[]\)], "Input",
  CellLabel->"In[14]:="],

Cell[TextData[{
  "Experts Only: How to launch ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " by hand?"
}], "Subsubsection"],

Cell[TextData[{
  "Experts may directly use the command ",
  StyleBox["RunThrough",
    FontFamily->"Courier New"],
  " but should ensure that the number representation in the graphics object \
are correctly formatted. ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " requires data in InputForm. Note, that it is necessary to adjust the path \
to ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  ".\nThe handling of directory and filenames with blanks was changed in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 5.2 under MS-Windows. Therefore additional quotes have been added around \
codebase."
}], "Text"],

Cell[TextData[{
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " codebase from package installation."
}], "MathCaption"],

Cell[BoxData[
    \(jvCB = 
      StringReplace[
        GetInstallationPath[], $PathnameSeparator \[Rule] "\</\>"]\)], "Input",\

  CellLabel->"In[17]:="],

Cell[TextData[{
  "Enclose in extra quotes since ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 5.2 now handles blanks in filenames differently under MS-Windows."
}], "MathCaption"],

Cell[BoxData[
    \(\(jvCB = "\<\"\>" <> jvCB <> "\<\"\>";\)\)], "Input"],

Cell[TextData[{
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " archives (here only javaview.jar is specified)."
}], "MathCaption"],

Cell[BoxData[
    \(jvJARS = jvCB <> "\<Java/javaview.jar\>"\)], "Input",
  CellLabel->"In[18]:="],

Cell[TextData[{
  "Combine the Java runtime with ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " archives and options."
}], "MathCaption"],

Cell[BoxData[
    \(jvCmd = "\<java -cp \>" <> 
        jvJARS <> "\< javaview file=stdin format=mgs codebase=\>" <> 
        jvCB\)], "Input",
  CellLabel->"In[19]:="],

Cell[TextData[{
  "Convert ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  "graphics to InputForm and launch JavaView."
}], "MathCaption"],

Cell[BoxData[
    \(\(fmtGeom = 
        InputForm[
          N[geom] /. x_Real \[RuleDelayed] CForm[Chop[x]]];\)\)], "Input",
  CellLabel->"In[23]:="],

Cell[TextData[{
  "Launch ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " to display ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  "graphics."
}], "MathCaption"],

Cell[BoxData[
    \(RunThrough[jvCmd, fmtGeom]\)], "Input",
  CellLabel->"In[29]:="],

Cell[TextData[{
  "Experts may insert changes to this setup in the package ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  "`RunThrough`."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Command WriteMgs[g, file]", "Subsection"],

Cell[TextData[{
  "WriteMgs[g,file] saves a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics in the given file, which may later be viewed with ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " using the shell command 'javaview file'. The filename may specify a file \
relative to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " or may be an absolute path. The command uses FormatGraphics[g] to convert \
the graphics object into a formatted string.\nThe saved file may later be \
viewed from command line using 'javaview myDode.mgs' or loaded into a running \
",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " from the File-Open menu."
}], "Text"],

Cell[BoxData[{
    \(<< Graphics`Polyhedra`\), "\n", 
    \(\(dode = \ Graphics3D[Dodecahedron[]];\)\)}], "Input",
  CellLabel->"In[30]:="],

Cell[BoxData[
    \(GetWorkingPath[]\)], "Input",
  CellLabel->"In[32]:="],

Cell["\<\
Saving a sample graphics as ASCII file relative to the working path.\
\>", "MathCaption"],

Cell[BoxData[{
    \(\(fileName\  = \ "\<models\\mgs\\myDode.mgs\>";\)\), "\
\[IndentingNewLine]", 
    \(WriteMgs[dode, fileName]\)}], "Input",
  CellLabel->"In[33]:="],

Cell[TextData[{
  "Re-import the previously saved geometry file as a regular ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics. There is no difference between the original \"cube\" and \
\"importCube\"."
}], "MathCaption"],

Cell[BoxData[{
    \(\(importDode\  = \ 
        Get[GetWorkingPath[] <> fileName];\)\), "\[IndentingNewLine]", 
    \(\(Show[importDode];\)\), "\[IndentingNewLine]", 
    \(RunJavaView[importDode]\)}], "Input",
  CellLabel->"In[35]:="]
}, Open  ]],

Cell[CellGroupData[{

Cell["Command WriteAnim[{g1, g2, ... },file]", "Subsection"],

Cell[TextData[{
  "WriteAnim[{g1, g2, ... },file] saves a list of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics as animation in the given file, which may later be viewed with \
JavaView using the shell command 'javaview file'. The filename may specify a \
file relative to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " or may be an absolute path. The command uses FormatGraphics[g] to convert \
the graphics objects into a formatted string."
}], "Text"],

Cell[TextData[{
  "The saved file may later be viewed from the DOS command line using \
'javaview c:\\myAnim.mgs' or loaded into a running ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " from the File-Open menu."
}], "Text"],

Cell[TextData[{
  "Create a list of cuboids in an external ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " display as a set of individual ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " geometries."
}], "MathCaption"],

Cell[BoxData[{
    \(rcoord := {Random[], Random[], Random[]}\), "\[IndentingNewLine]", 
    \(\(cubeAnim\  = \ 
        Table[Graphics3D[Cuboid[10  rcoord]], {i, 1, 3}];\)\)}], "Input",
  CellLabel->"In[40]:="],

Cell["\<\
Save the cuboids as animation in a geometry file cuboidAnim.mgs relative to \
the working path.\
\>", "MathCaption"],

Cell[BoxData[{
    \(\(fileName\  = \ "\<models/mgs/cubeAnim.mgs\>";\)\), "\
\[IndentingNewLine]", 
    \(WriteAnim[cubeAnim, fileName]\)}], "Input",
  CellLabel->"In[44]:="],

Cell[TextData[{
  "As a test, load the previously saved animation back and playback in ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  ". "
}], "MathCaption"],

Cell[BoxData[{
    \(<< Graphics`Animation`\), "\[IndentingNewLine]", 
    \(\(testAnim = Get[GetWorkingPath[] <> fileName];\)\)}], "Input",
  CellLabel->"In[49]:="],

Cell[TextData[{
  "The command ",
  StyleBox["WriteAnim",
    FontFamily->"Courier New"],
  " saves an animation using the command ",
  StyleBox["ShowAnimation",
    FontFamily->"Courier New"],
  "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Command WriteHtml[g,file]", "Subsection"],

Cell[TextData[{
  "The following commands save a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics in a web page with a ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " applet. This web page may be opened in a web browser, or published on a \
web site."
}], "Text"],

Cell[TextData[{
  "WriteHtml[g,file] creates a Html page showing the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics as interactive ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " applet. The method uses FormatGraphics[g] to avoid very long lines which \
are anoying to web designers who postprocess the file. The filename may \
specify a file relative to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " or may be an absolute path.\nNote, the applet contains no codebase \
setting. Either the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " archives must be included in the classpath or manually added in a \
codebase directive of this applet."
}], "Text"],

Cell["Generate a cuboid as working example.", "MathCaption"],

Cell[BoxData[
    \(\(cube\  = \ 
        Graphics3D[Cuboid[{5, 2, 1}], 
          PlotLabel \[Rule] "\<Cuboid\>"];\)\)], "Input",
  CellLabel->"In[54]:="],

Cell[TextData[{
  "Create an Html page which displays the cuboid in a ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " applet relative to the working path. The web page can be opened in any \
web browser."
}], "MathCaption"],

Cell[BoxData[
    \(WriteHtml[cube, "\<html\\myCube.html\>"]\)], "Input",
  CellLabel->"In[55]:="],

Cell[TextData[{
  "Note, it is essential to have a ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " installation in the target directory unless the path options of \
WriteHtml[] are adjusted as explained below."
}], "Text"],

Cell[TextData[{
  "The commands presented in this section are rather simple but very \
convenient in the daily use of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " if J/Link is not available, or if no feedback from ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " is needed. The following section gives a glimps of the tight integration \
J/Link offers for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell["Adjusting the Codebase of Applet", "Subsubsection"],

Cell[TextData[{
  "The ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " applet in the Html page needs the Java library 'javaview.jar' which \
contains the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " viewer. A web browser finds the location of the library by concatenating \
two string attributes of the applet: codebase and archive. The codebase \
attribute may either be an absolute or relative URL, and the archive \
attribute is a relative URL. If the codebase attribute is a relative URL then \
it is relative to the URL of the Html page.\nThe option \"Codebase\" \
specifies the codebase attribute of the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " applet. The codebase attribute is \"./\" on default, i.e. it refers to \
the directory of the Html page."
}], "Text"],

Cell[TextData[{
  "The option \"PathToArchive\" specifies the path of the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " archive relative to the codebase of the applet. A default installation of \
JavaView in a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " installation puts the Java archive to <<mathematica \
root>>\\AddOns\\Applications\\JavaView\\Java\\javaview.jar, and the default \
value of PathToArchive is \"Java/\".\nThe path name separators in the archive \
attributes must always be a slash \"/\". "
}], "Text"],

Cell["\<\
Save the web page in a non-standard directory and adjust the codebase and \
archive attributes of the applet.\
\>", "MathCaption"],

Cell[BoxData[{
    \(\(htmlFile\  = \ "\<html\\myCube.html\>";\)\), "\[IndentingNewLine]", 
    \(\(codebase\  = \ "\<../\>";\)\), "\[IndentingNewLine]", 
    \(\(archive = \ "\<Java/\>";\)\), "\[IndentingNewLine]", 
    \(WriteHtml[cube, htmlFile, Codebase \[Rule] codebase, 
      PathToArchive \[Rule] archive]\)}], "Input",
  CellLabel->"In[48]:="],

Cell[TextData[{
  "Note, if the web page is published on a web site, then the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " archives in .\\Java must be published as well."
}], "Text"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Using JavaView`JLink`", "Section"],

Cell[TextData[{
  StyleBox["JavaView",
    FontSlant->"Italic"],
  "`JLink is a powerful add-on package to enable the tight integration \
between ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  ".",
  " The package ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  "`JLink` makes use of the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " package J/Link. In this section we introduce two simple commands to \
easily setup an initialial connection, and then explore in more detail the \
interaction possibilities. "
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[\(InstallJavaView[]\),
              "MR",
              FontFamily->"Courier New",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontColor->GrayLevel[0],
              FontVariations->{"Underline"->False,
              "StrikeThrough"->False}], 
            RowBox[{
            "launch", " ", "the", " ", "Java", " ", "runtime", " ", "and", 
              " ", "prepare", " ", "it", " ", "for", " ", "use", " ", "from", 
              " ", \(Mathematica . \ Create\), " ", "a", " ", 
              StyleBox["JavaView",
                FontSlant->"Italic"], " ", "viewer", " ", "manager", " ", 
              "and", " ", "preload", " ", "some", " ", "static", 
              " ", \(\(classes\)\(.\)\)}]},
          {
            RowBox[{
              StyleBox["JavaView",
                FontFamily->"Courier New",
                FontSize->12,
                FontWeight->"Plain",
                FontSlant->"Plain",
                FontColor->GrayLevel[0],
                FontVariations->{"Underline"->False,
                "StrikeThrough"->False,
                "CompatibilityType"->0}], 
              StyleBox["[",
                "MR",
                FontFamily->"Courier New",
                FontSize->12,
                FontWeight->"Plain",
                FontSlant->"Plain",
                FontColor->GrayLevel[0],
                FontVariations->{"Underline"->False,
                "StrikeThrough"->False}], 
              StyleBox[
                FormBox["g",
                  "TraditionalForm"],
                "TI",
                FontFamily->"Courier New",
                FontSize->12,
                FontWeight->"Plain",
                FontSlant->"Plain",
                FontColor->GrayLevel[0],
                FontVariations->{"Underline"->False,
                "StrikeThrough"->False}], 
              StyleBox["]",
                "MR",
                FontFamily->"Courier New",
                FontSize->12,
                FontWeight->"Plain",
                FontSlant->"Plain",
                FontColor->GrayLevel[0],
                FontVariations->{"Underline"->False,
                "StrikeThrough"->False}]}], 
            RowBox[{
            "show", " ", "a", " ", "Mathematica", " ", "graphics", " ", "in", 
              " ", "a", " ", 
              StyleBox["JavaView",
                FontSlant->"Italic"], " ", \(display . \ The\), " ", "same", 
              " ", "command", " ", "accepts", " ", 
              StyleBox["JavaView",
                FontSlant->"Italic"], " ", "geometries", 
              " ", \(\(too\)\(.\)\)}]},
          {
            RowBox[{
              StyleBox["JavaView",
                FontFamily->"Courier",
                FontSize->12,
                FontWeight->"Plain",
                FontSlant->"Plain",
                FontColor->GrayLevel[0],
                FontVariations->{"Underline"->False,
                "StrikeThrough"->False,
                "CompatibilityType"->0}], 
              StyleBox["[",
                FontFamily->"Courier",
                FontSize->12,
                FontWeight->"Plain",
                FontSlant->"Plain",
                FontColor->GrayLevel[0],
                FontVariations->{"Underline"->False,
                "StrikeThrough"->False}], 
              RowBox[{
                StyleBox["{",
                  FontFamily->"Courier New",
                  FontSize->12,
                  FontWeight->"Plain",
                  FontSlant->"Italic",
                  FontColor->GrayLevel[0],
                  FontVariations->{"Underline"->False,
                  "StrikeThrough"->False}], 
                RowBox[{
                  StyleBox[\(g\_1\),
                    "InlineFormula",
                    FontSlant->"Italic"], 
                  StyleBox[",",
                    FontSlant->"Italic"], 
                  StyleBox[\(g\_2\),
                    "InlineFormula",
                    FontSlant->"Italic"], 
                  StyleBox[",",
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    FontSlant->"Italic"], 
                  StyleBox["...",
                    FontSlant->"Italic"]}], 
                StyleBox[" ",
                  FontSlant->"Italic"], 
                StyleBox["}",
                  FontFamily->"Courier New",
                  FontSize->12,
                  FontWeight->"Plain",
                  FontSlant->"Italic",
                  FontColor->GrayLevel[0],
                  FontVariations->{"Underline"->False,
                  "StrikeThrough"->False}]}], 
              StyleBox["]",
                FontFamily->"Courier",
                FontSize->12,
                FontWeight->"Plain",
                FontSlant->"Plain",
                FontColor->GrayLevel[0],
                FontVariations->{"Underline"->False,
                "StrikeThrough"->False}]}], 
            RowBox[{
            "show", " ", "a", " ", "list", " ", "of", " ", "Mathematica", " ",
               "graphics", " ", "together", " ", "in", " ", "a", " ", 
              StyleBox["JavaView",
                FontSlant->"Italic"], " ", \(\(display\)\(.\)\)}]},
          {
            RowBox[{
              StyleBox["JavaView",
                FontFamily->"Courier",
                FontSize->12,
                FontWeight->"Plain",
                FontSlant->"Plain",
                FontColor->GrayLevel[0],
                FontVariations->{"Underline"->False,
                "StrikeThrough"->False,
                "CompatibilityType"->0}], 
              StyleBox["[",
                FontFamily->"Courier",
                FontSize->12,
                FontWeight->"Plain",
                FontSlant->"Plain",
                FontColor->GrayLevel[0],
                FontVariations->{"Underline"->False,
                "StrikeThrough"->False}], 
              RowBox[{
                RowBox[{
                  StyleBox["{",
                    FontFamily->"Courier New",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Italic",
                    FontColor->GrayLevel[0],
                    FontVariations->{"Underline"->False,
                    "StrikeThrough"->False}], 
                  RowBox[{
                    StyleBox[\(g\_1\),
                      "InlineFormula",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      FontSlant->"Italic"], 
                    StyleBox[\(g\_2\),
                      "InlineFormula",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      FontSlant->"Italic"], 
                    StyleBox[" ",
                      FontSlant->"Italic"], 
                    StyleBox["...",
                      FontSlant->"Italic"]}], 
                  StyleBox[" ",
                    FontSlant->"Italic"], 
                  StyleBox["}",
                    FontFamily->"Courier New",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Italic",
                    FontColor->GrayLevel[0],
                    FontVariations->{"Underline"->False,
                    "StrikeThrough"->False}]}], 
                StyleBox[",",
                  FontFamily->"Courier New",
                  FontSize->12,
                  FontWeight->"Plain",
                  FontSlant->"Italic",
                  FontColor->GrayLevel[0],
                  FontVariations->{"Underline"->False,
                  "StrikeThrough"->False}], 
                StyleBox[\(Animatable \[Rule] True\),
                  FontFamily->"Courier New",
                  FontSize->12,
                  FontWeight->"Plain",
                  FontSlant->"Italic",
                  FontColor->GrayLevel[0],
                  FontVariations->{"Underline"->False,
                  "StrikeThrough"->False}]}], 
              StyleBox["]",
                FontFamily->"Courier",
                FontSize->12,
                FontWeight->"Plain",
                FontSlant->"Plain",
                FontColor->GrayLevel[0],
                FontVariations->{"Underline"->False,
                
                "StrikeThrough"->
                  False}]}], \(show\ a\ list\ of\ Mathematica\ graphics\ as\ \
a\ smooth\ animation\ with\ animation\ \(\(dialog\)\(.\)\)\)}
          }], NotebookDefault]], "DefinitionBox",
  TextAlignment->Left,
  TextJustification->0,
  GridBoxOptions->{ColumnAlignments->{Right, Left}}],

Cell[TextData[{
  "Start ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " using ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " and display ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics."
}], "Caption"],

Cell[TextData[{
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " is a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " package which must be loaded before using ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  ". The package JavaView`JLink` loads ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " automatically with a default configuration. A user may set different \
options to load and configure ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " before loading ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  ". Loading of JavaView`JLink` does not modify the previous configuration of \
",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " since the ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " command ",
  StyleBox["InstallJava",
    FontFamily->"Courier New"],
  " does nothing on its second and later invocations."
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[{
  "Optionally: configure ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " before loading the JavaView package by using ",
  StyleBox["SetOptions[]",
    FontFamily->"Courier New"],
  "."
}], "Text"],

Cell[TextData[{
  "The package JavaView`JLink` automatically loads the package ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " package ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  ". By default, the command ",
  StyleBox["InstallJavaView",
    FontFamily->"Courier New"],
  " uses the default settings of the ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " initialization command ",
  StyleBox["InstallJava",
    FontFamily->"Courier New"],
  " to load a Java runtime. This behaviour can be adjusted by using the \
command ",
  StyleBox["SetOptions",
    FontFamily->"Courier New"],
  " BEFORE calling either ",
  StyleBox["InstallJava",
    FontFamily->"Courier New"],
  " or ",
  StyleBox["InstallJavaView",
    FontFamily->"Courier New"],
  ". The following options enable the use of the deprecated Microsoft Java \
runtime:"
}], "Text"],

Cell["\<\
<<JLink`
SetOptions[InstallJava, ClassPath->None]
SetOptions[InstallJava, CommandLine->wjview]
SetOptions[InstallJava, MicrosoftJava->True]
SetOptions[InstallJava, Java1->True]\
\>", "Program"]
}, Closed]],

Cell[TextData[{
  StyleBox["InstallJavaView[]",
    FontFamily->"Courier New"],
  " creates a ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " viewer manager and must be called prior to the first usage of ",
  StyleBox["JavaView[g]",
    FontFamily->"Courier New"],
  ". The command also pre-loads some ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " classes to simplify later access to static methods and constants. Its \
return value is the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " viewer manager which is an instance of the class jv.viewer.PvViewer, and \
which may be queried, for example, for the current display.\nIn contrast to \
the command ",
  StyleBox["RunJavaView[g]",
    FontFamily->"Courier New"],
  " discussed in a previous section this ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " connection to ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " does not block the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernel. Instead, it allows a realtime exchange of interactive data."
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[{
  "First ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " display"
}], "Subsubsection"],

Cell[TextData[{
  "Load the ",
  "JavaView",
  "`JLink` package including the J/Link package of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(<< JavaView`JLink`\), "\[IndentingNewLine]", 
    \(\(viewer\  = \ InstallJavaView[];\)\)}], "Input",
  CellLabel->"In[1]:="],

Cell[BoxData[
    \("JavaView CodeBase = C:/Programme/Wolfram \
Research/Mathematica/4.0/AddOns/Applications/JavaView/"\)], "Print",
  CellLabel->"From In[1]:="]
}, Open  ]],

Cell["The package Polyhedra is used in this notebook.", "MathCaption"],

Cell[BoxData[
    \(<< Graphics`Polyhedra`\)], "Input",
  CellLabel->"In[3]:="],

Cell[TextData[{
  "Now we are ready to display the first geometry via the ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " connection. The command ",
  StyleBox["JavaView[g]",
    FontFamily->"Courier New"],
  " displays a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics in ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  ". The first invocation of the command ",
  StyleBox["JavaView",
    FontFamily->"Courier New"],
  " will open a ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " display."
}], "Text"],

Cell["Create a sample geometry and view it in a JavaView display.", \
"MathCaption"],

Cell[BoxData[
    \(\(dode = \ Graphics3D[Dodecahedron[]];\)\)], "Input",
  CellLabel->"In[4]:="],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["JavaView",
          FontSlant->"Plain"], "[", "dode", "]"}], ";"}]], "Input",
  CellLabel->"In[11]:="],

Cell[TextData[{
  "As a rule of thumb, the command JavaView[] can be used whenever the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " command Show[] would apply."
}], "MathCaption"],

Cell[BoxData[
    \(\(Show[dode];\)\)], "Input",
  CellLabel->"In[15]:="]
}, Closed]],

Cell[CellGroupData[{

Cell["Simple graphics examples displayed by JavaView", "Subsubsection"],

Cell[TextData[{
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " understands most ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics type such as Graphics, Graphics3D, SurfaceGraphics, and others. \
Subsequent invocations of the command JavaView[g] replace the previous \
geometry in the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " display. This is done intentionally to simplify the use of the command \
JavaView[g] although ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " is able to visualize a whole scene of multiple geometries and animations. \
An option exists to keep the current scene shown in the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " display."
}], "Text"],

Cell[TextData[{
  "A detailed list of graphics examples is provided in the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " user's guide."
}], "Text"],

Cell["Visualizing a function curve as a set of points. ", "MathCaption"],

Cell[BoxData[{
    RowBox[{"pts", "=", 
      RowBox[{"Graphics", "[", 
        RowBox[{
          RowBox[{"Table", "[", 
            RowBox[{
              RowBox[{"Point", "[", 
                RowBox[{"{", 
                  RowBox[{"x", ",", 
                    RowBox[{"2", 
                      RowBox[{"Sin", "[", 
                        RowBox[{"1", "/", 
                          StyleBox["x",
                            "MathCaption"]}], "]"}]}]}], "}"}], "]"}], 
              ",", \({x, \(-Pi\), Pi,  .01}\)}], "]"}], 
          ",", \(Axes \[Rule] Automatic\)}], 
        "]"}]}], "\[IndentingNewLine]", \(Show[pts];\)}], "Input",
  CellLabel->"In[6]:="],

Cell[BoxData[
    \(\(JavaView[pts];\)\)], "Input",
  CellLabel->"In[8]:="],

Cell["\<\
Visualized several cuboids, and an additional cuboid with different surface \
color. \
\>", "MathCaption"],

Cell[BoxData[{
    \(\(cub = 
        Graphics3D[{Cuboid[{0, 0, 0}], Cuboid[{0, 0, 1}], Cuboid[{0, 1, 1}], 
            Cuboid[{1, 1, 1}], \[IndentingNewLine]{SurfaceColor[
                RGBColor[0, 1, 0]], \[IndentingNewLine]Cuboid[{1.25, 0.25, 
                  0.25}, {1.75, 0.75, 0.75}]}}];\)\), "\[IndentingNewLine]", 
    \(\(Show[cub];\)\)}], "Input",
  CellLabel->"In[9]:="],

Cell[BoxData[
    \(\(JavaView[cub];\)\)], "Input",
  CellLabel->"In[11]:="],

Cell["Visualize a color image as rectangular grid of cells.", "MathCaption"],

Cell[BoxData[{
    \(\(rsa = 
        Graphics[
          RasterArray[
            Table[Hue[ .1  Mod[i, j]], {i, 2, 10}, {j, 2, 
                10}]], \[IndentingNewLine]AspectRatio \[Rule] 
            Automatic];\)\), "\[IndentingNewLine]", 
    \(\(Show[rsa];\)\)}], "Input",
  CellLabel->"In[12]:="],

Cell[BoxData[
    \(JavaView[rsa]\)], "Input",
  CellLabel->"In[14]:="]
}, Closed]],

Cell[CellGroupData[{

Cell["Simple examples of graphics options understood by JavaView", \
"Subsubsection"],

Cell[TextData[{
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " understands a large set of graphics options of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics. A detailed list of graphics options is provided in the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " user's guide."
}], "Text"],

Cell[TextData[{
  "The option",
  " ",
  StyleBox["PlotRange", "MR"],
  " contrains the shown graphics to a box in x,y and z direction."
}], "MathCaption"],

Cell[BoxData[{
    \(\(pr\  = \ 
        Graphics3D[
          Stellate[
            Dodecahedron[]], \[IndentingNewLine]PlotRange \[Rule] {All, {0. , 
                2. }, {\(-0.7\), 0.5}}];\)\), "\[IndentingNewLine]", 
    \(Show[pr]\)}], "Input",
  CellLabel->"In[7]:="],

Cell[BoxData[
    \(JavaView[pr]\)], "Input",
  CellLabel->"In[9]:="],

Cell["Adjust the focus and viewing direction of the camera.", "MathCaption"],

Cell[BoxData[{\(gp = 
        Plot3D[Sin[x\ y], {x, 0, Pi}, {y, 0, 
            Pi}, \[IndentingNewLine]ViewCenter \[Rule] {1, 1, 1}, 
          ViewVertical \[Rule] {1, 0, 0}];\), "\[IndentingNewLine]", 
    RowBox[{
      RowBox[{
        StyleBox["JavaView",
          FontSlant->"Plain"], "[", "gp", "]"}], ";"}]}], "Input",
  CellLabel->"In[37]:="],

Cell["Position a few light sources for illumination.", "MathCaption"],

Cell[BoxData[{
    \(\(ls\  = \ 
        Graphics3D[
          Stellate[
            Dodecahedron[]], \[IndentingNewLine]LightSources \[Rule] {{{1. , 
                  0. , 0. }, 
                RGBColor[1. , 0.4, 
                  0.4]}, \[IndentingNewLine]{{\(- .15\),  .85, 0. }, 
                RGBColor[0.4, 1. , 
                  0.4]}, \[IndentingNewLine]{{\(- .15\), \(- .85\), 0. }, 
                RGBColor[0.4, 0.4, 1. ]}}];\)\), "\[IndentingNewLine]", 
    \(\(Show[ls];\)\), "\[IndentingNewLine]", 
    \(\(JavaView[ls];\)\)}], "Input",
  CellLabel->"In[39]:="]
}, Closed]],

Cell[CellGroupData[{

Cell["Multiple geometries in a JavaView display", "Subsubsection"],

Cell[TextData[{
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " can display several graphics objects at once. The graphics objects may \
either be loaded at once, or one after another."
}], "Text"],

Cell["Load two geometries at once.", "MathCaption"],

Cell[BoxData[{
    \(\(dode = \ Graphics3D[Dodecahedron[]];\)\), "\[IndentingNewLine]", 
    \(\(ico = \ Graphics3D[Icosahedron[]];\)\)}], "Input",
  CellLabel->"In[4]:="],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["JavaView",
          FontSlant->"Plain"], "[", \({dode, ico}\), "]"}], ";"}]], "Input",
  CellLabel->"In[9]:="],

Cell["Load two geometries one after another.", "MathCaption"],

Cell[BoxData[{
    \(\(octa = \ Graphics3D[Octahedron[]];\)\), "\[IndentingNewLine]", 
    \(\(cube = \ Graphics3D[Cube[]];\)\)}], "Input",
  CellLabel->"In[33]:="],

Cell[BoxData[{
    RowBox[{
      RowBox[{
        StyleBox["JavaView",
          FontSlant->"Plain"], "[", "octa", "]"}], 
      ";"}], "\[IndentingNewLine]", 
    RowBox[{
      RowBox[{
        StyleBox["JavaView",
          FontSlant->"Plain"], "[", \(cube, Replace \[Rule] False\), "]"}], 
      ";"}]}], "Input",
  CellLabel->"In[35]:="],

Cell[TextData[{
  "When surfaces overlap or have intersections then switch on z-buffered \
rendering, for example, by pressing <shift-z> inside the JavaView display. \
The z-buffer can also be enabled from the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " notebook by calling appropriate methods of the JavaView display objects. \
First, get the display object from the viewer manager, then enabled \
z-buffered rendering and finally initiate an update of the display to \
rerender the scene. "
}], "Text"],

Cell["\<\
Get the JavaView viewer manager (in case we did not keep a reference at the \
beginning).\
\>", "MathCaption"],

Cell[BoxData[
    \(\(viewer\  = \ InstallJavaView[];\)\)], "Input",
  CellLabel->"In[65]:="],

Cell["Enable z-buffered rendering.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(disp = viewer@getDisplay[];\)\), "\[IndentingNewLine]", 
    \(\(disp@setEnabledZBuffer[True];\)\), "\[IndentingNewLine]", 
    \(disp@update[disp]\)}], "Input",
  CellLabel->"In[66]:="],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[68]="]
}, Open  ]],

Cell["\<\
Having the display object at hand provide many more useful ways to interact \
with a JavaView scene. For example, it allows to change the currently active \
geometry. Normally, the first geometry added to a display is the active \
geometry. Inside the JavaView display the active geometry may be changed \
either inside the display inspector panel, or by a shortcut keeping ctrl-key \
pressed and left-clicking the geometry.
The active geometry may also be changed from within a notebook in different. \
For example, when adding a geometry to JavaView then keep a reference to the \
returned JavaView geometry object. (note, open the JavaView display inspector \
panel to see the change of the selection.)\
\>", "Text"],

Cell["Select a known other geometry as active geometry.", "MathCaption"],

Cell[BoxData[{
    RowBox[{
      RowBox[{"jvOcta", "=", 
        RowBox[{
          StyleBox["JavaView",
            FontSlant->"Plain"], "[", "octa", "]"}]}], 
      ";"}], "\[IndentingNewLine]", 
    RowBox[{
      RowBox[{"jvCube", "=", 
        RowBox[{
          StyleBox["JavaView",
            FontSlant->"Plain"], "[", \(cube, Replace \[Rule] False\), 
          "]"}]}], ";"}]}], "Input",
  CellLabel->"In[53]:="],

Cell[BoxData[{
    \(\(disp@selectGeometry[jvCube];\)\), "\[IndentingNewLine]", 
    \(disp@update[disp]\)}], "Input",
  CellLabel->"In[57]:="],

Cell[TextData[{
  "Sometime the geometry are not known as JavaView objects. For example, when \
multiple geometries have been added to JavaView from a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics with many geometries. In this case the display can provide a \
list of all registered geometries."
}], "Text"],

Cell["Select an unknown other geometry.", "MathCaption"],

Cell[BoxData[
    \(geomArr = disp@getGeometries[]\)], "Input",
  CellLabel->"In[62]:="],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        InterpretationBox[\(\[LeftGuillemet]JavaObject[
              "jv.geom.PgElementSet"] \[RightGuillemet]\),
          JLink`Objects`JavaObject160859947009], ",", 
        InterpretationBox[\(\[LeftGuillemet]JavaObject[
              "jv.geom.PgElementSet"] \[RightGuillemet]\),
          JLink`Objects`JavaObject163057762305]}], "}"}]], "Output",
  CellLabel->"Out[62]="],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(disp@selectGeometry[geomArr[\([1]\)]];\)\), "\[IndentingNewLine]", 
    \(disp@update[disp]\)}], "Input",
  CellLabel->"In[63]:="],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[64]="]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Simple modifications of a geometry inside ",
  StyleBox["JavaView",
    FontSlant->"Italic"]
}], "Subsubsection"],

Cell[TextData[{
  "The return value of ",
  StyleBox["JavaView",
    FontFamily->"Courier New",
    FontSlant->"Italic"],
  StyleBox["[]",
    FontFamily->"Courier New"],
  " is the geometry object used in ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  ". The type of the geometry class depends on the source material obtained \
from the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics. Typically the geometry is an instance of jv.geom.PgElementSet \
for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " polygons and other surface primitives or it is an instance of \
jv.geom.PgPolygonSet for lines, circle, etc. The ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " documentation contains information about the functionality of these \
geometry classes and the set of visualization tools operating on them. Using \
",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " it is now possible to inspect the geometry classes, modify their material \
and appearence in the viewer, change the geometry, or return data to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell["\<\
The syntax of the invocation of Java methods is explained in detail in the \
J/Link manual. For convenience, a summary is included in these note. \
\>", "Text"],

Cell["\<\
View another geometry in JavaView which replaces the previous one. This time \
we catch the returned JavaView geometry.\
\>", "MathCaption"],

Cell[BoxData[
    RowBox[{"geom", "=", 
      RowBox[{
        StyleBox["JavaView",
          FontSlant->"Plain"], "[", \(Graphics3D[Icosahedron[]]\), 
        "]"}]}]], "Input",
  CellLabel->"In[42]:="],

Cell[TextData[{
  "Enable semi-transparent drawing in ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  ". The degree of transparency is in the interval [0,1]."
}], "MathCaption"],

Cell[BoxData[{
    \(\(geom@setTransparency[0.4];\)\), "\[IndentingNewLine]", 
    \(\(geom@showTransparency[True];\)\), "\[IndentingNewLine]", 
    \(geom@update[geom]\)}], "Input",
  CellLabel->"In[63]:="],

Cell[TextData[{
  "Query the geometry for its combinatorial structure, like number of \
vertices, edges, or elements. The name 'element' is used in ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " for a face similar to the notation in finite element numerics."
}], "MathCaption"],

Cell[BoxData[
    \(geom@getNumElements[]\)], "Input",
  CellLabel->"In[11]:="],

Cell["\<\
Query the geometry for geometric properties like surface area or enclosed \
oriented volume.\
\>", "MathCaption"],

Cell[BoxData[
    \(geom@getVolume[]\)], "Input",
  CellLabel->"In[12]:="],

Cell[TextData[{
  "Modify the appearance and material properties. Here we switch off showing \
of faces but keep the display of edges. Note, whenever the geometry is \
changed in ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " by a command from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " then its update method be called to invoke a redraw of the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " display."
}], "MathCaption"],

Cell[BoxData[{
    \(\(geom@showElements[False];\)\), "\[IndentingNewLine]", 
    \(geom@update[geom]\)}], "Input",
  CellLabel->"In[61]:="]
}, Closed]],

Cell[CellGroupData[{

Cell["Identification of Vertices", "Subsubsection"],

Cell[TextData[{
  "A ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics has a separate list of points for each polygon. As a \
consequence, one cannot decide if two adjacent polygons join a common edge or \
if  the edge is common to both polygons just by chance. For example, surfaces \
which self-intersect might have edges common to four polygons but only pairs \
of two shall match there.\nSince v3.0 ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " automatically identifies equal vertices when parsing ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics objects. In some rare cases the identification might produce a \
wrong neighbourhood relation of polygons and shall therefore be suppressed. \
Note, ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " does not not identify vertices in animations since in animations a 1-1 \
correspondence between the vertices of all keyframes must be ensured during \
the animation."
}], "Text"],

Cell[TextData[{
  "Prevent the automatic identification of vertices using the option ",
  StyleBox["Identify\[Rule]False",
    FontFamily->"Courier New"],
  "."
}], "MathCaption"],

Cell[BoxData[{\(<< Graphics`Polyhedra`\), "\n", 
    RowBox[{"geom", "=", 
      RowBox[{
        StyleBox["JavaView",
          FontSlant->"Plain"], "[", \(Graphics3D[Icosahedron[]], \ 
        Identify \[Rule] False\), "]"}]}]}], "Input",
  CellLabel->"In[39]:="],

Cell["\<\
The existence of duplicate vertices is easily detected by showing item \
labels, or by keeping the p-key pressed while dragging a vertex in the \
display.\
\>", "MathCaption"],

Cell[BoxData[{
    \(\(geom@showVertices[True];\)\), "\[IndentingNewLine]", 
    \(\(geom@showVertexLabels[True];\)\), "\[IndentingNewLine]", 
    \(geom@update[geom]\)}], "Input",
  CellLabel->"In[41]:="],

Cell[TextData[{
  "We now show vertex normals. Each vertex shows as many vertex normals as \
there are adjacent polygons since without vertex identification ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " is not able to produce an adjacency relation between polygons. "
}], "Text"],

Cell["Change orientation and show vertex normals.", "MathCaption"],

Cell[BoxData[{
    \(\(geom@flipOrientation[];\)\), "\[IndentingNewLine]", 
    \(\(geom@makeVertexNormals[];\)\), "\[IndentingNewLine]", 
    \(\(geom@showVertexNormals[True];\)\), "\[IndentingNewLine]", 
    \(geom@update[geom]\)}], "Input",
  CellLabel->"In[44]:="],

Cell[TextData[{
  "On first sight, the vertex normals do not appear as expected but show up \
as a bunch of vectors at each vertex. The reason is that ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " lists the vertex coordinates for each polygon separately. Since this may \
be intentionally, ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " keeps this duplicate vertices. In computational mathematics such a \
behaviour is usually avoided since duplicate vertices and edges lead to \
ambiguous neighboorhood relations between adjacent elements and to additional \
degrees of freedom in the numerical mesh."
}], "Text"],

Cell[TextData[{
  "If the vertices where not identified when passing to ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  ", then ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " provide postprocessing tools to convert the geometry in a 'good' mesh by \
identifying vertices and building a neighbourhood between adjacent elements. \
Toolbox class jv.geom.PuCleanMesh is loaded during the initialization of \
JavaView."
}], "Text"],

Cell["\<\
Identify vertices whose vertex coordinates are equal (or within a small \
distance). The method returns the number of removed vertices.\
\>", "MathCaption"],

Cell[BoxData[{
    \(PuCleanMesh`identifyVertices[geom]\), "\[IndentingNewLine]", 
    \(\(geom@update[geom];\)\)}], "Input",
  CellLabel->"In[57]:="],

Cell["Refresh the vertex normals.", "MathCaption"],

Cell[BoxData[{
    \(\(geom@makeVertexNormals[];\)\), "\[IndentingNewLine]", 
    \(\(geom@update[geom];\)\)}], "Input",
  CellLabel->"In[59]:="],

Cell[TextData[{
  "Some of the commands issued above can also be invoked from the control \
window of ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  ". Click inside a display with the right mouse button and select the item \
'Control Panel' from the popup menu."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Pre-Configuration of a ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " Display"
}], "Subsubsection"],

Cell[TextData[{
  "Normally, the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " display is initialized during each invocation such that all previous \
interactive configurations of a display are removed and reset to their \
default state. In some cases, a preconfiguration of the display is wanted \
were, for example, bounding box, axes frame and background image are enabled \
and visible when ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  "[] is launched.\nThe preconfiguration of the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " display is possible by configuration of the ",
  StyleBox["disp",
    FontSlant->"Italic"],
  " object. The ",
  StyleBox["disp",
    FontSlant->"Italic"],
  " object represents the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " display and can be obtained from the viewer manager. A large number of \
methods allow to configure even more feature than are available through the \
interactive display inspector.\nA configuration of the ",
  StyleBox["disp",
    FontSlant->"Italic"],
  " object must be followed by an ",
  StyleBox["update",
    FontSlant->"Italic"],
  " of the display in order to take effect.\nThe ",
  StyleBox["disp",
    FontSlant->"Italic"],
  " object received from the viewer manager becomes void if a ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " window is closed. When closing a ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " window the ",
  StyleBox["disp",
    FontSlant->"Italic"],
  " object is removed from the viewer and destroyed, although the reference \
from inside ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " will still exist but no longer work. Therefore, after closing a ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " window the ",
  StyleBox["disp",
    FontSlant->"Italic"],
  " object must be obtained again from the viewer manager."
}], "Text"],

Cell[TextData[{
  "Load the ",
  "JavaView",
  "`JLink` package including the J/Link package of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "MathCaption"],

Cell[BoxData[{
    \(<< JavaView`JLink`\), "\[IndentingNewLine]", 
    \(\(viewer\  = \ InstallJavaView[];\)\)}], "Input",
  CellLabel->"In[1]:="],

Cell["Get the disp object from the viewer manager.", "MathCaption"],

Cell[BoxData[
    \(\(disp = viewer@getDisplay[];\)\)], "Input",
  CellLabel->"In[3]:="],

Cell[TextData[{
  "Configure the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " display, and invoke update[] to enable the changes."
}], "MathCaption"],

Cell[BoxData[{
    \(\(disp@showFrame[True];\)\), "\[IndentingNewLine]", 
    \(\(disp@showAxes[True];\)\), "\[IndentingNewLine]", 
    \(\(disp@showBndBox[True];\)\), "\[IndentingNewLine]", 
    \(\(disp@showBackImage[True];\)\), "\[IndentingNewLine]", 
    \(disp@update[disp]\)}], "Input",
  CellLabel->"In[21]:="],

Cell[TextData[{
  "The parameter ",
  StyleBox["KeepView->True",
    FontSlant->"Italic"],
  " prevents an initialization of the display"
}], "MathCaption"],

Cell[BoxData[{\(<< Graphics`Polyhedra`\), "\n", \(dode = \ 
      Graphics3D[Dodecahedron[]]; \), "\n", 
    RowBox[{
      StyleBox["JavaView",
        FontSlant->"Plain"], "[", \(dode, KeepView \[Rule] True\), 
      "]"}]}], "Input",
  CellLabel->"In[10]:="],

Cell[TextData[{
  "There exist many methods to configure a ",
  StyleBox["disp",
    FontSlant->"Italic"],
  " object which can be shown with the command Methods[]. The listing \
includes many more methods which are not useful in this context, but the \
relevant configuration methods have the form setEnableXxxx[] or showXxxx[]. \
The methods are not documented within the ",
  StyleBox["JavaView`JLink`",
    FontSlant->"Italic"],
  " package but at the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " website in the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " reference documentation at ",
  StyleBox["http://www.javaview.de/doc/reference/index.html",
    FontFamily->"Courier New",
    FontSize->10,
    FontColor->RGBColor[0, 0, 0.996109],
    FontVariations->{"Underline"->True}],
  ". The configuration methods are described in the class jv.viewer.PvDisplay \
available at ",
  StyleBox["http://www.javaview.de/doc/reference/jv/viewer/PvDisplay.html",
    FontFamily->"Courier New",
    FontSize->10,
    FontColor->RGBColor[0, 0, 0.996109],
    FontVariations->{"Underline"->True}],
  "."
}], "Text"],

Cell[TextData[{
  "Show all available methods of the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " display (much more than you can use)."
}], "MathCaption"],

Cell[BoxData[
    \(Methods[disp]\)], "Input",
  CellLabel->"In[8]:="]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Reminder on J/Link Basics", "Section"],

Cell[CellGroupData[{

Cell["Launching J/Link", "Subsection"],

Cell["\<\
The first step is to load the J/Link package file. If you have installed \
J/Link as described in the installation chapter of the J/Link manual, you \
will be able to load the package:\
\>", "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[\(<< JLink`\),
              "MR",
              FontFamily->"Courier New",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontColor->GrayLevel[0],
              FontVariations->{"Underline"->False,
              "StrikeThrough"->False}], 
            StyleBox[\(load\ the\ J/Link\ package\),
              "Text"]},
          {
            StyleBox[\(InstallJava[]\),
              "MR",
              FontFamily->"Courier New",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontColor->GrayLevel[0],
              FontVariations->{"Underline"->False,
              "StrikeThrough"->False}], 
            
            StyleBox[\(launch\ the\ Java\ runtime\ and\ prepare\ it\ for\ use\
\ from\n
              Mathematica\),
              "Text"]},
          {
            StyleBox[
              RowBox[{
                StyleBox["UninstallJava",
                  FontFamily->"Courier New",
                  FontSize->12,
                  FontWeight->"Plain",
                  FontSlant->"Plain",
                  FontColor->GrayLevel[0],
                  FontVariations->{"Underline"->False,
                  "StrikeThrough"->False}], "[", "]"}],
              FontFamily->"Courier New",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontColor->GrayLevel[0],
              FontVariations->{"Underline"->False,
              "StrikeThrough"->False}], \(quit\ the\ Java\ runtime\)}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnAlignments->{Right, Left}}],

Cell["Launching J/Link and Java.", "Caption"],

Cell["Load J/Link.", "MathCaption"],

Cell[BoxData[
    \(<< JLink`\)], "Input",
  CellLabel->"In[1]:="],

Cell["Launch the Java runtime.", "MathCaption"],

Cell[BoxData[
    \(InstallJava[]\)], "Input",
  CellLabel->"In[2]:="],

Cell[TextData[{
  "A different invocation explicitly selects the Java runtime through options \
of ",
  StyleBox["InstallJava",
    FontFamily->"Courier New"],
  "."
}], "MathCaption"],

Cell[BoxData[
    \(\(\(InstallJava[CommandLine -> "\<java\>", 
      MicrosoftJava \[Rule] False, \ 
      Java1 \[Rule] False]\)\(\[IndentingNewLine]\)\( (*\ 
      InstallJava[CommandLine -> "\<wjview\>", \ MicrosoftJava -> True, \ 
        Java1 \[Rule] True]\ *) \)\)\)], "Input",
  CellLabel->"In[2]:="],

Cell[TextData[{
  "The command ",
  StyleBox["InstallJava",
    FontFamily->"Courier New"],
  " launches the Java runtime which may be selected by providing additional \
options. Remember, in J/Link version 1.01 the archive rmi.zip is required if \
the Microsoft virtual machine is used.\nInstallJava can be called more than \
once in a session. On every call after the first, it does nothing. Thus, it \
is safe to call InstallJava in any program you write, without considering \
whether the user has already called it. Only one Java runtime will ever be in \
use."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Creating Java Objects", "Subsection"],

Cell["\<\
To instantiate Java objects, use the JavaNew[] function. The first argument \
to JavaNew is the object\[CloseCurlyQuote]s class, specified either as a \
JavaClass expression returned from LoadClass or as a string giving the \
fully-qualified class name (i.e., having the full package prefix with all the \
periods). If you wish to supply any arguments to the \
object\[CloseCurlyQuote]s constructor, they follow as a sequence after the \
class.\
\>", "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[
              RowBox[{
                StyleBox["JavaNew",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                RowBox[{
                  StyleBox[
                    FormBox["classname",
                      "TraditionalForm"],
                    "TI"], ",", " ", "arg1", ",", " ", "..."}], 
                StyleBox["]",
                  "MR"]}],
              FontFamily->"Courier New",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontColor->GrayLevel[0],
              FontVariations->{"Underline"->False,
              
              "StrikeThrough"->
                False}], \(construct\ a\ new\ object\ of\ the\ specified\ \
class\ and\ return\n
            it\ to\ Mathematica\)},
          {
            StyleBox[
              RowBox[{
                StyleBox["LoadClass",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                StyleBox[
                  FormBox["classname",
                    "TraditionalForm"],
                  "TI"], 
                StyleBox["]",
                  "MR"]}],
              FontFamily->"Courier New",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontColor->GrayLevel[0],
              FontVariations->{"Underline"->False,
              "StrikeThrough"->False}], 
            
            StyleBox[\(load\ the\ specified\ class\ into\ Java\ and\ \
Mathematica\),
              "Text"]},
          {
            StyleBox[
              RowBox[{
                StyleBox["ReleaseObject",
                  FontFamily->"Courier New",
                  FontSize->12,
                  FontWeight->"Plain",
                  FontSlant->"Plain",
                  FontColor->GrayLevel[0],
                  FontVariations->{"Underline"->False,
                  "StrikeThrough"->False}], "[", 
                StyleBox["obj",
                  FontSlant->"Italic"], "]"}],
              FontFamily->"Courier New",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontColor->GrayLevel[0],
              FontVariations->{"Underline"->False,
              "StrikeThrough"->False}], 
            RowBox[{
            "let", " ", "Java", " ", "know", " ", "that", " ", "you", " ", 
              "are", " ", "done", " ", "using", " ", 
              StyleBox["obj",
                FontSlant->"Italic"], " ", "in", " ", "Mathematica"}]}
          }], TextForm]], "DefinitionBox",
  GridBoxOptions->{ColumnAlignments->{Right, Left}}],

Cell["Creating Java classes in Mathematica.", "Caption"],

Cell[TextData[{
  "Now we create a linear algebra vector in ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " which mainly consists of an array of double values. The initial length of \
the array may be given as constructor argument. Double and integer vectors \
are the base classes used in all geometry classes of ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell["Create a new vector with different constructors.", "MathCaption"],

Cell[BoxData[{
    \(vec0 = JavaNew["\<jv.vecmath.PdVector\>"]\), "\[IndentingNewLine]", 
    \(vec3 = JavaNew["\<jv.vecmath.PdVector\>", 3]\)}], "Input",
  CellLabel->"In[3]:="],

Cell["We check the length of the return vectors.", "MathCaption"],

Cell[BoxData[{
    \(vec0@getSize[]\), "\[IndentingNewLine]", 
    \(vec3@getSize[]\)}], "Input",
  CellLabel->"In[5]:="],

Cell[BoxData[
    \(vec3@setEntry[2, \ 17. ]\)], "Input",
  CellLabel->"In[7]:="],

Cell[BoxData[
    \(vec3@getEntries[]\)], "Input",
  CellLabel->"In[8]:="],

Cell[TextData[{
  "The return value from JavaNew[] can be considered as a reference to the \
Java object, although it is a strange expression internally that will be \
referred to as JavaObject expression. JavaNew[] is not the only way to get a \
reference to a Java object in Mathematica. Many methods and fields return \
objects. Such objects can be used in the same way as ones you explicitly \
construct with ",
  StyleBox["JavaNew",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  "."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Naming Conventions", "Subsection"],

Cell[TextData[{
  "J/Link strictly follows the rules of the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " programming language. This has certain implications how Java is \
accessed."
}], "Text"],

Cell["\<\
Access to public fields and methods follows the same rules as in Java with a \
slight difference in notation. Instead of '.' J/Link uses '@' for non-static \
respectively '`' for static fields and methods. Further, argument brackets [] \
are used instead of ().\
\>", "Text"],

Cell["\<\
Note, there is an issue with underscores used in method and variable names. \
They must be replaced by a capital 'U' unless the name appears inside of a \
string.\
\>", "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox["Java",
              "MR",
              FontVariations->{"Underline"->True}], 
            StyleBox["Mathematica",
              FontVariations->{"Underline"->True}]},
          {
            StyleBox[\(obj . methodName \((args)\);\),
              FontFamily->"Courier New",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontColor->GrayLevel[0],
              FontVariations->{"Underline"->False,
              "StrikeThrough"->False}], 
            StyleBox[\(obj@methodName[args];\),
              "Text",
              FontFamily->"Courier New",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontColor->GrayLevel[0],
              FontVariations->{"Underline"->False,
              "StrikeThrough"->False}]},
          {
            StyleBox[\(MyClass . staticMethod \((args)\);\),
              FontFamily->"Courier New",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontColor->GrayLevel[0],
              FontVariations->{"Underline"->False,
              "StrikeThrough"->False}], 
            StyleBox[\(MyClass`staticMethod[args];\),
              FontFamily->"Courier New",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontColor->GrayLevel[0],
              FontVariations->{"Underline"->False,
              "StrikeThrough"->False}]},
          {
            StyleBox[\(MyClass . UNDER_SCORE\),
              FontFamily->"Courier New",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontColor->GrayLevel[0],
              FontVariations->{"Underline"->False,
              "StrikeThrough"->False}], 
            StyleBox["MyClass`UNDERUSCORE",
              FontFamily->"Courier New",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontColor->GrayLevel[0],
              FontVariations->{"Underline"->False,
              "StrikeThrough"->False}]}
          }], TextForm]], "DefinitionBox",
  GridBoxOptions->{ColumnAlignments->{Right, Left}}],

Cell["Naming conventions used by J/Link.", "Caption"],

Cell[TextData[{
  "Before accessing a static variables the class must be loaded once. The \
command ",
  StyleBox["InstallJavaView",
    FontFamily->"Courier New"],
  " of the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " pre-loads some basic ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " classes but we repeat the loading here for completeness."
}], "Text"],

Cell["\<\
Load static classes prior to access of static variables. Notice the 'U'.\
\>", "MathCaption"],

Cell[BoxData[{
    \(\(LoadClass["\<jv.object.PsObject\>"];\)\), "\[IndentingNewLine]", 
    \(PsObject`ISUSELECTED\)}], "Input",
  CellLabel->"In[9]:="]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Arrays in Java and Lists in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "Subsection"],

Cell[TextData[{
  "The level of exchange of larger data between ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and Java is usually done on the basis of arrays in Java and lists in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " as their counterparts.\nThe vector classes PdVector and PiVector used in \
",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " have the functionality of double respectively integer arrays of arbitrary \
size. Basically, they contain a data fields 'double [] data' respectively \
'int [] data'."
}], "Text"],

Cell[TextData[{
  "Here we call some basic linear algebra methods. Java objects in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " behave like usual Java instances."
}], "MathCaption"],

Cell[BoxData[{
    \(\(vec0@setSize[3];\)\), "\[IndentingNewLine]", 
    \(\(vec0@setConstant[1. ];\)\), "\[IndentingNewLine]", 
    \(\(vec3@add[vec0];\)\), "\[IndentingNewLine]", 
    \(vec3@setEntry[0, 17]; \  (*\ 
      JavaView\ converts\ argument\ to\ \(\(double\)\(.\)\)\ *) \)}], "Input",\

  CellLabel->"In[11]:="],

Cell[TextData[{
  "Note, Java arrays start with index 0 while ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " lists start at index 1. This is essential when converting between Java \
arrays and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " lists."
}], "Text"],

Cell[TextData[{
  "The content of the vector can be converted back and forth to a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " list."
}], "MathCaption"],

Cell[BoxData[
    \(v\  = \ vec3@getEntries[]\)], "Input",
  CellLabel->"In[15]:="],

Cell[BoxData[{
    \(\(v[\([2]\)] = 19. ;\)\), "\[IndentingNewLine]", 
    \(\(vec3@set[v];\)\), "\[IndentingNewLine]", 
    \(vec3@getEntries[]\)}], "Input",
  CellLabel->"In[16]:="],

Cell["\<\
Create a new vector which is initialized with the data of the existing vector \
v.\
\>", "MathCaption"],

Cell[BoxData[
    \(kh = JavaNew["\<jv.vecmath.PdVector\>", \ v]\)], "Input",
  CellLabel->"In[19]:="],

Cell[BoxData[
    \(kh@getEntries[]\)], "Input",
  CellLabel->"In[20]:="],

Cell["Create a new empty surface.", "MathCaption"],

Cell[BoxData[{
    \(torus\  = \ JavaNew["\<jv.geom.PgElementSet\>", \ 3]\), "\n", 
    \(\(torus@setName["\<fancy torus\>"];\)\)}], "Input",
  CellLabel->"In[21]:="],

Cell["\<\
Use a helper routine to create a torus over a 10*10 grid and radii 2 and 1.\
\>", "MathCaption"],

Cell[BoxData[
    \(\(torus@computeTorus[10, \ 10, \ 2. , \ 1. ];\)\)], "Input",
  CellLabel->"In[23]:="],

Cell["\<\
Here we are just accessing the 16th vertex of the torus. Note, array counting \
starts at 0 in Java.\
\>", "MathCaption"],

Cell[BoxData[
    \(torus@\(getVertex[16]@getEntries[]\)\)], "Input",
  CellLabel->"In[24]:="],

Cell[TextData[{
  "Note, J/Link converts a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " list to an array of doubles only if ALL entries are floating point \
numbers."
}], "Text"],

Cell["\<\
If the list v contains an integer then the setting fails since J/Link does \
not find the Java method. \
\>", "MathCaption"],

Cell[BoxData[{
    \(\(v[\([2]\)] = 19;\)\), "\[IndentingNewLine]", 
    \(vec3@
      set[v]; \  (*\ \(! \(! \(! \ 
            v\ contains\ an\ integer\ \(\(component\)\(.\)\)\)\)\)\ *) \)}], \
"Input",
  CellLabel->"In[25]:="],

Cell[BoxData[
    \(vec3@set[17. , 19, 1. ]\)], "Input",
  CellLabel->"In[27]:="],

Cell[TextData[{
  "When transferring large arrays of geometric data back and forth between ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and ",
  "JavaView",
  " it is time to read the section on performance issues in the J/Link \
manual."
}], "Text"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Basics of the JavaView Display", "Section"],

Cell[TextData[{
  "The best introduction to the features of ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " and the interaction with its display is to browse through the \
demonstrations given at the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " homepage ",
  ButtonBox["http://www.javaview.de/",
    ButtonData:>{
      URL[ "http://www.javaview.de"], None},
    ButtonStyle->"Hyperlink"],
  ". Here we provide a basic reference list."
}], "Text"],

Cell[TextData[{
  "The ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " display always has a major interaction mode in which you can either \
rotate, scale, or translate a geometry. You press a shortcut key to switch to \
another mode temporarily. When releasing the key, the previous major mode is \
re-installed.\nNote, selecting an interaction mode with the popup menu \
switches the major mode."
}], "Text",
  CellDingbat->None],

Cell["\<\
Each display opens a popup menu by clicking with the right mouse. This is a \
convenient shortcut for a few basic tasks avoiding to know keyboard shortcuts \
or to open the control window. For example, to switch the interaction mode \
(without using keyboard shortcut), access to help dialog (without using \
control window), open another display (without using control window), or open \
the control window. \
\>", "Text"],

Cell[CellGroupData[{

Cell[TextData[{
  "Popup menu in any ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " display using right-mouse click."
}], "MathCaption"],

Cell[TextData[{
  "You can always get a listing of available keyboard shortcuts by opening \
the popup menu in any ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " display and select the Help menu item. Here is a list of most commands. \
While focus over the display keep either of the following keys pressed while \
dragging with the mouse."
}], "Text",
  CellDingbat->None],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox["Transformation",
              "MR",
              FontWeight->"Bold"], "\[Placeholder]"},
          {"o", 
            RowBox[{"Rotation", " ", "mode", " ", 
              RowBox[{"(", 
                StyleBox[
                  RowBox[{
                    StyleBox["O",
                      FontWeight->"Bold"], "rbit"}]], ")"}]}]},
          {"v", 
            RowBox[{
              RowBox[{"Rotation", " ", "with", " ", "fixed", " ", 
                StyleBox[
                  RowBox[{
                    StyleBox["v",
                      FontWeight->"Bold"], "ertical"}]], " ", "z"}], "-", 
              "axis"}]},
          {"s", 
            RowBox[{
              StyleBox[
                RowBox[{
                  StyleBox["S",
                    FontWeight->"Bold"], "caling"}]], " ", "mode"}]},
          {"t", 
            RowBox[{"xy", "-", 
              RowBox[{
                StyleBox[
                  RowBox[{
                    StyleBox["T",
                      FontWeight->"Bold"], "ranslation"}]], " ", "mode"}]}]},
          {"z", 
            RowBox[{
              StyleBox["Z",
                FontWeight->"Bold"], "-", \(Translation\ mode\)}]},
          {"f", 
            RowBox[{
              StyleBox[
                RowBox[{
                  StyleBox["F",
                    FontWeight->"Bold"], "it"}]], " ", "scene", " ", "to", 
              " ", "fill", " ", "display"}]},
          {"c", 
            RowBox[{
              StyleBox[
                RowBox[{
                  StyleBox["C",
                    FontWeight->"Bold"], "enter"}]], " ", "geometry", " ", 
              "in", " ", "display"}]},
          {"x", \(Drag\ rectangle\ to\ zoom\ in\)},
          {"r", 
            RowBox[{
              StyleBox[
                RowBox[{
                  StyleBox["R",
                    FontWeight->"Bold"], "eset"}]], " ", "display", " ", 
              "and", " ", "camera"}]},
          {\(Left\ Mouse\), \(Depending\ on\ the\ mode, drag, 
            pick\ and\ select\ the\ geometry\ in\ the\ viewer\)},
          {\(Right\ Mouse\), \(Show\ popup\ menu\ to\ select\ major\ modes\ \
and\ others\ actions\)},
          {
            StyleBox["Animation",
              FontWeight->"Bold"], 
            StyleBox["\[Placeholder]",
              FontWeight->"Bold"]},
          {"w", \(Start\ auto - rotation\ of\ geometry\)},
          {"q", \(Stop\ auto - rotation\)},
          {\(Ctrl - a\), \(Show\ animation\ panel\ \((if\ animatable)\)\)},
          {\(Ctrl - 
              k\), \(Create\ animation\ by\ storing\ current\ geometry\ as\ \
keyframe\)},
          {
            StyleBox["Modelling",
              FontWeight->"Bold"], 
            StyleBox["\[Placeholder]",
              FontWeight->"Bold"]},
          {"a", 
            RowBox[{
              StyleBox[
                RowBox[{
                  StyleBox["A",
                    FontWeight->"Bold"], "dd"}]], " ", "vertex", " ", "to", 
              " ", "current", " ", "geometry", 
              " ", \((enable' show\ vertices')\)}]},
          {"e", 
            RowBox[{"Add", " ", 
              StyleBox[
                RowBox[{
                  StyleBox["e",
                    FontWeight->"Bold"], "lement"}]], " ", "or", " ", 
              "polygon", " ", "by", " ", "picking", " ", "existing", " ", 
              "or", " ", "new", " ", "vertices"}]},
          {"d", 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox[
                    RowBox[{
                      StyleBox["D",
                        FontWeight->"Bold"], "uplicate"}]], " ", "geometry", 
                  " ", "by", " ", "reflection", " ", "depending", " ", "on", 
                  " ", "the", " ", "number", " ", "of", " ", "marked", 
                  " ", \(vertices : \ 1\ vertex\)}], " ", "=", 
                " ", \(inversion\ in\ point\)}], ",", 
              " ", \(2\ vertices\  = \ 180\ rotation\ around\ line\), ",", 
              " ", \(3\ vertices\  = \ 
                mirror\ reflection\ in\ \(\(plane\)\(.\)\)\)}]},
          {"i", 
            RowBox[{"Pick", " ", 
              StyleBox[
                RowBox[{
                  StyleBox["I",
                    FontWeight->"Bold"], "nital"}]], " ", "points", " ", "in",
               " ", "some", " ", "applets"}]},
          {"m", 
            RowBox[{"Drag", " ", "rectangle", " ", "to", " ", 
              StyleBox[
                RowBox[{
                  StyleBox["M",
                    FontWeight->"Bold"], "ark"}]], " ", "vertices", " ", 
              "inside"}]},
          {"n", \(Pick\ or\ drag\ rectangle\ to\ mark\ elements\ inside\)},
          {"p", 
            RowBox[{
              StyleBox[
                RowBox[{
                  StyleBox["P",
                    FontWeight->"Bold"], "ick"}]], " ", "a", " ", "vertex", 
              " ", "and", " ", "drag", " ", "it"}]},
          {"u", 
            RowBox[{"Drag", " ", "rectangle", " ", "to", " ", 
              StyleBox[
                RowBox[{
                  StyleBox["U",
                    FontWeight->"Bold"], "nmark"}]], " ", "vertices", " ", 
              "inside"}]},
          {\(Shift - u\), \(Drag\ rectangle\ to\ unmark\ elements\ inside\)},
          {
            StyleBox[\(Display\ Flags\),
              FontWeight->"Bold"], 
            StyleBox[\((toggle\ on/off)\),
              FontWeight->"Bold"]},
          {\(Shift - a\), 
            RowBox[{
              StyleBox[
                RowBox[{
                  StyleBox["A",
                    FontWeight->"Bold"], "ura"}]], " ", "around", " ", 
              "edges", " ", \((only\ if\ elements\ are\ switched\ off)\)}]},
          {\(Shift - b\), 
            RowBox[{
              StyleBox[
                RowBox[{
                  StyleBox["B",
                    FontWeight->"Bold"], "ounding"}]], " ", "box", " ", "of", 
              " ", "current", " ", "geometry"}]},
          {\(Shift - c\), 
            RowBox[{
              StyleBox[
                RowBox[{
                  StyleBox["C",
                    FontWeight->"Bold"], "enter"}]], " ", "of", " ", 
              "current", " ", "geometry", " ", \((pending)\)}]},
          {\(Shift - d\), 
            RowBox[{
              StyleBox[
                RowBox[{
                  StyleBox["D",
                    FontWeight->"Bold"], "epthcue"}]], " ", "fading", " ", 
              "off", " ", "items", " ", "farer", " ", "away"}]},
          {\(Shift - f\), 
            RowBox[{"Coordinate", " ", 
              StyleBox[
                RowBox[{
                  StyleBox["F",
                    FontWeight->"Bold"], "rame"}]]}]},
          {\(Shift - g\), 
            RowBox[{"xy", "-", 
              StyleBox[
                RowBox[{
                  StyleBox["G",
                    FontWeight->"Bold"], "rid"}]]}]},
          {\(Shift - h\), 
            RowBox[{\(Information\ at\ mouse\ cursor\), ",", " ", 
              StyleBox[
                RowBox[{
                  StyleBox["H",
                    FontWeight->"Bold"], "ighlight"}]]}]},
          {\(Shift - i\), 
            RowBox[{"Background", " ", 
              StyleBox[
                RowBox[{
                  StyleBox["I",
                    FontWeight->"Bold"], "mage"}]]}]},
          {\(Shift - j\), \(Toggle\ usage\ of\ lights\)},
          {\(Shift - l\), 
            RowBox[{
              StyleBox[
                RowBox[{"Border", 
                  StyleBox["l",
                    FontWeight->"Bold"], "ine"}]], " ", "around", " ", 
              "display"}]},
          {\(Shift - m\), \(Toggle\ magnet\ mode\ of\ vertices, 
            i . e . highlight\ if\ nearby\ vertices\)},
          {\(Shift - o\), \(Direct\ select\ mode, 
            geometries\ are\ automatically\ selected\ when\ picked\)},
          {\(Shift - p\), 
            RowBox[{
              RowBox[{
                StyleBox[
                  RowBox[{
                    StyleBox["P",
                      FontWeight->"Bold"], "ainter"}]], "'"}], "s", " ", 
              "algorithm", " ", "for", " ", "depthsort"}]},
          {\(Shift - q\), \(Toggle\ display\ of\ title\ information\)},
          {\(Shift - r\), 
            RowBox[{\(Backface\ culling\), ",", " ", 
              RowBox[{"show", " ", 
                StyleBox[
                  RowBox[{
                    StyleBox["R",
                      FontWeight->"Bold"], "ear"}]], " ", "elements"}]}]},
          {\(Shift - s\), \(Toggle\ anti - aliased\ rendering\)},
          {\(Shift - 
              t\), \(Toggle\ tag\ mode\ to\ move\ all\ marked\ vertices\)},
          {\(Shift - x\), 
            RowBox[{"Coordinate", " ", 
              StyleBox[
                RowBox[{"A", 
                  StyleBox["x",
                    FontWeight->"Bold"], "es"}]], " ", "around", " ", 
              "scene"}]},
          {\(Shift - y\), \(\((beta)\)\ Fly\ mode\)},
          {\(Shift - z\), \(Toggle\ z - buffer\ mode\)},
          {
            StyleBox["Selecting",
              FontWeight->"Bold"], 
            StyleBox["\[Placeholder]",
              FontWeight->"Bold"]},
          {\(Ctrl - 
              Left\ Mouse\), \(Pick\ geometry\ with\ left\ mouse\ while\ \
holding\ control\ key\ to\ select\ geometry\ in\ display\)},
          {\(Ctrl - 
              tab\), \(Cycle\ through\ the\ registered\ geometries\ of\ a\ \
scene\)},
          {
            StyleBox["Deleting",
              FontWeight->"Bold"], "\[Placeholder]"},
          {\(Backspace - 
              Left\ Mouse\), \(Pick\ geometry\ with\ left\ mouse\ while\ \
holding\ delete\ key\ to\ delete\ geometry\ in\ display\)},
          {
            StyleBox["Panels",
              FontWeight->"Bold"], 
            StyleBox["\[Placeholder]",
              FontWeight->"Bold"]},
          {"F1", \(Open\ control\ window\ with\ default\ panel\)},
          {"F2", \(Close\ control\ window\)},
          {\(Ctrl - a\), 
            RowBox[{"Show", " ", 
              StyleBox[
                RowBox[{
                  StyleBox["A",
                    FontWeight->"Bold"], "nimation"}]], " ", "Control", " ", 
              "Panel", " ", \((if\ project\ allows)\)}]},
          {\(Ctrl - c\), 
            RowBox[{
              RowBox[{"Show", " ", 
                StyleBox[
                  RowBox[{
                    StyleBox["C",
                      FontWeight->"Bold"], "amera"}]], " ", "panel"}], ",", 
              " ", \(info\ panel\ of\ camera\)}]},
          {\(Ctrl - d\), 
            RowBox[{
              RowBox[{"Show", " ", 
                StyleBox[
                  RowBox[{
                    StyleBox["D",
                      FontWeight->"Bold"], "ebug"}]], " ", "console"}], ",", 
              " ", 
              RowBox[{
                RowBox[{
                  StyleBox["JavaView",
                    FontWeight->"Bold",
                    FontSlant->"Italic",
                    FontColor->RGBColor[0, 0.250004, 0.500008]], "'"}], "s", 
                " ", "console"}]}]},
          {\(Ctrl - e\), \(Show\ vector\ panel\ of\ geometry, \ if\ any\)},
          {\(Ctrl - f\), \(Show\ configuration\ panel\ of\ geometry, \ 
            if\ any\)},
          {\(Ctrl - i\), 
            RowBox[{"Show", " ", 
              StyleBox[
                RowBox[{
                  StyleBox["I",
                    FontWeight->"Bold"], "nfo"}]], " ", "panel", " ", "of", 
              " ", "geometry"}]},
          {\(Ctrl - l\), 
            RowBox[{"Show", " ", 
              StyleBox[
                RowBox[{
                  StyleBox["l",
                    FontWeight->"Bold"], "ight"}]], " ", "panel"}]},
          {\(Ctrl - m\), 
            RowBox[{"Show", " ", 
              StyleBox[
                RowBox[{
                  StyleBox["M",
                    FontWeight->"Bold"], "aterial"}]], " ", "panel", " ", 
              "of", " ", "geometry"}]},
          {\(Ctrl - p\), \(Show\ project\ panel, if\ any\)},
          {\(Ctrl - t\), \(Show\ texture\ panel\ of\ geometry, if\ any\)},
          {\(Ctrl - v\), 
            RowBox[{
              RowBox[{"Show", " ", 
                StyleBox[
                  RowBox[{
                    StyleBox["V",
                      FontWeight->"Bold"], "iewer"}]], " ", "panel"}], ",", 
              " ", \(info\ panel\ of\ display\)}]},
          {\(Ctrl - x\), \(Show\ axis\ panel\)},
          {
            StyleBox[\(Menu\ Shortcuts\),
              FontWeight->"Bold"], "\[Placeholder]"},
          {\(Ctrl - n\), \(New\ geometry\ dialog\)},
          {\(Ctrl - 
              Shift . n\), \(Load\ a\ JVD\ file\ with\ same\ base\ name\ as\ \
recently\ loaded\ model\ file\)},
          {\(Ctrl - 
              o\), \(Open\ file\ import\ dialog\ to\ load\ any\ geometry\ or\ \
jvd\ file\)},
          {\(Ctrl - Shift - o\), \(Same\ as\ Ctrl - o, \ 
            but\ additionally\ load\ a\ JVD\ file\ with\ same\ name\ if\ it\ \
exists\)},
          {\(Ctrl - s\), \(Save\ geometry\ using\ export\ dialog\)},
          {"\[Placeholder]", "\[Placeholder]"},
          {
            StyleBox["System",
              FontWeight->"Bold"], "\[Placeholder]"},
          {\(Right\ mouse\), \(Open\ popup\ menu\)},
          {\(Ctrl - Shift - x\), 
            RowBox[{"Immediate", " ", 
              StyleBox[
                RowBox[{"e", 
                  StyleBox["X",
                    FontWeight->"Bold"], "it"}]], " ", "of", " ", "a", " ", 
              StyleBox["JavaView",
                FontWeight->"Bold",
                FontSlant->"Italic",
                FontColor->RGBColor[0, 0.250004, 0.500008]], " ", 
              "application"}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnAlignments->{Right, Left}}],

Cell[TextData[{
  "Keyboard shortcuts in ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " display (an excerpt). "
}], "Caption"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Different camera views, different display settings.", "MathCaption"],

Cell[TextData[{
  "Each ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " display maintains its own settings. If you like to have different views \
on the same scene then just open another display and select your preferred \
camera and display settings. Or go to the camera inspector and enable the \
synchronized display of four displays with different projection settings."
}], "Text"],

Cell["\<\
Different displays may also show a different set of geometries. But if a \
geometry is shared by displays, then it has the same shape and material in \
all displays. Therefore, if you have four displays with top, front, right, \
perspective view, then moving a vertex in either display will move the vertex \
in the other views too as you expect.\
\>", "Text"],

Cell["\<\
The control panel always views the camera and display panel of the currently \
active display. The current display is selected by moving the mouse over it. \
If there are many displays then this automatic selection might be annoying \
but it ensures that keyboard events are received by the display with mouse \
focus as expected (so we know about this problem).\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Current geometry of a display.", "MathCaption"],

Cell[TextData[{
  "Each ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " display is able to display a scene with many geometries. One of these \
geometries is the active geometry. For example, you can pick vertices only of \
the active geometry."
}], "Text",
  CellDingbat->None],

Cell["\<\
Note, the control panel shows the info and material panel of the current \
geometry.\
\>", "Text",
  CellDingbat->None],

Cell[TextData[{
  "The current geometry may be selected in different ways:\n1. Using keyboard \
shortcut Ctrl-tab or Ctrl-left mouse. This does not allow to select so-called \
",
  StyleBox["special geometries",
    FontSlant->"Italic"],
  " like the coordinate frame, xy-grid or bounding box.\n2. On the display \
panel select the active geometry. Here it is allowed to select special \
geometries too, and, for example, modify their appearance using their \
info/material/control panels.\n3. Via method call disp@selectGeometry[geom]."
}], "Text",
  CellDingbat->None]
}, Open  ]],

Cell[CellGroupData[{

Cell["Control Panel", "Subsection"],

Cell[TextData[{
  "The control window contains a set of panels to inspect the current \
geometry object, modify its material properties, select different camera type \
and to configure the active display.\nThe control panel may be opened in \
different ways:\n1. Click inside a display with the right mouse button and \
select the item 'Control Panel' from the popup menu.\n2. Ask the viewer \
manager to show the control panel, see below.\n3. If ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " is called from the command line as in the command ",
  StyleBox["RunJavaView",
    FontFamily->"Courier New"],
  " then command line arguments may be specified like 'javaview \
panel=material control=show myDode.mgs' additional to a possible geometry \
file.\n4. If ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " runs inside an applet the applet parameters can be used to configure the \
initial setup like '<param name=config value=show>'."
}], "Text"],

Cell["\<\
If you did not keep your JavaView link from a session above then generate a \
new one.\
\>", "MathCaption"],

Cell[BoxData[{
    \(<< JavaView`JLink`\), "\[IndentingNewLine]", 
    \(viewer\  = \ InstallJavaView[]\)}], "Input",
  CellLabel->"In[28]:="],

Cell[TextData[{
  "Show the control window to inspect and configure the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " scene. Here we make use of the viewer obtained from command ",
  StyleBox["InstallJavaView",
    FontFamily->"Courier New"],
  " and the automatic preloading of the interface class PsViewerIf."
}], "MathCaption"],

Cell[BoxData[{
    \(\(viewer@showPanel[PsViewerIf`MATERIAL];\)\), "\[IndentingNewLine]", 
    \(viewer@showDialog[PsViewerIf`CONTROL]\)}], "Input",
  CellLabel->"In[68]:="],

Cell[TextData[{
  "Java has some problems in bringing windows to the front, so the control \
panel might be hidden behind other windows. J/Link provides a special frame \
subclass to bring windows in front of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " but the current version of the viewer manager creates an own specialized \
frame."
}], "Text"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Acknowledgements", "Section"],

Cell[TextData[{
  "Although this text consists of informal notes, I would like use the \
opportunity to include thanks to Paul Wellin and Tom Wickham-Jones from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " for pointing my attention to J/Link and providing a development edition \
of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", and to Todd Gayley who designed the marvellous J/Link package and \
answered my numerous questions. In many aspects, J/Link is this perfect \
interface to allow true interactive, high level integration of mathematical \
software which I was looking for a long time."
}], "Text"],

Cell[TextData[{
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " is software written by Konrad Polthier with Klaus Hildebrandt, Eike Preu\
\[SZ], and Ulrich Reitebuch. Other contributors are listed in the About menu \
of JavaView. The ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics parser in ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " is written by Ulrich Reitebuch, and the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " interface to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is designed and developed by Konrad Polthier."
}], "Text"]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 938}},
ScreenStyleEnvironment->"Brackets",
WindowToolbars->"EditBar",
CellGrouping->Manual,
WindowSize->{922, 904},
WindowMargins->{{1, Automatic}, {Automatic, 0}},
ShowCellTags->True,
Magnification->1.25,
StyleDefinitions -> "HelpBrowser.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Sect_Obtaining Java"->{
    Cell[12977, 444, 162, 6, 73, "Subsection",
      CellTags->"Sect_Obtaining Java"]},
  "Sect_Using Microsoft Java"->{
    Cell[23499, 799, 125, 2, 73, "Subsection",
      CellTags->"Sect_Using Microsoft Java"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Sect_Obtaining Java", 139742, 4432},
  {"Sect_Using Microsoft Java", 139863, 4435}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 239, 9, 72, "Chapter",
  CellGroupingRules->"SectionGrouping"],
Cell[1981, 62, 157, 4, 32, "Text",
  CellGroupingRules->"SectionGrouping"],

Cell[CellGroupData[{
Cell[2163, 70, 95, 1, 70, InheritFromParent],
Cell[2261, 73, 762, 20, 272, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3060, 98, 31, 0, 77, "Section"],
Cell[3094, 100, 875, 24, 86, "Text"],
Cell[3972, 126, 949, 30, 86, "Text"],
Cell[4924, 158, 1271, 28, 158, "Text"],
Cell[6198, 188, 140, 6, 19, "Caption"],
Cell[6341, 196, 410, 10, 67, "Text"],
Cell[6754, 208, 980, 27, 105, "Text"],
Cell[7737, 237, 469, 14, 48, "Text"],
Cell[8209, 253, 373, 12, 48, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[8619, 270, 31, 0, 59, "Section"],
Cell[8653, 272, 644, 24, 67, "Text"],
Cell[9300, 298, 175, 8, 36, "MathCaption"],
Cell[9478, 308, 120, 5, 36, "NumberedEquation"],
Cell[9601, 315, 217, 8, 36, "NumberedEquation"],
Cell[9821, 325, 213, 8, 36, "NumberedEquation"],
Cell[10037, 335, 168, 5, 36, "NumberedEquation"],
Cell[10208, 342, 1298, 47, 87, "Text"],
Cell[11509, 391, 544, 18, 48, "Text"],
Cell[12056, 411, 896, 29, 87, "Text"],

Cell[CellGroupData[{
Cell[12977, 444, 162, 6, 73, "Subsection",
  CellTags->"Sect_Obtaining Java"],

Cell[CellGroupData[{
Cell[13164, 454, 63, 0, 42, "Subsubsection"],
Cell[13230, 456, 403, 10, 67, "Text"],
Cell[13636, 468, 435, 9, 67, "Text"],
Cell[14074, 479, 260, 7, 29, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14371, 491, 241, 8, 42, "Subsubsection"],
Cell[14615, 501, 523, 16, 67, "Text"],
Cell[15141, 519, 309, 5, 67, "Text"],
Cell[15453, 526, 32, 0, 36, "Program"],
Cell[15488, 528, 274, 5, 48, "Text"],
Cell[15765, 535, 371, 6, 67, "Text"],
Cell[16139, 543, 167, 5, 29, "Text"],
Cell[16309, 550, 42, 0, 42, "Subsubsection"],
Cell[16354, 552, 568, 15, 67, "Text"],
Cell[16925, 569, 34, 0, 42, "Subsubsection"],
Cell[16962, 571, 450, 14, 48, "Text"],
Cell[17415, 587, 30, 0, 42, "Subsubsection"],
Cell[17448, 589, 855, 19, 86, "Text"],
Cell[18306, 610, 32, 0, 42, "Subsubsection"],
Cell[18341, 612, 267, 7, 29, "Text"],
Cell[18611, 621, 28, 0, 42, "Subsubsection"],
Cell[18642, 623, 314, 7, 48, "Text"],
Cell[18959, 632, 30, 0, 42, "Subsubsection"],
Cell[18992, 634, 227, 7, 29, "Text"],
Cell[19222, 643, 38, 0, 42, "Subsubsection"],
Cell[19263, 645, 197, 7, 29, "Text"]
}, Closed]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[19521, 659, 38, 0, 59, "Section"],
Cell[19562, 661, 625, 23, 48, "Text"],
Cell[20190, 686, 550, 14, 67, "Text"],

Cell[CellGroupData[{
Cell[20765, 704, 174, 8, 36, "MathCaption"],
Cell[20942, 714, 60, 0, 36, "NumberedEquation"],
Cell[21005, 716, 54, 0, 36, "NumberedEquation"],
Cell[21062, 718, 110, 2, 36, "NumberedEquation"],
Cell[21175, 722, 286, 5, 55, "NumberedEquation"],
Cell[21464, 729, 200, 7, 36, "NumberedEquation"]
}, Open  ]],
Cell[21679, 739, 644, 21, 48, "Text"],
Cell[22326, 762, 290, 6, 48, "Text"],
Cell[22619, 770, 855, 25, 86, "Text"],

Cell[CellGroupData[{
Cell[23499, 799, 125, 2, 73, "Subsection",
  CellTags->"Sect_Using Microsoft Java"],
Cell[23627, 803, 882, 26, 105, "Text"],
Cell[24512, 831, 569, 15, 67, "Text"],
Cell[25084, 848, 203, 6, 112, "Program"]
}, Open  ]],

Cell[CellGroupData[{
Cell[25324, 859, 184, 7, 56, "Subsection"],
Cell[25511, 868, 459, 13, 67, "Text"],
Cell[25973, 883, 96, 2, 29, "Text"],
Cell[26072, 887, 702, 16, 86, "Text"],
Cell[26777, 905, 740, 20, 86, "Text"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[27566, 931, 122, 5, 59, "Section"],
Cell[27691, 938, 606, 16, 67, "Text"],

Cell[CellGroupData[{
Cell[28322, 958, 31, 0, 77, "Section"],
Cell[28356, 960, 391, 10, 48, "Text"],
Cell[28750, 972, 183, 4, 48, "Text"],
Cell[28936, 978, 111, 3, 36, "MathCaption"],
Cell[29050, 983, 32, 0, 36, "Program"],
Cell[29085, 985, 384, 10, 48, "Text"],
Cell[29472, 997, 590, 10, 86, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[30099, 1012, 50, 0, 77, "Section"],
Cell[30152, 1014, 520, 17, 48, "Text"],

Cell[CellGroupData[{
Cell[30697, 1035, 53, 0, 56, "Subsection"],
Cell[30753, 1037, 268, 8, 29, "Text"],
Cell[31024, 1047, 76, 2, 33, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[31137, 1054, 46, 0, 56, "Subsection"],
Cell[31186, 1056, 216, 7, 29, "Text"],
Cell[31405, 1065, 286, 8, 51, "DefinitionBox"],
Cell[31694, 1075, 103, 4, 19, "Caption"],
Cell[31800, 1081, 58, 0, 36, "MathCaption"],
Cell[31861, 1083, 83, 2, 33, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[31981, 1090, 37, 0, 56, "Subsection"],
Cell[32021, 1092, 292, 8, 30, "Text"],
Cell[32316, 1102, 377, 10, 53, "DefinitionBox"],
Cell[32696, 1114, 46, 0, 19, "Caption"],
Cell[32745, 1116, 53, 0, 36, "MathCaption"],
Cell[32801, 1118, 70, 2, 33, "Input"],
Cell[32874, 1122, 1104, 28, 133, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[34027, 1156, 52, 0, 77, "Section"],
Cell[34082, 1158, 565, 16, 67, "Text"],

Cell[CellGroupData[{
Cell[34672, 1178, 55, 0, 56, "Subsection"],
Cell[34730, 1180, 272, 8, 29, "Text"],
Cell[35005, 1190, 75, 2, 33, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[35117, 1197, 43, 0, 56, "Subsection"],
Cell[35163, 1199, 292, 8, 30, "Text"],
Cell[35458, 1209, 1745, 51, 71, "DefinitionBox"],
Cell[37206, 1262, 46, 0, 19, "Caption"],
Cell[37255, 1264, 55, 0, 36, "MathCaption"],
Cell[37313, 1266, 83, 2, 33, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[37433, 1273, 51, 0, 56, "Subsection"],
Cell[37487, 1275, 243, 6, 48, "Text"],
Cell[37733, 1283, 84, 1, 36, "MathCaption"],
Cell[37820, 1286, 253, 6, 75, "Input"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[38134, 1299, 45, 0, 59, "Section"],
Cell[38182, 1301, 415, 10, 67, "Text"],
Cell[38600, 1313, 7938, 226, 245, "DefinitionBox"],
Cell[46541, 1541, 52, 0, 19, "Caption"],
Cell[46596, 1543, 641, 15, 94, "Text"],
Cell[47240, 1560, 62, 0, 36, "MathCaption"],
Cell[47305, 1562, 80, 2, 33, "Input"],
Cell[47388, 1566, 65, 0, 36, "MathCaption"],
Cell[47456, 1568, 149, 3, 54, "Input"],
Cell[47608, 1573, 37, 0, 36, "MathCaption"],
Cell[47648, 1575, 77, 2, 33, "Input"],
Cell[47728, 1579, 233, 6, 48, "Text"],
Cell[47964, 1587, 234, 8, 36, "MathCaption"],
Cell[48201, 1597, 295, 7, 75, "Input"],
Cell[48499, 1606, 97, 2, 36, "MathCaption"],
Cell[48599, 1610, 108, 2, 33, "Input"],
Cell[48710, 1614, 100, 2, 36, "MathCaption"],
Cell[48813, 1618, 818, 16, 159, "Input"],
Cell[49634, 1636, 67, 0, 36, "MathCaption"],
Cell[49704, 1638, 102, 2, 33, "Input"],

Cell[CellGroupData[{
Cell[49831, 1644, 44, 0, 56, "Subsection"],
Cell[49878, 1646, 797, 25, 94, "Text"],
Cell[50678, 1673, 203, 8, 36, "MathCaption"],
Cell[50884, 1683, 131, 3, 33, "Input"],
Cell[51018, 1688, 75, 2, 33, "Input"],
Cell[51096, 1692, 886, 28, 86, "Text"],
Cell[51985, 1722, 395, 15, 37, "MathCaption"],
Cell[52383, 1739, 79, 2, 33, "Input"],
Cell[52465, 1743, 133, 5, 42, "Subsubsection"],
Cell[52601, 1750, 635, 17, 94, "Text"],
Cell[53239, 1769, 124, 4, 36, "MathCaption"],
Cell[53366, 1775, 155, 5, 33, "Input"],
Cell[53524, 1782, 193, 5, 36, "MathCaption"],
Cell[53720, 1789, 73, 1, 33, "Input"],
Cell[53796, 1792, 136, 4, 36, "MathCaption"],
Cell[53935, 1798, 98, 2, 33, "Input"],
Cell[54036, 1802, 146, 5, 36, "MathCaption"],
Cell[54185, 1809, 168, 4, 33, "Input"],
Cell[54356, 1815, 154, 6, 36, "MathCaption"],
Cell[54513, 1823, 151, 4, 33, "Input"],
Cell[54667, 1829, 187, 9, 36, "MathCaption"],
Cell[54857, 1840, 84, 2, 33, "Input"],
Cell[54944, 1844, 156, 5, 29, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[55137, 1854, 47, 0, 56, "Subsection"],
Cell[55187, 1856, 689, 18, 113, "Text"],
Cell[55879, 1876, 139, 3, 54, "Input"],
Cell[56021, 1881, 74, 2, 33, "Input"],
Cell[56098, 1885, 99, 2, 36, "MathCaption"],
Cell[56200, 1889, 169, 4, 54, "Input"],
Cell[56372, 1895, 240, 6, 55, "MathCaption"],
Cell[56615, 1903, 236, 5, 75, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[56888, 1913, 60, 0, 56, "Subsection"],
Cell[56951, 1915, 488, 11, 67, "Text"],
Cell[57442, 1928, 232, 6, 48, "Text"],
Cell[57677, 1936, 233, 8, 36, "MathCaption"],
Cell[57913, 1946, 211, 4, 54, "Input"],
Cell[58127, 1952, 126, 3, 36, "MathCaption"],
Cell[58256, 1957, 174, 4, 54, "Input"],
Cell[58433, 1963, 164, 5, 36, "MathCaption"],
Cell[58600, 1970, 165, 3, 54, "Input"],
Cell[58768, 1975, 211, 8, 29, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[59016, 1988, 47, 0, 56, "Subsection"],
Cell[59066, 1990, 290, 9, 48, "Text"],
Cell[59359, 2001, 703, 18, 113, "Text"],
Cell[60065, 2021, 60, 0, 36, "MathCaption"],
Cell[60128, 2023, 155, 4, 33, "Input"],
Cell[60286, 2029, 231, 6, 55, "MathCaption"],
Cell[60520, 2037, 98, 2, 33, "Input"],
Cell[60621, 2041, 230, 6, 48, "Text"],
Cell[60854, 2049, 509, 16, 48, "Text"],

Cell[CellGroupData[{
Cell[61388, 2069, 57, 0, 42, "Subsubsection"],
Cell[61448, 2071, 802, 18, 132, "Text"],
Cell[62253, 2091, 545, 12, 94, "Text"],
Cell[62801, 2105, 140, 3, 36, "MathCaption"],
Cell[62944, 2110, 352, 6, 96, "Input"],
Cell[63299, 2118, 193, 5, 29, "Text"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[63553, 2130, 40, 0, 59, "Section"],
Cell[63596, 2132, 610, 20, 67, "Text"],
Cell[64209, 2154, 8702, 219, 165, "DefinitionBox"],
Cell[72914, 2375, 237, 11, 19, "Caption"],
Cell[73154, 2388, 873, 30, 67, "Text"],

Cell[CellGroupData[{
Cell[74052, 2422, 219, 8, 29, "Text"],
Cell[74274, 2432, 864, 28, 86, "Text"],
Cell[75141, 2462, 203, 6, 112, "Program"]
}, Closed]],
Cell[75359, 2471, 1066, 31, 107, "Text"],

Cell[CellGroupData[{
Cell[76450, 2506, 110, 5, 42, "Subsubsection"],
Cell[76563, 2513, 175, 7, 36, "MathCaption"],

Cell[CellGroupData[{
Cell[76763, 2524, 146, 3, 54, "Input"],
Cell[76912, 2529, 161, 3, 48, "Print"]
}, Open  ]],
Cell[77088, 2535, 70, 0, 36, "MathCaption"],
Cell[77161, 2537, 79, 2, 33, "Input"],
Cell[77243, 2541, 543, 20, 48, "Text"],
Cell[77789, 2563, 84, 1, 36, "MathCaption"],
Cell[77876, 2566, 97, 2, 33, "Input"],
Cell[77976, 2570, 163, 5, 33, "Input"],
Cell[78142, 2577, 193, 5, 36, "MathCaption"],
Cell[78338, 2584, 73, 2, 33, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[78448, 2591, 71, 0, 38, "Subsubsection"],
Cell[78522, 2593, 724, 20, 86, "Text"],
Cell[79249, 2615, 157, 5, 29, "Text"],
Cell[79409, 2622, 72, 0, 36, "MathCaption"],
Cell[79484, 2624, 672, 17, 54, "Input"],
Cell[80159, 2643, 75, 2, 33, "Input"],
Cell[80237, 2647, 116, 3, 36, "MathCaption"],
Cell[80356, 2652, 385, 7, 96, "Input"],
Cell[80744, 2661, 76, 2, 33, "Input"],
Cell[80823, 2665, 76, 0, 36, "MathCaption"],
Cell[80902, 2667, 305, 8, 75, "Input"],
Cell[81210, 2677, 71, 2, 33, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[81318, 2684, 85, 1, 38, "Subsubsection"],
Cell[81406, 2687, 322, 10, 48, "Text"],
Cell[81731, 2699, 155, 5, 36, "MathCaption"],
Cell[81889, 2706, 274, 7, 75, "Input"],
Cell[82166, 2715, 69, 2, 33, "Input"],
Cell[82238, 2719, 76, 0, 36, "MathCaption"],
Cell[82317, 2721, 353, 8, 75, "Input"],
Cell[82673, 2731, 69, 0, 36, "MathCaption"],
Cell[82745, 2733, 580, 13, 138, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[83362, 2751, 66, 0, 38, "Subsubsection"],
Cell[83431, 2753, 202, 5, 29, "Text"],
Cell[83636, 2760, 51, 0, 36, "MathCaption"],
Cell[83690, 2762, 171, 3, 54, "Input"],
Cell[83864, 2767, 171, 5, 33, "Input"],
Cell[84038, 2774, 61, 0, 36, "MathCaption"],
Cell[84102, 2776, 164, 3, 54, "Input"],
Cell[84269, 2781, 343, 11, 54, "Input"],
Cell[84615, 2794, 519, 10, 67, "Text"],
Cell[85137, 2806, 120, 3, 36, "MathCaption"],
Cell[85260, 2811, 93, 2, 33, "Input"],
Cell[85356, 2815, 51, 0, 36, "MathCaption"],

Cell[CellGroupData[{
Cell[85432, 2819, 209, 4, 75, "Input"],
Cell[85644, 2825, 63, 2, 27, "Output"]
}, Open  ]],
Cell[85722, 2830, 729, 11, 113, "Text"],
Cell[86454, 2843, 72, 0, 36, "MathCaption"],
Cell[86529, 2845, 423, 13, 54, "Input"],
Cell[86955, 2860, 143, 3, 54, "Input"],
Cell[87101, 2865, 329, 7, 48, "Text"],
Cell[87433, 2874, 56, 0, 36, "MathCaption"],
Cell[87492, 2876, 88, 2, 33, "Input"],
Cell[87583, 2880, 425, 9, 27, "Output"],

Cell[CellGroupData[{
Cell[88033, 2893, 153, 3, 54, "Input"],
Cell[88189, 2898, 63, 2, 27, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[88301, 2906, 132, 4, 38, "Subsubsection"],
Cell[88436, 2912, 1130, 32, 106, "Text"],
Cell[89569, 2946, 170, 3, 29, "Text"],
Cell[89742, 2951, 150, 3, 36, "MathCaption"],
Cell[89895, 2956, 203, 6, 33, "Input"],
Cell[90101, 2964, 183, 5, 36, "MathCaption"],
Cell[90287, 2971, 207, 4, 75, "Input"],
Cell[90497, 2977, 286, 6, 55, "MathCaption"],
Cell[90786, 2985, 79, 2, 33, "Input"],
Cell[90868, 2989, 123, 3, 36, "MathCaption"],
Cell[90994, 2994, 74, 2, 33, "Input"],
Cell[91071, 2998, 455, 13, 74, "MathCaption"],
Cell[91529, 3013, 140, 3, 54, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[91706, 3021, 51, 0, 38, "Subsubsection"],
Cell[91760, 3023, 981, 22, 132, "Text"],
Cell[92744, 3047, 179, 5, 36, "MathCaption"],
Cell[92926, 3054, 265, 6, 54, "Input"],
Cell[93194, 3062, 185, 4, 55, "MathCaption"],
Cell[93382, 3068, 205, 4, 75, "Input"],
Cell[93590, 3074, 289, 6, 48, "Text"],
Cell[93882, 3082, 66, 0, 36, "MathCaption"],
Cell[93951, 3084, 268, 5, 96, "Input"],
Cell[94222, 3091, 636, 13, 86, "Text"],
Cell[94861, 3106, 441, 11, 67, "Text"],
Cell[95305, 3119, 166, 3, 55, "MathCaption"],
Cell[95474, 3124, 150, 3, 54, "Input"],
Cell[95627, 3129, 50, 0, 36, "MathCaption"],
Cell[95680, 3131, 145, 3, 54, "Input"],
Cell[95828, 3136, 281, 7, 48, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[96146, 3148, 127, 5, 38, "Subsubsection"],
Cell[96276, 3155, 1899, 54, 224, "Text"],
Cell[98178, 3211, 175, 7, 36, "MathCaption"],
Cell[98356, 3220, 146, 3, 54, "Input"],
Cell[98505, 3225, 67, 0, 36, "MathCaption"],
Cell[98575, 3227, 88, 2, 33, "Input"],
Cell[98666, 3231, 160, 5, 36, "MathCaption"],
Cell[98829, 3238, 317, 6, 117, "Input"],
Cell[99149, 3246, 156, 5, 36, "MathCaption"],
Cell[99308, 3253, 261, 6, 75, "Input"],
Cell[99572, 3261, 1128, 30, 105, "Text"],
Cell[100703, 3293, 166, 5, 36, "MathCaption"],
Cell[100872, 3300, 70, 2, 33, "Input"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[100991, 3308, 44, 0, 77, "Section"],

Cell[CellGroupData[{
Cell[101060, 3312, 38, 0, 56, "Subsection"],
Cell[101101, 3314, 208, 4, 48, "Text"],
Cell[101312, 3320, 1752, 48, 119, "DefinitionBox"],
Cell[103067, 3370, 45, 0, 19, "Caption"],
Cell[103115, 3372, 35, 0, 36, "MathCaption"],
Cell[103153, 3374, 66, 2, 33, "Input"],
Cell[103222, 3378, 47, 0, 36, "MathCaption"],
Cell[103272, 3380, 70, 2, 33, "Input"],
Cell[103345, 3384, 184, 6, 36, "MathCaption"],
Cell[103532, 3392, 309, 6, 54, "Input"],
Cell[103844, 3400, 578, 11, 94, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[104459, 3416, 43, 0, 52, "Subsection"],
Cell[104505, 3418, 468, 8, 67, "Text"],
Cell[104976, 3428, 2730, 77, 119, "DefinitionBox"],
Cell[107709, 3507, 56, 0, 19, "Caption"],
Cell[107768, 3509, 391, 10, 48, "Text"],
Cell[108162, 3521, 71, 0, 36, "MathCaption"],
Cell[108236, 3523, 178, 3, 54, "Input"],
Cell[108417, 3528, 65, 0, 36, "MathCaption"],
Cell[108485, 3530, 121, 3, 54, "Input"],
Cell[108609, 3535, 81, 2, 33, "Input"],
Cell[108693, 3539, 74, 2, 33, "Input"],
Cell[108770, 3543, 553, 12, 68, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[109360, 3560, 40, 0, 52, "Subsection"],
Cell[109403, 3562, 207, 6, 29, "Text"],
Cell[109613, 3570, 285, 5, 48, "Text"],
Cell[109901, 3577, 186, 4, 48, "Text"],
Cell[110090, 3583, 2315, 61, 125, "DefinitionBox"],
Cell[112408, 3646, 53, 0, 19, "Caption"],
Cell[112464, 3648, 378, 12, 48, "Text"],
Cell[112845, 3662, 103, 2, 36, "MathCaption"],
Cell[112951, 3666, 153, 3, 54, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[113141, 3674, 118, 4, 52, "Subsection"],
Cell[113262, 3680, 561, 14, 94, "Text"],
Cell[113826, 3696, 195, 5, 36, "MathCaption"],
Cell[114024, 3703, 323, 7, 96, "Input"],
Cell[114350, 3712, 283, 9, 48, "Text"],
Cell[114636, 3723, 166, 5, 36, "MathCaption"],
Cell[114805, 3730, 83, 2, 33, "Input"],
Cell[114891, 3734, 183, 4, 75, "Input"],
Cell[115077, 3740, 113, 3, 36, "MathCaption"],
Cell[115193, 3745, 102, 2, 33, "Input"],
Cell[115298, 3749, 73, 2, 33, "Input"],
Cell[115374, 3753, 50, 0, 36, "MathCaption"],
Cell[115427, 3755, 166, 3, 54, "Input"],
Cell[115596, 3760, 106, 2, 36, "MathCaption"],
Cell[115705, 3764, 105, 2, 33, "Input"],
Cell[115813, 3768, 131, 3, 36, "MathCaption"],
Cell[115947, 3773, 94, 2, 33, "Input"],
Cell[116044, 3777, 192, 6, 29, "Text"],
Cell[116239, 3785, 134, 3, 36, "MathCaption"],
Cell[116376, 3790, 229, 6, 54, "Input"],
Cell[116608, 3798, 81, 2, 33, "Input"],
Cell[116692, 3802, 264, 8, 48, "Text"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[117005, 3816, 49, 0, 59, "Section"],
Cell[117057, 3818, 466, 14, 48, "Text"],
Cell[117526, 3834, 439, 10, 75, "Text"],
Cell[117968, 3846, 433, 7, 67, "Text"],

Cell[CellGroupData[{
Cell[118426, 3857, 145, 5, 36, "MathCaption"],
Cell[118574, 3864, 382, 9, 48, "Text"],
Cell[118959, 3875, 13974, 357, 2055, "DefinitionBox"],
Cell[132936, 4234, 135, 5, 19, "Caption"]
}, Open  ]],

Cell[CellGroupData[{
Cell[133108, 4244, 74, 0, 36, "MathCaption"],
Cell[133185, 4246, 393, 8, 67, "Text"],
Cell[133581, 4256, 370, 6, 67, "Text"],
Cell[133954, 4264, 386, 6, 67, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[134377, 4275, 53, 0, 36, "MathCaption"],
Cell[134433, 4277, 286, 8, 48, "Text"],
Cell[134722, 4287, 129, 4, 29, "Text"],
Cell[134854, 4293, 570, 11, 148, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[135461, 4309, 35, 0, 56, "Subsection"],
Cell[135499, 4311, 965, 19, 202, "Text"],
Cell[136467, 4332, 117, 3, 36, "MathCaption"],
Cell[136587, 4337, 142, 3, 54, "Input"],
Cell[136732, 4342, 340, 8, 55, "MathCaption"],
Cell[137075, 4352, 173, 3, 54, "Input"],
Cell[137251, 4357, 362, 8, 48, "Text"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[137662, 4371, 35, 0, 59, "Section"],
Cell[137700, 4373, 635, 13, 86, "Text"],
Cell[138338, 4388, 599, 18, 67, "Text"]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

