(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      8271,        267]*)
(*NotebookOutlinePosition[     10087,        320]*)
(*  CellTagsIndexPosition[     10043,        316]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  "Camera Events from ",
  StyleBox["JavaView",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " Display\n",
  StyleBox["\tby Konrad Polthier\n\t",
    FontSize->16],
  StyleBox["(v. 1.03, 14.11.04)",
    FontSize->16,
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}]
}], "Chapter",
  CellGroupingRules->"SectionGrouping",
  TextAlignment->Left],

Cell[TextData[{
  "When the JavaView display is opened, rotate the torus with the mouse. The \
camera events are caught by ",
  StyleBox["Mathematica.",
    FontSlant->"Italic"],
  " The viewing direction of the camera is interpreted as rgb values and used \
to set the surface color immediately. As an effect the surface color will \
continuously change during rotation."
}], "Text"],

Cell["\<\
This notebook tests the camera listener class \"jvx.math.MathCameraListener\" \
of JavaView. This listener operates asynchronously by starting another thread \
for the event handling. This avoids delays during the rotation and user \
perceiption of the ongoing event handling.\
\>", "Text"],

Cell[CellGroupData[{

Cell[TextData[{
  "Load Java runtime into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and load JavaView."
}], "MathCaption"],

Cell[BoxData[{
    \(<< JavaView`JLink`\), "\n", 
    \(\(viewer = InstallJavaView[];\)\)}], "Input",
  CellLabel->"In[40]:="],

Cell["\<\
Get the active JavaView 3d-display to be able to register the event handler \
below.\
\>", "MathCaption"],

Cell[BoxData[
    \(\(disp = viewer@getDisplay[];\)\)], "Input",
  CellLabel->"In[42]:="],

Cell["Create a sample geometry.", "MathCaption"],

Cell[BoxData[{
    \(\(geom\  = \ 
        JavaNew["\<jv.geom.PgElementSet\>", 3];\)\), "\[IndentingNewLine]", 
    \(\(geom@computeTorus[10, 10, 2. , 1. ];\)\)}], "Input",
  CellLabel->"In[43]:="],

Cell["Show sample geometry in JavaView display.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      StyleBox["JavaView",
        FontSlant->"Plain"], "[", "geom", "]"}]], "Input",
  CellLabel->"In[45]:="],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]JavaObject[
          "jv.geom.PgElementSet"] \[RightGuillemet]\),
      JLink`Objects`JavaObject22800236545]], "Output",
  CellLabel->"Out[45]="]
}, Open  ]],

Cell["\<\
This function will be called upon camera events. The argument evt is instance \
of jv.project.PvCameraEvent. Here we interpret the viewing direction of the \
camera as vector on the 1_sphere in rgb color space.\
\>", "MathCaption"],

Cell[BoxData[
    RowBox[{
      StyleBox[\(evalCameraPosition[evt_, message_]\),
        "InlineInput"], 
      StyleBox[":=",
        "InlineInput"], 
      StyleBox["\[IndentingNewLine]",
        "InlineInput"], 
      StyleBox["\t",
        "InlineInput"], 
      RowBox[{
        StyleBox["JavaBlock",
          "InlineInput"], 
        StyleBox["[",
          "InlineInput"], 
        StyleBox["\[IndentingNewLine]",
          "InlineInput"], "\t\t", 
        StyleBox[\(\(dir = evt@getViewDir[];\)\[IndentingNewLine]
          \t\t\(rgb = Abs[dir@getEntries[]];\)\[IndentingNewLine]
          \t\t\(col = 
              JavaNew["\<java.awt.Color\>", rgb[\([1]\)], rgb[\([2]\)], 
                rgb[\([3]\)]];\)\[IndentingNewLine]
          \t\t\(geom@setGlobalElementColor[col];\)\[IndentingNewLine]
          \t\t\(geom@update[geom];\)\[IndentingNewLine]
          \t\tReleaseObject[evt]\),
          "InlineInput"], 
        StyleBox["\[IndentingNewLine]",
          "InlineInput"], 
        StyleBox["\t",
          "InlineInput"], 
        StyleBox["]",
          "InlineInput"]}]}]], "Input",
  CellLabel->"In[46]:="],

Cell["Register a listener of camera events in the 2D-display.", "MathCaption"],

Cell[BoxData[{
    \(\(listener = 
        JavaNew["\<jvx.math.MathCameraListener\>"];\)\), \
"\[IndentingNewLine]", 
    \(\(listener@
        setHandler["\<pickCamera\>", "\<evalCameraPosition\>"];\)\), "\
\[IndentingNewLine]", 
    \(\(listener@
        setHandler["\<dragCamera\>", "\<evalCameraPosition\>"];\)\), "\
\[IndentingNewLine]", 
    \(\(disp@addCameraListener[listener];\)\)}], "Input",
  CellLabel->"In[47]:="],

Cell["\<\
Share the kernel to allow further interaction with the geometry and display. \
After this call, rotate the surface inside the display and see the surface \
color changing.\
\>", "MathCaption"],

Cell[BoxData[
    \(ShareKernel[]\)], "Input",
  CellLabel->"In[53]:="],

Cell[BoxData[
    \(3\)], "Output",
  CellLabel->"Out[53]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "When done with interaction, then call UnshareKernel[]. After calling \
UnshareKernel[] ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " will no longer receive events from ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " unless ShareKernel[] is called again."
}], "MathCaption"],

Cell[BoxData[
    \(UnshareKernel[]\)], "Input",
  CellLabel->"(sharing) In[54]:="]
}, Open  ]],

Cell["Auto-rotation", "Subsubsection"],

Cell[TextData[{
  "After having rotated the surface by hand you might want to switch to \
auto-rotate mode by pressing the w-key while mouse focus is in the display, \
or from within ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". The surface will then continuously rotate. Pressing the q-key will stop \
auto-rotate mode. Open the control panel to view and modify material \
properties of the surface."
}], "Text"],

Cell[TextData[{
  "Enable auto-rotation in display from within ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". First specify rotation axis and angle increments, and then let the \
display run. Alternatively, use the w-key."
}], "MathCaption"],

Cell[BoxData[{
    \(\(axis = 
        JavaNew["\<jv.vecmath.PdVector\>", 0. , 1. , 
          0. ];\)\), "\[IndentingNewLine]", 
    \(disp@setAutoRotation[axis, Pi/30. ]\), "\[IndentingNewLine]", 
    \(\(disp@setEnabledAnimation[True];\)\), "\[IndentingNewLine]", 
    \(disp@start[]\)}], "Input",
  CellLabel->"(sharing) In[17]:="],

Cell["\<\
Press the w-key while mouse focus is over the display to enable \
auto-rotation. Use the q-key to stop auto-rotation.\
\>", "MathCaption"],

Cell["\<\
Use right-mouse click within the display to open the control panel. See the \
surface color continuously changing in the material panel.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell["Finally, stop sharing the kernel.", "Subsubsection"],

Cell[BoxData[
    \(\(UnshareKernel[];\)\)], "Input",
  CellLabel->"(sharing) In[21]:="]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1400}, {0, 998}},
AutoGeneratedPackage->None,
ScreenStyleEnvironment->"Brackets",
CellGrouping->Manual,
WindowSize->{703, 949},
WindowMargins->{{Automatic, 66}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Inherited, Cell[ 
        TextData[ {"Konrad Polthier"}], "PageHeader"]}, {Cell[ 
        TextData[ {"The ", 
          StyleBox[ "JavaView", FontSlant -> "Italic"], " Packages"}], 
        "PageHeader"], Inherited, Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"]}},
PageFooters->{{Inherited, Cell[ 
        TextData[ {
          "\[Copyright]1999 Wolfram Research, Inc. All rights reserved."}], 
        "PageFooter"], Inherited}, {Inherited, Cell[ 
        TextData[ {
          "\[Copyright]1999 Wolfram Research, Inc. All rights reserved."}], 
        "PageFooter"], Inherited}},
PageFooterLines->{True, True},
PrintingOptions->{"PrintingMargins"->{{57.375, 57.375}, {57.375, 57.375}},
"PrintCellBrackets"->True,
"PrintRegistrationMarks"->False,
"PrintMultipleHorizontalPages"->False,
"FacingPages"->True},
CellLabelAutoDelete->False,
Magnification->1.25,
StyleDefinitions -> "HelpBrowser.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 412, 14, 124, "Chapter",
  CellGroupingRules->"SectionGrouping"],
Cell[2132, 65, 384, 8, 67, "Text"],
Cell[2519, 75, 300, 5, 67, "Text"],

Cell[CellGroupData[{
Cell[2844, 84, 139, 5, 36, "MathCaption"],
Cell[2986, 91, 126, 3, 54, "Input"],
Cell[3115, 96, 115, 3, 36, "MathCaption"],
Cell[3233, 101, 89, 2, 33, "Input"],
Cell[3325, 105, 48, 0, 36, "MathCaption"],
Cell[3376, 107, 197, 4, 54, "Input"],
Cell[3576, 113, 64, 0, 36, "MathCaption"],

Cell[CellGroupData[{
Cell[3665, 117, 137, 4, 33, "Input"],
Cell[3805, 123, 200, 4, 27, "Output"]
}, Open  ]],
Cell[4020, 130, 241, 4, 74, "MathCaption"],
Cell[4264, 136, 1130, 32, 222, "Input"],
Cell[5397, 170, 78, 0, 36, "MathCaption"],
Cell[5478, 172, 426, 11, 96, "Input"],
Cell[5907, 185, 202, 4, 55, "MathCaption"],
Cell[6112, 191, 71, 2, 33, "Input"],
Cell[6186, 195, 60, 2, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6283, 202, 313, 9, 55, "MathCaption"],
Cell[6599, 213, 83, 2, 50, "Input"]
}, Open  ]],
Cell[6697, 218, 38, 0, 42, "Subsubsection"],
Cell[6738, 220, 427, 9, 86, "Text"],
Cell[7168, 231, 254, 6, 55, "MathCaption"],
Cell[7425, 239, 335, 7, 113, "Input"],
Cell[7763, 248, 148, 3, 55, "MathCaption"],
Cell[7914, 253, 167, 3, 55, "MathCaption"],

Cell[CellGroupData[{
Cell[8106, 260, 58, 0, 42, "Subsubsection"],
Cell[8167, 262, 88, 2, 50, "Input"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

