(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     33920,       1092]*)
(*NotebookOutlinePosition[     35624,       1142]*)
(*  CellTagsIndexPosition[     35580,       1138]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  "Sample Applications of the ",
  StyleBox["JavaView",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " Packages\n",
  StyleBox["\tby Konrad Polthier\n\t",
    FontSize->16],
  StyleBox["(Extended Sample Applications, Draft 0.95, 14.11.04)",
    FontSize->16,
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}]
}], "Chapter",
  CellGroupingRules->"SectionGrouping",
  TextAlignment->Left],

Cell[CellGroupData[{

Cell["Technical Comments", "Section",
  CellGroupingRules->"SectionGrouping"],

Cell[CellGroupData[{

Cell["A Reminder How to Setup JavaView`JLink`", "Subsubsection"],

Cell[TextData[{
  "The first step in using JavaView inside ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is the loading of the JavaView package. ",
  "This allows to use the commands RunJavaView[g] and JavaView[g] to \
visualize a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Graphics in a JavaView display."
}], "Text"],

Cell[TextData[{
  "Load the ",
  StyleBox["JavaView",
    FontFamily->"Trebuchet MS",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontTracking->"Plain",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " packages."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(<< JavaView`JLink`\), "\[IndentingNewLine]", 
    \(\(viewer\  = \ InstallJavaView[];\)\)}], "Input",
  CellLabel->"In[1]:="],

Cell[BoxData[
    \("JavaView CodeBase = \
C:/PROGRA~1/WOLFRA~1/MATHEM~1/4.0/AddOns/Applications/JavaView/"\)], "Print",
  CellLabel->"From In[1]:="]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
For experts, the loading and initialization of JavaView performs the \
following operations:\
\>", "SubsubsectionIcon"],

Cell["Load J/Link, here with a Microsoft virtual machine.", "MathCaption"],

Cell[BoxData[{
    \(Needs["\<JLink`\>"]\), "\[IndentingNewLine]", 
    \(\(InstallJava[];\)\)}], "Input",
  CellLabel->"In[100]:="],

Cell[TextData[{
  "Create a new JavaView display from viewer manager. Note, the window might \
appear behind ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " windows. This sequence of commands can be replaced with the command ",
  StyleBox["JavaView[]",
    FontFamily->"Courier New"],
  "."
}], "MathCaption"],

Cell[BoxData[{
    \(\(disp = 
        viewer@newDisplay["\<JavaView: From Mathematica\>", 
            True];\)\), "\[IndentingNewLine]", 
    \(\(frame = disp@getFrame[];\)\), "\[IndentingNewLine]", 
    \(\(frame@setSize[400, 400];\)\), "\[IndentingNewLine]", 
    \(\(JavaShow[frame];\)\)}], "Input",
  CellLabel->"In[102]:="],

Cell[TextData[{
  "Clear ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " from all Java processes. After calling UninstallJava[] the package \
JavaView`JLink` must be loaded again."
}], "MathCaption"],

Cell[BoxData[
    \(\(UninstallJava[];\)\)], "Input",
  CellLabel->"In[106]:="]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Initialization and Viewing of Graphics and Geometries", "Subsection",
  CellGroupingRules->"SectionGrouping"],

Cell[TextData[{
  "This sample shows the basic steps to load JavaView`JLink`, create a \
JavaView display window, and use two ways to display either a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics or a simple JavaView geometry."
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[{
  "Display a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Graphics"
}], "Subsubsection"],

Cell[TextData[{
  "Here we repeat the above step with a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics. The following set of commands would have been performed when ",
  StyleBox["JavaView[dode]",
    FontFamily->"Courier New"],
  " is called from a notebook. Here we repeat these commands step by step \
within this notebook."
}], "Text"],

Cell[TextData[{
  "Create a sample ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics."
}], "MathCaption"],

Cell[BoxData[{
    \(<< Graphics`Polyhedra`\), "\n", 
    \(\(dode = \ Graphics3D[Dodecahedron[]];\)\)}], "Input",
  CellLabel->"In[27]:="],

Cell[TextData[{
  "The ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics is first converted to ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " geometries. Since a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics may be a single geometry, a set of geometries combind in a \
single Graphics[] structure, or a list of geometries, the command ",
  StyleBox["ToJavaView[]",
    FontFamily->"Courier New"],
  " always returns a list of ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " geometries."
}], "Text"],

Cell[TextData[{
  "First, we convert the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics to one or more JavaView geometries."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(geomArr = ToJavaView[dode]\)], "Input",
  CellLabel->"In[29]:="],

Cell[BoxData[
    RowBox[{"{", 
      InterpretationBox[\(\[LeftGuillemet]JavaObject[
            "jv.geom.PgElementSet"] \[RightGuillemet]\),
        JLink`Objects`JavaObject21223178241], "}"}]], "Output",
  CellLabel->"Out[29]="]
}, Open  ]],

Cell["\<\
Add the JavaView geometry to the display. Fitting will center and scale the \
camera such that the geometry fills the available display area. Finally the \
display is updated to invoke a repaint.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(geom = geomArr[\([1]\)];\)\), "\[IndentingNewLine]", 
    \(\(disp@removeGeometries[];\)\), "\[IndentingNewLine]", 
    \(\(disp@addGeometry[geom];\)\), "\[IndentingNewLine]", 
    \(\(disp@fit[];\)\), "\[IndentingNewLine]", 
    \(disp@update[disp]\)}], "Input",
  CellLabel->"In[35]:="],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[39]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Display a JavaView Geometry", "Subsubsection"],

Cell["\<\
Here we create a second simple JavaView surface and show it in the display.\
\>", "Text"],

Cell["Create an empty JavaView surface geometry.", "MathCaption"],

Cell[BoxData[
    \(\(\(geom\  = \ 
        JavaNew["\<jv.geom.PgElementSet\>", 3];\)\(\ \)\)\)], "Input",
  CellLabel->"In[40]:="],

Cell["Compute a sample torus surface.", "MathCaption"],

Cell[BoxData[{
    \(\(geom@computeTorus[20, 15, 2. , \ 1. ];\)\), "\[IndentingNewLine]", 
    \(\(geom@setName["\<Torus\>"];\)\)}], "Input",
  CellLabel->"In[41]:="],

Cell[TextData[{
  "The following commands would have been performed when ",
  StyleBox["JavaView[dode, Replace->False]",
    FontFamily->"Courier New"],
  " is called from a notebook. Here we repeat these commands step by step \
within this notebook."
}], "Text"],

Cell["\<\
Add the geometry to the display. When the geometry has changed the method \
geom@update[geom] must be called to initiate a repaint in the display.\
\>", "MathCaption"],

Cell[BoxData[{
    \(\(disp@addGeometry[geom];\)\), "\[IndentingNewLine]", 
    \(\(disp@update[disp];\)\)}], "Input",
  CellLabel->"In[43]:="]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Manipulating a Geometry", "Subsection",
  CellGroupingRules->"SectionGrouping"],

Cell[TextData[{
  "This example uses ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to generate a vector field from interactive modifications of a JavaView \
geometry in the display.\n1. We create a sample sphere.\n2. We modify the \
sphere interactively in the JavaView display by dragging vertices around.\n3. \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is used to compute the difference between corresponding vertices of the \
original and the modified sphere as vector field.\n4. Mathematica assigns the \
offset vector field to the original sphere."
}], "Text"],

Cell["Create an empty sample geometry with JavaView", "MathCaption"],

Cell[BoxData[
    \(\(\(geom\  = \ 
        JavaNew["\<jv.geom.PgElementSet\>", 3];\)\(\ \)\)\)], "Input",
  CellLabel->"In[45]:="],

Cell["\<\
We remove its interior boundary, enable drawing of vertices and labels of \
indices.\
\>", "MathCaption"],

Cell[BoxData[{
    \(\(geom@computeSphere[6, 6, 1. ];\)\), "\[IndentingNewLine]", 
    \(\(geom@setName["\<Discrete Sphere\>"];\)\), "\[IndentingNewLine]", 
    \(\(geom@showVertices[True];\)\), "\[IndentingNewLine]", 
    \(\(geom@showIndices[True];\)\)}], "Input",
  CellLabel->"In[46]:="],

Cell[TextData[{
  "Show geometry in JavaView display, display opens on first call. Maybe \
hidden behind ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " windows."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(JavaView[geom]\)], "Input",
  CellLabel->"In[50]:="],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]JavaObject[
          "jv.geom.PgElementSet"] \[RightGuillemet]\),
      JLink`Objects`JavaObject4815060993]], "Output",
  CellLabel->"Out[50]="]
}, Open  ]],

Cell[TextData[{
  "Save a copy of the vertex array of the original sphere as ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " list of PdVector's. Print 15th vertex for testing."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(origVertex\  = \ 
        PdVector`getEntries[
          PdVector`copyNew[geom@getVertices[]]];\)\), "\[IndentingNewLine]", 
    \(origVertex[\([16]\)]\)}], "Input",
  CellLabel->"In[51]:="],

Cell[BoxData[
    \({\(-0.7694208842938133`\), 0.5590169943749476`, 
      0.3090169943749474`}\)], "Output",
  CellLabel->"Out[52]="]
}, Open  ]],

Cell[TextData[{
  "Before invoking the next command, pick vertex 15 in the display and move \
it slightly to a new position. Note the 15: Java starts array indices at 0 \
and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " at 1. The pick mode is temporarily enabled by keeping the p-key pressed, \
and then drag a single vertex. Move a few vertices. "
}], "Commentary",
  CellGroupingRules->"SectionGrouping"],

Cell[TextData[{
  "Save a copy of the vertex array of the modified sphere as ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " list of PdVector's. The 15th vertex should have changed."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(vertex\  = \ 
        PdVector`getEntries[
          PdVector`copyNew[geom@getVertices[]]];\)\), "\[IndentingNewLine]", 
    \(vertex[\([16]\)]\)}], "Input",
  CellLabel->"In[64]:="],

Cell[BoxData[
    \({\(-1.1341872210142445`\), 0.919549020632076`, 
      0.38182048870871227`}\)], "Output",
  CellLabel->"Out[65]="]
}, Open  ]],

Cell[TextData[{
  "Let ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " compute the distance vector for each vertex. The 15th vector should be \
non-zero."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(vector = Subtract[vertex, origVertex];\)\), "\[IndentingNewLine]", 
    \(vector[\([16]\)]\)}], "Input",
  CellLabel->"In[66]:="],

Cell[BoxData[
    \({\(-0.36476633672043124`\), 0.36053202625712844`, 
      0.07280349433376487`}\)], "Output",
  CellLabel->"Out[67]="]
}, Open  ]],

Cell["\<\
The method copyNew[] creates an array of PdVectors from an array of \
doubles.\
\>", "MathCaption"],

Cell[BoxData[
    \(\(pdv\  = \ PdVector`copyNew[vector];\)\)], "Input",
  CellLabel->"In[68]:="],

Cell["Create a vector field and assign the distance vectors.", "MathCaption"],

Cell[BoxData[{
    \(\(vf\  = \ 
        JavaNew["\<jv.geom.PgVectorField\>", 
          geom@getDimOfVertices[]];\)\), "\[IndentingNewLine]", 
    \(\(vf@setGeometry[geom];\)\), "\[IndentingNewLine]", 
    \(\(vf@setVectors[pdv];\)\)}], "Input",
  CellLabel->"In[69]:="],

Cell["\<\
Assign the vector field to the geometry, and initiate a repaint of the \
display. Before, we also restore the original vertices.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(geom@
        setVertices[
          PdVector`copyNew[origVertex]];\)\), "\[IndentingNewLine]", 
    \(geom@addVectorField[vf]\), "\[IndentingNewLine]", 
    \(\(geom@selectVectorField[vf];\)\), "\[IndentingNewLine]", 
    \(\(geom@update[geom];\)\)}], "Input",
  CellLabel->"In[83]:="],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[84]="]
}, Open  ]],

Cell[TextData[{
  "Following this exersize you can let the surface evolve in direction of the \
vector field using the effect EVOLVE which is available from the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " menu bar METHOD->EFFECT->EVOLVE. In the effect dialog select the vector \
field as evolution direction."
}], "Text"],

Cell[CellGroupData[{

Cell["Remove/Add a Single Element", "Subsubsection"],

Cell["\<\
Manually remove and add an individual element to a triangulation by using \
commands. Note, this sequence of commands is a feasibility demo and does not \
extend to larger number of elements. Larger number of elements are usually \
assigned either by allocating elements with setNumElements[int] and then \
using a sequence of setElement[int, int []] calls, or by high-level methods \
like makeQuadrConn[int,int] which generates the connectivity of a m*n grid.\
\>", "Text"],

Cell["\<\
Remove an arbitrary element. We recompute element adjacency to refresh \
boundary.\
\>", "MathCaption"],

Cell[BoxData[{
    \(\(geom@removeElement[18];\)\), "\[IndentingNewLine]", 
    \(\(geom@makeNeighbour[];\)\), "\[IndentingNewLine]", 
    \(\(geom@showBoundaries[True];\)\), "\[IndentingNewLine]", 
    \(\(geom@update[geom];\)\)}], "Input",
  CellLabel->"In[87]:="],

Cell["\<\
Restore the previously element by adding an element. We recompute element \
adjacency to refresh boundary.\
\>", "MathCaption"],

Cell[BoxData[{
    \(\(geom@
        addElement[
          JavaNew["\<jv.vecmath.PiVector\>", \ 22, 21, 27, 
            28]];\)\), "\[IndentingNewLine]", 
    \(\(geom@update[geom];\)\)}], "Input",
  CellLabel->"In[91]:="],

Cell[BoxData[""], "Input"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Adaptions of ",
  StyleBox["JavaView",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " for J/Link"
}], "Subsection"],

Cell[TextData[{
  "A few modifications of ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " were made for a better integration with J/Link and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". A set of listener classes allow ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to register for ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " events. These classes reside in the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " package jvx.math which are available with the archive jvx.jar. The sample \
applications of this notebook require no further adaption of ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " since the listener classes now belong to the basic API of ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell["Arrays of PdVectors and PiVectors", "Subsubsection"],

Cell[TextData[{
  "1. Arrays of PdVector resp. PiVector are frequently used in geometry \
classes in JavaView, for example, the set of vertices of a surfaces is an \
array of PdVectors. J/Link will convert such an array to a list of PdVector \
resp. PiVector, where access to individual number would require another \
method call. Therefore, I provided routines getEntries[] and setEntries[] of \
PdVector and PiVector to convert an array of PdVector resp. PiVector to a \
double array of doubles resp. integers. The implicit rule in J/Link converts \
such arrays to a list of lists in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " which are then processed as in the usual way."
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[{
  "Each of the fundamental linear algebra classes PiVector respectively \
PdVector contains an array of integer respectively double values which are \
mapped to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " lists by J/Link."
}], "MathCaption"],

Cell[BoxData[
    \(mathvi = {2, 3, 4}\)], "Input",
  CellLabel->"In[3]:="],

Cell[BoxData[
    \({2, 3, 4}\)], "Output",
  CellLabel->"Out[3]="],

Cell[CellGroupData[{

Cell[BoxData[
    \(vi = JavaNew["\<jv.vecmath.PiVector\>"]\)], "Input",
  CellLabel->"In[4]:="],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]JavaObject[
          "jv.vecmath.PiVector"] \[RightGuillemet]\),
      JLink`Objects`JavaObject5989466113]], "Output",
  CellLabel->"Out[4]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(vi@getSize[]\)], "Input",
  CellLabel->"In[5]:="],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[5]="]
}, Open  ]],

Cell[BoxData[
    \(\(vi@set[mathvi];\)\)], "Input",
  CellLabel->"In[6]:="],

Cell[BoxData[
    \(\(vi@setEntry[1, 17];\)\)], "Input",
  CellLabel->"In[7]:="],

Cell[CellGroupData[{

Cell[BoxData[
    \(vi@getEntries[]\)], "Input",
  CellLabel->"In[8]:="],

Cell[BoxData[
    \({2, 17, 4}\)], "Output",
  CellLabel->"Out[8]="]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
  "Many geometry items in ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " are available as arrays of PdVector and PiVector which are easily \
exchanged back and forth with a list of lists in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  "Convert the points of a geometry into a list in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(geom = 
        JavaNew["\<jv.geom.PgElementSet\>", 3];\)\), "\[IndentingNewLine]", 
    \(\(geom@computeTorus[5, 5, 2. , 1. ];\)\), "\[IndentingNewLine]", 
    \(vertex\  = \ geom@getVertices[]\)}], "Input",
  CellLabel->"In[9]:="],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        InterpretationBox[\(\[LeftGuillemet]JavaObject[
              "jv.vecmath.PdVector"] \[RightGuillemet]\),
          JLink`Objects`JavaObject3288334337], ",", 
        InterpretationBox[\(\[LeftGuillemet]JavaObject[
              "jv.vecmath.PdVector"] \[RightGuillemet]\),
          JLink`Objects`JavaObject3221225473], ",", 
        InterpretationBox[\(\[LeftGuillemet]JavaObject[
              "jv.vecmath.PdVector"] \[RightGuillemet]\),
          JLink`Objects`JavaObject3154116609], ",", 
        InterpretationBox[\(\[LeftGuillemet]JavaObject[
              "jv.vecmath.PdVector"] \[RightGuillemet]\),
          JLink`Objects`JavaObject3070230529], ",", 
        InterpretationBox[\(\[LeftGuillemet]JavaObject[
              "jv.vecmath.PdVector"] \[RightGuillemet]\),
          JLink`Objects`JavaObject3003121665], ",", 
        InterpretationBox[\(\[LeftGuillemet]JavaObject[
              "jv.vecmath.PdVector"] \[RightGuillemet]\),
          JLink`Objects`JavaObject2936012801], ",", 
        InterpretationBox[\(\[LeftGuillemet]JavaObject[
              "jv.vecmath.PdVector"] \[RightGuillemet]\),
          JLink`Objects`JavaObject2868903937], ",", 
        InterpretationBox[\(\[LeftGuillemet]JavaObject[
              "jv.vecmath.PdVector"] \[RightGuillemet]\),
          JLink`Objects`JavaObject2801795073], ",", 
        InterpretationBox[\(\[LeftGuillemet]JavaObject[
              "jv.vecmath.PdVector"] \[RightGuillemet]\),
          JLink`Objects`JavaObject2734686209], ",", 
        InterpretationBox[\(\[LeftGuillemet]JavaObject[
              "jv.vecmath.PdVector"] \[RightGuillemet]\),
          JLink`Objects`JavaObject20182990849], ",", 
        InterpretationBox[\(\[LeftGuillemet]JavaObject[
              "jv.vecmath.PdVector"] \[RightGuillemet]\),
          JLink`Objects`JavaObject20099104769], ",", 
        InterpretationBox[\(\[LeftGuillemet]JavaObject[
              "jv.vecmath.PdVector"] \[RightGuillemet]\),
          JLink`Objects`JavaObject20015218689], ",", 
        InterpretationBox[\(\[LeftGuillemet]JavaObject[
              "jv.vecmath.PdVector"] \[RightGuillemet]\),
          JLink`Objects`JavaObject19948109825], ",", 
        InterpretationBox[\(\[LeftGuillemet]JavaObject[
              "jv.vecmath.PdVector"] \[RightGuillemet]\),
          JLink`Objects`JavaObject19813892097], ",", 
        InterpretationBox[\(\[LeftGuillemet]JavaObject[
              "jv.vecmath.PdVector"] \[RightGuillemet]\),
          JLink`Objects`JavaObject19746783233], ",", 
        InterpretationBox[\(\[LeftGuillemet]JavaObject[
              "jv.vecmath.PdVector"] \[RightGuillemet]\),
          JLink`Objects`JavaObject19679674369], ",", 
        InterpretationBox[\(\[LeftGuillemet]JavaObject[
              "jv.vecmath.PdVector"] \[RightGuillemet]\),
          JLink`Objects`JavaObject19612565505], ",", 
        InterpretationBox[\(\[LeftGuillemet]JavaObject[
              "jv.vecmath.PdVector"] \[RightGuillemet]\),
          JLink`Objects`JavaObject19545456641], ",", 
        InterpretationBox[\(\[LeftGuillemet]JavaObject[
              "jv.vecmath.PdVector"] \[RightGuillemet]\),
          JLink`Objects`JavaObject19478347777], ",", 
        InterpretationBox[\(\[LeftGuillemet]JavaObject[
              "jv.vecmath.PdVector"] \[RightGuillemet]\),
          JLink`Objects`JavaObject19411238913], ",", 
        InterpretationBox[\(\[LeftGuillemet]JavaObject[
              "jv.vecmath.PdVector"] \[RightGuillemet]\),
          JLink`Objects`JavaObject19344130049], ",", 
        InterpretationBox[\(\[LeftGuillemet]JavaObject[
              "jv.vecmath.PdVector"] \[RightGuillemet]\),
          JLink`Objects`JavaObject19277021185], ",", 
        InterpretationBox[\(\[LeftGuillemet]JavaObject[
              "jv.vecmath.PdVector"] \[RightGuillemet]\),
          JLink`Objects`JavaObject19209912321], ",", 
        InterpretationBox[\(\[LeftGuillemet]JavaObject[
              "jv.vecmath.PdVector"] \[RightGuillemet]\),
          JLink`Objects`JavaObject19142803457], ",", 
        InterpretationBox[\(\[LeftGuillemet]JavaObject[
              "jv.vecmath.PdVector"] \[RightGuillemet]\),
          JLink`Objects`JavaObject19075694593]}], "}"}]], "Output",
  CellLabel->"Out[11]="],

Cell["\<\
The array of points is converted to a list of lists of double values.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(mathList = PdVector`getEntries[vertex]\)], "Input",
  CellLabel->"In[12]:="],

Cell[BoxData[
    \({{1.`, 0.`, 1.2246063538223773`*^-16}, {1.9999999999999998`, 
        0.`, \(-1.`\)}, {3.`, 
        0.`, \(-2.4492127076447545`*^-16\)}, {2.0000000000000004`, 0.`, 
        1.`}, {1.`, 0.`, 3.673819061467132`*^-16}, {6.123031769111886`*^-17, 
        1.`, 1.2246063538223773`*^-16}, {1.224606353822377`*^-16, 
        1.9999999999999998`, \(-1.`\)}, {1.836909530733566`*^-16, 
        3.`, \(-2.4492127076447545`*^-16\)}, {1.2246063538223775`*^-16, 
        2.0000000000000004`, 1.`}, {6.123031769111886`*^-17, 1.`, 
        3.673819061467132`*^-16}, {\(-1.`\), 1.2246063538223773`*^-16, 
        1.2246063538223773`*^-16}, {\(-1.9999999999999998`\), 
        2.449212707644754`*^-16, \(-1.`\)}, {\(-3.`\), 
        3.673819061467132`*^-16, \(-2.4492127076447545`*^-16\)}, \
{\(-2.0000000000000004`\), 2.449212707644755`*^-16, 1.`}, {\(-1.`\), 
        1.2246063538223773`*^-16, 
        3.673819061467132`*^-16}, {\(-1.836909530733566`*^-16\), \(-1.`\), 
        1.2246063538223773`*^-16}, {\(-3.6738190614671313`*^-16\), \
\(-1.9999999999999998`\), \(-1.`\)}, {\(-5.510728592200698`*^-16\), \(-3.`\), \
\(-2.4492127076447545`*^-16\)}, {\(-3.673819061467133`*^-16\), \
\(-2.0000000000000004`\), 1.`}, {\(-1.836909530733566`*^-16\), \(-1.`\), 
        3.673819061467132`*^-16}, {1.`, \(-2.4492127076447545`*^-16\), 
        1.2246063538223773`*^-16}, {1.9999999999999998`, \
\(-4.898425415289508`*^-16\), \(-1.`\)}, {3.`, \(-7.347638122934264`*^-16\), \
\(-2.4492127076447545`*^-16\)}, {2.0000000000000004`, \
\(-4.89842541528951`*^-16\), 1.`}, {1.`, \(-2.4492127076447545`*^-16\), 
        3.673819061467132`*^-16}}\)], "Output",
  CellLabel->"Out[12]="]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
  "Assign a list of points produced in ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "to a geometry in ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  "."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(numULines\  = \ 5;\)\), "\[IndentingNewLine]", 
    \(\(numVLines\  = \ 6;\)\), "\[IndentingNewLine]", 
    \(point = 
      Flatten[Table[{x, y, Sin[x*y]}, \[IndentingNewLine]{x, 1, 
              numULines}, {y, 1, numVLines}], 1]\  // \ N\)}], "Input",
  CellLabel->"In[13]:="],

Cell[BoxData[
    \({{1.`, 1.`, 0.8414709848078965`}, {1.`, 2.`, 
        0.9092974268256817`}, {1.`, 3.`, 0.1411200080598672`}, {1.`, 
        4.`, \(-0.7568024953079282`\)}, {1.`, 
        5.`, \(-0.9589242746631385`\)}, {1.`, 
        6.`, \(-0.27941549819892586`\)}, {2.`, 1.`, 
        0.9092974268256817`}, {2.`, 2.`, \(-0.7568024953079282`\)}, {2.`, 
        3.`, \(-0.27941549819892586`\)}, {2.`, 4.`, 
        0.9893582466233818`}, {2.`, 5.`, \(-0.5440211108893698`\)}, {2.`, 
        6.`, \(-0.5365729180004349`\)}, {3.`, 1.`, 
        0.1411200080598672`}, {3.`, 2.`, \(-0.27941549819892586`\)}, {3.`, 
        3.`, 0.4121184852417566`}, {3.`, 
        4.`, \(-0.5365729180004349`\)}, {3.`, 5.`, 
        0.6502878401571168`}, {3.`, 6.`, \(-0.750987246771676`\)}, {4.`, 
        1.`, \(-0.7568024953079282`\)}, {4.`, 2.`, 
        0.9893582466233818`}, {4.`, 3.`, \(-0.5365729180004349`\)}, {4.`, 
        4.`, \(-0.2879033166650653`\)}, {4.`, 5.`, 
        0.9129452507276277`}, {4.`, 6.`, \(-0.9055783620066239`\)}, {5.`, 
        1.`, \(-0.9589242746631385`\)}, {5.`, 
        2.`, \(-0.5440211108893698`\)}, {5.`, 3.`, 
        0.6502878401571168`}, {5.`, 4.`, 0.9129452507276277`}, {5.`, 
        5.`, \(-0.13235175009777303`\)}, {5.`, 
        6.`, \(-0.9880316240928618`\)}}\)], "Output",
  CellLabel->"Out[15]="]
}, Open  ]],

Cell[TextData[{
  "Create a ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " geometry and display it in the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " display."
}], "Text"],

Cell[TextData[{
  "Create an empty ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " point set and assign the vertices of the previous example."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{\(geom = 
        JavaNew["\<jv.geom.PgPointSet\>", 
          3];\), "\[IndentingNewLine]", \(geom@
        setName["\<Graph of Sin[x*y]\>"];\), "\[IndentingNewLine]", \(geom@
        setNumVertices[numULines*numVLines];\), "\[IndentingNewLine]", \(geom@
        setVertices[PdVector`copyNew[point]];\), "\[IndentingNewLine]", 
    RowBox[{
      StyleBox["JavaView",
        FontSlant->"Plain"], "[", "geom", "]"}]}], "Input",
  CellLabel->"In[16]:="],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]JavaObject[
          "jv.geom.PgPointSet"] \[RightGuillemet]\),
      JLink`Objects`JavaObject18673041409]], "Output",
  CellLabel->"Out[20]="]
}, Open  ]],

Cell["Get the currently selected display from the viewer.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(disp = viewer@getDisplay[];\)\), "\[IndentingNewLine]", 
    \(disp@getName[]\)}], "Input",
  CellLabel->"In[21]:="],

Cell[BoxData[
    \("Display: From Mathematica"\)], "Output",
  CellLabel->"Out[22]="]
}, Open  ]],

Cell["\<\
Show the name of the display in the upper part of the canvas.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(disp@showTitle[True];\)\), "\[IndentingNewLine]", 
    \(disp@update[disp]\)}], "Input",
  CellLabel->"In[23]:="],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[24]="]
}, Open  ]],

Cell["Get all displays registered in the viewer.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(viewer@getDisplays[]\)], "Input",
  CellLabel->"In[26]:="],

Cell[BoxData[
    RowBox[{"{", 
      InterpretationBox[\(\[LeftGuillemet]JavaObject[
            "jv.viewer.PvDisplay"] \[RightGuillemet]\),
        JLink`Objects`JavaObject17347641345], "}"}]], "Output",
  CellLabel->"Out[26]="]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Package jvx.math", "Subsubsection"],

Cell[TextData[{
  "The package jvx.math provides listener classes for basic JavaView events \
to be received by a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " notebook in the same ways as listener classes provided by J/Link for \
other Java events. See the section on \"Advanced Examples\" for applications \
of the listener classes."
}], "Text"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Advanced Examples", "Section",
  CellGroupingRules->"SectionGrouping"],

Cell[CellGroupData[{

Cell["Using Mouse Events for Real-Time Algebra", "Subsection",
  CellGroupingRules->"SectionGrouping"],

Cell[TextData[{
  "Mouse position in a ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " display is received by the notebook and interpreted as two input \
parameters for a calculation.\nSee notebook: ",
  ButtonBox["MouseListener.nb",
    ButtonData:>{"MouseListener.nb", None},
    ButtonStyle->"Hyperlink"]
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Using Camera Events from Display", "Subsection",
  CellGroupingRules->"SectionGrouping"],

Cell[TextData[{
  "Catch the position of the camera in a ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " display and use the information to adjust the color of a torus.\nSee \
notebook: ",
  ButtonBox["CameraListener.nb",
    ButtonData:>{"CameraListener.nb", None},
    ButtonStyle->"Hyperlink"]
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Using a ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " Slider to Steer a Calculation"
}], "Subsection",
  CellGroupingRules->"SectionGrouping"],

Cell[TextData[{
  "Use a JavaView slider to interactively adjust the frequency of a \
sine-curve and the radius of a torus.\nSee notebook: ",
  ButtonBox["SliderListener.nb",
    ButtonData:>{"SliderListener.nb", None},
    ButtonStyle->"Hyperlink"]
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Using Timer Events for Animations", "Subsection",
  CellGroupingRules->"SectionGrouping"],

Cell[TextData[{
  "Create an animation where a satellite flies around a torus. All \
calculations are performed by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and initiated by events from the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " animation dialog.\nSee notebook: ",
  Cell[BoxData[
      FormBox[
        ButtonBox[\(Satellite . nb\),
          ButtonData:>{"Satellite.nb", None},
          ButtonStyle->"Hyperlink"], TraditionalForm]]]
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Pick Events and ",
  StyleBox["Mathematica'",
    FontSlant->"Italic"],
  "s Delaunay Algorithm"
}], "Subsection",
  CellGroupingRules->"SectionGrouping"],

Cell[TextData[{
  "This notebook demonstrates a use of real-time heavy computations by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " while interacting with the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " display. We show a planar triangulation and drag vertices around while ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " simultaneously calculates the Delaunay triangulation.\nSee notebook: ",
  ButtonBox["Delaunay.nb",
    ButtonData:>{"Delaunay.nb", None},
    ButtonStyle->"Hyperlink"]
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["3D Pick Events", "Subsection",
  CellGroupingRules->"SectionGrouping"],

Cell[TextData[{
  "Basic examples to register a notebook such that it receives 3D pick events \
from picking on a 3D surface.\nSee notebook: ",
  Cell[BoxData[
      FormBox[
        ButtonBox[\(Pick3DListener . nb\),
          ButtonData:>{"Pick3DListener.nb", None},
          ButtonStyle->"Hyperlink"], TraditionalForm]]]
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Animations with ",
  StyleBox["JavaView",
    FontSlant->"Italic"]
}], "Subsection",
  CellGroupingRules->"SectionGrouping"],

Cell[TextData[{
  "Basic examples to save animations to web pages or load them into ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  ".\nSee notebook: ",
  ButtonBox["Animation.nb",
    ButtonData:>{"Animation.nb", None},
    ButtonStyle->"Hyperlink"]
}], "Text"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1400}, {0, 998}},
ScreenStyleEnvironment->"Brackets",
CellGrouping->Manual,
WindowSize->{895, 900},
WindowMargins->{{Automatic, 9}, {Automatic, 21}},
PageHeaders->{{Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Inherited, Cell[ 
        TextData[ {"Konrad Polthier"}], "PageHeader"]}, {Cell[ 
        TextData[ {"The ", 
          StyleBox[ "JavaView", FontSlant -> "Italic"], " Packages"}], 
        "PageHeader"], Inherited, Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"]}},
PageFooters->{{Inherited, Cell[ 
        TextData[ {
          "\[Copyright]1999 Wolfram Research, Inc. All rights reserved."}], 
        "PageFooter"], Inherited}, {Inherited, Cell[ 
        TextData[ {
          "\[Copyright]1999 Wolfram Research, Inc. All rights reserved."}], 
        "PageFooter"], Inherited}},
PageFooterLines->{True, True},
PrintingOptions->{"PrintingMargins"->{{56.6875, 56.6875}, {56.6875, \
56.6875}},
"PrintCellBrackets"->True,
"PrintRegistrationMarks"->False,
"PrintMultipleHorizontalPages"->False,
"FacingPages"->True},
Magnification->1.25,
StyleDefinitions -> "HelpBrowser.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 454, 14, 124, "Chapter",
  CellGroupingRules->"SectionGrouping"],

Cell[CellGroupData[{
Cell[2196, 67, 77, 1, 77, "Section",
  CellGroupingRules->"SectionGrouping"],

Cell[CellGroupData[{
Cell[2298, 72, 64, 0, 42, "Subsubsection"],
Cell[2365, 74, 347, 10, 48, "Text"],
Cell[2715, 86, 244, 9, 39, "MathCaption"],

Cell[CellGroupData[{
Cell[2984, 99, 146, 3, 54, "Input"],
Cell[3133, 104, 149, 3, 27, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3319, 112, 129, 3, 30, "SubsubsectionIcon"],
Cell[3451, 117, 74, 0, 36, "MathCaption"],
Cell[3528, 119, 132, 3, 54, "Input"],
Cell[3663, 124, 320, 9, 55, "MathCaption"],
Cell[3986, 135, 330, 7, 96, "Input"],
Cell[4319, 144, 210, 6, 36, "MathCaption"],
Cell[4532, 152, 79, 2, 33, "Input"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[4660, 160, 115, 1, 56, "Subsection",
  CellGroupingRules->"SectionGrouping"],
Cell[4778, 163, 262, 6, 48, "Text"],

Cell[CellGroupData[{
Cell[5065, 173, 118, 5, 42, "Subsubsection"],
Cell[5186, 180, 360, 9, 48, "Text"],
Cell[5549, 191, 123, 5, 36, "MathCaption"],
Cell[5675, 198, 139, 3, 54, "Input"],
Cell[5817, 203, 555, 18, 67, "Text"],
Cell[6375, 223, 164, 5, 36, "MathCaption"],

Cell[CellGroupData[{
Cell[6564, 232, 84, 2, 33, "Input"],
Cell[6651, 236, 231, 5, 27, "Output"]
}, Open  ]],
Cell[6897, 244, 226, 4, 55, "MathCaption"],

Cell[CellGroupData[{
Cell[7148, 252, 311, 6, 117, "Input"],
Cell[7462, 260, 63, 2, 27, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[7574, 268, 52, 0, 42, "Subsubsection"],
Cell[7629, 270, 99, 2, 29, "Text"],
Cell[7731, 274, 65, 0, 36, "MathCaption"],
Cell[7799, 276, 131, 3, 33, "Input"],
Cell[7933, 281, 54, 0, 36, "MathCaption"],
Cell[7990, 283, 166, 3, 54, "Input"],
Cell[8159, 288, 263, 6, 48, "Text"],
Cell[8425, 296, 177, 3, 55, "MathCaption"],
Cell[8605, 301, 143, 3, 54, "Input"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[8797, 310, 85, 1, 52, "Subsection",
  CellGroupingRules->"SectionGrouping"],
Cell[8885, 313, 595, 13, 137, "Text"],
Cell[9483, 328, 68, 0, 36, "MathCaption"],
Cell[9554, 330, 131, 3, 33, "Input"],
Cell[9688, 335, 115, 3, 36, "MathCaption"],
Cell[9806, 340, 291, 5, 96, "Input"],
Cell[10100, 347, 192, 6, 36, "MathCaption"],

Cell[CellGroupData[{
Cell[10317, 357, 72, 2, 33, "Input"],
Cell[10392, 361, 199, 4, 27, "Output"]
}, Open  ]],
Cell[10606, 368, 206, 5, 36, "MathCaption"],

Cell[CellGroupData[{
Cell[10837, 377, 213, 5, 54, "Input"],
Cell[11053, 384, 134, 3, 27, "Output"]
}, Open  ]],
Cell[11202, 390, 420, 9, 80, "Commentary",
  CellGroupingRules->"SectionGrouping"],
Cell[11625, 401, 212, 5, 55, "MathCaption"],

Cell[CellGroupData[{
Cell[11862, 410, 205, 5, 54, "Input"],
Cell[12070, 417, 134, 3, 27, "Output"]
}, Open  ]],
Cell[12219, 423, 184, 6, 36, "MathCaption"],

Cell[CellGroupData[{
Cell[12428, 433, 152, 3, 54, "Input"],
Cell[12583, 438, 137, 3, 27, "Output"]
}, Open  ]],
Cell[12735, 444, 109, 3, 36, "MathCaption"],
Cell[12847, 449, 97, 2, 33, "Input"],
Cell[12947, 453, 77, 0, 36, "MathCaption"],
Cell[13027, 455, 271, 6, 75, "Input"],
Cell[13301, 463, 159, 3, 36, "MathCaption"],

Cell[CellGroupData[{
Cell[13485, 470, 309, 7, 96, "Input"],
Cell[13797, 479, 60, 2, 27, "Output"]
}, Open  ]],
Cell[13872, 484, 333, 7, 48, "Text"],

Cell[CellGroupData[{
Cell[14230, 495, 52, 0, 42, "Subsubsection"],
Cell[14285, 497, 484, 7, 86, "Text"],
Cell[14772, 506, 113, 3, 36, "MathCaption"],
Cell[14888, 511, 266, 5, 96, "Input"],
Cell[15157, 518, 137, 3, 36, "MathCaption"],
Cell[15297, 523, 223, 6, 54, "Input"],
Cell[15523, 531, 26, 0, 33, "Input"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[15598, 537, 165, 6, 52, "Subsection"],
Cell[15766, 545, 784, 24, 86, "Text"],

Cell[CellGroupData[{
Cell[16575, 573, 58, 0, 42, "Subsubsection"],
Cell[16636, 575, 703, 12, 105, "Text"],

Cell[CellGroupData[{
Cell[17364, 591, 272, 7, 55, "MathCaption"],
Cell[17639, 600, 75, 2, 33, "Input"],
Cell[17717, 604, 67, 2, 27, "Output"],

Cell[CellGroupData[{
Cell[17809, 610, 96, 2, 33, "Input"],
Cell[17908, 614, 197, 4, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18142, 623, 69, 2, 33, "Input"],
Cell[18214, 627, 59, 2, 27, "Output"]
}, Open  ]],
Cell[18288, 632, 76, 2, 33, "Input"],
Cell[18367, 636, 80, 2, 33, "Input"],

Cell[CellGroupData[{
Cell[18472, 642, 72, 2, 33, "Input"],
Cell[18547, 646, 68, 2, 27, "Output"]
}, Open  ]]
}, Open  ]],
Cell[18642, 652, 287, 9, 48, "Text"],
Cell[18932, 663, 146, 5, 36, "MathCaption"],

Cell[CellGroupData[{
Cell[19103, 672, 255, 5, 75, "Input"],
Cell[19361, 679, 4276, 78, 279, "Output"],
Cell[23640, 759, 100, 2, 36, "MathCaption"],

Cell[CellGroupData[{
Cell[23765, 765, 96, 2, 33, "Input"],
Cell[23864, 769, 1676, 26, 237, "Output"]
}, Open  ]]
}, Open  ]],
Cell[25567, 799, 207, 8, 36, "MathCaption"],

Cell[CellGroupData[{
Cell[25799, 811, 303, 6, 96, "Input"],
Cell[26105, 819, 1331, 23, 174, "Output"]
}, Open  ]],
Cell[27451, 845, 192, 8, 29, "Text"],
Cell[27646, 855, 169, 5, 36, "MathCaption"],

Cell[CellGroupData[{
Cell[27840, 864, 467, 9, 117, "Input"],
Cell[28310, 875, 198, 4, 27, "Output"]
}, Open  ]],
Cell[28523, 882, 74, 0, 36, "MathCaption"],

Cell[CellGroupData[{
Cell[28622, 886, 139, 3, 54, "Input"],
Cell[28764, 891, 86, 2, 27, "Output"]
}, Open  ]],
Cell[28865, 896, 92, 2, 36, "MathCaption"],

Cell[CellGroupData[{
Cell[28982, 902, 136, 3, 54, "Input"],
Cell[29121, 907, 63, 2, 27, "Output"]
}, Open  ]],
Cell[29199, 912, 65, 0, 36, "MathCaption"],

Cell[CellGroupData[{
Cell[29289, 916, 78, 2, 33, "Input"],
Cell[29370, 920, 230, 5, 27, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[29649, 931, 41, 0, 38, "Subsubsection"],
Cell[29693, 933, 360, 8, 48, "Text"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[30114, 948, 76, 1, 59, "Section",
  CellGroupingRules->"SectionGrouping"],

Cell[CellGroupData[{
Cell[30215, 953, 102, 1, 56, "Subsection",
  CellGroupingRules->"SectionGrouping"],
Cell[30320, 956, 327, 9, 56, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[30684, 970, 94, 1, 56, "Subsection",
  CellGroupingRules->"SectionGrouping"],
Cell[30781, 973, 316, 9, 56, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[31134, 987, 171, 6, 56, "Subsection",
  CellGroupingRules->"SectionGrouping"],
Cell[31308, 995, 261, 6, 56, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[31606, 1006, 95, 1, 56, "Subsection",
  CellGroupingRules->"SectionGrouping"],
Cell[31704, 1009, 481, 14, 75, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[32222, 1028, 173, 6, 56, "Subsection",
  CellGroupingRules->"SectionGrouping"],
Cell[32398, 1036, 538, 14, 75, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[32973, 1055, 76, 1, 56, "Subsection",
  CellGroupingRules->"SectionGrouping"],
Cell[33052, 1058, 336, 8, 56, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[33425, 1071, 196, 7, 56, "Subsection",
  CellGroupingRules->"SectionGrouping"],
Cell[33624, 1080, 268, 8, 56, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

