(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     30547,        991]*)
(*NotebookOutlinePosition[     31298,       1017]*)
(*  CellTagsIndexPosition[     31254,       1013]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Animations and ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  "\n",
  StyleBox["\tby Konrad Polthier\n\t",
    FontSize->16],
  StyleBox["(Part of User's Guide, Draft 0.04, 29.11.03)",
    FontSize->16,
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}]
}], "Chapter"],

Cell[TextData[{
  "Load the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " package"
}], "Subsubsection"],

Cell[TextData[{
  "The first step in using ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " inside ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is the loading of the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " package. This allows to use the commands RunJavaView[g] and JavaView[g] \
to visualize a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics in a ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " display."
}], "Text"],

Cell[TextData[{
  "Load the JavaView`JLink` package including the J/Link package of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "MathCaption"],

Cell[BoxData[{
    \(<< JavaView`JLink`\), "\n", 
    \(\(viewer\  = \ InstallJavaView[];\)\)}], "Input",
  CellLabel->"In[1]:="],

Cell["Create an animation as sample for this notebook", "Subsubsection"],

Cell["\<\
An animation consists of a sequence of surfaces which usually arise by \
sampling a continuous deformation of a surface at several values of the \
changing parameter. Each sample is called a keyframe geometry. JavaView is \
able to take the list of keyframe geometries and show a smooth animation by \
interpolating between the keyframe geometries.\
\>", "Text"],

Cell["\<\
Create a list of deforming surfaces used overall in this notebook\
\>", "MathCaption"],

Cell[BoxData[{
    \(\(numFrames\  = \ 3;\)\), "\[IndentingNewLine]", 
    \(anim = 
      Table[\ ParametricPlot3D[\[IndentingNewLine]{Cos[t]\ Cos[x]\ Cosh[y] + 
              Sin[t]\ Sin[x]\ Sinh[y], \[IndentingNewLine]\(-Cos[t]\)\ Sin[
                  x]\ Cosh[y] + 
              Sin[t]\ Cos[x]\ Sinh[y], \[IndentingNewLine]Cos[t]\ y + 
              Sin[t]\ x}, {x, \(-Pi\), Pi}, {y, \(-Pi\)/2, 
            Pi/2}, \[IndentingNewLine]AspectRatio -> Automatic, 
          Boxed -> False, Axes -> False, 
          PlotPoints\  -> \ {13, 
              7}, \[IndentingNewLine]PlotRange -> {{\(-3\), 3}, {\(-3\), 
                3}, {\(-4\), 4}}], {t, 0. , 
          Pi/2. , \(Pi/2. \)/\((numFrames - 1)\)}]\)}], "Input",
  CellLabel->"In[84]:=",
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity],

Cell[TextData[{
  "Show an Animation in ",
  StyleBox["JavaView",
    FontSlant->"Italic"]
}], "Subsection"],

Cell[TextData[{
  "An animation in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is obtained from a list of graphics objects which is interpreted as a \
deforming geometry."
}], "Text",
  CellDingbat->None],

Cell[BoxData[{
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["JavaView",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                RowBox[{
                  StyleBox["{",
                    "MR"], 
                  RowBox[{
                    StyleBox[\(g\_1\),
                      "InlineFormula",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      FontSlant->"Italic"], 
                    StyleBox[\(g\_2\),
                      "InlineFormula",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      FontSlant->"Italic"], 
                    StyleBox[" ",
                      FontSlant->"Italic"], 
                    StyleBox["...",
                      FontSlant->"Italic"]}], 
                  StyleBox[" ",
                    FontSlant->"Italic"], 
                  StyleBox["}",
                    "MR"]}], 
                StyleBox[",",
                  "MR"], 
                StyleBox[\(Animatable -> True\),
                  FontSlant->"Italic"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["show",
                "Text"], 
              StyleBox[" ",
                "Text"], 
              StyleBox["a",
                "Text"], 
              StyleBox[" ",
                "Text"], 
              StyleBox["list",
                "Text"], 
              StyleBox[" ",
                "Text"], 
              StyleBox["of",
                "Text"], 
              StyleBox[" ",
                "Text"], 
              StyleBox["Mathematica",
                "Text"], 
              StyleBox[" ",
                "Text"], 
              StyleBox["graphics",
                "Text"], 
              StyleBox[" ",
                "Text"], 
              StyleBox["as",
                "Text"], 
              StyleBox[" ",
                "Text"], 
              StyleBox["animation",
                "Text"], 
              StyleBox[" ",
                "Text"], 
              StyleBox["in",
                "Text"], 
              StyleBox[" ",
                "Text"], 
              RowBox[{
                StyleBox["JavaView",
                  "Text"], 
                StyleBox[".",
                  "Text"], "\n"}]}]}
          }], NotebookDefault], "\n", 
    FormBox[
      RowBox[{GridBox[{
            {
              RowBox[{
                StyleBox["RunJavaView",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                RowBox[{
                  RowBox[{
                    StyleBox["{",
                      "MR"], 
                    RowBox[{
                      StyleBox[\(g\_1\),
                        "InlineFormula",
                        FontSlant->"Italic"], 
                      StyleBox[",",
                        FontSlant->"Italic"], 
                      StyleBox[\(g\_2\),
                        "InlineFormula",
                        FontSlant->"Italic"], 
                      StyleBox[",",
                        FontSlant->"Italic"], 
                      StyleBox[" ",
                        FontSlant->"Italic"], 
                      StyleBox["...",
                        FontSlant->"Italic"]}], 
                    StyleBox[" ",
                      FontSlant->"Italic"], 
                    StyleBox["}",
                      "MR"]}], 
                  StyleBox[",",
                    "MR"], "\n", 
                  StyleBox[\(Animatable -> True\),
                    FontSlant->"Italic"]}], 
                StyleBox["]",
                  "MR"]}], 
              RowBox[{
                StyleBox["show",
                  "Text"], 
                StyleBox[" ",
                  "Text"], 
                StyleBox["a",
                  "Text"], 
                StyleBox[" ",
                  "Text"], 
                StyleBox["list",
                  "Text"], 
                StyleBox[" ",
                  "Text"], 
                StyleBox["of",
                  "Text"], 
                StyleBox[" ",
                  "Text"], 
                StyleBox["Mathematica",
                  "Text"], 
                StyleBox[" ",
                  "Text"], 
                StyleBox["graphics",
                  "Text"], 
                StyleBox[" ",
                  "Text"], 
                StyleBox["as",
                  "Text"], 
                StyleBox[" ",
                  "Text"], 
                StyleBox["animation",
                  "Text"], 
                StyleBox[" ",
                  "Text"], 
                StyleBox["in",
                  "Text"], 
                StyleBox[" ",
                  "Text"], 
                RowBox[{
                  StyleBox["JavaView",
                    "Text"], 
                  StyleBox[".",
                    "Text"], "\n", "\n"}]}]}
            }], GridBox[{
            {
              RowBox[{
                StyleBox["RunJavaView",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                RowBox[{
                  StyleBox[
                    RowBox[{
                      StyleBox["S",
                        "MR"], "howAnimation"}]], "[", 
                  RowBox[{
                    StyleBox["{",
                      "MR"], 
                    RowBox[{
                      StyleBox[\(g\_1\),
                        "InlineFormula",
                        FontSlant->"Italic"], 
                      StyleBox[",",
                        FontSlant->"Italic"], 
                      StyleBox[\(g\_2\),
                        "InlineFormula",
                        FontSlant->"Italic"], 
                      StyleBox[",",
                        FontSlant->"Italic"], 
                      StyleBox[" ",
                        FontSlant->"Italic"], 
                      StyleBox["...",
                        FontSlant->"Italic"]}], 
                    StyleBox[" ",
                      FontSlant->"Italic"], 
                    StyleBox["}",
                      "MR"]}], 
                  StyleBox["]",
                    "MR"]}], 
                StyleBox["]",
                  "MR"]}], 
              RowBox[{\(CURRENTLY\ NOT\ WORKING\ IN\ JAVAVIEW\), "\n", 
                
                StyleBox[\(create\ an\ Html\ page\ which\ shows\ a\ list\ of\ \
Mathematica\ graphics\ as\ animation\ in\ a\ JavaView\ \(\(applet\)\(.\)\)\),
                  "Text"]}]}
            }]}], NotebookDefault]}], "DefinitionBox",
  GridBoxOptions->{ColumnAlignments->{Right, Left}}],

Cell["\<\
Basically there are two different ways to pass an animation to JavaView, and \
both methods are equally good if JavaView is directly used to show the \
animation.\
\>", "Text",
  CellDingbat->None],

Cell["\<\
1. Export a list of geometries to JavaView and instruct JavaView to animate \
the list using a command line or applet parameter.\
\>", "Text",
  CellDingbat->None],

Cell["\<\
Show a list of surfaces as smooth animation. Returned is an array of \
interpolation geometries, not of keyframe geometries.\
\>", "MathCaption"],

Cell[BoxData[
    RowBox[{"geomArr", "=", 
      RowBox[{
        StyleBox["JavaView",
          FontSlant->"Plain"], "[", \(anim, Animatable \[Rule] True\), 
        "]"}]}]], "Input",
  CellLabel->"In[5]:="],

Cell[TextData[{
  "If JavaView is called with the option \"Animatable->False\" (the default \
value), then all geometries will be displayed at once in ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " similar to the above Show[a] command. Returned is an array of all \
geometries."
}], "MathCaption"],

Cell[BoxData[
    \(JavaView[anim, Animatable \[Rule] False]\)], "Input",
  CellLabel->"In[7]:="],

Cell[TextData[{
  "2. Define an animation in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", and export this animation to JavaView."
}], "Text",
  CellDingbat->None],

Cell["\<\
Identify a list of surfaces as animation, and show the animation in JavaView.
CURRENTLY, ShowAnimation[] DOES NOT WORK WITH JAVAVIEW\
\>", "MathCaption"],

Cell[BoxData[{
    \(<< Graphics`Animation`\), "\[IndentingNewLine]", 
    \(JavaView[ShowAnimation[anim]]\)}], "Input",
  CellLabel->"In[10]:="],

Cell[TextData[{
  "Animations with ",
  StyleBox["RunJavaView",
    FontFamily->"Courier New"]
}], "Subsubsection"],

Cell["Use RunJavaView[] to show the animation.", "MathCaption"],

Cell[BoxData[
    \(RunJavaView[anim, \ Animatable \[Rule] True]\)], "Input",
  CellLabel->"In[12]:="],

Cell["\<\
Deprecated: Using the directive Animation[] to identify a list of surfaces as \
animation.\
\>", "MathCaption"],

Cell[BoxData[
    \(RunJavaView[Apply[Animation, anim]]\)], "Input",
  CellLabel->"In[19]:="],

Cell["CURRENTLY, ShowAnimation[] DOES NOT WORK WITH JAVAVIEW", "MathCaption"],

Cell[BoxData[
    \(RunJavaView[ShowAnimation[anim]]\)], "Input",
  CellLabel->"In[13]:="],

Cell["Invoke JavaView by Hand", "Subsubsection"],

Cell["\<\
Just for completeness we note three ways to directly invoke JavaView \"by \
hand\". These methods avoid using the functionality of the package \
JavaView`RunThrough`.\
\>", "Text",
  CellDingbat->None],

Cell["\<\
Instead of RunJavaView[a, Animatable\[Rule]True]:\
\>", "MathCaption"],

Cell[BoxData[
    \(RunThrough["\<javaview file=stdin format=mgs animate=show\>", 
      InputForm[anim]]\)], "Input",
  CellLabel->"In[15]:="],

Cell["\<\
The elements \"Animation\" and \"KeyAnimation\" are deprecated and should no \
longer be used:\
\>", "MathCaption"],

Cell[BoxData[
    \(RunThrough["\<javaview file=stdin format=mgs\>", 
      InputForm[Apply[Animation, anim]]]\)], "Input",
  CellLabel->"In[17]:="],

Cell[BoxData[
    \(RunThrough["\<javaview file=stdin format=mgs\>", 
      InputForm[Apply[KeyAnimation, anim]]]\)], "Input",
  CellLabel->"In[18]:="],

Cell[TextData[{
  "Note, the command FormatGraphics cannot be used instead of applying \
InputForm[] since the return value of FormatGraphics[] is a string. As a \
consequence the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " parser in JavaView currently quits when receiving a string instead of a \
graphics command."
}], "Text",
  CellDingbat->None],

Cell[BoxData[{
    \(\(bFormat\  = \ 
        FormatGraphics[Apply[Animation, anim]];\)\), "\[IndentingNewLine]", 
    \(RunThrough["\<javaview file=stdin format=mgs\>", bFormat]\)}], "Input",
  CellLabel->"In[20]:="],

Cell["\<\
Instead of RunJavaView[ShowAnimation[a]]:
CURRENTLY, ShowAnimation[] DOES NOT WORK WITH JAVAVIEW\
\>", "MathCaption"],

Cell[BoxData[
    \(RunThrough["\<javaview file=stdin format=mgs\>", 
      InputForm[ShowAnimation[anim]]]\)], "Input",
  CellLabel->"In[16]:="],

Cell["Animated Wave Example", "Subsection"],

Cell[TextData[{
  "This generates a list of graphics objects. Setting ",
  StyleBox["DisplayFunction", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["Identity", "MR"],
  " stops ",
  StyleBox["Plot3D", "MR"],
  " from rendering the graphics it produces. Explicitly setting ",
  StyleBox["PlotRange", "MR"],
  " ensures that the scale is the same in each piece of graphics. "
}], "MathCaption"],

Cell[BoxData[
    \(table = 
      Table[Plot3D[
          Cos[Sqrt[x^2 + y^2] - t], {x, \(-10\), 10}, {y, \(-10\), 10}, 
          Axes \[Rule] False, PlotRange \[Rule] {0. , 1.0}, 
          PlotPoints \[Rule] 25, DisplayFunction \[Rule] Identity], {t, 0, 
          2  Pi}]\)], "Input",
  CellLabel->"In[63]:="],

Cell[TextData[{
  "On an appropriate computer system, ",
  StyleBox["ShowAnimation[table]", "MR"],
  " would animate the graphics in this notebook."
}], "MathCaption"],

Cell[BoxData[
    \(ShowAnimation[table]\)], "Input",
  CellLabel->"In[57]:="],

Cell["\<\
Animation in JavaView. Use <ctrl-a> to bring the animation dialog of JavaView \
to the front.\
\>", "MathCaption"],

Cell[BoxData[
    \(JavaView[table, Animatable \[Rule] True]\)], "Input",
  CellLabel->"In[60]:="],

Cell["Save an Animation to a Geometry File", "Subsection"],

Cell[TextData[{
  "Similar to the viewing of animations in JavaView there are two different \
ways to save an animation to a geometry file: either by enclosing a list of \
geometries with the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " directive ShowAnimation[], or by saving the animation as list of \
geometries, or ."
}], "Text",
  CellDingbat->None],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["WriteAnim",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                RowBox[{
                  StyleBox["{",
                    "MR"], 
                  RowBox[{
                    StyleBox[\(g\_1\),
                      "InlineFormula",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      FontSlant->"Italic"], 
                    StyleBox[\(g\_2\),
                      "InlineFormula",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      FontSlant->"Italic"], 
                    StyleBox[" ",
                      FontSlant->"Italic"], 
                    StyleBox["...",
                      FontSlant->"Italic"]}], 
                  StyleBox[" ",
                    FontSlant->"Italic"], 
                  StyleBox["}",
                    "MR"]}], ",", 
                StyleBox[" ",
                  "TI"], 
                StyleBox["file",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            
            StyleBox[\(save\ a\ list\ of\ graphics\ as\ animation\ to\ a\ \
\(\(file\)\(.\)\)\),
              "Text"]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnAlignments->{Right, Left}}],

Cell["\<\
For convenience, the command WriteAnim[] automatically encloses the list of \
geometries with the directive ShowAnimation[].\
\>", "Text",
  CellDingbat->None],

Cell["\<\
Set a base working directory relative to which commands like WriteHtml[] may \
export data.\
\>", "MathCaption"],

Cell[BoxData[
    \(\(SetWorkingPath["\<c:/_tmp/math/\>"];\)\)], "Input",
  CellLabel->"In[86]:="],

Cell["\<\
Note: the following export commands store the data relative to the working \
path. All directories such as ./mgs and ./html must exist relative to the \
working path.\
\>", "Commentary"],

Cell["Save a list of surfaces as animation.", "MathCaption"],

Cell[BoxData[
    \(WriteAnim[anim, "\<mgs/writeAnim.mgs\>"]\)], "Input",
  CellLabel->"In[90]:="],

Cell["\<\
Deprecated: Using the directive Animation[] to identify a list of surfaces as \
animation.\
\>", "MathCaption"],

Cell[BoxData[
    \(WriteMgs[
      Apply[Animation, anim], "\<mgs/writeMgs_Animation.mgs\>"]\)], "Input",
  CellLabel->"In[92]:="],

Cell["\<\
Saving a list of geometries to a file or to a web page for publicaction or \
later processing provides more flexibility. For example, JavaView can later \
be directed to play the animation using the command line or applet parameter.\
\
\>", "Text",
  CellDingbat->None],

Cell["Save a list of surfaces ...", "MathCaption"],

Cell[BoxData[
    \(WriteMgs[anim, "\<mgs/writeMgs_List.mgs\>"]\)], "Input",
  CellLabel->"In[93]:="],

Cell["\<\
... and playback the previously saved list of surfaces as animation.\
\>", "MathCaption"],

Cell[BoxData[
    \(\(Run["\<javaview animate=show \>" <> 
          GetWorkingPath[] <> "\<mgs/writeMgs_List.mgs\>"];\)\)], "Input",
  CellLabel->"In[95]:="],

Cell["Save an Animation to a Web Page", "Subsection"],

Cell[TextData[{
  "Similar to the viewing of animations in JavaView there are two different \
ways to save an animation to a geometry file: either by enclosing a list of \
geometries with the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " directive ShowAnimation[], or by saving the animation as list of \
geometries and using the directive Animatable->True."
}], "Text",
  CellDingbat->None],

Cell[BoxData[
    FormBox[
      RowBox[{GridBox[{
            {
              RowBox[{
                StyleBox["WriteHtml",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                RowBox[{
                  RowBox[{
                    StyleBox["{",
                      "MR"], 
                    RowBox[{
                      StyleBox[\(g\_1\),
                        "InlineFormula",
                        FontSlant->"Italic"], 
                      StyleBox[",",
                        FontSlant->"Italic"], 
                      StyleBox[\(g\_2\),
                        "InlineFormula",
                        FontSlant->"Italic"], 
                      StyleBox[",",
                        FontSlant->"Italic"], 
                      StyleBox[" ",
                        FontSlant->"Italic"], 
                      StyleBox["...",
                        FontSlant->"Italic"]}], 
                    StyleBox[" ",
                      FontSlant->"Italic"], 
                    StyleBox["}",
                      "MR"]}], ",", 
                  StyleBox[" ",
                    "TI"], 
                  StyleBox["file",
                    "TI"], 
                  StyleBox[",",
                    "TI"], "\n", 
                  StyleBox[" ",
                    "TI"], 
                  StyleBox[\(Animatable \[Rule] True\),
                    FontFamily->"Courier New",
                    FontSize->12,
                    FontWeight->"Plain",
                    FontSlant->"Italic",
                    FontColor->GrayLevel[0],
                    FontVariations->{"Underline"->False,
                    "StrikeThrough"->False}]}], 
                StyleBox["]",
                  "MR"]}], 
              RowBox[{
                StyleBox["create",
                  "Text"], 
                StyleBox[" ",
                  "Text"], 
                StyleBox["an",
                  "Text"], 
                StyleBox[" ",
                  "Text"], 
                StyleBox["Html",
                  "Text"], 
                StyleBox[" ",
                  "Text"], 
                StyleBox["page",
                  "Text"], 
                StyleBox[" ",
                  "Text"], 
                StyleBox["which",
                  "Text"], 
                StyleBox[" ",
                  "Text"], 
                StyleBox["shows",
                  "Text"], 
                StyleBox[" ",
                  "Text"], 
                StyleBox["a",
                  "Text"], 
                StyleBox[" ",
                  "Text"], 
                StyleBox["list",
                  "Text"], 
                StyleBox[" ",
                  "Text"], 
                StyleBox["of",
                  "Text"], 
                StyleBox[" ",
                  "Text"], 
                StyleBox["Mathematica",
                  "Text"], 
                StyleBox[" ",
                  "Text"], 
                StyleBox["graphics",
                  "Text"], 
                StyleBox[" ",
                  "Text"], 
                StyleBox["as",
                  "Text"], 
                StyleBox[" ",
                  "Text"], 
                StyleBox["animation",
                  "Text"], 
                StyleBox[" ",
                  "Text"], 
                StyleBox["in",
                  "Text"], 
                StyleBox[" ",
                  "Text"], 
                StyleBox["a",
                  "Text"], 
                StyleBox[" ",
                  "Text"], 
                StyleBox["JavaView",
                  "Text"], 
                StyleBox[" ",
                  "Text"], 
                RowBox[{
                  StyleBox["applet",
                    "Text"], 
                  StyleBox[".",
                    "Text"], "\n"}]}]}
            }], GridBox[{
            {
              RowBox[{
                StyleBox["WriteHtml",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                RowBox[{
                  RowBox[{
                    StyleBox["ShowAnimation",
                      "MR"], 
                    StyleBox["[",
                      "MR"], 
                    RowBox[{
                      StyleBox["{",
                        "MR"], 
                      RowBox[{
                        StyleBox[\(g\_1\),
                          "InlineFormula",
                          FontSlant->"Italic"], 
                        StyleBox[",",
                          FontSlant->"Italic"], 
                        StyleBox[\(g\_2\),
                          "InlineFormula",
                          FontSlant->"Italic"], 
                        StyleBox[",",
                          FontSlant->"Italic"], 
                        StyleBox[" ",
                          FontSlant->"Italic"], 
                        StyleBox["...",
                          FontSlant->"Italic"]}], 
                      StyleBox[" ",
                        FontSlant->"Italic"], 
                      StyleBox["}",
                        "MR"]}], 
                    StyleBox["]",
                      "MR"]}], 
                  StyleBox[",",
                    "TI"], 
                  StyleBox[" ",
                    "TI"], 
                  StyleBox["file",
                    "TI"]}], 
                StyleBox["]",
                  "MR"]}], 
              
              StyleBox[\(create\ an\ Html\ page\ which\ shows\ a\ list\ of\ \
Mathematica\ graphics\ as\ animation\ in\ a\ JavaView\ \(\(applet\)\(.\)\)\),
                "Text"]}
            }]}], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnAlignments->{Right, Left}}],

Cell["\<\
Set a base working directory relative to which commands like WriteHtml[] may \
export data.\
\>", "MathCaption"],

Cell[BoxData[
    \(\(SetWorkingPath["\<c:/_tmp/math/\>"];\)\)], "Input",
  CellLabel->"In[86]:="],

Cell["Save a list of geometries as an animation as a web page.", "MathCaption"],

Cell[BoxData[
    \(WriteHtml[anim, "\<html/writeHtml_ListAnimate.html\>", \ 
      Animatable \[Rule] True]\)], "Input",
  CellLabel->"In[30]:="],

Cell[TextData[{
  "Note, instead of including the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics within the web page one may save the graphics to a file, say ",
  StyleBox["geom.mgs",
    FontSlant->"Italic"],
  ", using the export command WriteMgs[] and simply refer to that file via \
applet parameter\n\t<param  name=\"model\"  value=\"geom.mgs\">"
}], "Text"],

Cell["\<\
Save an animation as a web page. CURRENTLY, ShowAnimation[] DOES NOT WORK \
WITH JAVAVIEW\
\>", "MathCaption"],

Cell[BoxData[
    \(WriteHtml[
      ShowAnimation[
        anim], "\<html/writeHtml_ShowAnimation.html\>"]\)], "Input",
  CellLabel->"In[31]:="],

Cell[TextData[{
  "Import an Animation back to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "Subsection"],

Cell[TextData[{
  "A previously saved animation can be loaded back into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". Since the animation uses the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " command ShowAnimation[..] the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " package Graphics`Animation must be loaded."
}], "MathCaption"],

Cell[BoxData[
    \(<< Graphics`Animation`\)], "Input",
  CellLabel->"In[96]:="],

Cell[BoxData[
    \(<< c:/_tmp/math/mgs/writeAnim.mgs\)], "Input",
  CellLabel->"In[97]:="],

Cell["Some more Examples", "Subsection"],

Cell["\<\
Set a base working directory relative to which commands like WriteHtml[] may \
export data.\
\>", "MathCaption"],

Cell[BoxData[
    \(\(SetWorkingPath["\<c:/_tmp/math/\>"];\)\)], "Input",
  CellLabel->"In[75]:="],

Cell["Random Cubes", "Subsubsection"],

Cell[TextData[{
  "A random list of cubes is displayed in ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " as an animated single cube."
}], "MathCaption"],

Cell[BoxData[
    \(\(b = \ 
        Table[Graphics3D[
            Cuboid[{Random[Integer, 20], Random[Integer, 20], 
                Random[Integer, 20]}], Boxed \[Rule] False], {t, 1, 20, 
            1}];\)\)], "Input",
  CellLabel->"In[64]:="],

Cell[BoxData[
    \(\(Show[b];\)\)], "Input",
  CellLabel->"In[65]:="],

Cell[BoxData[
    \(\(JavaView[b, Animatable \[Rule] True];\)\)], "Input",
  CellLabel->"In[67]:="],

Cell[BoxData[
    \(WriteHtml[b, "\<html/cubesAnim.html\>", 
      Animatable \[Rule] True]\)], "Input",
  CellLabel->"In[77]:="],

Cell["Density Plots", "Subsubsection"],

Cell["An animated set of density plots.", "MathCaption"],

Cell[BoxData[
    \(\(c = 
        Table[DensityPlot[
            Sin[Sin[t] x + Cos[t] y] Sin[Cos[t] x - Sin[t] y], {x, \(-2\), 
              2}, {y, \(-2\), 2}], {t, 0. , 2  Pi, Pi/4}];\)\)], "Input",
  CellLabel->"In[80]:="],

Cell[BoxData[
    \(\(JavaView[c, Animatable \[Rule] True];\)\)], "Input",
  CellLabel->"In[10]:="],

Cell[BoxData[
    \(WriteHtml[c, "\<html/densityAnim.html\>", 
      Animatable \[Rule] True]\)], "Input",
  CellLabel->"In[81]:="],

Cell["Rotating Line", "Subsubsection"],

Cell["A rotating line.", "MathCaption"],

Cell[BoxData[
    \(\(d = 
        Table[Graphics[Line[{{0, 0}, {Cos[t], Sin[t]}}], 
            PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}}], {t, 0, 2  Pi, 
            Pi/8}];\)\)], "Input",
  CellLabel->"In[82]:="],

Cell[BoxData[
    \(\(JavaView[d, \ Animatable \[Rule] True];\)\)], "Input",
  CellLabel->"In[12]:="],

Cell[BoxData[
    \(WriteHtml[d, "\<html/lineAnim.html\>", 
      Animatable \[Rule] True]\)], "Input",
  CellLabel->"In[83]:="]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1400}, {0, 1000}},
ScreenStyleEnvironment->"Brackets",
WindowSize->{865, 955},
WindowMargins->{{Automatic, 23}, {Automatic, -2}},
Magnification->1.25,
StyleDefinitions -> "HelpBrowser.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 367, 13, 124, "Chapter"],
Cell[2087, 64, 113, 5, 42, "Subsubsection"],
Cell[2203, 71, 482, 18, 48, "Text"],
Cell[2688, 91, 163, 5, 36, "MathCaption"],
Cell[2854, 98, 129, 3, 54, "Input"],
Cell[2986, 103, 72, 0, 42, "Subsubsection"],
Cell[3061, 105, 372, 6, 67, "Text"],
Cell[3436, 113, 96, 2, 36, "MathCaption"],
Cell[3535, 117, 818, 16, 159, "Input"],
Cell[4356, 135, 108, 4, 56, "Subsection"],
Cell[4467, 141, 219, 7, 29, "Text"],
Cell[4689, 150, 6735, 203, 195, "DefinitionBox"],
Cell[11427, 355, 207, 5, 48, "Text"],
Cell[11637, 362, 173, 4, 29, "Text"],
Cell[11813, 368, 155, 3, 36, "MathCaption"],
Cell[11971, 373, 209, 6, 33, "Input"],
Cell[12183, 381, 306, 7, 55, "MathCaption"],
Cell[12492, 390, 97, 2, 33, "Input"],
Cell[12592, 394, 177, 6, 29, "Text"],
Cell[12772, 402, 163, 3, 63, "MathCaption"],
Cell[12938, 407, 145, 3, 54, "Input"],
Cell[13086, 412, 115, 4, 43, "Subsubsection"],
Cell[13204, 418, 63, 0, 36, "MathCaption"],
Cell[13270, 420, 102, 2, 33, "Input"],
Cell[13375, 424, 121, 3, 36, "MathCaption"],
Cell[13499, 429, 93, 2, 33, "Input"],
Cell[13595, 433, 77, 0, 36, "MathCaption"],
Cell[13675, 435, 90, 2, 33, "Input"],
Cell[13768, 439, 48, 0, 42, "Subsubsection"],
Cell[13819, 441, 211, 5, 48, "Text"],
Cell[14033, 448, 80, 2, 36, "MathCaption"],
Cell[14116, 452, 143, 3, 33, "Input"],
Cell[14262, 457, 125, 3, 36, "MathCaption"],
Cell[14390, 462, 148, 3, 33, "Input"],
Cell[14541, 467, 151, 3, 33, "Input"],
Cell[14695, 472, 364, 9, 48, "Text"],
Cell[15062, 483, 217, 4, 54, "Input"],
Cell[15282, 489, 127, 3, 63, "MathCaption"],
Cell[15412, 494, 145, 3, 33, "Input"],
Cell[15560, 499, 43, 0, 56, "Subsection"],
Cell[15606, 501, 403, 12, 55, "MathCaption"],
Cell[16012, 515, 314, 7, 54, "Input"],
Cell[16329, 524, 167, 4, 36, "MathCaption"],
Cell[16499, 530, 78, 2, 33, "Input"],
Cell[16580, 534, 124, 3, 36, "MathCaption"],
Cell[16707, 539, 98, 2, 33, "Input"],
Cell[16808, 543, 58, 0, 56, "Subsection"],
Cell[16869, 545, 368, 9, 48, "Text"],
Cell[17240, 556, 1430, 42, 51, "DefinitionBox"],
Cell[18673, 600, 169, 4, 29, "Text"],
Cell[18845, 606, 122, 3, 36, "MathCaption"],
Cell[18970, 611, 98, 2, 33, "Input"],
Cell[19071, 615, 196, 4, 59, "Commentary"],
Cell[19270, 621, 60, 0, 36, "MathCaption"],
Cell[19333, 623, 98, 2, 33, "Input"],
Cell[19434, 627, 121, 3, 36, "MathCaption"],
Cell[19558, 632, 131, 3, 33, "Input"],
Cell[19692, 637, 279, 6, 48, "Text"],
Cell[19974, 645, 50, 0, 36, "MathCaption"],
Cell[20027, 647, 101, 2, 33, "Input"],
Cell[20131, 651, 99, 2, 36, "MathCaption"],
Cell[20233, 655, 158, 3, 33, "Input"],
Cell[20394, 660, 53, 0, 56, "Subsection"],
Cell[20450, 662, 404, 9, 67, "Text"],
Cell[20857, 673, 5763, 170, 123, "DefinitionBox"],
Cell[26623, 845, 122, 3, 36, "MathCaption"],
Cell[26748, 850, 98, 2, 33, "Input"],
Cell[26849, 854, 79, 0, 36, "MathCaption"],
Cell[26931, 856, 146, 3, 33, "Input"],
Cell[27080, 861, 384, 9, 75, "Text"],
Cell[27467, 872, 120, 3, 36, "MathCaption"],
Cell[27590, 877, 145, 4, 33, "Input"],
Cell[27738, 883, 118, 4, 56, "Subsection"],
Cell[27859, 889, 371, 11, 55, "MathCaption"],
Cell[28233, 902, 80, 2, 33, "Input"],
Cell[28316, 906, 91, 2, 33, "Input"],
Cell[28410, 910, 40, 0, 56, "Subsection"],
Cell[28453, 912, 122, 3, 36, "MathCaption"],
Cell[28578, 917, 98, 2, 33, "Input"],
Cell[28679, 921, 37, 0, 42, "Subsubsection"],
Cell[28719, 923, 161, 5, 36, "MathCaption"],
Cell[28883, 930, 247, 6, 75, "Input"],
Cell[29133, 938, 70, 2, 33, "Input"],
Cell[29206, 942, 99, 2, 33, "Input"],
Cell[29308, 946, 129, 3, 33, "Input"],
Cell[29440, 951, 38, 0, 42, "Subsubsection"],
Cell[29481, 953, 56, 0, 36, "MathCaption"],
Cell[29540, 955, 228, 5, 54, "Input"],
Cell[29771, 962, 99, 2, 33, "Input"],
Cell[29873, 966, 131, 3, 33, "Input"],
Cell[30007, 971, 38, 0, 42, "Subsubsection"],
Cell[30048, 973, 39, 0, 36, "MathCaption"],
Cell[30090, 975, 218, 5, 54, "Input"],
Cell[30311, 982, 101, 2, 33, "Input"],
Cell[30415, 986, 128, 3, 33, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

