/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.number.PdVector_IP;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.viewer.PvCamera;
import jv.viewer.PvDisplay;

public class PvCamera_IP
extends PsPanel
implements ActionListener,
ItemListener {
    protected PvCamera m_camera;
    protected PvDisplay m_disp;
    protected Checkbox m_cAllViews;
    protected CheckboxGroup m_gProjection;
    protected Checkbox m_rPerspective;
    protected Checkbox m_rTop;
    protected Checkbox m_rFront;
    protected Checkbox m_rRight;
    protected PsPanel m_pOrient;
    protected PsPanel m_pOrient2;
    protected Checkbox m_cShowCamera;
    protected Checkbox m_cLocal;
    protected CheckboxGroup m_gTransform;
    protected Checkbox m_rCameraTransform;
    protected Checkbox m_rModelTransform;
    protected Checkbox m_rAmbientTransform;
    protected int m_spaceMode = 3;
    protected Choice m_cAmbient;
    protected Label m_lAmbient;
    protected Choice m_cProj;
    protected Label m_lProj;
    protected PdVector m_viewDir;
    protected PdVector_IP m_pViewDir;
    protected PdVector m_interest;
    protected PdVector_IP m_pInterest;
    protected PuDouble m_dist;
    protected Checkbox m_cFillDisplay;
    protected Checkbox m_cShowBoxRatio;
    protected PdVector_IP m_pBoxRatio;
    protected PdVector m_boxRatio;
    protected PsPanel m_pClipRange;
    protected Checkbox m_cClip;
    protected Checkbox m_cRange;
    protected int m_rangeType = 0;
    protected CheckboxGroup m_gRangeAxis;
    protected Checkbox m_cXRange;
    protected Checkbox m_cYRange;
    protected Checkbox m_cZRange;
    protected Button m_bCenter;
    protected Button m_bFit;
    protected Button m_bSave;
    protected Button m_bReset;
    protected Button m_bResetAll;
    static /* synthetic */ Class class$jv$viewer$PvCamera_IP;

    public PvCamera_IP() {
        if (this.getClass() == (class$jv$viewer$PvCamera_IP == null ? (class$jv$viewer$PvCamera_IP = PvCamera_IP.class$("jv.viewer.PvCamera_IP")) : class$jv$viewer$PvCamera_IP)) {
            this.init();
        }
    }

    public void init() {
        PsPanel psPanel;
        super.init();
        this.setInsetSize(4);
        this.setBorderType(1);
        Label label = this.getTitle("", PsConfig.getFont(3));
        if (!PsConfig.isApplication()) {
            this.add(label);
        } else {
            psPanel = new PsPanel(new GridLayout(1, 2));
            psPanel.add(label);
            this.m_cAllViews = new Checkbox(PsConfig.getMessage(24339), false);
            this.m_cAllViews.addItemListener(this);
            psPanel.add(this.m_cAllViews);
            this.add(psPanel);
        }
        psPanel = new PsPanel(new GridLayout(2, 2));
        psPanel.setInsetSizeHorizontal(4);
        this.add(psPanel);
        this.m_gProjection = new CheckboxGroup();
        this.m_rPerspective = new Checkbox(PsConfig.getMessage(24162), this.m_gProjection, true);
        this.m_rPerspective.addItemListener(this);
        psPanel.add(this.m_rPerspective);
        this.m_rTop = new Checkbox(PsConfig.getMessage(24222), this.m_gProjection, false);
        this.m_rTop.addItemListener(this);
        psPanel.add(this.m_rTop);
        this.m_rFront = new Checkbox(PsConfig.getMessage(24223), this.m_gProjection, false);
        this.m_rFront.addItemListener(this);
        psPanel.add(this.m_rFront);
        this.m_rRight = new Checkbox(PsConfig.getMessage(24224), this.m_gProjection, false);
        this.m_rRight.addItemListener(this);
        psPanel.add(this.m_rRight);
        this.addLine(1);
        this.m_pOrient = new PsPanel();
        this.add(this.m_pOrient);
        PsPanel psPanel2 = new PsPanel(new GridLayout(1, 2));
        psPanel2.addTitle(PsConfig.getMessage(24225));
        this.m_cShowCamera = new Checkbox(PsConfig.getMessage(24361), false);
        this.m_cShowCamera.addItemListener(this);
        psPanel2.add(this.m_cShowCamera);
        this.m_pOrient.add(psPanel2);
        this.m_pViewDir = new PdVector_IP();
        this.m_pViewDir.setTitle(PsConfig.getMessage(24226));
        this.m_pViewDir.setParent(this);
        this.m_viewDir = new PdVector(3);
        this.m_pViewDir.setVector(this.m_viewDir);
        this.m_pOrient.add(this.m_pViewDir);
        this.m_pInterest = new PdVector_IP();
        this.m_pInterest.setTitle(PsConfig.getMessage(24227));
        this.m_pInterest.setParent(this);
        this.m_interest = new PdVector(3);
        this.m_pInterest.setVector(this.m_interest);
        this.m_pOrient.add(this.m_pInterest);
        this.m_pOrient2 = new PsPanel();
        this.add(this.m_pOrient2);
        this.m_dist = new PuDouble(PsConfig.getMessage(24228), this);
        this.m_dist.setBounds(0.001, 100.0, 1.0, 10.0);
        this.m_dist.setValue(10.0);
        this.addLine(1);
        psPanel2 = new PsPanel();
        this.add(psPanel2);
        PsPanel psPanel3 = new PsPanel(new GridLayout(1, 2));
        psPanel3.addTitle(PsConfig.getMessage(24229));
        this.m_cLocal = new Checkbox(PsConfig.getMessage(24230), true);
        this.m_cLocal.addItemListener(this);
        psPanel3.add(this.m_cLocal);
        psPanel2.add(psPanel3);
        PsPanel psPanel4 = new PsPanel(new GridLayout(1, 3));
        psPanel2.add(psPanel4);
        this.m_gTransform = new CheckboxGroup();
        this.m_rCameraTransform = new Checkbox(PsConfig.getMessage(24231), this.m_gTransform, true);
        this.m_rCameraTransform.addItemListener(this);
        psPanel4.add(this.m_rCameraTransform);
        this.m_rModelTransform = new Checkbox(PsConfig.getMessage(24117), this.m_gTransform, false);
        this.m_rModelTransform.addItemListener(this);
        psPanel4.add(this.m_rModelTransform);
        this.m_rAmbientTransform = new Checkbox("... " + PsConfig.getMessage(24232), this.m_gTransform, false);
        this.m_rAmbientTransform.addItemListener(this);
        psPanel4.add(this.m_rAmbientTransform);
        psPanel3 = new PsPanel(new GridLayout(2, 2));
        psPanel3.setInsetSizeHorizontal(4);
        this.add(psPanel3);
        this.m_lAmbient = new Label(PsConfig.getMessage(24233));
        psPanel3.add(this.m_lAmbient);
        this.m_cAmbient = new Choice();
        this.m_cAmbient.addItemListener(this);
        for (int i = 0; i < PgGeometryIf.AMBIENT_SPACES[this.m_spaceMode].length; ++i) {
            this.m_cAmbient.add(PgGeometryIf.AMBIENT_SPACES[this.m_spaceMode][i]);
        }
        psPanel3.add(this.m_cAmbient);
        this.m_lProj = new Label(PsConfig.getMessage(24234));
        psPanel3.add(this.m_lProj);
        this.m_cProj = new Choice();
        this.m_cProj.addItemListener(this);
        psPanel3.add(this.m_cProj);
        this.addLine(1);
        PsPanel psPanel5 = new PsPanel(new GridLayout(1, 2));
        psPanel5.addTitle(PsConfig.getMessage(24235));
        Panel panel = new Panel(new GridLayout(1, 2));
        this.m_cRange = new Checkbox(PsConfig.getMessage(24231));
        this.m_cRange.addItemListener(this);
        panel.add(this.m_cRange);
        this.m_cClip = new Checkbox(PsConfig.getMessage(24238));
        this.m_cClip.addItemListener(this);
        panel.add(this.m_cClip);
        psPanel5.add(panel);
        this.add(psPanel5);
        panel = new PsPanel(new GridLayout(1, 3));
        this.m_gRangeAxis = new CheckboxGroup();
        this.m_cXRange = new Checkbox(PsConfig.getMessage(24341), this.m_gRangeAxis, true);
        this.m_cXRange.addItemListener(this);
        panel.add(this.m_cXRange);
        this.m_cYRange = new Checkbox(PsConfig.getMessage(24342), this.m_gRangeAxis, false);
        this.m_cYRange.addItemListener(this);
        panel.add(this.m_cYRange);
        this.m_cZRange = new Checkbox(PsConfig.getMessage(24343), this.m_gRangeAxis, false);
        this.m_cZRange.addItemListener(this);
        panel.add(this.m_cZRange);
        this.add(panel);
        this.m_pClipRange = new PsPanel(new GridLayout(2, 1));
        this.add(this.m_pClipRange);
        this.addLine(1);
        PsPanel psPanel6 = new PsPanel();
        this.add(psPanel6);
        Panel panel2 = new PsPanel(new GridLayout(1, 2));
        psPanel6.add(panel2);
        ((PsPanel)panel2).addTitle(PsConfig.getMessage(24347));
        Panel panel3 = new PsPanel(new GridLayout(1, 2));
        this.m_cShowBoxRatio = new Checkbox(PsConfig.getMessage(24413), false);
        this.m_cShowBoxRatio.addItemListener(this);
        panel3.add(this.m_cShowBoxRatio);
        this.m_cFillDisplay = new Checkbox(PsConfig.getMessage(true, 24000, "Aspect"), false);
        this.m_cFillDisplay.addItemListener(this);
        panel3.add(this.m_cFillDisplay);
        panel2.add(panel3);
        this.m_pBoxRatio = new PdVector_IP();
        this.m_pBoxRatio.setTitle(PsConfig.getMessage(24414));
        this.m_pBoxRatio.setParent(this);
        this.m_boxRatio = new PdVector(1.0, 1.0, 1.0);
        this.m_pBoxRatio.setVector(this.m_boxRatio);
        psPanel6.add(this.m_pBoxRatio);
        this.addLine(1);
        panel2 = new Panel(new FlowLayout(1));
        this.add(panel2);
        this.m_bCenter = new Button(PsConfig.getMessage(24090));
        this.m_bCenter.addActionListener(this);
        panel2.add(this.m_bCenter);
        this.m_bFit = new Button(PsConfig.getMessage(24236));
        this.m_bFit.addActionListener(this);
        panel2.add(this.m_bFit);
        panel3 = new Panel(new FlowLayout(1));
        this.add(panel3);
        this.m_bSave = new Button(PsConfig.getMessage(24141));
        this.m_bSave.addActionListener(this);
        panel3.add(this.m_bSave);
        this.m_bReset = new Button(PsConfig.getMessage(24104));
        this.m_bReset.addActionListener(this);
        panel3.add(this.m_bReset);
        this.m_bResetAll = new Button(PsConfig.getMessage(24237));
        this.m_bResetAll.addActionListener(this);
        panel3.add(this.m_bResetAll);
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        if (psUpdateIf == null) {
            PsDebug.warning("missing camera");
            return;
        }
        super.setParent(psUpdateIf);
        this.m_camera = (PvCamera)psUpdateIf;
        this.m_disp = this.m_camera.m_display;
        this.m_pOrient2.removeAll();
        this.m_pOrient2.add(this.m_dist.getInfoPanel());
        this.m_pOrient2.add(this.m_camera.m_roll.getInfoPanel());
        this.m_pOrient2.add(this.m_camera.m_fieldOfView.getInfoPanel());
        this.m_pOrient2.validate();
        if (!this.m_disp.isEnabledClip() && !this.m_disp.isEnabledClipBounds()) {
            this.m_pClipRange.removeAll();
            this.m_pClipRange.add(this.m_camera.m_nearClip.getInfoPanel());
            this.m_pClipRange.add(this.m_camera.m_farClip.getInfoPanel());
            this.m_pClipRange.validate();
        }
        this.setClipState(-1, false);
        this.setClipState(0, false);
        if (!this.m_disp.isEnabledClip()) {
            this.adjustRangeBounds(-1, -1);
        }
        if (!this.m_disp.isEnabledClipBounds()) {
            this.adjustRangeBounds(0, 0);
            this.adjustRangeBounds(0, 1);
            this.adjustRangeBounds(0, 2);
        }
        this.setTransformationMode(this.m_disp.getTransformationMode());
        switch (this.m_camera.getProjectionMode()) {
            default: {
                PsDebug.warning("unknown projection mode = " + this.m_camera.getProjectionMode());
                break;
            }
            case 0: {
                this.m_gProjection.setSelectedCheckbox(this.m_rPerspective);
                break;
            }
            case 1: {
                this.m_gProjection.setSelectedCheckbox(this.m_rTop);
                break;
            }
            case 2: {
                this.m_gProjection.setSelectedCheckbox(this.m_rFront);
                break;
            }
            case 3: {
                this.m_gProjection.setSelectedCheckbox(this.m_rRight);
            }
        }
    }

    public boolean update(Object object) {
        if (this.m_camera == null) {
            PsDebug.warning("missing camera");
            return false;
        }
        if (object == this.m_camera) {
            this.m_disp = this.m_camera.m_display;
            this.setTitle(PsConfig.getMessage(24238) + ": " + this.m_disp.getName());
            if (this.m_cAllViews != null) {
                PsPanel.setState(this.m_cAllViews, this.m_disp.isShowingAllViews());
            }
            this.m_viewDir.copy(this.m_camera.getViewDir());
            this.m_pViewDir.update(this.m_viewDir);
            this.m_interest.copy(this.m_camera.getInterest());
            this.m_pInterest.update(this.m_interest);
            this.m_dist.setValue(this.m_camera.getDist());
            boolean bl = this.m_disp.isEnabledBoxRatio();
            PsPanel.setState(this.m_cShowBoxRatio, bl);
            PsPanel.setState(this.m_cFillDisplay, this.m_disp.isEnabledFillDisplay());
            PdVector pdVector = this.m_disp.getBoxRatio();
            if (pdVector != null && PdVector.sqrDist(this.m_boxRatio, pdVector) > 1.0E-10) {
                this.m_boxRatio.copyArray(pdVector);
                this.m_pBoxRatio.update(this.m_boxRatio);
            }
            this.m_camera.getRoll();
            PsPanel.setState(this.m_cShowCamera, this.m_disp.isShowingCamera());
            PsPanel.setState(this.m_cLocal, this.m_disp.isEnabledLocalTransform());
            this.setTransformationMode(this.m_disp.getTransformationMode());
            this.setAmbientSpace(this.m_disp.getAmbientSpace());
            if (this.m_cClip.getState() != this.m_disp.isEnabledClip()) {
                this.setClipState(-1, this.m_disp.isEnabledClip());
            }
            if (this.m_disp.m_clipBoundsType > -1 && this.m_disp.m_clipBoundsType != this.getSelectedRange()) {
                this.selectRangeType(this.m_disp.m_clipBoundsType);
                if (this.m_disp.m_clipBoundsType == 0) {
                    this.m_gRangeAxis.setSelectedCheckbox(this.m_cXRange);
                } else if (this.m_disp.m_clipBoundsType == 1) {
                    this.m_gRangeAxis.setSelectedCheckbox(this.m_cYRange);
                } else if (this.m_disp.m_clipBoundsType == 2) {
                    this.m_gRangeAxis.setSelectedCheckbox(this.m_cZRange);
                }
            }
            if (this.m_cRange.getState() != this.m_disp.isEnabledClipBounds()) {
                this.setClipState(0, this.m_disp.isEnabledClipBounds());
            }
            return true;
        }
        if (object == this) {
            this.m_camera.setViewDir(this.m_pViewDir.getVector());
            this.m_camera.setInterest(this.m_pInterest.getVector());
            this.m_camera.setDist(this.m_dist.getValue());
            return this.m_camera.update(null);
        }
        if (object == this.m_pViewDir) {
            this.m_camera.setViewDir(this.m_pViewDir.getVector());
            return this.m_camera.update(null);
        }
        if (object == this.m_pInterest) {
            this.m_camera.setInterest(this.m_pInterest.getVector());
            return this.m_camera.update(null);
        }
        if (object == this.m_dist) {
            this.m_camera.setDist(this.m_dist.getValue());
            return this.m_camera.update(null);
        }
        if (object == this.m_pBoxRatio) {
            boolean bl = false;
            for (int i = 0; i < this.m_boxRatio.getSize(); ++i) {
                if (!(Math.abs(this.m_boxRatio.getEntry(i)) < 1.0E-10)) continue;
                this.m_boxRatio.setEntry(i, 1.0);
                bl = true;
            }
            if (bl) {
                this.m_pBoxRatio.update(this.m_boxRatio);
            }
            this.m_disp.setBoxRatioFromPanel(this.m_boxRatio);
            this.m_disp.update(this.m_camera);
            return true;
        }
        return super.update(object);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.m_camera == null) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object == this.m_bCenter) {
            this.m_disp.center();
            this.m_camera.update(this.m_camera);
        } else if (object == this.m_bFit) {
            this.m_disp.fit();
            this.m_camera.update(this.m_camera);
        } else {
            if (object == this.m_bSave) {
                this.m_camera.saveAsDefault();
                return;
            }
            if (object == this.m_bReset) {
                PdMatrix pdMatrix;
                int n = this.m_disp.getTransformationMode();
                if (n == 0) {
                    this.m_camera.reset();
                } else if (n == 1) {
                    PdMatrix pdMatrix2 = this.m_disp.getTransMatrix(8);
                    if (pdMatrix2 != null) {
                        pdMatrix2.setIdentity();
                        pdMatrix2 = this.m_disp.getTransMatrix(256);
                        pdMatrix2.setIdentity();
                    }
                } else if (n == 2 && (pdMatrix = this.m_disp.getTransMatrix(512)) != null) {
                    pdMatrix.setIdentity();
                    pdMatrix = this.m_disp.getTransMatrix(1024);
                    pdMatrix.setIdentity();
                }
                this.m_camera.update(this.m_camera);
            } else if (object == this.m_bResetAll) {
                this.m_disp.resetTransformModel();
                this.m_disp.m_clipBoundsType = this.m_disp.m_defClipBoundsType;
                this.m_disp.setEnabledClip((this.m_disp.m_sceneDefaults & 0x400000000L) != 0L);
                this.m_disp.setEnabledClipBounds((this.m_disp.m_sceneDefaults & 0x100000000L) != 0L);
                this.m_disp.recomputeBndBox();
                this.m_camera.reset();
                this.m_camera.update(this.m_camera);
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.m_camera == null) {
            return;
        }
        Object object = itemEvent.getSource();
        int n = this.m_disp.m_cameraDefault;
        long l = this.m_disp.m_sceneDefaults;
        if (object == this.m_cAllViews) {
            this.m_disp.showAllViews(this.m_cAllViews.getState());
            this.m_camera.update(null);
        } else if (object == this.m_cShowBoxRatio) {
            this.m_disp.setEnabledBoxRatio(this.m_cShowBoxRatio.getState());
            this.m_disp.update(this.m_camera);
        } else if (object == this.m_cFillDisplay) {
            this.m_disp.setEnabledFillDisplay(this.m_cFillDisplay.getState());
            this.m_disp.update(this.m_camera);
        } else if (object == this.m_rPerspective) {
            this.m_disp.selectCamera(0);
            this.m_camera.update(null);
        } else if (object == this.m_rTop) {
            this.m_disp.selectCamera(1);
            this.m_camera.update(null);
        } else if (object == this.m_rFront) {
            this.m_disp.selectCamera(2);
            this.m_camera.update(null);
        } else if (object == this.m_rRight) {
            this.m_disp.selectCamera(3);
            this.m_camera.update(null);
        } else if (object == this.m_cLocal) {
            this.m_disp.setEnabledLocalTransform(this.m_cLocal.getState());
            this.m_camera.update(this.m_camera);
        } else if (object == this.m_rCameraTransform) {
            this.m_disp.setTransformationMode(0);
            this.m_camera.update(this.m_camera);
        } else if (object == this.m_rModelTransform) {
            this.m_disp.setTransformationMode(1);
            this.m_camera.update(this.m_camera);
        } else if (object == this.m_rAmbientTransform) {
            this.m_disp.setTransformationMode(2);
            this.m_camera.update(this.m_camera);
        } else if (object == this.m_cAmbient) {
            int n2 = this.m_cAmbient.getSelectedIndex();
            int n3 = this.m_disp.getAmbientDim();
            switch (n2) {
                case 0: {
                    if (this.m_spaceMode == 0 || this.m_spaceMode == 1 || this.m_spaceMode == 3 || this.m_spaceMode == 6 || this.m_spaceMode == 9) {
                        return;
                    }
                    if (n3 == 2) {
                        this.m_spaceMode = 1;
                        break;
                    }
                    if (n3 == 3) {
                        this.m_spaceMode = 3;
                        break;
                    }
                    if (n3 == 4) {
                        this.m_spaceMode = 6;
                        break;
                    }
                    if (n3 != 5) break;
                    this.m_spaceMode = 9;
                    break;
                }
                case 1: {
                    if (this.m_spaceMode == 2 || this.m_spaceMode == 4 || this.m_spaceMode == 7 || this.m_spaceMode == 10) {
                        return;
                    }
                    if (n3 == 2) {
                        this.m_spaceMode = 2;
                        break;
                    }
                    if (n3 == 3) {
                        this.m_spaceMode = 4;
                        break;
                    }
                    if (n3 == 4) {
                        this.m_spaceMode = 7;
                        break;
                    }
                    if (n3 != 5) break;
                    this.m_spaceMode = 10;
                    break;
                }
                case 2: {
                    if (this.m_spaceMode == 5 || this.m_spaceMode == 8 || this.m_spaceMode == 11) {
                        return;
                    }
                    if (n3 == 3) {
                        this.m_spaceMode = 5;
                        break;
                    }
                    if (n3 == 4) {
                        this.m_spaceMode = 8;
                        break;
                    }
                    if (n3 != 5) break;
                    this.m_spaceMode = 11;
                }
            }
            this.m_disp.setAmbientSpace(this.m_spaceMode);
            this.m_cProj.removeAll();
            for (int i = 0; i < PgGeometryIf.AMBIENT_PROJECTIONS[this.m_spaceMode].length; ++i) {
                this.m_cProj.add(PgGeometryIf.AMBIENT_PROJECTIONS[this.m_spaceMode][i]);
            }
            if (this.m_disp.getAmbientProjection() >= this.m_cProj.getItemCount()) {
                this.m_disp.setAmbientProjection(0);
            }
            this.m_cProj.select(this.m_disp.getAmbientProjection());
            this.m_disp.update(this.m_disp);
        } else if (object == this.m_cProj) {
            this.m_disp.setAmbientProjection(this.m_cProj.getSelectedIndex());
            this.m_disp.update(this.m_disp);
        } else if (object == this.m_cClip) {
            boolean bl = this.m_cClip.getState();
            this.m_disp.setEnabledClip(bl);
            if (bl) {
                this.m_disp.setEnabledClipBounds(false);
                this.adjustRangeBounds(-1, -1);
            }
            this.m_disp.recomputeBndBox();
            this.setClipState(-1, bl);
            this.m_camera.update(null);
        } else if (object == this.m_cRange) {
            boolean bl = this.m_cRange.getState();
            this.m_disp.setEnabledClipBounds(bl);
            if (bl) {
                this.m_disp.setEnabledClip(false);
                this.adjustRangeBounds(0, 0);
                this.adjustRangeBounds(0, 1);
                this.adjustRangeBounds(0, 2);
            }
            this.m_disp.recomputeBndBox();
            this.setClipState(0, bl);
            this.m_camera.update(null);
        } else if (object == this.m_cXRange || object == this.m_cYRange || object == this.m_cZRange) {
            this.selectRangeType(this.getSelectedRange());
            this.m_disp.m_clipBoundsType = this.getSelectedRange();
            this.m_disp.update((Object)null);
        } else if (object == this.m_cShowCamera) {
            this.m_disp.showCamera(this.m_cShowCamera.getState());
            this.m_disp.showInterest(this.m_cShowCamera.getState());
            this.m_disp.update(this.m_camera);
        }
        this.m_disp.m_cameraDefault = n;
        this.m_disp.m_sceneDefaults = l;
    }

    private void selectRangeType(int n) {
        if (n < 0 || n == this.m_rangeType) {
            return;
        }
        this.m_rangeType = n;
        this.m_pClipRange.removeAll();
        this.m_pClipRange.add(this.m_disp.m_clipBoundMin[this.m_rangeType].getInfoPanel());
        this.m_pClipRange.add(this.m_disp.m_clipBoundMax[this.m_rangeType].getInfoPanel());
        this.m_pClipRange.validate();
    }

    private void setClipState(int n, boolean bl) {
        if (n == -1) {
            PsPanel.setState(this.m_cClip, bl);
            if (bl) {
                if (this.m_cRange.getState()) {
                    this.setClipState(0, false);
                }
                this.m_pClipRange.removeAll();
                this.m_pClipRange.add(this.m_camera.m_nearClip.getInfoPanel());
                this.m_pClipRange.add(this.m_camera.m_farClip.getInfoPanel());
                this.m_pClipRange.validate();
            }
            this.m_camera.m_nearClip.setEnabled(bl);
            this.m_camera.m_farClip.setEnabled(bl);
        } else if (n == 0) {
            PsPanel.setState(this.m_cRange, bl);
            if (bl) {
                if (this.m_cClip.getState()) {
                    this.setClipState(-1, false);
                }
                this.m_pClipRange.removeAll();
                this.m_pClipRange.add(this.m_disp.m_clipBoundMin[this.m_rangeType].getInfoPanel());
                this.m_pClipRange.add(this.m_disp.m_clipBoundMax[this.m_rangeType].getInfoPanel());
                this.m_pClipRange.validate();
            }
            this.m_cXRange.setEnabled(bl);
            this.m_cYRange.setEnabled(bl);
            this.m_cZRange.setEnabled(bl);
            if (this.m_disp.m_clipBoundMin != null) {
                for (int i = 0; i < 3; ++i) {
                    this.m_disp.m_clipBoundMin[i].setEnabled(bl);
                    this.m_disp.m_clipBoundMax[i].setEnabled(bl);
                }
            }
        }
    }

    private int getSelectedRange() {
        Checkbox checkbox = this.m_gRangeAxis.getSelectedCheckbox();
        if (checkbox == this.m_cXRange) {
            return 0;
        }
        if (checkbox == this.m_cYRange) {
            return 1;
        }
        if (checkbox == this.m_cZRange) {
            return 2;
        }
        return 0;
    }

    private void adjustRangeBounds(int n, int n2) {
        if (n == -1) {
            double d;
            double d2;
            PdVector[] pdVectorArray = this.m_camera.getBounds();
            if (pdVectorArray == null) {
                return;
            }
            if (pdVectorArray[1].m_data[2] < pdVectorArray[0].m_data[2]) {
                d2 = pdVectorArray[1].m_data[2];
                d = pdVectorArray[0].m_data[2];
            } else {
                d2 = pdVectorArray[0].m_data[2];
                d = pdVectorArray[1].m_data[2];
            }
            this.m_camera.m_nearClip.setBounds(d2 - (-d2 + d) / 2.0, d + (-d2 + d) / 2.0, 0.02, 1.0);
            this.m_camera.m_farClip.setBounds(d2 - (-d2 + d) / 2.0, d + (-d2 + d) / 2.0, 0.02, 1.0);
            this.m_camera.m_nearClip.setValue(d);
            this.m_camera.m_farClip.setValue(d2);
        } else {
            if (!this.m_disp.isEnabledClipAutoBounds()) {
                return;
            }
            if (this.m_disp.m_clipBoundMin == null || this.m_disp.m_clipBoundMin[n2] == null) {
                return;
            }
            PdVector[] pdVectorArray = this.m_disp.m_scene.getBounds();
            if (pdVectorArray == null) {
                return;
            }
            double d = pdVectorArray[0].m_data[n2];
            double d3 = pdVectorArray[1].m_data[n2];
            this.m_disp.m_clipBoundMin[n2].setBounds(d - (-d + d3) / 2.0, d3 + (-d + d3) / 2.0, 0.02, 1.0);
            this.m_disp.m_clipBoundMax[n2].setBounds(d - (-d + d3) / 2.0, d3 + (-d + d3) / 2.0, 0.02, 1.0);
            this.m_disp.setClipBounds(n2, new double[]{d, d3});
        }
    }

    private void setTransformationMode(int n) {
        Checkbox checkbox = this.m_gTransform.getSelectedCheckbox();
        Checkbox checkbox2 = null;
        switch (n) {
            default: {
                PsDebug.warning("unknown transformation mode = " + n);
            }
            case 0: {
                checkbox2 = this.m_rCameraTransform;
                break;
            }
            case 1: {
                checkbox2 = this.m_rModelTransform;
                break;
            }
            case 2: {
                checkbox2 = this.m_rAmbientTransform;
            }
        }
        if (checkbox != checkbox2) {
            this.m_gTransform.setSelectedCheckbox(checkbox2);
        }
        this.m_cLocal.setEnabled(n != 2);
        this.m_cAmbient.setEnabled(n == 2);
        this.m_lAmbient.setEnabled(n == 2);
        this.m_cProj.setEnabled(n == 2);
        this.m_lProj.setEnabled(n == 2);
    }

    private void setAmbientSpace(int n) {
        int n2;
        if (n != this.m_spaceMode) {
            this.m_cAmbient.removeAll();
            this.m_cProj.removeAll();
            for (n2 = 0; n2 < PgGeometryIf.AMBIENT_SPACES[n].length; ++n2) {
                this.m_cAmbient.add(PgGeometryIf.AMBIENT_SPACES[n][n2]);
            }
            switch (n) {
                case 0: 
                case 1: 
                case 3: 
                case 6: 
                case 9: {
                    this.m_cAmbient.select(0);
                    break;
                }
                case 2: 
                case 4: 
                case 7: 
                case 10: {
                    this.m_cAmbient.select(1);
                    break;
                }
                case 5: 
                case 8: 
                case 11: {
                    this.m_cAmbient.select(2);
                }
            }
            this.m_spaceMode = n;
        }
        if (this.m_cProj.getItemCount() == 0) {
            for (n2 = 0; n2 < PgGeometryIf.AMBIENT_PROJECTIONS[n].length; ++n2) {
                this.m_cProj.add(PgGeometryIf.AMBIENT_PROJECTIONS[n][n2]);
            }
        }
        n2 = this.m_disp.getAmbientProjection();
        if (this.m_cProj.getSelectedIndex() != n2) {
            if (this.m_cProj.getItemCount() > n2) {
                this.m_cProj.select(n2);
            } else {
                PsDebug.warning("ambient projection not updated");
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

