/*
 * Decompiled with CFR 0.152.
 */
package jv.vecmath;

import jv.object.PsDebug;
import jv.vecmath.P_Vector;
import jv.vecmath.PdMatrix;
import jv.vecmath.PuData;
import jv.vecmath.PuMath;

public class PiVector
extends P_Vector
implements Cloneable {
    public int[] m_data;

    public Object clone() {
        PiVector piVector = null;
        piVector = (PiVector)super.clone();
        if (piVector == null) {
            return null;
        }
        if (this.m_data != null) {
            piVector.m_data = (int[])this.m_data.clone();
        }
        return piVector;
    }

    public static int[][] getEntries(PiVector[] piVectorArray) {
        if (piVectorArray == null) {
            return null;
        }
        int n = piVectorArray.length;
        int[][] nArrayArray = new int[n][];
        for (int i = 0; i < n; ++i) {
            nArrayArray[i] = piVectorArray[i].getEntries();
        }
        return nArrayArray;
    }

    public static PiVector[][] alloc(int n, int n2, int n3) {
        PiVector[][] piVectorArray = new PiVector[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                piVectorArray[i][j] = new PiVector(n3);
            }
        }
        return piVectorArray;
    }

    public static final PiVector[] realloc(PiVector[] piVectorArray, int n, int n2) {
        int n3;
        int n4;
        if (piVectorArray != null && piVectorArray.length == n) {
            for (int i = 0; i < piVectorArray.length; ++i) {
                if (piVectorArray[i] == null) {
                    piVectorArray[i] = new PiVector(n2);
                    continue;
                }
                if (piVectorArray[i].m_data != null && piVectorArray[i].m_data.length == n2) continue;
                piVectorArray[i].setSize(n2);
            }
            return piVectorArray;
        }
        PiVector[] piVectorArray2 = new PiVector[n];
        if (piVectorArray == null) {
            n4 = 0;
        } else {
            n4 = Math.min(piVectorArray.length, n);
            System.arraycopy(piVectorArray, 0, piVectorArray2, 0, n4);
        }
        for (n3 = 0; n3 < n4; ++n3) {
            if (piVectorArray2[n3] == null) {
                piVectorArray2[n3] = new PiVector(n2);
                continue;
            }
            if (piVectorArray2[n3].m_data != null && piVectorArray2[n3].m_data.length == n2) continue;
            piVectorArray2[n3].setSize(n2);
        }
        for (n3 = n4; n3 < n; ++n3) {
            piVectorArray2[n3] = new PiVector(n2);
        }
        return piVectorArray2;
    }

    public static final PiVector[] realloc(PiVector[] piVectorArray, int n) {
        int n2;
        int n3;
        if (piVectorArray != null && piVectorArray.length == n) {
            for (int i = 0; i < piVectorArray.length; ++i) {
                if (piVectorArray[i] != null) continue;
                piVectorArray[i] = new PiVector(0);
            }
            return piVectorArray;
        }
        PiVector[] piVectorArray2 = new PiVector[n];
        if (piVectorArray == null) {
            n3 = 0;
        } else {
            n3 = Math.min(piVectorArray.length, n);
            System.arraycopy(piVectorArray, 0, piVectorArray2, 0, n3);
            for (n2 = 0; n2 < n3; ++n2) {
                if (piVectorArray2[n2] != null) continue;
                piVectorArray2[n2] = new PiVector(0);
            }
        }
        for (n2 = n3; n2 < n; ++n2) {
            piVectorArray2[n2] = new PiVector(0);
        }
        return piVectorArray2;
    }

    public static PiVector[] copyNew(int[][] nArray) {
        if (nArray == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        int n = nArray.length;
        PiVector[] piVectorArray = new PiVector[n];
        for (int i = 0; i < n; ++i) {
            piVectorArray[i] = new PiVector(nArray[i]);
        }
        return piVectorArray;
    }

    public static PiVector[] copyNew(PiVector[] piVectorArray) {
        if (piVectorArray == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        return PiVector.copyNew(piVectorArray, piVectorArray.length);
    }

    public static PiVector[] copyNew(PiVector[] piVectorArray, int n) {
        if (piVectorArray == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        PiVector[] piVectorArray2 = new PiVector[n];
        for (int i = 0; i < n; ++i) {
            piVectorArray2[i] = PiVector.copyNew(piVectorArray[i]);
        }
        return piVectorArray2;
    }

    public static boolean copy(PiVector[] piVectorArray, int n, PiVector[] piVectorArray2, int n2, int n3) {
        if (n3 == 0) {
            return true;
        }
        if (piVectorArray == null || piVectorArray.length < n + n3) {
            PsDebug.warning("missing space in dataDest", piVectorArray);
            return false;
        }
        if (piVectorArray2 == null || piVectorArray2.length < n2 + n3) {
            PsDebug.warning("missing space in dataSrc", piVectorArray2);
            return false;
        }
        for (int i = 0; i < n3; ++i) {
            piVectorArray[n + i].copy(piVectorArray2[n2 + i]);
        }
        return true;
    }

    public static boolean adjustSizes(PiVector[] piVectorArray, int n, PiVector[] piVectorArray2, int n2, int n3) {
        if (n3 == 0) {
            return true;
        }
        if (piVectorArray == null || piVectorArray.length < n + n3) {
            PsDebug.warning("missing space in dataDest", piVectorArray2);
            return false;
        }
        for (int i = 0; i < n3; ++i) {
            piVectorArray[n + i].setSize(piVectorArray2[n2 + i].getSize());
        }
        return true;
    }

    public static int getSameSize(PiVector[] piVectorArray, int n) {
        if (piVectorArray == null || piVectorArray.length == 0) {
            return -1;
        }
        if (piVectorArray[0] == null) {
            return -1;
        }
        if (piVectorArray.length < n) {
            PsDebug.warning("used vectors larger than array size.");
            n = piVectorArray.length;
        }
        int n2 = piVectorArray[0].getSize();
        for (int i = 1; i < n; ++i) {
            if (n2 == piVectorArray[i].getSize()) continue;
            n2 = -1;
            break;
        }
        return n2;
    }

    public static final boolean min(PiVector piVector, PiVector[] piVectorArray, int n) {
        if (piVectorArray == null || piVectorArray.length == 0 || piVectorArray.length < n || piVectorArray[0] == null) {
            PsDebug.warning("null pointer argument or array too small");
            return false;
        }
        if (piVector == null || piVector.m_data == null) {
            PsDebug.warning("missing min argument");
            return false;
        }
        piVector.setConstant(Integer.MAX_VALUE);
        for (int i = 0; i < n; ++i) {
            for (int j = Math.min(piVector.m_data.length, piVectorArray[i].m_data.length) - 1; j >= 0; --j) {
                if (piVector.m_data[j] <= piVectorArray[i].m_data[j]) continue;
                piVector.m_data[j] = piVectorArray[i].m_data[j];
            }
        }
        return true;
    }

    public static final boolean max(PiVector piVector, PiVector[] piVectorArray, int n) {
        if (piVectorArray == null || piVectorArray.length == 0 || piVectorArray.length < n || piVectorArray[0] == null) {
            PsDebug.warning("null pointer argument or array too small");
            return false;
        }
        if (piVector == null || piVector.m_data == null) {
            PsDebug.warning("missing max argument");
            return false;
        }
        piVector.setConstant(Integer.MIN_VALUE);
        for (int i = 0; i < n; ++i) {
            for (int j = Math.min(piVector.m_data.length, piVectorArray[i].m_data.length) - 1; j >= 0; --j) {
                if (piVector.m_data[j] >= piVectorArray[i].m_data[j]) continue;
                piVector.m_data[j] = piVectorArray[i].m_data[j];
            }
        }
        return true;
    }

    public static void setConstant(PiVector[] piVectorArray, int n) {
        if (piVectorArray == null || piVectorArray.length == 0 || piVectorArray[0] == null) {
            return;
        }
        for (int i = 0; i < piVectorArray.length; ++i) {
            piVectorArray[i].setConstant(n);
        }
    }

    public static void setConstant(PiVector[] piVectorArray, int[] nArray) {
        if (piVectorArray == null || piVectorArray.length == 0 || piVectorArray[0] == null) {
            return;
        }
        int n = piVectorArray[0].m_data.length;
        if (n != nArray.length) {
            PsDebug.warning("arrays have different length");
            return;
        }
        for (int i = 0; i < piVectorArray.length; ++i) {
            for (int j = 0; j < n; ++j) {
                piVectorArray[i].m_data[j] = nArray[j];
            }
        }
    }

    public static void setConstant(PiVector[] piVectorArray, PiVector piVector) {
        if (piVector == null || piVector.m_data == null) {
            return;
        }
        PiVector.setConstant(piVectorArray, piVector.m_data);
    }

    public static void setConstant(PiVector piVector, int n) {
        if (piVector == null || piVector.m_data == null) {
            return;
        }
        for (int i = piVector.getSize() - 1; i >= 0; --i) {
            piVector.m_data[i] = n;
        }
    }

    public void setConstant(int n) {
        if (this.m_data == null || this.m_data.length == 0) {
            return;
        }
        for (int i = this.m_data.length - 1; i >= 0; --i) {
            this.m_data[i] = n;
        }
    }

    public PiVector() {
        this(0);
    }

    public PiVector(int n) {
        this.m_data = new int[n];
    }

    public PiVector(int n, int n2) {
        this(2);
        this.m_data[0] = n;
        this.m_data[1] = n2;
    }

    public PiVector(int n, int n2, int n3) {
        this(3);
        this.m_data[0] = n;
        this.m_data[1] = n2;
        this.m_data[2] = n3;
    }

    public PiVector(int n, int n2, int n3, int n4) {
        this(4);
        this.m_data[0] = n;
        this.m_data[1] = n2;
        this.m_data[2] = n3;
        this.m_data[3] = n4;
    }

    public PiVector(int[] nArray) {
        this();
        this.set(nArray);
    }

    public int getSize() {
        if (this.m_data == null) {
            return 0;
        }
        return this.m_data.length;
    }

    public int setSize(int n) {
        if (this.m_data == null) {
            this.m_data = new int[n];
        } else if (this.m_data.length != n) {
            this.m_data = PuData.realloc(this.m_data, n);
        }
        return n;
    }

    public int[] getEntries() {
        return (int[])this.m_data.clone();
    }

    public int getEntry(int n) {
        if (n < 0 || this.m_data.length <= n) {
            PsDebug.warning("index out of range, index=" + n);
            return 0;
        }
        return this.m_data[n];
    }

    public void setEntry(int n, int n2) {
        if (this.m_data == null || this.m_data.length <= n || n < 0) {
            this.setSize(n + 1);
        }
        this.m_data[n] = n2;
    }

    public int getFirstEntry() {
        if (this.m_data == null || this.m_data.length == 0) {
            PsDebug.warning("empty vector.");
            return 0;
        }
        return this.m_data[0];
    }

    public void setFirstEntry(int n) {
        if (this.m_data == null || this.m_data.length == 0) {
            PsDebug.warning("empty vector.");
            return;
        }
        this.m_data[0] = n;
    }

    public int getLastEntry() {
        if (this.m_data == null || this.m_data.length == 0) {
            PsDebug.warning("empty vector.");
            return 0;
        }
        return this.m_data[this.m_data.length - 1];
    }

    public void setLastEntry(int n) {
        if (this.m_data == null || this.m_data.length == 0) {
            PsDebug.warning("empty vector.");
            return;
        }
        this.m_data[this.m_data.length - 1] = n;
    }

    public int addEntry(int n) {
        int n2 = this.getSize() + 1;
        this.setSize(n2);
        this.m_data[n2 - 1] = n;
        return n2;
    }

    public void removeEntry(int n) {
        int n2 = this.getSize();
        if (n < 0 || n >= n2) {
            PsDebug.warning("Index out of range. Cannot delete vector index " + n);
            return;
        }
        for (int i = n + 1; i < n2; ++i) {
            this.m_data[i - 1] = this.m_data[i];
        }
        this.setSize(n2 - 1);
    }

    public void concat(PiVector piVector) {
        int n = this.getSize();
        int n2 = piVector.getSize();
        this.setSize(n + n2);
        this.copy(n, piVector, 0, n2);
    }

    public static PiVector concatNew(PiVector piVector, PiVector piVector2) {
        int n = piVector.getSize();
        int n2 = piVector2.getSize();
        PiVector piVector3 = new PiVector(n + n2);
        piVector3.copy(piVector);
        piVector3.copy(n, piVector2, 0, n2);
        return piVector3;
    }

    public void set(PiVector piVector, int n, int n2) {
        if (piVector == null || piVector.getSize() < n + n2) {
            PsDebug.warning("argument array too small.");
            return;
        }
        if (this.m_data == null || this.m_data.length != n2) {
            this.setSize(n2);
        }
        for (int i = 0; i < n2; ++i) {
            this.m_data[i] = piVector.m_data[n + i];
        }
    }

    public void set(int[] nArray, int n, int n2) {
        if (nArray == null || nArray.length < n + n2) {
            PsDebug.warning("argument array too small.");
            return;
        }
        if (this.m_data == null || this.m_data.length != n2) {
            this.setSize(n2);
        }
        for (int i = 0; i < n2; ++i) {
            this.m_data[i] = nArray[n + i];
        }
    }

    public void set(int[] nArray, int n) {
        this.set(nArray, 0, n);
    }

    public void set(int[] nArray) {
        if (nArray == null) {
            PsDebug.warning("missing argument array.");
            return;
        }
        this.set(nArray, 0, nArray.length);
    }

    public void set(int n) {
        if (this.m_data == null || this.m_data.length < 1) {
            this.setSize(1);
        }
        this.m_data[0] = n;
    }

    public void set(int n, int n2) {
        if (this.m_data == null || this.m_data.length < 2) {
            this.setSize(2);
        }
        this.m_data[0] = n;
        this.m_data[1] = n2;
    }

    public void set(int n, int n2, int n3) {
        if (this.m_data == null || this.m_data.length < 3) {
            this.setSize(3);
        }
        this.m_data[0] = n;
        this.m_data[1] = n2;
        this.m_data[2] = n3;
    }

    public void set(int n, int n2, int n3, int n4) {
        if (this.m_data == null || this.m_data.length < 4) {
            this.setSize(4);
        }
        this.m_data[0] = n;
        this.m_data[1] = n2;
        this.m_data[2] = n3;
        this.m_data[3] = n4;
    }

    public int getIndexOf(int n) {
        for (int i = 0; i < this.m_data.length; ++i) {
            if (this.m_data[i] != n) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(int n) {
        return this.getIndexOf(n) != -1;
    }

    public int changeValue(int n, int n2, int n3) {
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            if (this.m_data[i] != n2) continue;
            this.m_data[i] = n3;
            ++n4;
        }
        return n4;
    }

    public int changeValue(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < this.m_data.length; ++i) {
            if (this.m_data[i] != n) continue;
            this.m_data[i] = n2;
            ++n3;
        }
        return n3;
    }

    public void shift(int n) {
        int n2 = this.m_data.length;
        if (n2 < 2) {
            return;
        }
        if (n > n2 - 1) {
            n %= n2;
        } else if (n < 1 - n2) {
            n = -(Math.abs(n) % n2);
        }
        if (n == 0) {
            return;
        }
        if (n > n2 / 2) {
            n -= n2;
        } else if (n < -n2 / 2) {
            n += n2;
        }
        if (n > 0) {
            int n3;
            int[] nArray = new int[n];
            for (n3 = 0; n3 < n; ++n3) {
                nArray[n3] = this.m_data[n2 - n + n3];
            }
            for (n3 = n2 - 1; n3 > n - 1; --n3) {
                this.m_data[n3] = this.m_data[n3 - n];
            }
            for (n3 = n - 1; n3 > -1; --n3) {
                this.m_data[n3] = nArray[n3];
            }
        } else {
            int n4;
            int[] nArray = new int[-n];
            for (n4 = 0; n4 < -n; ++n4) {
                nArray[n4] = this.m_data[n4];
            }
            for (n4 = 0; n4 < n2 + n; ++n4) {
                this.m_data[n4] = this.m_data[n4 - n];
            }
            for (n4 = 0; n4 < -n; ++n4) {
                this.m_data[n2 + n + n4] = nArray[n4];
            }
        }
    }

    public PiVector invert(int n) {
        int n2 = n / 2;
        for (int i = 0; i < n2; ++i) {
            int n3 = this.m_data[i];
            this.m_data[i] = this.m_data[n - 1 - i];
            this.m_data[n - 1 - i] = n3;
        }
        return this;
    }

    public PiVector invert() {
        int n = this.m_data.length / 2;
        for (int i = 0; i < n; ++i) {
            int n2 = this.m_data[i];
            this.m_data[i] = this.m_data[this.m_data.length - 1 - i];
            this.m_data[this.m_data.length - 1 - i] = n2;
        }
        return this;
    }

    public void add(int n) {
        if (this.m_data == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.m_data.length) {
            int n3 = n2++;
            this.m_data[n3] = this.m_data[n3] + n;
        }
    }

    public void add(PiVector piVector) {
        if (this.m_data == null) {
            this.setSize(piVector.m_data.length);
        }
        if (this.m_data.length != piVector.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        for (int i = 0; i < this.m_data.length; ++i) {
            int n = i;
            this.m_data[n] = this.m_data[n] + piVector.m_data[i];
        }
    }

    public void add(int n, PiVector piVector) {
        if (piVector == null) {
            PsDebug.warning("missing argument");
            return;
        }
        if (this.m_data == null || this.m_data.length == 0) {
            this.setSize(piVector.m_data.length);
        }
        if (this.m_data.length != piVector.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        for (int i = 0; i < this.m_data.length; ++i) {
            int n2 = i;
            this.m_data[n2] = this.m_data[n2] + n * piVector.m_data[i];
        }
    }

    public void add(PiVector piVector, PiVector piVector2) {
        if (this.m_data == null) {
            this.setSize(piVector.m_data.length);
        }
        if (this.m_data.length != piVector.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        for (int i = 0; i < this.m_data.length; ++i) {
            this.m_data[i] = piVector.m_data[i] + piVector2.m_data[i];
        }
    }

    public void sub(PiVector piVector) {
        if (this.m_data == null) {
            this.setSize(piVector.m_data.length);
        }
        if (this.m_data.length != piVector.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        for (int i = 0; i < this.m_data.length; ++i) {
            int n = i;
            this.m_data[n] = this.m_data[n] - piVector.m_data[i];
        }
    }

    public void sub(PiVector piVector, PiVector piVector2) {
        if (this.m_data == null) {
            this.setSize(piVector.m_data.length);
        }
        if (this.m_data.length != piVector.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        for (int i = 0; i < this.m_data.length; ++i) {
            this.m_data[i] = piVector.m_data[i] - piVector2.m_data[i];
        }
    }

    public static PiVector subNew(PiVector piVector, PiVector piVector2) {
        int n;
        if (piVector == null || piVector2 == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        int n2 = piVector.getSize();
        if (n2 != (n = piVector2.getSize())) {
            PsDebug.warning("different size of argument vectors");
            n2 = Math.min(n2, n);
        }
        PiVector piVector3 = new PiVector(n2);
        piVector3.sub(piVector, piVector2);
        return piVector3;
    }

    public static PiVector copyNew(PiVector piVector) {
        if (piVector == null) {
            return null;
        }
        if (piVector.m_data == null) {
            PsDebug.warning("missing data of argument vector.");
            return null;
        }
        PiVector piVector2 = new PiVector(piVector.m_data.length);
        piVector2.copy(piVector);
        return piVector2;
    }

    public boolean copy(int n, PiVector piVector, int n2, int n3) {
        if (this.m_data.length < n + n3) {
            PsDebug.warning("missing space in this", this);
            return false;
        }
        if (this.m_data == null || this.m_data.length < n + n3) {
            this.setSize(n + n3);
        }
        System.arraycopy(piVector.m_data, n2, this.m_data, n, n3);
        return true;
    }

    public void copy(PiVector piVector) {
        if (piVector == null) {
            PsDebug.warning("missing argument vector");
            return;
        }
        if (piVector.m_data == null) {
            PsDebug.warning("missing data of argument vector");
            return;
        }
        this.copyArray(piVector);
        super.copy(piVector);
    }

    public void copyArray(PiVector piVector) {
        if (piVector == null) {
            PsDebug.warning("missing argument vector");
            return;
        }
        if (piVector.m_data == null) {
            PsDebug.warning("missing data of argument vector");
            return;
        }
        int n = piVector.m_data.length;
        if (this.m_data == null || this.m_data.length == 0) {
            this.setSize(n);
        }
        if (this.m_data.length > n) {
            for (int i = n; i < this.m_data.length; ++i) {
                this.m_data[i] = 0;
            }
        } else {
            n = this.m_data.length;
        }
        switch (n) {
            case 4: {
                if (this.m_data[3] != piVector.m_data[3]) {
                    this.m_data[3] = piVector.m_data[3];
                }
            }
            case 3: {
                if (this.m_data[2] != piVector.m_data[2]) {
                    this.m_data[2] = piVector.m_data[2];
                }
            }
            case 2: {
                if (this.m_data[1] != piVector.m_data[1]) {
                    this.m_data[1] = piVector.m_data[1];
                }
            }
            case 1: {
                if (this.m_data[0] == piVector.m_data[0]) break;
                this.m_data[0] = piVector.m_data[0];
                break;
            }
            default: {
                System.arraycopy(piVector.m_data, 0, this.m_data, 0, n);
            }
        }
    }

    public void copy(int[] nArray, int n) {
        if (nArray == null) {
            PsDebug.warning("null vector 'm' passed");
            return;
        }
        if (this.m_data == null || this.m_data.length == 0) {
            this.setSize(n);
        }
        int n2 = Math.min(this.m_data.length, n);
        System.arraycopy(nArray, 0, this.m_data, 0, n2);
        for (int i = n2; i < this.m_data.length; ++i) {
            this.m_data[i] = 0;
        }
    }

    public void multScalar(int n) {
        int n2 = 0;
        while (n2 < this.m_data.length) {
            int n3 = n2++;
            this.m_data[n3] = this.m_data[n3] * n;
        }
    }

    public void multScalar(PiVector piVector, int n) {
        for (int i = 0; i < this.m_data.length; ++i) {
            this.m_data[i] = piVector.m_data[i] * n;
        }
    }

    public void leftMultMatrix(PdMatrix pdMatrix) {
        if (pdMatrix == null) {
            PsDebug.warning("missing argument");
            return;
        }
        if (pdMatrix.m_iSize != pdMatrix.m_jSize || pdMatrix.m_iSize != this.m_data.length) {
            PsDebug.warning("argument not square or incompatible sizes");
            return;
        }
        int n = this.m_data.length;
        int[] nArray = (int[])this.m_data.clone();
        for (int i = 0; i < n; ++i) {
            this.m_data[i] = 0;
            for (int j = 0; j < n; ++j) {
                int n2 = i;
                this.m_data[n2] = (int)((double)this.m_data[n2] + pdMatrix.m_data[i][j] * (double)nArray[j]);
            }
        }
    }

    public void leftMultMatrix(PdMatrix pdMatrix, PiVector piVector) {
        if (this == piVector) {
            PsDebug.warning("'this' must be different from argument");
            return;
        }
        if (this.m_data.length != pdMatrix.m_iSize) {
            this.setSize(pdMatrix.m_iSize);
        }
        for (int i = 0; i < this.m_data.length; ++i) {
            this.m_data[i] = 0;
            for (int j = 0; j < this.m_data.length; ++j) {
                int n = i;
                this.m_data[n] = (int)((double)this.m_data[n] + pdMatrix.m_data[i][j] * (double)piVector.m_data[j]);
            }
        }
    }

    public void rightMultMatrix(PdMatrix pdMatrix) {
        if (pdMatrix == null) {
            PsDebug.warning("missing argument");
            return;
        }
        if (pdMatrix.m_iSize != pdMatrix.m_jSize || pdMatrix.m_iSize != this.m_data.length) {
            PsDebug.warning("argument not square or incompatible sizes");
            return;
        }
        int n = this.m_data.length;
        int[] nArray = (int[])this.m_data.clone();
        for (int i = 0; i < n; ++i) {
            this.m_data[i] = 0;
            for (int j = 0; j < n; ++j) {
                int n2 = i;
                this.m_data[n2] = (int)((double)this.m_data[n2] + (double)nArray[j] * pdMatrix.m_data[j][i]);
            }
        }
    }

    public void rightMultMatrix(PiVector piVector, PdMatrix pdMatrix) {
        if (this == piVector) {
            PsDebug.warning("'this' must be different from argument");
            return;
        }
        if (this.m_data.length != pdMatrix.m_jSize) {
            this.setSize(pdMatrix.m_jSize);
        }
        for (int i = 0; i < pdMatrix.m_jSize; ++i) {
            this.m_data[i] = 0;
            for (int j = 0; j < pdMatrix.m_iSize; ++j) {
                int n = i;
                this.m_data[n] = (int)((double)this.m_data[n] + (double)piVector.m_data[j] * pdMatrix.m_data[j][i]);
            }
        }
    }

    public static int dot(PiVector piVector, PiVector piVector2) {
        int n = 0;
        for (int i = 0; i < piVector.m_data.length; ++i) {
            n += piVector.m_data[i] * piVector2.m_data[i];
        }
        return n;
    }

    public int dot(PiVector piVector) {
        int n = 0;
        for (int i = 0; i < this.m_data.length; ++i) {
            n += this.m_data[i] * piVector.m_data[i];
        }
        return n;
    }

    public int sqrLength() {
        int n = 0;
        for (int i = 0; i < this.m_data.length; ++i) {
            n += this.m_data[i] * this.m_data[i];
        }
        return n;
    }

    public int length() {
        return (int)this.getLength();
    }

    public double getLength() {
        double d = 0.0;
        for (int i = 0; i < this.m_data.length; ++i) {
            d += (double)((long)this.m_data[i] * (long)this.m_data[i]);
        }
        return Math.sqrt(d);
    }

    public boolean normalize() {
        int n = this.length();
        if (n == 0) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.m_data.length) {
            int n3 = n2++;
            this.m_data[n3] = this.m_data[n3] / n;
        }
        return true;
    }

    public void normalize(PiVector piVector) {
        int n = piVector.length();
        if (n == 0) {
            this.copyArray(piVector);
            return;
        }
        for (int i = 0; i < this.m_data.length; ++i) {
            this.m_data[i] = piVector.m_data[i] / n;
        }
    }

    public void setLength(int n) {
        int n2 = this.length();
        if (n2 == 0) {
            return;
        }
        n2 /= n;
        int n3 = 0;
        while (n3 < this.m_data.length) {
            int n4 = n3++;
            this.m_data[n4] = this.m_data[n4] / n2;
        }
    }

    public static PiVector blendNew(int n, PiVector piVector, int n2, PiVector piVector2) {
        PiVector piVector3 = new PiVector(piVector.getSize());
        piVector3.blend(n, piVector, n2, piVector2);
        return piVector3;
    }

    public void blend(int n, PiVector piVector, int n2, PiVector piVector2) {
        if (piVector == null || piVector2 == null) {
            PsDebug.warning("missing argument vector");
            return;
        }
        if (this.m_data == null || this.m_data.length == 0) {
            this.setSize(piVector.m_data.length);
        }
        if (this.m_data.length != piVector.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        for (int i = 0; i < this.m_data.length; ++i) {
            this.m_data[i] = n * piVector.m_data[i] + n2 * piVector2.m_data[i];
        }
    }

    public void blendBase(PiVector piVector, int n, PiVector piVector2) {
        if (piVector == null || piVector2 == null) {
            PsDebug.warning("missing argument vector");
            return;
        }
        if (this.m_data == null || this.m_data.length == 0) {
            this.setSize(piVector.m_data.length);
        }
        if (this.m_data.length != piVector.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        for (int i = 0; i < this.m_data.length; ++i) {
            this.m_data[i] = piVector.m_data[i] + n * piVector2.m_data[i];
        }
    }

    public void blend(double d, PiVector piVector, double d2, PiVector piVector2) {
        if (piVector == null || piVector2 == null) {
            PsDebug.warning("missing argument vector");
            return;
        }
        if (this.m_data == null || this.m_data.length == 0) {
            this.setSize(piVector.m_data.length);
        }
        if (this.m_data.length != piVector.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        for (int i = 0; i < this.m_data.length; ++i) {
            this.m_data[i] = (int)(d * (double)piVector.m_data[i] + d2 * (double)piVector2.m_data[i]);
        }
    }

    public int dist(PiVector piVector) {
        int n = 0;
        for (int i = 0; i < this.m_data.length; ++i) {
            int n2 = this.m_data[i] - piVector.m_data[i];
            n += n2 * n2;
        }
        return (int)Math.sqrt(n);
    }

    public int sqrDist(PiVector piVector) {
        int n = 0;
        for (int i = 0; i < this.m_data.length; ++i) {
            int n2 = this.m_data[i] - piVector.m_data[i];
            n += n2 * n2;
        }
        return n;
    }

    public int max() {
        int n = -2147483647;
        for (int i = 0; i < this.m_data.length; ++i) {
            if (this.m_data[i] <= n) continue;
            n = this.m_data[i];
        }
        return n;
    }

    public double maxAbs() {
        double d = -2.147483647E9;
        for (int i = 0; i < this.m_data.length; ++i) {
            int n = Math.abs(this.m_data[i]);
            if (!((double)n > d)) continue;
            d = n;
        }
        return d;
    }

    public int min() {
        int n = Integer.MAX_VALUE;
        for (int i = 0; i < this.m_data.length; ++i) {
            if (this.m_data[i] >= n) continue;
            n = this.m_data[i];
        }
        return n;
    }

    public int indexOfAbsMax() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.m_data.length; ++i) {
            int n3 = Math.abs(this.m_data[i]);
            if (n3 <= n2) continue;
            n2 = n3;
            n = i;
        }
        return n;
    }

    public int indexOfAbsMin() {
        int n = 0;
        int n2 = Integer.MAX_VALUE;
        for (int i = 0; i < this.m_data.length; ++i) {
            int n3 = Math.abs(this.m_data[i]);
            if (n3 >= n2) continue;
            n2 = n3;
            n = i;
        }
        return n;
    }

    public int indexOfMax() {
        int n = 0;
        int n2 = Integer.MIN_VALUE;
        for (int i = 0; i < this.m_data.length; ++i) {
            if (this.m_data[i] <= n2) continue;
            n2 = this.m_data[i];
            n = i;
        }
        return n;
    }

    public int indexOfMin() {
        int n = 0;
        int n2 = Integer.MAX_VALUE;
        for (int i = 0; i < this.m_data.length; ++i) {
            if (this.m_data[i] >= n2) continue;
            n2 = this.m_data[i];
            n = i;
        }
        return n;
    }

    public int indexOfValueInOrdering(int n) {
        int n2 = this.m_data.length;
        if (n2 == 0 || n < this.m_data[0]) {
            return -1;
        }
        int n3 = n2 - 1;
        if (n > this.m_data[n3]) {
            return n3;
        }
        int n4 = 0;
        while (n3 - n4 > 1) {
            int n5 = n4 + (n3 - n4) / 2;
            if (n > this.m_data[n5]) {
                n4 = n5;
                continue;
            }
            n3 = n5;
        }
        if (this.m_data[n4] >= n) {
            n3 = n4;
        }
        return n3;
    }

    public int sum() {
        int n = this.getSize();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += this.m_data[i];
        }
        return n2;
    }

    public double average() {
        double d = this.sum();
        if (d == 0.0) {
            return 0.0;
        }
        return d / (double)this.getSize();
    }

    public boolean hasUniqueEntries() {
        if (this.m_data == null) {
            return true;
        }
        int n = this.getSize();
        if (n <= 1) {
            return true;
        }
        PiVector piVector = (PiVector)this.clone();
        piVector.sort();
        for (int i = 1; i < n; ++i) {
            if (piVector.m_data[i - 1] != piVector.m_data[i]) continue;
            return false;
        }
        return true;
    }

    public void sort(PiVector piVector) {
        int n = this.getSize();
        if (piVector == null || piVector.m_data == null) {
            piVector = new PiVector(n);
        }
        if (piVector.getSize() != n) {
            piVector.setSize(n);
        }
        if (n < 10) {
            int n2;
            int[] nArray = piVector.m_data;
            for (n2 = 0; n2 < n; ++n2) {
                nArray[n2] = this.m_data[n2];
            }
            for (int i = n - 1; i > 0; --i) {
                for (int j = 0; j < i; ++j) {
                    if (nArray[j] <= nArray[j + 1]) continue;
                    n2 = nArray[j + 1];
                    nArray[j + 1] = nArray[j];
                    nArray[j] = n2;
                }
            }
        } else {
            int[] nArray = new int[n];
            PuMath.heapsort(n, this.m_data, nArray);
            for (int i = 0; i < n; ++i) {
                piVector.m_data[i] = this.m_data[nArray[i]];
            }
        }
    }

    public void sort() {
        int n = this.getSize();
        if (n < 10) {
            for (int i = n - 1; i > 0; --i) {
                for (int j = 0; j < i; ++j) {
                    if (this.m_data[j] <= this.m_data[j + 1]) continue;
                    int n2 = this.m_data[j + 1];
                    this.m_data[j + 1] = this.m_data[j];
                    this.m_data[j] = n2;
                }
            }
        } else {
            int n3;
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            for (n3 = 0; n3 < n; ++n3) {
                nArray2[n3] = this.m_data[n3];
            }
            PuMath.heapsort(n, nArray2, nArray);
            for (n3 = 0; n3 < n; ++n3) {
                this.m_data[n3] = nArray2[nArray[n3]];
            }
        }
    }

    public boolean equals(Object object) {
        if (object instanceof PiVector) {
            return this.equals((PiVector)object);
        }
        if (object instanceof int[]) {
            return this.equals((int[])object);
        }
        return super.equals(object);
    }

    public boolean equals(int[] nArray) {
        int n = this.getSize();
        if (nArray == null && n == 0) {
            return true;
        }
        if (nArray == null) {
            return false;
        }
        if (n != nArray.length) {
            return false;
        }
        --n;
        while (n >= 0) {
            if (this.m_data[n] != nArray[n]) {
                return false;
            }
            --n;
        }
        return true;
    }

    public boolean equals(PiVector piVector) {
        if (piVector == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        return this.equals(piVector.m_data);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString() + "\n");
        stringBuffer.append("\t ******* PiVector ***********\n");
        int n = this.getSize();
        stringBuffer.append("\t size\t = " + n + "\n");
        if (n > 0) {
            stringBuffer.append("\t m_data = (" + String.valueOf(this.m_data[0]));
            for (int i = 1; i < n; ++i) {
                stringBuffer.append(", " + String.valueOf(this.m_data[i]));
            }
            stringBuffer.append(")\n");
        } else if (this.m_data != null) {
            stringBuffer.append("\t m_data = {}\n");
        } else {
            stringBuffer.append("\t m_data = null\n");
        }
        return stringBuffer.toString();
    }

    public String toShortString() {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = this.getSize();
        if (n > 0) {
            stringBuffer.append("\t {" + String.valueOf(this.m_data[0]));
            for (int i = 1; i < n; ++i) {
                stringBuffer.append(", " + String.valueOf(this.m_data[i]));
            }
            stringBuffer.append("},");
        } else if (this.m_data != null) {
            stringBuffer.append("\t m_data = {},");
        } else {
            stringBuffer.append("\t m_data = null,");
        }
        stringBuffer.append("\t Attr = (" + this.getBits() + ")\n");
        return stringBuffer.toString();
    }

    public void removeSuccessiveDuplicates() {
        int n = this.getSize();
        int n2 = 1;
        for (int i = 1; i < n; ++i) {
            if (this.m_data[i] == this.m_data[i - 1]) continue;
            this.m_data[n2] = this.m_data[i];
            ++n2;
        }
        this.setSize(n2);
    }
}

