/*
 * Decompiled with CFR 0.152.
 */
package jv.objectGui;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import jv.object.PsActionSupport;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.objectGui.PsToolbar;

public final class PsToolbarItem
extends PsPanel
implements ActionListener,
MouseListener {
    protected static int m_defBorderType = 0;
    protected int m_actionType;
    protected boolean m_bSingleChoice = true;
    protected PopupMenu m_popup;
    protected MenuItem[] m_menuItem;
    protected Vector m_actionCommand;
    protected String m_actionString;
    private PsActionSupport m_actionSupport;

    public PsToolbarItem() {
        this(2);
    }

    public PsToolbarItem(int n) {
        this.m_actionType = n;
        this.m_actionCommand = new Vector();
        this.init();
    }

    public void init() {
        int n = 16;
        Image image = PsToolbar.getImage(this, this.m_actionType);
        if (image == null) {
            m_defBorderType = 1;
            this.setBorderType(m_defBorderType);
        } else {
            this.setImage(image);
        }
        int n2 = 3;
        this.setPreferredSize(n + 2 * n2, n + 2 * n2);
        this.setInsetSize(n2);
        this.addMouseListener(this);
    }

    public void setChoice(String string) {
        this.m_actionCommand.removeAllElements();
        this.m_actionCommand.addElement(string);
        this.m_bSingleChoice = true;
        this.setActionString(string);
    }

    public void addChoice(String string) {
        this.m_actionCommand.addElement(string);
        this.m_bSingleChoice = false;
    }

    public void setActionString(String string) {
        this.m_actionString = string;
    }

    private void showPopup(int n, int n2) {
        if (this.m_actionCommand.isEmpty()) {
            PsDebug.warning("missing action command in toolbar item");
            return;
        }
        if (this.m_popup != null) {
            this.remove(this.m_popup);
            this.m_popup = null;
        }
        this.m_popup = new PopupMenu(PsConfig.getMessage(21184));
        int n3 = this.m_actionCommand.size();
        this.m_menuItem = new MenuItem[n3];
        for (int i = 0; i < n3; ++i) {
            this.m_menuItem[i] = new MenuItem((String)this.m_actionCommand.elementAt(i));
            this.m_menuItem[i].addActionListener(this);
            this.m_popup.add(this.m_menuItem[i]);
        }
        this.add(this.m_popup);
        this.m_popup.show(this, 10, 10);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.setBorderType(2);
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Dimension dimension = this.getSize();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (n >= 0 && n < dimension.width && n2 >= 0 && n2 < dimension.height) {
            this.setBorderType(1);
            if (this.m_bSingleChoice) {
                PsDebug.showStatus(this.m_actionString);
                this.fireAction(this.m_actionType, (String)this.m_actionCommand.elementAt(0));
            } else {
                this.showPopup(n, n2);
            }
        } else {
            PsDebug.popStatus();
            this.setBorderType(m_defBorderType);
        }
        this.repaint();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        PsDebug.pushStatus(this.m_actionString);
        this.setBorderType(1);
        this.repaint();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        PsDebug.popStatus();
        this.setBorderType(m_defBorderType);
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.m_menuItem == null) {
            return;
        }
        Object object = actionEvent.getSource();
        for (int i = 0; i < this.m_menuItem.length; ++i) {
            if (object != this.m_menuItem[i]) continue;
            this.fireAction(this.m_actionType, this.m_menuItem[i].getLabel());
            if (this.m_popup == null) break;
            this.remove(this.m_popup);
            this.m_popup = null;
            this.m_menuItem = null;
            break;
        }
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.m_actionSupport == null) {
            this.m_actionSupport = new PsActionSupport();
        }
        this.m_actionSupport.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        if (this.m_actionSupport != null) {
            this.removeActionListener(actionListener);
        }
    }

    protected void fireAction(int n, String string) {
        if (this.m_actionSupport != null) {
            this.m_actionSupport.fireAction(new ActionEvent(this, n, string));
        }
    }

    protected void fireAction(int n, String string, int n2) {
        if (this.m_actionSupport != null) {
            this.m_actionSupport.fireAction(new ActionEvent(this, n, string, n2));
        }
    }
}

