/*
 * Decompiled with CFR 0.152.
 */
package jv.number;

import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import jv.number.PuString;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.vecmath.PiVector;

public class PiVector_IP
extends PsPanel
implements ActionListener {
    protected PiVector m_vector;
    protected int m_length;
    protected Panel m_pVector;
    protected TextField[] m_text;
    static /* synthetic */ Class class$jv$number$PiVector_IP;

    public PiVector_IP() {
        if (this.getClass() == (class$jv$number$PiVector_IP == null ? (class$jv$number$PiVector_IP = PiVector_IP.class$("jv.number.PiVector_IP")) : class$jv$number$PiVector_IP)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.setLayout(new GridLayout(1, 2));
        this.m_lTitle = new Label();
        this.add(this.m_lTitle);
        this.m_pVector = new Panel();
        this.add(this.m_pVector);
    }

    public boolean update(Object object) {
        if (object == null) {
            PsDebug.warning("missing event");
            return false;
        }
        if (this.m_vector == null) {
            PsDebug.warning("missing vector");
            return false;
        }
        if (object == this.m_vector) {
            for (int i = 0; i < this.m_length; ++i) {
                PsPanel.setText(this.m_text[i], String.valueOf(this.m_vector.getEntry(i)));
            }
            return true;
        }
        return super.update(object);
    }

    public void setEnabled(boolean bl) {
        if (this.isEnabled() == bl) {
            return;
        }
        super.setEnabled(bl);
        PsPanel.setEnabled(this.m_lTitle, bl);
        for (int i = 0; i < this.m_length; ++i) {
            PsPanel.setEnabled(this.m_text[i], bl);
        }
    }

    protected boolean setLength(int n) {
        if (n == this.m_length) {
            return true;
        }
        if (n > 5) {
            PsDebug.warning("vector length=" + this.m_length + " too large");
            return false;
        }
        this.m_length = n;
        this.m_pVector.removeAll();
        if (this.m_text == null || this.m_text.length != this.m_length) {
            int n2;
            if (this.m_text != null) {
                for (n2 = 0; n2 < this.m_text.length; ++n2) {
                    this.m_text[n2].removeActionListener(this);
                }
            }
            this.m_pVector.setLayout(new GridLayout(1, this.m_length));
            this.m_text = new TextField[this.m_length];
            for (n2 = 0; n2 < this.m_length; ++n2) {
                this.m_text[n2] = new TextField();
                this.m_text[n2].addActionListener(this);
                this.m_pVector.add(this.m_text[n2]);
            }
            this.m_pVector.validate();
        }
        return true;
    }

    public boolean setVector(PiVector piVector) {
        if (piVector == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        if (!this.setLength(piVector.getSize())) {
            PsDebug.warning("invalid length");
            return false;
        }
        this.m_vector = piVector;
        this.update(this.m_vector);
        return true;
    }

    public PiVector getVector() {
        return this.m_vector;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.m_vector == null) {
            PsDebug.warning("missing vector, return");
            return;
        }
        Object object = actionEvent.getSource();
        for (int i = 0; i < this.m_length; ++i) {
            if (object != this.m_text[i]) continue;
            String string = this.m_text[i].getText();
            if (PuString.isEmpty(string)) {
                return;
            }
            try {
                this.m_vector.setEntry(i, Integer.parseInt(string));
                this.m_parent.update(this);
            }
            catch (NumberFormatException numberFormatException) {
                PsDebug.warning("wrong format = " + string);
                ((TextComponent)this.m_text[i]).setText(String.valueOf(this.m_vector.getEntry(i)));
                return;
            }
            return;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

