/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.geom.PgTexture;
import jv.loader.PgFileDialog;
import jv.number.PiVector_IP;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.objectGui.PsSlotLayout;
import jv.vecmath.PiVector;

public class PgTexture_IP
extends PsPanel
implements ActionListener,
ItemListener {
    protected PgTexture m_texture;
    protected Panel m_pSize;
    protected TextField m_tImage;
    protected String m_fileName;
    protected String m_dirName;
    protected Button m_bBrowse;
    protected PiVector_IP m_pRepeat;
    protected PiVector m_repeat;
    protected Checkbox m_cMove;
    protected Choice m_cPeriodic;
    protected Choice m_cSampling;
    protected Choice m_cBlending;
    protected Choice m_cSurfaceSide;
    protected Button m_bReset;
    static /* synthetic */ Class class$jv$geom$PgTexture_IP;

    public PgTexture_IP() {
        if (this.getClass() == (class$jv$geom$PgTexture_IP == null ? (class$jv$geom$PgTexture_IP = PgTexture_IP.class$("jv.geom.PgTexture_IP")) : class$jv$geom$PgTexture_IP)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.addSubTitle(PsConfig.getMessage(24088));
        PsPanel psPanel = new PsPanel(new GridLayout(2, 2));
        Panel panel = new Panel(new PsSlotLayout(3));
        panel.add("2", new Label(PsConfig.getMessage(24093)));
        this.m_bBrowse = new Button(PsConfig.getMessage(24094));
        this.m_bBrowse.addActionListener(this);
        panel.add("1", this.m_bBrowse);
        psPanel.add(panel);
        this.m_tImage = new TextField();
        this.m_tImage.addActionListener(this);
        psPanel.add(this.m_tImage);
        psPanel.add(new Label(PsConfig.getMessage(true, 24000, "Continuation")));
        this.m_cPeriodic = new Choice();
        this.m_cPeriodic.addItemListener(this);
        this.m_cPeriodic.addItem(PsConfig.getMessage(true, 24000, "None"));
        this.m_cPeriodic.addItem(PsConfig.getMessage(true, 24000, "Along Width"));
        this.m_cPeriodic.addItem(PsConfig.getMessage(true, 24000, "Along Height"));
        this.m_cPeriodic.addItem(PsConfig.getMessage(true, 24000, "Doubly Periodic"));
        this.m_cPeriodic.select(3);
        psPanel.add(this.m_cPeriodic);
        this.add(psPanel);
        this.m_pRepeat = new PiVector_IP();
        this.m_pRepeat.setTitle(PsConfig.getMessage(24089));
        this.m_pRepeat.setParent(this);
        this.m_repeat = new PiVector(1, 1);
        this.m_pRepeat.setVector(this.m_repeat);
        this.add(this.m_pRepeat);
        this.addSubTitle(PsConfig.getMessage(24095));
        panel = new PsPanel(new GridLayout(3, 2));
        panel.add(new Label(PsConfig.getMessage(true, 24000, "Surface Side")));
        this.m_cSurfaceSide = new Choice();
        this.m_cSurfaceSide.addItemListener(this);
        this.m_cSurfaceSide.addItem(PsConfig.getMessage(true, 24000, "Both Sides"));
        this.m_cSurfaceSide.addItem(PsConfig.getMessage(true, 24000, "Only Frontside"));
        this.m_cSurfaceSide.addItem(PsConfig.getMessage(true, 24000, "Only Backside"));
        panel.add(this.m_cSurfaceSide);
        panel.add(new Label(PsConfig.getMessage(24096)));
        this.m_cSampling = new Choice();
        this.m_cSampling.addItemListener(this);
        this.m_cSampling.addItem(PsConfig.getMessage(24097));
        this.m_cSampling.addItem(PsConfig.getMessage(24098));
        this.m_cSampling.addItem(PsConfig.getMessage(24099));
        panel.add(this.m_cSampling);
        panel.add(new Label(PsConfig.getMessage(24100)));
        this.m_cBlending = new Choice();
        this.m_cBlending.addItemListener(this);
        this.m_cBlending.addItem(PsConfig.getMessage(24101));
        this.m_cBlending.addItem(PsConfig.getMessage(24350));
        this.m_cBlending.addItem(PsConfig.getMessage(true, 24000, "Transparency from Grey"));
        panel.add(this.m_cBlending);
        this.add(panel);
        PsPanel psPanel2 = new PsPanel(new GridLayout(1, 2));
        psPanel2.addSubTitle(PsConfig.getMessage(true, 24000, "Cropping"));
        this.m_cMove = new Checkbox(PsConfig.getMessage(24351));
        this.m_cMove.addItemListener(this);
        psPanel2.add(this.m_cMove);
        this.add(psPanel2);
        this.m_pSize = new Panel(new GridLayout(4, 1));
        this.add(this.m_pSize);
        Panel panel2 = new Panel(new FlowLayout());
        this.add(panel2);
        this.m_bReset = new Button(PsConfig.getMessage(24104));
        this.m_bReset.addActionListener(this);
        panel2.add(this.m_bReset);
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        super.setParent(psUpdateIf);
        this.m_texture = (PgTexture)psUpdateIf;
        this.m_pSize.add(this.m_texture.m_uMin.newInspector("_IP"));
        this.m_pSize.add(this.m_texture.m_vMin.newInspector("_IP"));
        this.m_pSize.add(this.m_texture.m_uMax.newInspector("_IP"));
        this.m_pSize.add(this.m_texture.m_vMax.newInspector("_IP"));
        this.m_pSize.validate();
    }

    public boolean update(Object object) {
        if (this.m_texture == null) {
            PsDebug.warning("missing texture");
            return false;
        }
        if (object == this.m_texture) {
            this.setTitle(this.m_texture.getName());
            PsPanel.setText(this.m_tImage, this.m_texture.getImageName());
            int n = 0;
            if (this.m_texture.getTextureSide() == 1) {
                n = 1;
            } else if (this.m_texture.getTextureSide() == 2) {
                n = 2;
            }
            PsPanel.select(this.m_cSurfaceSide, n);
            int n2 = 3;
            if (this.m_texture.getPeriodic() == 0) {
                n2 = 0;
            } else if (this.m_texture.getPeriodic() == 1) {
                n2 = 1;
            } else if (this.m_texture.getPeriodic() == 2) {
                n2 = 2;
            }
            PsPanel.select(this.m_cPeriodic, n2);
            PsPanel.select(this.m_cSampling, this.m_texture.getFilterType());
            PsPanel.select(this.m_cBlending, this.m_texture.getBlendingMode());
            PsPanel.setState(this.m_cMove, this.m_texture.isEnabledMove());
            this.m_repeat.set(this.m_texture.getWidthTiling(), this.m_texture.getHeightTiling());
            this.m_pRepeat.update(this.m_repeat);
            return true;
        }
        if (object == this.m_pRepeat) {
            boolean bl = false;
            for (int i = 0; i < this.m_repeat.getSize(); ++i) {
                if (this.m_repeat.getEntry(i) >= 1) continue;
                this.m_repeat.setEntry(i, 1);
                bl = true;
            }
            if (bl) {
                this.m_pRepeat.update(this.m_repeat);
            }
            this.m_texture.setTiling(this.m_repeat.getEntry(0), this.m_repeat.getEntry(1));
            this.m_texture.update(this.m_texture);
            return true;
        }
        return super.update(object);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.m_texture == null) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object == this.m_tImage) {
            this.m_fileName = this.m_tImage.getText();
            this.m_fileName.trim();
            this.m_texture.setImageName(this.m_fileName);
            Image image = this.m_texture.loadImage(this);
            if (image == null) {
                this.m_texture.setImageName(null);
                return;
            }
            this.m_texture.update(this.m_texture);
        } else if (object == this.m_bBrowse) {
            Object object2;
            if (!PsConfig.isApplication()) {
                this.m_fileName = this.m_tImage.getText();
                this.m_fileName.trim();
            } else {
                String string;
                object2 = new PgFileDialog(PsConfig.getFrame(), PsConfig.getMessage(24105), 0);
                if (this.m_dirName == null) {
                    string = PsConfig.getInstBase();
                    if (PuString.isEmpty(string)) {
                        string = PsConfig.getCodeBase();
                    }
                    this.m_dirName = string + "images";
                }
                ((FileDialog)object2).setDirectory(this.m_dirName);
                ((Component)object2).setVisible(true);
                string = ((FileDialog)object2).getFile();
                if (string == null) {
                    return;
                }
                this.m_dirName = ((FileDialog)object2).getDirectory();
                this.m_fileName = this.m_dirName + string;
                this.m_fileName.trim();
                PsPanel.setText(this.m_tImage, this.m_fileName);
            }
            this.m_texture.setImageName(this.m_fileName);
            object2 = this.m_texture.loadImage(this);
            if (object2 == null) {
                return;
            }
            this.m_texture.update(this.m_texture);
        } else if (object == this.m_bReset) {
            this.m_texture.init();
            this.m_texture.update(this.m_texture);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.m_cSurfaceSide) {
            int n = this.m_cSurfaceSide.getSelectedIndex();
            int n2 = 3;
            if (n == 1) {
                n2 = 1;
            } else if (n == 2) {
                n2 = 2;
            }
            this.m_texture.setTextureSide(n2);
            this.m_texture.update(this.m_texture);
        } else if (object == this.m_cSampling) {
            this.m_texture.setFilterType(this.m_cSampling.getSelectedIndex());
            this.m_texture.update(this.m_texture);
        } else if (object == this.m_cBlending) {
            this.m_texture.setBlendingMode(this.m_cBlending.getSelectedIndex());
            this.m_texture.update(this.m_texture);
        } else if (object == this.m_cMove) {
            this.m_texture.setEnabledMove(this.m_cMove.getState());
            this.m_texture.update(this.m_texture);
        } else if (object == this.m_cPeriodic) {
            this.m_texture.setPeriodic(this.m_cPeriodic.getSelectedIndex());
            this.m_texture.update(this.m_texture);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

