/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import jv.number.PdColor;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.objectGui.PsImage;
import jv.vecmath.PdVector;

public class PgTexture
extends PsObject {
    public static final int FILTER_DIRECT = 0;
    public static final int FILTER_LINEAR = 1;
    public static final int FILTER_QUADRATIC = 2;
    public static final int BLEND_REPLACE = 0;
    public static final int BLEND_MATERIAL = 1;
    protected String m_imageName;
    protected transient Image m_image = null;
    protected transient int[] m_pixel;
    protected PuInteger m_uMin = new PuInteger(PsConfig.getMessage(24084), this);
    protected PuInteger m_vMin = new PuInteger(PsConfig.getMessage(24085), this);
    protected PuInteger m_uMax = new PuInteger(PsConfig.getMessage(24086), this);
    protected PuInteger m_vMax = new PuInteger(PsConfig.getMessage(24087), this);
    protected Dimension m_tiling;
    protected int m_filterType = 0;
    protected int m_blendingMode = 1;
    protected int m_surfaceSide = 3;
    protected int m_periodic = 3;
    protected boolean m_bMoveTexture = false;
    protected Dimension m_sector;
    protected PdVector[] m_textureImageBnd = PdVector.realloc(null, 2, 2);
    protected boolean m_bValidPixels;
    private transient boolean m_bIsUpdateSender = false;
    static /* synthetic */ Class class$jv$geom$PgTexture;

    public PgTexture() {
        this.m_tiling = new Dimension(1, 1);
        if (this.getClass() == (class$jv$geom$PgTexture == null ? (class$jv$geom$PgTexture = PgTexture.class$("jv.geom.PgTexture")) : class$jv$geom$PgTexture)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_textureImageBnd[0].set(0.0, 0.0);
        this.m_textureImageBnd[1].set(1.0, 1.0);
        int n = 1280;
        int n2 = 1024;
        if (this.m_image != null) {
            n = this.m_image.getWidth(null);
            n2 = this.m_image.getHeight(null);
        }
        this.m_bValidPixels = false;
        this.m_tiling.setSize(1, 1);
        this.setImageSize(n, n2);
    }

    public Object clone() {
        PgTexture pgTexture = (PgTexture)super.clone();
        if (pgTexture == null) {
            return null;
        }
        if (this.m_pixel != null) {
            pgTexture.m_pixel = (int[])this.m_pixel.clone();
        }
        pgTexture.m_uMin = (PuInteger)this.m_uMin.clone();
        pgTexture.m_uMin.setParent(pgTexture);
        pgTexture.m_vMin = (PuInteger)this.m_vMin.clone();
        pgTexture.m_vMin.setParent(pgTexture);
        pgTexture.m_uMax = (PuInteger)this.m_uMax.clone();
        pgTexture.m_uMax.setParent(pgTexture);
        pgTexture.m_vMax = (PuInteger)this.m_vMax.clone();
        pgTexture.m_vMax.setParent(pgTexture);
        pgTexture.m_textureImageBnd = PdVector.copyNew(this.m_textureImageBnd);
        pgTexture.m_tiling = new Dimension(this.m_tiling);
        if (this.m_sector != null) {
            pgTexture.m_sector = new Dimension(this.m_sector);
        }
        return pgTexture;
    }

    public void copy(PgTexture pgTexture) {
        super.copy(pgTexture);
        if (pgTexture == null) {
            return;
        }
        this.m_imageName = pgTexture.m_imageName;
        this.m_image = pgTexture.m_image;
        if (pgTexture.m_pixel == null || !pgTexture.m_bValidPixels) {
            this.m_pixel = null;
            this.m_bValidPixels = false;
        } else {
            int n = pgTexture.m_pixel.length;
            if (this.m_pixel == null || this.m_pixel.length != n) {
                this.m_pixel = (int[])pgTexture.m_pixel.clone();
            } else {
                System.arraycopy(pgTexture.m_pixel, 0, this.m_pixel, 0, n);
            }
            this.m_bValidPixels = true;
        }
        this.m_uMin.copy(pgTexture.m_uMin);
        this.m_vMin.copy(pgTexture.m_vMin);
        this.m_uMax.copy(pgTexture.m_uMax);
        this.m_vMax.copy(pgTexture.m_vMax);
        this.m_tiling.setSize(pgTexture.m_tiling);
        this.m_periodic = pgTexture.m_periodic;
        this.m_filterType = pgTexture.m_filterType;
        this.m_blendingMode = pgTexture.m_blendingMode;
        this.m_surfaceSide = pgTexture.m_surfaceSide;
        PdVector.copy(this.m_textureImageBnd, 0, pgTexture.m_textureImageBnd, 0, 2);
        this.setEnabledMove(pgTexture.isEnabledMove());
    }

    public boolean update(Object object) {
        if (object == null) {
            return super.update(object);
        }
        if (this.m_bIsUpdateSender) {
            return true;
        }
        if (object == this) {
            this.m_bIsUpdateSender = true;
            this.m_uMin.update(this.m_uMin);
            this.m_vMin.update(this.m_vMin);
            this.m_uMax.update(this.m_uMax);
            this.m_vMax.update(this.m_vMax);
            this.m_bIsUpdateSender = false;
            return super.update(this);
        }
        if (object == this.m_uMin) {
            this.m_bValidPixels = false;
            if (this.m_bMoveTexture) {
                this.m_uMax.setValue(this.m_uMin.getValue() + this.m_sector.width);
            }
            return super.update(this);
        }
        if (object == this.m_vMin) {
            this.m_bValidPixels = false;
            if (this.m_bMoveTexture) {
                this.m_vMax.setValue(this.m_vMin.getValue() + this.m_sector.height);
            }
            return super.update(this);
        }
        if (object == this.m_uMax) {
            this.m_bValidPixels = false;
            return super.update(this);
        }
        if (object == this.m_vMax) {
            this.m_bValidPixels = false;
            return super.update(this);
        }
        return super.update(object);
    }

    public String getImageName() {
        return this.m_imageName;
    }

    public void setImageName(String string) {
        this.m_imageName = string;
    }

    public void setImage(String string) {
        this.m_imageName = string;
    }

    public Image getImage() {
        return this.m_image;
    }

    public void setImage(Image image) {
        this.m_image = image;
        if (this.m_image == null) {
            this.m_pixel = null;
            return;
        }
        int n = this.m_image.getWidth(null);
        int n2 = this.m_image.getHeight(null);
        this.setImageSize(n, n2);
        PdVector[] pdVectorArray = this.m_textureImageBnd;
        this.setUMin((int)((double)n * pdVectorArray[0].getEntry(0)));
        this.setVMin((int)((double)n2 * pdVectorArray[0].getEntry(1)));
        this.setUMax((int)((double)n * pdVectorArray[1].getEntry(0)));
        this.setVMax((int)((double)n2 * pdVectorArray[1].getEntry(1)));
        this.m_bValidPixels = false;
    }

    protected int[] getPixels() {
        if (this.m_image == null) {
            PsDebug.warning("missing image");
            return null;
        }
        if (!this.m_bValidPixels) {
            int n = this.getUMax() - this.getUMin();
            this.m_pixel = PsImage.getPixels(this.m_image, this.getUMin(), this.getVMin(), this.getUMax() - this.getUMin(), this.getVMax() - this.getVMin(), null, 0, n);
            this.m_bValidPixels = true;
        }
        return this.m_pixel;
    }

    private void setImageSize(int n, int n2) {
        this.m_uMin.setDefBounds(-n, n, 5, 10);
        this.m_uMin.setDefValue(0);
        this.m_uMin.init();
        this.m_vMin.setDefBounds(-n2, n2, 5, 10);
        this.m_vMin.setDefValue(0);
        this.m_vMin.init();
        this.m_uMax.setDefBounds(0, 2 * n, 5, 10);
        this.m_uMax.setDefValue(n);
        this.m_uMax.init();
        this.m_vMax.setDefBounds(0, 2 * n2, 5, 10);
        this.m_vMax.setDefValue(n2);
        this.m_vMax.init();
    }

    public PdVector[] getTextureImageBnd() {
        PdVector[] pdVectorArray = this.m_textureImageBnd;
        if (this.m_image == null) {
            return pdVectorArray;
        }
        int n = this.m_image.getWidth(null);
        int n2 = this.m_image.getHeight(null);
        if (n <= 0 || n2 <= 0) {
            return pdVectorArray;
        }
        pdVectorArray[0].setEntry(0, (double)this.getUMin() / (double)n);
        pdVectorArray[0].setEntry(1, (double)this.getVMin() / (double)n2);
        pdVectorArray[1].setEntry(0, (double)this.getUMax() / (double)n);
        pdVectorArray[1].setEntry(1, (double)this.getVMax() / (double)n2);
        return pdVectorArray;
    }

    public void setTextureImageBnd(PdVector[] pdVectorArray) {
        if (pdVectorArray == null) {
            this.m_textureImageBnd[0].set(0.0, 0.0);
            this.m_textureImageBnd[1].set(1.0, 1.0);
        } else {
            if (pdVectorArray.length != 2 || pdVectorArray[0] == null || pdVectorArray[1] == null) {
                PsDebug.warning("missing or void length of texture image bounds");
                return;
            }
            if (pdVectorArray[0].getSize() != 2 || pdVectorArray[1].getSize() != 2) {
                PsDebug.warning("dimension of bounds != 2.");
                return;
            }
            this.m_textureImageBnd[0].copy(pdVectorArray[0]);
            this.m_textureImageBnd[1].copy(pdVectorArray[1]);
        }
        if (this.m_image == null) {
            return;
        }
        int n = this.m_image.getWidth(null);
        int n2 = this.m_image.getHeight(null);
        this.setUMin((int)((double)n * this.m_textureImageBnd[0].getEntry(0)));
        this.setVMin((int)((double)n2 * this.m_textureImageBnd[0].getEntry(1)));
        this.setUMax((int)((double)n * this.m_textureImageBnd[1].getEntry(0)));
        this.setVMax((int)((double)n2 * this.m_textureImageBnd[1].getEntry(1)));
    }

    public int getUMin() {
        return this.m_uMin.getValue();
    }

    public void setUMin(int n) {
        this.m_bValidPixels = false;
        this.m_uMin.setValue(n);
    }

    public int getVMin() {
        return this.m_vMin.getValue();
    }

    public void setVMin(int n) {
        this.m_bValidPixels = false;
        this.m_vMin.setValue(n);
    }

    public int getUMax() {
        return this.m_uMax.getValue();
    }

    public void setUMax(int n) {
        this.m_bValidPixels = false;
        this.m_uMax.setValue(n);
    }

    public int getVMax() {
        return this.m_vMax.getValue();
    }

    public void setVMax(int n) {
        this.m_bValidPixels = false;
        this.m_vMax.setValue(n);
    }

    public int getWidth() {
        return this.m_uMax.getValue() - this.m_uMin.getValue();
    }

    public int getHeight() {
        return this.m_vMax.getValue() - this.m_vMin.getValue();
    }

    public Image loadImage() {
        return this.loadImage(PsConfig.getFrame());
    }

    public Image loadImage(Component component) {
        if (this.m_imageName == null) {
            PsDebug.warning("missing image name in tecture, must be assigned first.");
            return null;
        }
        Image image = PsImage.getImage(this.m_imageName);
        if (component == null) {
            component = PsConfig.getFrame();
        }
        if (!PsImage.loadImage(component, image)) {
            PsDebug.warning("failed loading image = " + this.m_imageName);
            return null;
        }
        this.setImage(image);
        return image;
    }

    public int getPeriodic() {
        return this.m_periodic;
    }

    public void setPeriodic(int n) {
        this.m_periodic = n;
    }

    public Dimension getTiling() {
        return this.m_tiling;
    }

    public void setTiling(Dimension dimension) {
        if (dimension == null) {
            PsDebug.warning("missing argument repeat");
            return;
        }
        this.setTiling(dimension.width, dimension.height);
    }

    public void setTiling(int n, int n2) {
        if (n < 1) {
            PsDebug.warning("argument width must be >=1, width = " + n);
            return;
        }
        this.m_tiling.width = n;
        if (n2 < 1) {
            PsDebug.warning("argument height must be >=1, height = " + n2);
            return;
        }
        this.m_tiling.height = n2;
    }

    public int getWidthTiling() {
        return this.m_tiling.width;
    }

    public int getHeightTiling() {
        return this.m_tiling.height;
    }

    public int getFilterType() {
        return this.m_filterType;
    }

    public void setFilterType(int n) {
        this.m_filterType = n;
    }

    public int getBlendingMode() {
        return this.m_blendingMode;
    }

    public void setBlendingMode(int n) {
        this.m_blendingMode = n;
    }

    public int getTextureSide() {
        return this.m_surfaceSide;
    }

    public void setTextureSide(int n) {
        this.m_surfaceSide = n;
    }

    public boolean isEnabledMove() {
        return this.m_bMoveTexture;
    }

    public void setEnabledMove(boolean bl) {
        this.m_bMoveTexture = bl;
        this.m_sector = bl ? new Dimension(this.m_uMax.getValue() - this.m_uMin.getValue(), this.m_vMax.getValue() - this.m_vMin.getValue()) : null;
        this.m_uMax.setEnabled(!bl);
        this.m_vMax.setEnabled(!bl);
    }

    public boolean blend(double d, PgTexture pgTexture, double d2, PgTexture pgTexture2) {
        int n;
        double d3;
        PgTexture pgTexture3;
        if (pgTexture == null || pgTexture2 == null) {
            if (pgTexture != null) {
                this.copy(pgTexture);
            } else if (pgTexture2 != null) {
                this.copy(pgTexture2);
            } else {
                PsDebug.warning("missing arguments");
            }
            return false;
        }
        double d4 = Math.abs(d);
        PgTexture pgTexture4 = pgTexture3 = d4 > (d3 = Math.abs(d2)) ? pgTexture : pgTexture2;
        if (pgTexture.m_pixel != null && pgTexture2.m_pixel != null && pgTexture.m_pixel.length == pgTexture2.m_pixel.length) {
            n = pgTexture.m_pixel.length;
            if (this.m_pixel == null || this.m_pixel.length != n) {
                this.m_pixel = new int[n];
            }
            for (int i = 0; i < n; ++i) {
                this.m_pixel[i] = PdColor.blend(d4, pgTexture.m_pixel[i], d3, pgTexture2.m_pixel[i]);
            }
            this.m_bValidPixels = true;
        } else {
            this.m_imageName = pgTexture3.m_imageName;
            this.m_image = pgTexture3.m_image;
            this.m_pixel = null;
            this.m_bValidPixels = false;
        }
        this.m_uMin.blend(d4, pgTexture.m_uMin, d3, pgTexture2.m_uMin);
        this.m_vMin.blend(d4, pgTexture.m_vMin, d3, pgTexture2.m_vMin);
        this.m_uMax.blend(d4, pgTexture.m_uMax, d3, pgTexture2.m_uMax);
        this.m_vMax.blend(d4, pgTexture.m_vMax, d3, pgTexture2.m_vMax);
        this.setTiling((int)(d4 * (double)pgTexture.m_tiling.width + d3 * (double)pgTexture2.m_tiling.width + 0.5), (int)(d4 * (double)pgTexture.m_tiling.height + d3 * (double)pgTexture2.m_tiling.height + 0.5));
        this.m_filterType = pgTexture3.m_filterType;
        this.m_blendingMode = pgTexture3.m_blendingMode;
        for (n = 0; n < 2; ++n) {
            this.m_textureImageBnd[n].blend(d4, pgTexture.m_textureImageBnd[n], d3, pgTexture2.m_textureImageBnd[n]);
        }
        this.setEnabledMove(pgTexture3.isEnabledMove());
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

