/*
 * Decompiled with CFR 0.152.
 */
package vgp.tutor.vectorField;

import java.awt.Color;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.number.PuDouble;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.surface.PgDomain;
import jvx.surface.PgDomainDescr;

public class PjVectorField
extends PjProject {
    public static final int GRADIENT = 0;
    public static final int ROTATION = 1;
    protected PgDomain m_geom;
    protected PgVectorField m_vf = new PgVectorField(2);
    protected PiVector m_fieldType;
    protected int m_fieldTypeSelection = 0;
    protected PdVector m_radiusForEach;
    protected PgPointSet m_center;
    protected PuDouble m_radius;
    static /* synthetic */ Class class$vgp$tutor$vectorField$PjVectorField;

    public PjVectorField() {
        super("Potential");
        this.m_vf.setName("Vector Field");
        this.m_geom = new PgDomain(2);
        this.m_geom.setName("Domain with Vectorfield");
        this.m_geom.setParent((PsUpdateIf)this);
        this.m_center = new PgPointSet(2);
        this.m_center.setName("Singularities");
        this.m_center.setParent((PsUpdateIf)this);
        this.m_fieldType = new PiVector();
        this.m_radiusForEach = new PdVector();
        this.m_radius = new PuDouble("Ratio of Decay", (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$vgp$tutor$vectorField$PjVectorField == null ? (class$vgp$tutor$vectorField$PjVectorField = PjVectorField.class$("vgp.tutor.vectorField.PjVectorField")) : class$vgp$tutor$vectorField$PjVectorField)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_radius.setDefBounds(0.001, 5.0, 0.01, 0.1);
        this.m_radius.setDefValue(0.5);
        this.m_radius.init();
        PgDomainDescr pgDomainDescr = this.m_geom.getDescr();
        pgDomainDescr.setMaxSize(-10.0, -10.0, 10.0, 10.0);
        pgDomainDescr.setSize(-5.0, -5.0, 5.0, 5.0);
        pgDomainDescr.setDiscrBounds(2, 2, 50, 50);
        pgDomainDescr.setDiscr(20, 20);
        this.m_geom.compute();
        this.addSingularity(0.0, 0.0, 0, 0.6);
        this.addSingularity(-2.0, 2.0, 1, 0.4);
    }

    public void start() {
        this.m_geom.addVectorField(this.m_vf);
        this.m_vf.setGeometry((PgPointSet)this.m_geom);
        this.m_vf.setGlobalVectorColor(Color.black);
        this.computeVectorfield();
        this.m_geom.showVectorArrows(true);
        this.m_geom.showEdges(false);
        this.m_geom.showElements(false);
        this.m_geom.update(null);
        this.addGeometry((PgGeometryIf)this.m_geom);
        this.addGeometry((PgGeometryIf)this.m_center);
        this.selectGeometry((PgGeometryIf)this.m_center);
        PvDisplayIf pvDisplayIf = this.getDisplay();
        pvDisplayIf.selectCamera(1);
        pvDisplayIf.setBackgroundColor(Color.white);
        super.start();
    }

    public boolean update(Object object) {
        if (object == null) {
            super.update(null);
        } else {
            if (object == this.m_geom) {
                this.computeVectorfield();
                return true;
            }
            if (object == this.m_radius) {
                if (this.m_radiusForEach.getSize() > 0) {
                    this.m_radiusForEach.setEntry(this.m_radiusForEach.getSize() - 1, this.m_radius.getValue());
                    this.computeVectorfield();
                    this.m_geom.update(null);
                }
                return true;
            }
            if (object == this.getInfoPanel()) {
                this.computeVectorfield();
                this.m_geom.update(null);
                return true;
            }
            if (object == this.m_center) {
                if (this.m_center.getNumVertices() > this.m_radiusForEach.getSize()) {
                    int n = this.m_radiusForEach.getSize();
                    int n2 = this.m_center.getNumVertices();
                    this.m_radiusForEach.setSize(n2);
                    this.m_fieldType.setSize(n2);
                    for (int i = n; i < n2; ++i) {
                        this.m_radiusForEach.setEntry(i, this.m_radius.getValue());
                        this.m_fieldType.setEntry(i, this.m_fieldTypeSelection);
                    }
                } else {
                    int n = this.m_center.getNumVertices();
                    this.m_radiusForEach.setSize(n);
                    this.m_fieldType.setSize(n);
                }
                this.computeVectorfield();
                this.m_vf.update(null);
                this.m_geom.update(null);
                return super.update(null);
            }
        }
        return super.update(object);
    }

    public void computeVectorfield() {
        int n = this.m_geom.getNumVertices();
        this.m_vf.setNumVectors(n);
        PdVector[] pdVectorArray = this.m_vf.getVectors();
        PdVector[] pdVectorArray2 = this.m_vf.getVertices();
        int n2 = this.m_center.getNumVertices();
        for (int i = 0; i < n; ++i) {
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            for (int j = 0; j < n2; ++j) {
                PdVector pdVector = this.m_center.getVertex(j);
                d = Math.exp(-2.0 * PdVector.dist((PdVector)pdVector, (PdVector)pdVectorArray2[i]) * this.m_radiusForEach.getEntry(j));
                if (this.m_fieldType.getEntry(j) == 0) {
                    d3 += -2.0 * (pdVectorArray2[i].m_data[0] - pdVector.m_data[0]) * d;
                    d2 += -2.0 * (pdVectorArray2[i].m_data[1] - pdVector.m_data[1]) * d;
                    continue;
                }
                d3 -= -2.0 * (pdVectorArray2[i].m_data[1] - pdVector.m_data[1]) * d;
                d2 += -2.0 * (pdVectorArray2[i].m_data[0] - pdVector.m_data[0]) * d;
            }
            pdVectorArray[i].set(d3, d2);
        }
        if (this.m_vf.hasInspector("Info") && this.m_vf.getInspector("Info").isShowing()) {
            this.m_vf.getInspector("Info").update((Object)this.m_vf);
        }
    }

    protected void setFieldType(int n) {
        this.m_fieldTypeSelection = n;
    }

    protected int getFieldType() {
        return this.m_fieldTypeSelection;
    }

    protected void addSingularity(double d, double d2, int n, double d3) {
        int n2 = this.m_center.getNumVertices() + 1;
        this.m_center.setNumVertices(n2);
        this.m_center.setVertex(n2 - 1, new PdVector(d, d2));
        this.m_radiusForEach.setSize(n2);
        this.m_fieldType.setSize(n2);
        this.m_radiusForEach.setEntry(n2 - 1, d3);
        this.m_fieldType.setEntry(n2 - 1, n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

