/*
 * Decompiled with CFR 0.152.
 */
package vgp.discrete.harmonic;

import jv.anim.PsAnimation;
import jv.anim.PsTimeEvent;
import jv.anim.PsTimeListenerIf;
import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PvGeometryIf;
import jvx.geom.PnConjugate;

public class PgSurfacePair
extends PgGeometry
implements PsTimeListenerIf {
    public static final int DOMAIN = 0;
    public static final int SURFACE = 1;
    public static final int DUAL = 2;
    public static final int DUAL_FULL = 3;
    public static final int ASSOCIATE = 4;
    public static final int ASSOCIATE_FULL = 5;
    public static final int CURRENT = 6;
    protected PgElementSet m_geom;
    protected int m_domainDim;
    protected int m_imageDim;
    protected PgElementSet m_domain;
    protected PgElementSet m_surface;
    protected PgElementSet m_dual;
    protected PgElementSet m_associate;
    protected double m_associateTime;
    protected int m_activeSurface;
    protected PsAnimation m_anim = null;
    static /* synthetic */ Class class$vgp$discrete$harmonic$PgSurfacePair;

    public PgSurfacePair(int n, int n2) {
        super(n2);
        this.setTag(4);
        this.m_domainDim = n;
        this.m_imageDim = n2;
        if (((Object)((Object)this)).getClass() == (class$vgp$discrete$harmonic$PgSurfacePair == null ? (class$vgp$discrete$harmonic$PgSurfacePair = PgSurfacePair.class$("vgp.discrete.harmonic.PgSurfacePair")) : class$vgp$discrete$harmonic$PgSurfacePair)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.setActiveSurface(1);
        this.m_associateTime = 0.0;
    }

    public boolean update(Object object) {
        if (this.m_surface == object) {
            if (this.m_activeSurface == 2) {
                this.conjugate();
                this.m_dual.update((Object)this.m_dual);
                return true;
            }
            if (this.m_activeSurface == 3) {
                this.conjugateToFull();
                this.m_dual.update((Object)this.m_dual);
                return true;
            }
            if (this.m_activeSurface == 4) {
                this.conjugate();
                this.computeAssociate(this.m_associateTime);
                this.m_associate.update((Object)this.m_associate);
                return true;
            }
            if (this.m_activeSurface == 5) {
                this.conjugateToFull();
                this.computeAssociate(this.m_associateTime);
                this.m_associate.update((Object)this.m_associate);
                return true;
            }
            return super.update((Object)this);
        }
        if (this.m_dual == object) {
            return super.update((Object)this);
        }
        if (this.m_domain == object) {
            return super.update((Object)this);
        }
        if (this.m_associate == object) {
            return super.update((Object)this);
        }
        return super.update(object);
    }

    public PgElementSet getActiveSurface() {
        return this.m_geom;
    }

    public void setActiveSurface(int n) {
        this.m_activeSurface = n;
        this.m_geom = this.getSurface(this.m_activeSurface);
    }

    public boolean computeAssociate(double d) {
        if (this.m_surface == null || this.m_dual == null) {
            PsDebug.error((String)"missing surface pair", (Object)((Object)this));
            return false;
        }
        if (this.m_associate == null) {
            this.m_associate = new PgElementSet(this.m_surface.getDimOfVertices());
            this.m_associate.setName("Associate of " + this.m_surface.getName());
            this.m_associate.setParent((PsUpdateIf)this);
            if (this.m_activeSurface == 4 || this.m_activeSurface == 5) {
                this.m_geom = this.m_associate;
            }
        }
        if (this.m_domain == null) {
            this.m_domain = new PgElementSet(this.m_surface.getDimOfVertices());
            this.m_domain.setName("Domain of " + this.m_surface.getName());
            this.m_domain.setParent((PsUpdateIf)this);
            if (this.m_activeSurface == 0) {
                this.m_geom = this.m_domain;
            }
        }
        this.m_domain.copy((PsObject)this.m_surface);
        if (this.m_activeSurface == 4) {
            PnConjugate.makeNonConforming((PgElementSet)this.m_surface);
            PnConjugate.makeNonConforming((PgElementSet)this.m_dual);
        } else if (this.m_activeSurface == 5) {
            PnConjugate.makeConformingToFull((PgElementSet)this.m_surface);
        }
        this.m_associate.blend(Math.cos(d), (PgGeometry)this.m_surface, Math.sin(d), (PgGeometry)this.m_dual);
        this.m_associateTime = d;
        this.m_surface.copy((PsObject)this.m_domain);
        return true;
    }

    public void setSurface(PgElementSet pgElementSet, int n) {
        if (pgElementSet == null) {
            PsDebug.warning((String)"missing argument");
            return;
        }
        switch (n) {
            case 6: {
                PsDebug.warning((String)"CURRENT is not allowed");
                return;
            }
            case 0: {
                this.m_domain = pgElementSet;
                break;
            }
            case 1: {
                this.m_surface = pgElementSet;
                break;
            }
            case 2: 
            case 3: {
                this.m_dual = pgElementSet;
                break;
            }
            case 4: 
            case 5: {
                this.m_associate = pgElementSet;
                break;
            }
            default: {
                PsDebug.warning((String)("unknown type = " + n));
                return;
            }
        }
        if (this.m_activeSurface == n) {
            this.m_geom = pgElementSet;
        }
        pgElementSet.setParent((PsUpdateIf)this);
    }

    public PgElementSet getSurface(int n) {
        PgElementSet pgElementSet;
        switch (n) {
            case 6: {
                pgElementSet = this.m_geom;
                break;
            }
            case 0: {
                pgElementSet = this.m_domain;
                break;
            }
            case 1: {
                pgElementSet = this.m_surface;
                break;
            }
            case 2: 
            case 3: {
                pgElementSet = this.m_dual;
                break;
            }
            case 4: 
            case 5: {
                pgElementSet = this.m_associate;
                break;
            }
            default: {
                PsDebug.warning((String)("unknown type = " + n));
                return null;
            }
        }
        return pgElementSet;
    }

    public void paint(PvGeometryIf pvGeometryIf) {
        if (this.m_geom != null) {
            this.m_geom.paint(pvGeometryIf);
        }
    }

    public boolean conjugate() {
        if (this.m_surface == null) {
            return false;
        }
        this.m_dual = PnConjugate.conjugate((PgElementSet)this.m_dual, (PgElementSet)this.m_surface, (PgElementSet)this.m_domain);
        this.m_dual.setParent((PsUpdateIf)this);
        return true;
    }

    public boolean conjugateToFull() {
        if (this.m_surface == null) {
            return false;
        }
        this.m_dual = PnConjugate.conjugateToFull((PgElementSet)this.m_dual, (PgElementSet)this.m_surface, (PgElementSet)this.m_domain);
        this.m_dual.setParent((PsUpdateIf)this);
        return true;
    }

    public boolean setTime(PsTimeEvent psTimeEvent) {
        double d = psTimeEvent.getTime();
        this.computeAssociate(d);
        if (this.m_geom == null) {
            PsDebug.warning((String)"missing current geometry");
            return false;
        }
        this.m_geom.update(null);
        return true;
    }

    public PsAnimation getAnimation() {
        return this.m_anim;
    }

    public boolean hasAnimation() {
        return this.m_anim != null;
    }

    public void setAnimation(PsAnimation psAnimation) {
        this.m_anim = psAnimation;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

