/*
 * Decompiled with CFR 0.152.
 */
package vgp.curve.cycloid;

import java.awt.Color;
import jv.anim.PsAnimation;
import jv.anim.PsTimeEvent;
import jv.anim.PsTimeListenerIf;
import jv.geom.PgElementSet;
import jv.geom.PgPolygon;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.vecmath.PdVector;

public class PjCycloid
extends PjProject {
    protected boolean m_bShowCircle;
    protected boolean m_bShowCycloid;
    protected boolean m_bShowSurface;
    protected PgPolygon m_circle;
    protected PgPolygon m_stick;
    protected PgPolygon m_cycloid;
    protected PgElementSet m_surface;
    protected int m_defCycloidDiscr = 40;
    protected PuInteger m_cycloidDiscr;
    protected double m_defDistance = 2.0;
    protected PuDouble m_distance;
    protected double m_defLength = Math.PI * 4;
    protected PuDouble m_length;
    protected double m_defRadius = 1.0;
    protected PuDouble m_radius;
    protected int m_numCircleDiscr = 20;
    static /* synthetic */ Class class$vgp$curve$cycloid$PjCycloid;

    public PjCycloid() {
        super("Cycloid");
        this.m_circle = new PgPolygon(2);
        this.m_circle.setName("Circle");
        this.m_circle.showVertices(false);
        this.m_cycloid = new PgPolygon(2);
        this.m_cycloid.setName("Cycloid");
        this.m_cycloid.setGlobalEdgeColor(Color.blue);
        this.m_stick = new PgPolygon(2);
        this.m_stick.setName("Stick");
        this.m_stick.showVertices(true);
        this.m_stick.setGlobalEdgeSize(5.0);
        this.m_stick.setGlobalVertexSize(7.0);
        this.m_stick.setGlobalVertexColor(Color.yellow);
        this.m_stick.setNumVertices(2);
        this.m_surface = new PgElementSet(3);
        this.m_surface.setName("Surface");
        this.m_surface.showElements(false);
        this.m_surface.setVisible(false);
        this.m_cycloidDiscr = new PuInteger("Cycloid Discr", (PsUpdateIf)this);
        this.m_length = new PuDouble("Cycloid Length", (PsUpdateIf)this);
        this.m_radius = new PuDouble("Radius r", (PsUpdateIf)this);
        this.m_distance = new PuDouble("Distance d", (PsUpdateIf)this);
        this.m_anim = new PsAnimation();
        this.m_anim.setName("Rolling Circle");
        this.m_anim.addTimeListener((PsTimeListenerIf)this);
        this.setAnimation(this.m_anim);
        if (((Object)((Object)this)).getClass() == (class$vgp$curve$cycloid$PjCycloid == null ? (class$vgp$curve$cycloid$PjCycloid = PjCycloid.class$("vgp.curve.cycloid.PjCycloid")) : class$vgp$curve$cycloid$PjCycloid)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_bShowCircle = true;
        this.m_bShowCycloid = true;
        this.m_bShowSurface = false;
        this.m_cycloidDiscr.setDefBounds(0, 2 * this.m_defCycloidDiscr, 1, 2);
        this.m_cycloidDiscr.setDefValue(this.m_defCycloidDiscr);
        this.m_cycloidDiscr.init();
        this.m_length.setDefBounds(0.1, 20.0, 0.1, 1.0);
        this.m_length.setDefValue(this.m_defLength);
        this.m_length.init();
        this.m_distance.setDefBounds(0.01, 5.0, 0.01, 0.1);
        this.m_distance.setDefValue(this.m_defDistance);
        this.m_distance.init();
        this.m_radius.setDefBounds(0.01, 5.0, 0.01, 0.1);
        this.m_radius.setDefValue(this.m_defRadius);
        this.m_radius.init();
        this.m_anim.setTime(0.0);
        this.computeCycloid(this.m_cycloidDiscr.getValue(), this.m_length.getValue(), this.m_distance.getValue());
    }

    public void start() {
        PvDisplayIf pvDisplayIf = this.getDisplay();
        if (pvDisplayIf != null) {
            pvDisplayIf.showGrid(true);
            pvDisplayIf.selectCamera(1);
        }
        this.addGeometry((PgGeometryIf)this.m_cycloid);
        this.addGeometry((PgGeometryIf)this.m_circle);
        this.addGeometry((PgGeometryIf)this.m_stick);
        this.selectGeometry((PgGeometryIf)this.m_cycloid);
        super.start();
    }

    public void reset() {
        this.stop();
        this.init();
    }

    public boolean update(Object object) {
        if (object == this) {
            this.computeCycloid(this.m_cycloidDiscr.getValue(), this.m_length.getValue(), this.m_distance.getValue());
            this.m_display.setPaintTag(1L, false);
            this.m_circle.update(null);
            this.m_stick.update(null);
            if (this.m_surface.isVisible()) {
                this.m_surface.computeRotation(this.m_cycloid, 10);
                this.m_surface.update(null);
            }
            this.m_display.setPaintTag(1L, true);
            this.m_cycloid.update((Object)this.m_cycloid);
            return super.update((Object)this);
        }
        if (object == this.m_cycloidDiscr) {
            return this.update((Object)this);
        }
        if (object == this.m_distance || object == this.m_radius) {
            return this.update((Object)this);
        }
        if (object == this.m_length) {
            return this.update((Object)this);
        }
        return super.update(object);
    }

    public boolean setTime(PsTimeEvent psTimeEvent) {
        return this.update((Object)this);
    }

    private void computeCycloid(int n, double d, double d2) {
        double d3 = this.m_radius.getValue();
        this.m_cycloid.setNumVertices(n);
        PdVector[] pdVectorArray = this.m_cycloid.getVertices();
        for (int i = 0; i < n; ++i) {
            double d4 = d * (double)i / ((double)n - 1.0);
            pdVectorArray[i].m_data[0] = d3 * d4 - d2 * Math.sin(d4);
            pdVectorArray[i].m_data[1] = d3 - d2 * Math.cos(d4);
        }
        double d5 = d * this.m_anim.getTime() / 100.0;
        this.m_circle.computeCircle(this.m_numCircleDiscr, d3);
        this.m_circle.translate(new PdVector(d3 * d5, d3));
        this.m_stick.setVertex(0, d3 * d5, d3);
        this.m_stick.setVertex(1, d3 * d5 - d2 * Math.sin(d5), d3 - d2 * Math.cos(d5));
    }

    public PgPolygon getCycloid() {
        return this.m_cycloid;
    }

    public int getCycloidDiscr() {
        return this.m_cycloidDiscr.getValue();
    }

    public void setCycloidDiscr(int n) {
        this.m_cycloidDiscr.setValue(n);
    }

    public double getCycloidLength() {
        return this.m_length.getValue();
    }

    public void setCycloidLength(double d) {
        this.m_length.setValue(d);
    }

    public double getDistance() {
        return this.m_distance.getValue();
    }

    public void setDistance(double d) {
        this.m_distance.setValue(d);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

