/*
 * Decompiled with CFR 0.152.
 */
package vgp.curve.curvaturePlot;

import java.awt.Color;
import java.awt.Dimension;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.geom.PgVectorField;
import jv.object.PsConfig;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.project.PvViewerIf;
import jv.thirdParty.ruler.PgAxes;
import jv.vecmath.PdVector;
import jv.viewer.PvDisplay;
import jvx.geom.PwRefinePolygon;

public class PjCurvaturePlot
extends PjProject
implements Runnable {
    public static final int ENERGY_NUM = 5;
    public static final int ENERGY_LENGTH = 0;
    public static final int ENERGY_AREA = 1;
    public static final int ENERGY_TENSION = 2;
    public static final int ENERGY_CURVATURE = 3;
    public static final int ENERGY_CORNER = 4;
    public static final String[] ENERGY_NAMES = new String[]{"Length", "Area", "Tension", "Curvature", "Corner"};
    protected PgPolygon m_geom = new PgPolygon(2);
    protected PgPolygon m_geomBackup;
    protected PgPolygon m_curvPlot;
    protected PvDisplay m_curvDisp;
    protected int m_numPoints = 6;
    protected boolean m_bScale;
    protected boolean m_bColorByLength;
    protected int m_numSteps;
    protected float m_stepSize;
    protected PgVectorField[] m_vfGrad;
    protected int m_energyType = 3;
    private boolean m_bStop = false;
    private Thread m_thread;
    protected boolean m_bIsUpdateSender = false;
    static /* synthetic */ Class class$vgp$curve$curvaturePlot$PjCurvaturePlot;

    public PjCurvaturePlot() {
        super("Curvature Plots");
        this.m_geom.setName(PsConfig.getMessage((boolean)true, (int)75000, (String)"Noisy Curve"));
        this.m_geom.setParent((PsUpdateIf)this);
        this.m_geomBackup = new PgPolygon(this.m_geom.getDimOfVertices());
        this.m_vfGrad = new PgVectorField[5];
        for (int i = 0; i < 5; ++i) {
            this.m_vfGrad[i] = new PgVectorField(2, 0);
            this.m_vfGrad[i].setName(ENERGY_NAMES[i] + PsConfig.getMessage((boolean)true, (int)75000, (String)"Gradient"));
            this.m_vfGrad[i].setVisible(false);
            this.m_vfGrad[i].setGeometry((PgPointSet)this.m_geom);
            this.m_geom.addVectorField(this.m_vfGrad[i]);
        }
        this.m_geom.showVectorArrows(true);
        this.m_curvDisp = new PvDisplay();
        this.m_curvDisp.setPreferredSize(new Dimension(200, 250));
        this.m_curvDisp.setBackgroundColor(Color.white);
        this.m_curvDisp.selectCamera(1);
        this.m_curvDisp.setBoxRatio(new PdVector(5.0, 1.0, 1.0));
        this.m_curvDisp.setEnabledBoxRatio(true);
        PgAxes pgAxes = new PgAxes(2);
        pgAxes.setMode(3);
        PdVector[] pdVectorArray = PdVector.realloc(null, (int)2, (int)3);
        double d = 0.1;
        pdVectorArray[0].set(0.0 - d, -d, 0.0);
        pdVectorArray[1].set(1.0 + d, 1.5 + d, 0.0);
        pgAxes.configure(pdVectorArray, null);
        pgAxes.setEnabledAutoBounds(false);
        this.m_curvDisp.setAxes(pgAxes);
        this.m_curvDisp.showAxes(true);
        this.m_curvPlot = new PgPolygon(2);
        this.m_curvPlot.setName(PsConfig.getMessage((boolean)true, (int)75000, (String)"Curvature Plot"));
        this.newCurve();
        if (this.getClass() == (class$vgp$curve$curvaturePlot$PjCurvaturePlot == null ? (class$vgp$curve$curvaturePlot$PjCurvaturePlot = PjCurvaturePlot.class$("vgp.curve.curvaturePlot.PjCurvaturePlot")) : class$vgp$curve$curvaturePlot$PjCurvaturePlot)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_bAutoFit = true;
        this.m_bScale = true;
        this.m_bColorByLength = true;
        this.m_stepSize = 0.001f;
        this.m_numSteps = 10;
        this.m_geom.setVertices(this.m_geomBackup.getVertices());
        this.m_geom.showVertices(false);
        this.m_geom.showEdgeColors(this.m_bColorByLength);
        this.m_curvPlot.showVertices(false);
        this.m_curvPlot.showEdgeColors(this.m_bColorByLength);
        this.computePlot();
        if (!this.m_curvDisp.containsGeometry((PgGeometryIf)this.m_curvPlot)) {
            this.m_curvDisp.addGeometry((PgGeometryIf)this.m_curvPlot);
        }
    }

    public void newCurve() {
        int n;
        this.m_geom.computeCircle(this.m_numPoints, 1.0);
        for (n = 0; n < this.m_numPoints; ++n) {
            PdVector pdVector = this.m_geom.getVertex(n);
            for (int i = 0; i < pdVector.getSize(); ++i) {
                pdVector.setEntry(i, pdVector.getEntry(i) + (Math.random() - 0.5));
            }
            this.m_geom.setVertex(n, pdVector);
        }
        for (n = 0; n < 5; ++n) {
            PwRefinePolygon.refineDLG((PgPolygon)this.m_geom);
        }
        this.m_geomBackup.copy((PsObject)this.m_geom);
    }

    public void start() {
        this.addGeometry((PgGeometryIf)this.m_geom);
        this.selectGeometry((PgGeometryIf)this.m_geom);
        this.m_geom.update((Object)this.m_geom);
        PvDisplayIf pvDisplayIf = this.getDisplay();
        pvDisplayIf.selectCamera(1);
        pvDisplayIf.fit();
        PvViewerIf pvViewerIf = this.getViewer();
        if (!pvViewerIf.hasDisplay((PvDisplayIf)this.m_curvDisp)) {
            pvViewerIf.addDisplay("Curvature Plot", (PvDisplayIf)this.m_curvDisp);
        }
        super.start();
    }

    public boolean update(Object object) {
        if (this.m_bIsUpdateSender) {
            return true;
        }
        if (object == this) {
            this.m_geom.update((Object)this.m_geom);
        } else if (object == this.m_geom && !this.m_bIsUpdateSender) {
            this.computeGradients(this.m_vfGrad, this.m_geom);
            if (this.m_bColorByLength) {
                this.m_geom.makeEdgeColorsFromLength();
            }
            this.computePlot();
            if (this.m_bColorByLength) {
                this.m_curvPlot.makeEdgeColorsFromLength();
            }
            this.m_bIsUpdateSender = true;
            this.m_curvPlot.update((Object)this.m_curvPlot);
            this.m_geom.update(null);
            this.m_bIsUpdateSender = false;
            if (this.m_bAutoFit) {
                this.m_curvDisp.fit();
            }
            return true;
        }
        return super.update(object);
    }

    public void computePlot() {
        this.computePlot(this.m_curvPlot, this.m_geom);
    }

    protected void computePlot(PgPolygon pgPolygon, PgPolygon pgPolygon2) {
        int n = pgPolygon2.getNumVertices();
        PdVector pdVector = this.computeCurvature(null, pgPolygon2);
        double d = pgPolygon2.getLength();
        if (d < 1.0E-10) {
            return;
        }
        double d2 = 0.0;
        if (pgPolygon2.isClosed()) {
            if (pgPolygon.getNumVertices() != n + 1) {
                pgPolygon.setNumVertices(n + 1);
            }
            for (int i = 0; i < n; ++i) {
                double d3 = pgPolygon2.getLengthOfEdge((i - 1 + n) % n);
                double d4 = pgPolygon2.getLengthOfEdge(i);
                double d5 = d3 + d4;
                double d6 = pdVector.getEntry(i);
                if (this.m_bScale && d5 > 1.0E-10) {
                    d6 *= d / d5 / Math.PI;
                }
                pgPolygon.setVertex(i, d2, d6);
                d2 += d4 / d;
            }
            pgPolygon.setVertex(n, 1.0, pgPolygon.getVertex(0).getEntry(1));
        } else {
            if (pgPolygon.getNumVertices() != n) {
                pgPolygon.setNumVertices(n);
            }
            pgPolygon.setVertex(0, 0.0, 0.0);
            pgPolygon.setVertex(n - 1, 1.0, 0.0);
            for (int i = 1; i < n - 1; ++i) {
                double d7 = pgPolygon2.getLengthOfEdge(i - 1);
                double d8 = pgPolygon2.getLengthOfEdge(i);
                double d9 = d7 + d8;
                d2 += d7 / d;
                double d10 = pdVector.getEntry(i);
                if (this.m_bScale && d9 > 1.0E-10) {
                    d10 /= d9 / Math.PI;
                }
                pgPolygon.setVertex(i, d2, d10);
            }
        }
    }

    public PdVector computeCurvature(PdVector pdVector, PgPolygon pgPolygon) {
        if (pdVector == null) {
            pdVector = new PdVector();
        }
        int n = pgPolygon.getNumVertices();
        if (pdVector.getSize() != n) {
            pdVector.setSize(n);
        }
        PdVector[] pdVectorArray = pgPolygon.getVertices();
        PdVector.angleWithOrientation((double[])pdVector.m_data, (PdVector[])pdVectorArray, (int)n);
        return pdVector;
    }

    public void computeGradients(PgVectorField[] pgVectorFieldArray, PgPolygon pgPolygon) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = pgPolygon.getDimOfVertices();
        for (n6 = 0; n6 < pgVectorFieldArray.length; ++n6) {
            if (pgVectorFieldArray[n6] == null) {
                pgVectorFieldArray[n6] = new PgVectorField(n7, 0);
            }
            if (pgVectorFieldArray[n6].getDimOfVectors() != n7) {
                pgVectorFieldArray[n6].setDimOfVectors(n7);
            }
            pgVectorFieldArray[n6].setGeometry((PgPointSet)pgPolygon);
        }
        n6 = pgPolygon.getNumVertices();
        PdVector[][] pdVectorArrayArray = new PdVector[pgVectorFieldArray.length][];
        for (n5 = 0; n5 < pgVectorFieldArray.length; ++n5) {
            pdVectorArrayArray[n5] = pgVectorFieldArray[n5].getVectors();
        }
        if (n6 < 3) {
            for (n5 = 0; n5 < pgVectorFieldArray.length; ++n5) {
                PdVector.setConstant((PdVector[])pdVectorArrayArray[n5], (PdVector)new PdVector(n7));
            }
            return;
        }
        PdVector[] pdVectorArray = pgPolygon.getVertices();
        if (pgPolygon.isClosed()) {
            n4 = 0;
            n3 = n6;
            n2 = n6 - 1;
            n = 1;
        } else {
            n4 = 1;
            n3 = n6 - 1;
            for (int i = 0; i < pgVectorFieldArray.length; ++i) {
                pdVectorArrayArray[i][0].setConstant(0.0);
            }
            n2 = 0;
            n = 2;
        }
        PdVector pdVector = null;
        if (this.m_energyType == 4) {
            pdVector = new PdVector(n6);
            this.computeCurvature(pdVector, pgPolygon);
        }
        PdVector pdVector2 = new PdVector(n7);
        PdVector pdVector3 = new PdVector(n7);
        for (int i = n4; i < n3; ++i) {
            pdVector2.sub(pdVectorArray[i], pdVectorArray[n2]);
            pdVector3.sub(pdVectorArray[i], pdVectorArray[n]);
            double d = pdVector2.length();
            double d2 = pdVector3.length();
            pdVectorArrayArray[3][i].blend(1.0 / d / d, pdVector2, 1.0 / d2 / d2, pdVector3);
            pdVectorArrayArray[3][i].multScalar(-PdVector.dot((PdVector)pdVector3, (PdVector)pdVector2));
            pdVectorArrayArray[3][i].add(pdVector3);
            pdVectorArrayArray[3][i].add(pdVector2);
            pdVectorArrayArray[3][i].multScalar(1.0 / d / d2 / 70.0);
            pdVectorArrayArray[4][i].copy(pdVectorArrayArray[3][i]);
            pdVectorArrayArray[4][i].normalize();
            if (4 == this.m_energyType) {
                double d3 = pdVector.getEntry((i - 1 + n6) % n6);
                double d4 = pdVector.getEntry(i);
                double d5 = pdVector.getEntry((i + 1) % n6);
                if (Math.abs(d3) < Math.abs(d4) && Math.abs(d4) > Math.abs(d5)) {
                    pdVectorArrayArray[4][i].setConstant(0.0);
                }
            }
            pdVectorArrayArray[2][i].add(pdVector2, pdVector3);
            pdVector2.normalize();
            pdVector3.normalize();
            pdVectorArrayArray[0][i].add(pdVector2, pdVector3);
            pdVector2.sub(pdVectorArray[n2], pdVectorArray[n]);
            pdVectorArrayArray[1][i].m_data[0] = -pdVector2.m_data[1] * 0.5;
            pdVectorArrayArray[1][i].m_data[1] = pdVector2.m_data[0] * 0.5;
            n2 = (n2 + 1) % n6;
            n = (n + 1) % n6;
        }
    }

    public PgVectorField getGradient(int n) {
        return this.m_vfGrad[n];
    }

    public float getStepSize() {
        return this.m_stepSize;
    }

    public void setStepSize(float f) {
        this.m_stepSize = f;
    }

    public int getNumSteps() {
        return this.m_numSteps;
    }

    public void setNumSteps(int n) {
        this.m_numSteps = n;
    }

    public void step() {
        PdVector[] pdVectorArray = this.m_vfGrad[this.m_energyType].getVectors();
        PdVector[] pdVectorArray2 = this.m_geom.getVertices();
        int n = this.m_geom.getNumVertices();
        for (int i = 0; i < this.m_numSteps; ++i) {
            for (int j = 0; j < n; ++j) {
                pdVectorArray2[j].blendBase(pdVectorArray2[j], (double)(-this.m_stepSize), pdVectorArray[j]);
            }
            this.computeGradients(this.m_vfGrad, this.m_geom);
        }
    }

    public boolean isEnabledMetricScale() {
        return this.m_bScale;
    }

    public void setEnabledMetricScale(boolean bl) {
        this.m_bScale = bl;
    }

    public boolean isEnabledColorByLength() {
        return this.m_bColorByLength;
    }

    public void setEnabledColorByLength(boolean bl) {
        this.m_bColorByLength = bl;
        this.m_geom.showEdgeColors(bl);
        this.m_curvPlot.showEdgeColors(bl);
    }

    public int getEnergy() {
        return this.m_energyType;
    }

    public void setEnergy(int n) {
        this.m_energyType = n;
    }

    public void minimize() {
        if (this.m_thread != null) {
            return;
        }
        this.m_thread = new Thread(this);
        this.m_bStop = false;
        this.m_thread.start();
    }

    public boolean isMinimize() {
        return this.m_thread != null;
    }

    public void stopMinimize() {
        this.m_bStop = true;
        this.m_thread = null;
    }

    public void run() {
        while (!this.m_bStop) {
            this.step();
            this.update(this.m_geom);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

