/*
 * Decompiled with CFR 0.152.
 */
package jvx.thirdParty.fonts;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import jv.object.PsConfig;
import jv.viewer.PvViewer;
import jvx.thirdParty.fonts.FontsCanvas;

public class SystemFonts
extends Applet
implements ActionListener {
    protected Frame m_frame;
    protected Button m_bQuit;
    protected Button m_bApply;
    protected FontsCanvas m_canvas;
    protected TextField m_tSize;
    protected int m_size;

    public SystemFonts() {
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 2));
        panel.add(new Label("Font Size"));
        this.m_tSize = new TextField(5);
        this.m_tSize.addActionListener(this);
        panel.add(this.m_tSize);
        this.add((Component)panel, "North");
        this.m_canvas = new FontsCanvas();
        this.add((Component)this.m_canvas, "Center");
        this.m_bApply = new Button("Apply");
        this.m_bApply.addActionListener(this);
        this.add((Component)this.m_bApply, "South");
        this.init();
    }

    public void init() {
        this.m_size = 16;
        ((TextComponent)this.m_tSize).setText("" + this.m_size);
        this.m_canvas.setSize(this.m_size);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (this.m_bQuit != null && object == this.m_bQuit) {
            this.m_frame.dispose();
            System.exit(0);
        } else if (this.m_bApply != null && object == this.m_bApply) {
            try {
                this.m_size = Integer.parseInt(this.m_tSize.getText());
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("SystemFonts.actionPerformed():  wrong format = " + this.m_tSize.getText());
            }
            PvViewer pvViewer = (PvViewer)PsConfig.getViewer();
            pvViewer.updateFonts(this.m_size);
        } else if (object == this.m_tSize) {
            try {
                this.m_size = Integer.parseInt(this.m_tSize.getText());
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("SystemFonts.actionPerformed():  wrong format = " + this.m_tSize.getText());
            }
            this.m_canvas.setSize(this.m_size);
        }
    }

    public void setFrame(Frame frame) {
        this.m_frame = frame;
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame("Font Example");
        SystemFonts systemFonts = new SystemFonts();
        systemFonts.m_bQuit = new Button("Quit");
        systemFonts.m_bQuit.addActionListener(systemFonts);
        systemFonts.add((Component)systemFonts.m_bQuit, "South");
        systemFonts.m_frame = frame;
        ((Component)frame).setSize(400, 700);
        frame.add((Component)systemFonts, "Center");
        ((Component)frame).setVisible(true);
    }
}

