/*
 * Decompiled with CFR 0.152.
 */
package jvx.loader;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.lang.constant.Constable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jv.geom.PgElementSet;
import jv.loader.PgAbstractLoader;
import jv.loader.PvDisplayOption;
import jv.number.PdColor;
import jv.number.PuDouble;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuReflect;
import jvx.geom.PwPlatonic;
import jvx.project.PjWorkshop;

public final class PgWrlLoader
extends PgAbstractLoader {
    private static final String StrSpace = " ";
    private static final String StrNL = "\n";
    private static final String Str1CBracket = "}\n";
    private static final String Str1Bracket = "]\n";
    private static final String StrNegOne = "-1";
    private static final String Str1Zero = "0";
    private static final String Str2Zero = "0 0";
    private static final String Str3Zero = "0 0 0";
    private static final String Str3One = "1 1 1";
    private static final String FALSE = "FALSE\n";
    private static final String TRUE = "TRUE\n";
    private static final int DEFAULT = 0;
    private static final int OVERALL = 1;
    private static final int PER_VERTEX = 2;
    private static final int PER_VERTEX_INDEXED = 3;
    private static final int PER_FACE = 4;
    private static final int PER_FACE_INDEXED = 5;
    private static final int PER_PART = 6;
    private static final int PER_PART_INDEXED = 7;
    private static final int UNKNOWN_ORDERING = 20;
    private static final int CLOCKWISE = 21;
    private static final int COUNTERCLOCKWISE = 22;
    private static final int UNKNOWN_SHAPE_TYPE = 23;
    private static final int SOLID = 24;
    private static final int CONVEX = 26;
    private boolean m_bVRML_1_MODE = false;
    protected String m_currentName;
    private Color m_colorDiffuse;
    private Color m_colorEmissive;
    private Color m_colorSpecular;
    private Double m_shininess;
    private Double m_transparency;
    private PdVector[] m_vertex;
    private Color[] m_color;
    private int m_normalBinding = 3;
    private double m_creaseAngle = 0.0;
    private Hashtable m_namedItems;
    private Hashtable m_geometries;

    public PgJvxSrc[] read(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            PsDebug.warning((String)"missing buffered reader");
            return null;
        }
        PgJvxSrc[] pgJvxSrcArray = this.parse(bufferedReader);
        if (pgJvxSrcArray == null) {
            PsDebug.warning((String)"error when parsing reader");
            return null;
        }
        return pgJvxSrcArray;
    }

    protected synchronized PgJvxSrc[] parse(BufferedReader bufferedReader) {
        Object object;
        try {
            object = bufferedReader.readLine();
            if (object == null || !((String)object).startsWith("#VRML")) {
                PsDebug.warning((String)"not a a VRML stream");
                return null;
            }
            if (((String)object).startsWith("#VRML V1.0")) {
                PsDebug.warning((String)"Parsing of VRML 1.0 format not fully supported.");
                this.m_bVRML_1_MODE = true;
            }
        }
        catch (IOException iOException) {
            PsDebug.warning((String)"Failed to parse header of VRML reader");
            return null;
        }
        object = new StreamTokenizer(bufferedReader);
        ((StreamTokenizer)object).eolIsSignificant(false);
        ((StreamTokenizer)object).commentChar(35);
        ((StreamTokenizer)object).ordinaryChar(34);
        ((StreamTokenizer)object).ordinaryChar(45);
        ((StreamTokenizer)object).ordinaryChar(43);
        ((StreamTokenizer)object).ordinaryChar(46);
        ((StreamTokenizer)object).ordinaryChars(48, 48);
        ((StreamTokenizer)object).ordinaryChars(49, 57);
        ((StreamTokenizer)object).wordChars(94, 94);
        ((StreamTokenizer)object).wordChars(38, 38);
        ((StreamTokenizer)object).wordChars(36, 36);
        ((StreamTokenizer)object).wordChars(40, 40);
        ((StreamTokenizer)object).wordChars(41, 41);
        ((StreamTokenizer)object).wordChars(126, 126);
        ((StreamTokenizer)object).wordChars(64, 64);
        ((StreamTokenizer)object).wordChars(45, 45);
        ((StreamTokenizer)object).wordChars(43, 43);
        ((StreamTokenizer)object).wordChars(42, 42);
        ((StreamTokenizer)object).wordChars(48, 48);
        ((StreamTokenizer)object).wordChars(49, 57);
        ((StreamTokenizer)object).wordChars(46, 46);
        ((StreamTokenizer)object).wordChars(44, 44);
        ((StreamTokenizer)object).wordChars(59, 59);
        ((StreamTokenizer)object).wordChars(95, 95);
        ((StreamTokenizer)object).wordChars(58, 58);
        ((StreamTokenizer)object).whitespaceChars(44, 44);
        ((StreamTokenizer)object).whitespaceChars(61, 61);
        this.m_namedItems = new Hashtable();
        this.m_geometries = new Hashtable();
        if (this.m_bVRML_1_MODE) {
            this.m_colorDiffuse = Color.white;
        }
        this.parseVrml((StreamTokenizer)object, null);
        PgJvxSrc[] pgJvxSrcArray = null;
        if (this.m_geometries.size() > 0) {
            pgJvxSrcArray = new PgJvxSrc[this.m_geometries.size()];
            int n = 0;
            Enumeration enumeration = this.m_geometries.elements();
            while (enumeration.hasMoreElements()) {
                pgJvxSrcArray[n++] = (PgJvxSrc)enumeration.nextElement();
            }
        }
        this.m_namedItems = null;
        this.m_geometries = null;
        if (this.m_bVRML_1_MODE) {
            this.m_bVRML_1_MODE = false;
            this.m_vertex = null;
            this.m_color = null;
            this.m_colorDiffuse = null;
            this.m_colorEmissive = null;
        }
        return pgJvxSrcArray;
    }

    private Hashtable parseVrml(StreamTokenizer streamTokenizer, Hashtable hashtable) {
        Hashtable<String, Hashtable> hashtable2 = new Hashtable<String, Hashtable>();
        try {
            while (true) {
                switch (streamTokenizer.nextToken()) {
                    default: {
                        throw new IOException(streamTokenizer.toString());
                    }
                    case -1: {
                        return hashtable2;
                    }
                    case -3: 
                }
                streamTokenizer.pushBack();
                Hashtable hashtable3 = this.parseSFNode(streamTokenizer);
                if (hashtable3 == null) continue;
                String string = (String)hashtable3.get("vrmlType");
                if (string != null) {
                    hashtable2.put(string, hashtable3);
                    continue;
                }
                PsDebug.warning((String)"missing vrml type.");
            }
        }
        catch (IOException iOException) {
            PsDebug.warning((Exception)iOException, (String)("Parsing broke abnormally\n\tIOException thrown e = " + iOException));
            return null;
        }
    }

    private static String[] parseMFString(StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.quoteChar(34);
        boolean bl = true;
        if (streamTokenizer.nextToken() != 91) {
            streamTokenizer.pushBack();
            bl = false;
        }
        Vector<String> vector = new Vector<String>();
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype != 34) {
            throw new IOException("missing quotes around first string.");
        }
        if (streamTokenizer.sval != null && !"".equals(streamTokenizer.sval)) {
            vector.addElement(streamTokenizer.sval);
        }
        while (streamTokenizer.nextToken() == 34) {
            if (streamTokenizer.sval == null || "".equals(streamTokenizer.sval)) continue;
            vector.addElement(streamTokenizer.sval);
        }
        streamTokenizer.pushBack();
        if (bl) {
            streamTokenizer.nextToken();
        }
        streamTokenizer.ordinaryChar(34);
        int n = vector.size();
        if (n == 0) {
            return new String[0];
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    private static String parseString(StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.quoteChar(34);
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype != 34) {
            throw new IOException("missing quotes around string.");
        }
        streamTokenizer.ordinaryChar(34);
        return streamTokenizer.sval;
    }

    private static String parseWord(StreamTokenizer streamTokenizer) throws IOException {
        if (streamTokenizer.nextToken() != -3) {
            return null;
        }
        return streamTokenizer.sval;
    }

    private static Boolean parseBoolean(StreamTokenizer streamTokenizer) throws IOException {
        if (streamTokenizer.nextToken() != -3) {
            return null;
        }
        return new Boolean(streamTokenizer.sval != null && streamTokenizer.sval.equalsIgnoreCase("true"));
    }

    private static Double parseDouble(StreamTokenizer streamTokenizer) throws IOException {
        if (streamTokenizer.nextToken() != -3) {
            return null;
        }
        return new Double(PuDouble.parseDouble((String)streamTokenizer.sval));
    }

    private static Integer parseInteger(StreamTokenizer streamTokenizer) throws IOException {
        if (streamTokenizer.nextToken() != -3) {
            return null;
        }
        try {
            return new Integer(Integer.parseInt(streamTokenizer.sval));
        }
        catch (NumberFormatException numberFormatException) {
            PsDebug.warning((String)("wrong format in integer string = " + streamTokenizer.sval));
            return null;
        }
    }

    private static Color parseColor(StreamTokenizer streamTokenizer) throws IOException {
        int n = 3;
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            if (streamTokenizer.nextToken() != -3) {
                return null;
            }
            fArray[i] = (float)PuDouble.parseDouble((String)streamTokenizer.sval);
        }
        return new Color(fArray[0], fArray[1], fArray[2]);
    }

    private static PdVector parsePdVector(StreamTokenizer streamTokenizer, int n) throws IOException {
        PdVector pdVector = new PdVector(n);
        try {
            for (int i = 0; i < n; ++i) {
                if (streamTokenizer.nextToken() != -3) {
                    return null;
                }
                double d = PuDouble.parseDouble((String)streamTokenizer.sval);
                pdVector.setEntry(i, d);
            }
            return pdVector;
        }
        catch (NumberFormatException numberFormatException) {
            PsDebug.warning((String)("wrong format in double string = " + streamTokenizer.sval));
            return null;
        }
    }

    private static PdVector parsePdVector(StreamTokenizer streamTokenizer) throws IOException {
        PdVector pdVector = new PdVector();
        try {
            int n = 0;
            while (true) {
                if (streamTokenizer.nextToken() != -3) {
                    streamTokenizer.pushBack();
                    if (n != 0) {
                        pdVector.setSize(n);
                        return pdVector;
                    }
                    return null;
                }
                double d = PuDouble.parseDouble((String)streamTokenizer.sval);
                pdVector.setEntry(n++, d);
            }
        }
        catch (NumberFormatException numberFormatException) {
            PsDebug.warning((String)("wrong format in double string = " + streamTokenizer.sval));
            return null;
        }
    }

    private static PiVector parseIntegerArray(StreamTokenizer streamTokenizer, int n) throws IOException {
        PiVector piVector = new PiVector(n);
        try {
            for (int i = 0; i < n; ++i) {
                int n2;
                if (streamTokenizer.nextToken() != -3) {
                    return null;
                }
                if (streamTokenizer.sval.charAt(1) == 'x') {
                    n2 = Integer.parseInt(streamTokenizer.sval.substring(2), 16);
                    piVector.setEntry(i, n2);
                    continue;
                }
                n2 = Integer.parseInt(streamTokenizer.sval);
                piVector.setEntry(i, n2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            PsDebug.warning((String)("wrong format in integer string = " + streamTokenizer.sval));
            return null;
        }
        return piVector;
    }

    private static PiVector parsePiVector(StreamTokenizer streamTokenizer, int n) throws IOException {
        PiVector piVector = new PiVector(n);
        try {
            int n2 = 0;
            while (true) {
                if (streamTokenizer.nextToken() != -3) {
                    if (n2 != 0) {
                        streamTokenizer.pushBack();
                        piVector.setSize(n2);
                        return piVector;
                    }
                    return null;
                }
                int n3 = Integer.parseInt(streamTokenizer.sval);
                if (n3 == -1) {
                    piVector.setSize(n2);
                    return piVector;
                }
                piVector.setEntry(n2++, n3);
            }
        }
        catch (NumberFormatException numberFormatException) {
            PsDebug.warning((String)("wrong format in integer string = " + streamTokenizer.sval));
            return null;
        }
    }

    private static PdVector[] parseVertexArray(StreamTokenizer streamTokenizer, int n) throws IOException {
        PdVector[] pdVectorArray = null;
        streamTokenizer.nextToken();
        String string = streamTokenizer.sval;
        if (string != null && (string.equals("point") || string.equals("vector"))) {
            streamTokenizer.nextToken();
            Vector<PdVector> vector = new Vector<PdVector>();
            PdVector pdVector = null;
            while ((pdVector = PgWrlLoader.parsePdVector(streamTokenizer, n)) != null) {
                vector.addElement(pdVector);
            }
            int n2 = vector.size();
            if (n2 != 0) {
                pdVectorArray = new PdVector[n2];
                for (int i = 0; i < n2; ++i) {
                    pdVectorArray[i] = (PdVector)vector.elementAt(i);
                }
            }
        } else {
            throw new IOException(streamTokenizer.toString());
        }
        return pdVectorArray;
    }

    private static Color[] parseMFColor(StreamTokenizer streamTokenizer) throws IOException {
        if (streamTokenizer.nextToken() != 91) {
            streamTokenizer.pushBack();
            Color color = PgWrlLoader.parseColor(streamTokenizer);
            if (color == null) {
                return null;
            }
            return new Color[]{color};
        }
        Vector<Color> vector = new Vector<Color>();
        Color color = null;
        while ((color = PgWrlLoader.parseColor(streamTokenizer)) != null) {
            vector.addElement(color);
        }
        int n = vector.size();
        if (n == 0) {
            return null;
        }
        Color[] colorArray = new Color[n];
        for (int i = 0; i < n; ++i) {
            colorArray[i] = (Color)vector.elementAt(i);
        }
        return colorArray;
    }

    private static PiVector[] parseElementArray(StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        Vector<PiVector> vector = new Vector<PiVector>();
        PiVector piVector = null;
        while ((piVector = PgWrlLoader.parsePiVector(streamTokenizer, 4)) != null) {
            vector.addElement(piVector);
        }
        int n = vector.size();
        if (n == 0) {
            return null;
        }
        PiVector[] piVectorArray = new PiVector[n];
        for (int i = 0; i < n; ++i) {
            piVectorArray[i] = (PiVector)vector.elementAt(i);
        }
        return piVectorArray;
    }

    private Hashtable parseIndexedFaceSet(String string, StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        if (!"IndexedFaceSet".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        streamTokenizer.nextToken();
        Color[] colorArray = null;
        PdVector[] pdVectorArray = null;
        PdVector[] pdVectorArray2 = null;
        PdVector[] pdVectorArray3 = null;
        PiVector[] piVectorArray = null;
        boolean bl = true;
        PiVector[] piVectorArray2 = null;
        double d = 0.0;
        PiVector[] piVectorArray3 = null;
        boolean bl2 = true;
        PiVector[] piVectorArray4 = null;
        if (this.m_bVRML_1_MODE) {
            boolean bl3 = bl2 = this.m_normalBinding == 2 || this.m_normalBinding == 3;
            if (this.m_creaseAngle != 0.0) {
                d = this.m_creaseAngle;
            }
        }
        PgJvxSrc pgJvxSrc = new PgJvxSrc();
        if (string != null) {
            pgJvxSrc.setName(string);
        }
        if (this.m_bVRML_1_MODE) {
            if (string != null) {
                this.m_currentName = null;
            }
            this.assignVRML1Globals(pgJvxSrc);
        }
        pgJvxSrc.setType(33);
        pgJvxSrc.showEdges(false);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        while (true) {
            String string2;
            if ((string2 = PgWrlLoader.parseWord(streamTokenizer)) == null) {
                int n;
                pgJvxSrc.setCreaseAngle(d);
                if (this.m_bVRML_1_MODE) {
                    if (this.m_vertex != null) {
                        pgJvxSrc.setNumVertices(this.m_vertex.length);
                        pgJvxSrc.setVertices(this.m_vertex);
                    }
                    if (piVectorArray2 != null) {
                        pgJvxSrc.setNumElements(piVectorArray2.length);
                        pgJvxSrc.setElements(piVectorArray2);
                    } else {
                        PsDebug.warning((String)"missing element array");
                    }
                    if (this.m_color != null) {
                        if (this.m_color.length == pgJvxSrc.getNumVertices()) {
                            pgJvxSrc.setVertexColors(this.m_color);
                            pgJvxSrc.showVertexColors(true);
                        } else if (this.m_color.length == pgJvxSrc.getNumElements()) {
                            pgJvxSrc.setElementColors(this.m_color);
                            pgJvxSrc.showElementColors(true);
                        } else {
                            PsDebug.warning((String)"length of color and vertex/element arrays differ");
                        }
                    } else if (this.m_colorDiffuse != null) {
                        pgJvxSrc.setGlobalElementColor(this.m_colorDiffuse);
                    } else if (this.m_colorEmissive != null) {
                        pgJvxSrc.setGlobalElementColor(this.m_colorEmissive);
                    }
                } else {
                    if (pdVectorArray != null) {
                        pgJvxSrc.setNumVertices(pdVectorArray.length);
                        pgJvxSrc.setVertices(pdVectorArray);
                    } else {
                        PsDebug.warning((String)"missing vertex array");
                    }
                    if (piVectorArray2 != null) {
                        pgJvxSrc.setNumElements(piVectorArray2.length);
                        pgJvxSrc.setElements(piVectorArray2);
                    } else {
                        PsDebug.warning((String)"missing element array");
                    }
                    if (colorArray != null) {
                        int n2;
                        Object[] objectArray;
                        n = pgJvxSrc.getNumElements();
                        if (!bl) {
                            if (piVectorArray != null) {
                                if (piVectorArray[0] != null && piVectorArray[0].getSize() >= n) {
                                    objectArray = new Color[n];
                                    for (n2 = 0; n2 < n; ++n2) {
                                        objectArray[n2] = colorArray[piVectorArray[0].m_data[n2]];
                                    }
                                    pgJvxSrc.setElementColors((Color[])objectArray);
                                    pgJvxSrc.showElementColors(true);
                                } else {
                                    PsDebug.warning((String)"colorIndex array missing or smaller than element array");
                                }
                            } else {
                                pgJvxSrc.setElementColors(colorArray);
                                pgJvxSrc.showElementColors(true);
                            }
                        } else {
                            objectArray = null;
                            objectArray = piVectorArray != null ? piVectorArray : piVectorArray2;
                            n2 = pgJvxSrc.getNumVertices();
                            if (objectArray != null) {
                                int n3;
                                int n4;
                                PiVector[] piVectorArray5 = PiVector.realloc(null, (int)n2, (int)3);
                                int[] nArray = new int[n2];
                                Color[] colorArray2 = new Color[n];
                                int[] nArray2 = new int[3];
                                int[] nArray3 = new int[3];
                                for (int i = 0; i < n; ++i) {
                                    for (n4 = 0; n4 < 3; ++n4) {
                                        nArray2[n4] = 0;
                                    }
                                    n4 = objectArray[i].getSize();
                                    for (n3 = 0; n3 < n4; ++n3) {
                                        int n5;
                                        int n6 = n5 = objectArray[i].m_data[n3];
                                        nArray[n6] = nArray[n6] + 1;
                                        int n7 = colorArray[n5].getRGB();
                                        nArray3[0] = n7 >> 16 & 0xFF;
                                        nArray3[1] = n7 >> 8 & 0xFF;
                                        nArray3[2] = n7 & 0xFF;
                                        for (int j = 0; j < 3; ++j) {
                                            int n8 = j;
                                            piVectorArray5[n5].m_data[n8] = piVectorArray5[n5].m_data[n8] + nArray3[j];
                                            int n9 = j;
                                            nArray2[n9] = nArray2[n9] + nArray3[j];
                                        }
                                    }
                                    for (n3 = 0; n3 < 3; ++n3) {
                                        nArray2[n3] = (int)((float)(nArray2[n3] / n4) + 0.5f);
                                    }
                                    colorArray2[i] = new Color(nArray2[0], nArray2[1], nArray2[2]);
                                }
                                pgJvxSrc.setElementColors(colorArray2);
                                pgJvxSrc.showElementColors(true);
                                Color[] colorArray3 = new Color[n2];
                                for (n4 = 0; n4 < n2; ++n4) {
                                    if (nArray[n4] == 0) continue;
                                    for (n3 = 0; n3 < 3; ++n3) {
                                        piVectorArray5[n4].m_data[n3] = (int)((float)piVectorArray5[n4].m_data[n3] / (float)nArray[n4] + 0.5f);
                                    }
                                    colorArray3[n4] = new Color(piVectorArray5[n4].m_data[0], piVectorArray5[n4].m_data[1], piVectorArray5[n4].m_data[2]);
                                }
                                pgJvxSrc.setVertexColors(colorArray3);
                            } else {
                                PsDebug.warning((String)"colorIndex array smaller than vertex array");
                            }
                            if (colorArray.length == n2) {
                                pgJvxSrc.setVertexColors(colorArray);
                                pgJvxSrc.showVertexColors(true);
                                pgJvxSrc.showSmoothElementColors(true);
                                pgJvxSrc.showElementFromVertexColors(true);
                            }
                        }
                    }
                    if (pdVectorArray3 != null) {
                        n = pgJvxSrc.getNumVertices();
                        int n10 = pgJvxSrc.getNumElements();
                        if (piVectorArray4 == null) {
                            if (pdVectorArray3.length >= n) {
                                pgJvxSrc.setVertexTextures(pdVectorArray3);
                                pgJvxSrc.showVertexTexture(true);
                            } else {
                                PsDebug.warning((String)"texCoord array smaller than number of vertices.");
                            }
                        } else if (piVectorArray4.length >= n10) {
                            PdVector[][] pdVectorArrayArray = new PdVector[n10][];
                            for (int i = 0; i < n10; ++i) {
                                int n11 = piVectorArray4[i].getSize();
                                pdVectorArrayArray[i] = new PdVector[n11];
                                for (int j = 0; j < n11; ++j) {
                                    pdVectorArrayArray[i][j] = pdVectorArray3[piVectorArray4[i].m_data[j]];
                                }
                            }
                            pgJvxSrc.setElementTextures((PdVector[][])pdVectorArrayArray);
                            pgJvxSrc.showElementTexture(true);
                        } else {
                            PsDebug.warning((String)"texCoordIndex array smaller than element array");
                        }
                    }
                }
                if (pdVectorArray2 != null) {
                    n = pgJvxSrc.getNumElements();
                    if (!bl2) {
                        if (piVectorArray3 != null) {
                            if (piVectorArray3[0] != null && piVectorArray3[0].getSize() >= n) {
                                PdVector[] pdVectorArray4 = PdVector.realloc(null, (int)n, (int)3);
                                for (int i = 0; i < n; ++i) {
                                    pdVectorArray4[i].copyArray(pdVectorArray2[piVectorArray3[0].m_data[i]]);
                                }
                                pgJvxSrc.setElementNormals(pdVectorArray4);
                            } else {
                                PsDebug.warning((String)"normalIndex array missing or smaller than element array");
                            }
                        } else {
                            pgJvxSrc.setElementNormals(pdVectorArray2);
                        }
                    } else if (piVectorArray3 != null) {
                        if (piVectorArray3.length >= n) {
                            PdVector[] pdVectorArray5 = PdVector.realloc(null, (int)n, (int)3);
                            for (int i = 0; i < n; ++i) {
                                int n12 = piVectorArray3[i].getSize();
                                for (int j = 0; j < n12; ++j) {
                                    pdVectorArray5[i].add(pdVectorArray2[piVectorArray3[i].m_data[j]]);
                                }
                                pdVectorArray5[i].normalize();
                            }
                            pgJvxSrc.setElementNormals(pdVectorArray5);
                        } else {
                            PsDebug.warning((String)"normalIndex array smaller than element array");
                        }
                    } else {
                        pgJvxSrc.setElementNormals(pdVectorArray2);
                    }
                }
                this.m_geometries.put(pgJvxSrc.getName(), pgJvxSrc);
                hashtable.put("geometry", pgJvxSrc);
                return hashtable;
            }
            if (string2.equals("coord")) {
                Hashtable hashtable2 = this.parseSFNode(streamTokenizer);
                if (hashtable2 == null) {
                    return null;
                }
                pdVectorArray = (PdVector[])hashtable2.get("point");
                continue;
            }
            if (string2.equals("coordIndex")) {
                piVectorArray2 = PgWrlLoader.parseElementArray(streamTokenizer);
                continue;
            }
            if (string2.equals("color")) {
                Hashtable hashtable3 = this.parseSFNode(streamTokenizer);
                if (hashtable3 == null) {
                    return null;
                }
                colorArray = (Color[])hashtable3.get("color");
                continue;
            }
            if (string2.equals("colorPerVertex")) {
                Boolean bl4 = PgWrlLoader.parseBoolean(streamTokenizer);
                bl = bl4;
                hashtable.put("colorPerVertex", bl4);
                continue;
            }
            if (string2.equals("colorIndex")) {
                if (!bl) {
                    piVectorArray = PiVector.realloc(null, (int)1);
                    int n = 1000;
                    if (piVectorArray2 != null) {
                        n = piVectorArray2.length;
                    }
                    streamTokenizer.nextToken();
                    piVectorArray[0] = PgWrlLoader.parseIntegerArray(streamTokenizer, n);
                    streamTokenizer.nextToken();
                    continue;
                }
                piVectorArray = PgWrlLoader.parseElementArray(streamTokenizer);
                continue;
            }
            if (string2.equals("normal")) {
                Hashtable hashtable4 = this.parseSFNode(streamTokenizer);
                if (hashtable4 == null) {
                    return null;
                }
                pdVectorArray2 = (PdVector[])hashtable4.get("vector");
                continue;
            }
            if (string2.equals("normalPerVertex")) {
                Boolean bl5 = PgWrlLoader.parseBoolean(streamTokenizer);
                bl2 = bl5;
                hashtable.put("normalPerVertex", bl5);
                continue;
            }
            if (string2.equals("normalIndex")) {
                if (!bl2) {
                    piVectorArray3 = PiVector.realloc(null, (int)1);
                    int n = 1000;
                    if (piVectorArray2 != null) {
                        n = piVectorArray2.length;
                    }
                    streamTokenizer.nextToken();
                    piVectorArray3[0] = PgWrlLoader.parseIntegerArray(streamTokenizer, n);
                    streamTokenizer.nextToken();
                    continue;
                }
                piVectorArray3 = PgWrlLoader.parseElementArray(streamTokenizer);
                continue;
            }
            if (string2.equals("texCoord")) {
                Hashtable hashtable5 = this.parseSFNode(streamTokenizer);
                if (hashtable5 == null) {
                    return null;
                }
                pdVectorArray3 = (PdVector[])hashtable5.get("point");
                if (pdVectorArray3 != null) continue;
                return null;
            }
            if (string2.equals("texCoordIndex")) {
                piVectorArray4 = PgWrlLoader.parseElementArray(streamTokenizer);
                continue;
            }
            if (string2.equals("ccw")) {
                Boolean bl6 = PgWrlLoader.parseBoolean(streamTokenizer);
                hashtable.put("ccw", bl6);
                continue;
            }
            if (string2.equals("convex")) {
                Boolean bl7 = PgWrlLoader.parseBoolean(streamTokenizer);
                hashtable.put("convex", bl7);
                continue;
            }
            if (string2.equals("creaseAngle")) {
                d = PgWrlLoader.parseDouble(streamTokenizer);
                continue;
            }
            if (string2.equals("solid")) {
                Boolean bl8 = PgWrlLoader.parseBoolean(streamTokenizer);
                hashtable.put("solid", bl8);
                continue;
            }
            streamTokenizer.pushBack();
            PgWrlLoader.parseUnknown(streamTokenizer);
        }
    }

    private Hashtable parseIndexedLineSet(String string, StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        if (!"IndexedLineSet".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        streamTokenizer.nextToken();
        Color[] colorArray = null;
        PdVector[] pdVectorArray = null;
        PiVector[] piVectorArray = null;
        boolean bl = true;
        PiVector[] piVectorArray2 = null;
        PgJvxSrc pgJvxSrc = new PgJvxSrc();
        if (string != null) {
            pgJvxSrc.setName(string);
        }
        if (this.m_bVRML_1_MODE) {
            if (string != null) {
                this.m_currentName = null;
            }
            this.assignVRML1Globals(pgJvxSrc);
        }
        pgJvxSrc.setType(32);
        pgJvxSrc.showEdges(true);
        pgJvxSrc.showPolygons(true);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        while (true) {
            String string2;
            if ((string2 = PgWrlLoader.parseWord(streamTokenizer)) == null) {
                if (this.m_bVRML_1_MODE) {
                    if (this.m_vertex != null) {
                        pgJvxSrc.setNumVertices(this.m_vertex.length);
                        pgJvxSrc.setVertices(this.m_vertex);
                    }
                    if (piVectorArray2 != null) {
                        pgJvxSrc.setNumPolygons(piVectorArray2.length);
                        pgJvxSrc.setPolygons(piVectorArray2);
                    } else {
                        PsDebug.warning((String)"missing polygon array in IndexedFaceSet");
                    }
                    if (this.m_color != null) {
                        if (this.m_color.length == pgJvxSrc.getNumVertices()) {
                            pgJvxSrc.setVertexColors(this.m_color);
                            pgJvxSrc.showVertexColors(true);
                        } else if (this.m_color.length == pgJvxSrc.getNumPolygons()) {
                            pgJvxSrc.setPolygonColors(this.m_color);
                            pgJvxSrc.showPolygonColors(true);
                        } else {
                            PsDebug.warning((String)"length of color and vertex/polygon arrays differ");
                        }
                    } else if (this.m_colorDiffuse != null) {
                        pgJvxSrc.setGlobalPolygonColor(this.m_colorDiffuse);
                    } else if (this.m_colorEmissive != null) {
                        pgJvxSrc.setGlobalPolygonColor(this.m_colorEmissive);
                    }
                } else {
                    if (pdVectorArray != null) {
                        pgJvxSrc.setNumVertices(pdVectorArray.length);
                        pgJvxSrc.setVertices(pdVectorArray);
                    } else {
                        PsDebug.warning((String)"missing vertex array");
                    }
                    if (piVectorArray2 != null) {
                        pgJvxSrc.setNumPolygons(piVectorArray2.length);
                        pgJvxSrc.setPolygons(piVectorArray2);
                    } else {
                        PsDebug.warning((String)"missing polygon array");
                    }
                    if (colorArray != null) {
                        int n = pgJvxSrc.getNumPolygons();
                        if (!bl) {
                            if (piVectorArray != null) {
                                if (piVectorArray[0] != null && piVectorArray[0].getSize() >= n) {
                                    Color[] colorArray2 = new Color[n];
                                    for (int i = 0; i < n; ++i) {
                                        colorArray2[i] = colorArray[piVectorArray[0].m_data[i]];
                                    }
                                    pgJvxSrc.setPolygonColors(colorArray2);
                                    pgJvxSrc.showPolygonColors(true);
                                } else {
                                    PsDebug.warning((String)"colorIndex array missing or smaller than polygon array");
                                }
                            } else {
                                pgJvxSrc.setPolygonColors(colorArray);
                                pgJvxSrc.showPolygonColors(true);
                            }
                        } else if (piVectorArray != null) {
                            if (piVectorArray.length >= n) {
                                Color[] colorArray3 = new Color[n];
                                for (int i = 0; i < n; ++i) {
                                    float f = 0.0f;
                                    float f2 = 0.0f;
                                    float f3 = 0.0f;
                                    int n2 = piVectorArray[i].getSize();
                                    for (int j = 0; j < n2; ++j) {
                                        f += (float)colorArray[piVectorArray[i].m_data[j]].getRed();
                                        f2 += (float)colorArray[piVectorArray[i].m_data[j]].getGreen();
                                        f3 += (float)colorArray[piVectorArray[i].m_data[j]].getBlue();
                                    }
                                    colorArray3[i] = new Color(f /= (float)(n2 * 255), f2 /= (float)(n2 * 255), f3 /= (float)(n2 * 255));
                                }
                                pgJvxSrc.setPolygonColors(colorArray3);
                                pgJvxSrc.showPolygonColors(true);
                            } else {
                                PsDebug.warning((String)"colorIndex array smaller than element array");
                            }
                        } else {
                            pgJvxSrc.setPolygonColors(colorArray);
                            pgJvxSrc.showPolygonColors(true);
                            pgJvxSrc.showSmoothElementColors(true);
                            pgJvxSrc.showElementFromVertexColors(true);
                        }
                    }
                }
                this.m_geometries.put(pgJvxSrc.getName(), pgJvxSrc);
                hashtable.put("geometry", pgJvxSrc);
                return hashtable;
            }
            if (string2.equals("coord")) {
                Hashtable hashtable2 = this.parseSFNode(streamTokenizer);
                if (hashtable2 == null) {
                    return null;
                }
                pdVectorArray = (PdVector[])hashtable2.get("point");
                continue;
            }
            if (string2.equals("coordIndex")) {
                piVectorArray2 = PgWrlLoader.parseElementArray(streamTokenizer);
                continue;
            }
            if (string2.equals("color")) {
                Hashtable hashtable3 = this.parseSFNode(streamTokenizer);
                if (hashtable3 == null) {
                    return null;
                }
                colorArray = (Color[])hashtable3.get("color");
                continue;
            }
            if (string2.equals("colorPerVertex")) {
                Boolean bl2 = PgWrlLoader.parseBoolean(streamTokenizer);
                bl = bl2;
                hashtable.put("colorPerVertex", bl2);
                continue;
            }
            if (string2.equals("colorIndex")) {
                if (!bl) {
                    piVectorArray = PiVector.realloc(null, (int)1);
                    int n = 1000;
                    if (pdVectorArray != null) {
                        n = piVectorArray2.length;
                    }
                    streamTokenizer.nextToken();
                    piVectorArray[0] = PgWrlLoader.parseIntegerArray(streamTokenizer, n);
                    streamTokenizer.nextToken();
                    continue;
                }
                piVectorArray = PgWrlLoader.parseElementArray(streamTokenizer);
                continue;
            }
            streamTokenizer.pushBack();
            PgWrlLoader.parseUnknown(streamTokenizer);
        }
    }

    private Hashtable parsePointSet(String string, StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        if (!"PointSet".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        streamTokenizer.nextToken();
        Color[] colorArray = null;
        PdVector[] pdVectorArray = null;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        while (true) {
            Object object;
            String string2;
            if ((string2 = PgWrlLoader.parseWord(streamTokenizer)) == null) {
                object = new PgJvxSrc();
                if (string != null) {
                    object.setName(string);
                }
                if (this.m_bVRML_1_MODE) {
                    if (string != null) {
                        this.m_currentName = null;
                    }
                    this.assignVRML1Globals((PgJvxSrc)object);
                }
                object.setType(30);
                object.showVertices(true);
                if (this.m_bVRML_1_MODE) {
                    pdVectorArray = this.m_vertex;
                    colorArray = this.m_color;
                    if (this.m_colorDiffuse != null) {
                        object.setGlobalVertexColor(this.m_colorDiffuse);
                    } else if (this.m_colorEmissive != null) {
                        object.setGlobalVertexColor(this.m_colorEmissive);
                    }
                }
                if (pdVectorArray != null) {
                    object.setNumVertices(pdVectorArray.length);
                    object.setVertices(pdVectorArray);
                } else {
                    PsDebug.warning((String)"missing vertex array");
                }
                if (colorArray != null) {
                    if (colorArray.length < object.getNumVertices()) {
                        PsDebug.warning((String)"color array smaller than vertex array");
                    } else {
                        object.setVertexColors(colorArray);
                        object.showVertexColors(true);
                    }
                }
                this.m_geometries.put(object.getName(), object);
                hashtable.put("geometry", object);
                return hashtable;
            }
            if (string2.equals("coord")) {
                object = this.parseSFNode(streamTokenizer);
                if (object == null) {
                    return null;
                }
                pdVectorArray = (PdVector[])((Hashtable)object).get("point");
                continue;
            }
            if (string2.equals("color")) {
                object = this.parseSFNode(streamTokenizer);
                if (object == null) {
                    return null;
                }
                colorArray = (Color[])((Hashtable)object).get("color");
                continue;
            }
            streamTokenizer.pushBack();
            PgWrlLoader.parseUnknown(streamTokenizer);
        }
    }

    private Hashtable parseElevationGrid(String string, StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        if (!"ElevationGrid".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        streamTokenizer.nextToken();
        Color[] colorArray = null;
        PdVector[] pdVectorArray = null;
        PdVector[] pdVectorArray2 = null;
        PdVector pdVector = null;
        boolean bl = true;
        boolean bl2 = true;
        int n = 0;
        double d = 0.0;
        int n2 = 0;
        double d2 = 0.0;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        while (true) {
            String string2;
            if ((string2 = PgWrlLoader.parseWord(streamTokenizer)) == null) {
                int n3;
                if (n < 2 || n2 < 2) {
                    PsDebug.warning((String)"dimension too small, no grid allocated");
                    return null;
                }
                PgElementSet pgElementSet = new PgElementSet(3);
                if (string != null) {
                    pgElementSet.setName(string);
                }
                if (this.m_bVRML_1_MODE) {
                    if (string != null) {
                        this.m_currentName = null;
                    }
                    this.assignVRML1Globals(pgElementSet);
                }
                pgElementSet.setType(33);
                int n4 = n * n2;
                pgElementSet.setNumVertices(n4);
                int n5 = 0;
                for (n3 = 0; n3 < n2; ++n3) {
                    for (int i = 0; i < n; ++i) {
                        pgElementSet.setVertex(n5, d * (double)i, pdVector.getEntry(n5), d2 * (double)n3);
                        ++n5;
                    }
                }
                n3 = (n2 - 1) * (n - 1);
                pgElementSet.setNumElements(n3);
                pgElementSet.setDimOfElements(4);
                pgElementSet.showEdges(false);
                pgElementSet.makeQuadrConn(n2, n);
                if (colorArray != null) {
                    if (!bl) {
                        pgElementSet.setElementColors(colorArray);
                        pgElementSet.showElementColors(true);
                    } else {
                        pgElementSet.setVertexColors(colorArray);
                        pgElementSet.showVertexColors(true);
                        Color[] colorArray2 = new Color[n3];
                        float[] fArray = new float[3];
                        int[] nArray = new int[3];
                        int n6 = 4;
                        for (int i = 0; i < n3; ++i) {
                            int n7;
                            for (int j = 0; j < 3; ++j) {
                                fArray[j] = 0.0f;
                            }
                            PiVector piVector = pgElementSet.getElement(i);
                            for (n7 = 0; n7 < n6; ++n7) {
                                int n8 = piVector.m_data[n7];
                                int n9 = colorArray[n8].getRGB();
                                nArray[0] = n9 >> 16 & 0xFF;
                                nArray[1] = n9 >> 8 & 0xFF;
                                nArray[2] = n9 & 0xFF;
                                for (int j = 0; j < 3; ++j) {
                                    int n10 = j;
                                    fArray[n10] = fArray[n10] + (float)nArray[j];
                                }
                            }
                            n7 = 0;
                            while (n7 < 3) {
                                int n11 = n7++;
                                fArray[n11] = fArray[n11] / (float)(n6 * 255);
                            }
                            colorArray2[i] = new Color(fArray[0], fArray[1], fArray[2]);
                        }
                        pgElementSet.setElementColors(colorArray2);
                        pgElementSet.showElementColors(true);
                        pgElementSet.showSmoothElementColors(true);
                        pgElementSet.showElementFromVertexColors(true);
                    }
                }
                if (pdVectorArray != null) {
                    if (bl2) {
                        pgElementSet.setVertexNormals(pdVectorArray);
                    } else {
                        pgElementSet.setElementNormals(pdVectorArray);
                    }
                }
                if (pdVectorArray2 != null) {
                    if (pdVectorArray2.length >= n4) {
                        pgElementSet.setVertexTextures(pdVectorArray2);
                        pgElementSet.showVertexTexture(true);
                    } else {
                        PsDebug.warning((String)"texCoord array smaller than number of vertices.");
                    }
                }
                PgJvxSrc pgJvxSrc = pgElementSet.getJvx();
                this.m_geometries.put(pgElementSet.getName(), pgJvxSrc);
                hashtable.put("geometry", pgJvxSrc);
                return hashtable;
            }
            if (string2.equals("color")) {
                Hashtable hashtable2 = this.parseSFNode(streamTokenizer);
                if (hashtable2 == null) {
                    return null;
                }
                colorArray = (Color[])hashtable2.get("color");
                continue;
            }
            if (string2.equals("normal")) {
                Hashtable hashtable3 = this.parseSFNode(streamTokenizer);
                if (hashtable3 == null) {
                    return null;
                }
                pdVectorArray = (PdVector[])hashtable3.get("vector");
                continue;
            }
            if (string2.equals("texCoord")) {
                Hashtable hashtable4 = this.parseSFNode(streamTokenizer);
                if (hashtable4 == null) {
                    return null;
                }
                pdVectorArray2 = (PdVector[])hashtable4.get("point");
                if (pdVectorArray2 != null) continue;
                return null;
            }
            if (string2.equals("height")) {
                streamTokenizer.nextToken();
                if (n > 0 && n2 > 0) {
                    int n12 = n * n2;
                    pdVector = PgWrlLoader.parsePdVector(streamTokenizer, n12);
                } else {
                    pdVector = PgWrlLoader.parsePdVector(streamTokenizer);
                }
                streamTokenizer.nextToken();
                if (pdVector != null) continue;
                return null;
            }
            if (string2.equals("ccw")) {
                Boolean bl3 = PgWrlLoader.parseBoolean(streamTokenizer);
                hashtable.put("ccw", bl3);
                continue;
            }
            if (string2.equals("colorPerVertex")) {
                Boolean bl4 = PgWrlLoader.parseBoolean(streamTokenizer);
                bl = bl4;
                hashtable.put("colorPerVertex", bl4);
                continue;
            }
            if (string2.equals("creaseAngle")) {
                PgWrlLoader.parseDouble(streamTokenizer);
                continue;
            }
            if (string2.equals("normalPerVertex")) {
                Boolean bl5 = PgWrlLoader.parseBoolean(streamTokenizer);
                bl2 = bl5;
                hashtable.put("normalPerVertex", bl5);
                continue;
            }
            if (string2.equals("solid")) {
                Boolean bl6 = PgWrlLoader.parseBoolean(streamTokenizer);
                hashtable.put("solid", bl6);
                continue;
            }
            if (string2.equals("xDimension")) {
                n = PgWrlLoader.parseInteger(streamTokenizer);
                continue;
            }
            if (string2.equals("xSpacing")) {
                d = PgWrlLoader.parseDouble(streamTokenizer);
                continue;
            }
            if (string2.equals("zDimension")) {
                n2 = PgWrlLoader.parseInteger(streamTokenizer);
                continue;
            }
            if (string2.equals("zSpacing")) {
                d2 = PgWrlLoader.parseDouble(streamTokenizer);
                continue;
            }
            streamTokenizer.pushBack();
            PgWrlLoader.parseUnknown(streamTokenizer);
        }
    }

    private Hashtable parseBox(String string, StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        if (!"Box".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        streamTokenizer.nextToken();
        PdVector pdVector = new PdVector(2.0, 2.0, 2.0);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        while (true) {
            String string2;
            if ((string2 = PgWrlLoader.parseWord(streamTokenizer)) == null) {
                PwPlatonic pwPlatonic = new PwPlatonic();
                pwPlatonic.setSolidType(1);
                pwPlatonic.compute();
                PgElementSet pgElementSet = (PgElementSet)pwPlatonic.getGeometry();
                PdVector[] pdVectorArray = pgElementSet.getBounds();
                PdVector pdVector2 = PdVector.subNew((PdVector)pdVectorArray[1], (PdVector)pdVectorArray[0]);
                PdMatrix pdMatrix = new PdMatrix(4);
                pdMatrix.setIdentity();
                for (int i = 0; i < 3; ++i) {
                    pdMatrix.setEntry(i, i, pdVector.getEntry(i) / pdVector2.getEntry(i));
                }
                pgElementSet.setModelMatrix(pdMatrix);
                pgElementSet.applyModelingMatrix();
                pgElementSet.setModelMatrix(null);
                PgJvxSrc pgJvxSrc = pgElementSet.getJvx();
                if (string != null) {
                    pgJvxSrc.setName(string);
                }
                if (this.m_bVRML_1_MODE) {
                    if (string != null) {
                        this.m_currentName = null;
                    }
                    this.assignVRML1Globals(pgJvxSrc);
                }
                pgJvxSrc.setType(33);
                pgJvxSrc.showEdges(false);
                this.m_geometries.put(pgJvxSrc.getName(), pgJvxSrc);
                hashtable.put("geometry", pgJvxSrc);
                return hashtable;
            }
            if (string2.equals("size")) {
                pdVector = PgWrlLoader.parsePdVector(streamTokenizer, 3);
                hashtable.put("size", pdVector);
                continue;
            }
            streamTokenizer.pushBack();
            PgWrlLoader.parseUnknown(streamTokenizer);
        }
    }

    private Hashtable parseCube(String string, StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        if (!"Cube".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        streamTokenizer.nextToken();
        PdVector pdVector = new PdVector(2.0, 2.0, 2.0);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        while (true) {
            Object object;
            String string2;
            if ((string2 = PgWrlLoader.parseWord(streamTokenizer)) == null) {
                object = new PwPlatonic();
                ((PwPlatonic)((Object)object)).setSolidType(1);
                ((PwPlatonic)((Object)object)).compute();
                PgElementSet pgElementSet = (PgElementSet)((PjWorkshop)((Object)object)).getGeometry();
                PdVector[] pdVectorArray = pgElementSet.getBounds();
                PdVector pdVector2 = PdVector.subNew((PdVector)pdVectorArray[1], (PdVector)pdVectorArray[0]);
                PdMatrix pdMatrix = new PdMatrix(4);
                pdMatrix.setIdentity();
                for (int i = 0; i < 3; ++i) {
                    pdMatrix.setEntry(i, i, pdVector.getEntry(i) / pdVector2.getEntry(i));
                }
                pgElementSet.setModelMatrix(pdMatrix);
                pgElementSet.applyModelingMatrix();
                pgElementSet.setModelMatrix(null);
                PgJvxSrc pgJvxSrc = pgElementSet.getJvx();
                if (string != null) {
                    pgJvxSrc.setName(string);
                }
                if (this.m_bVRML_1_MODE) {
                    if (string != null) {
                        this.m_currentName = null;
                    }
                    this.assignVRML1Globals(pgJvxSrc);
                }
                pgJvxSrc.setType(33);
                pgJvxSrc.showEdges(false);
                this.m_geometries.put(pgJvxSrc.getName(), pgJvxSrc);
                hashtable.put("geometry", pgJvxSrc);
                return hashtable;
            }
            if (string2.equals("width")) {
                object = PgWrlLoader.parseDouble(streamTokenizer);
                pdVector.setEntry(0, ((Double)object).doubleValue());
                hashtable.put("width", object);
                continue;
            }
            if (string2.equals("height")) {
                object = PgWrlLoader.parseDouble(streamTokenizer);
                pdVector.setEntry(1, ((Double)object).doubleValue());
                hashtable.put("height", object);
                continue;
            }
            if (string2.equals("depth")) {
                object = PgWrlLoader.parseDouble(streamTokenizer);
                pdVector.setEntry(2, ((Double)object).doubleValue());
                hashtable.put("depth", object);
                continue;
            }
            streamTokenizer.pushBack();
            PgWrlLoader.parseUnknown(streamTokenizer);
        }
    }

    private Hashtable parseCone(String string, StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        if (!"Cone".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        streamTokenizer.nextToken();
        double d = 1.0;
        double d2 = 2.0;
        boolean bl = true;
        boolean bl2 = true;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        while (true) {
            Constable constable;
            String string2;
            if ((string2 = PgWrlLoader.parseWord(streamTokenizer)) == null) {
                PdMatrix pdMatrix;
                if (!bl && !bl2) {
                    PsDebug.warning((String)"cone has no visible faces, no cone allocated.");
                    return hashtable;
                }
                constable = null;
                PgElementSet pgElementSet = null;
                PgElementSet pgElementSet2 = null;
                if (bl) {
                    pgElementSet = new PgElementSet(3);
                    pgElementSet.computeCone(17, 2, d, d2);
                }
                if (bl2) {
                    pgElementSet2 = new PgElementSet(3);
                    pgElementSet2.computeDisk(2, 17, d);
                    pgElementSet2.flipOrientation();
                    pdMatrix = new PdMatrix(4);
                    pdMatrix.setIdentity();
                    pdMatrix.setEntry(2, 3, -d2 / 2.0);
                    pgElementSet2.setModelMatrix(pdMatrix);
                    pgElementSet2.applyModelingMatrix();
                    pgElementSet2.setModelMatrix(null);
                }
                if (bl && bl2) {
                    pgElementSet.merge((PgGeometryIf)pgElementSet2);
                    pgElementSet.close();
                    constable = pgElementSet;
                } else if (bl) {
                    constable = pgElementSet;
                } else if (bl2) {
                    constable = pgElementSet2;
                }
                pdMatrix = PuReflect.rotateLine((PdVector)new PdVector(0.0, 0.0, 0.0), (PdVector)new PdVector(1.0, 0.0, 0.0), (double)-1.5707963267948966);
                constable.setModelMatrix(pdMatrix);
                constable.applyModelingMatrix();
                constable.setModelMatrix(null);
                PgJvxSrc pgJvxSrc = constable.getJvx();
                if (string != null) {
                    pgJvxSrc.setName(string);
                }
                if (this.m_bVRML_1_MODE) {
                    if (string != null) {
                        this.m_currentName = null;
                    }
                    this.assignVRML1Globals(pgJvxSrc);
                }
                pgJvxSrc.setType(33);
                pgJvxSrc.showEdges(false);
                this.m_geometries.put(pgJvxSrc.getName(), pgJvxSrc);
                hashtable.put("geometry", pgJvxSrc);
                return hashtable;
            }
            if (string2.equals("bottomRadius")) {
                constable = PgWrlLoader.parseDouble(streamTokenizer);
                d = (Double)constable;
                hashtable.put("bottomRadius", constable);
                continue;
            }
            if (string2.equals("height")) {
                constable = PgWrlLoader.parseDouble(streamTokenizer);
                d2 = (Double)constable;
                hashtable.put("height", constable);
                continue;
            }
            if (string2.equals("side")) {
                constable = PgWrlLoader.parseBoolean(streamTokenizer);
                bl = (Boolean)constable;
                hashtable.put("side", constable);
                continue;
            }
            if (string2.equals("bottom")) {
                constable = PgWrlLoader.parseBoolean(streamTokenizer);
                bl2 = (Boolean)constable;
                hashtable.put("bottom", constable);
                continue;
            }
            streamTokenizer.pushBack();
            PgWrlLoader.parseUnknown(streamTokenizer);
        }
    }

    private Hashtable parseCylinder(String string, StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        if (!"Cylinder".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        streamTokenizer.nextToken();
        double d = 1.0;
        double d2 = 2.0;
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        while (true) {
            Constable constable;
            String string2;
            if ((string2 = PgWrlLoader.parseWord(streamTokenizer)) == null) {
                PdMatrix pdMatrix;
                if (!(bl || bl2 || bl3)) {
                    PsDebug.warning((String)"cylinder has no visible faces, no cylinder allocated.");
                    return hashtable;
                }
                constable = null;
                PgElementSet pgElementSet = null;
                PgElementSet pgElementSet2 = null;
                PgElementSet pgElementSet3 = null;
                if (bl) {
                    pgElementSet = new PgElementSet(3);
                    pgElementSet.computeCylinder(17, 2, d, d2);
                }
                if (bl2) {
                    pgElementSet2 = new PgElementSet(3);
                    pgElementSet2.computeDisk(2, 17, d);
                    pgElementSet2.flipOrientation();
                    pdMatrix = new PdMatrix(4);
                    pdMatrix.setIdentity();
                    pdMatrix.setEntry(2, 3, -d2 / 2.0);
                    pgElementSet2.setModelMatrix(pdMatrix);
                    pgElementSet2.applyModelingMatrix();
                    pgElementSet2.setModelMatrix(null);
                }
                if (bl3) {
                    pgElementSet3 = new PgElementSet(3);
                    pgElementSet3.computeDisk(2, 17, d);
                    pdMatrix = new PdMatrix(4);
                    pdMatrix.setIdentity();
                    pdMatrix.setEntry(2, 3, d2 / 2.0);
                    pgElementSet3.setModelMatrix(pdMatrix);
                    pgElementSet3.applyModelingMatrix();
                    pgElementSet3.setModelMatrix(null);
                }
                if (bl) {
                    constable = pgElementSet;
                    if (bl2) {
                        constable.merge((PgGeometryIf)pgElementSet2);
                    }
                    if (bl3) {
                        constable.merge((PgGeometryIf)pgElementSet3);
                    }
                } else if (bl2) {
                    constable = pgElementSet2;
                    if (bl3) {
                        constable.merge((PgGeometryIf)pgElementSet3);
                    }
                } else {
                    constable = pgElementSet3;
                }
                constable.close();
                pdMatrix = PuReflect.rotateLine((PdVector)new PdVector(0.0, 0.0, 0.0), (PdVector)new PdVector(1.0, 0.0, 0.0), (double)-1.5707963267948966);
                constable.setModelMatrix(pdMatrix);
                constable.applyModelingMatrix();
                constable.setModelMatrix(null);
                PgJvxSrc pgJvxSrc = constable.getJvx();
                if (string != null) {
                    pgJvxSrc.setName(string);
                }
                if (this.m_bVRML_1_MODE) {
                    if (string != null) {
                        this.m_currentName = null;
                    }
                    this.assignVRML1Globals(pgJvxSrc);
                }
                pgJvxSrc.setType(33);
                pgJvxSrc.showEdges(false);
                this.m_geometries.put(pgJvxSrc.getName(), pgJvxSrc);
                hashtable.put("geometry", pgJvxSrc);
                return hashtable;
            }
            if (string2.equals("radius")) {
                constable = PgWrlLoader.parseDouble(streamTokenizer);
                d = (Double)constable;
                hashtable.put("radius", constable);
                continue;
            }
            if (string2.equals("height")) {
                constable = PgWrlLoader.parseDouble(streamTokenizer);
                d2 = (Double)constable;
                hashtable.put("height", constable);
                continue;
            }
            if (string2.equals("side")) {
                constable = PgWrlLoader.parseBoolean(streamTokenizer);
                bl = (Boolean)constable;
                hashtable.put("side", constable);
                continue;
            }
            if (string2.equals("bottom")) {
                constable = PgWrlLoader.parseBoolean(streamTokenizer);
                bl2 = (Boolean)constable;
                hashtable.put("bottom", constable);
                continue;
            }
            if (string2.equals("top")) {
                constable = PgWrlLoader.parseBoolean(streamTokenizer);
                bl3 = (Boolean)constable;
                hashtable.put("top", constable);
                continue;
            }
            streamTokenizer.pushBack();
            PgWrlLoader.parseUnknown(streamTokenizer);
        }
    }

    private Hashtable parseSphere(String string, StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        if (!"Sphere".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        streamTokenizer.nextToken();
        double d = 1.0;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        while (true) {
            Object object;
            String string2;
            if ((string2 = PgWrlLoader.parseWord(streamTokenizer)) == null) {
                object = new PgElementSet(3);
                object.computeSphere(17, 9, d);
                PgJvxSrc pgJvxSrc = object.getJvx();
                if (string != null) {
                    pgJvxSrc.setName(string);
                }
                if (this.m_bVRML_1_MODE) {
                    if (string != null) {
                        this.m_currentName = null;
                    }
                    this.assignVRML1Globals(pgJvxSrc);
                }
                pgJvxSrc.setType(33);
                pgJvxSrc.showEdges(false);
                this.m_geometries.put(pgJvxSrc.getName(), pgJvxSrc);
                hashtable.put("geometry", pgJvxSrc);
                return hashtable;
            }
            if (string2.equals("radius")) {
                object = PgWrlLoader.parseDouble(streamTokenizer);
                d = (Double)object;
                hashtable.put("radius", object);
                continue;
            }
            streamTokenizer.pushBack();
            PgWrlLoader.parseUnknown(streamTokenizer);
        }
    }

    private Hashtable parseShapeHints(StreamTokenizer streamTokenizer) throws IOException {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        streamTokenizer.nextToken();
        if (!"ShapeHints".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        streamTokenizer.nextToken();
        int n = 20;
        int n2 = 23;
        int n3 = 26;
        double d = 0.5;
        String string;
        while ((string = PgWrlLoader.parseWord(streamTokenizer)) != null) {
            Object object;
            if (string.equals("vertexOrdering")) {
                object = PgWrlLoader.parseWord(streamTokenizer);
                if ("CLOCKWISE".equals(object)) {
                    n = 21;
                } else if ("COUNTERCLOCKWISE".equals(object)) {
                    n = 22;
                }
                hashtable.put("vertexOrdering", new Integer(n));
                continue;
            }
            if (string.equals("shapeType")) {
                object = PgWrlLoader.parseWord(streamTokenizer);
                if ("SOLID".equals(object)) {
                    n2 = 24;
                }
                hashtable.put("shapeType", new Integer(n2));
                continue;
            }
            if (string.equals("faceType")) {
                object = PgWrlLoader.parseWord(streamTokenizer);
                if ("CONVEX".equals(object)) {
                    n3 = 26;
                }
                hashtable.put("faceType", new Integer(n3));
                continue;
            }
            if (!string.equals("creaseAngle")) continue;
            object = PgWrlLoader.parseDouble(streamTokenizer);
            this.m_creaseAngle = d = ((Double)object).doubleValue();
            hashtable.put("creaseAngle", object);
        }
        return hashtable;
    }

    private Hashtable parseOrthographicCamera(String string, StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        if (!"OrthographicCamera".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        streamTokenizer.nextToken();
        if (this.m_displayOption == null) {
            this.m_displayOption = new PvDisplayOption();
        }
        PdVector pdVector = new PdVector(0.0, 0.0, 1.0);
        PdMatrix pdMatrix = new PdMatrix(4);
        pdMatrix.setIdentity();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        while (true) {
            Object object;
            String string2;
            if ((string2 = PgWrlLoader.parseWord(streamTokenizer)) == null) {
                object = new PdVector(0.0, 1.0, 0.0);
                PdVector pdVector2 = new PdVector(0.0, 0.0, -1.0);
                object.leftMultMatrix(pdMatrix);
                pdVector2.leftMultMatrix(pdMatrix);
                PdVector pdVector3 = PdVector.addNew((PdVector)pdVector, (PdVector)pdVector2);
                PdVector pdVector4 = new PdVector(0.0, 0.0, 1.0);
                PdVector pdVector5 = pdVector4.orthogonalPart(null, pdVector2);
                double d = PdVector.angleWithOrientation((PdVector)object, (PdVector)pdVector5, (PdVector)pdVector2) * 180.0 / Math.PI;
                int n = this.m_displayOption.getNumCameras();
                this.m_displayOption.setNumCameras(n + 1);
                if (string != null) {
                    this.m_displayOption.setCameraName(n, string);
                }
                this.m_displayOption.setCameraProjection(n, 1);
                this.m_displayOption.setCameraInterest(n, pdVector3);
                this.m_displayOption.setCameraPosition(n, pdVector);
                this.m_displayOption.setCameraFieldOfView(n, 0.0);
                this.m_displayOption.setCameraRoll(n, d);
                return hashtable;
            }
            if (string2.equals("position")) {
                pdVector = PgWrlLoader.parsePdVector(streamTokenizer, 3);
                hashtable.put("position", pdVector);
                continue;
            }
            if (string2.equals("orientation")) {
                double d;
                object = PgWrlLoader.parsePdVector(streamTokenizer, 3);
                if (!PuReflect.makeRotation((PdMatrix)pdMatrix, (PdVector)object, (double)(d = PgWrlLoader.parseDouble(streamTokenizer).doubleValue()))) continue;
                hashtable.put("rotation", pdMatrix);
                continue;
            }
            if (string2.equals("focalDistance")) {
                object = PgWrlLoader.parseDouble(streamTokenizer);
                hashtable.put("focalDistance", object);
                continue;
            }
            if (!string2.equals("height")) continue;
            object = PgWrlLoader.parseDouble(streamTokenizer);
            hashtable.put("height", object);
        }
    }

    private Hashtable parsePerspectiveCamera(String string, StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        if (!"PerspectiveCamera".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        streamTokenizer.nextToken();
        if (this.m_displayOption == null) {
            this.m_displayOption = new PvDisplayOption();
        }
        PdVector pdVector = new PdVector(0.0, 0.0, 1.0);
        PdMatrix pdMatrix = new PdMatrix(3);
        pdMatrix.setIdentity();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        while (true) {
            Object object;
            String string2;
            if ((string2 = PgWrlLoader.parseWord(streamTokenizer)) == null) {
                object = new PdVector(0.0, 1.0, 0.0);
                PdVector pdVector2 = new PdVector(0.0, 0.0, -1.0);
                object.leftMultMatrix(pdMatrix);
                pdVector2.leftMultMatrix(pdMatrix);
                PdVector pdVector3 = PdVector.addNew((PdVector)pdVector, (PdVector)pdVector2);
                PdVector pdVector4 = new PdVector(0.0, 0.0, 1.0);
                PdVector pdVector5 = pdVector4.orthogonalPart(null, pdVector2);
                double d = PdVector.angleWithOrientation((PdVector)object, (PdVector)pdVector5, (PdVector)pdVector2) * 180.0 / Math.PI;
                int n = this.m_displayOption.getNumCameras();
                this.m_displayOption.setNumCameras(n + 1);
                if (string != null) {
                    this.m_displayOption.setCameraName(n, string);
                }
                this.m_displayOption.setCameraProjection(n, 0);
                this.m_displayOption.setCameraInterest(n, pdVector3);
                this.m_displayOption.setCameraPosition(n, pdVector);
                this.m_displayOption.setCameraFieldOfView(n, 0.5);
                this.m_displayOption.setCameraRoll(n, d);
                return hashtable;
            }
            if (string2.equals("position")) {
                pdVector = PgWrlLoader.parsePdVector(streamTokenizer, 3);
                hashtable.put("position", pdVector);
                continue;
            }
            if (string2.equals("orientation")) {
                double d;
                object = PgWrlLoader.parsePdVector(streamTokenizer, 3);
                if (!PuReflect.makeRotation((PdMatrix)pdMatrix, (PdVector)object, (double)(d = PgWrlLoader.parseDouble(streamTokenizer).doubleValue()))) continue;
                hashtable.put("rotation", pdMatrix);
                continue;
            }
            if (string2.equals("focalDistance")) {
                object = PgWrlLoader.parseDouble(streamTokenizer);
                hashtable.put("focalDistance", object);
                continue;
            }
            if (!string2.equals("height")) continue;
            object = PgWrlLoader.parseDouble(streamTokenizer);
            hashtable.put("height", object);
        }
    }

    private Hashtable parseDirectionalLight(String string, StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        if (!"DirectionalLight".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        streamTokenizer.nextToken();
        if (this.m_displayOption == null) {
            this.m_displayOption = new PvDisplayOption();
        }
        int n = this.m_displayOption.getNumLights();
        this.m_displayOption.setNumLights(n + 1);
        if (string != null) {
            this.m_displayOption.setLightName(n, string);
        }
        this.m_displayOption.setLightType(n, 1);
        this.m_displayOption.setLightIntensity(n, 1.0);
        this.m_displayOption.setLightColor(n, Color.white);
        this.m_displayOption.setLightInterest(n, new PdVector(0.0, 0.0, 0.0));
        this.m_displayOption.setLightPosition(n, new PdVector(0.0, 0.0, 1.0));
        this.m_displayOption.setLightSwitchedOn(n, true);
        Hashtable<String, Serializable> hashtable = new Hashtable<String, Serializable>();
        while (true) {
            Serializable serializable;
            String string2;
            if ((string2 = PgWrlLoader.parseWord(streamTokenizer)) == null) {
                if (this.m_displayOption.isLightSwitchedOn(n)) {
                    this.m_displayOption.setLightingModel(1);
                }
                return hashtable;
            }
            if (string2.equals("ambientIntensity")) continue;
            if (string2.equals("color")) {
                serializable = PgWrlLoader.parseColor(streamTokenizer);
                this.m_displayOption.setLightColor(n, (Color)serializable);
                hashtable.put("color", serializable);
                continue;
            }
            if (string2.equals("direction")) {
                serializable = PgWrlLoader.parsePdVector(streamTokenizer, 3);
                if (!serializable.normalize()) {
                    PsDebug.warning((String)"normalization of light direction failed.");
                    continue;
                }
                serializable.multScalar(-1.0);
                this.m_displayOption.setLightPosition(n, (PdVector)serializable);
                serializable.multScalar(-1.0);
                hashtable.put("direction", serializable);
                continue;
            }
            if (string2.equals("intensity")) {
                serializable = PgWrlLoader.parseDouble(streamTokenizer);
                this.m_displayOption.setLightIntensity(n, ((Double)serializable).doubleValue());
                hashtable.put("intensity", serializable);
                continue;
            }
            if (!string2.equals("on")) continue;
            serializable = PgWrlLoader.parseBoolean(streamTokenizer);
            this.m_displayOption.setLightSwitchedOn(n, ((Boolean)serializable).booleanValue());
            hashtable.put("on", serializable);
        }
    }

    private Hashtable parsePointLight(String string, StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        if (!"PointLight".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        streamTokenizer.nextToken();
        if (this.m_displayOption == null) {
            this.m_displayOption = new PvDisplayOption();
        }
        int n = this.m_displayOption.getNumLights();
        this.m_displayOption.setNumLights(n + 1);
        if (string != null) {
            this.m_displayOption.setLightName(n, string);
        }
        this.m_displayOption.setLightType(n, 2);
        this.m_displayOption.setLightIntensity(n, 1.0);
        this.m_displayOption.setLightColor(n, Color.white);
        this.m_displayOption.setLightInterest(n, new PdVector(0.0, 0.0, 0.0));
        this.m_displayOption.setLightPosition(n, new PdVector(0.0, 0.0, 0.0));
        this.m_displayOption.setLightSwitchedOn(n, true);
        this.m_displayOption.setLightFalloff(n, 100.0);
        Hashtable<String, Serializable> hashtable = new Hashtable<String, Serializable>();
        while (true) {
            Serializable serializable;
            String string2;
            if ((string2 = PgWrlLoader.parseWord(streamTokenizer)) == null) {
                if (this.m_displayOption.isLightSwitchedOn(n)) {
                    this.m_displayOption.setLightingModel(1);
                }
                return hashtable;
            }
            if (string2.equals("ambientIntensity")) continue;
            if (string2.equals("color")) {
                serializable = PgWrlLoader.parseColor(streamTokenizer);
                this.m_displayOption.setLightColor(n, (Color)serializable);
                hashtable.put("color", serializable);
                continue;
            }
            if (string2.equals("intensity")) {
                serializable = PgWrlLoader.parseDouble(streamTokenizer);
                this.m_displayOption.setLightIntensity(n, ((Double)serializable).doubleValue());
                hashtable.put("intensity", serializable);
                continue;
            }
            if (string2.equals("location")) {
                serializable = PgWrlLoader.parsePdVector(streamTokenizer, 3);
                this.m_displayOption.setLightPosition(n, (PdVector)serializable);
                hashtable.put("location", serializable);
                continue;
            }
            if (string2.equals("on")) {
                serializable = PgWrlLoader.parseBoolean(streamTokenizer);
                this.m_displayOption.setLightSwitchedOn(n, ((Boolean)serializable).booleanValue());
                hashtable.put("on", serializable);
                continue;
            }
            if (!string2.equals("radius")) continue;
            serializable = PgWrlLoader.parseDouble(streamTokenizer);
            this.m_displayOption.setLightFalloff(n, ((Double)serializable).doubleValue());
            hashtable.put("radius", serializable);
        }
    }

    private Hashtable parseSpotLight(String string, StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        if (!"SpotLight".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        streamTokenizer.nextToken();
        if (this.m_displayOption == null) {
            this.m_displayOption = new PvDisplayOption();
        }
        int n = this.m_displayOption.getNumLights();
        this.m_displayOption.setNumLights(n + 1);
        if (string != null) {
            this.m_displayOption.setLightName(n, string);
        }
        this.m_displayOption.setLightType(n, 3);
        this.m_displayOption.setLightIntensity(n, 1.0);
        this.m_displayOption.setLightColor(n, Color.white);
        this.m_displayOption.setLightAngle(n, 1.5707963267948966);
        this.m_displayOption.setLightCorona(n, 0.0);
        this.m_displayOption.setLightInterest(n, new PdVector(0.0, 0.0, -1.0));
        this.m_displayOption.setLightPosition(n, new PdVector(0.0, 0.0, 0.0));
        this.m_displayOption.setLightSwitchedOn(n, true);
        this.m_displayOption.setLightFalloff(n, 100.0);
        Hashtable<String, Serializable> hashtable = new Hashtable<String, Serializable>();
        while (true) {
            PdVector pdVector;
            Serializable serializable;
            String string2;
            if ((string2 = PgWrlLoader.parseWord(streamTokenizer)) == null) {
                if (this.m_displayOption.isLightSwitchedOn(n)) {
                    this.m_displayOption.setLightingModel(1);
                }
                return hashtable;
            }
            if (string2.equals("ambientIntensity")) continue;
            if (string2.equals("color")) {
                serializable = PgWrlLoader.parseColor(streamTokenizer);
                this.m_displayOption.setLightColor(n, (Color)serializable);
                hashtable.put("color", serializable);
                continue;
            }
            if (string2.equals("intensity")) {
                serializable = PgWrlLoader.parseDouble(streamTokenizer);
                this.m_displayOption.setLightIntensity(n, ((Double)serializable).doubleValue());
                hashtable.put("intensity", serializable);
                continue;
            }
            if (string2.equals("beamWidth")) {
                serializable = PgWrlLoader.parseDouble(streamTokenizer);
                this.m_displayOption.setLightAngle(n, ((Double)serializable).doubleValue());
                hashtable.put("beamWidth", serializable);
                continue;
            }
            if (string2.equals("cutOffAngle")) {
                serializable = PgWrlLoader.parseDouble(streamTokenizer);
                this.m_displayOption.setLightIntensity(n, ((Double)serializable).doubleValue());
                hashtable.put("cutOffAngle", serializable);
                continue;
            }
            if (string2.equals("direction")) {
                serializable = PgWrlLoader.parsePdVector(streamTokenizer, 3);
                if (!serializable.normalize()) {
                    PsDebug.warning((String)"normalization of light direction failed.");
                    continue;
                }
                pdVector = PdVector.addNew((PdVector)this.m_displayOption.getLightPosition(n), (PdVector)serializable);
                this.m_displayOption.setLightInterest(n, pdVector);
                hashtable.put("direction", serializable);
                continue;
            }
            if (string2.equals("location")) {
                serializable = PdVector.subNew((PdVector)this.m_displayOption.getLightInterest(n), (PdVector)this.m_displayOption.getLightPosition(n));
                pdVector = PgWrlLoader.parsePdVector(streamTokenizer, 3);
                this.m_displayOption.setLightPosition(n, pdVector);
                this.m_displayOption.setLightInterest(n, PdVector.addNew((PdVector)pdVector, (PdVector)serializable));
                hashtable.put("location", (Serializable)pdVector);
                continue;
            }
            if (string2.equals("on")) {
                serializable = PgWrlLoader.parseBoolean(streamTokenizer);
                this.m_displayOption.setLightSwitchedOn(n, ((Boolean)serializable).booleanValue());
                hashtable.put("on", serializable);
                continue;
            }
            if (!string2.equals("radius")) continue;
            serializable = PgWrlLoader.parseDouble(streamTokenizer);
            this.m_displayOption.setLightFalloff(n, ((Double)serializable).doubleValue());
            hashtable.put("radius", serializable);
        }
    }

    private Hashtable parseBackground(StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        if (!"Background".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        streamTokenizer.nextToken();
        Hashtable<String, Color[]> hashtable = new Hashtable<String, Color[]>();
        Color color = Color.black;
        while (true) {
            String string;
            if ((string = PgWrlLoader.parseWord(streamTokenizer)) == null) {
                if (this.m_displayOption == null) {
                    this.m_displayOption = new PvDisplayOption();
                }
                this.m_displayOption.setBackgroundColor(color);
                return hashtable;
            }
            if (string.equals("skyColor")) {
                Color[] colorArray = PgWrlLoader.parseMFColor(streamTokenizer);
                if (colorArray != null && colorArray.length > 0) {
                    color = colorArray[0];
                }
                hashtable.put("skyColor", colorArray);
                continue;
            }
            streamTokenizer.pushBack();
            PgWrlLoader.parseUnknown(streamTokenizer);
        }
    }

    private void assignVRML1Globals(PgElementSet pgElementSet) {
        if (this.m_currentName != null) {
            pgElementSet.setName(this.m_currentName);
            this.m_currentName = null;
        }
        if (this.m_colorDiffuse != null) {
            pgElementSet.setGlobalElementColor(this.m_colorDiffuse);
        }
        if (this.m_colorSpecular != null) {
            pgElementSet.setSpecularColor(this.m_colorSpecular);
        }
        if (this.m_transparency != null) {
            pgElementSet.setTransparency(this.m_transparency.doubleValue());
            if (this.m_transparency > 0.0) {
                pgElementSet.showTransparency(true);
            }
        }
    }

    private void assignVRML1Globals(PgJvxSrc pgJvxSrc) {
        if (this.m_currentName != null) {
            pgJvxSrc.setName(this.m_currentName);
            this.m_currentName = null;
        }
        if (this.m_colorDiffuse != null) {
            pgJvxSrc.setGlobalElementColor(this.m_colorDiffuse);
        }
        if (this.m_colorSpecular != null) {
            pgJvxSrc.setSpecularColor(this.m_colorSpecular);
        }
        if (this.m_shininess != null) {
            pgJvxSrc.setShininess(this.m_shininess.doubleValue());
        }
        if (this.m_transparency != null) {
            pgJvxSrc.setTransparency(this.m_transparency.doubleValue());
            if (this.m_transparency > 0.0) {
                pgJvxSrc.showTransparency(true);
            }
        }
    }

    private Hashtable parseMaterial(StreamTokenizer streamTokenizer) throws IOException {
        Hashtable<String, Serializable> hashtable = new Hashtable<String, Serializable>();
        streamTokenizer.nextToken();
        if (!"Material".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        streamTokenizer.nextToken();
        String string;
        while ((string = PgWrlLoader.parseWord(streamTokenizer)) != null) {
            if (string.equals("ambientIntensity")) {
                hashtable.put("ambientIntensity", PgWrlLoader.parseDouble(streamTokenizer));
                continue;
            }
            if (string.equals("diffuseColor")) {
                this.m_colorDiffuse = PgWrlLoader.parseColor(streamTokenizer);
                hashtable.put("diffuseColor", this.m_colorDiffuse);
                continue;
            }
            if (string.equals("emissiveColor")) {
                this.m_colorEmissive = PgWrlLoader.parseColor(streamTokenizer);
                hashtable.put("emissiveColor", this.m_colorEmissive);
                continue;
            }
            if (string.equals("shininess")) {
                this.m_shininess = PgWrlLoader.parseDouble(streamTokenizer);
                hashtable.put("shininess", this.m_shininess);
                continue;
            }
            if (string.equals("specularColor")) {
                this.m_colorSpecular = PgWrlLoader.parseColor(streamTokenizer);
                hashtable.put("specularColor", this.m_colorSpecular);
                continue;
            }
            if (!string.equals("transparency")) continue;
            this.m_transparency = PgWrlLoader.parseDouble(streamTokenizer);
            hashtable.put("transparency", this.m_transparency);
        }
        return hashtable;
    }

    private Hashtable parseAppearance(StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        if (!"Appearance".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        streamTokenizer.nextToken();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        while (true) {
            Object object;
            String string;
            if ((string = PgWrlLoader.parseWord(streamTokenizer)) == null) {
                return hashtable;
            }
            if (string.equals("material")) {
                object = this.parseSFNode(streamTokenizer);
                if (object == null) {
                    throw new IOException();
                }
                hashtable.put("material", object);
                continue;
            }
            if (string.equals("texture")) {
                object = PgWrlLoader.parseTexImage(streamTokenizer);
                if (object == null) {
                    throw new IOException("parsing texture image failed");
                }
                hashtable.put("texture", object);
                continue;
            }
            if (!string.equals("textureTransform")) break;
            PgWrlLoader.parseUnknown(streamTokenizer);
        }
        throw new IOException(streamTokenizer.toString());
    }

    private static String parseTexImage(StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        if ("ImageTexture".equals(streamTokenizer.sval)) {
            streamTokenizer.nextToken();
            String[] stringArray = null;
            while (true) {
                String string;
                if ((string = PgWrlLoader.parseWord(streamTokenizer)) == null) {
                    if (stringArray != null) {
                        return stringArray[0];
                    }
                    return null;
                }
                if (string.equals("url")) {
                    stringArray = PgWrlLoader.parseMFString(streamTokenizer);
                    continue;
                }
                if (string.equals("repeatS")) {
                    PgWrlLoader.parseBoolean(streamTokenizer);
                    continue;
                }
                if (!string.equals("repeatT")) continue;
                PgWrlLoader.parseBoolean(streamTokenizer);
            }
        }
        if ("MovieTexture".equals(streamTokenizer.sval)) {
            PsDebug.warning((String)"movie texture not supported yet.");
            return null;
        }
        if ("PixelTexture".equals(streamTokenizer.sval)) {
            PsDebug.warning((String)"pixel texture not supported yet.");
            return null;
        }
        throw new IOException("failed parsing texture image");
    }

    private Hashtable parseShape(StreamTokenizer streamTokenizer, Vector vector) throws IOException {
        streamTokenizer.nextToken();
        if (!"Shape".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        streamTokenizer.nextToken();
        Hashtable hashtable = null;
        Hashtable hashtable2 = null;
        Hashtable<String, Hashtable> hashtable3 = new Hashtable<String, Hashtable>();
        while (true) {
            String string;
            if ((string = PgWrlLoader.parseWord(streamTokenizer)) == null) {
                if (hashtable2 != null) {
                    PgJvxSrc pgJvxSrc = (PgJvxSrc)hashtable2.get("geometry");
                    if (pgJvxSrc == null) {
                        throw new IOException("failed parsing geometry");
                    }
                    if (vector != null) {
                        vector.addElement(pgJvxSrc);
                    }
                    if (hashtable != null) {
                        Serializable serializable;
                        Object object;
                        Hashtable hashtable4 = (Hashtable)hashtable.get("material");
                        if (hashtable4 != null) {
                            object = (Color)hashtable4.get("diffuseColor");
                            serializable = (Color)hashtable4.get("emissiveColor");
                            Double d = (Double)hashtable.get("shininess");
                            Color color = (Color)hashtable.get("specularColor");
                            Double d2 = (Double)hashtable4.get("transparency");
                            if (pgJvxSrc.getType() == 30) {
                                if (serializable != null) {
                                    pgJvxSrc.setGlobalVertexColor(serializable);
                                }
                            } else if (pgJvxSrc.getType() == 32) {
                                if (serializable != null) {
                                    pgJvxSrc.setGlobalPolygonColor(serializable);
                                }
                            } else if (pgJvxSrc.getType() == 33) {
                                if (object != null) {
                                    pgJvxSrc.setGlobalElementColor((Color)object);
                                }
                                if (color != null) {
                                    pgJvxSrc.setSpecularColor(color);
                                }
                            }
                            if (d != null) {
                                pgJvxSrc.setShininess(d.doubleValue());
                            }
                            if (d2 != null) {
                                pgJvxSrc.setTransparency(d2.doubleValue());
                                if (d2 > 0.0) {
                                    pgJvxSrc.showTransparency(true);
                                }
                            }
                        }
                        if ((object = (String)hashtable.get("texture")) != null) {
                            pgJvxSrc.setTextureImageName((String)object);
                        }
                        if ((serializable = (Hashtable)hashtable.get("textureTransform")) != null) {
                            PsDebug.warning((String)"textureTransform not supported yet.");
                        }
                    }
                }
                return hashtable3;
            }
            if (string.equals("appearance")) {
                hashtable = this.parseSFNode(streamTokenizer);
                if (hashtable == null) {
                    throw new IOException("failed parsing appearance");
                }
                hashtable3.put("appearance", hashtable);
                continue;
            }
            if (!string.equals("geometry")) break;
            hashtable2 = this.parseSFNode(streamTokenizer);
            if (hashtable2 == null) continue;
            hashtable3.put("geometry", hashtable2);
        }
        throw new IOException(streamTokenizer.toString());
    }

    private Hashtable parseSwitch(StreamTokenizer streamTokenizer, Vector vector) throws IOException {
        Hashtable<String, Serializable> hashtable = new Hashtable<String, Serializable>();
        streamTokenizer.nextToken();
        if (!"Switch".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        streamTokenizer.nextToken();
        while (true) {
            int n = 0;
            String string = PgWrlLoader.parseWord(streamTokenizer);
            if (string == null) {
                return hashtable;
            }
            if (string.equals("choice")) {
                hashtable.put("choice", this.parseMFNode(streamTokenizer, vector));
                continue;
            }
            if (string.equals("whichChoice")) {
                hashtable.put("whichChoice", PgWrlLoader.parseInteger(streamTokenizer));
                continue;
            }
            if (string.equals("whichChild")) {
                hashtable.put("whichChild", PgWrlLoader.parseInteger(streamTokenizer));
                continue;
            }
            streamTokenizer.pushBack();
            Hashtable hashtable2 = this.parseSFNode(streamTokenizer);
            if (hashtable2 == null) continue;
            hashtable.put("choice_" + n++, hashtable2);
        }
    }

    private Hashtable parseMFNode(StreamTokenizer streamTokenizer, Vector vector) throws IOException {
        Hashtable<String, Hashtable> hashtable = new Hashtable<String, Hashtable>();
        int n = 0;
        block5: while (true) {
            switch (streamTokenizer.nextToken()) {
                default: {
                    throw new IOException(streamTokenizer.toString());
                }
                case 93: {
                    if (--n != 0) continue block5;
                    return hashtable;
                }
                case 91: {
                    ++n;
                    continue block5;
                }
                case -3: 
            }
            streamTokenizer.pushBack();
            Hashtable hashtable2 = this.parseSFNode(streamTokenizer, vector);
            if (hashtable2 != null) {
                String string = (String)hashtable2.get("vrmlType");
                hashtable.put(string, hashtable2);
            }
            if (n == 0) break;
        }
        return hashtable;
    }

    private Hashtable parseSFNode(StreamTokenizer streamTokenizer) throws IOException {
        return this.parseSFNode(streamTokenizer, null);
    }

    private Hashtable parseSFNode(StreamTokenizer streamTokenizer, Vector vector) throws IOException {
        switch (streamTokenizer.nextToken()) {
            default: {
                throw new IOException(streamTokenizer.toString());
            }
            case -3: 
        }
        String string = streamTokenizer.sval;
        String string2 = null;
        Hashtable hashtable = null;
        if (string.equals("DEF")) {
            string2 = PgWrlLoader.parseWord(streamTokenizer);
            streamTokenizer.nextToken();
            string = streamTokenizer.sval;
        } else {
            if (string.equals("PROTO")) {
                PsDebug.warning((String)("identifier not supported, key = " + string + " (line = " + streamTokenizer.lineno() + ")"));
                string2 = PgWrlLoader.parseWord(streamTokenizer);
                PgWrlLoader.parseUnknown(streamTokenizer);
                PgWrlLoader.parseUnknown(streamTokenizer);
                return null;
            }
            if (string.equals("ROUTE")) {
                PsDebug.warning((String)("identifier not supported, key = " + string + " (line = " + streamTokenizer.lineno() + ")"));
                PgWrlLoader.parseWord(streamTokenizer);
                PgWrlLoader.parseWord(streamTokenizer);
                PgWrlLoader.parseWord(streamTokenizer);
                return null;
            }
            if (string.equals("USE")) {
                String string3 = PgWrlLoader.parseWord(streamTokenizer);
                if (string3 != null) {
                    hashtable = (Hashtable)this.m_namedItems.get(string3);
                }
                if (hashtable == null) {
                    PsDebug.warning((String)("named node not found in hashtable, name = " + string3 + " (line = " + streamTokenizer.lineno() + ")"));
                }
                return hashtable;
            }
        }
        streamTokenizer.pushBack();
        boolean bl = this.m_bVRML_1_MODE;
        if (this.m_bVRML_1_MODE) {
            if (string.equals("Separator")) {
                hashtable = this.parseSeparator(streamTokenizer);
            } else if (string.equals("Info")) {
                hashtable = this.parseInfo(string2, streamTokenizer);
            } else if (string.equals("NormalBinding")) {
                hashtable = this.parseNormalBinding(streamTokenizer);
            } else if (string.equals("Coordinate3")) {
                hashtable = this.parseCoordinate(streamTokenizer);
            } else if (string.equals("Cube")) {
                hashtable = this.parseCube(string2, streamTokenizer);
            } else if (string.equals("ShapeHints")) {
                hashtable = this.parseShapeHints(streamTokenizer);
            } else if (string.equals("OrthographicCamera")) {
                hashtable = this.parseOrthographicCamera(string2, streamTokenizer);
            } else if (string.equals("PerspectiveCamera")) {
                hashtable = this.parsePerspectiveCamera(string2, streamTokenizer);
            } else {
                bl = false;
            }
        }
        if (!bl) {
            if (string.equals("Appearance")) {
                hashtable = this.parseAppearance(streamTokenizer);
            } else if (string.equals("DirectionalLight")) {
                hashtable = this.parseDirectionalLight(string2, streamTokenizer);
            } else if (string.equals("PointLight")) {
                hashtable = this.parsePointLight(string2, streamTokenizer);
            } else if (string.equals("SpotLight")) {
                hashtable = this.parseSpotLight(string2, streamTokenizer);
            } else if (string.equals("Background")) {
                hashtable = this.parseBackground(streamTokenizer);
            } else if (string.equals("Material")) {
                hashtable = this.parseMaterial(streamTokenizer);
            } else if (string.equals("Shape")) {
                hashtable = this.parseShape(streamTokenizer, vector);
            } else if (string.equals("Switch")) {
                hashtable = this.parseSwitch(streamTokenizer, vector);
            } else if (string.equals("Anchor")) {
                hashtable = this.parseAnchor(streamTokenizer, vector);
            } else if (string.equals("Billboard")) {
                hashtable = this.parseBillboard(streamTokenizer, vector);
            } else if (string.equals("Collision")) {
                hashtable = this.parseCollision(streamTokenizer, vector);
            } else if (string.equals("Group")) {
                hashtable = this.parseGroup(streamTokenizer, vector);
            } else if (string.equals("Transform")) {
                hashtable = this.parseTransform(streamTokenizer, vector);
            } else if (string.equals("Color")) {
                hashtable = this.parseColorSet(streamTokenizer);
            } else if (string.equals("Coordinate")) {
                hashtable = this.parseCoordinate(streamTokenizer);
            } else if (string.equals("Normal")) {
                hashtable = this.parseNormal(streamTokenizer);
            } else if (string.equals("TextureCoordinate")) {
                hashtable = this.parseTextureCoordinate(streamTokenizer);
            } else if (string.equals("WorldInfo")) {
                hashtable = this.parseWorldInfo(streamTokenizer);
            } else if (string.equals("NavigationInfo")) {
                hashtable = this.parseNavigationInfo(streamTokenizer);
            } else if (string.equals("Viewpoint")) {
                hashtable = this.parseViewpoint(streamTokenizer);
            } else if (string.equals("Box")) {
                hashtable = this.parseBox(string2, streamTokenizer);
            } else if (string.equals("Cone")) {
                hashtable = this.parseCone(string2, streamTokenizer);
            } else if (string.equals("Cylinder")) {
                hashtable = this.parseCylinder(string2, streamTokenizer);
            } else if (string.equals("ElevationGrid")) {
                hashtable = this.parseElevationGrid(string2, streamTokenizer);
            } else if (string.equals("IndexedFaceSet")) {
                hashtable = this.parseIndexedFaceSet(string2, streamTokenizer);
            } else if (string.equals("IndexedLineSet")) {
                hashtable = this.parseIndexedLineSet(string2, streamTokenizer);
            } else if (string.equals("PointSet")) {
                hashtable = this.parsePointSet(string2, streamTokenizer);
            } else if (string.equals("Sphere")) {
                hashtable = this.parseSphere(string2, streamTokenizer);
            } else {
                PgWrlLoader.parseUnknown(streamTokenizer);
            }
        }
        if (hashtable != null) {
            hashtable.put("vrmlType", string);
            if (string2 != null) {
                this.m_namedItems.put(string2, hashtable);
            }
        }
        return hashtable;
    }

    private Hashtable parseInfo(String string, StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        if (!"Info".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        streamTokenizer.nextToken();
        Hashtable hashtable = new Hashtable();
        String string2;
        while ((string2 = PgWrlLoader.parseWord(streamTokenizer)) != null) {
            if (string2.equalsIgnoreCase("string")) {
                Object object;
                if (string == null) {
                    this.m_currentName = PgWrlLoader.parseString(streamTokenizer);
                    continue;
                }
                if ("BackgroundColor".equalsIgnoreCase(string)) {
                    streamTokenizer.nextToken();
                    object = PgWrlLoader.parseColor(streamTokenizer);
                    streamTokenizer.nextToken();
                    if (this.m_displayOption == null) {
                        this.m_displayOption = new PvDisplayOption();
                    }
                    this.m_displayOption.setBackgroundColor((Color)object);
                    continue;
                }
                if ("Title".equalsIgnoreCase(string)) {
                    object = PgWrlLoader.parseString(streamTokenizer);
                    if (this.m_displayOption == null) {
                        this.m_displayOption = new PvDisplayOption();
                    }
                    this.m_displayOption.setTitle((String)object);
                    continue;
                }
                PgWrlLoader.parseString(streamTokenizer);
                continue;
            }
            streamTokenizer.pushBack();
            PgWrlLoader.parseUnknown(streamTokenizer);
        }
        return hashtable;
    }

    private Hashtable parseNavigationInfo(StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        if (!"NavigationInfo".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        streamTokenizer.nextToken();
        PdVector pdVector = new PdVector(0.25, 1.6, 0.75);
        boolean bl = true;
        String[] stringArray = new String[]{"Walk"};
        while (true) {
            Comparable<Boolean> comparable;
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            String string = PgWrlLoader.parseWord(streamTokenizer);
            if (string == null) {
                if (bl) {
                    if (this.m_displayOption == null) {
                        this.m_displayOption = new PvDisplayOption();
                    }
                    int n = this.m_displayOption.getNumLights();
                    this.m_displayOption.setNumLights(n + 1);
                    this.m_displayOption.setLightType(n, 5);
                    this.m_displayOption.setLightIntensity(n, 0.8);
                    this.m_displayOption.setLightColor(n, Color.white);
                    this.m_displayOption.setLightSwitchedOn(n, true);
                }
                return hashtable;
            }
            if (string.equals("avatarSize")) {
                streamTokenizer.nextToken();
                pdVector = PgWrlLoader.parsePdVector(streamTokenizer);
                pdVector.setLength(3.0);
                hashtable.put("avatarSize", pdVector);
                streamTokenizer.nextToken();
                continue;
            }
            if (string.equals("headlight")) {
                comparable = PgWrlLoader.parseBoolean(streamTokenizer);
                bl = comparable;
                hashtable.put("headlight", comparable);
                continue;
            }
            if (string.equals("speed")) {
                comparable = PgWrlLoader.parseDouble(streamTokenizer);
                hashtable.put("speed", comparable);
                continue;
            }
            if (string.equals("type")) {
                stringArray = PgWrlLoader.parseMFString(streamTokenizer);
                hashtable.put("type", stringArray);
                continue;
            }
            if (!string.equals("visibilityLimit")) continue;
            comparable = PgWrlLoader.parseDouble(streamTokenizer);
            hashtable.put("visibilityLimit", comparable);
        }
    }

    private Hashtable parseViewpoint(StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        if (!"Viewpoint".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        streamTokenizer.nextToken();
        double d = 0.785398;
        PdMatrix pdMatrix = new PdMatrix(3);
        pdMatrix.setIdentity();
        PdVector pdVector = new PdVector(0.0, 0.0, 10.0);
        String string = "";
        while (true) {
            Object object;
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            String string2 = PgWrlLoader.parseWord(streamTokenizer);
            if (string2 == null) {
                object = new PdVector(0.0, 1.0, 0.0);
                PdVector pdVector2 = new PdVector(0.0, 0.0, -1.0);
                object.leftMultMatrix(pdMatrix);
                pdVector2.leftMultMatrix(pdMatrix);
                PdVector pdVector3 = PdVector.addNew((PdVector)pdVector, (PdVector)pdVector2);
                PdVector pdVector4 = new PdVector(0.0, 0.0, 1.0);
                PdVector pdVector5 = pdVector4.orthogonalPart(null, pdVector2);
                double d2 = PdVector.angleWithOrientation((PdVector)object, (PdVector)pdVector5, (PdVector)pdVector2) * 180.0 / Math.PI;
                if (this.m_displayOption == null) {
                    this.m_displayOption = new PvDisplayOption();
                }
                int n = this.m_displayOption.getNumCameras();
                this.m_displayOption.setNumCameras(n + 1);
                this.m_displayOption.setCameraPosition(n, pdVector);
                this.m_displayOption.setCameraInterest(n, pdVector3);
                this.m_displayOption.setCameraRoll(n, d2);
                this.m_displayOption.setCameraFieldOfView(n, d);
                this.m_displayOption.setCameraProjection(n, n);
                this.m_displayOption.setCameraName(n, string);
                return hashtable;
            }
            if (string2.equals("fieldOfView")) {
                object = PgWrlLoader.parseDouble(streamTokenizer);
                d = (Double)object;
                hashtable.put("fieldOfView", object);
                continue;
            }
            if (string2.equals("jump")) {
                object = PgWrlLoader.parseBoolean(streamTokenizer);
                hashtable.put("jump", object);
                continue;
            }
            if (string2.equals("orientation")) {
                double d3;
                object = PgWrlLoader.parsePdVector(streamTokenizer, 3);
                if (!PuReflect.makeRotation((PdMatrix)pdMatrix, (PdVector)object, (double)(d3 = PgWrlLoader.parseDouble(streamTokenizer).doubleValue()))) continue;
                hashtable.put("rotation", pdMatrix);
                continue;
            }
            if (string2.equals("position")) {
                pdVector = PgWrlLoader.parsePdVector(streamTokenizer, 3);
                hashtable.put("position", pdVector);
                continue;
            }
            if (!string2.equals("description")) continue;
            string = PgWrlLoader.parseString(streamTokenizer);
            hashtable.put("description", string);
        }
    }

    private Hashtable parseColorSet(StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        if (!"Color".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        streamTokenizer.nextToken();
        streamTokenizer.nextToken();
        Color[] colorArray = PgWrlLoader.parseMFColor(streamTokenizer);
        if (colorArray == null) {
            return null;
        }
        if (this.m_bVRML_1_MODE) {
            this.m_color = colorArray;
        }
        Hashtable<String, Color[]> hashtable = new Hashtable<String, Color[]>();
        hashtable.put("color", colorArray);
        streamTokenizer.nextToken();
        return hashtable;
    }

    private Hashtable parseCoordinate(StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        if (!"Coordinate".equals(streamTokenizer.sval) && !"Coordinate3".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        streamTokenizer.nextToken();
        PdVector[] pdVectorArray = PgWrlLoader.parseVertexArray(streamTokenizer, 3);
        if (pdVectorArray == null) {
            return null;
        }
        if (this.m_bVRML_1_MODE) {
            this.m_vertex = pdVectorArray;
        }
        Hashtable<String, PdVector[]> hashtable = new Hashtable<String, PdVector[]>();
        hashtable.put("point", pdVectorArray);
        streamTokenizer.nextToken();
        return hashtable;
    }

    private Hashtable parseNormal(StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        if (!"Normal".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        streamTokenizer.nextToken();
        PdVector[] pdVectorArray = PgWrlLoader.parseVertexArray(streamTokenizer, 3);
        if (pdVectorArray == null) {
            return null;
        }
        Hashtable<String, PdVector[]> hashtable = new Hashtable<String, PdVector[]>();
        hashtable.put("normal", pdVectorArray);
        streamTokenizer.nextToken();
        return hashtable;
    }

    private Hashtable parseNormalBinding(StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        if (!"NormalBinding".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        streamTokenizer.nextToken();
        String string = PgWrlLoader.parseWord(streamTokenizer);
        if (!"value".equals(string)) {
            throw new IOException(streamTokenizer.toString());
        }
        String string2 = PgWrlLoader.parseWord(streamTokenizer);
        if (string2 == null) {
            throw new IOException(streamTokenizer.toString());
        }
        if (string2.equals("OVERALL")) {
            this.m_normalBinding = 1;
        } else if (string2.equals("DEFAULT")) {
            this.m_normalBinding = 0;
        } else if (string2.equals("PER_VERTEX")) {
            this.m_normalBinding = 2;
        } else if (string2.equals("PER_VERTEX_INDEXED")) {
            this.m_normalBinding = 3;
        } else if (string2.equals("PER_FACE")) {
            this.m_normalBinding = 4;
        } else if (string2.equals("PER_FACE_INDEXED")) {
            this.m_normalBinding = 5;
        } else if (string2.equals("PER_PART")) {
            this.m_normalBinding = 6;
        } else if (string2.equals("PER_PART_INDEXED")) {
            this.m_normalBinding = 7;
        }
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        hashtable.put("normalBinding", new Integer(this.m_normalBinding));
        streamTokenizer.nextToken();
        return hashtable;
    }

    private Hashtable parseTextureCoordinate(StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        if (!"TextureCoordinate".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        streamTokenizer.nextToken();
        PdVector[] pdVectorArray = PgWrlLoader.parseVertexArray(streamTokenizer, 2);
        if (pdVectorArray == null) {
            return null;
        }
        Hashtable<String, PdVector[]> hashtable = new Hashtable<String, PdVector[]>();
        hashtable.put("point", pdVectorArray);
        streamTokenizer.nextToken();
        return hashtable;
    }

    private Hashtable parseTransform(StreamTokenizer streamTokenizer, Vector vector) throws IOException {
        streamTokenizer.nextToken();
        if (!"Transform".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        PdVector pdVector = null;
        PdVector pdVector2 = null;
        PdVector pdVector3 = null;
        PdVector pdVector4 = null;
        PdVector pdVector5 = null;
        PdVector pdVector6 = null;
        PdVector pdVector7 = null;
        boolean bl = false;
        PdMatrix pdMatrix = null;
        PdMatrix pdMatrix2 = null;
        PdMatrix pdMatrix3 = null;
        PdMatrix pdMatrix4 = null;
        PdMatrix pdMatrix5 = null;
        PdMatrix pdMatrix6 = null;
        PdMatrix pdMatrix7 = null;
        Vector vector2 = new Vector();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        int n = 0;
        block5: while (true) {
            switch (streamTokenizer.nextToken()) {
                default: {
                    throw new IOException(streamTokenizer.toString());
                }
                case 125: {
                    PgJvxSrc pgJvxSrc;
                    Enumeration enumeration;
                    if (--n > 0) continue block5;
                    PdMatrix pdMatrix8 = null;
                    if (bl) {
                        pdMatrix8 = new PdMatrix(4);
                        pdMatrix8.setIdentity();
                        if (pdVector != null) {
                            pdMatrix8.leftMult(pdMatrix6);
                        }
                        if (pdVector4 != null) {
                            pdMatrix8.leftMult(pdMatrix7);
                        }
                        if (pdVector3 != null) {
                            pdMatrix8.leftMult(pdMatrix3);
                        }
                        if (pdVector4 != null) {
                            pdMatrix8.leftMult(pdMatrix4);
                        }
                        if (pdVector2 != null) {
                            pdMatrix8.leftMult(pdMatrix2);
                        }
                        if (pdVector != null) {
                            pdMatrix8.leftMult(pdMatrix);
                        }
                        if (pdVector5 != null) {
                            pdMatrix8.leftMult(pdMatrix5);
                        }
                        hashtable.put("transform", pdMatrix8);
                    }
                    if (bl) {
                        enumeration = vector2.elements();
                        while (enumeration.hasMoreElements()) {
                            PdMatrix pdMatrix9;
                            pgJvxSrc = (PgJvxSrc)enumeration.nextElement();
                            if (pgJvxSrc.hasModelMatrix()) {
                                pdMatrix9 = pgJvxSrc.getModelMatrix();
                                pdMatrix9.leftMult(pdMatrix8);
                            } else {
                                pdMatrix9 = pdMatrix8;
                            }
                            pgJvxSrc.setModelMatrix(pdMatrix9);
                        }
                    }
                    if (vector != null) {
                        enumeration = vector2.elements();
                        while (enumeration.hasMoreElements()) {
                            pgJvxSrc = (PgJvxSrc)enumeration.nextElement();
                            vector.addElement(pgJvxSrc);
                        }
                    }
                    return hashtable;
                }
                case 123: {
                    ++n;
                    break;
                }
                case -3: {
                    PgJvxSrc pgJvxSrc;
                    Enumeration enumeration = streamTokenizer.sval;
                    if (((String)((Object)enumeration)).equals("children")) {
                        hashtable.put("children", this.parseMFNode(streamTokenizer, vector2));
                        break;
                    }
                    if (((String)((Object)enumeration)).equals("center")) {
                        pdVector = PgWrlLoader.parsePdVector(streamTokenizer, 3);
                        if (pdVector == null) continue block5;
                        hashtable.put("center", pdVector);
                        pdMatrix6 = PuReflect.translate((PdVector)pdVector);
                        pdVector.multScalar(-1.0);
                        pdMatrix = PuReflect.translate((PdVector)pdVector);
                        bl = true;
                        break;
                    }
                    if (((String)((Object)enumeration)).equals("rotation")) {
                        double d;
                        pdVector2 = PgWrlLoader.parsePdVector(streamTokenizer, 4);
                        if (pdVector2 == null) continue block5;
                        hashtable.put("rotation", pdVector2);
                        pgJvxSrc = new PdVector(3);
                        double d2 = pdVector2.getEntry(3);
                        pdVector2.setSize(3);
                        if (Math.abs(d2) < 1.0E-10 && (d = pdVector2.sqrLength()) < 1.0E-10) {
                            pdVector2.m_data[0] = 1.0;
                        }
                        pdMatrix2 = PuReflect.rotateLine((PdVector)pgJvxSrc, (PdVector)pdVector2, (double)d2);
                        bl = true;
                        break;
                    }
                    if (((String)((Object)enumeration)).equals("scale")) {
                        pdVector3 = PgWrlLoader.parsePdVector(streamTokenizer, 3);
                        if (pdVector3 == null) continue block5;
                        pdMatrix3 = PuReflect.scale((PdVector)pdVector3);
                        hashtable.put("scale", pdVector3);
                        bl = true;
                        break;
                    }
                    if (((String)((Object)enumeration)).equals("scaleOrientation")) {
                        pdVector4 = PgWrlLoader.parsePdVector(streamTokenizer, 4);
                        if (pdVector4 == null) continue block5;
                        hashtable.put("scaleOrientation", pdVector4);
                        pgJvxSrc = new PdVector(3);
                        pdMatrix4 = PuReflect.rotateLine((PdVector)pgJvxSrc, (PdVector)pdVector4, (double)pdVector4.getEntry(3));
                        pdMatrix7 = PuReflect.rotateLine((PdVector)pgJvxSrc, (PdVector)pdVector4, (double)(-pdVector4.getEntry(3)));
                        bl = true;
                        break;
                    }
                    if (((String)((Object)enumeration)).equals("translation")) {
                        pdVector5 = PgWrlLoader.parsePdVector(streamTokenizer, 3);
                        if (pdVector5 == null) continue block5;
                        hashtable.put("translation", pdVector5);
                        pdMatrix5 = PuReflect.translate((PdVector)pdVector5);
                        bl = true;
                        break;
                    }
                    if (((String)((Object)enumeration)).equals("bboxCenter")) {
                        pdVector6 = PgWrlLoader.parsePdVector(streamTokenizer, 3);
                        if (pdVector6 == null) continue block5;
                        hashtable.put("bboxCenter", pdVector6);
                        break;
                    }
                    if (!((String)((Object)enumeration)).equals("bboxSize") || (pdVector7 = PgWrlLoader.parsePdVector(streamTokenizer, 3)) == null) continue block5;
                    hashtable.put("bboxSize", pdVector7);
                }
            }
        }
    }

    private Hashtable parseGroup(StreamTokenizer streamTokenizer, Vector vector) throws IOException {
        streamTokenizer.nextToken();
        if (!"Group".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        if (streamTokenizer.nextToken() != 123) {
            return null;
        }
        Vector vector2 = new Vector();
        Hashtable hashtable = new Hashtable();
        while (true) {
            Object object;
            String string;
            if ((string = PgWrlLoader.parseWord(streamTokenizer)) == null) {
                if (vector != null) {
                    object = vector2.elements();
                    while (object.hasMoreElements()) {
                        vector.addElement(object.nextElement());
                    }
                }
                return hashtable;
            }
            if (string.equals("children")) {
                hashtable.put("children", this.parseMFNode(streamTokenizer, vector2));
                continue;
            }
            if (string.equals("bboxCenter")) {
                object = PgWrlLoader.parsePdVector(streamTokenizer, 3);
                if (object == null) continue;
                hashtable.put("bboxCenter", object);
                continue;
            }
            if (string.equals("bboxSize")) {
                object = PgWrlLoader.parsePdVector(streamTokenizer, 3);
                if (object == null) continue;
                hashtable.put("bboxSize", object);
                continue;
            }
            if (string.equals("Separator")) {
                streamTokenizer.pushBack();
                object = this.parseSeparator(streamTokenizer);
                if (object == null) continue;
                hashtable.put("Separator", object);
                continue;
            }
            streamTokenizer.pushBack();
            object = this.parseSFNode(streamTokenizer);
            if (object == null) continue;
            hashtable.put(string, object);
        }
    }

    private Hashtable parseAnchor(StreamTokenizer streamTokenizer, Vector vector) throws IOException {
        streamTokenizer.nextToken();
        if (!"Anchor".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        if (streamTokenizer.nextToken() != 123) {
            return null;
        }
        Vector vector2 = new Vector();
        Hashtable hashtable = new Hashtable();
        while (true) {
            Object object;
            String string;
            if ((string = PgWrlLoader.parseWord(streamTokenizer)) == null) {
                if (vector != null) {
                    object = vector2.elements();
                    while (object.hasMoreElements()) {
                        vector.addElement(object.nextElement());
                    }
                }
                return hashtable;
            }
            if (string.equals("children")) {
                hashtable.put("children", this.parseMFNode(streamTokenizer, vector2));
                continue;
            }
            if (string.equals("description")) {
                object = PgWrlLoader.parseString(streamTokenizer);
                if (object == null) continue;
                hashtable.put("description", object);
                continue;
            }
            if (string.equals("parameter")) {
                object = PgWrlLoader.parseMFString(streamTokenizer);
                if (object == null || ((String[])object).length <= 0 || object[0] == null) continue;
                hashtable.put("parameter", object[0]);
                continue;
            }
            if (string.equals("url")) {
                object = PgWrlLoader.parseMFString(streamTokenizer);
                if (object == null || ((String[])object).length <= 0 || object[0] == null) continue;
                hashtable.put("url", object[0]);
                continue;
            }
            if (string.equals("bboxCenter")) {
                object = PgWrlLoader.parsePdVector(streamTokenizer, 3);
                if (object == null) continue;
                hashtable.put("bboxCenter", object);
                continue;
            }
            if (string.equals("bboxSize")) {
                object = PgWrlLoader.parsePdVector(streamTokenizer, 3);
                if (object == null) continue;
                hashtable.put("bboxSize", object);
                continue;
            }
            streamTokenizer.pushBack();
            object = this.parseSFNode(streamTokenizer);
            if (object == null) continue;
            hashtable.put(string, object);
        }
    }

    private Hashtable parseCollision(StreamTokenizer streamTokenizer, Vector vector) throws IOException {
        streamTokenizer.nextToken();
        if (!"Collision".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        if (streamTokenizer.nextToken() != 123) {
            return null;
        }
        Vector vector2 = new Vector();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        while (true) {
            Object object;
            String string;
            if ((string = PgWrlLoader.parseWord(streamTokenizer)) == null) {
                if (vector != null) {
                    object = vector2.elements();
                    while (object.hasMoreElements()) {
                        vector.addElement(object.nextElement());
                    }
                }
                return hashtable;
            }
            if (string.equals("children")) {
                hashtable.put("children", this.parseMFNode(streamTokenizer, vector2));
                continue;
            }
            if (string.equals("collide")) {
                object = PgWrlLoader.parseBoolean(streamTokenizer);
                if (object == null) continue;
                hashtable.put("collide", object);
                continue;
            }
            if (string.equals("bboxCenter")) {
                object = PgWrlLoader.parsePdVector(streamTokenizer, 3);
                if (object == null) continue;
                hashtable.put("bboxCenter", object);
                continue;
            }
            if (string.equals("bboxSize")) {
                object = PgWrlLoader.parsePdVector(streamTokenizer, 3);
                if (object == null) continue;
                hashtable.put("bboxSize", object);
                continue;
            }
            streamTokenizer.pushBack();
            object = this.parseSFNode(streamTokenizer);
            if (object == null) continue;
            hashtable.put(string, object);
        }
    }

    private Hashtable parseBillboard(StreamTokenizer streamTokenizer, Vector vector) throws IOException {
        streamTokenizer.nextToken();
        if (!"Billboard".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        if (streamTokenizer.nextToken() != 123) {
            return null;
        }
        Vector vector2 = new Vector();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        while (true) {
            Object object;
            String string;
            if ((string = PgWrlLoader.parseWord(streamTokenizer)) == null) {
                if (vector != null) {
                    object = vector2.elements();
                    while (object.hasMoreElements()) {
                        vector.addElement(object.nextElement());
                    }
                }
                return hashtable;
            }
            if (string.equals("axisOfRotation")) {
                object = PgWrlLoader.parsePdVector(streamTokenizer, 3);
                if (object == null) continue;
                hashtable.put("axisOfRotation", object);
                continue;
            }
            if (string.equals("children")) {
                hashtable.put("children", this.parseMFNode(streamTokenizer, vector2));
                continue;
            }
            if (string.equals("bboxCenter")) {
                object = PgWrlLoader.parsePdVector(streamTokenizer, 3);
                if (object == null) continue;
                hashtable.put("bboxCenter", object);
                continue;
            }
            if (string.equals("bboxSize")) {
                object = PgWrlLoader.parsePdVector(streamTokenizer, 3);
                if (object == null) continue;
                hashtable.put("bboxSize", object);
                continue;
            }
            streamTokenizer.pushBack();
            object = this.parseSFNode(streamTokenizer);
            if (object == null) continue;
            hashtable.put(string, object);
        }
    }

    private static Hashtable parseUnknown(StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        if (streamTokenizer.sval != null) {
            PsDebug.warning((String)("parsing not implemented of identifier = " + streamTokenizer.sval + " (line = " + streamTokenizer.lineno() + ")"));
        }
        int n = 0;
        block6: while (true) {
            switch (streamTokenizer.nextToken()) {
                default: {
                    continue block6;
                }
                case 34: {
                    continue block6;
                }
                case 93: 
                case 125: {
                    if (--n != 0) continue block6;
                    return null;
                }
                case 91: 
                case 123: {
                    ++n;
                    continue block6;
                }
                case -1: 
            }
            break;
        }
        if (n != 0) {
            PsDebug.warning((String)("numOpenNodes = " + n + "\n\tnum of lines  = " + streamTokenizer.lineno()));
        }
        return null;
    }

    private Hashtable parseSeparator(StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        if (!"Separator".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        Hashtable<String, Hashtable> hashtable = new Hashtable<String, Hashtable>();
        streamTokenizer.nextToken();
        while (true) {
            streamTokenizer.nextToken();
            String string = streamTokenizer.sval;
            if (string == null) {
                this.m_colorDiffuse = Color.white;
                this.m_colorEmissive = null;
                this.m_colorSpecular = null;
                this.m_shininess = null;
                this.m_transparency = null;
                this.m_normalBinding = 3;
                this.m_creaseAngle = 0.0;
                return hashtable;
            }
            if (string.equals("renderCulling")) {
                PgWrlLoader.parseWord(streamTokenizer);
                continue;
            }
            streamTokenizer.pushBack();
            Hashtable hashtable2 = this.parseSFNode(streamTokenizer);
            if (hashtable2 == null) continue;
            String string2 = (String)hashtable2.get("vrmlType");
            if (string2 != null) {
                hashtable.put(string2, hashtable2);
                continue;
            }
            PsDebug.warning((String)"missing vrml type");
        }
    }

    private Hashtable parseWorldInfo(StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        if (!"WorldInfo".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = null;
        String string2 = null;
        streamTokenizer.nextToken();
        while (true) {
            String string3;
            if ((string3 = PgWrlLoader.parseWord(streamTokenizer)) == null) {
                if (string != null || string2 != null) {
                    if (this.m_displayOption == null) {
                        this.m_displayOption = new PvDisplayOption();
                    }
                    if (string != null) {
                        this.m_displayOption.setAbstract(string);
                    }
                    if (string2 != null) {
                        this.m_displayOption.setTitle(string2);
                    }
                }
                return hashtable;
            }
            if (string3.equals("info")) {
                String[] stringArray = PgWrlLoader.parseMFString(streamTokenizer);
                if (stringArray == null || stringArray.length <= 0) continue;
                string = PuString.mergeStrings((String[])stringArray, (String)StrNL);
                hashtable.put("info", string);
                continue;
            }
            if (!string3.equals("title") || (string2 = PgWrlLoader.parseString(streamTokenizer)) == null) continue;
            hashtable.put("title", string2);
        }
    }

    public boolean write(Writer writer, PgJvxSrc[] pgJvxSrcArray) throws IOException {
        int n;
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0 || pgJvxSrcArray[0] == null) {
            PsDebug.warning((String)"missing geometry");
            return false;
        }
        writer.write("#VRML V2.0 utf8\n");
        writer.write("# Produced with JavaView v." + PsConfig.getVersion() + StrNL);
        writer.write("# JavaView is " + PsConfig.getCopyright() + ", " + PsConfig.getHomepage() + StrNL);
        writer.write("# by " + PsConfig.getAuthors() + StrNL);
        writer.write("#     File Format = WRL\n");
        writer.write("#     Date        = " + new Date().toString() + StrNL);
        writer.write("#     Scene Title = " + pgJvxSrcArray[0].getTitle() + StrNL);
        writer.write("#\n");
        for (n = 0; n < pgJvxSrcArray.length; ++n) {
            if (pgJvxSrcArray[n] == null) continue;
            writer.write("#     Geometry    = " + pgJvxSrcArray[n].getName() + StrNL);
            writer.write("#     Number of Vertices = " + pgJvxSrcArray[n].getNumVertices() + StrNL);
            if (pgJvxSrcArray[n].getType() == 32) {
                writer.write("#     Number of Polygons = " + pgJvxSrcArray[n].getNumPolygons() + StrNL);
            }
            if (pgJvxSrcArray[n].getType() != 33) continue;
            writer.write("#     Number of Elements = " + pgJvxSrcArray[n].getNumElements() + StrNL);
        }
        writer.write("#\n# End of Header\n");
        writer.write("NavigationInfo {\n");
        writer.write("   headlight TRUE\n");
        writer.write("   type      [ \"EXAMINE\", \"WALK\", \"ANY\" ]\n");
        writer.write(Str1CBracket);
        writer.write("Group {\nchildren [\n");
        for (n = 0; n < pgJvxSrcArray.length; ++n) {
            if (pgJvxSrcArray[n] == null) continue;
            StringBuffer stringBuffer = new StringBuffer("");
            if (pgJvxSrcArray[n].hasModelMatrix()) {
                PgWrlLoader.drawTransform(stringBuffer, pgJvxSrcArray[n]);
            } else {
                PgWrlLoader.drawShape(stringBuffer, pgJvxSrcArray[n]);
            }
            writer.write(stringBuffer.toString());
        }
        writer.write(Str1Bracket);
        writer.write(Str1CBracket);
        return true;
    }

    protected static void drawTransform(StringBuffer stringBuffer, PgJvxSrc pgJvxSrc) {
        stringBuffer.append("Transform {\n");
        PdMatrix pdMatrix = pgJvxSrc.getModelMatrix();
        PdVector pdVector = pdMatrix.getColumn(0);
        double d = pdVector.length();
        PdVector pdVector2 = pdMatrix.getColumn(3);
        pdVector2.setSize(3);
        pdMatrix.multScalar(1.0 / d);
        PdVector pdVector3 = new PdVector(3);
        Double d2 = PuReflect.getRotation((PdMatrix)pdMatrix, (PdVector)pdVector3);
        stringBuffer.append("rotation    " + String.valueOf(pdVector3.getEntry(0)) + StrSpace + String.valueOf(pdVector3.getEntry(1)) + StrSpace + String.valueOf(pdVector3.getEntry(2)) + StrSpace + String.valueOf(d2.floatValue()) + StrNL);
        String string = String.valueOf((float)d);
        stringBuffer.append("scale       " + string + StrSpace + string + StrSpace + string + StrNL);
        stringBuffer.append("translation " + String.valueOf(pdVector2.getEntry(0)) + StrSpace + String.valueOf(pdVector2.getEntry(1)) + StrSpace + String.valueOf(pdVector2.getEntry(2)) + StrNL);
        stringBuffer.append("children [\n");
        PgWrlLoader.drawShape(stringBuffer, pgJvxSrc);
        stringBuffer.append(Str1Bracket);
        stringBuffer.append(Str1CBracket);
    }

    protected static void drawShape(StringBuffer stringBuffer, PgJvxSrc pgJvxSrc) {
        stringBuffer.append("Shape {\n");
        if (pgJvxSrc.getNumElements() > 0) {
            PgWrlLoader.drawElementSet(stringBuffer, pgJvxSrc);
        } else if (pgJvxSrc.getNumPolygons() > 0) {
            PgWrlLoader.drawPolygonSet(stringBuffer, pgJvxSrc);
        } else {
            PgWrlLoader.drawPointSet(stringBuffer, pgJvxSrc);
        }
        PgWrlLoader.createAppearance(stringBuffer, pgJvxSrc);
        stringBuffer.append(Str1CBracket);
    }

    private static void appendColor(StringBuffer stringBuffer, Color color) {
        if (color == null) {
            stringBuffer.append(Str3One);
        } else {
            stringBuffer.append(PdColor.toStringAsFloat((Color)color, (String)StrSpace));
        }
        stringBuffer.append(StrNL);
    }

    protected static void createAppearance(StringBuffer stringBuffer, PgJvxSrc pgJvxSrc) {
        stringBuffer.append("appearance Appearance {\n");
        PgWrlLoader.createMaterial(stringBuffer, pgJvxSrc);
        String string = pgJvxSrc.getTextureImageName();
        if (string != null) {
            stringBuffer.append("texture ImageTexture {\n");
            stringBuffer.append("url     [ \"" + string + "\" ]\n");
            stringBuffer.append("repeatS TRUE\n");
            stringBuffer.append("repeatT TRUE\n");
            stringBuffer.append(Str1CBracket);
        }
        stringBuffer.append(Str1CBracket);
    }

    protected static void createMaterial(StringBuffer stringBuffer, PgJvxSrc pgJvxSrc) {
        stringBuffer.append("material Material {\n");
        if (pgJvxSrc.getType() == 30) {
            stringBuffer.append("emissiveColor ");
            PgWrlLoader.appendColor(stringBuffer, pgJvxSrc.getGlobalVertexColor());
        } else if (pgJvxSrc.getType() == 31 || pgJvxSrc.getType() == 32) {
            stringBuffer.append("emissiveColor ");
            PgWrlLoader.appendColor(stringBuffer, pgJvxSrc.getGlobalPolygonColor());
        } else if (pgJvxSrc.getType() == 33) {
            stringBuffer.append("diffuseColor ");
            PgWrlLoader.appendColor(stringBuffer, pgJvxSrc.getGlobalElementColor());
        }
        if (pgJvxSrc.isShowingTransparency() && pgJvxSrc.getTransparency() > 0.0) {
            stringBuffer.append("transparency " + String.valueOf(pgJvxSrc.getTransparency()));
        }
        stringBuffer.append(Str1CBracket);
    }

    protected static void createNormals(StringBuffer stringBuffer, int n, int n2, PdVector[] pdVectorArray) {
        stringBuffer.append("normal Normal {\nvector [\n");
        for (int i = 0; i < n2; ++i) {
            double[] dArray = pdVectorArray[i].m_data;
            if (n < 1) {
                stringBuffer.append(Str3Zero);
            } else {
                stringBuffer.append((float)dArray[0]);
                stringBuffer.append(StrSpace);
                if (n < 2) {
                    stringBuffer.append(Str2Zero);
                } else {
                    stringBuffer.append((float)dArray[1]);
                    stringBuffer.append(StrSpace);
                    if (n < 3) {
                        stringBuffer.append(Str1Zero);
                    } else {
                        stringBuffer.append((float)dArray[2]);
                    }
                }
            }
            if (i < n2 - 1) {
                stringBuffer.append(",");
            }
            stringBuffer.append(StrNL);
        }
        stringBuffer.append(Str1Bracket);
        stringBuffer.append(Str1CBracket);
    }

    protected static void createColors(StringBuffer stringBuffer, int n, Color[] colorArray) {
        stringBuffer.append("color Color {\ncolor [\n");
        for (int i = 0; i < n; ++i) {
            Color color = null;
            if (i < n) {
                color = colorArray[i];
            }
            if (color == null) {
                stringBuffer.append(Str3One);
            } else {
                stringBuffer.append((float)color.getRed() / 255.0f);
                stringBuffer.append(StrSpace);
                stringBuffer.append((float)color.getGreen() / 255.0f);
                stringBuffer.append(StrSpace);
                stringBuffer.append((float)color.getBlue() / 255.0f);
            }
            if (i < n - 1) {
                stringBuffer.append(",");
            }
            stringBuffer.append(StrNL);
        }
        stringBuffer.append(Str1Bracket);
        stringBuffer.append(Str1CBracket);
    }

    protected static void createCoord(StringBuffer stringBuffer, int n, int n2, PdVector[] pdVectorArray) {
        stringBuffer.append("coord Coordinate {\npoint [\n");
        for (int i = 0; i < n2; ++i) {
            double[] dArray = pdVectorArray[i].m_data;
            if (n < 1) {
                stringBuffer.append(Str3Zero);
            } else {
                stringBuffer.append((float)dArray[0]);
                stringBuffer.append(StrSpace);
                if (n < 2) {
                    stringBuffer.append(Str2Zero);
                } else {
                    stringBuffer.append((float)dArray[1]);
                    stringBuffer.append(StrSpace);
                    if (n < 3) {
                        stringBuffer.append(Str1Zero);
                    } else {
                        stringBuffer.append((float)dArray[2]);
                    }
                }
            }
            if (i < n2 - 1) {
                stringBuffer.append(",");
            }
            stringBuffer.append(StrNL);
        }
        stringBuffer.append(Str1Bracket);
        stringBuffer.append(Str1CBracket);
    }

    protected static void createTextureCoord(StringBuffer stringBuffer, int n, int n2, PdVector[] pdVectorArray) {
        stringBuffer.append("texCoord TextureCoordinate {\npoint [\n");
        for (int i = 0; i < n2; ++i) {
            int n3 = pdVectorArray[i].getSize();
            double[] dArray = pdVectorArray[i].m_data;
            for (int j = 0; j < n3; ++j) {
                stringBuffer.append((float)dArray[j]);
                stringBuffer.append(StrSpace);
            }
            if (i < n2 - 1) {
                stringBuffer.append(",");
            }
            stringBuffer.append(StrNL);
        }
        stringBuffer.append(Str1Bracket);
        stringBuffer.append(Str1CBracket);
    }

    protected static void createTextureCoord(StringBuffer stringBuffer, int n, int n2, PdVector[][] pdVectorArray) {
        stringBuffer.append("texCoord TextureCoordinate {\npoint [\n");
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < pdVectorArray[i].length; ++j) {
                int n3 = pdVectorArray[i][j].getSize();
                double[] dArray = pdVectorArray[i][j].m_data;
                for (int k = 0; k < n3; ++k) {
                    stringBuffer.append((float)dArray[k]);
                    stringBuffer.append(StrSpace);
                }
                if (i != n2 - 1 || j != pdVectorArray[i].length - 1) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(StrNL);
            }
        }
        stringBuffer.append(Str1Bracket);
        stringBuffer.append(Str1CBracket);
    }

    protected static void createIdxCoord(StringBuffer stringBuffer, int n, PiVector[] piVectorArray) {
        stringBuffer.append("coordIndex [\n");
        for (int i = 0; i < n; ++i) {
            int[] nArray = piVectorArray[i].m_data;
            for (int j = 0; j < nArray.length; ++j) {
                stringBuffer.append(nArray[j]);
                stringBuffer.append(j < nArray.length - 1 && j % 11 == 10 ? StrNL : StrSpace);
            }
            stringBuffer.append(StrNegOne);
            if (i < n - 1) {
                stringBuffer.append(",");
            }
            stringBuffer.append(StrNL);
        }
        stringBuffer.append(Str1Bracket);
    }

    protected static void createTextureIdxCoord(StringBuffer stringBuffer, int n, PiVector[] piVectorArray) {
        stringBuffer.append("texCoordIndex [\n");
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int[] nArray = piVectorArray[i].m_data;
            for (int j = 0; j < nArray.length; ++j) {
                stringBuffer.append(n2++);
                stringBuffer.append(j < nArray.length - 1 && j % 11 == 10 ? StrNL : StrSpace);
            }
            stringBuffer.append(StrNegOne);
            if (i < n - 1) {
                stringBuffer.append(",");
            }
            stringBuffer.append(StrNL);
        }
        stringBuffer.append(Str1Bracket);
    }

    protected static void drawPointSet(StringBuffer stringBuffer, PgJvxSrc pgJvxSrc) {
        boolean bl;
        stringBuffer.append("geometry PointSet {\n");
        PgWrlLoader.createCoord(stringBuffer, pgJvxSrc.getDimOfVertices(), pgJvxSrc.getNumVertices(), pgJvxSrc.getVertices());
        boolean bl2 = bl = pgJvxSrc.getVertexColors() != null;
        if (bl) {
            PgWrlLoader.createColors(stringBuffer, pgJvxSrc.getNumVertices(), pgJvxSrc.getVertexColors());
        }
        stringBuffer.append(Str1CBracket);
    }

    protected static void drawPolygonSet(StringBuffer stringBuffer, PgJvxSrc pgJvxSrc) {
        stringBuffer.append("geometry IndexedLineSet {\n");
        PgWrlLoader.createCoord(stringBuffer, pgJvxSrc.getDimOfVertices(), pgJvxSrc.getNumVertices(), pgJvxSrc.getVertices());
        if (pgJvxSrc.getVertexColors() != null) {
            PgWrlLoader.createColors(stringBuffer, pgJvxSrc.getNumVertices(), pgJvxSrc.getVertexColors());
        }
        PgWrlLoader.createIdxCoord(stringBuffer, pgJvxSrc.getNumPolygons(), pgJvxSrc.getPolygons());
        if (pgJvxSrc.isShowingPolygonColors() || pgJvxSrc.isShowingSmoothElementColors()) {
            if (pgJvxSrc.isShowingElementFromVertexColors()) {
                stringBuffer.append("colorPerVertex TRUE\n");
            } else {
                stringBuffer.append("colorPerVertex FALSE\n");
                PgWrlLoader.createColors(stringBuffer, pgJvxSrc.getNumPolygons(), pgJvxSrc.getPolygonColors());
            }
        }
        stringBuffer.append(Str1CBracket);
    }

    protected static void drawElementSet(StringBuffer stringBuffer, PgJvxSrc pgJvxSrc) {
        stringBuffer.append("geometry IndexedFaceSet {\n");
        if (pgJvxSrc.isShowingSmoothLighting() || pgJvxSrc.isShowingSmoothElementColors()) {
            stringBuffer.append("creaseAngle " + String.valueOf(pgJvxSrc.getCreaseAngle()) + StrNL);
        }
        stringBuffer.append("solid FALSE\n");
        PgWrlLoader.createCoord(stringBuffer, pgJvxSrc.getDimOfVertices(), pgJvxSrc.getNumVertices(), pgJvxSrc.getVertices());
        if (pgJvxSrc.getVertexColors() != null && pgJvxSrc.isShowingElementFromVertexColors()) {
            PgWrlLoader.createColors(stringBuffer, pgJvxSrc.getNumVertices(), pgJvxSrc.getVertexColors());
        }
        if (pgJvxSrc.getVertexNormals() != null) {
            stringBuffer.append("normalPerVertex TRUE\n");
            PgWrlLoader.createNormals(stringBuffer, pgJvxSrc.getDimOfVertices(), pgJvxSrc.getNumVertices(), pgJvxSrc.getVertexNormals());
        } else if (pgJvxSrc.getElementNormals() != null) {
            stringBuffer.append("normalPerVertex FALSE\n");
            PgWrlLoader.createNormals(stringBuffer, pgJvxSrc.getDimOfVertices(), pgJvxSrc.getNumElements(), pgJvxSrc.getElementNormals());
        }
        if (pgJvxSrc.getVertexTextures() != null) {
            PgWrlLoader.createTextureCoord(stringBuffer, pgJvxSrc.getDimOfTextures(), pgJvxSrc.getNumVertices(), pgJvxSrc.getVertexTextures());
        } else if (pgJvxSrc.getElementTextures() != null) {
            PgWrlLoader.createTextureCoord(stringBuffer, pgJvxSrc.getDimOfTextures(), pgJvxSrc.getNumElements(), pgJvxSrc.getElementTextures());
        }
        PgWrlLoader.createIdxCoord(stringBuffer, pgJvxSrc.getNumElements(), pgJvxSrc.getElements());
        if (pgJvxSrc.isShowingElementColors() || pgJvxSrc.isShowingSmoothElementColors()) {
            if (pgJvxSrc.isShowingElementFromVertexColors()) {
                stringBuffer.append("colorPerVertex TRUE\n");
            } else {
                stringBuffer.append("colorPerVertex FALSE\n");
                PgWrlLoader.createColors(stringBuffer, pgJvxSrc.getNumElements(), pgJvxSrc.getElementColors());
            }
        }
        if (pgJvxSrc.getElementTextures() != null) {
            PgWrlLoader.createTextureIdxCoord(stringBuffer, pgJvxSrc.getNumElements(), pgJvxSrc.getElements());
        }
        stringBuffer.append(Str1CBracket);
    }
}

