/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Random;
import jv.anim.PsAnimation;
import jv.anim.PsTimeEvent;
import jv.anim.PsTimeListenerIf;
import jv.geom.PgEdgeStar;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygonSet;
import jv.geom.PuCleanMesh;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PvCameraIf;
import jv.project.PvDisplayIf;
import jv.vecmath.P_Vector;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuReflect;
import jv.viewer.PvCamera;
import jvx.geom.PgVertexStar;
import jvx.geom.PwCleanMesh;
import jvx.geom.PwModel;
import jvx.numeric.PnMatrix;
import jvx.project.PjWorkshop;
import jvx.util.PuPriorityQueue;

public class PwUnfold
extends PjWorkshop
implements PsTimeListenerIf,
Runnable {
    protected PgElementSet m_geom;
    protected PgElementSet m_geomSave;
    protected int[] m_linTree;
    protected int[] m_linTreeParent;
    protected int m_linTreeDepth;
    protected int[] m_linTreeLevel;
    protected int m_flattenVersion = 0;
    protected static final int FLATTEN_UNIFORMLY = 0;
    protected static final int FLATTEN_ALONG_TREE = 1;
    public static final int WEIGHT_EDGELENGTH = 0;
    public static final int WEIGHT_ELEMENTINDEX = 1;
    public static final int WEIGHT_BY_SELECTION = 2;
    protected boolean m_showSplice;
    protected boolean m_isFlat;
    protected PgElementSet m_splice;
    protected boolean m_isUnfold;
    protected int m_numOfParts = 0;
    protected PsAnimation m_anim = new PsAnimation();
    protected int[][] m_vertOfPolygons;
    protected double[][] m_translatePolygons;
    protected double[][] m_BBoxdata;
    protected boolean m_bAutoFit;
    protected double[] m_diamBB;
    protected boolean m_bPickFixElem;
    protected boolean m_bFixElem;
    protected int m_fixedElement = -1;
    protected static double SPLICES_FIRST = 0.125;
    protected static double SPLICES_SECOND = 0.325;
    protected static double SPLICES_THIRD = 0.1;
    private static boolean m_bFixedSpliceSize = true;
    private static final double m_boxDistFactor = 1.05;
    protected int m_weight;
    protected boolean m_bShowPolygonSet = false;
    protected PgPolygonSet m_polygonSet;
    protected boolean[] m_polygonIsSelected;
    protected int[] m_partnerPolygon;
    private boolean m_bPolygonSetUpdate = false;
    private boolean m_bSpliceUpdate = false;
    private boolean[] m_bFlipSplice;
    private static final Color m_edgeBoundaryColor = Color.blue;
    private static final Color m_edgeSelectedColor = Color.red;
    private static final Color m_edgeUnselectedColor = Color.black;
    private static final boolean m_bLabeLPolygons = false;
    private final int m_polygonLabelType = 1;
    private static final int EDGE_NUMBER = 0;
    private static final int EDGE_ANGLE = 1;
    private int[] m_edgeFoldingAngle;
    private static final boolean m_bColorPolygonsByHue = false;
    private PdMatrix m_eq;
    private PdVector m_tri;
    private PdVector m_oriTri;
    private PdMatrix m_trafo;
    private PdVector m_trans;
    private PdVector m_helpEdge1;
    private PdVector m_helpEdge2;
    protected boolean m_bAnimIsRunning;
    protected boolean m_isImproving = false;
    private boolean noOverlaps = false;
    protected boolean m_bStopImproving = false;
    protected boolean m_bquickImprove = false;
    protected boolean m_bUpdateWhileImprove = true;
    private boolean m_bNoImprove = false;
    protected int[] m_elemTreeTable;
    protected Thread m_thread;
    protected boolean m_bRunning = false;
    protected boolean m_bStopped = true;
    static /* synthetic */ Class class$jvx$geom$PwUnfold;

    public PwUnfold() {
        super(PsConfig.getMessage((int)48014));
        this.m_anim.setName(PsConfig.getMessage((int)54207));
        this.m_anim.addTimeListener((PsTimeListenerIf)this);
        this.m_anim.setTimeInterval(0.0, 100.0, 2.0, 4.0);
        this.m_anim.update((Object)this.m_anim);
        this.m_diamBB = new double[2];
        if (this.getClass() == (class$jvx$geom$PwUnfold == null ? (class$jvx$geom$PwUnfold = PwUnfold.class$("jvx.geom.PwUnfold")) : class$jvx$geom$PwUnfold)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        if (this.m_splice != null) {
            this.removeSplice();
        }
        this.m_showSplice = false;
        this.m_isFlat = false;
        this.m_splice = null;
        this.m_isUnfold = false;
        this.m_bAutoFit = false;
        this.m_bPickFixElem = false;
        this.m_bFixElem = false;
        this.m_weight = 0;
        this.m_bAnimIsRunning = false;
        this.m_helpEdge1 = new PdVector(3);
        this.m_helpEdge2 = new PdVector(3);
        this.stopAnimation();
    }

    public void reset() {
        this.stopAnimation();
        super.reset();
        if (this.m_geom != null && this.m_geomSave != null) {
            this.m_geom.copy((PsObject)this.m_geomSave);
            this.setGeometry(this.m_geom);
        }
    }

    public void ok() {
        this.stopAnimation();
        this.showPolygonSet(false);
        super.ok();
    }

    public void cancel() {
        this.stopAnimation();
        this.removeSplice();
        this.showPolygonSet(false);
        super.cancel();
    }

    public boolean update(Object object) {
        if (object == this.m_geom) {
            if (this.isUpdateSender()) {
                return true;
            }
            this.setGeometry(this.m_geom);
            return true;
        }
        if (object == this.m_polygonSet) {
            if (this.m_bPolygonSetUpdate) {
                return true;
            }
            int n = this.m_polygonSet.getNumPolygons();
            for (int i = 0; i < n; ++i) {
                if (!this.m_polygonSet.hasTagPolygon(i, 1)) continue;
                this.m_polygonSet.clearTagPolygon(i, 1);
                if (this.m_partnerPolygon[i] == -1) continue;
                this.m_polygonSet.clearTagPolygon(this.m_partnerPolygon[i], 1);
                if (!this.m_polygonIsSelected[i]) {
                    this.m_polygonIsSelected[i] = true;
                    this.m_polygonIsSelected[this.m_partnerPolygon[i]] = true;
                    this.m_polygonSet.setPolygonColor(i, m_edgeSelectedColor);
                    this.m_polygonSet.setPolygonColor(this.m_partnerPolygon[i], m_edgeSelectedColor);
                    continue;
                }
                this.m_polygonIsSelected[i] = false;
                this.m_polygonIsSelected[this.m_partnerPolygon[i]] = false;
                this.m_polygonSet.setPolygonColor(i, m_edgeUnselectedColor);
                this.m_polygonSet.setPolygonColor(this.m_partnerPolygon[i], m_edgeUnselectedColor);
            }
            this.recompute();
            return true;
        }
        if (object == this.m_splice) {
            if (!this.m_bSpliceUpdate) {
                int n = this.m_splice.getNumElements();
                for (int i = 0; i < n; ++i) {
                    if (!this.m_splice.hasTagElement(i, 1)) continue;
                    this.m_splice.clearTagElement(i, 1);
                    this.m_bFlipSplice[i] = !this.m_bFlipSplice[i];
                }
                this.showSplices();
                this.m_bSpliceUpdate = true;
                this.m_splice.update((Object)this.m_splice);
                this.m_bSpliceUpdate = false;
            }
            return true;
        }
        if (object == this && this.m_bShowPolygonSet) {
            this.flattenPolygonSet();
            this.m_bPolygonSetUpdate = true;
            this.m_polygonSet.update(null);
            this.m_bPolygonSetUpdate = false;
        }
        return super.update(object);
    }

    private void labelPolygons() {
        int n;
        int n2 = this.m_polygonSet.getNumPolygons();
        int n3 = 1;
        int n4 = 0;
        for (n = 0; n < n2; ++n) {
            if (this.m_polygonIsSelected[n] || this.m_partnerPolygon[n] <= n) continue;
            ++n4;
        }
        for (n = 0; n < n2; ++n) {
            if (!this.m_polygonIsSelected[n]) {
                if (this.m_partnerPolygon[n] > n) {
                    this.m_polygonSet.getPolygon(n).setName("" + this.m_edgeFoldingAngle[n]);
                    this.m_polygonSet.getPolygon(this.m_partnerPolygon[n]).setName("" + this.m_edgeFoldingAngle[this.m_partnerPolygon[n]]);
                    ++n3;
                    continue;
                }
                if (this.m_partnerPolygon[n] != -1) continue;
                this.m_polygonSet.getPolygon(n).setName("");
                continue;
            }
            this.m_polygonSet.getPolygon(n).setName("" + this.m_edgeFoldingAngle[n]);
            if (this.m_partnerPolygon[n] == -1) continue;
            this.m_polygonSet.getPolygon(this.m_partnerPolygon[n]).setName("" + this.m_edgeFoldingAngle[this.m_partnerPolygon[n]]);
        }
        this.m_polygonSet.showPolygonLabels(true);
    }

    protected void recompute() {
        double d = this.m_anim.getTime();
        this.removeSplice();
        int n = this.m_geom.getNumElements();
        for (int i = 0; i < n; ++i) {
            this.m_linTreeParent[i] = -1;
            this.m_linTree[i] = -1;
        }
        this.m_elemTreeTable = null;
        this.m_eq = null;
        this.m_tri = null;
        this.m_oriTri = null;
        this.m_trafo = null;
        this.m_trans = null;
        this.m_numOfParts = 0;
        this.m_helpEdge1 = new PdVector(3);
        this.m_helpEdge2 = new PdVector(3);
        this.m_vertOfPolygons = null;
        this.m_translatePolygons = null;
        this.m_BBoxdata = null;
        this.m_diamBB = new double[2];
        this.m_isFlat = false;
        this.m_isUnfold = false;
        this.m_geom.copy((PsObject)this.m_geomSave);
        this.timestep(d);
    }

    public void setGeometry(PgElementSet pgElementSet) {
        PiVector piVector;
        int n;
        int n2;
        int n3;
        if (pgElementSet == null) {
            PsDebug.warning((String)"Cannot compute unfolding of geometry, given geometry is null");
            return;
        }
        if (pgElementSet.getDimOfVertices() != 3) {
            PsDebug.warning((String)("Cannot compute unfolding of geometry, dimension of vertices is " + pgElementSet.getDimOfVertices() + ". " + "Vertices must have dimension 3."));
            return;
        }
        if (!pgElementSet.checkNeighbour(false)) {
            PsDebug.warning((String)("Cannot unfold this geometry: " + pgElementSet.getName() + "." + " Problems computing the neighbour information."));
            return;
        }
        this.stopAnimation();
        this.m_anim.removeTimeListener((PsTimeListenerIf)this);
        this.m_anim.setTime(this.m_anim.getMinTime());
        this.m_anim.addTimeListener((PsTimeListenerIf)this);
        this.removeSplice();
        this.m_splice = null;
        ((PjWorkshop)this).m_geomSave = null;
        super.setGeometry((PgGeometry)pgElementSet);
        this.m_geom = pgElementSet;
        boolean bl = false;
        if (!PwCleanMesh.hasPlanarElements(this.m_geom, 0.01)) {
            PgElementSet.triangulate((PgElementSet)this.m_geom);
            bl = true;
        }
        if (PwCleanMesh.isDegenerated(this.m_geom)) {
            PuCleanMesh.identifyVertices((PgPointSet)this.m_geom, (double)1.0E-10);
            PuCleanMesh.removeDegenerateElements((PgElementSet)this.m_geom);
            bl = true;
        }
        if (((PjWorkshop)this).m_geomSave == null) {
            bl = true;
        }
        this.m_geomSave = bl ? (PgElementSet)this.m_geom.clone() : (PgElementSet)((PjWorkshop)this).m_geomSave;
        int n4 = this.m_geom.getNumElements();
        this.m_linTree = new int[n4];
        this.m_linTreeParent = new int[n4];
        this.m_linTreeLevel = new int[n4];
        this.m_linTreeDepth = 0;
        for (int i = 0; i < n4; ++i) {
            this.m_linTreeParent[i] = -1;
        }
        this.m_isFlat = false;
        this.m_isUnfold = false;
        PdVector[] pdVectorArray = this.m_geom.getBounds();
        this.m_diamBB[0] = PdVector.dist((PdVector)pdVectorArray[0], (PdVector)pdVectorArray[1]);
        this.m_polygonSet = new PgPolygonSet(this.m_geom.getDimOfVertices());
        this.m_polygonSet.setName("Edges of " + this.m_geom.getName());
        int n5 = 0;
        int n6 = this.m_geom.getNumElements();
        for (n3 = 0; n3 < n6; ++n3) {
            n5 += this.m_geom.getElement(n3).getSize();
        }
        this.m_polygonSet.setNumVertices(n5);
        this.m_polygonSet.setNumPolygons(n5);
        this.m_polygonIsSelected = new boolean[n5];
        this.m_partnerPolygon = new int[n5];
        n3 = 0;
        PiVector[] piVectorArray = new PiVector[n6];
        int n7 = 0;
        this.m_edgeFoldingAngle = new int[n5];
        for (n2 = 0; n2 < n6; ++n2) {
            PiVector piVector2 = this.m_geom.getElement(n2);
            PiVector piVector3 = this.m_geom.getNeighbour(n2);
            n3 = piVector2.getSize();
            piVectorArray[n2] = new PiVector(n3);
            for (n = 0; n < n3; ++n) {
                piVector = new PiVector(2);
                piVector.m_data[0] = n < n3 - 1 ? n7 + 1 : n7 - n3 + 1;
                piVector.m_data[1] = n < n3 - 2 ? n7 + 2 : n7 + 2 - n3;
                this.m_polygonSet.setPolygon(n7, piVector);
                piVectorArray[n2].m_data[n] = n7;
                int n8 = piVector3.m_data[n];
                if (n8 != -1) {
                    if (piVectorArray[n8] != null) {
                        this.m_partnerPolygon[n7] = piVectorArray[n8].m_data[this.m_geom.getOppVertexLocInd(n2, n)];
                        this.m_partnerPolygon[this.m_partnerPolygon[n7]] = n7;
                        if (this.m_geom.hasElementNormals()) {
                            this.m_edgeFoldingAngle[n7] = (int)(PdVector.angle((PdVector)this.m_geom.getElementNormal(n2), (PdVector)this.m_geom.getElementNormal(n8)) + 0.5);
                            if (PdVector.dot((PdVector)PdVector.subNew((PdVector)this.m_geom.getVertex(this.m_geom.getOppVertexInd(n2, n)), (PdVector)this.m_geom.getVertex(piVector2.m_data[n])), (PdVector)this.m_geom.getElementNormal(n2)) > 0.0) {
                                int n9 = n7;
                                this.m_edgeFoldingAngle[n9] = this.m_edgeFoldingAngle[n9] * -1;
                            }
                            this.m_edgeFoldingAngle[this.m_partnerPolygon[n7]] = this.m_edgeFoldingAngle[n7];
                        } else {
                            this.m_edgeFoldingAngle[n7] = 0;
                            this.m_edgeFoldingAngle[this.m_partnerPolygon[n7]] = 0;
                        }
                    }
                } else {
                    this.m_partnerPolygon[n7] = -1;
                    this.m_edgeFoldingAngle[n7] = 0;
                }
                ++n7;
            }
        }
        this.flattenPolygonSet();
        if (pgElementSet.isEnabledEdges()) {
            int n10;
            int n11;
            PgEdgeStar[] pgEdgeStarArray = (PgEdgeStar[])P_Vector.clone((P_Vector[])pgElementSet.getEdgeStars());
            n = pgEdgeStarArray.length;
            pgElementSet.makeEdgeStars();
            piVector = pgElementSet.getEdgeStars();
            if (((PgEdgeStar[])piVector).length < n) {
                n = ((PgEdgeStar[])piVector).length;
            }
            block4: for (n11 = 0; n11 < n; ++n11) {
                if (!pgEdgeStarArray[n11].hasTag(1)) continue;
                for (n10 = 0; n10 < n; ++n10) {
                    if ((pgEdgeStarArray[n11].getVertexInd(0) != piVector[(n11 + n10) % n].getVertexInd(0) || pgEdgeStarArray[n11].getVertexInd(1) != piVector[(n11 + n10) % n].getVertexInd(1)) && (pgEdgeStarArray[n11].getVertexInd(0) != piVector[(n11 + n10) % n].getVertexInd(1) || pgEdgeStarArray[n11].getVertexInd(1) != piVector[(n11 + n10) % n].getVertexInd(0))) continue;
                    piVector[(n11 + n10) % n].setTag(1);
                    continue block4;
                }
            }
            n11 = ((PiVector)piVector).length;
            n10 = -1;
            for (int i = 0; i < n11; ++i) {
                n10 = piVector[i].getValence();
                if (n10 != 2) continue;
                for (int j = 0; j < 2; ++j) {
                    this.m_polygonIsSelected[piVectorArray[piVector[i].getElementInd((int)j)].m_data[piVector[i].getNeighbourLocInd((int)j)]] = piVector[i].hasTag(1);
                }
            }
        } else {
            for (n2 = 0; n2 < n5; ++n2) {
                this.m_polygonIsSelected[n2] = false;
            }
        }
        this.m_polygonSet.assurePolygonColors();
        for (int i = 0; i < n5; ++i) {
            if (this.m_partnerPolygon[i] == -1) {
                this.m_polygonSet.setPolygonColor(i, m_edgeBoundaryColor);
                continue;
            }
            if (this.m_polygonIsSelected[i]) {
                this.m_polygonSet.setPolygonColor(i, m_edgeSelectedColor);
                continue;
            }
            this.m_polygonSet.setPolygonColor(i, m_edgeUnselectedColor);
        }
        this.m_polygonSet.showPolygonColors(true);
        this.m_polygonSet.showVertices(false);
    }

    public void showPolygonSet(boolean bl) {
        this.m_bShowPolygonSet = bl;
        if (bl) {
            this.m_display.addGeometry((PgGeometryIf)this.m_polygonSet);
            this.m_display.selectGeometry((PgGeometryIf)this.m_polygonSet);
            this.m_polygonSet.addUpdateListener((PsUpdateIf)this);
        } else {
            if (this.m_display.containsGeometry((PgGeometryIf)this.m_polygonSet)) {
                this.m_display.removeGeometry((PgGeometryIf)this.m_polygonSet);
                this.m_display.selectGeometry((PgGeometryIf)this.m_geom);
            }
            if (this.m_polygonSet.hasUpdateListener((PsUpdateIf)this)) {
                this.m_polygonSet.removeUpdateListener((PsUpdateIf)this);
            }
        }
    }

    public void unselectAllEdges() {
        int n = this.m_polygonSet.getNumPolygons();
        for (int i = 0; i < n; ++i) {
            this.m_polygonIsSelected[i] = false;
            if (this.m_partnerPolygon[i] == -1) {
                this.m_polygonSet.setPolygonColor(i, m_edgeBoundaryColor);
                continue;
            }
            this.m_polygonSet.setPolygonColor(i, m_edgeUnselectedColor);
        }
    }

    public void setWeight(int n) {
        this.m_weight = n;
    }

    public int getWeight() {
        return this.m_weight;
    }

    protected void buildTreeLevelInformation() {
        Object object;
        int n;
        int n2;
        int n3 = this.m_geom.getNumElements();
        this.m_linTreeDepth = 0;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        int n4 = 0;
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.m_fixedElement == n2) {
                nArray[n5] = n2;
                this.m_linTreeLevel[n2] = 0;
                nArray2[n2] = -1;
                ++n5;
                continue;
            }
            this.m_linTreeLevel[n2] = -1;
            nArray2[n2] = -2;
        }
        n2 = 0;
        while (n4 < n3) {
            if (n4 == n5) {
                while (this.m_linTreeLevel[n2] != -1) {
                    ++n2;
                }
                int n6 = -1;
                for (n = n2; n < n3; ++n) {
                    if (!this.m_geom.hasTagElement(n, 1) || this.m_linTreeLevel[n] != -1) continue;
                    n6 = n;
                    break;
                }
                if (n6 == -1) {
                    n6 = n2++;
                }
                this.m_linTreeLevel[n6] = 0;
                nArray[n5] = n6;
                nArray2[n6] = -1;
                ++n5;
            }
            if (nArray2[nArray[n4]] > -1) {
                this.m_linTreeLevel[nArray[n4]] = this.m_linTreeLevel[nArray2[nArray[n4]]] + 1;
            }
            if (this.m_linTreeLevel[nArray[n4]] > this.m_linTreeDepth) {
                this.m_linTreeDepth = this.m_linTreeLevel[nArray[n4]];
            }
            object = this.m_geom.getNeighbour(nArray[n4]);
            n = object.getSize();
            for (int i = 0; i < n; ++i) {
                if (object.m_data[i] <= -1 || nArray2[object.m_data[i]] != -2) continue;
                nArray[n5] = object.m_data[i];
                nArray2[object.m_data[i]] = nArray[n4];
                ++n5;
            }
            ++n4;
        }
        n4 = 0;
        n5 = 0;
        object = new boolean[n3];
        for (n = 0; n < n3; ++n) {
            object[n] = false;
        }
        for (n = 0; n < n3; ++n) {
            if (this.m_linTreeLevel[n] != 0) continue;
            this.m_linTree[n4] = n;
            object[n] = true;
            this.m_linTreeParent[this.m_linTree[n4]] = -1;
            ++n5;
            while (n4 < n5) {
                PiVector piVector = this.m_geom.getNeighbour(this.m_linTree[n4]);
                int n7 = piVector.getSize();
                for (int i = 0; i < n7; ++i) {
                    if (piVector.m_data[i] <= -1 || object[piVector.m_data[i]] || this.m_linTreeLevel[piVector.m_data[i]] <= this.m_linTreeLevel[this.m_linTree[n4]]) continue;
                    this.m_linTree[n5] = piVector.m_data[i];
                    this.m_linTreeParent[this.m_linTree[n5]] = this.m_geom.getOppVertexLocInd(this.m_linTree[n4], i);
                    ++n5;
                    object[piVector.m_data[i]] = true;
                }
                ++n4;
            }
        }
    }

    public void flatten(double d) {
        int n;
        int n2;
        int n3;
        if (this.m_geom == null) {
            PsDebug.warning((String)"Missing Geometry. Set Geometry first.");
            return;
        }
        this.m_isFlat = d == 1.0;
        if (!this.m_isFlat && this.m_splice != null) {
            this.removeSplice();
            this.m_splice = null;
        }
        if (!this.m_isUnfold) {
            this.computeUnfolding();
            if (!this.m_bNoImprove && this.m_weight != 2) {
                boolean bl = this.m_isFlat;
                this.m_isFlat = true;
                if (this.m_geom.getNumElements() < 250) {
                    this.m_bUpdateWhileImprove = false;
                    this.improveUnfolding();
                    this.m_bUpdateWhileImprove = true;
                }
                this.m_isFlat = bl;
            }
            this.m_fixedElement = this.computeCenterElement();
        }
        if (this.m_flattenVersion == 1) {
            this.buildTreeLevelInformation();
        }
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        PiVector[] piVectorArray = this.m_geom.getElements();
        PdVector[] pdVectorArray2 = this.m_geomSave.getVertices();
        PiVector[] piVectorArray2 = this.m_geomSave.getElements();
        int n4 = this.m_geom.getNumElements();
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < piVectorArray[n3].getSize(); ++n2) {
                for (n = 0; n < 3; ++n) {
                    pdVectorArray[piVectorArray[n3].m_data[n2]].m_data[n] = pdVectorArray2[piVectorArray2[n3].m_data[n2]].m_data[n];
                }
            }
        }
        if (d == 0.0) {
            this.m_geom.makeElementNormals();
            this.m_geom.makeVertexNormals();
            return;
        }
        n3 = this.m_linTree.length - 1;
        int[] nArray = new int[this.m_geom.getNumVertices()];
        int n5 = 0;
        PiVector[] piVectorArray3 = this.m_geom.getNeighbours();
        Object object = new PdMatrix(4);
        PdMatrix pdMatrix = new PdMatrix(3);
        PdVector pdVector = new PdVector(3);
        PdVector pdVector2 = new PdVector(3);
        PdVector pdVector3 = new PdVector(3);
        PdVector pdVector4 = new PdVector(3);
        PdVector pdVector5 = new PdVector(0.0, 0.0, 1.0);
        int n6 = -1;
        int[] nArray2 = new int[n4];
        int n7 = 3;
        double d2 = 0.0;
        while (n3 >= 0) {
            double d3;
            PiVector piVector;
            int n8 = this.m_linTree[n3];
            int n9 = this.m_linTreeParent[n8];
            if (n9 == -1) {
                n6 = 0;
                nArray2[0] = n8;
                n7 = piVectorArray[n8].getSize();
                for (n2 = 0; n2 < n7; ++n2) {
                    nArray[n5] = piVectorArray[n8].m_data[n2];
                    ++n5;
                }
                --n6;
                for (n2 = 0; n2 < n7; ++n2) {
                    if (piVectorArray3[n8].m_data[n2] < 0) continue;
                    nArray2[++n6] = piVectorArray3[n8].m_data[n2];
                }
                while (n6 >= 0) {
                    n8 = nArray2[n6];
                    n9 = this.m_linTreeParent[n8];
                    n7 = piVectorArray[n8].getSize();
                    n2 = (n9 + 3) % n7;
                    while (n2 != (n9 + 1) % n7) {
                        nArray[n5] = piVectorArray[n8].m_data[n2];
                        ++n5;
                        n2 = (n2 + 1) % n7;
                    }
                    --n6;
                    n2 = (n9 + 1) % n7;
                    while (n2 != n9 % n7) {
                        if (piVectorArray3[n8].m_data[n2] >= 0) {
                            nArray2[++n6] = piVectorArray3[n8].m_data[n2];
                        }
                        n2 = (n2 + 1) % n7;
                    }
                }
                n8 = this.m_linTree[n3];
                n9 = this.m_linTreeParent[n8];
                piVector = this.m_geom.getElement(this.m_linTree[n3]);
                this.normalOfElement(this.m_linTree[n3], pdVector);
                d3 = PdVector.angle((PdVector)pdVector, (PdVector)pdVector5);
                pdVector4.cross(pdVector, pdVector5);
                object = pdVector4.sqrLength() < 1.0E-10 ? null : PuReflect.rotateLine((PdVector)this.m_geom.getVertex(piVector.m_data[0]), (PdVector)pdVector4, (double)((d3 *= d) * Math.PI / 180.0));
                d2 = this.m_geom.getVertex((int)piVector.m_data[0]).m_data[2];
                double d4 = this.m_geomSave.getCenterOfGravity().m_data[2];
                if (object != null) {
                    for (n2 = 0; n2 < n5; ++n2) {
                        pdVector3 = this.m_geom.getVertex(nArray[n2]);
                        pdVector4.copy(pdVector3);
                        pdVector3.leftMultAffin(object, pdVector4, true);
                        pdVector3.m_data[2] = pdVector3.m_data[2] + d * (d4 - d2);
                    }
                } else {
                    for (n2 = 0; n2 < n5; ++n2) {
                        pdVector3 = this.m_geom.getVertex(nArray[n2]);
                        pdVector3.m_data[2] = pdVector3.m_data[2] + d * (d4 - d2);
                    }
                }
                --n3;
                n5 = 0;
                continue;
            }
            n6 = 0;
            nArray2[0] = n8;
            while (n6 >= 0) {
                n8 = nArray2[n6];
                n9 = this.m_linTreeParent[n8];
                n7 = piVectorArray[n8].getSize();
                n2 = (n9 + 3) % n7;
                while (n2 != (n9 + 1) % n7) {
                    nArray[n5] = piVectorArray[n8].m_data[n2];
                    ++n5;
                    n2 = (n2 + 1) % n7;
                }
                --n6;
                n2 = (n9 + 1) % n7;
                while (n2 != n9 % n7) {
                    if (piVectorArray3[n8].m_data[n2] >= 0) {
                        nArray2[++n6] = piVectorArray3[n8].m_data[n2];
                    }
                    n2 = (n2 + 1) % n7;
                }
            }
            n8 = this.m_linTree[n3];
            n9 = this.m_linTreeParent[n8];
            piVector = this.m_geom.getElement(this.m_linTree[n3]);
            n7 = piVector.getSize();
            n2 = this.m_linTreeParent[this.m_linTree[n3]];
            PiVector piVector2 = this.m_geom.getElement(piVectorArray3[this.m_linTree[n3]].m_data[n2]);
            if (piVector.m_data[(n2 + 1) % n7] == piVector2.m_data[(this.m_geom.getOppVertexLocInd(this.m_linTree[n3], n2) + 1) % piVector2.getSize()]) {
                this.normalOfElement(this.m_linTree[n3], pdVector);
                this.normalOfElement(piVectorArray3[this.m_linTree[n3]].m_data[n2], pdVector2);
                pdVector2.multScalar(-1.0);
            } else {
                this.normalOfElement(this.m_linTree[n3], pdVector);
                this.normalOfElement(piVectorArray3[this.m_linTree[n3]].m_data[n2], pdVector2);
            }
            d3 = PdVector.angle((PdVector)pdVector, (PdVector)pdVector2);
            if (this.m_flattenVersion == 0) {
                d3 *= d;
            } else if (this.m_linTreeLevel[n8] == 0) {
                d3 *= d;
            } else {
                int n10 = this.m_linTreeLevel[n8];
                if (piVectorArray3[n8].m_data[n2] > -1 && this.m_linTreeLevel[piVectorArray3[n8].m_data[n2]] > n10) {
                    n10 = this.m_linTreeLevel[piVectorArray3[n8].m_data[n2]];
                }
                d3 = d * (double)this.m_linTreeDepth - (double)n10 >= 0.0 ? (d3 *= 1.0) : (d * (double)this.m_linTreeDepth - (double)n10 >= -1.0 ? (d3 *= 1.0 + d * (double)this.m_linTreeDepth - (double)n10) : (d3 *= 0.0));
            }
            pdVector4.sub(this.m_geom.getVertex(piVector.m_data[(n2 + 2) % n7]), this.m_geom.getVertex(piVector.m_data[(n2 + 1) % n7]));
            pdMatrix.setColumn(0, pdVector4);
            pdMatrix.setColumn(1, pdVector);
            pdMatrix.setColumn(2, pdVector2);
            if (pdMatrix.det() < 0.0) {
                d3 = -d3;
            }
            pdVector4.sub(this.m_geom.getVertex(piVector.m_data[(n2 + 2) % n7]), this.m_geom.getVertex(piVector.m_data[(n2 + 1) % n7]));
            object = pdVector4.sqrLength() < 1.0E-10 ? null : PuReflect.rotateLine((PdVector)this.m_geom.getVertex(piVector.m_data[(n2 + 1) % n7]), (PdVector)pdVector4, (double)(d3 * Math.PI / 180.0));
            if (object != null) {
                for (n = 0; n < n5; ++n) {
                    pdVector3 = this.m_geom.getVertex(nArray[n]);
                    pdVector4.copy(pdVector3);
                    pdVector3.leftMultAffin(object, pdVector4, true);
                }
            }
            --n3;
            n5 = 0;
        }
        for (n2 = 0; n2 < this.m_vertOfPolygons.length; ++n2) {
            for (n = 0; n < this.m_vertOfPolygons[n2].length; ++n) {
                if (this.m_BBoxdata[n2][2] == 0.0) {
                    pdVectorArray[this.m_vertOfPolygons[n2][n]].m_data[0] = pdVectorArray[this.m_vertOfPolygons[n2][n]].m_data[0] + d * (this.m_translatePolygons[n2][0] - this.m_BBoxdata[n2][0]);
                    pdVectorArray[this.m_vertOfPolygons[n2][n]].m_data[1] = pdVectorArray[this.m_vertOfPolygons[n2][n]].m_data[1] + d * (this.m_translatePolygons[n2][1] - this.m_BBoxdata[n2][1]);
                    continue;
                }
                double d5 = pdVectorArray[this.m_vertOfPolygons[n2][n]].m_data[0];
                pdVectorArray[this.m_vertOfPolygons[n2][n]].m_data[0] = pdVectorArray[this.m_vertOfPolygons[n2][n]].m_data[0] + (d * (-pdVectorArray[this.m_vertOfPolygons[n2][n]].m_data[1] - pdVectorArray[this.m_vertOfPolygons[n2][n]].m_data[0]) + d * (this.m_translatePolygons[n2][0] + this.m_BBoxdata[n2][3]));
                pdVectorArray[this.m_vertOfPolygons[n2][n]].m_data[1] = pdVectorArray[this.m_vertOfPolygons[n2][n]].m_data[1] + (d * (d5 - pdVectorArray[this.m_vertOfPolygons[n2][n]].m_data[1]) + d * (this.m_translatePolygons[n2][1] - this.m_BBoxdata[n2][0]));
            }
        }
        if (this.m_bFixElem && this.m_fixedElement >= 0 && this.m_fixedElement < n4) {
            this.fixElement(this.m_fixedElement);
        }
        this.m_geom.makeElementNormals();
        this.m_geom.makeVertexNormals();
        if (this.m_bShowPolygonSet) {
            this.flattenPolygonSet();
        }
    }

    private void flattenPolygonSet() {
        int n = this.m_geom.getNumElements();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            PiVector piVector = this.m_geom.getElement(i);
            int n3 = piVector.getSize();
            for (int j = 0; j < n3; ++j) {
                this.m_polygonSet.getVertex(n2).copy(this.m_geom.getVertex(piVector.m_data[j]));
                ++n2;
            }
        }
    }

    public void storeEdges() {
        double d = this.m_anim.getTime();
        PgElementSet pgElementSet = (PgElementSet)this.m_geom.clone();
        PgGeometryIf pgGeometryIf = this.m_display.getSelectedGeometry();
        this.m_display.selectGeometry((PgGeometryIf)this.m_geom);
        boolean bl = this.m_display.containsGeometry((PgGeometryIf)this.m_polygonSet);
        if (bl) {
            this.m_display.removeGeometry((PgGeometryIf)this.m_polygonSet);
        }
        this.m_geom.copy((PsObject)this.m_geomSave);
        boolean bl2 = this.m_geom.isEnabledEdges();
        this.m_geom.setEnabledEdges(true);
        PgEdgeStar[] pgEdgeStarArray = this.m_geom.makeEdgeStars();
        int n = pgEdgeStarArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = pgEdgeStarArray[i].getValence();
            if (n2 == 2 && (this.m_linTreeParent[pgEdgeStarArray[i].getElementInd(0)] == pgEdgeStarArray[i].getNeighbourLocInd(0) || this.m_linTreeParent[pgEdgeStarArray[i].getElementInd(1)] == pgEdgeStarArray[i].getNeighbourLocInd(1))) {
                pgEdgeStarArray[i].setTag(1);
                continue;
            }
            pgEdgeStarArray[i].clearTag(1);
        }
        if (this.m_display != null && this.m_display.getViewer() != null) {
            this.m_display.getViewer().showDialog(47);
        }
        this.m_geom.setEnabledEdges(bl2);
        if (bl) {
            this.m_display.addGeometry((PgGeometryIf)this.m_polygonSet);
        }
        this.m_display.selectGeometry(pgGeometryIf);
        this.m_geom.copy((PsObject)pgElementSet);
        this.timestep(d);
    }

    public void setEnabledFixingElement(boolean bl) {
        this.m_bFixElem = bl;
        this.m_bPickFixElem = bl;
    }

    public boolean isEnabledFixingElement() {
        return this.m_bFixElem;
    }

    public void setFixedElement(int n) {
        this.m_fixedElement = n;
    }

    public int getFixedElement() {
        return this.m_fixedElement;
    }

    public void fitGeometry(boolean bl) {
        this.m_bAutoFit = bl;
    }

    public boolean isFittingGeometry() {
        return this.m_bAutoFit;
    }

    private void fixElement(int n) {
        int n2;
        if (this.m_eq == null) {
            this.m_eq = new PdMatrix(9);
            this.m_tri = new PdVector(9);
            this.m_oriTri = new PdVector(9);
            this.m_trafo = new PdMatrix(3);
            this.m_trans = new PdVector(3);
        }
        int[] nArray = this.m_geom.getElement((int)n).m_data;
        int[] nArray2 = this.m_geomSave.getElement((int)n).m_data;
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        PdVector[] pdVectorArray2 = this.m_geomSave.getVertices();
        double[] dArray = this.m_tri.m_data;
        double[] dArray2 = this.m_oriTri.m_data;
        int n3 = nArray.length - 1;
        PdVector pdVector = new PdVector(3);
        for (n2 = 0; n2 < 3; ++n2) {
            dArray[n2] = pdVectorArray[nArray[1]].m_data[n2] - pdVectorArray[nArray[0]].m_data[n2];
            dArray[n2 + 3] = pdVectorArray[nArray[n3]].m_data[n2] - pdVectorArray[nArray[0]].m_data[n2];
            dArray2[n2] = pdVectorArray2[nArray2[1]].m_data[n2] - pdVectorArray2[nArray2[0]].m_data[n2];
            dArray2[n2 + 3] = pdVectorArray2[nArray2[n3]].m_data[n2] - pdVectorArray2[nArray2[0]].m_data[n2];
        }
        pdVector.m_data[0] = dArray[1] * dArray[5] - dArray[2] * dArray[4];
        pdVector.m_data[1] = dArray[2] * dArray[3] - dArray[0] * dArray[5];
        pdVector.m_data[2] = dArray[0] * dArray[4] - dArray[1] * dArray[3];
        pdVector.normalize();
        for (n2 = 0; n2 < 3; ++n2) {
            dArray[6 + n2] = pdVector.m_data[n2];
        }
        pdVector.m_data[0] = dArray2[1] * dArray2[5] - dArray2[2] * dArray2[4];
        pdVector.m_data[1] = dArray2[2] * dArray2[3] - dArray2[0] * dArray2[5];
        pdVector.m_data[2] = dArray2[0] * dArray2[4] - dArray2[1] * dArray2[3];
        pdVector.normalize();
        for (n2 = 0; n2 < 3; ++n2) {
            dArray2[6 + n2] = pdVector.m_data[n2];
        }
        this.m_eq.setConstant(0.0);
        int n4 = 0;
        for (n2 = 0; n2 < 3; ++n2) {
            this.m_eq.m_data[n2][0] = dArray[n4++];
            this.m_eq.m_data[n2][1] = dArray[n4++];
            this.m_eq.m_data[n2][2] = dArray[n4];
            ++n4;
        }
        n4 = 0;
        for (n2 = 3; n2 < 6; ++n2) {
            this.m_eq.m_data[n2][3] = dArray[n4++];
            this.m_eq.m_data[n2][4] = dArray[n4++];
            this.m_eq.m_data[n2][5] = dArray[n4];
            ++n4;
        }
        n4 = 0;
        for (n2 = 6; n2 < 9; ++n2) {
            this.m_eq.m_data[n2][6] = dArray[n4++];
            this.m_eq.m_data[n2][7] = dArray[n4++];
            this.m_eq.m_data[n2][8] = dArray[n4];
            ++n4;
        }
        for (n2 = 0; n2 < 9; ++n2) {
            dArray[n2] = dArray2[n2];
        }
        dArray2[1] = dArray[3];
        dArray2[2] = dArray[6];
        dArray2[3] = dArray[1];
        dArray2[5] = dArray[7];
        dArray2[6] = dArray[2];
        dArray2[7] = dArray[5];
        PnMatrix.invert(this.m_eq.m_data, this.m_eq.m_data, 9);
        this.m_tri.leftMultMatrix(this.m_eq, this.m_oriTri);
        double[][] dArray3 = this.m_trafo.m_data;
        int n5 = 0;
        for (n2 = 0; n2 < 3; ++n2) {
            for (n4 = 0; n4 < 3; ++n4) {
                dArray3[n2][n4] = dArray[n5++];
            }
        }
        this.m_trans.copyArray(pdVectorArray[nArray[0]]);
        n4 = this.m_geom.getNumVertices();
        for (n2 = 0; n2 < n4; ++n2) {
            pdVectorArray[n2].sub(this.m_trans);
            pdVector.copyArray(pdVectorArray[n2]);
            pdVectorArray[n2].leftMultMatrix(this.m_trafo, pdVector);
            pdVectorArray[n2].add(pdVectorArray2[nArray2[0]]);
        }
    }

    protected int computeCenterElement() {
        PdVector pdVector = this.m_geom.getCenterOfGravity();
        int n = this.m_geom.getNumElements();
        PiVector[] piVectorArray = this.m_geom.getElements();
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        PdVector pdVector2 = new PdVector(3);
        double d = Double.POSITIVE_INFINITY;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int[] nArray = piVectorArray[i].m_data;
            pdVector2.copyArray(pdVectorArray[nArray[0]]);
            for (int j = 1; j < nArray.length; ++j) {
                pdVector2.add(pdVectorArray[nArray[j]]);
            }
            pdVector2.multScalar(1.0 / (double)nArray.length);
            double d2 = PdVector.sqrDist((PdVector)pdVector2, (PdVector)pdVector);
            if (!(d2 < d)) continue;
            n2 = i;
            d = d2;
        }
        return n2;
    }

    public boolean isShowingSplices() {
        return this.m_showSplice;
    }

    public void showSplices(boolean bl) {
        this.m_showSplice = bl;
        if (this.m_showSplice) {
            this.showSplices();
        } else {
            this.removeSplice();
        }
    }

    protected void showSplices() {
        if (this.m_isFlat && this.m_showSplice) {
            this.m_bSpliceUpdate = true;
            if (this.m_splice == null) {
                this.m_splice = new PgElementSet(3);
                this.m_splice.setName(PsConfig.getMessage((boolean)true, (int)45000, (String)"Tabs of unfolded Geometry"));
                this.m_splice.setGlobalElementColor(Color.white);
                this.m_splice.setGlobalElementBackColor(Color.white);
                this.m_splice.addUpdateListener((PsUpdateIf)this);
                if (this.m_bFixElem) {
                    int n = this.m_fixedElement;
                    this.m_fixedElement = -1;
                    this.flatten(1.0);
                    this.computeSplices();
                    this.m_fixedElement = n;
                    this.flatten(1.0);
                    this.transformSplice();
                } else {
                    this.computeSplices();
                }
                Enumeration enumeration = this.m_geom.getDisplayList().elements();
                while (enumeration.hasMoreElements()) {
                    PvDisplayIf pvDisplayIf = (PvDisplayIf)enumeration.nextElement();
                    pvDisplayIf.addGeometry((PgGeometryIf)this.m_splice);
                }
            } else {
                if (this.m_bFixElem) {
                    int n = this.m_fixedElement;
                    this.m_fixedElement = -1;
                    this.flatten(1.0);
                    this.computeSplices();
                    this.m_fixedElement = n;
                    this.flatten(1.0);
                    this.transformSplice();
                } else {
                    this.computeSplices();
                }
                if (!this.m_splice.isVisible()) {
                    this.m_splice.setVisible(true);
                }
            }
            this.m_splice.update((Object)this.m_splice);
            this.m_bSpliceUpdate = false;
        } else if (this.m_splice != null && this.m_splice.isVisible()) {
            this.m_bSpliceUpdate = true;
            this.m_splice.setVisible(false);
            this.m_splice.update((Object)this.m_splice);
            this.m_bSpliceUpdate = false;
            return;
        }
    }

    private void transformSplice() {
        if (this.m_isFlat && this.m_showSplice && this.m_bFixElem && this.m_trafo != null && this.m_fixedElement >= 0) {
            PdVector[] pdVectorArray = this.m_splice.getVertices();
            PdVector pdVector = this.m_geomSave.getVertex(this.m_geomSave.getElement((int)this.m_fixedElement).m_data[0]);
            int n = this.m_splice.getNumVertices();
            PdVector pdVector2 = new PdVector(3);
            for (int i = 0; i < n; ++i) {
                pdVectorArray[i].sub(this.m_trans);
                pdVector2.copyArray(pdVectorArray[i]);
                pdVectorArray[i].leftMultMatrix(this.m_trafo, pdVector2);
                pdVectorArray[i].add(pdVector);
            }
        }
    }

    private void computeSplices() {
        PdVector pdVector;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = 0;
        PiVector[] piVectorArray = this.m_geom.getNeighbours();
        PiVector[] piVectorArray2 = this.m_geomSave.getNeighbours();
        PiVector[] piVectorArray3 = this.m_geom.getElements();
        int n9 = this.m_geom.getNumElements();
        double d = 0.0;
        for (n7 = 0; n7 < n9; ++n7) {
            n6 = piVectorArray3[n7].getSize();
            for (int i = 0; i < n6; ++i) {
                if (n7 >= piVectorArray2[n7].m_data[i] || piVectorArray[n7].m_data[i] != -1) continue;
                ++n8;
                if (!m_bFixedSpliceSize) continue;
                d += PdVector.dist((PdVector)this.m_geom.getVertex(piVectorArray3[n7].m_data[(i + 1) % n6]), (PdVector)this.m_geom.getVertex(piVectorArray3[n7].m_data[(i + 2) % n6]));
            }
        }
        d /= (double)n8;
        this.m_splice.setNumElements(n8);
        this.m_splice.setNumVertices(4 * n8);
        if (this.m_bFlipSplice == null || this.m_bFlipSplice.length != n8) {
            this.m_bFlipSplice = new boolean[n8];
            for (n7 = 0; n7 < n8; ++n7) {
                this.m_bFlipSplice[n7] = false;
            }
        }
        n7 = 0;
        PdVector pdVector2 = new PdVector(3);
        pdVector2.m_data[2] = this.m_geomSave.getCenterOfGravity().m_data[2];
        piVectorArray = this.m_geom.getNeighbours();
        piVectorArray2 = this.m_geomSave.getNeighbours();
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        PdVector[] pdVectorArray2 = this.m_splice.getVertices();
        piVectorArray3 = this.m_geom.getElements();
        int n10 = -1;
        int n11 = this.m_geom.getNumVertices();
        PdVector pdVector3 = new PdVector(n11);
        pdVector3.setConstant(-1.0);
        PgVertexStar pgVertexStar = new PgVertexStar();
        for (n5 = 0; n5 < n9; ++n5) {
            n6 = piVectorArray3[n5].getSize();
            for (n4 = 0; n4 < n6; ++n4) {
                if (!(pdVector3.m_data[piVectorArray3[n5].m_data[n4]] < 0.0)) continue;
                pdVector3.m_data[piVectorArray3[n5].m_data[n4]] = 0.0;
                pgVertexStar.makeVertexStar(this.m_geom, piVectorArray3[n5].m_data[n4], n5);
                n3 = pgVertexStar.getSize();
                PiVector piVector = pgVertexStar.getElement();
                PiVector piVector2 = pgVertexStar.getVertexLocInd();
                for (n2 = 0; n2 < n3; ++n2) {
                    PiVector piVector3 = this.m_geom.getElement(piVector.m_data[n2]);
                    int n12 = piVector3.getSize();
                    n = piVector2.m_data[n2];
                    pdVector = PdVector.subNew((PdVector)this.m_geom.getVertex(piVector3.m_data[(n + n12 - 1) % n12]), (PdVector)this.m_geom.getVertex(piVector3.m_data[n]));
                    PdVector pdVector4 = PdVector.subNew((PdVector)this.m_geom.getVertex(piVector3.m_data[(n + 1) % n12]), (PdVector)this.m_geom.getVertex(piVector3.m_data[n]));
                    double d2 = PdVector.angleWithOrientation((PdVector)pdVector4, (PdVector)pdVector, (PdVector)this.m_geom.getElementNormal(piVector.m_data[n2]));
                    if (d2 < 0.0) {
                        d2 += Math.PI * 2;
                    }
                    int n13 = piVectorArray3[n5].m_data[n4];
                    pdVector3.m_data[n13] = pdVector3.m_data[n13] + d2;
                }
            }
        }
        n5 = -1;
        n3 = -1;
        double d3 = -1.0;
        double d4 = -1.0;
        n9 = this.m_geom.getNumElements();
        for (n4 = 0; n4 < n9; ++n4) {
            for (n2 = 0; n2 < piVectorArray3[n4].getSize(); ++n2) {
                double d5;
                double d6;
                PdVector pdVector5;
                PdVector pdVector6;
                double d7;
                double d8;
                double d9;
                double d10;
                if (n4 >= piVectorArray2[n4].m_data[n2] || piVectorArray[n4].m_data[n2] != -1) continue;
                n10 = this.m_geomSave.getOppVertexLocInd(n4, n2);
                int n14 = n = this.m_geomSave.getElement((int)piVectorArray2[n4].m_data[n2]).m_data[(n10 + 1) % piVectorArray3[piVectorArray2[n4].m_data[n2]].getSize()] == this.m_geomSave.getElement((int)n4).m_data[(n2 + 2) % piVectorArray3[n4].getSize()] ? 1 : 0;
                if (this.m_bFlipSplice[n7 / 4]) {
                    pdVector = this.m_geom.getElementNormal(piVectorArray2[n4].m_data[n2]);
                    d10 = pdVectorArray[piVectorArray3[piVectorArray2[n4].m_data[n2]].m_data[(n10 + 1) % piVectorArray3[piVectorArray2[n4].m_data[n2]].getSize()]].m_data[0];
                    d9 = pdVectorArray[piVectorArray3[piVectorArray2[n4].m_data[n2]].m_data[(n10 + 1) % piVectorArray3[piVectorArray2[n4].m_data[n2]].getSize()]].m_data[1];
                    d8 = pdVectorArray[piVectorArray3[piVectorArray2[n4].m_data[n2]].m_data[(n10 + 2) % piVectorArray3[piVectorArray2[n4].m_data[n2]].getSize()]].m_data[0];
                    d7 = pdVectorArray[piVectorArray3[piVectorArray2[n4].m_data[n2]].m_data[(n10 + 2) % piVectorArray3[piVectorArray2[n4].m_data[n2]].getSize()]].m_data[1];
                    n5 = piVectorArray3[piVectorArray2[n4].m_data[n2]].m_data[(n10 + 1) % piVectorArray3[piVectorArray2[n4].m_data[n2]].getSize()];
                    n3 = piVectorArray3[piVectorArray2[n4].m_data[n2]].m_data[(n10 + 2) % piVectorArray3[piVectorArray2[n4].m_data[n2]].getSize()];
                    if (n != 0) {
                        pdVector6 = PdVector.subNew((PdVector)pdVectorArray[piVectorArray3[n4].m_data[(n2 + 2) % piVectorArray3[n4].getSize()]], (PdVector)pdVectorArray[piVectorArray3[n4].m_data[(n2 + 1) % piVectorArray3[n4].getSize()]]);
                        pdVector5 = PdVector.subNew((PdVector)pdVectorArray[piVectorArray3[n4].m_data[n2]], (PdVector)pdVectorArray[piVectorArray3[n4].m_data[(n2 + 1) % piVectorArray3[n4].getSize()]]);
                        d4 = PdVector.angleWithOrientation((PdVector)pdVector6, (PdVector)pdVector5, (PdVector)this.m_geom.getElementNormal(n4));
                        pdVector6 = PdVector.subNew((PdVector)pdVectorArray[piVectorArray3[n4].m_data[(n2 + 3) % piVectorArray3[n4].getSize()]], (PdVector)pdVectorArray[piVectorArray3[n4].m_data[(n2 + 2) % piVectorArray3[n4].getSize()]]);
                        pdVector5 = PdVector.subNew((PdVector)pdVectorArray[piVectorArray3[n4].m_data[(n2 + 1) % piVectorArray3[n4].getSize()]], (PdVector)pdVectorArray[piVectorArray3[n4].m_data[(n2 + 2) % piVectorArray3[n4].getSize()]]);
                        d3 = PdVector.angleWithOrientation((PdVector)pdVector6, (PdVector)pdVector5, (PdVector)this.m_geom.getElementNormal(n4));
                    } else {
                        pdVector6 = PdVector.subNew((PdVector)pdVectorArray[piVectorArray3[n4].m_data[(n2 + 2) % piVectorArray3[n4].getSize()]], (PdVector)pdVectorArray[piVectorArray3[n4].m_data[(n2 + 1) % piVectorArray3[n4].getSize()]]);
                        pdVector5 = PdVector.subNew((PdVector)pdVectorArray[piVectorArray3[n4].m_data[n2]], (PdVector)pdVectorArray[piVectorArray3[n4].m_data[(n2 + 1) % piVectorArray3[n4].getSize()]]);
                        d3 = PdVector.angleWithOrientation((PdVector)pdVector6, (PdVector)pdVector5, (PdVector)this.m_geom.getElementNormal(n4));
                        pdVector6 = PdVector.subNew((PdVector)pdVectorArray[piVectorArray3[n4].m_data[(n2 + 3) % piVectorArray3[n4].getSize()]], (PdVector)pdVectorArray[piVectorArray3[n4].m_data[(n2 + 2) % piVectorArray3[n4].getSize()]]);
                        pdVector5 = PdVector.subNew((PdVector)pdVectorArray[piVectorArray3[n4].m_data[(n2 + 1) % piVectorArray3[n4].getSize()]], (PdVector)pdVectorArray[piVectorArray3[n4].m_data[(n2 + 2) % piVectorArray3[n4].getSize()]]);
                        d4 = PdVector.angleWithOrientation((PdVector)pdVector6, (PdVector)pdVector5, (PdVector)this.m_geom.getElementNormal(n4));
                    }
                } else {
                    pdVector = this.m_geom.getElementNormal(n4);
                    d10 = pdVectorArray[piVectorArray3[n4].m_data[(n2 + 1) % piVectorArray3[n4].getSize()]].m_data[0];
                    d9 = pdVectorArray[piVectorArray3[n4].m_data[(n2 + 1) % piVectorArray3[n4].getSize()]].m_data[1];
                    d8 = pdVectorArray[piVectorArray3[n4].m_data[(n2 + 2) % piVectorArray3[n4].getSize()]].m_data[0];
                    d7 = pdVectorArray[piVectorArray3[n4].m_data[(n2 + 2) % piVectorArray3[n4].getSize()]].m_data[1];
                    n5 = piVectorArray3[n4].m_data[(n2 + 1) % piVectorArray3[n4].getSize()];
                    n3 = piVectorArray3[n4].m_data[(n2 + 2) % piVectorArray3[n4].getSize()];
                    if (n != 0) {
                        pdVector6 = PdVector.subNew((PdVector)pdVectorArray[piVectorArray3[piVectorArray2[n4].m_data[n2]].m_data[(n10 + 2) % piVectorArray3[piVectorArray2[n4].m_data[n2]].getSize()]], (PdVector)pdVectorArray[piVectorArray3[piVectorArray2[n4].m_data[n2]].m_data[(n10 + 1) % piVectorArray3[piVectorArray2[n4].m_data[n2]].getSize()]]);
                        pdVector5 = PdVector.subNew((PdVector)pdVectorArray[piVectorArray3[piVectorArray2[n4].m_data[n2]].m_data[n10]], (PdVector)pdVectorArray[piVectorArray3[piVectorArray2[n4].m_data[n2]].m_data[(n10 + 1) % piVectorArray3[piVectorArray2[n4].m_data[n2]].getSize()]]);
                        d4 = PdVector.angleWithOrientation((PdVector)pdVector6, (PdVector)pdVector5, (PdVector)this.m_geom.getElementNormal(piVectorArray2[n4].m_data[n2]));
                        pdVector6 = PdVector.subNew((PdVector)pdVectorArray[piVectorArray3[piVectorArray2[n4].m_data[n2]].m_data[(n10 + 3) % piVectorArray3[piVectorArray2[n4].m_data[n2]].getSize()]], (PdVector)pdVectorArray[piVectorArray3[piVectorArray2[n4].m_data[n2]].m_data[(n10 + 2) % piVectorArray3[piVectorArray2[n4].m_data[n2]].getSize()]]);
                        pdVector5 = PdVector.subNew((PdVector)pdVectorArray[piVectorArray3[piVectorArray2[n4].m_data[n2]].m_data[(n10 + 1) % piVectorArray3[piVectorArray2[n4].m_data[n2]].getSize()]], (PdVector)pdVectorArray[piVectorArray3[piVectorArray2[n4].m_data[n2]].m_data[(n10 + 2) % piVectorArray3[piVectorArray2[n4].m_data[n2]].getSize()]]);
                        d3 = PdVector.angleWithOrientation((PdVector)pdVector6, (PdVector)pdVector5, (PdVector)this.m_geom.getElementNormal(piVectorArray2[n4].m_data[n2]));
                    } else {
                        pdVector6 = PdVector.subNew((PdVector)pdVectorArray[piVectorArray3[piVectorArray2[n4].m_data[n2]].m_data[(n10 + 2) % piVectorArray3[piVectorArray2[n4].m_data[n2]].getSize()]], (PdVector)pdVectorArray[piVectorArray3[piVectorArray2[n4].m_data[n2]].m_data[(n10 + 1) % piVectorArray3[piVectorArray2[n4].m_data[n2]].getSize()]]);
                        pdVector5 = PdVector.subNew((PdVector)pdVectorArray[piVectorArray3[piVectorArray2[n4].m_data[n2]].m_data[n10]], (PdVector)pdVectorArray[piVectorArray3[piVectorArray2[n4].m_data[n2]].m_data[(n10 + 1) % piVectorArray3[piVectorArray2[n4].m_data[n2]].getSize()]]);
                        d3 = PdVector.angleWithOrientation((PdVector)pdVector6, (PdVector)pdVector5, (PdVector)this.m_geom.getElementNormal(piVectorArray2[n4].m_data[n2]));
                        pdVector6 = PdVector.subNew((PdVector)pdVectorArray[piVectorArray3[piVectorArray2[n4].m_data[n2]].m_data[(n10 + 3) % piVectorArray3[piVectorArray2[n4].m_data[n2]].getSize()]], (PdVector)pdVectorArray[piVectorArray3[piVectorArray2[n4].m_data[n2]].m_data[(n10 + 2) % piVectorArray3[piVectorArray2[n4].m_data[n2]].getSize()]]);
                        pdVector5 = PdVector.subNew((PdVector)pdVectorArray[piVectorArray3[piVectorArray2[n4].m_data[n2]].m_data[(n10 + 1) % piVectorArray3[piVectorArray2[n4].m_data[n2]].getSize()]], (PdVector)pdVectorArray[piVectorArray3[piVectorArray2[n4].m_data[n2]].m_data[(n10 + 2) % piVectorArray3[piVectorArray2[n4].m_data[n2]].getSize()]]);
                        d4 = PdVector.angleWithOrientation((PdVector)pdVector6, (PdVector)pdVector5, (PdVector)this.m_geom.getElementNormal(piVectorArray2[n4].m_data[n2]));
                    }
                }
                if (d3 < 0.0) {
                    d3 += Math.PI * 2;
                }
                if (d4 < 0.0) {
                    d4 += Math.PI * 2;
                }
                pdVector2.m_data[0] = d10 * (1.0 - SPLICES_FIRST) + d8 * SPLICES_FIRST;
                pdVector2.m_data[1] = d9 * (1.0 - SPLICES_FIRST) + d7 * SPLICES_FIRST;
                pdVectorArray2[n7++].copyArray(pdVector2);
                pdVector2.m_data[0] = d10 * SPLICES_FIRST + d8 * (1.0 - SPLICES_FIRST);
                pdVector2.m_data[1] = d9 * SPLICES_FIRST + d7 * (1.0 - SPLICES_FIRST);
                pdVectorArray2[n7++].copyArray(pdVector2);
                double d11 = PdVector.dist((PdVector)pdVectorArray[piVectorArray3[n4].m_data[(n2 + 1) % piVectorArray3[n4].getSize()]], (PdVector)pdVectorArray[piVectorArray3[n4].m_data[(n2 + 2) % piVectorArray3[n4].getSize()]]);
                double d12 = m_bFixedSpliceSize && d11 > 1.0E-10 ? d * SPLICES_THIRD / d11 : SPLICES_THIRD;
                double d13 = 90.0;
                if (SPLICES_SECOND != 0.0) {
                    d13 = 57.29577951308232 * Math.atan(d12 / SPLICES_SECOND);
                }
                double d14 = d13;
                if (d13 > 57.29577951308232 * d3) {
                    d13 = 57.29577951308232 * d3;
                }
                if (d14 > 57.29577951308232 * d4) {
                    d14 = 57.29577951308232 * d4;
                }
                if (d13 > 360.0 - 57.29577951308232 * pdVector3.m_data[n5]) {
                    d13 = 360.0 - 57.29577951308232 * pdVector3.m_data[n5];
                }
                if (d14 > 360.0 - 57.29577951308232 * pdVector3.m_data[n3]) {
                    d14 = 360.0 - 57.29577951308232 * pdVector3.m_data[n3];
                }
                if ((d6 = d12 / Math.tan(Math.PI / 180 * d13)) + (d5 = d12 / Math.tan(Math.PI / 180 * d14)) > 1.0) {
                    double d15 = d6 + d5;
                    d6 /= d15;
                    d5 /= d15;
                    d12 /= d15;
                }
                PdVector pdVector7 = new PdVector(d8 - d10, d7 - d9, 0.0);
                PdVector pdVector8 = new PdVector(d7 - d9, -d8 + d10, 0.0);
                if (PdVector.dot((PdVector)PdVector.crossNew((PdVector)pdVector7, (PdVector)pdVector), (PdVector)pdVector8) > 0.0) {
                    pdVector2.m_data[0] = (-d9 + d7) * d12 + d10 * d5 + d8 * (1.0 - d5);
                    pdVector2.m_data[1] = (d10 - d8) * d12 + d9 * d5 + d7 * (1.0 - d5);
                    pdVectorArray2[n7++].copyArray(pdVector2);
                    pdVector2.m_data[0] = (-d9 + d7) * d12 + d10 * (1.0 - d6) + d8 * d6;
                    pdVector2.m_data[1] = (d10 - d8) * d12 + d9 * (1.0 - d6) + d7 * d6;
                    pdVectorArray2[n7++].copyArray(pdVector2);
                    continue;
                }
                pdVector2.m_data[0] = (d9 - d7) * d12 + d10 * d5 + d8 * (1.0 - d5);
                pdVector2.m_data[1] = (-d10 + d8) * d12 + d9 * d5 + d7 * (1.0 - d5);
                pdVectorArray2[n7++].copyArray(pdVector2);
                pdVector2.m_data[0] = (d9 - d7) * d12 + d10 * (1.0 - d6) + d8 * d6;
                pdVector2.m_data[1] = (-d10 + d8) * d12 + d9 * (1.0 - d6) + d7 * d6;
                pdVectorArray2[n7++].copyArray(pdVector2);
            }
        }
        n = this.m_splice.getNumElements();
        for (n4 = 0; n4 < n; ++n4) {
            n2 = 4 * n4;
            this.m_splice.setElement(n4, n2, n2 + 1, n2 + 2, n2 + 3);
        }
        this.m_splice.makeVertexNormals();
        this.m_splice.makeElementNormals();
    }

    public void unfold() {
        this.flatten(1.0);
    }

    public void refold() {
        this.flatten(0.0);
    }

    private void normalOfElement(int n, PdVector pdVector) {
        PiVector piVector = this.m_geom.getElement(n);
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        pdVector.setConstant(0.0);
        int n2 = piVector.m_data.length;
        if (n2 == 3) {
            this.m_helpEdge1.sub(pdVectorArray[piVector.m_data[0]], pdVectorArray[piVector.m_data[1]]);
            this.m_helpEdge2.sub(pdVectorArray[piVector.m_data[2]], pdVectorArray[piVector.m_data[1]]);
            pdVector.m_data[0] = pdVector.m_data[0] + (this.m_helpEdge1.m_data[1] * this.m_helpEdge2.m_data[2] - this.m_helpEdge1.m_data[2] * this.m_helpEdge2.m_data[1]);
            pdVector.m_data[1] = pdVector.m_data[1] + (-this.m_helpEdge1.m_data[0] * this.m_helpEdge2.m_data[2] + this.m_helpEdge1.m_data[2] * this.m_helpEdge2.m_data[0]);
            pdVector.m_data[2] = pdVector.m_data[2] + (this.m_helpEdge1.m_data[0] * this.m_helpEdge2.m_data[1] - this.m_helpEdge1.m_data[1] * this.m_helpEdge2.m_data[0]);
        } else {
            for (int i = 0; i < n2; ++i) {
                this.m_helpEdge1.sub(pdVectorArray[piVector.m_data[i]], pdVectorArray[piVector.m_data[(i + 1) % n2]]);
                this.m_helpEdge2.sub(pdVectorArray[piVector.m_data[(i + 2) % n2]], pdVectorArray[piVector.m_data[(i + 1) % n2]]);
                pdVector.m_data[0] = pdVector.m_data[0] + (this.m_helpEdge1.m_data[1] * this.m_helpEdge2.m_data[2] - this.m_helpEdge1.m_data[2] * this.m_helpEdge2.m_data[1]);
                pdVector.m_data[1] = pdVector.m_data[1] + (-this.m_helpEdge1.m_data[0] * this.m_helpEdge2.m_data[2] + this.m_helpEdge1.m_data[2] * this.m_helpEdge2.m_data[0]);
                pdVector.m_data[2] = pdVector.m_data[2] + (this.m_helpEdge1.m_data[0] * this.m_helpEdge2.m_data[1] - this.m_helpEdge1.m_data[1] * this.m_helpEdge2.m_data[0]);
            }
        }
        pdVector.normalize();
    }

    private void computeUnfolding() {
        int n;
        int n2;
        int n3;
        if (this.m_geom == null) {
            PsDebug.warning((String)"Missing Geometry. Set Geometry first.");
            return;
        }
        PgElementSet pgElementSet = this.m_geomSave;
        PiVector[] piVectorArray = pgElementSet.getNeighbours();
        int n4 = this.m_geom.getNumElements();
        double[][] dArrayArray = new double[n4][];
        PiVector[] piVectorArray2 = this.m_geom.getElements();
        if (this.m_weight == 1) {
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = piVectorArray2[n3].getSize();
                dArrayArray[n3] = new double[n2];
                for (n = 0; n < n2; ++n) {
                    dArrayArray[n3][n] = Math.abs(n3 - piVectorArray[n3].m_data[n]);
                }
            }
        } else if (this.m_weight == 2) {
            int n5 = 0;
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = piVectorArray2[n3].getSize();
                dArrayArray[n3] = new double[n2];
                for (n = 0; n < n2; ++n) {
                    dArrayArray[n3][n] = this.m_polygonIsSelected[n5] ? 0.0 : Double.POSITIVE_INFINITY;
                    ++n5;
                }
            }
        } else {
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = piVectorArray2[n3].getSize();
                dArrayArray[n3] = new double[n2];
                for (n = 0; n < n2; ++n) {
                    dArrayArray[n3][n] = -this.m_geom.getEdgeLength(n3, n);
                }
            }
        }
        PwModel.shrink(this.m_geom, 1.0);
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        PuPriorityQueue puPriorityQueue = new PuPriorityQueue(n4, Double.MAX_VALUE);
        int n6 = 0;
        int n7 = -1;
        int n8 = -1;
        Object object = new PdMatrix(4);
        PdVector pdVector = new PdVector(0.0, 0.0, 1.0);
        PdVector pdVector2 = new PdVector(3);
        PdVector pdVector3 = new PdVector(3);
        PdVector pdVector4 = new PdVector(3);
        PdVector pdVector5 = new PdVector(3);
        PdVector pdVector6 = new PdVector(3);
        PdVector[] pdVectorArray2 = new PdVector[]{new PdVector(3), new PdVector(3)};
        double[][] dArray = new double[this.m_geom.getNumEdges()][4];
        boolean[] blArray = new boolean[dArray.length];
        int[][] nArray = new int[dArray.length][2];
        int n9 = 0;
        boolean bl = true;
        boolean bl2 = false;
        double[] dArray2 = new double[2];
        double[][] dArray3 = new double[3][2];
        double[] dArray4 = new double[4];
        int n10 = -1;
        double d = 1.0E-10;
        d *= 100.0;
        double d2 = -1.0;
        double d3 = -1.0;
        while ((n7 = puPriorityQueue.extractMin()) != -1) {
            int n11 = piVectorArray2[n7].getSize();
            if (this.m_linTreeParent[n7] == -1) {
                this.normalOfElement(n7, pdVector2);
                double d4 = PdVector.angle((PdVector)pdVector2, (PdVector)pdVector);
                pdVector4.cross(pdVector2, pdVector);
                object = pdVector4.sqrLength() < 1.0E-10 ? null : PuReflect.rotateLine((PdVector)pdVectorArray[piVectorArray2[n7].m_data[0]], (PdVector)pdVector4, (double)(d4 * Math.PI / 180.0));
                if (Math.abs(d4) < 1.0E-10 || object == null) {
                    for (n3 = 0; n3 < n11; ++n3) {
                        pdVectorArray[piVectorArray2[n7].m_data[n3]].m_data[2] = 0.0;
                    }
                } else {
                    pdVector4.cross(pdVector2, pdVector);
                    object = pdVector4.sqrLength() < 1.0E-10 ? null : PuReflect.rotateLine((PdVector)pdVectorArray[piVectorArray2[n7].m_data[0]], (PdVector)pdVector4, (double)(d4 * Math.PI / 180.0));
                    double[] dArray5 = object.m_data[2];
                    dArray5[3] = dArray5[3] - pdVectorArray[piVectorArray2[n7].m_data[0]].m_data[2];
                    for (n3 = 0; n3 < n11; ++n3) {
                        pdVector4.copy(pdVectorArray[piVectorArray2[n7].m_data[n3]]);
                        pdVectorArray[piVectorArray2[n7].m_data[n3]].leftMultAffin(object, pdVector4, true);
                    }
                }
                n9 = n11;
                for (n3 = 0; n3 < n11 - 1; ++n3) {
                    nArray[n3][0] = n7;
                    nArray[n3][1] = (n3 - 1 + n11) % n11;
                    if (pdVectorArray[piVectorArray2[n7].m_data[n3]].m_data[0] < pdVectorArray[piVectorArray2[n7].m_data[n3 + 1]].m_data[0]) {
                        dArray[n3][0] = pdVectorArray[piVectorArray2[n7].m_data[n3]].m_data[0];
                        dArray[n3][1] = pdVectorArray[piVectorArray2[n7].m_data[n3 + 1]].m_data[0];
                        if (pdVectorArray[piVectorArray2[n7].m_data[n3]].m_data[1] < pdVectorArray[piVectorArray2[n7].m_data[n3 + 1]].m_data[1]) {
                            dArray[n3][2] = pdVectorArray[piVectorArray2[n7].m_data[n3]].m_data[1];
                            dArray[n3][3] = pdVectorArray[piVectorArray2[n7].m_data[n3 + 1]].m_data[1];
                            blArray[n3] = true;
                            continue;
                        }
                        dArray[n3][2] = pdVectorArray[piVectorArray2[n7].m_data[n3 + 1]].m_data[1];
                        dArray[n3][3] = pdVectorArray[piVectorArray2[n7].m_data[n3]].m_data[1];
                        blArray[n3] = false;
                        continue;
                    }
                    dArray[n3][0] = pdVectorArray[piVectorArray2[n7].m_data[n3 + 1]].m_data[0];
                    dArray[n3][1] = pdVectorArray[piVectorArray2[n7].m_data[n3]].m_data[0];
                    if (pdVectorArray[piVectorArray2[n7].m_data[n3]].m_data[1] < pdVectorArray[piVectorArray2[n7].m_data[n3 + 1]].m_data[1]) {
                        dArray[n3][2] = pdVectorArray[piVectorArray2[n7].m_data[n3]].m_data[1];
                        dArray[n3][3] = pdVectorArray[piVectorArray2[n7].m_data[n3 + 1]].m_data[1];
                        blArray[n3] = false;
                        continue;
                    }
                    dArray[n3][2] = pdVectorArray[piVectorArray2[n7].m_data[n3 + 1]].m_data[1];
                    dArray[n3][3] = pdVectorArray[piVectorArray2[n7].m_data[n3]].m_data[1];
                    blArray[n3] = true;
                }
                nArray[n11 - 1][0] = n7;
                nArray[n11 - 1][1] = n11 - 2;
                if (pdVectorArray[piVectorArray2[n7].m_data[n11 - 1]].m_data[0] < pdVectorArray[piVectorArray2[n7].m_data[0]].m_data[0]) {
                    dArray[n11 - 1][0] = pdVectorArray[piVectorArray2[n7].m_data[n11 - 1]].m_data[0];
                    dArray[n11 - 1][1] = pdVectorArray[piVectorArray2[n7].m_data[0]].m_data[0];
                    if (pdVectorArray[piVectorArray2[n7].m_data[n11 - 1]].m_data[1] < pdVectorArray[piVectorArray2[n7].m_data[0]].m_data[1]) {
                        dArray[n11 - 1][2] = pdVectorArray[piVectorArray2[n7].m_data[n11 - 1]].m_data[1];
                        dArray[n11 - 1][3] = pdVectorArray[piVectorArray2[n7].m_data[0]].m_data[1];
                        blArray[n11 - 1] = true;
                    } else {
                        dArray[n11 - 1][2] = pdVectorArray[piVectorArray2[n7].m_data[0]].m_data[1];
                        dArray[n11 - 1][3] = pdVectorArray[piVectorArray2[n7].m_data[n11 - 1]].m_data[1];
                        blArray[n11 - 1] = false;
                    }
                } else {
                    dArray[n11 - 1][0] = pdVectorArray[piVectorArray2[n7].m_data[0]].m_data[0];
                    dArray[n11 - 1][1] = pdVectorArray[piVectorArray2[n7].m_data[n11 - 1]].m_data[0];
                    if (pdVectorArray[piVectorArray2[n7].m_data[n11 - 1]].m_data[1] < pdVectorArray[piVectorArray2[n7].m_data[0]].m_data[1]) {
                        dArray[n11 - 1][2] = pdVectorArray[piVectorArray2[n7].m_data[n11 - 1]].m_data[1];
                        dArray[n11 - 1][3] = pdVectorArray[piVectorArray2[n7].m_data[0]].m_data[1];
                        blArray[n11 - 1] = false;
                    } else {
                        dArray[n11 - 1][2] = pdVectorArray[piVectorArray2[n7].m_data[0]].m_data[1];
                        dArray[n11 - 1][3] = pdVectorArray[piVectorArray2[n7].m_data[n11 - 1]].m_data[1];
                        blArray[n11 - 1] = true;
                    }
                }
                this.m_linTree[n6] = n7;
                ++n6;
            } else {
                pdVector5.sub(pdVectorArray[piVectorArray2[n7].m_data[(this.m_linTreeParent[n7] + 2) % n11]], pdVectorArray[piVectorArray2[n7].m_data[(this.m_linTreeParent[n7] + 1) % n11]]);
                pdVector5.normalize();
                pdVector6.sub(pdVectorArray[piVectorArray2[n7].m_data[this.m_linTreeParent[n7]]], pdVectorArray[piVectorArray2[n7].m_data[(this.m_linTreeParent[n7] + 1) % n11]]);
                pdVector4.multScalar(pdVector5, PdVector.dot((PdVector)pdVector5, (PdVector)pdVector6));
                pdVector6.sub(pdVector4);
                pdVector6.normalize();
                pdVectorArray2[0].setSize(n11);
                pdVectorArray2[1].setSize(n11);
                pdVector3 = pdVectorArray[piVectorArray2[n7].m_data[(this.m_linTreeParent[n7] + 1) % n11]];
                for (n3 = 0; n3 < n11; ++n3) {
                    pdVector4.sub(pdVectorArray[piVectorArray2[n7].m_data[n3]], pdVector3);
                    pdVectorArray2[0].setEntry(n3, PdVector.dot((PdVector)pdVector5, (PdVector)pdVector4));
                    pdVector4.sub(pdVectorArray[piVectorArray2[n7].m_data[n3]], pdVector3);
                    pdVectorArray2[1].setEntry(n3, PdVector.dot((PdVector)pdVector6, (PdVector)pdVector4));
                }
                int n12 = piVectorArray[n7].m_data[this.m_linTreeParent[n7]];
                int n13 = piVectorArray2[n12].getSize();
                int n14 = pgElementSet.getOppVertexLocInd(n7, this.m_linTreeParent[n7]);
                bl = true;
                bl2 = false;
                if (pgElementSet.getElement((int)n7).m_data[(this.m_linTreeParent[n7] + 1) % n11] == pgElementSet.getElement((int)n12).m_data[(n14 + 1) % n13]) {
                    bl = false;
                    pdVector5.sub(pdVectorArray[piVectorArray2[n12].m_data[(n14 + 2) % n13]], pdVectorArray[piVectorArray2[n12].m_data[(n14 + 1) % n13]]);
                    pdVector5.normalize();
                    pdVector6.m_data[0] = -pdVector5.m_data[1];
                    pdVector6.m_data[1] = pdVector5.m_data[0];
                    pdVector6.m_data[2] = 0.0;
                    pdVector4.sub(pdVectorArray[piVectorArray2[n12].m_data[n14]], pdVectorArray[piVectorArray2[n12].m_data[(n14 + 1) % n13]]);
                    if (PdVector.dot((PdVector)pdVector6, (PdVector)pdVector4) > 0.0) {
                        pdVector6.multScalar(-1.0);
                    }
                    dArray2[0] = pdVectorArray[piVectorArray2[n12].m_data[(n14 + 1) % n13]].m_data[0];
                    dArray2[1] = pdVectorArray[piVectorArray2[n12].m_data[(n14 + 1) % n13]].m_data[1];
                } else {
                    pdVector5.sub(pdVectorArray[piVectorArray2[n12].m_data[(n14 + 1) % n13]], pdVectorArray[piVectorArray2[n12].m_data[(n14 + 2) % n13]]);
                    pdVector5.normalize();
                    pdVector6.m_data[0] = -pdVector5.m_data[1];
                    pdVector6.m_data[1] = pdVector5.m_data[0];
                    pdVector6.m_data[2] = 0.0;
                    pdVector4.sub(pdVectorArray[piVectorArray2[n12].m_data[n14]], pdVectorArray[piVectorArray2[n12].m_data[(n14 + 2) % n13]]);
                    if (PdVector.dot((PdVector)pdVector6, (PdVector)pdVector4) > 0.0) {
                        pdVector6.multScalar(-1.0);
                    }
                    dArray2[0] = pdVectorArray[piVectorArray2[n12].m_data[(n14 + 2) % n13]].m_data[0];
                    dArray2[1] = pdVectorArray[piVectorArray2[n12].m_data[(n14 + 2) % n13]].m_data[1];
                }
                if (dArray3.length != n11) {
                    dArray3 = new double[n11][2];
                }
                for (n3 = 0; n3 < n11; ++n3) {
                    dArray3[n3][0] = dArray2[0] + pdVectorArray2[0].m_data[n3] * pdVector5.m_data[0] + pdVectorArray2[1].m_data[n3] * pdVector6.m_data[0];
                    dArray3[n3][1] = dArray2[1] + pdVectorArray2[0].m_data[n3] * pdVector5.m_data[1] + pdVectorArray2[1].m_data[n3] * pdVector6.m_data[1];
                }
                dArray4[0] = dArray3[0][0];
                dArray4[1] = dArray3[0][0];
                dArray4[2] = dArray3[0][1];
                dArray4[3] = dArray3[0][1];
                for (n3 = 1; n3 < n11; ++n3) {
                    dArray4[0] = Math.min(dArray4[0], dArray3[n3][0]);
                    dArray4[1] = Math.max(dArray4[1], dArray3[n3][0]);
                    dArray4[2] = Math.min(dArray4[2], dArray3[n3][1]);
                    dArray4[3] = Math.max(dArray4[3], dArray3[n3][1]);
                }
                n3 = (this.m_linTreeParent[n7] + 1) % n11;
                n = (this.m_linTreeParent[n7] + 2) % n11;
                int n15 = pgElementSet.getNeighbour((int)n7).m_data[this.m_linTreeParent[n7]];
                int n16 = pgElementSet.getOppVertexLocInd(n7, this.m_linTreeParent[n7]);
                block13: for (n3 = 0; n3 < n9 && !bl2; ++n3) {
                    double d5;
                    double d6;
                    double d7;
                    double d8;
                    if (dArray[n3][0] > dArray4[1] || dArray[n3][1] < dArray4[0] || dArray[n3][2] > dArray4[3] || dArray[n3][3] < dArray4[2]) continue;
                    if (nArray[n3][0] == n15 && nArray[n3][1] == n16) {
                        n10 = n3;
                        continue;
                    }
                    if (blArray[n3]) {
                        d8 = dArray[n3][0];
                        d7 = dArray[n3][2];
                        d6 = dArray[n3][1] - d8;
                        d5 = dArray[n3][3] - d7;
                    } else {
                        d8 = dArray[n3][0];
                        d7 = dArray[n3][3];
                        d6 = dArray[n3][1] - d8;
                        d5 = dArray[n3][2] - d7;
                    }
                    n = (this.m_linTreeParent[n7] + 2) % n11;
                    while (n != (this.m_linTreeParent[n7] + 1) % n11) {
                        double d9 = dArray3[n][1];
                        double d10 = dArray3[(n + 1) % n11][1] - d9;
                        double d11 = dArray3[n][0];
                        double d12 = dArray3[(n + 1) % n11][0] - d11;
                        if (Math.abs(d10 * d6 - d12 * d5) > d && (d2 = ((d11 - d8) * d5 - (d9 - d7) * d6) / (d10 * d6 - d12 * d5)) > -d && d2 < 1.0 + d && (d3 = ((d9 - d7) * d12 - (d11 - d8) * d10) / (d12 * d5 - d10 * d6)) > -d && d3 < 1.0 + d) {
                            if (d2 > d && d2 < 1.0 - d && d3 > d && d3 < 1.0 - d) {
                                bl2 = true;
                                if (!this.noOverlaps) continue block13;
                                bl2 = false;
                                continue block13;
                            }
                            if (!(d2 < d) && !(d2 > 1.0 - d) || !(d3 < d) && !(d3 > 1.0 - d)) {
                                if (d2 < d) {
                                    if (d6 * (d9 + d10 - d7) - d5 * (d11 + d12 - d8) > 0.0) {
                                        bl2 = true;
                                        if (!this.noOverlaps) continue block13;
                                        bl2 = false;
                                        continue block13;
                                    }
                                } else if (d2 > 1.0 - d) {
                                    if (d6 * (d9 - d7) - d5 * (d11 - d8) > 0.0) {
                                        bl2 = true;
                                        if (!this.noOverlaps) continue block13;
                                        bl2 = false;
                                        continue block13;
                                    }
                                } else if (d3 < d) {
                                    if (d12 * (d7 + d5 - d9) - d10 * (d8 + d6 - d11) > 0.0) {
                                        bl2 = true;
                                        if (!this.noOverlaps) continue block13;
                                        bl2 = false;
                                        continue block13;
                                    }
                                } else if (d3 > 1.0 - d && d12 * (d7 - d9) - d10 * (d8 - d11) > 0.0) {
                                    bl2 = true;
                                    if (!this.noOverlaps) continue block13;
                                    bl2 = false;
                                    continue block13;
                                }
                            }
                        }
                        n = (n + 1) % n11;
                    }
                }
                if (bl2) {
                    puPriorityQueue.enqueue(n7, Double.POSITIVE_INFINITY);
                    this.m_linTreeParent[n7] = -1;
                    bl2 = false;
                    continue;
                }
                if (this.m_weight == 2 && this.m_linTreeParent[n7] != -1 && dArrayArray[n7][this.m_linTreeParent[n7]] == Double.POSITIVE_INFINITY) {
                    puPriorityQueue.enqueue(n7, Double.POSITIVE_INFINITY);
                    this.m_linTreeParent[n7] = -1;
                    continue;
                }
                if (bl) {
                    piVectorArray2[n7].m_data[(this.m_linTreeParent[n7] + 1) % n11] = piVectorArray2[n12].m_data[(n14 + 2) % n13];
                    piVectorArray2[n7].m_data[(this.m_linTreeParent[n7] + 2) % n11] = piVectorArray2[n12].m_data[(n14 + 1) % n13];
                } else {
                    piVectorArray2[n7].m_data[(this.m_linTreeParent[n7] + 1) % n11] = piVectorArray2[n12].m_data[(n14 + 1) % n13];
                    piVectorArray2[n7].m_data[(this.m_linTreeParent[n7] + 2) % n11] = piVectorArray2[n12].m_data[(n14 + 2) % n13];
                }
                for (n3 = 0; n3 < n11; ++n3) {
                    pdVectorArray[piVectorArray2[n7].m_data[n3]].m_data[0] = dArray3[n3][0];
                    pdVectorArray[piVectorArray2[n7].m_data[n3]].m_data[1] = dArray3[n3][1];
                    pdVectorArray[piVectorArray2[n7].m_data[n3]].m_data[2] = 0.0;
                }
                this.m_linTree[n6] = n7;
                ++n6;
                for (n3 = 0; n3 < n11 - 1; ++n3) {
                    nArray[n9][0] = n7;
                    nArray[n9][1] = (n3 - 1 + n11) % n11;
                    if (dArray3[n3][0] < dArray3[n3 + 1][0]) {
                        dArray[n9][0] = dArray3[n3][0];
                        dArray[n9][1] = dArray3[n3 + 1][0];
                        if (dArray3[n3][1] < dArray3[n3 + 1][1]) {
                            dArray[n9][2] = dArray3[n3][1];
                            dArray[n9][3] = dArray3[n3 + 1][1];
                            blArray[n9] = true;
                        } else {
                            dArray[n9][2] = dArray3[n3 + 1][1];
                            dArray[n9][3] = dArray3[n3][1];
                            blArray[n9] = false;
                        }
                    } else {
                        dArray[n9][0] = dArray3[n3 + 1][0];
                        dArray[n9][1] = dArray3[n3][0];
                        if (dArray3[n3][1] < dArray3[n3 + 1][1]) {
                            dArray[n9][2] = dArray3[n3][1];
                            dArray[n9][3] = dArray3[n3 + 1][1];
                            blArray[n9] = false;
                        } else {
                            dArray[n9][2] = dArray3[n3 + 1][1];
                            dArray[n9][3] = dArray3[n3][1];
                            blArray[n9] = true;
                        }
                    }
                    ++n9;
                }
                if (n10 >= 0) {
                    nArray[n10][0] = n7;
                    nArray[n10][1] = n11 - 2;
                    if (dArray3[n11 - 1][0] < dArray3[0][0]) {
                        dArray[n10][0] = dArray3[n11 - 1][0];
                        dArray[n10][1] = dArray3[0][0];
                        if (dArray3[n11 - 1][1] < dArray3[0][1]) {
                            dArray[n10][2] = dArray3[n11 - 1][1];
                            dArray[n10][3] = dArray3[0][1];
                            blArray[n10] = true;
                        } else {
                            dArray[n10][2] = dArray3[0][1];
                            dArray[n10][3] = dArray3[n11 - 1][1];
                            blArray[n10] = false;
                        }
                    } else {
                        dArray[n10][0] = dArray3[0][0];
                        dArray[n10][1] = dArray3[n11 - 1][0];
                        if (dArray3[n3][1] < dArray3[0][1]) {
                            dArray[n10][2] = dArray3[n11 - 1][1];
                            dArray[n10][3] = dArray3[0][1];
                            blArray[n10] = false;
                        } else {
                            dArray[n10][2] = dArray3[0][1];
                            dArray[n10][3] = dArray3[n11 - 1][1];
                            blArray[n10] = true;
                        }
                    }
                    n10 = -1;
                } else {
                    nArray[n9][0] = n7;
                    nArray[n9][1] = n11 - 2;
                    if (dArray3[n11 - 1][0] < dArray3[0][0]) {
                        dArray[n9][0] = dArray3[n11 - 1][0];
                        dArray[n9][1] = dArray3[0][0];
                        if (dArray3[n11 - 1][1] < dArray3[0][1]) {
                            dArray[n9][2] = dArray3[n11 - 1][1];
                            dArray[n9][3] = dArray3[0][1];
                            blArray[n9] = true;
                        } else {
                            dArray[n9][2] = dArray3[0][1];
                            dArray[n9][3] = dArray3[n11 - 1][1];
                            blArray[n9] = false;
                        }
                    } else {
                        dArray[n9][0] = dArray3[0][0];
                        dArray[n9][1] = dArray3[n11 - 1][0];
                        if (dArray3[n3][1] < dArray3[0][1]) {
                            dArray[n9][2] = dArray3[n11 - 1][1];
                            dArray[n9][3] = dArray3[0][1];
                            blArray[n9] = false;
                        } else {
                            dArray[n9][2] = dArray3[0][1];
                            dArray[n9][3] = dArray3[n11 - 1][1];
                            blArray[n9] = true;
                        }
                    }
                    ++n9;
                }
            }
            for (n3 = 0; n3 < n11; ++n3) {
                n8 = piVectorArray[n7].m_data[n3];
                if (n8 == -1 || !puPriorityQueue.isElement(n8) || !(dArrayArray[n7][n3] < puPriorityQueue.getKey(n8))) continue;
                for (n = 0; n < piVectorArray[n8].getSize(); ++n) {
                    if (piVectorArray[n8].m_data[n] != n7) continue;
                    this.m_linTreeParent[n8] = n;
                    break;
                }
                puPriorityQueue.decreaseKey(n8, dArrayArray[n7][n3]);
            }
        }
        this.m_geom.removeUnusedVertices();
        pdVectorArray = this.m_geom.getVertices();
        this.arrangeParts();
        this.m_isUnfold = true;
        this.m_geom.makeNeighbour();
        this.m_geom.makeElementNormals();
        this.m_geom.makeVertexNormals();
        PdVector[] pdVectorArray3 = this.m_geom.getBounds();
        this.m_diamBB[1] = PdVector.dist((PdVector)pdVectorArray3[0], (PdVector)pdVectorArray3[1]);
    }

    private void arrangeParts() {
        double d;
        double d2;
        int n;
        int n2;
        int n3 = this.m_geom.getNumElements();
        PiVector[] piVectorArray = this.m_geom.getElements();
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        PgElementSet pgElementSet = this.m_geomSave;
        double d3 = 0.0;
        double d4 = 0.0;
        this.m_numOfParts = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.m_linTreeParent[n2] != -1) continue;
            ++this.m_numOfParts;
        }
        this.m_vertOfPolygons = new int[this.m_numOfParts][];
        int n4 = 0;
        int n5 = 0;
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            if (this.m_linTreeParent[this.m_linTree[n2]] == -1) {
                this.m_vertOfPolygons[n5] = new int[n4 += piVectorArray[this.m_linTree[n2]].getSize()];
                ++n5;
                n4 = 0;
                continue;
            }
            n4 += piVectorArray[this.m_linTree[n2]].getSize() - 2;
        }
        n5 = 0;
        n4 = 0;
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            if (this.m_linTreeParent[this.m_linTree[n2]] == -1) {
                for (n = 0; n < piVectorArray[this.m_linTree[n2]].getSize(); ++n) {
                    this.m_vertOfPolygons[n5][n4] = piVectorArray[this.m_linTree[n2]].getEntry(n);
                    ++n4;
                }
                ++n5;
                n4 = 0;
                continue;
            }
            int n6 = piVectorArray[this.m_linTree[n2]].getSize();
            for (n = 0; n < n6 - 2; ++n) {
                this.m_vertOfPolygons[n5][n4] = piVectorArray[this.m_linTree[n2]].getEntry((this.m_linTreeParent[this.m_linTree[n2]] - n + n6) % n6);
                ++n4;
            }
        }
        double[][] dArray = new double[this.m_numOfParts][2];
        this.m_BBoxdata = new double[this.m_numOfParts][4];
        for (n2 = 0; n2 < this.m_numOfParts; ++n2) {
            double d5;
            double d6;
            d2 = d6 = pdVectorArray[this.m_vertOfPolygons[n2][0]].m_data[0];
            d = d5 = pdVectorArray[this.m_vertOfPolygons[n2][0]].m_data[1];
            this.m_BBoxdata[n2][0] = d6;
            this.m_BBoxdata[n2][3] = d;
            this.m_BBoxdata[n2][1] = d5;
            for (n4 = 1; n4 < this.m_vertOfPolygons[n2].length; ++n4) {
                if (pdVectorArray[this.m_vertOfPolygons[n2][n4]].m_data[0] > d2) {
                    d2 = pdVectorArray[this.m_vertOfPolygons[n2][n4]].m_data[0];
                } else if (pdVectorArray[this.m_vertOfPolygons[n2][n4]].m_data[0] < d6) {
                    this.m_BBoxdata[n2][0] = d6 = pdVectorArray[this.m_vertOfPolygons[n2][n4]].m_data[0];
                }
                if (pdVectorArray[this.m_vertOfPolygons[n2][n4]].m_data[1] > d) {
                    this.m_BBoxdata[n2][3] = d = pdVectorArray[this.m_vertOfPolygons[n2][n4]].m_data[1];
                    continue;
                }
                if (!(pdVectorArray[this.m_vertOfPolygons[n2][n4]].m_data[1] < d5)) continue;
                this.m_BBoxdata[n2][1] = d5 = pdVectorArray[this.m_vertOfPolygons[n2][n4]].m_data[1];
            }
            dArray[n2][0] = d2 - d6;
            dArray[n2][1] = d - d5;
            if (dArray[n2][0] > d3) {
                d3 = dArray[n2][0];
            }
            if (!(dArray[n2][1] > d4)) continue;
            d4 = dArray[n2][1];
        }
        double d7 = Math.log(2.0);
        if (d3 > d4) {
            if (d3 > 2.0 * d4) {
                d4 = Math.pow(2.0, Math.floor(Math.log(d3 / d4) / d7)) * d4;
            }
        } else if (d4 > 2.0 * d3) {
            d3 = Math.pow(2.0, Math.floor(Math.log(d4 / d3) / d7)) * d3;
        }
        int[] nArray = new int[this.m_numOfParts];
        int n7 = 0;
        for (n2 = 0; n2 < this.m_numOfParts; ++n2) {
            d2 = Math.log(d3 / dArray[n2][0]) / d7;
            n4 = (int)Math.floor(Math.min(d2, d = Math.log(d4 / dArray[n2][1]) / d7));
            n4 = dArray[n2][0] * Math.pow(2.0, n4 + 1) < d3 ? 2 * n4 + 1 : (n4 *= 2);
            nArray[n2] = n4;
            if (n4 <= n7) continue;
            n7 = n4;
        }
        PiVector[] piVectorArray2 = new PiVector[n7 + 1];
        for (n2 = 0; n2 < n7 + 1; ++n2) {
            piVectorArray2[n2] = new PiVector(0);
        }
        for (n2 = 0; n2 < this.m_numOfParts; ++n2) {
            piVectorArray2[nArray[n2]].addEntry(n2);
        }
        int n8 = 0;
        double d8 = 0.0;
        for (n2 = 0; n2 < n7 + 1; ++n2) {
            d8 += (double)piVectorArray2[n2].getSize() / Math.pow(2.0, n2);
        }
        n8 = (int)Math.ceil(d8);
        int n9 = (int)Math.ceil(Math.sqrt(n8));
        this.m_translatePolygons = new double[this.m_numOfParts][2];
        int n10 = 0;
        int n11 = 0;
        n2 = (int)((double)n9 * Math.pow(2.0, Math.ceil((double)n7 / 2.0)));
        int[] nArray2 = new int[n2];
        PdVector pdVector = pgElementSet.getCenterOfGravity();
        double d9 = d3 / Math.pow(2.0, Math.ceil((double)n7 / 2.0));
        double d10 = d4 / Math.pow(2.0, Math.floor((double)n7 / 2.0));
        d9 *= 1.05;
        d10 *= 1.05;
        for (n2 = 0; n2 < n7 + 1; ++n2) {
            for (n4 = 0; n4 < piVectorArray2[n2].getSize(); ++n4) {
                this.m_translatePolygons[piVectorArray2[n2].m_data[n4]][0] = (double)n11 * d9;
                this.m_translatePolygons[piVectorArray2[n2].m_data[n4]][1] = (double)n10 * d10;
                n11 += (int)Math.pow(2.0, Math.ceil((double)n7 / 2.0) - Math.ceil((double)n2 / 2.0));
                n = n10 + (int)Math.pow(2.0, Math.floor((double)n7 / 2.0) - Math.floor((double)n2 / 2.0));
                for (n5 = n10; n5 < n; ++n5) {
                    nArray2[n5] = n11;
                }
                while (n11 >= nArray2.length && n10 < nArray2.length - 1) {
                    n11 = nArray2[++n10];
                }
            }
        }
        for (n2 = 0; n2 < this.m_vertOfPolygons.length; ++n2) {
            for (n4 = 0; n4 < this.m_vertOfPolygons[n2].length; ++n4) {
                if (this.m_BBoxdata[n2][2] == 0.0) {
                    pdVectorArray[this.m_vertOfPolygons[n2][n4]].m_data[0] = pdVectorArray[this.m_vertOfPolygons[n2][n4]].m_data[0] + (this.m_translatePolygons[n2][0] - this.m_BBoxdata[n2][0]);
                    pdVectorArray[this.m_vertOfPolygons[n2][n4]].m_data[1] = pdVectorArray[this.m_vertOfPolygons[n2][n4]].m_data[1] + (this.m_translatePolygons[n2][1] - this.m_BBoxdata[n2][1]);
                    continue;
                }
                d8 = pdVectorArray[this.m_vertOfPolygons[n2][n4]].m_data[0];
                pdVectorArray[this.m_vertOfPolygons[n2][n4]].m_data[0] = pdVectorArray[this.m_vertOfPolygons[n2][n4]].m_data[0] + (-pdVectorArray[this.m_vertOfPolygons[n2][n4]].m_data[1] - pdVectorArray[this.m_vertOfPolygons[n2][n4]].m_data[0] + (this.m_translatePolygons[n2][0] + this.m_BBoxdata[n2][3]));
                pdVectorArray[this.m_vertOfPolygons[n2][n4]].m_data[1] = pdVectorArray[this.m_vertOfPolygons[n2][n4]].m_data[1] + (d8 - pdVectorArray[this.m_vertOfPolygons[n2][n4]].m_data[1] + (this.m_translatePolygons[n2][1] - this.m_BBoxdata[n2][0]));
            }
        }
        PdVector pdVector2 = this.m_geom.getCenterOfGravity();
        double d11 = pdVector.m_data[0] - pdVector2.m_data[0];
        double d12 = pdVector.m_data[1] - pdVector2.m_data[1];
        for (n2 = 0; n2 < n7 + 1; ++n2) {
            for (n4 = 0; n4 < piVectorArray2[n2].getSize(); ++n4) {
                double[] dArray2 = this.m_translatePolygons[piVectorArray2[n2].m_data[n4]];
                dArray2[0] = dArray2[0] + d11;
                double[] dArray3 = this.m_translatePolygons[piVectorArray2[n2].m_data[n4]];
                dArray3[1] = dArray3[1] + d12;
            }
        }
        for (n2 = 0; n2 < this.m_vertOfPolygons.length; ++n2) {
            for (n4 = 0; n4 < this.m_vertOfPolygons[n2].length; ++n4) {
                pdVectorArray[this.m_vertOfPolygons[n2][n4]].m_data[0] = pdVectorArray[this.m_vertOfPolygons[n2][n4]].m_data[0] + d11;
                pdVectorArray[this.m_vertOfPolygons[n2][n4]].m_data[1] = pdVectorArray[this.m_vertOfPolygons[n2][n4]].m_data[1] + d12;
            }
        }
        int n12 = this.m_geom.getNumVertices();
        for (n2 = 0; n2 < n12; ++n2) {
            pdVectorArray[n2].m_data[2] = pdVectorArray[n2].m_data[2] + pdVector.m_data[2];
        }
    }

    protected void removeSplice() {
        if (this.m_splice == null) {
            return;
        }
        Enumeration enumeration = this.m_splice.getDisplayList().elements();
        while (enumeration.hasMoreElements()) {
            PvDisplayIf pvDisplayIf = (PvDisplayIf)enumeration.nextElement();
            pvDisplayIf.removeGeometry((PgGeometryIf)this.m_splice);
            pvDisplayIf.update((Object)pvDisplayIf);
        }
        if (this.m_splice.hasUpdateListener((PsUpdateIf)this)) {
            this.m_splice.removeUpdateListener((PsUpdateIf)this);
        }
        this.m_splice = null;
    }

    protected void stopAnimation() {
        if (this.m_anim != null && this.m_anim.isRunning()) {
            int n;
            this.m_anim.stop();
            for (n = -10000; this.m_bAnimIsRunning && n < 0; n += 100) {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (n == 0) {
                PsDebug.warning((String)"animation has not been stopped properly.");
            }
        }
    }

    public PsAnimation getAnimation() {
        return this.m_anim;
    }

    public boolean hasAnimation() {
        return this.m_anim == null;
    }

    public void setAnimation(PsAnimation psAnimation) {
        this.m_anim = psAnimation;
    }

    public boolean setTime(PsTimeEvent psTimeEvent) {
        if (this.m_isImproving) {
            return true;
        }
        this.m_bAnimIsRunning = true;
        double d = psTimeEvent.getTime();
        this.timestep(d);
        this.m_bAnimIsRunning = false;
        return true;
    }

    protected void timestep(double d) {
        this.flatten((d - this.m_anim.getMinTime()) / (this.m_anim.getMaxTime() - this.m_anim.getMinTime()));
        this.showSplices();
        if (this.m_bAutoFit && this.m_display != null) {
            PvCameraIf pvCameraIf = this.m_display.getCamera();
            if (pvCameraIf instanceof PvCamera) {
                PvCamera pvCamera = (PvCamera)pvCameraIf;
                double d2 = (d - this.m_anim.getMinTime()) / (this.m_anim.getMaxTime() - this.m_anim.getMinTime());
                pvCamera.fit((1.0 - d2) * this.m_diamBB[0] + d2 * this.m_diamBB[1]);
            } else {
                this.m_display.fit();
            }
        }
        this.update(this);
    }

    public boolean improveUnfolding() {
        int n;
        int n2;
        if (this.m_anim.isRunning() && this.m_bUpdateWhileImprove) {
            this.stopAnimation();
        }
        if (this.m_bUpdateWhileImprove) {
            n2 = this.m_fixedElement;
            this.m_fixedElement = -1;
            this.flatten(1.0);
            this.m_fixedElement = n2;
        }
        this.m_isImproving = true;
        int n3 = n2 = this.assureElemTreeTable();
        int n4 = n2 + 1;
        if (n2 <= 1) {
            this.m_isImproving = false;
            return false;
        }
        boolean bl = true;
        int n5 = 0;
        int n6 = 0;
        bl = false;
        for (n5 = 0; !bl && n5 < 10; ++n5) {
            bl = this.resort(false);
            n3 = this.assureElemTreeTable();
            if (this.m_bStopImproving) break;
        }
        if (!this.m_bquickImprove) {
            block3: while (n6 < 10 && n3 > 1) {
                n4 = n3;
                bl = false;
                for (n5 = 0; !bl && n5 < 10; ++n5) {
                    bl = this.resort(true);
                    n3 = this.assureElemTreeTable();
                    if (this.m_bStopImproving) break block3;
                }
                bl = false;
                for (n5 = 0; !bl && n5 < 10; ++n5) {
                    bl = this.resort(false);
                    n3 = this.assureElemTreeTable();
                    if (this.m_bStopImproving) break block3;
                }
                if (n4 <= n3) {
                    ++n6;
                    continue;
                }
                if (this.m_numOfParts == n3 || !this.m_bUpdateWhileImprove) continue;
                this.m_numOfParts = n3;
                this.update(this);
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.setVertexPos();
        this.m_geom.removeUnusedVertices();
        int n7 = this.m_geom.getNumElements();
        for (n = 0; n < n7; ++n) {
            this.m_linTreeParent[n] = -1;
        }
        this.m_isFlat = false;
        this.m_isUnfold = false;
        n = this.m_geom.getNumElements();
        PiVector[] piVectorArray = new PiVector[n];
        PiVector[] piVectorArray2 = this.m_geomSave.getNeighbours();
        PiVector[] piVectorArray3 = this.m_geom.getNeighbours();
        for (int i = 0; i < n; ++i) {
            int n8 = piVectorArray2[i].getSize();
            piVectorArray[i] = new PiVector(n8);
            for (int j = 0; j < n8; ++j) {
                piVectorArray[i].m_data[j] = piVectorArray2[i].m_data[j];
            }
        }
        PiVector.copy((PiVector[])piVectorArray2, (int)0, (PiVector[])piVectorArray3, (int)0, (int)n);
        this.noOverlaps = true;
        this.m_bNoImprove = true;
        this.flatten(1.0);
        this.m_bNoImprove = false;
        this.noOverlaps = false;
        this.m_fixedElement = this.computeCenterElement();
        PiVector.copy((PiVector[])piVectorArray2, (int)0, (PiVector[])piVectorArray, (int)0, (int)n);
        this.m_isImproving = false;
        this.rebuildLinTreeBreadthFirst();
        return n2 != n3;
    }

    protected void rebuildLinTreeDepthFirst() {
        PiVector[] piVectorArray = this.m_geom.getNeighbours();
        int n = this.m_geom.getNumElements();
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            int n4;
            if (this.m_linTreeParent[n2] != -1) {
                ++n2;
                continue;
            }
            this.m_linTree[n3] = n2;
            ++n3;
            int n5 = piVectorArray[n2].getSize();
            for (n4 = 0; n4 < n5 && piVectorArray[n2].m_data[n4] == -1; ++n4) {
            }
            if (n4 == n5) {
                ++n2;
                continue;
            }
            int n6 = piVectorArray[n2].m_data[n4];
            n5 = piVectorArray[n6].getSize();
            int n7 = (this.m_geom.getOppVertexLocInd(n2, n4) + 1) % n5;
            this.m_linTree[n3] = n6;
            ++n3;
            while (n6 != n2 || n7 != n4) {
                int n8;
                if (n7 == this.m_linTreeParent[n6]) {
                    n8 = n6;
                    n6 = piVectorArray[n6].m_data[n7];
                    n5 = piVectorArray[n6].getSize();
                    n7 = (this.m_geom.getOppVertexLocInd(n8, n7) + 1) % n5;
                    continue;
                }
                if (piVectorArray[n6].m_data[n7] == -1) {
                    n7 = (n7 + 1) % n5;
                    continue;
                }
                n8 = n6;
                n6 = piVectorArray[n6].m_data[n7];
                n5 = piVectorArray[n6].getSize();
                n7 = (this.m_geom.getOppVertexLocInd(n8, n7) + 1) % n5;
                this.m_linTree[n3] = n6;
                ++n3;
            }
            ++n2;
        }
    }

    protected void rebuildLinTreeBreadthFirst() {
        int n = this.m_geom.getNumElements();
        boolean[] blArray = new boolean[n];
        int n2 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            blArray[n2] = false;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        PiVector[] piVectorArray = this.m_geom.getNeighbours();
        int n6 = 0;
        while (n3 < n) {
            n6 = n3;
            while (this.m_linTreeParent[n6] != -1) {
                n6 = piVectorArray[n6].m_data[this.m_linTreeParent[n6]];
            }
            this.m_linTree[n5] = n6;
            blArray[n6] = true;
            ++n5;
            while (n4 != n5) {
                int n7 = piVectorArray[this.m_linTree[n4]].m_data.length;
                for (n2 = 0; n2 < n7; ++n2) {
                    if (piVectorArray[this.m_linTree[n4]].m_data[n2] == -1 || n2 == this.m_linTreeParent[this.m_linTree[n4]]) continue;
                    this.m_linTree[n5] = piVectorArray[this.m_linTree[n4]].m_data[n2];
                    blArray[piVectorArray[this.m_linTree[n4]].m_data[n2]] = true;
                    ++n5;
                }
                ++n4;
            }
            while (n3 < n && blArray[n3]) {
                ++n3;
            }
        }
    }

    protected boolean resort(boolean bl) {
        int n;
        PiVector[] piVectorArray = this.m_geom.getNeighbours();
        PiVector[] piVectorArray2 = this.m_geomSave.getNeighbours();
        int n2 = 3;
        int n3 = this.m_geom.getNumElements();
        PdMatrix pdMatrix = new PdMatrix(2, 3);
        int n4 = this.assureElemTreeTable();
        int[] nArray = new int[n4];
        for (n4 = 0; n4 < n3; ++n4) {
            int n5 = this.m_elemTreeTable[n4];
            nArray[n5] = nArray[n5] + 1;
        }
        int n6 = 0;
        boolean bl2 = true;
        int n7 = nArray[0];
        for (n4 = 1; n4 < nArray.length; ++n4) {
            if (nArray[n4] <= n7) continue;
            n6 = n4;
            n7 = nArray[n4];
        }
        int[] nArray2 = new int[n3];
        for (n4 = 0; n4 < n3; ++n4) {
            nArray2[this.m_linTree[n4]] = n4;
        }
        int n8 = -1;
        boolean bl3 = false;
        boolean bl4 = true;
        boolean bl5 = true;
        int n9 = -1;
        int n10 = -1;
        int[] nArray3 = new int[]{-1, -1, -1, -1};
        int n11 = 1;
        int[] nArray4 = new int[6];
        int[] nArray5 = new int[n3];
        for (n4 = 0; n4 < n3; ++n4) {
            nArray5[n4] = n4;
        }
        int n12 = n3 / 2;
        Random random = new Random();
        for (n4 = 0; n4 < n12; ++n4) {
            n7 = Math.abs(random.nextInt()) % n3;
            n = Math.abs(random.nextInt()) % n3;
            int n13 = nArray5[n7];
            nArray5[n7] = nArray5[n];
            nArray5[n] = n13;
        }
        block5: for (n12 = 0; n12 < n3; ++n12) {
            if (this.m_bStopImproving) {
                return bl2;
            }
            n4 = nArray5[n12];
            if (!bl && this.m_elemTreeTable[n4] == n6) continue;
            n2 = piVectorArray[n4].getSize();
            for (n7 = 0; n7 < n2; ++n7) {
                if (piVectorArray[n4].m_data[n7] != -1 || piVectorArray2[n4].m_data[n7] == -1 || this.m_elemTreeTable[n4] == this.m_elemTreeTable[piVectorArray2[n4].m_data[n7]] || (!bl ? nArray[this.m_elemTreeTable[n4]] > nArray[this.m_elemTreeTable[piVectorArray2[n4].m_data[n7]]] : nArray[this.m_elemTreeTable[n4]] < nArray[this.m_elemTreeTable[piVectorArray2[n4].m_data[n7]]])) continue;
                pdMatrix = this.computeTrafo(n4, n7);
                n9 = nArray2[piVectorArray2[n4].m_data[n7]];
                while (this.m_linTreeParent[this.m_linTree[n9]] != -1) {
                    n9 = nArray2[piVectorArray[this.m_linTree[n9]].m_data[this.m_linTreeParent[this.m_linTree[n9]]]];
                }
                for (n10 = n9 + 1; n10 < n3 && this.m_linTreeParent[this.m_linTree[n10]] != -1; ++n10) {
                }
                --n10;
                if (nArray4.length < n2) {
                    nArray4 = new int[n2];
                }
                for (n = 0; n < n2; ++n) {
                    nArray4[n] = piVectorArray[n4].m_data[n];
                    piVectorArray[n4].m_data[n] = -1;
                }
                if (this.doIntersect(nArray2[n4], nArray2[n4], pdMatrix, n9, n10, null)) {
                    for (n = 0; n < n2; ++n) {
                        piVectorArray[n4].m_data[n] = nArray4[n];
                    }
                    continue;
                }
                for (n = 0; n < n2; ++n) {
                    piVectorArray[n4].m_data[n] = nArray4[n];
                }
                n11 = 1;
                for (n = 0; n < n2; ++n) {
                    if (piVectorArray[n4].m_data[n] == -1) continue;
                    this.getSubComponent(piVectorArray[n4].m_data[n], n4, nArray3);
                    bl4 = this.doIntersect(nArray2[nArray3[0]], nArray2[nArray3[1]], pdMatrix, n9, n10, null);
                    bl5 = nArray3[2] >= 0 && nArray3[3] >= 0 ? this.doIntersect(nArray2[nArray3[2]], nArray2[nArray3[3]], pdMatrix, n9, n10, null) : false;
                    if (bl4 || bl5) {
                        if (n8 == -1) {
                            n8 = n;
                            continue;
                        }
                        bl3 = true;
                        break;
                    }
                    if (!bl) continue;
                    n11 = nArray3[2] >= 0 && nArray3[3] >= 0 ? (n11 += nArray2[nArray3[1]] - nArray2[nArray3[0]] + nArray2[nArray3[3]] - nArray2[nArray3[2]]) : (n11 += nArray2[nArray3[1]] - nArray2[nArray3[0]]);
                    if (nArray[this.m_elemTreeTable[n4]] - 2 * n11 >= nArray[this.m_elemTreeTable[piVectorArray2[n4].m_data[n7]]]) continue;
                    if (n8 == -1) {
                        n8 = n;
                        continue;
                    }
                    bl3 = true;
                    break;
                }
                if (!bl3) {
                    int n14;
                    if (n8 != -1) {
                        int n15 = n4;
                        int n16 = piVectorArray[n4].m_data[n8];
                        int n17 = n8;
                        int n18 = -1;
                        int n19 = this.m_geom.getOppVertexLocInd(n4, n8);
                        boolean bl6 = false;
                        n2 = piVectorArray[n16].getSize();
                        while (!bl6) {
                            if (nArray4.length < n2) {
                                nArray4 = new int[n2];
                            }
                            for (n = 0; n < n2; ++n) {
                                nArray4[n] = piVectorArray[n16].m_data[n];
                                piVectorArray[n16].m_data[n] = -1;
                            }
                            if (this.doIntersect(nArray2[n16], nArray2[n16], pdMatrix, n9, n10, null)) {
                                for (n = 0; n < n2; ++n) {
                                    piVectorArray[n16].m_data[n] = nArray4[n];
                                }
                                bl6 = true;
                                continue;
                            }
                            for (n = 0; n < n2; ++n) {
                                piVectorArray[n16].m_data[n] = nArray4[n];
                            }
                            for (n = 0; n < n2; ++n) {
                                if (n == n19 || piVectorArray[n16].m_data[n] == -1) continue;
                                this.getSubComponent(piVectorArray[n16].m_data[n], n16, nArray3);
                                bl4 = this.doIntersect(nArray2[nArray3[0]], nArray2[nArray3[1]], pdMatrix, n9, n10, null);
                                bl5 = nArray3[2] >= 0 && nArray3[3] >= 0 ? this.doIntersect(nArray2[nArray3[2]], nArray2[nArray3[3]], pdMatrix, n9, n10, null) : false;
                                if (bl4 || bl5) {
                                    if (n18 == -1) {
                                        n18 = n;
                                        continue;
                                    }
                                    bl6 = true;
                                    break;
                                }
                                if (!bl) continue;
                                n11 = nArray3[2] >= 0 && nArray3[3] >= 0 ? (n11 += nArray2[nArray3[1]] - nArray2[nArray3[0]] + nArray2[nArray3[3]] - nArray2[nArray3[2]]) : (n11 += nArray2[nArray3[1]] - nArray2[nArray3[0]]);
                                if (nArray[this.m_elemTreeTable[n4]] - 2 * n11 >= nArray[this.m_elemTreeTable[piVectorArray2[n4].m_data[n7]]]) continue;
                                if (n18 == -1) {
                                    n18 = n;
                                    continue;
                                }
                                bl6 = true;
                                break;
                            }
                            if (bl6) continue;
                            if (n18 != -1) {
                                n19 = this.m_geom.getOppVertexLocInd(n16, n18);
                                n15 = n16;
                                n17 = n18;
                                n16 = piVectorArray[n15].m_data[n17];
                                n18 = -1;
                                n2 = piVectorArray[n16].getSize();
                                continue;
                            }
                            bl6 = true;
                        }
                        if (!bl) {
                            this.moveComponent(n4, n7, n15, n17, pdMatrix, nArray2);
                            bl2 = false;
                            this.assureElemTreeTable();
                            for (n14 = 0; n14 < n3; ++n14) {
                                nArray2[this.m_linTree[n14]] = n14;
                            }
                            for (n14 = 0; n14 < nArray.length; ++n14) {
                                nArray[n14] = 0;
                            }
                            for (n14 = 0; n14 < n3; ++n14) {
                                int n20 = this.m_elemTreeTable[n14];
                                nArray[n20] = nArray[n20] + 1;
                            }
                        } else {
                            this.getSubComponent(n15, piVectorArray[n15].m_data[n17], nArray3);
                            int n21 = nArray3[2] >= 0 && nArray3[3] >= 0 ? nArray2[nArray3[1]] - nArray2[nArray3[0]] + nArray2[nArray3[3]] - nArray2[nArray3[2]] + 1 : nArray2[nArray3[1]] - nArray2[nArray3[0]] + 1;
                            if (nArray[this.m_elemTreeTable[n4]] - 2 * n21 > nArray[this.m_elemTreeTable[piVectorArray2[n4].m_data[n7]]]) {
                                this.moveComponent(n4, n7, n15, n17, pdMatrix, nArray2);
                                bl2 = false;
                                this.assureElemTreeTable();
                                for (n14 = 0; n14 < n3; ++n14) {
                                    nArray2[this.m_linTree[n14]] = n14;
                                }
                                for (n14 = 0; n14 < nArray.length; ++n14) {
                                    nArray[n14] = 0;
                                }
                                for (n14 = 0; n14 < n3; ++n14) {
                                    int n22 = this.m_elemTreeTable[n14];
                                    nArray[n22] = nArray[n22] + 1;
                                }
                            }
                        }
                    } else {
                        this.moveTree(n4, n7, pdMatrix);
                        bl2 = false;
                        this.assureElemTreeTable();
                        for (n14 = 0; n14 < n3; ++n14) {
                            nArray2[this.m_linTree[n14]] = n14;
                        }
                        for (n14 = 0; n14 < nArray.length; ++n14) {
                            nArray[n14] = 0;
                        }
                        for (n14 = 0; n14 < n3; ++n14) {
                            int n23 = this.m_elemTreeTable[n14];
                            nArray[n23] = nArray[n23] + 1;
                        }
                    }
                }
                n8 = -1;
                bl3 = false;
                continue block5;
            }
        }
        return bl2;
    }

    protected int assureElemTreeTable() {
        this.rebuildLinTreeDepthFirst();
        if (this.m_elemTreeTable == null || this.m_elemTreeTable.length != this.m_linTree.length) {
            this.m_elemTreeTable = new int[this.m_linTree.length];
        }
        int n = -1;
        for (int i = 0; i < this.m_linTree.length; ++i) {
            if (this.m_linTreeParent[this.m_linTree[i]] == -1) {
                // empty if block
            }
            this.m_elemTreeTable[this.m_linTree[i]] = ++n;
        }
        return n + 1;
    }

    protected void colorPieces() {
        int n = this.assureElemTreeTable();
        int n2 = (int)Math.ceil((float)n / 8.0f);
        int[][] nArrayArray = new int[][]{{255, 255, 0}, {255, 0, 0}, {255, 175, 175}, {0, 255, 0}, {255, 0, 255}, {0, 255, 255}, {0, 0, 255}, {255, 200, 0}, {255, 0, 0}};
        for (int i = 0; i < this.m_elemTreeTable.length; ++i) {
            int n3 = this.m_elemTreeTable[i] / n2;
            double d = (double)(this.m_elemTreeTable[i] % n2) / (double)n2;
            int n4 = (int)((double)nArrayArray[n3][0] * d + (1.0 - d) * (double)nArrayArray[n3 + 1][0]);
            int n5 = (int)((double)nArrayArray[n3][1] * d + (1.0 - d) * (double)nArrayArray[n3 + 1][1]);
            int n6 = (int)((double)nArrayArray[n3][2] * d + (1.0 - d) * (double)nArrayArray[n3 + 1][2]);
            this.m_geom.setElementColor(i, new Color(n4, n5, n6));
        }
    }

    protected boolean doIntersect(int n, int n2, PdMatrix pdMatrix, int n3, int n4, PdMatrix pdMatrix2) {
        int n5;
        int n6;
        int n7;
        double d;
        double d2;
        double d3;
        double d4;
        double d5 = 1.0E-12;
        PiVector[] piVectorArray = this.m_geom.getNeighbours();
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        PiVector[] piVectorArray2 = this.m_geom.getElements();
        if (pdMatrix == null) {
            pdMatrix = new PdMatrix(2, 3);
            pdMatrix.m_data[0][0] = 1.0;
            pdMatrix.m_data[1][1] = 1.0;
            pdMatrix.m_data[1][0] = 0.0;
            pdMatrix.m_data[0][1] = 0.0;
            pdMatrix.m_data[1][2] = 0.0;
            pdMatrix.m_data[0][2] = 0.0;
        }
        if (pdMatrix2 == null) {
            d4 = pdVectorArray[piVectorArray2[this.m_linTree[n3]].m_data[0]].m_data[0];
            d3 = pdVectorArray[piVectorArray2[this.m_linTree[n3]].m_data[0]].m_data[1];
            d2 = d4;
            d = d3;
            for (n7 = n3; n7 < n4 + 1; ++n7) {
                n6 = piVectorArray2[this.m_linTree[n7]].getSize();
                for (n5 = 0; n5 < n6; ++n5) {
                    if (pdVectorArray[piVectorArray2[this.m_linTree[n7]].m_data[n5]].m_data[0] < d4) {
                        d4 = pdVectorArray[piVectorArray2[this.m_linTree[n7]].m_data[n5]].m_data[0];
                    } else if (pdVectorArray[piVectorArray2[this.m_linTree[n7]].m_data[n5]].m_data[0] > d2) {
                        d2 = pdVectorArray[piVectorArray2[this.m_linTree[n7]].m_data[n5]].m_data[0];
                    }
                    if (pdVectorArray[piVectorArray2[this.m_linTree[n7]].m_data[n5]].m_data[1] < d3) {
                        d3 = pdVectorArray[piVectorArray2[this.m_linTree[n7]].m_data[n5]].m_data[1];
                        continue;
                    }
                    if (!(pdVectorArray[piVectorArray2[this.m_linTree[n7]].m_data[n5]].m_data[1] > d)) continue;
                    d = pdVectorArray[piVectorArray2[this.m_linTree[n7]].m_data[n5]].m_data[1];
                }
            }
        } else {
            PdVector pdVector = new PdVector(this.m_geom.getDimOfVertices());
            d4 = this.transform((PdMatrix)pdMatrix2, (PdVector)pdVectorArray[piVectorArray2[this.m_linTree[n3]].m_data[0]], (PdVector)pdVector).m_data[0];
            d3 = this.transform((PdMatrix)pdMatrix2, (PdVector)pdVectorArray[piVectorArray2[this.m_linTree[n3]].m_data[0]], (PdVector)pdVector).m_data[1];
            d2 = d4;
            d = d3;
            for (n7 = n3; n7 < n4 + 1; ++n7) {
                n6 = piVectorArray2[this.m_linTree[n7]].getSize();
                for (n5 = 0; n5 < n6; ++n5) {
                    if (this.transform((PdMatrix)pdMatrix2, (PdVector)pdVectorArray[piVectorArray2[this.m_linTree[n7]].m_data[n5]], (PdVector)pdVector).m_data[0] < d4) {
                        d4 = this.transform((PdMatrix)pdMatrix2, (PdVector)pdVectorArray[piVectorArray2[this.m_linTree[n7]].m_data[n5]], (PdVector)pdVector).m_data[0];
                    } else if (this.transform((PdMatrix)pdMatrix2, (PdVector)pdVectorArray[piVectorArray2[this.m_linTree[n7]].m_data[n5]], (PdVector)pdVector).m_data[0] > d2) {
                        d2 = this.transform((PdMatrix)pdMatrix2, (PdVector)pdVectorArray[piVectorArray2[this.m_linTree[n7]].m_data[n5]], (PdVector)pdVector).m_data[0];
                    }
                    if (this.transform((PdMatrix)pdMatrix2, (PdVector)pdVectorArray[piVectorArray2[this.m_linTree[n7]].m_data[n5]], (PdVector)pdVector).m_data[1] < d3) {
                        d3 = this.transform((PdMatrix)pdMatrix2, (PdVector)pdVectorArray[piVectorArray2[this.m_linTree[n7]].m_data[n5]], (PdVector)pdVector).m_data[1];
                        continue;
                    }
                    if (!(this.transform((PdMatrix)pdMatrix2, (PdVector)pdVectorArray[piVectorArray2[this.m_linTree[n7]].m_data[n5]], (PdVector)pdVector).m_data[1] > d)) continue;
                    d = this.transform((PdMatrix)pdMatrix2, (PdVector)pdVectorArray[piVectorArray2[this.m_linTree[n7]].m_data[n5]], (PdVector)pdVector).m_data[1];
                }
            }
        }
        PdVector pdVector = new PdVector(3);
        for (n7 = n; n7 < n2 + 1; ++n7) {
            n6 = piVectorArray2[this.m_linTree[n7]].getSize();
            for (n5 = 0; n5 < n6; ++n5) {
                if (piVectorArray[this.m_linTree[n7]].m_data[n5] != -1) continue;
                this.transform(pdMatrix, pdVectorArray[piVectorArray2[this.m_linTree[n7]].m_data[(n5 + 1) % n6]], pdVector);
                double d6 = pdVector.m_data[0];
                double d7 = pdVector.m_data[1];
                this.transform(pdMatrix, pdVectorArray[piVectorArray2[this.m_linTree[n7]].m_data[(n5 + 2) % n6]], pdVector);
                double d8 = pdVector.m_data[0];
                double d9 = pdVector.m_data[1];
                if (Math.min(d6, d8) > d2 || Math.max(d6, d8) < d4 || Math.min(d7, d9) > d || Math.max(d7, d9) < d3) continue;
                d8 -= d6;
                d9 -= d7;
                this.transform(pdMatrix, pdVectorArray[piVectorArray2[this.m_linTree[n7]].m_data[n5]], pdVector);
                if (d8 * (pdVector.m_data[1] - d7) - d9 * (pdVector.m_data[0] - d6) < 0.0) {
                    d6 += d8;
                    d7 += d9;
                    d8 = -d8;
                    d9 = -d9;
                }
                for (int i = n3; i < n4 + 1; ++i) {
                    int n8 = piVectorArray2[this.m_linTree[i]].getSize();
                    for (int j = 0; j < n8; ++j) {
                        double d10;
                        double d11;
                        double d12;
                        double d13;
                        double d14;
                        double d15;
                        if (piVectorArray[this.m_linTree[i]].m_data[j] != -1) continue;
                        if (pdMatrix2 != null) {
                            this.transform(pdMatrix2, pdVectorArray[piVectorArray2[this.m_linTree[i]].m_data[(j + 1) % n8]], pdVector);
                            d15 = pdVector.m_data[0];
                            d14 = pdVector.m_data[1];
                            this.transform(pdMatrix2, pdVectorArray[piVectorArray2[this.m_linTree[i]].m_data[(j + 2) % n8]], pdVector);
                            d13 = pdVector.m_data[0];
                            d12 = pdVector.m_data[1];
                            if (Math.min(d15, d13) >= Math.max(d6, d8 + d6) || Math.max(d15, d13) <= Math.min(d6, d8 + d6) || Math.min(d14, d12) >= Math.max(d7, d9 + d7) || Math.max(d14, d12) <= Math.min(d7, d9 + d7)) continue;
                            d13 -= d15;
                            d12 -= d14;
                            this.transform(pdMatrix2, pdVectorArray[piVectorArray2[this.m_linTree[i]].m_data[j]], pdVector);
                            if (d13 * (pdVector.m_data[1] - d14) - d12 * (pdVector.m_data[0] - d15) < 0.0) {
                                d15 += d13;
                                d14 += d12;
                                d13 = -d13;
                                d12 = -d12;
                            }
                        } else {
                            d15 = pdVectorArray[piVectorArray2[this.m_linTree[i]].m_data[(j + 1) % n8]].m_data[0];
                            d14 = pdVectorArray[piVectorArray2[this.m_linTree[i]].m_data[(j + 1) % n8]].m_data[1];
                            d13 = pdVectorArray[piVectorArray2[this.m_linTree[i]].m_data[(j + 2) % n8]].m_data[0];
                            d12 = pdVectorArray[piVectorArray2[this.m_linTree[i]].m_data[(j + 2) % n8]].m_data[1];
                            if (Math.min(d15, d13) >= Math.max(d6, d8 + d6) || Math.max(d15, d13) <= Math.min(d6, d8 + d6) || Math.min(d14, d12) >= Math.max(d7, d9 + d7) || Math.max(d14, d12) <= Math.min(d7, d9 + d7)) continue;
                            d13 -= d15;
                            d12 -= d14;
                            pdVector.copy(pdVectorArray[piVectorArray2[this.m_linTree[i]].m_data[j]]);
                            if (d13 * (pdVector.m_data[1] - d14) - d12 * (pdVector.m_data[0] - d15) < 0.0) {
                                d15 += d13;
                                d14 += d12;
                                d13 = -d13;
                                d12 = -d12;
                            }
                        }
                        if (!(d12 * d8 - d13 * d9 > d5) && !(-(d12 * d8 - d13 * d9) > d5) || !((d11 = ((d15 - d6) * d9 - (d14 - d7) * d8) / (d12 * d8 - d13 * d9)) > -d5) || !(d11 < 1.0 + d5) || !((d10 = ((d14 - d7) * d13 - (d15 - d6) * d12) / (d13 * d9 - d12 * d8)) > -d5) || !(d10 < 1.0 + d5)) continue;
                        if (d11 > d5 && d11 < 1.0 - d5 && d10 > d5 && d10 < 1.0 - d5) {
                            return true;
                        }
                        if ((d11 < d5 || d11 > 1.0 - d5) && (d10 < d5 || d10 > 1.0 - d5) || !(d11 < d5 ? d8 * (d14 + d12 - d7) - d9 * (d15 + d13 - d6) > 0.0 : (d11 > 1.0 - d5 ? d8 * (d14 - d7) - d9 * (d15 - d6) > 0.0 : (d10 < d5 ? d13 * (d7 + d9 - d14) - d12 * (d6 + d8 - d15) > 0.0 : d10 > 1.0 - d5 && d13 * (d7 - d14) - d12 * (d6 - d15) > 0.0)))) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    protected final PdVector transform(PdMatrix pdMatrix, PdVector pdVector, PdVector pdVector2) {
        pdVector2.m_data[0] = pdMatrix.m_data[0][0] * pdVector.m_data[0] + pdMatrix.m_data[0][1] * pdVector.m_data[1] + pdMatrix.m_data[0][2];
        pdVector2.m_data[1] = pdMatrix.m_data[1][0] * pdVector.m_data[0] + pdMatrix.m_data[1][1] * pdVector.m_data[1] + pdMatrix.m_data[1][2];
        return pdVector2;
    }

    protected void getSubComponent(int n, int n2, int[] nArray) {
        int n3;
        if (n < 0 || n >= this.m_geom.getNumElements()) {
            PsDebug.warning((String)("Cannot compute component " + n + " is not an index of an element."));
            return;
        }
        if (n2 < 0 || n2 >= this.m_geom.getNumElements()) {
            PsDebug.warning((String)("Cannot compute subcomponent. " + n + " is not an index of an element."));
            return;
        }
        PiVector[] piVectorArray = this.m_geom.getNeighbours();
        int n4 = piVectorArray[n].getSize();
        int n5 = -1;
        for (n3 = 0; n3 < n4; ++n3) {
            if (piVectorArray[n].m_data[n3] != n2) continue;
            n5 = n3;
            break;
        }
        if (n5 == -1) {
            PsDebug.warning((String)("Cannot compute subcomponent. Elements " + n + " and " + n2 + " are not neighbours."));
            return;
        }
        if (this.m_linTreeParent[n] != -1 && piVectorArray[n].m_data[this.m_linTreeParent[n]] == n2) {
            nArray[0] = n;
            nArray[1] = nArray[0];
            n5 = -1;
            n3 = (this.m_linTreeParent[nArray[1]] - 1 + n4) % n4;
            while (n3 != this.m_linTreeParent[nArray[1]]) {
                if (piVectorArray[nArray[1]].m_data[n3] > -1) {
                    n5 = n3;
                    break;
                }
                n3 = (n3 - 1 + n4) % n4;
            }
            block2: while (n5 != -1) {
                nArray[1] = piVectorArray[nArray[1]].m_data[n5];
                n4 = piVectorArray[nArray[1]].getSize();
                n5 = -1;
                n3 = (this.m_linTreeParent[nArray[1]] - 1 + n4) % n4;
                while (n3 != this.m_linTreeParent[nArray[1]]) {
                    if (piVectorArray[nArray[1]].m_data[n3] != -1) {
                        n5 = n3;
                        continue block2;
                    }
                    n3 = (n3 - 1 + n4) % n4;
                }
            }
            nArray[2] = -1;
            nArray[3] = -1;
        } else {
            nArray[0] = n;
            while (this.m_linTreeParent[nArray[0]] > -1) {
                nArray[0] = piVectorArray[nArray[0]].m_data[this.m_linTreeParent[nArray[0]]];
            }
            n5 = -1;
            n4 = piVectorArray[n].getSize();
            int n6 = this.m_geom.getOppVertexLocInd(n2, this.m_linTreeParent[n2]);
            int n7 = this.m_linTreeParent[n] != -1 ? this.m_linTreeParent[n] : n4 - 1;
            n3 = (n6 - 1 + n4) % n4;
            while (n3 != n7) {
                if (piVectorArray[n].m_data[n3] != -1) {
                    n5 = n3;
                    break;
                }
                n3 = (n3 - 1 + n4) % n4;
            }
            nArray[1] = n;
            block6: while (n5 != -1) {
                nArray[1] = piVectorArray[nArray[1]].m_data[n5];
                n4 = piVectorArray[nArray[1]].getSize();
                n5 = -1;
                n3 = (this.m_linTreeParent[nArray[1]] - 1 + n4) % n4;
                while (n3 != this.m_linTreeParent[nArray[1]]) {
                    if (piVectorArray[nArray[1]].m_data[n3] != -1) {
                        n5 = n3;
                        continue block6;
                    }
                    n3 = (n3 - 1 + n4) % n4;
                }
            }
            n5 = -1;
            n6 = this.m_geom.getOppVertexLocInd(n2, this.m_linTreeParent[n2]);
            nArray[2] = n;
            while (true) {
                n4 = piVectorArray[nArray[2]].getSize();
                n7 = this.m_linTreeParent[nArray[2]] != -1 ? this.m_linTreeParent[nArray[2]] : 0;
                n3 = (n6 + 1) % n4;
                while (n3 != n7) {
                    if (piVectorArray[nArray[2]].m_data[n3] != -1) {
                        n5 = n3;
                        break;
                    }
                    n3 = (n3 + 1) % n4;
                }
                if (n5 != -1) {
                    nArray[2] = piVectorArray[nArray[2]].m_data[n5];
                    break;
                }
                if (this.m_linTreeParent[nArray[2]] == -1) {
                    nArray[2] = -1;
                    break;
                }
                n6 = this.m_geom.getOppVertexLocInd(nArray[2], this.m_linTreeParent[nArray[2]]);
                nArray[2] = piVectorArray[nArray[2]].m_data[this.m_linTreeParent[nArray[2]]];
            }
            if (nArray[2] != -1) {
                nArray[3] = nArray[0];
                n4 = piVectorArray[nArray[3]].getSize();
                n5 = -1;
                for (n3 = n4 - 1; n3 >= 0; --n3) {
                    if (piVectorArray[nArray[3]].m_data[n3] <= -1) continue;
                    n5 = n3;
                    break;
                }
                block11: while (n5 != -1) {
                    nArray[3] = piVectorArray[nArray[3]].m_data[n5];
                    n4 = piVectorArray[nArray[3]].getSize();
                    n5 = -1;
                    n3 = (this.m_linTreeParent[nArray[3]] - 1 + n4) % n4;
                    while (n3 != this.m_linTreeParent[nArray[3]]) {
                        if (piVectorArray[nArray[3]].m_data[n3] != -1) {
                            n5 = n3;
                            continue block11;
                        }
                        n3 = (n3 - 1 + n4) % n4;
                    }
                }
            } else {
                nArray[3] = -1;
            }
        }
    }

    protected void moveComponent(int n, int n2, int n3, int n4) {
        PdMatrix pdMatrix = this.computeTrafo(n, n2);
        int n5 = this.m_geom.getNumElements();
        int[] nArray = new int[n5];
        for (int i = 0; i < n5; ++i) {
            nArray[this.m_linTree[i]] = i;
        }
        this.moveComponent(n, n2, n3, n4, pdMatrix, nArray);
    }

    protected void moveComponent(int n, int n2, int n3, int n4, PdMatrix pdMatrix, int[] nArray) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        PiVector[] piVectorArray = this.m_geom.getElements();
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        PgElementSet pgElementSet = this.m_geomSave;
        PiVector[] piVectorArray2 = pgElementSet.getNeighbours();
        int[] nArray2 = new int[4];
        this.getSubComponent(n3, piVectorArray2[n3].m_data[n4], nArray2);
        int n10 = piVectorArray2[n].m_data[n2];
        int n11 = pgElementSet.getOppVertexLocInd(n, n2);
        int n12 = piVectorArray[n10].getSize();
        int n13 = piVectorArray[n].getSize();
        int n14 = piVectorArray[n].m_data[(n2 + 1) % n13];
        int n15 = piVectorArray[n].m_data[(n2 + 2) % n13];
        if (pgElementSet.getElement((int)n).m_data[(n2 + 1) % n13] == pgElementSet.getElement((int)n10).m_data[(n11 + 1) % n12]) {
            n9 = piVectorArray[n10].m_data[(n11 + 1) % n12];
            n8 = piVectorArray[n10].m_data[(n11 + 2) % n12];
        } else {
            n9 = piVectorArray[n10].m_data[(n11 + 2) % n12];
            n8 = piVectorArray[n10].m_data[(n11 + 1) % n12];
        }
        n13 = piVectorArray[n3].getSize();
        int n16 = piVectorArray[n3].m_data[(n4 + 1) % n13];
        int n17 = piVectorArray[n3].m_data[(n4 + 2) % n13];
        for (n7 = nArray[nArray2[0]]; n7 <= nArray[nArray2[1]]; ++n7) {
            n6 = this.m_linTree[n7];
            n13 = piVectorArray[n6].getSize();
            for (n5 = 0; n5 < n13; ++n5) {
                if (piVectorArray[n6].m_data[n5] == n14) {
                    piVectorArray[n6].m_data[n5] = n9;
                }
                if (piVectorArray[n6].m_data[n5] != n15) continue;
                piVectorArray[n6].m_data[n5] = n8;
            }
        }
        if (nArray2[2] != -1 && nArray2[3] != -1) {
            for (n7 = nArray[nArray2[2]]; n7 <= nArray[nArray2[3]]; ++n7) {
                n6 = this.m_linTree[n7];
                n13 = piVectorArray[n6].getSize();
                for (n5 = 0; n5 < n13; ++n5) {
                    if (piVectorArray[n6].m_data[n5] == n14) {
                        piVectorArray[n6].m_data[n5] = n9;
                    }
                    if (piVectorArray[n6].m_data[n5] != n15) continue;
                    piVectorArray[n6].m_data[n5] = n8;
                }
            }
        }
        if (n14 == n17 || n15 == n16) {
            n7 = n16;
            n16 = n17;
            n17 = n7;
        }
        for (n7 = 0; n7 < this.m_geom.getDimOfVertices(); ++n7) {
            pdVectorArray[n14].m_data[n7] = pdVectorArray[n16].m_data[n7];
            pdVectorArray[n15].m_data[n7] = pdVectorArray[n17].m_data[n7];
        }
        for (n7 = nArray[nArray2[0]]; n7 <= nArray[nArray2[1]]; ++n7) {
            n6 = this.m_linTree[n7];
            n13 = piVectorArray[n6].getSize();
            for (n5 = 0; n5 < n13; ++n5) {
                if (piVectorArray[n6].m_data[n5] == n16) {
                    piVectorArray[n6].m_data[n5] = n14;
                }
                if (piVectorArray[n6].m_data[n5] != n17) continue;
                piVectorArray[n6].m_data[n5] = n15;
            }
        }
        if (nArray2[2] != -1 && nArray2[3] != -1) {
            for (n7 = nArray[nArray2[2]]; n7 <= nArray[nArray2[3]]; ++n7) {
                n6 = this.m_linTree[n7];
                n13 = piVectorArray[n6].getSize();
                for (n5 = 0; n5 < n13; ++n5) {
                    if (piVectorArray[n6].m_data[n5] == n16) {
                        piVectorArray[n6].m_data[n5] = n14;
                    }
                    if (piVectorArray[n6].m_data[n5] != n17) continue;
                    piVectorArray[n6].m_data[n5] = n15;
                }
            }
        }
        PiVector[] piVectorArray3 = this.m_geom.getNeighbours();
        piVectorArray3[n].m_data[n2] = piVectorArray2[n].m_data[n2];
        n7 = piVectorArray2[n].m_data[n2];
        n5 = pgElementSet.getOppVertexLocInd(n, n2);
        piVectorArray3[n7].m_data[n5] = piVectorArray2[n7].m_data[n5];
        piVectorArray3[n3].m_data[n4] = -1;
        n7 = piVectorArray2[n3].m_data[n4];
        n5 = pgElementSet.getOppVertexLocInd(n3, n4);
        piVectorArray3[n7].m_data[n5] = -1;
        int n18 = n;
        int n19 = this.m_linTreeParent[n];
        int n20 = -1;
        if (n19 != -1) {
            n6 = piVectorArray3[n].m_data[n19];
            while (n6 != -1 && this.m_linTreeParent[n6] != -1) {
                n20 = this.m_linTreeParent[n6];
                this.m_linTreeParent[n6] = this.m_geom.getOppVertexLocInd(n18, n19);
                n18 = n6;
                n6 = piVectorArray3[n6].m_data[n20];
                n19 = n20;
            }
            if (n6 != -1) {
                this.m_linTreeParent[n6] = this.m_geom.getOppVertexLocInd(n18, n19);
            }
        }
        if (this.m_linTreeParent[n7 = piVectorArray2[n3].m_data[n4]] == (n5 = pgElementSet.getOppVertexLocInd(n3, n4))) {
            this.m_linTreeParent[n7] = -1;
        }
        this.m_linTreeParent[n] = n2;
        PdVector pdVector = new PdVector(this.m_geom.getDimOfVertices());
        for (n7 = nArray[nArray2[0]]; n7 <= nArray[nArray2[1]]; ++n7) {
            n6 = this.m_linTree[n7];
            n13 = piVectorArray[n6].getSize();
            n5 = (this.m_linTreeParent[n6] + 3) % n13;
            while (n5 != (this.m_linTreeParent[n6] + 1) % n13) {
                if (piVectorArray[n6].m_data[n5] != n9 && piVectorArray[n6].m_data[n5] != n8) {
                    pdVector.copy(pdVectorArray[piVectorArray[n6].m_data[n5]]);
                    this.transform(pdMatrix, pdVector, pdVectorArray[piVectorArray[n6].m_data[n5]]);
                }
                n5 = (n5 + 1) % n13;
            }
        }
        if (nArray2[2] != -1 && nArray2[3] != -1) {
            for (n7 = nArray[nArray2[2]]; n7 <= nArray[nArray2[3]]; ++n7) {
                n6 = this.m_linTree[n7];
                n13 = piVectorArray[n6].getSize();
                n5 = (this.m_linTreeParent[n6] + 3) % n13;
                while (n5 != (this.m_linTreeParent[n6] + 1) % n13) {
                    if (piVectorArray[n6].m_data[n5] != n9 && piVectorArray[n6].m_data[n5] != n8) {
                        pdVector.copy(pdVectorArray[piVectorArray[n6].m_data[n5]]);
                        this.transform(pdMatrix, pdVector, pdVectorArray[piVectorArray[n6].m_data[n5]]);
                    }
                    n5 = (n5 + 1) % n13;
                }
            }
        }
    }

    protected PdMatrix computeTrafo(int n, int n2) {
        PdMatrix pdMatrix = new PdMatrix(2, 3);
        return this.computeTrafo(n, n2, pdMatrix);
    }

    protected PdMatrix computeTrafo(int n, int n2, PdMatrix pdMatrix) {
        PdVector pdVector;
        double d;
        PdVector pdVector2;
        if (this.m_geom.getNeighbour((int)n).m_data[n2] != -1) {
            return null;
        }
        PiVector[] piVectorArray = this.m_geom.getElements();
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        int n3 = this.m_geomSave.getNeighbour((int)n).m_data[n2];
        int n4 = piVectorArray[n].getSize();
        int n5 = piVectorArray[n3].getSize();
        int n6 = this.m_geomSave.getOppVertexLocInd(n, n2);
        double d2 = 0.0;
        double d3 = 0.0;
        boolean bl = false;
        if (this.m_geomSave.getElement((int)n).m_data[(n2 + 1) % n4] == this.m_geomSave.getElement((int)n3).m_data[(n6 + 1) % n5]) {
            d2 = pdVectorArray[piVectorArray[n3].m_data[(n6 + 2) % n5]].m_data[0] - pdVectorArray[piVectorArray[n].m_data[(n2 + 2) % n4]].m_data[0];
            d3 = pdVectorArray[piVectorArray[n3].m_data[(n6 + 2) % n5]].m_data[1] - pdVectorArray[piVectorArray[n].m_data[(n2 + 2) % n4]].m_data[1];
            pdVector2 = PdVector.subNew((PdVector)pdVectorArray[piVectorArray[n].m_data[(n2 + 2) % n4]], (PdVector)pdVectorArray[piVectorArray[n].m_data[(n2 + 1) % n4]]);
            PdVector pdVector3 = PdVector.subNew((PdVector)pdVectorArray[piVectorArray[n3].m_data[(n6 + 2) % n5]], (PdVector)pdVectorArray[piVectorArray[n3].m_data[(n6 + 1) % n5]]);
            d = PdVector.angleWithOrientation((PdVector)pdVector2, (PdVector)pdVector3, (PdVector)new PdVector(0.0, 0.0, 1.0));
            pdVector = new PdVector(3);
            PdVector pdVector4 = new PdVector(3);
            pdVector.normalOfPlane(pdVectorArray[piVectorArray[n].m_data[n2]], pdVectorArray[piVectorArray[n].m_data[(n2 + 1) % n4]], pdVectorArray[piVectorArray[n].m_data[(n2 + 2) % n4]]);
            pdVector4.normalOfPlane(pdVectorArray[piVectorArray[n3].m_data[n6]], pdVectorArray[piVectorArray[n3].m_data[(n6 + 1) % n5]], pdVectorArray[piVectorArray[n3].m_data[(n6 + 2) % n5]]);
            if (PdVector.dot((PdVector)pdVector, (PdVector)pdVector4) > 0.0) {
                bl = true;
            }
        } else {
            d2 = pdVectorArray[piVectorArray[n3].m_data[(n6 + 2) % n5]].m_data[0] - pdVectorArray[piVectorArray[n].m_data[(n2 + 1) % n4]].m_data[0];
            d3 = pdVectorArray[piVectorArray[n3].m_data[(n6 + 2) % n5]].m_data[1] - pdVectorArray[piVectorArray[n].m_data[(n2 + 1) % n4]].m_data[1];
            pdVector2 = PdVector.subNew((PdVector)pdVectorArray[piVectorArray[n].m_data[(n2 + 1) % n4]], (PdVector)pdVectorArray[piVectorArray[n].m_data[(n2 + 2) % n4]]);
            PdVector pdVector5 = PdVector.subNew((PdVector)pdVectorArray[piVectorArray[n3].m_data[(n6 + 2) % n5]], (PdVector)pdVectorArray[piVectorArray[n3].m_data[(n6 + 1) % n5]]);
            d = PdVector.angleWithOrientation((PdVector)pdVector2, (PdVector)pdVector5, (PdVector)new PdVector(0.0, 0.0, 1.0));
            pdVector = new PdVector(3);
            PdVector pdVector6 = new PdVector(3);
            pdVector.normalOfPlane(pdVectorArray[piVectorArray[n].m_data[n2]], pdVectorArray[piVectorArray[n].m_data[(n2 + 1) % n4]], pdVectorArray[piVectorArray[n].m_data[(n2 + 2) % n4]]);
            pdVector6.normalOfPlane(pdVectorArray[piVectorArray[n3].m_data[n6]], pdVectorArray[piVectorArray[n3].m_data[(n6 + 1) % n5]], pdVectorArray[piVectorArray[n3].m_data[(n6 + 2) % n5]]);
            if (PdVector.dot((PdVector)pdVector, (PdVector)pdVector6) < 0.0) {
                bl = true;
            }
        }
        double d4 = Math.cos(d);
        double d5 = Math.sin(d);
        PdVector pdVector7 = pdVectorArray[piVectorArray[n3].m_data[(n6 + 2) % n5]];
        if (pdMatrix == null || pdMatrix.getISize() < 2 || pdMatrix.getJSize() < 3) {
            pdMatrix = new PdMatrix(2, 3);
        }
        pdMatrix.m_data[0][0] = d4;
        pdMatrix.m_data[0][1] = -d5;
        pdMatrix.m_data[0][2] = pdVector7.m_data[0] - d4 * (pdVector7.m_data[0] - d2) + d5 * (pdVector7.m_data[1] - d3);
        pdMatrix.m_data[1][0] = d5;
        pdMatrix.m_data[1][1] = d4;
        pdMatrix.m_data[1][2] = pdVector7.m_data[1] - d5 * (pdVector7.m_data[0] - d2) - d4 * (pdVector7.m_data[1] - d3);
        if (bl) {
            PdVector pdVector8 = PdVector.subNew((PdVector)pdVectorArray[piVectorArray[n3].m_data[(n6 + 2) % n5]], (PdVector)pdVectorArray[piVectorArray[n3].m_data[(n6 + 1) % n5]]);
            double d6 = pdVector8.m_data[0];
            pdVector8.m_data[0] = -pdVector8.m_data[1];
            pdVector8.m_data[1] = d6;
            pdVector8.m_data[2] = 0.0;
            pdVector8.normalize();
            double d7 = pdVector8.m_data[0];
            double d8 = pdVector8.m_data[1];
            d6 = PdVector.dot((PdVector)pdVectorArray[piVectorArray[n3].m_data[(n6 + 2) % n5]], (PdVector)pdVector8);
            double d9 = pdMatrix.m_data[0][0];
            double d10 = pdMatrix.m_data[0][1];
            double d11 = pdMatrix.m_data[0][2];
            double d12 = pdMatrix.m_data[1][0];
            double d13 = pdMatrix.m_data[1][1];
            double d14 = pdMatrix.m_data[1][2];
            pdMatrix.m_data[0][0] = (1.0 - 2.0 * d7 * d7) * d9 - 2.0 * d8 * d7 * d12;
            pdMatrix.m_data[0][1] = (1.0 - 2.0 * d7 * d7) * d10 - 2.0 * d8 * d7 * d13;
            pdMatrix.m_data[0][2] = (1.0 - 2.0 * d7 * d7) * d11 - 2.0 * d8 * d7 * d14 + 2.0 * d6 * d7;
            pdMatrix.m_data[1][0] = -2.0 * d7 * d8 * d9 + (1.0 - 2.0 * d8 * d8) * d12;
            pdMatrix.m_data[1][1] = -2.0 * d7 * d8 * d10 + (1.0 - 2.0 * d8 * d8) * d13;
            pdMatrix.m_data[1][2] = -2.0 * d7 * d8 * d11 + (1.0 - 2.0 * d8 * d8) * d14 + 2.0 * d6 * d8;
        }
        return pdMatrix;
    }

    protected void moveTree(int n, int n2) {
        int n3;
        PiVector piVector = this.m_geomSave.getNeighbour(n);
        int n4 = piVector.getSize();
        for (n3 = 0; n3 < n4 && piVector.m_data[n3] != n2; ++n3) {
        }
        if (n3 == n4) {
            PsDebug.warning((String)"Cannot move tree.");
            return;
        }
        PdMatrix pdMatrix = this.computeTrafo(n, n3);
        this.moveTree(n, n3, pdMatrix);
    }

    protected void moveTree(int n, int n2, PdMatrix pdMatrix) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (pdMatrix == null || pdMatrix.getISize() < 2 || pdMatrix.getJSize() < 3) {
            PsDebug.warning((String)"Cannot move tree. Missing transformation matrix.");
            return;
        }
        PiVector[] piVectorArray = this.m_geom.getElements();
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        PiVector[] piVectorArray2 = this.m_geom.getNeighbours();
        int n7 = 0;
        int n8 = n;
        while (this.m_linTreeParent[n8] != -1) {
            n8 = piVectorArray2[n8].m_data[this.m_linTreeParent[n8]];
        }
        while (this.m_linTree[n7] != n8) {
            ++n7;
        }
        int n9 = this.m_geom.getNumElements();
        for (n6 = n7 + 1; n6 < n9 && this.m_linTreeParent[this.m_linTree[n6]] != -1; ++n6) {
        }
        if (n6 != n7) {
            --n6;
        }
        PiVector[] piVectorArray3 = this.m_geomSave.getNeighbours();
        piVectorArray2[n].m_data[n2] = piVectorArray3[n].m_data[n2];
        n8 = piVectorArray3[n].m_data[n2];
        int n10 = this.m_geomSave.getOppVertexLocInd(n, n2);
        piVectorArray2[n8].m_data[n10] = piVectorArray3[n8].m_data[n10];
        int n11 = n;
        int n12 = this.m_linTreeParent[n];
        int n13 = -1;
        if (n12 != -1) {
            n5 = piVectorArray2[n].m_data[n12];
            while (n5 != -1 && this.m_linTreeParent[n5] != -1) {
                n13 = this.m_linTreeParent[n5];
                this.m_linTreeParent[n5] = this.m_geom.getOppVertexLocInd(n11, n12);
                n11 = n5;
                n5 = piVectorArray2[n5].m_data[n13];
                n12 = n13;
            }
            if (n5 != -1) {
                this.m_linTreeParent[n5] = this.m_geom.getOppVertexLocInd(n11, n12);
            }
        }
        this.m_linTreeParent[n] = n2;
        int n14 = piVectorArray3[n].m_data[n2];
        int n15 = this.m_geomSave.getOppVertexLocInd(n, n2);
        int n16 = piVectorArray[n].getSize();
        int n17 = piVectorArray[n14].getSize();
        int n18 = piVectorArray[n].m_data[(n2 + 1) % n16];
        int n19 = piVectorArray[n].m_data[(n2 + 2) % n16];
        if (this.m_geomSave.getElement((int)n).m_data[(n2 + 1) % n16] == this.m_geomSave.getElement((int)n14).m_data[(n15 + 1) % piVectorArray3[n14].getSize()]) {
            n4 = piVectorArray[n14].m_data[(n15 + 1) % n17];
            n3 = piVectorArray[n14].m_data[(n15 + 2) % n17];
        } else {
            n4 = piVectorArray[n14].m_data[(n15 + 2) % n17];
            n3 = piVectorArray[n14].m_data[(n15 + 1) % n17];
        }
        for (n8 = n7; n8 <= n6; ++n8) {
            n16 = piVectorArray[this.m_linTree[n8]].getSize();
            for (n10 = 0; n10 < n16; ++n10) {
                if (piVectorArray[this.m_linTree[n8]].m_data[n10] == n18) {
                    piVectorArray[this.m_linTree[n8]].m_data[n10] = n4;
                }
                if (piVectorArray[this.m_linTree[n8]].m_data[n10] != n19) continue;
                piVectorArray[this.m_linTree[n8]].m_data[n10] = n3;
            }
        }
        PdVector pdVector = new PdVector(this.m_geom.getDimOfVertices());
        for (n8 = n7; n8 <= n6; ++n8) {
            n5 = this.m_linTree[n8];
            n16 = piVectorArray[n5].getSize();
            n10 = (this.m_linTreeParent[n5] + 3) % n16;
            while (n10 != (this.m_linTreeParent[n5] + 1) % n16) {
                if (piVectorArray[n5].m_data[n10] != n4 && piVectorArray[n5].m_data[n10] != n3) {
                    pdVector.copy(pdVectorArray[piVectorArray[n5].m_data[n10]]);
                    this.transform(pdMatrix, pdVector, pdVectorArray[piVectorArray[n5].m_data[n10]]);
                }
                n10 = (n10 + 1) % n16;
            }
        }
    }

    protected void setVertexPos() {
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        PiVector[] piVectorArray = this.m_geom.getElements();
        PdVector[] pdVectorArray2 = this.m_geomSave.getVertices();
        PiVector[] piVectorArray2 = this.m_geomSave.getElements();
        int n = this.m_geom.getNumElements();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < piVectorArray[i].getSize(); ++j) {
                for (int k = 0; k < 3; ++k) {
                    pdVectorArray[piVectorArray[i].m_data[j]].m_data[k] = pdVectorArray2[piVectorArray2[i].m_data[j]].m_data[k];
                }
            }
        }
        this.m_geom.makeNeighbour();
    }

    public boolean isRunning() {
        return this.m_bRunning;
    }

    public boolean isStopped() {
        return this.m_bStopped;
    }

    public void start() {
        if (!this.m_bStopped || this.m_bRunning) {
            return;
        }
        this.m_bRunning = true;
        this.m_bStopped = false;
        this.m_thread = new Thread((Runnable)this, "JavaView: Improve Unfolding");
        this.m_thread.setPriority(5);
        this.m_thread.start();
    }

    public void stop() {
        if (this.m_bRunning) {
            this.m_bStopImproving = true;
            this.m_thread = null;
        }
    }

    public void run() {
        this.improveUnfolding();
        this.m_bRunning = false;
        this.m_bStopImproving = false;
        this.m_bStopped = true;
        if (this.m_anim.getTime() != this.m_anim.getMaxTime()) {
            this.m_anim.setTime(this.m_anim.getMaxTime());
        } else {
            this.showSplices();
        }
        this.update(this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

