/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import jv.geom.PgElementSet;
import jv.geom.PgVectorField;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jvx.geom.PgUtil;
import jvx.number.PuHistogram;
import jvx.project.PjWorkshop;

public class PwHistogram
extends PjWorkshop {
    public static final int ITEM_EDGE_LENGTH = 0;
    public static final int ITEM_ELEMENT_AREA = 1;
    public static final int ITEM_VERTEX_ANGLE = 2;
    public static final int ITEM_SCALAR_FIELD = 3;
    public static final int ITEM_NORM_VECTOR_FIELD = 4;
    protected String[] m_itemArr = new String[]{"Edge Length", "Element Area", "Vertex Angle", "First Scalar Field", "Norm of Vector Field"};
    protected PgElementSet m_elemSet;
    protected PuHistogram m_histogram;
    protected int m_itemType;
    protected PdVector m_samples = new PdVector();
    static /* synthetic */ Class class$jvx$geom$PwHistogram;

    public PwHistogram() {
        super(PsConfig.getMessage((boolean)true, (int)50000, (String)"Histogram"));
        this.m_histogram = new PuHistogram("Histogram", (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PwHistogram == null ? (class$jvx$geom$PwHistogram = PwHistogram.class$("jvx.geom.PwHistogram")) : class$jvx$geom$PwHistogram)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_histogram.setClassType(0);
        this.m_histogram.setEnabledShowAxisLabels(true);
        this.m_histogram.setEnabledShowAxisTicks(true);
        this.m_histogram.setEnabledShowCounts(true);
        this.setItemType(1);
    }

    public void reset() {
        super.reset();
    }

    public void close() {
        if (this.m_elemSet != null) {
            this.m_elemSet.removeUpdateListener((PsUpdateIf)this);
        }
        this.m_elemSet = null;
    }

    public void setGeometry(PgElementSet pgElementSet) {
        super.setGeometry((PgGeometry)pgElementSet);
        this.m_elemSet = pgElementSet;
        this.m_elemSet.addUpdateListener((PsUpdateIf)this);
        this.m_histogram.setTitle("Histogram of " + pgElementSet.getName());
    }

    public boolean update(Object object) {
        if (object == this.m_elemSet) {
            this.computeSamples();
            this.m_histogram.update((Object)this.m_histogram);
            return true;
        }
        if (object == this.m_histogram) {
            return super.update((Object)this);
        }
        return false;
    }

    private void computeSamples() {
        if (this.m_itemType == 0) {
            PgUtil.getEdgeLengths(this.m_elemSet, this.m_samples, false);
        } else if (this.m_itemType == 1) {
            int n = this.m_elemSet.getNumElements();
            this.m_samples.setSize(n);
            for (int i = 0; i < n; ++i) {
                this.m_samples.setEntry(i, this.m_elemSet.getAreaOfElement(i));
            }
        } else if (this.m_itemType == 2) {
            PgUtil.getVertexAngles(this.m_elemSet, this.m_samples, false);
        } else if (this.m_itemType == 3) {
            boolean bl = false;
            int n = this.m_elemSet.getNumVectorFields();
            for (int i = 0; i < n; ++i) {
                PdVector[] pdVectorArray;
                PgVectorField pgVectorField = this.m_elemSet.getVectorField(i);
                if (pgVectorField.getDimOfVectors() != 1 || (pdVectorArray = pgVectorField.getVectors()) == null) continue;
                int n2 = pdVectorArray.length;
                this.m_samples.setSize(n2);
                for (int j = 0; j < n2; ++j) {
                    this.m_samples.setEntry(j, pdVectorArray[j].getEntry(0));
                }
                bl = true;
                break;
            }
            if (!bl) {
                PsDebug.warning((String)"missing scalar field");
                this.m_samples.setSize(0);
            }
        } else if (this.m_itemType == 4) {
            boolean bl = false;
            int n = this.m_elemSet.getNumVectorFields();
            for (int i = 0; i < n; ++i) {
                PgVectorField pgVectorField = this.m_elemSet.getVectorField(i);
                PdVector[] pdVectorArray = pgVectorField.getVectors();
                if (pdVectorArray == null) continue;
                int n3 = pdVectorArray.length;
                this.m_samples.setSize(n3);
                for (int j = 0; j < n3; ++j) {
                    this.m_samples.setEntry(j, pdVectorArray[j].length());
                }
                bl = true;
                break;
            }
            if (!bl) {
                PsDebug.warning((String)"missing vector field");
                this.m_samples.setSize(0);
            }
        }
        this.m_histogram.setSamples(this.m_samples);
    }

    public int getItemType() {
        return this.m_itemType;
    }

    public void setItemType(int n) {
        this.m_itemType = n;
        this.m_histogram.setXAxisLabel(this.m_itemArr[n]);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

