/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.awt.Color;
import jv.anim.PsAnimation;
import jv.anim.PsTimeEvent;
import jv.anim.PsTimeListenerIf;
import jv.geom.PgElementSet;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.project.PvPickEvent;
import jv.project.PvPickListenerIf;
import jv.vecmath.PdBary;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdVector;
import jvx.geom.PgPointSetOnElementSet;
import jvx.geom.PwBary;
import jvx.numeric.PnStraightestGeodesic;
import jvx.project.PjWorkshop;

public class PwGeodesicFlow
extends PjWorkshop
implements PsTimeListenerIf,
PvPickListenerIf {
    private PgElementSet m_elementSet = null;
    private PsAnimation m_animation = null;
    private PdBary m_spawnPoint = null;
    private double m_firstEdgeLength;
    private PnStraightestGeodesic m_exp = null;
    private PgPointSetOnElementSet m_particles = null;
    private double[] m_age;
    private PdBaryDir[] m_velocity;
    private boolean m_bSetHueColors = true;
    protected PuInteger m_maxNumParticles = new PuInteger(NUMPARTICLES, (PsUpdateIf)this);
    protected PuDouble m_speed = new PuDouble(SPEED, (PsUpdateIf)this);
    protected PuDouble m_maxAge = new PuDouble(LIFETIME, (PsUpdateIf)this);
    protected PuDouble m_emitInterval = new PuDouble(EMITINTERVAL, (PsUpdateIf)this);
    private static String TITLE = "Geodesic Flow";
    private static String NUMPARTICLES = "Number of Particles";
    private static String SPEED = "Speed";
    private static String LIFETIME = "Life Time";
    private static String EMITINTERVAL = "Emit Interval";
    static /* synthetic */ Class class$jvx$geom$PwGeodesicFlow;

    public PwGeodesicFlow() {
        super(TITLE);
        this.m_animation = new PsAnimation();
        this.m_animation.setName("Animation");
        this.m_animation.setTimeInterval(0.0, 40.0, 1.0, 2.0);
        this.m_animation.setRepeat(1);
        this.m_animation.addTimeListener((PsTimeListenerIf)this);
        this.m_spawnPoint = new PdBary(0, 1.0, 0.0, 0.0);
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PwGeodesicFlow == null ? (class$jvx$geom$PwGeodesicFlow = PwGeodesicFlow.class$("jvx.geom.PwGeodesicFlow")) : class$jvx$geom$PwGeodesicFlow)) {
            this.init();
        }
    }

    public void init() {
        this.m_maxNumParticles.setDefBounds(100, 20000, 100, 2000);
        this.m_maxNumParticles.setDefValue(5000);
        this.m_maxNumParticles.init();
        this.m_speed.setDefBounds(0.0, 0.5, 0.001, 0.01);
        this.m_speed.setDefValue(0.01);
        this.m_speed.init();
        this.m_maxAge.setDefBounds(10.0, 100.0, 1.0, 10.0);
        this.m_maxAge.setDefValue(40.0);
        this.m_maxAge.init();
        this.m_emitInterval.setDefBounds(1.0, 10.0, 1.0, 10.0);
        this.m_emitInterval.setDefValue(4.0);
        this.m_emitInterval.init();
        super.init();
    }

    public void ok() {
        this.m_animation.stop();
        this.m_animation.removeTimeListener((PsTimeListenerIf)this);
        super.ok();
    }

    public void cancel() {
        this.m_animation.stop();
        this.m_animation.removeTimeListener((PsTimeListenerIf)this);
        if (this.m_display != null && this.m_particles != null) {
            this.m_display.removeGeometry((PgGeometryIf)this.m_particles);
        }
        super.cancel();
    }

    public void setDisplay(PvDisplayIf pvDisplayIf) {
        super.setDisplay(pvDisplayIf);
        if (this.m_display != null) {
            this.m_display.addPickListener((PvPickListenerIf)this);
        }
        if (this.m_particles != null && this.m_display != null) {
            this.m_display.addGeometry((PgGeometryIf)this.m_particles);
        }
    }

    public void pickInitial(PvPickEvent pvPickEvent) {
        int n = pvPickEvent.getElementInd();
        if (n < 0) {
            return;
        }
        if (pvPickEvent.getGeometry() == null) {
            return;
        }
        this.m_spawnPoint.copy(pvPickEvent.getBary());
        this.m_firstEdgeLength = PwBary.norm(this.m_elementSet, this.m_spawnPoint.m_elementInd, PdBaryDir.TRIANGLE_EDGE[0], true);
        if (this.m_firstEdgeLength < 1.0E-10) {
            this.m_firstEdgeLength = 1.0;
        }
        this.m_animation.start();
    }

    public int initialize() {
        int n = this.getMaxNumParticles();
        double d = Math.ceil(this.getMaxAge() / this.getEmitInterval());
        int n2 = (int)((double)n / d);
        this.m_particles.setNumVertices(n);
        if (this.m_bSetHueColors) {
            this.m_particles.assureVertexColors();
            this.m_particles.showVertexColors(true);
        }
        this.m_age = new double[n];
        this.m_velocity = PdBaryDir.realloc((PdBaryDir[])this.m_velocity, (int)n, (int)3);
        int n3 = 0;
        double d2 = this.getMaxAge() - 1.0;
        for (int i = 0; i < n; ++i) {
            this.m_particles.setVertexBary(i, this.m_spawnPoint);
            if (++n3 > n2) {
                n3 = 0;
                d2 -= this.getEmitInterval();
            }
            this.m_age[i] = d2;
        }
        return n;
    }

    public boolean setTime(PsTimeEvent psTimeEvent) {
        if (this.m_spawnPoint == null) {
            return super.update((Object)this);
        }
        double d = this.getMaxAge();
        double d2 = this.getSpeed();
        if (d2 < 1.0E-10) {
            d2 = 1.0E-10;
        }
        int n = this.getMaxNumParticles();
        int n2 = this.m_particles.getNumVertices();
        if (n2 != n) {
            n2 = this.initialize();
        }
        PdBary[] pdBaryArray = this.m_particles.getVertexBary();
        for (int i = 0; i < n2; ++i) {
            PdBary pdBary = pdBaryArray[i];
            int n3 = i;
            this.m_age[n3] = this.m_age[n3] + 1.0;
            if (this.m_age[i] >= d) {
                this.m_age[i] = 0.0;
                pdBary.copy(this.m_spawnPoint);
                this.m_velocity[i].copyArray(PdBaryDir.TRIANGLE_EDGE[0]);
                this.m_velocity[i].multScalar(d2 / this.m_firstEdgeLength);
                double d3 = Math.random();
                if (this.m_bSetHueColors) {
                    this.m_particles.setVertexColor(i, Color.getHSBColor((float)d3, 1.0f, 1.0f));
                }
                PwBary.rotateInElement(this.m_elementSet, this.m_spawnPoint.m_elementInd, this.m_velocity[i], Math.PI * 2 * d3, this.m_velocity[i], false);
            }
            this.m_exp.eval(pdBary, this.m_velocity[i], pdBary, this.m_velocity[i]);
        }
        this.m_particles.computeVertices();
        this.m_particles.update(null);
        return true;
    }

    public void setAnimation(PsAnimation psAnimation) {
        this.m_animation = psAnimation;
    }

    public boolean hasAnimation() {
        return this.m_animation != null;
    }

    public PsAnimation getAnimation() {
        return this.m_animation;
    }

    public void markVertices(PvPickEvent pvPickEvent) {
    }

    public void selectGeometry(PgGeometryIf pgGeometryIf) {
    }

    public void pickVertex(PgGeometryIf pgGeometryIf, int n, PdVector pdVector) {
    }

    public void pickDisplay(PvPickEvent pvPickEvent) {
    }

    public void unmarkVertices(PvPickEvent pvPickEvent) {
    }

    public void dragVertex(PgGeometryIf pgGeometryIf, int n, PdVector pdVector) {
    }

    public void dragDisplay(PvPickEvent pvPickEvent) {
    }

    public void dragInitial(PvPickEvent pvPickEvent) {
        this.pickInitial(pvPickEvent);
    }

    public void setGeometry(PgGeometry pgGeometry) {
        if (!(pgGeometry instanceof PgElementSet)) {
            PsDebug.warning((String)"geometry is no PgElementSet");
            return;
        }
        this.m_elementSet = (PgElementSet)pgGeometry;
        super.setGeometry(pgGeometry);
        PdVector[] pdVectorArray = pgGeometry.getBounds();
        double d = pdVectorArray[1].dist(pdVectorArray[0]) / 1000.0;
        this.m_speed.setBounds(d, 100.0 * d, 2.0 * d, 10.0 * d);
        this.m_speed.setValue(5.0 * d);
        this.m_exp = new PnStraightestGeodesic(this.m_elementSet);
        this.m_particles = new PgPointSetOnElementSet(this.m_elementSet);
        this.m_particles.setName("Particles");
        this.m_particles.setGlobalVertexSize(this.getMaxNumParticles() < 30 ? 2.0 : 1.0);
        this.m_particles.showVertexOutline(false);
        this.m_particles.showVertices(true);
        this.m_particles.setNumVertices(0);
        this.m_particles.showVertexColors(true);
        this.m_particles.update(null);
        if (this.m_display != null) {
            this.m_display.addGeometry((PgGeometryIf)this.m_particles);
        }
        if (this.m_spawnPoint != null) {
            this.m_firstEdgeLength = PwBary.norm(this.m_elementSet, this.m_spawnPoint.m_elementInd, PdBaryDir.TRIANGLE_EDGE[0], true);
            if (this.m_firstEdgeLength < 1.0E-10) {
                this.m_firstEdgeLength = 1.0;
            }
        }
        super.update((Object)this);
    }

    public void setEnabledHueColoring(boolean bl) {
        this.m_bSetHueColors = bl;
        if (bl && this.m_particles != null) {
            this.m_particles.assureVertexColors();
            this.m_particles.showVertexColors(true);
        }
    }

    public int getMaxNumParticles() {
        return this.m_maxNumParticles.getValue();
    }

    public void setMaxNumParticles(int n) {
        this.m_maxNumParticles.setValue(n);
    }

    public double getMaxAge() {
        return this.m_maxAge.getValue();
    }

    public void setMaxAge(double d) {
        this.m_maxAge.setValue(d);
    }

    public double getEmitInterval() {
        return this.m_emitInterval.getValue();
    }

    public void setEmitInterval(double d) {
        this.m_emitInterval.setValue(d);
    }

    public double getSpeed() {
        return this.m_speed.getValue();
    }

    public void setSpeed(double d) {
        this.m_speed.setValue(d);
    }

    public boolean update(Object object) {
        if (object != this.m_maxNumParticles && object != this.m_speed) {
            if (object == this.m_maxAge) {
                this.initialize();
            } else if (object == this.m_emitInterval) {
                this.initialize();
            } else {
                return super.update(object);
            }
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

