/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.geom.PgPolygonSet;
import jv.geom.PgVectorField;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.vecmath.P_Vector;
import jv.vecmath.PdBary;
import jv.vecmath.PiVector;
import jvx.geom.PgPolygonOnElementSet;

public class PgPolygonSetOnElementSet
extends PgPolygonSet {
    protected PgElementSet m_geom;
    protected static final int m_dimOfElements = 3;
    protected PdBary[] m_vertexBary;
    static /* synthetic */ Class class$jvx$geom$PgPolygonSetOnElementSet;

    public PgPolygonSetOnElementSet(PgElementSet pgElementSet) {
        this(pgElementSet, pgElementSet.getDimOfVertices());
    }

    public PgPolygonSetOnElementSet(PgElementSet pgElementSet, int n) {
        super(n);
        this.m_geom = pgElementSet;
        this.m_vertexBary = new PdBary[0];
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PgPolygonSetOnElementSet == null ? (class$jvx$geom$PgPolygonSetOnElementSet = PgPolygonSetOnElementSet.class$("jvx.geom.PgPolygonSetOnElementSet")) : class$jvx$geom$PgPolygonSetOnElementSet)) {
            this.init();
        }
    }

    public void init() {
        super.init();
    }

    public PgElementSet getGeometry() {
        return this.m_geom;
    }

    public void setGeometry(PgElementSet pgElementSet) {
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"Geometry is not triangulated.");
            return;
        }
        this.m_geom = pgElementSet;
    }

    public Object clone() {
        PgPolygonSetOnElementSet pgPolygonSetOnElementSet = (PgPolygonSetOnElementSet)((Object)super.clone());
        if (pgPolygonSetOnElementSet == null) {
            return null;
        }
        if (this.m_geom != null) {
            pgPolygonSetOnElementSet.setGeometry(this.m_geom);
        }
        if (this.m_vertexBary != null) {
            pgPolygonSetOnElementSet.m_vertexBary = (PdBary[])P_Vector.clone((P_Vector[])this.m_vertexBary);
        }
        return pgPolygonSetOnElementSet;
    }

    public void copy(PsObject psObject) {
        super.copy(psObject);
        if (psObject == null) {
            return;
        }
        if (!(psObject instanceof PgPolygonSetOnElementSet)) {
            return;
        }
        PgPolygonSetOnElementSet pgPolygonSetOnElementSet = (PgPolygonSetOnElementSet)psObject;
        PdBary.copy((PdBary[])this.m_vertexBary, (int)0, (PdBary[])pgPolygonSetOnElementSet.m_vertexBary, (int)0, (int)((PgPointSet)this).m_numVertices);
    }

    public boolean merge(PgGeometryIf pgGeometryIf) {
        int n = this.getNumVertices();
        if (!super.merge(pgGeometryIf)) {
            return false;
        }
        if (!(pgGeometryIf instanceof PgPolygonSetOnElementSet)) {
            return false;
        }
        PgPolygonSetOnElementSet pgPolygonSetOnElementSet = (PgPolygonSetOnElementSet)pgGeometryIf;
        if (pgPolygonSetOnElementSet.m_geom != this.m_geom) {
            return false;
        }
        int n2 = pgPolygonSetOnElementSet.getNumVertices();
        PdBary.copy((PdBary[])this.m_vertexBary, (int)n, (PdBary[])pgPolygonSetOnElementSet.m_vertexBary, (int)0, (int)n2);
        return true;
    }

    public boolean blend(double d, PgGeometry pgGeometry, double d2, PgGeometry pgGeometry2) {
        if (!super.blend(d, pgGeometry, d2, pgGeometry2)) {
            return false;
        }
        if (!(pgGeometry instanceof PgPolygonSetOnElementSet) || !(pgGeometry2 instanceof PgPolygonSetOnElementSet)) {
            return false;
        }
        PgPolygonSetOnElementSet pgPolygonSetOnElementSet = (PgPolygonSetOnElementSet)pgGeometry;
        PgPolygonSetOnElementSet pgPolygonSetOnElementSet2 = (PgPolygonSetOnElementSet)pgGeometry2;
        int n = pgPolygonSetOnElementSet.getNumVertices();
        for (int i = 0; i < n; ++i) {
            pgPolygonSetOnElementSet.m_vertexBary[i].blend(d, pgPolygonSetOnElementSet.m_vertexBary[i], d2, pgPolygonSetOnElementSet2.m_vertexBary[i]);
        }
        return true;
    }

    public void setMaxNumVertices(int n) {
        if (((PgPointSet)this).m_maxNumVertices == n) {
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            ((PgPointSet)this).m_maxNumVertices = n;
            return;
        }
        super.setMaxNumVertices(n);
        this.m_vertexBary = PdBary.realloc((PdBary[])this.m_vertexBary, (int)n, (int)3);
    }

    public PdBary[] getVertexBary() {
        return this.m_vertexBary;
    }

    public PdBary getVertexBary(int n) {
        if (n < 0 || n >= ((PgPointSet)this).m_numVertices) {
            PsDebug.warning((String)("Vertex index out of bounds: " + n + "."));
            return null;
        }
        return this.m_vertexBary[n];
    }

    public int getVertexElemInd(int n) {
        if (n < 0 || n >= ((PgPointSet)this).m_numVertices) {
            PsDebug.warning((String)("Vertex index out of bounds: " + n + "."));
            return -1;
        }
        return this.m_vertexBary[n].m_elementInd;
    }

    public void setVertexBary(int n, int n2, PdBary pdBary) {
        if (pdBary == null) {
            PsDebug.warning((String)"Missing bary vector.");
            return;
        }
        if (n < 0 || n >= ((PgPointSet)this).m_numVertices) {
            PsDebug.warning((String)("Vertex index out of bounds: " + n + "."));
            return;
        }
        if (n2 < 0 || this.m_geom != null && n2 >= this.m_geom.getNumElements()) {
            PsDebug.warning((String)("Element index out of bounds: " + n2 + "."));
            return;
        }
        if (this.m_geom != null) {
            PiVector piVector = this.m_geom.getElement(n2);
            pdBary.getVertex(((PgPointSet)this).m_vertex[n], this.m_geom.getVertex(piVector.m_data[0]), this.m_geom.getVertex(piVector.m_data[1]), this.m_geom.getVertex(piVector.m_data[2]));
        }
        this.m_vertexBary[n].copy(pdBary);
        this.m_vertexBary[n].setElementInd(n2);
    }

    public void setVertexBary(int n, PdBary pdBary) {
        if (pdBary == null) {
            PsDebug.warning((String)"Missing bary vector.");
            return;
        }
        this.setVertexBary(n, pdBary.getElementInd(), pdBary);
    }

    public void computeVertices() {
        if (this.m_geom == null) {
            PsDebug.warning((String)"Missing surface.");
            return;
        }
        if (((PgPointSet)this).m_numVertices == 0) {
            return;
        }
        for (int i = 0; i < ((PgPointSet)this).m_numVertices; ++i) {
            int n = this.m_vertexBary[i].getElementInd();
            if (n == -1) {
                PsDebug.warning((String)("Missing element index in vertexBary[" + i + "]"));
                return;
            }
            PiVector piVector = this.m_geom.getElement(n);
            this.m_vertexBary[i].getVertex(((PgPointSet)this).m_vertex[i], this.m_geom.getVertex(piVector.m_data[0]), this.m_geom.getVertex(piVector.m_data[1]), this.m_geom.getVertex(piVector.m_data[2]));
        }
    }

    public int addPolygonBary(PgPolygonOnElementSet pgPolygonOnElementSet) {
        if (pgPolygonOnElementSet == null) {
            PsDebug.warning((String)"polygon is null");
            return -1;
        }
        if (this.m_geom != pgPolygonOnElementSet.getGeometry()) {
            PsDebug.warning((String)"Polygon live on a different element set.");
            return -1;
        }
        int n = ((PgPointSet)this).m_numVertices;
        PgPolygonSet pgPolygonSet = PgPolygonSet.convert((PgPolygon)pgPolygonOnElementSet);
        this.merge((PgGeometryIf)pgPolygonSet);
        PdBary.copy((PdBary[])this.m_vertexBary, (int)n, (PdBary[])pgPolygonOnElementSet.getVertexBary(), (int)0, (int)pgPolygonOnElementSet.getNumVertices());
        return this.m_numPolygons - 1;
    }

    public boolean removeUnusedVertices() {
        int n;
        int n2;
        int n3 = 1;
        int n4 = -1;
        PiVector piVector = new PiVector(((PgPointSet)this).m_numVertices);
        piVector.setConstant(n4);
        int[] nArray = piVector.m_data;
        for (n2 = 0; n2 < this.m_numPolygons; ++n2) {
            for (n = 0; n < this.m_polygon[n2].m_data.length; ++n) {
                nArray[this.m_polygon[n2].m_data[n]] = n3;
            }
        }
        int n5 = 0;
        for (n2 = 0; n2 < ((PgPointSet)this).m_numVertices; ++n2) {
            if (nArray[n2] != n3) continue;
            nArray[n2] = n5++;
        }
        if (n5 == ((PgPointSet)this).m_numVertices) {
            return true;
        }
        for (n2 = 0; n2 < ((PgPointSet)this).m_numVertices; ++n2) {
            if (nArray[n2] == n4 || nArray[n2] >= n2) continue;
            ((PgPointSet)this).m_vertex[nArray[n2]] = ((PgPointSet)this).m_vertex[n2];
        }
        for (n2 = 0; n2 < this.m_numPolygons; ++n2) {
            for (n = 0; n < this.m_polygon[n2].m_data.length; ++n) {
                this.m_polygon[n2].m_data[n] = nArray[this.m_polygon[n2].m_data[n]];
            }
        }
        if (((PgPointSet)this).m_vertexNormal != null) {
            for (n2 = 0; n2 < ((PgPointSet)this).m_numVertices; ++n2) {
                if (nArray[n2] == n4 || nArray[n2] >= n2) continue;
                ((PgPointSet)this).m_vertexNormal[nArray[n2]] = ((PgPointSet)this).m_vertexNormal[n2];
            }
        }
        if (((PgPointSet)this).m_vertexColor != null) {
            for (n2 = 0; n2 < ((PgPointSet)this).m_numVertices; ++n2) {
                if (nArray[n2] == n4 || nArray[n2] >= n2) continue;
                ((PgPointSet)this).m_vertexColor[nArray[n2]] = ((PgPointSet)this).m_vertexColor[n2];
            }
        }
        int n6 = this.getNumVectorFields();
        for (n2 = 0; n2 < n6; ++n2) {
            PgVectorField pgVectorField = this.getVectorField(n2);
            if (pgVectorField.getBasedOn() == 1) continue;
            for (n = 0; n < ((PgPointSet)this).m_numVertices; ++n) {
                if (nArray[n] == n4 || nArray[n] >= n) continue;
                pgVectorField.setVector(nArray[n], pgVectorField.getVector(n));
            }
            pgVectorField.setNumVectors(n5);
        }
        if (this.m_vertexBary != null) {
            for (n2 = 0; n2 < ((PgPointSet)this).m_numVertices; ++n2) {
                if (nArray[n2] == n4 || nArray[n2] >= n2) continue;
                this.m_vertexBary[nArray[n2]] = this.m_vertexBary[n2];
            }
        }
        this.setNumVertices(n5);
        this.setMaxNumVertices(n5);
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

