/*
 * Decompiled with CFR 0.152.
 */
package jvx.surface;

import java.util.Enumeration;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PuCleanMesh;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PvDisplayIf;
import jv.vecmath.PiVector;

public class PgGenusSurface
extends PgElementSet {
    public static int TYPE_HOLES_IN_A_ROW = 0;
    public static int TYPE_HOLES_ON_A_CIRCLE = 1;
    protected PuInteger m_genus;
    protected PuDouble m_xSize;
    protected PuDouble m_ySize;
    protected PuDouble m_zSize;
    protected PuDouble m_holeBySize;
    protected PuDouble m_ySizeOfHole;
    protected PuDouble m_radius;
    protected PuDouble m_radius1;
    protected PuDouble m_radius2;
    protected int m_defGenus;
    protected double m_defxSize;
    protected double m_defHoleBySize;
    protected double m_defYSizeOfHole;
    protected int m_type;
    protected double m_oldQuot;
    protected boolean m_bfitSurface;
    static /* synthetic */ Class class$jvx$surface$PgGenusSurface;

    public PgGenusSurface() {
        super(3);
        this.setTag(10);
        this.m_defGenus = 3;
        this.m_defxSize = 5.0;
        this.m_defHoleBySize = 0.35;
        this.m_defYSizeOfHole = 0.35;
        this.m_oldQuot = this.m_defxSize / (double)this.m_defGenus;
        this.m_type = TYPE_HOLES_IN_A_ROW;
        this.m_genus = new PuInteger(PsConfig.getMessage((int)54341), (PsUpdateIf)this);
        this.m_holeBySize = new PuDouble(PsConfig.getMessage((int)54498), (PsUpdateIf)this);
        this.m_ySizeOfHole = new PuDouble(PsConfig.getMessage((int)54499), (PsUpdateIf)this);
        this.m_xSize = new PuDouble(PsConfig.getMessage((int)54342), (PsUpdateIf)this);
        this.m_ySize = new PuDouble(PsConfig.getMessage((int)54285), (PsUpdateIf)this);
        this.m_zSize = new PuDouble(PsConfig.getMessage((int)54286), (PsUpdateIf)this);
        this.m_radius = new PuDouble(PsConfig.getMessage((int)54399), (PsUpdateIf)this);
        this.m_radius1 = new PuDouble(PsConfig.getMessage((int)54400), (PsUpdateIf)this);
        this.m_radius2 = new PuDouble(PsConfig.getMessage((int)54401), (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$jvx$surface$PgGenusSurface == null ? (class$jvx$surface$PgGenusSurface = PgGenusSurface.class$("jvx.surface.PgGenusSurface")) : class$jvx$surface$PgGenusSurface)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_bfitSurface = false;
        this.m_genus.setDefBounds(1, 10, 1, 2);
        this.m_genus.setDefValue(3);
        this.m_genus.init();
        this.m_holeBySize.setDefBounds(0.01, 0.49, 0.01, 0.1);
        this.m_holeBySize.setDefValue(this.m_defHoleBySize);
        this.m_holeBySize.init();
        this.m_ySizeOfHole.setDefBounds(0.01, 0.49, 0.01, 0.1);
        this.m_ySizeOfHole.setDefValue(this.m_defYSizeOfHole);
        this.m_ySizeOfHole.init();
        this.m_xSize.setDefBounds(0.0, 20.0, 0.1, 0.5);
        this.m_xSize.setDefValue(this.m_defxSize);
        this.m_xSize.init();
        this.m_ySize.setDefBounds(0.0, 10.0, 0.1, 0.5);
        this.m_ySize.setDefValue((double)Math.round(10.0 / (double)this.m_defGenus * this.m_defxSize) / 10.0);
        this.m_ySize.init();
        this.m_zSize.setDefBounds(0.0, 10.0, 0.1, 0.5);
        this.m_zSize.setDefValue((double)Math.round(10.0 / (double)this.m_defGenus / 3.0 * this.m_defxSize) / 10.0);
        this.m_zSize.init();
        this.m_radius.setDefBounds(0.0, 20.0, 0.1, 1.0);
        this.m_radius.setDefValue(this.m_defxSize);
        this.m_radius.init();
        this.m_radius1.setDefBounds(0.0, 1.0, 0.01, 0.1);
        this.m_radius1.setDefValue(0.3);
        this.m_radius1.init();
        this.m_radius2.setDefBounds(0.0, 1.0, 0.01, 0.1);
        this.m_radius2.setDefValue(0.5);
        this.m_radius2.init();
        this.setOrderingOfHoles(TYPE_HOLES_IN_A_ROW);
        this.computeSurface();
        if (this.m_bfitSurface) {
            this.fitSurface();
        }
    }

    protected void fitSurface() {
        if (((PgGeometry)this).m_displayList != null) {
            Enumeration enumeration = ((PgGeometry)this).m_displayList.elements();
            while (enumeration.hasMoreElements()) {
                PvDisplayIf pvDisplayIf = (PvDisplayIf)enumeration.nextElement();
                pvDisplayIf.fit();
            }
        }
    }

    public boolean update(Object object) {
        if (object == this.m_genus || object == this.m_xSize || object == this.m_ySize || object == this.m_zSize || object == this.m_holeBySize || object == this.m_ySizeOfHole || object == this.m_radius || object == this.m_radius1 || object == this.m_radius2) {
            int n = this.m_genus.getValue();
            if (object == this.m_genus && this.m_type == TYPE_HOLES_IN_A_ROW) {
                this.m_xSize.setValue(this.m_oldQuot * (double)n);
                this.m_xSize.updatePanels((Object)this.m_xSize);
            }
            if (object == this.m_xSize && this.m_type == TYPE_HOLES_IN_A_ROW) {
                this.m_oldQuot = this.m_xSize.getValue() / (double)n;
            }
            this.computeSurface();
            this.update((Object)this);
            if (this.m_bfitSurface) {
                this.fitSurface();
            }
            return true;
        }
        return super.update(object);
    }

    public void setXSize(double d) {
        this.m_xSize.setValue(d);
    }

    public double getXSize() {
        return this.m_xSize.getValue();
    }

    public void setYSize(double d) {
        this.m_ySize.setValue(d);
    }

    public double getYSize() {
        return this.m_ySize.getValue();
    }

    public void setZSize(double d) {
        this.m_zSize.setValue(d);
    }

    public double getZSize() {
        return this.m_zSize.getValue();
    }

    public void setGenus(int n) {
        this.m_genus.setValue(n);
    }

    public int getGenus() {
        return this.m_genus.getValue();
    }

    public void setRadiusOfSurface(double d) {
        this.m_radius.setValue(d);
    }

    public double getRadiusOfSurface() {
        return this.m_radius.getValue();
    }

    public void setSizeOfHoles(double d) {
        this.m_holeBySize.setValue(d);
        this.m_ySizeOfHole.setValue(d);
    }

    public double getSizeOfHoles() {
        return this.m_holeBySize.getValue();
    }

    public void setXSizeOfHoles(double d) {
        this.m_holeBySize.setValue(d);
    }

    public double getXSizeOfHoles() {
        return this.m_holeBySize.getValue();
    }

    public void setYSizeOfHoles(double d) {
        this.m_ySizeOfHole.setValue(d);
    }

    public double getYSizeOfHoles() {
        return this.m_ySizeOfHole.getValue();
    }

    public void setInnerBorderOfHoles(double d) {
        this.m_radius1.setValue(d);
    }

    public double getInnerBorderOfHoles() {
        return this.m_radius1.getValue();
    }

    public void setOuterBorderOfHoles(double d) {
        this.m_radius2.setValue(d);
    }

    public double getOuterBorderOfHoles() {
        return this.m_radius2.getValue();
    }

    public void setOrderingOfHoles(int n) {
        if (n == TYPE_HOLES_IN_A_ROW) {
            this.m_type = TYPE_HOLES_IN_A_ROW;
            if (!this.m_xSize.isEnabled()) {
                this.m_xSize.setEnabled(true);
            }
            if (!this.m_ySize.isEnabled()) {
                this.m_ySize.setEnabled(true);
            }
            if (!this.m_zSize.isEnabled()) {
                this.m_zSize.setEnabled(true);
            }
            if (!this.m_holeBySize.isEnabled()) {
                this.m_holeBySize.setEnabled(true);
            }
            if (!this.m_ySizeOfHole.isEnabled()) {
                this.m_ySizeOfHole.setEnabled(true);
            }
            if (this.m_radius.isEnabled()) {
                this.m_radius.setEnabled(false);
            }
            if (this.m_radius1.isEnabled()) {
                this.m_radius1.setEnabled(false);
            }
            if (this.m_radius2.isEnabled()) {
                this.m_radius2.setEnabled(false);
            }
            this.computeSurface();
        } else if (n == TYPE_HOLES_ON_A_CIRCLE) {
            this.m_type = TYPE_HOLES_ON_A_CIRCLE;
            if (this.m_xSize.isEnabled()) {
                this.m_xSize.setEnabled(false);
            }
            if (this.m_ySize.isEnabled()) {
                this.m_ySize.setEnabled(false);
            }
            if (!this.m_zSize.isEnabled()) {
                this.m_zSize.setEnabled(true);
            }
            if (this.m_holeBySize.isEnabled()) {
                this.m_holeBySize.setEnabled(false);
            }
            if (this.m_ySizeOfHole.isEnabled()) {
                this.m_ySizeOfHole.setEnabled(false);
            }
            if (!this.m_radius.isEnabled()) {
                this.m_radius.setEnabled(true);
            }
            if (!this.m_radius1.isEnabled()) {
                this.m_radius1.setEnabled(true);
            }
            if (!this.m_radius2.isEnabled()) {
                this.m_radius2.setEnabled(true);
            }
            this.computeSurface();
        } else {
            PsDebug.warning((String)"Cannot set order of holes, unknown ordering.");
            return;
        }
    }

    public int getOderingOfHoles() {
        return this.m_type;
    }

    public void computeSurface() {
        int n = this.m_genus.getValue();
        if (n <= 0) {
            return;
        }
        if (this.m_type == TYPE_HOLES_IN_A_ROW || n < 3) {
            int n2 = 12;
            this.setNumVertices(4 + n2 * n);
            int n3 = 14;
            this.setNumElements(2 + n3 * n);
            double d = this.m_xSize.getValue();
            double d2 = 1.0 / (double)n * d;
            double d3 = this.m_ySize.getValue();
            double d4 = this.m_zSize.getValue();
            for (int i = 0; i < 4; ++i) {
                ((PgPointSet)this).m_vertex[i].m_data[0] = 0.0;
                ((PgPointSet)this).m_vertex[i].m_data[1] = (double)(i / 2) * d3;
                ((PgPointSet)this).m_vertex[i].m_data[2] = (double)(i % 2) * d4;
            }
            double d5 = (1.0 - this.m_holeBySize.getValue()) * d2;
            double d6 = (1.0 - this.m_ySizeOfHole.getValue()) * d3;
            for (int i = 0; i < n; ++i) {
                int n4;
                for (n4 = 0; n4 < 4; ++n4) {
                    ((PgPointSet)this).m_vertex[4 + n2 * i + n4].m_data[0] = (double)(i + 1) * d2 - d5;
                }
                for (n4 = 4; n4 < 8; ++n4) {
                    ((PgPointSet)this).m_vertex[4 + n2 * i + n4].m_data[0] = (double)i * d2 + d5;
                }
                for (n4 = 8; n4 < 12; ++n4) {
                    ((PgPointSet)this).m_vertex[4 + n2 * i + n4].m_data[0] = (double)(i + 1) * d2;
                }
                for (n4 = 0; n4 < n2; ++n4) {
                    switch (n4 >> 1) {
                        case 0: 
                        case 2: {
                            ((PgPointSet)this).m_vertex[4 + n2 * i + n4].m_data[1] = d3 - d6;
                            break;
                        }
                        case 1: 
                        case 3: {
                            ((PgPointSet)this).m_vertex[4 + n2 * i + n4].m_data[1] = d6;
                            break;
                        }
                        case 4: {
                            ((PgPointSet)this).m_vertex[4 + n2 * i + n4].m_data[1] = 0.0;
                            break;
                        }
                        case 5: {
                            ((PgPointSet)this).m_vertex[4 + n2 * i + n4].m_data[1] = d3;
                        }
                    }
                    ((PgPointSet)this).m_vertex[4 + n2 * i + n4].m_data[2] = (double)(n4 % 2) * d4;
                }
                this.setElement(i * n3, i * n2 + 0, i * n2 + 12, i * n2 + 13, i * n2 + 1);
                this.setElement(i * n3 + 1, i * n2 + 2, i * n2 + 3, i * n2 + 15, i * n2 + 14);
                this.setElement(i * n3 + 2, i * n2 + 4, i * n2 + 5, i * n2 + 9, i * n2 + 8);
                this.setElement(i * n3 + 3, i * n2 + 6, i * n2 + 10, i * n2 + 11, i * n2 + 7);
                this.setElement(i * n3 + 4, i * n2 + 4, i * n2 + 6, i * n2 + 7, i * n2 + 5);
                this.setElement(i * n3 + 5, i * n2 + 8, i * n2 + 9, i * n2 + 11, i * n2 + 10);
                this.setElement(i * n3 + 6, i * n2 + 0, i * n2 + 4, i * n2 + 8, i * n2 + 12);
                this.setElement(i * n3 + 7, i * n2 + 12, i * n2 + 8, i * n2 + 10, i * n2 + 14);
                this.setElement(i * n3 + 8, i * n2 + 14, i * n2 + 10, i * n2 + 6, i * n2 + 2);
                this.setElement(i * n3 + 9, i * n2 + 2, i * n2 + 6, i * n2 + 4, i * n2 + 0);
                this.setElement(i * n3 + 10, i * n2 + 1, i * n2 + 13, i * n2 + 9, i * n2 + 5);
                this.setElement(i * n3 + 11, i * n2 + 13, i * n2 + 15, i * n2 + 11, i * n2 + 9);
                this.setElement(i * n3 + 12, i * n2 + 15, i * n2 + 3, i * n2 + 7, i * n2 + 11);
                this.setElement(i * n3 + 13, i * n2 + 3, i * n2 + 1, i * n2 + 5, i * n2 + 7);
            }
            this.setElement(n * n3, 0, 1, 3, 2);
            this.setElement(n * n3 + 1, n * n2, n * n2 + 2, n * n2 + 3, n * n2 + 1);
            this.makeNeighbour();
        } else if (this.m_type == TYPE_HOLES_ON_A_CIRCLE) {
            int n5;
            double d = this.m_radius.getValue();
            double d7 = Math.PI * 2 / (double)(3 * n);
            double d8 = 0.1 * d;
            double d9 = this.m_radius1.getValue() * d;
            double d10 = this.m_radius2.getValue() * d;
            double d11 = this.m_zSize.getValue();
            this.setNumVertices(12 * n + 4);
            this.setNumElements(2 + n * 13);
            ((PgPointSet)this).m_vertex[0].m_data[0] = 0.0;
            ((PgPointSet)this).m_vertex[0].m_data[1] = d8;
            ((PgPointSet)this).m_vertex[0].m_data[2] = 0.0;
            ((PgPointSet)this).m_vertex[1].m_data[0] = 0.0;
            ((PgPointSet)this).m_vertex[1].m_data[1] = d8;
            ((PgPointSet)this).m_vertex[1].m_data[2] = d11;
            ((PgPointSet)this).m_vertex[2].m_data[0] = 0.0;
            ((PgPointSet)this).m_vertex[2].m_data[1] = d;
            ((PgPointSet)this).m_vertex[2].m_data[2] = 0.0;
            ((PgPointSet)this).m_vertex[3].m_data[0] = 0.0;
            ((PgPointSet)this).m_vertex[3].m_data[1] = d;
            ((PgPointSet)this).m_vertex[3].m_data[2] = d11;
            for (int i = 0; i < n; ++i) {
                double d12 = Math.sin((double)(3 * i + 1) * d7);
                double d13 = Math.cos((double)(3 * i + 1) * d7);
                ((PgPointSet)this).m_vertex[4 + i * 12].m_data[0] = d12 * d9;
                ((PgPointSet)this).m_vertex[4 + i * 12].m_data[1] = d13 * d9;
                ((PgPointSet)this).m_vertex[4 + i * 12].m_data[2] = 0.0;
                ((PgPointSet)this).m_vertex[5 + i * 12].m_data[0] = d12 * d9;
                ((PgPointSet)this).m_vertex[5 + i * 12].m_data[1] = d13 * d9;
                ((PgPointSet)this).m_vertex[5 + i * 12].m_data[2] = d11;
                ((PgPointSet)this).m_vertex[6 + i * 12].m_data[0] = d12 * d10;
                ((PgPointSet)this).m_vertex[6 + i * 12].m_data[1] = d13 * d10;
                ((PgPointSet)this).m_vertex[6 + i * 12].m_data[2] = 0.0;
                ((PgPointSet)this).m_vertex[7 + i * 12].m_data[0] = d12 * d10;
                ((PgPointSet)this).m_vertex[7 + i * 12].m_data[1] = d13 * d10;
                ((PgPointSet)this).m_vertex[7 + i * 12].m_data[2] = d11;
                d12 = Math.sin((double)(3 * i + 2) * d7);
                d13 = Math.cos((double)(3 * i + 2) * d7);
                ((PgPointSet)this).m_vertex[8 + i * 12].m_data[0] = d12 * d9;
                ((PgPointSet)this).m_vertex[8 + i * 12].m_data[1] = d13 * d9;
                ((PgPointSet)this).m_vertex[8 + i * 12].m_data[2] = 0.0;
                ((PgPointSet)this).m_vertex[9 + i * 12].m_data[0] = d12 * d9;
                ((PgPointSet)this).m_vertex[9 + i * 12].m_data[1] = d13 * d9;
                ((PgPointSet)this).m_vertex[9 + i * 12].m_data[2] = d11;
                ((PgPointSet)this).m_vertex[10 + i * 12].m_data[0] = d12 * d10;
                ((PgPointSet)this).m_vertex[10 + i * 12].m_data[1] = d13 * d10;
                ((PgPointSet)this).m_vertex[10 + i * 12].m_data[2] = 0.0;
                ((PgPointSet)this).m_vertex[11 + i * 12].m_data[0] = d12 * d10;
                ((PgPointSet)this).m_vertex[11 + i * 12].m_data[1] = d13 * d10;
                ((PgPointSet)this).m_vertex[11 + i * 12].m_data[2] = d11;
                d12 = Math.sin((double)(3 * i + 3) * d7);
                d13 = Math.cos((double)(3 * i + 3) * d7);
                ((PgPointSet)this).m_vertex[12 + i * 12].m_data[0] = d12 * d8;
                ((PgPointSet)this).m_vertex[12 + i * 12].m_data[1] = d13 * d8;
                ((PgPointSet)this).m_vertex[12 + i * 12].m_data[2] = 0.0;
                ((PgPointSet)this).m_vertex[13 + i * 12].m_data[0] = d12 * d8;
                ((PgPointSet)this).m_vertex[13 + i * 12].m_data[1] = d13 * d8;
                ((PgPointSet)this).m_vertex[13 + i * 12].m_data[2] = d11;
                ((PgPointSet)this).m_vertex[14 + i * 12].m_data[0] = d12 * d;
                ((PgPointSet)this).m_vertex[14 + i * 12].m_data[1] = d13 * d;
                ((PgPointSet)this).m_vertex[14 + i * 12].m_data[2] = 0.0;
                ((PgPointSet)this).m_vertex[15 + i * 12].m_data[0] = d12 * d;
                ((PgPointSet)this).m_vertex[15 + i * 12].m_data[1] = d13 * d;
                ((PgPointSet)this).m_vertex[15 + i * 12].m_data[2] = d11;
                this.setElement(13 * i, i * 12 + 2, i * 12 + 3, i * 12 + 15, i * 12 + 14);
                this.setElement(1 + 13 * i, i * 12 + 4, i * 12 + 5, i * 12 + 9, i * 12 + 8);
                this.setElement(2 + 13 * i, i * 12 + 10, i * 12 + 8, i * 12 + 9, i * 12 + 11);
                this.setElement(3 + 13 * i, i * 12 + 10, i * 12 + 11, i * 12 + 7, i * 12 + 6);
                this.setElement(4 + 13 * i, i * 12 + 4, i * 12 + 6, i * 12 + 7, i * 12 + 5);
                this.setElement(5 + 13 * i, i * 12 + 1, i * 12 + 13, i * 12 + 9, i * 12 + 5);
                this.setElement(6 + 13 * i, i * 12 + 13, i * 12 + 15, i * 12 + 11, i * 12 + 9);
                this.setElement(7 + 13 * i, i * 12 + 15, i * 12 + 3, i * 12 + 7, i * 12 + 11);
                this.setElement(8 + 13 * i, i * 12 + 3, i * 12 + 1, i * 12 + 5, i * 12 + 7);
                this.setElement(9 + 13 * i, i * 12 + 0, i * 12 + 4, i * 12 + 8, i * 12 + 12);
                this.setElement(10 + 13 * i, i * 12 + 12, i * 12 + 8, i * 12 + 10, i * 12 + 14);
                this.setElement(11 + 13 * i, i * 12 + 14, i * 12 + 10, i * 12 + 6, i * 12 + 2);
                this.setElement(12 + 13 * i, i * 12 + 2, i * 12 + 6, i * 12 + 4, i * 12 + 0);
            }
            PiVector piVector = new PiVector(n);
            for (n5 = 0; n5 < n; ++n5) {
                piVector.m_data[n5] = n5 * 12;
            }
            this.setElement(n * 13, piVector);
            for (n5 = n - 1; n5 >= 0; --n5) {
                piVector.m_data[n - 1 - n5] = n5 * 12 + 1;
            }
            this.setElement(n * 13 + 1, piVector);
            this.makeNeighbour();
            PuCleanMesh.identifyVertices((PgPointSet)this, (double)1.0E-10);
        }
        this.makeElementNormals();
        this.makeVertexNormals();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

