/*
 * Decompiled with CFR 0.152.
 */
package jvx.surface;

import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jvx.geom.PnConjugate;
import jvx.surface.PgDomainDescr;

public class PgDomain
extends PgElementSet {
    public static final int DOMAIN_RECTANGULAR = 0;
    public static final int DOMAIN_POLAR = 1;
    protected PgDomainDescr m_descr;
    protected PgDomainDescr m_descrRect;
    protected PgDomainDescr m_descrPolar;
    protected int m_type;
    static /* synthetic */ Class class$jvx$surface$PgDomain;

    public PgDomain() {
        this(2);
    }

    public PgDomain(int n) {
        super(n);
        this.setTag(10);
        this.m_type = 0;
        this.setDimOfElements(4);
        this.setDescr(new PgDomainDescr(n));
        if (((Object)((Object)this)).getClass() == (class$jvx$surface$PgDomain == null ? (class$jvx$surface$PgDomain = PgDomain.class$("jvx.surface.PgDomain")) : class$jvx$surface$PgDomain)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        if (this.m_descrRect != null) {
            this.m_descrRect.init();
        }
        if (this.m_descrPolar != null) {
            this.m_descrPolar.init();
        }
        this.compute();
    }

    public Object clone() {
        PgDomain pgDomain = (PgDomain)((Object)super.clone());
        if (pgDomain == null) {
            return null;
        }
        if (this.m_descrRect != null) {
            pgDomain.setDescr((PgDomainDescr)((Object)this.m_descrRect.clone()), pgDomain.getType());
        }
        if (this.m_descrPolar != null) {
            pgDomain.setDescr((PgDomainDescr)((Object)this.m_descrPolar.clone()), pgDomain.getType());
        }
        return pgDomain;
    }

    public void copy(PsObject psObject) {
        super.copy(psObject);
        if (!(psObject instanceof PgDomain)) {
            return;
        }
        PgDomain pgDomain = (PgDomain)psObject;
        if (this.m_descrRect != null) {
            this.m_descrRect.copy(pgDomain.getDescr(0));
        } else if (this.m_descrPolar != null) {
            this.m_descrPolar.copy(pgDomain.getDescr(1));
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\n\t ******* PgDomain ***********\n");
        if (this.m_descr == null) {
            stringBuffer.append("\t m_descr    = null\n");
        } else {
            stringBuffer.append(this.m_descr.toString());
        }
        return stringBuffer.toString();
    }

    public boolean update(Object object) {
        if (object == this.m_descr) {
            this.compute();
            return super.update((Object)this);
        }
        return super.update(object);
    }

    public void computeSurface() {
        this.compute();
    }

    public void compute() {
        if (this.m_descr == null) {
            PsDebug.warning((String)"missing descriptor");
            return;
        }
        boolean bl = true;
        if (!this.isConforming()) {
            this.setConforming(true);
            bl = false;
        }
        int n = this.m_descr.getNumULines();
        int n2 = this.m_descr.getNumVLines();
        super.setNumVertices(n * n2);
        PdVector[] pdVectorArray = this.getVertices();
        int n3 = 0;
        double[] dArray = new double[2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.m_descr.eval(dArray, i, j);
                if (this.m_type == 1) {
                    pdVectorArray[n3].set(dArray[0] * Math.cos(dArray[1]), dArray[0] * Math.sin(dArray[1]));
                } else {
                    pdVectorArray[n3].set(dArray);
                }
                ++n3;
            }
        }
        super.makeQuadrConn(n, n2);
        super.makeQuadrBnd(n, n2);
        if (!bl) {
            PnConjugate.makeNonConforming(this);
        }
        super.makeVertexTextureFromBndBox(0, 1);
    }

    public int getDomainType() {
        return this.m_type;
    }

    public void setDomainType(int n) {
        if (this.m_type == n) {
            return;
        }
        if (n == 0) {
            if (this.m_descrRect == null && this.m_descr != null) {
                this.setDescr((PgDomainDescr)((Object)this.m_descr.clone()), 0);
            }
            this.m_descr = this.m_descrRect;
        } else if (n == 1) {
            if (this.m_descrPolar == null && this.m_descr != null) {
                this.setDescr((PgDomainDescr)((Object)this.m_descr.clone()), 1);
            }
            this.m_descr = this.m_descrPolar;
        } else {
            PsDebug.warning((String)("invalid type of domain descriptior, type = " + n));
            return;
        }
        this.m_type = n;
        if (this.m_descr == null) {
            this.setDescr(new PgDomainDescr(((PgGeometry)this).m_dim), this.m_type);
        }
    }

    public PgDomainDescr getDescr() {
        return this.m_descr;
    }

    public boolean setDescr(PgDomainDescr pgDomainDescr) {
        this.setDescr(pgDomainDescr, this.m_type);
        return true;
    }

    public PgDomainDescr getDescr(int n) {
        if (n == 0) {
            return this.m_descrRect;
        }
        if (n == 1) {
            return this.m_descrPolar;
        }
        PsDebug.warning((String)("invalid type of domain descriptior, type = " + n));
        return null;
    }

    public boolean setDescr(PgDomainDescr pgDomainDescr, int n) {
        if (n != 0 && n != 1) {
            PsDebug.warning((String)("invalid type of domain descriptior, type = " + n));
            return false;
        }
        if (n == 0) {
            if (this.m_descrRect != null) {
                this.m_descrRect.removeUpdateListener((PsUpdateIf)this);
            }
            this.m_descrRect = pgDomainDescr;
            this.m_descrRect.addUpdateListener((PsUpdateIf)this);
        } else if (n == 1) {
            if (this.m_descrPolar != null) {
                this.m_descrPolar.removeUpdateListener((PsUpdateIf)this);
            }
            this.m_descrPolar = pgDomainDescr;
            this.m_descrPolar.addUpdateListener((PsUpdateIf)this);
        }
        if (pgDomainDescr != null) {
            pgDomainDescr.addUpdateListener((PsUpdateIf)this);
        }
        if (this.m_type == n) {
            this.m_descr = pgDomainDescr;
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

