/*
 * Decompiled with CFR 0.152.
 */
package jvx.rsrc;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.objectGui.PsImage;

public final class JarResources {
    private static Hashtable m_hashImage;
    public boolean m_bDebugOn = false;
    private Hashtable m_htJarContents;
    private boolean m_bIsApplication;
    private String m_jarFileName;

    public JarResources(String string) {
        this(string, true);
    }

    public JarResources(String string, boolean bl) {
        this.m_jarFileName = string;
        this.m_bIsApplication = bl;
        this.m_htJarContents = new Hashtable();
        this.init();
    }

    public byte[] getResource(String string) {
        return (byte[])this.m_htJarContents.get(string);
    }

    private void init() {
        try {
            BufferedInputStream bufferedInputStream;
            Object object;
            if (this.m_bIsApplication) {
                object = new FileInputStream(this.m_jarFileName);
                bufferedInputStream = new BufferedInputStream((InputStream)object);
            } else {
                object = new URL(this.m_jarFileName);
                bufferedInputStream = new BufferedInputStream(((URL)object).openStream());
            }
            object = new ZipInputStream(bufferedInputStream);
            ZipEntry zipEntry = null;
            int n = ((FilterInputStream)object).available();
            if (this.m_bDebugOn) {
                System.out.println("available " + n);
            }
            if (n < 0) {
                return;
            }
            int n2 = 10000;
            int n3 = Math.min(n, n2);
            byte[] byArray = new byte[n3];
            while ((zipEntry = ((ZipInputStream)object).getNextEntry()) != null) {
                if (zipEntry.isDirectory()) continue;
                if (this.m_bDebugOn) {
                    System.out.println("ze.getName()=" + zipEntry.getName() + "," + "getSize()=" + zipEntry.getSize());
                }
                int n4 = 0;
                int n5 = 0;
                while (n - n4 > 0 && (n5 = ((ZipInputStream)object).read(byArray, n4, n3 - n4)) != -1) {
                    if ((n4 += n5) != n3) continue;
                    byte[] byArray2 = byArray;
                    byArray = new byte[n3 + n2];
                    System.arraycopy(byArray2, 0, byArray, 0, n3);
                    n3 += n2;
                }
                int n6 = n4;
                byte[] byArray3 = new byte[n6];
                System.arraycopy(byArray, 0, byArray3, 0, n6);
                this.m_htJarContents.put(zipEntry.getName(), byArray3);
                if (!this.m_bDebugOn) continue;
                System.out.println(zipEntry.getName() + "  rb=" + n4 + ",size=" + n6 + ",csize=" + zipEntry.getCompressedSize());
            }
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("done.");
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        JarResources jarResources;
        byte[] byArray;
        if (stringArray.length != 2) {
            System.err.println("usage: java JarResources <jar file name> <resource name>");
            System.exit(1);
        }
        if ((byArray = (jarResources = new JarResources(stringArray[0])).getResource(stringArray[1])) == null) {
            System.out.println("Could not find " + stringArray[1] + ".");
        } else {
            System.out.println("Found " + stringArray[1] + " (length=" + byArray.length + ").");
        }
    }

    public static PsImage getImageFromArchive(String string, String string2) {
        Image image = null;
        PsImage psImage = null;
        if (m_hashImage != null && (psImage = (PsImage)m_hashImage.get(string)) != null) {
            PsDebug.message((String)("Image taken from hashtable, image = " + string), (boolean)false);
            return psImage;
        }
        PsDebug.message((String)"Second attempt: reading Jar file directly", (boolean)false);
        try {
            JarResources jarResources = PsConfig.isApplication() ? new JarResources(string2) : new JarResources(PsConfig.getCodeBase() + string2, false);
            byte[] byArray = jarResources.getResource(string);
            if (byArray == null) {
                PsDebug.warning((String)("failed to create blob for image = " + string));
                return new PsImage(string);
            }
            image = Toolkit.getDefaultToolkit().createImage(byArray);
            psImage = new PsImage(image, "ColorPicker");
            if (!psImage.loadImage()) {
                PsDebug.warning((String)("failed to load image = " + string));
                return null;
            }
        }
        catch (Exception exception) {
            PsDebug.warning((String)("exception during loading of image = " + string));
            return null;
        }
        if (m_hashImage == null) {
            m_hashImage = new Hashtable();
        }
        m_hashImage.put(string, psImage);
        return psImage;
    }
}

