/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.numeric.PnBiconjugateGradient;
import jvx.numeric.PnStiffMatrix;

public class PnMassMatrix
extends PnStiffMatrix {
    protected boolean m_bLumped;
    protected PgElementSet m_geom;
    protected PnBiconjugateGradient m_solver;
    private PdVector[] m_store;
    static /* synthetic */ Class class$jvx$numeric$PnMassMatrix;

    public PnMassMatrix(PgElementSet pgElementSet) {
        this(pgElementSet, false);
    }

    public PnMassMatrix(PgElementSet pgElementSet, boolean bl) {
        super(pgElementSet);
        this.m_geom = pgElementSet;
        this.m_bLumped = bl;
        this.setSize(pgElementSet.getNumVertices());
        this.m_noe = pgElementSet.getNumElements();
        this.allocateArrays(pgElementSet, this.m_bLumped);
        if (((Object)((Object)this)).getClass() == (class$jvx$numeric$PnMassMatrix == null ? (class$jvx$numeric$PnMassMatrix = PnMassMatrix.class$("jvx.numeric.PnMassMatrix")) : class$jvx$numeric$PnMassMatrix)) {
            this.init();
        }
    }

    protected void allocateArrays(PgElementSet pgElementSet, boolean bl) {
        int n;
        PiVector[] piVectorArray = pgElementSet.getElements();
        PiVector[] piVectorArray2 = pgElementSet.getNeighbours();
        this.m_snoe.setConstant(0);
        if (!this.m_bLumped) {
            for (n = 0; n < this.m_noe; ++n) {
                int n2 = piVectorArray[n].getSize();
                for (int i = 0; i < n2; ++i) {
                    if (piVectorArray2[n].m_data[i] >= 0 && piVectorArray2[n].m_data[i] <= n) continue;
                    int n3 = piVectorArray[n].m_data[(i + 1) % n2];
                    this.m_snoe.m_data[n3] = this.m_snoe.m_data[n3] + 1;
                    int n4 = piVectorArray[n].m_data[(i + 2) % n2];
                    this.m_snoe.m_data[n4] = this.m_snoe.m_data[n4] + 1;
                }
            }
            for (n = 0; n < this.m_iSize; ++n) {
                if (this.m_snoe.m_data[n] <= 0) continue;
                int n5 = n;
                this.m_snoe.m_data[n5] = this.m_snoe.m_data[n5] + 1;
            }
        } else {
            n = 0;
            while (n < this.m_iSize) {
                int n6 = n++;
                this.m_snoe.m_data[n6] = this.m_snoe.m_data[n6] + 1;
            }
        }
        for (n = 0; n < this.m_iSize; ++n) {
            if (this.m_snoe.m_data[n] <= 0) continue;
            if (this.m_sindx[n] == null) {
                this.m_sindx[n] = new PiVector(this.m_snoe.m_data[n]);
            } else {
                this.m_sindx[n].setSize(this.m_snoe.m_data[n]);
            }
            if (this.m_stiff[n] == null) {
                this.m_stiff[n] = new PdVector(this.m_snoe.m_data[n]);
                continue;
            }
            this.m_stiff[n].setSize(this.m_snoe.m_data[n]);
        }
    }

    public void init(PgElementSet pgElementSet) {
        if (pgElementSet != this.m_geom) {
            PsDebug.warning((String)"given surface is not the surface of this matrix.");
            if (pgElementSet.getNumVertices() != this.m_iSize || pgElementSet.getNumElements() != this.m_noe) {
                return;
            }
        }
        this.init();
    }

    public void init() {
        int n;
        PgElementSet pgElementSet = this.m_geom;
        for (n = 0; n < this.m_iSize; ++n) {
            this.m_sindx[n].setConstant(-1);
            this.m_stiff[n].setConstant(0.0);
        }
        n = pgElementSet.getNumElements();
        PiVector[] piVectorArray = pgElementSet.getElements();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        if (!this.m_bLumped) {
            for (int i = 0; i < n; ++i) {
                int[] nArray = piVectorArray[i].m_data;
                double d = PdVector.area((PdVector)pdVectorArray[nArray[0]], (PdVector)pdVectorArray[nArray[1]], (PdVector)pdVectorArray[nArray[2]]);
                int n2 = this.getIndex(nArray[0], nArray[0]);
                this.m_stiff[nArray[0]].m_data[n2] = this.m_stiff[nArray[0]].m_data[n2] + d / 6.0;
                int n3 = this.getIndex(nArray[1], nArray[1]);
                this.m_stiff[nArray[1]].m_data[n3] = this.m_stiff[nArray[1]].m_data[n3] + d / 6.0;
                int n4 = this.getIndex(nArray[2], nArray[2]);
                this.m_stiff[nArray[2]].m_data[n4] = this.m_stiff[nArray[2]].m_data[n4] + d / 6.0;
                int n5 = this.getIndex(nArray[0], nArray[1]);
                this.m_stiff[nArray[0]].m_data[n5] = this.m_stiff[nArray[0]].m_data[n5] + d / 12.0;
                int n6 = this.getIndex(nArray[0], nArray[2]);
                this.m_stiff[nArray[0]].m_data[n6] = this.m_stiff[nArray[0]].m_data[n6] + d / 12.0;
                int n7 = this.getIndex(nArray[1], nArray[0]);
                this.m_stiff[nArray[1]].m_data[n7] = this.m_stiff[nArray[1]].m_data[n7] + d / 12.0;
                int n8 = this.getIndex(nArray[1], nArray[2]);
                this.m_stiff[nArray[1]].m_data[n8] = this.m_stiff[nArray[1]].m_data[n8] + d / 12.0;
                int n9 = this.getIndex(nArray[2], nArray[0]);
                this.m_stiff[nArray[2]].m_data[n9] = this.m_stiff[nArray[2]].m_data[n9] + d / 12.0;
                int n10 = this.getIndex(nArray[2], nArray[1]);
                this.m_stiff[nArray[2]].m_data[n10] = this.m_stiff[nArray[2]].m_data[n10] + d / 12.0;
            }
        } else {
            int n11;
            for (n11 = 0; n11 < n; ++n11) {
                int[] nArray = piVectorArray[n11].m_data;
                double d = PdVector.area((PdVector)pdVectorArray[nArray[0]], (PdVector)pdVectorArray[nArray[1]], (PdVector)pdVectorArray[nArray[2]]);
                int n12 = this.getIndex(nArray[0], nArray[0]);
                this.m_stiff[nArray[0]].m_data[n12] = this.m_stiff[nArray[0]].m_data[n12] + d;
                int n13 = this.getIndex(nArray[1], nArray[1]);
                this.m_stiff[nArray[1]].m_data[n13] = this.m_stiff[nArray[1]].m_data[n13] + d;
                int n14 = this.getIndex(nArray[2], nArray[2]);
                this.m_stiff[nArray[2]].m_data[n14] = this.m_stiff[nArray[2]].m_data[n14] + d;
            }
            for (n11 = 0; n11 < this.m_iSize; ++n11) {
                this.m_stiff[n11].m_data[0] = this.m_stiff[n11].m_data[0] / 3.0;
            }
        }
    }

    public void useLumpedMass(boolean bl) {
        if (this.m_bLumped == bl) {
            return;
        }
        this.m_bLumped = bl;
        this.allocateArrays(this.m_geom, this.m_bLumped);
        this.init();
    }

    public boolean isUsingLumpedMass() {
        return this.m_bLumped;
    }

    public PnBiconjugateGradient getSolver() {
        return this.m_solver;
    }

    public PdVector[] multInvMassMatrix(PdVector[] pdVectorArray) {
        if (pdVectorArray == null || pdVectorArray.length != this.m_iSize) {
            PsDebug.warning((String)"Cannot multiply with inverse mass matrix. Invalid size of given vector.");
            return pdVectorArray;
        }
        if (this.m_bLumped) {
            for (int i = 0; i < this.m_iSize; ++i) {
                if (this.m_snoe.m_data[i] == 0) continue;
                double d = this.m_stiff[i].m_data[this.getIndex(i, i)];
                if (d < 1.0E-10) {
                    PsDebug.warning((String)("Problems computing multiplication with inverse lumped mass matrix. Area of star of vertex " + i + " " + "is smaller then " + d + "."));
                    continue;
                }
                pdVectorArray[i].multScalar(1.0 / d);
            }
        } else {
            int n = pdVectorArray[0].m_data.length;
            if (this.m_store == null) {
                this.m_store = new PdVector[2];
            }
            if (this.m_store[0] == null) {
                this.m_store[0] = new PdVector(this.m_iSize);
            } else if (this.m_store[0].m_data.length != this.m_iSize) {
                this.m_store[0].setSize(this.m_iSize);
            }
            if (this.m_store[1] == null) {
                this.m_store[1] = new PdVector(this.m_iSize);
            } else if (this.m_store[1].m_data.length != this.m_iSize) {
                this.m_store[1].setSize(this.m_iSize);
            }
            if (this.m_solver == null) {
                this.m_solver = new PnBiconjugateGradient();
            }
            this.m_solver.setDimension(1);
            for (int i = 0; i < n; ++i) {
                int n2;
                for (n2 = 0; n2 < this.m_iSize; ++n2) {
                    this.m_store[1].m_data[n2] = pdVectorArray[n2].m_data[i];
                }
                double d = this.m_solver.solve(this, this.m_store[0], this.m_store[1]);
                if (d > 1.0E-10 || d < 0.0) {
                    PsDebug.warning((String)("Solving linear system to compute multiplication with inverse mass matrix produced an esimated error of " + d + ". " + "Mass matrix seems to have bad condition."));
                }
                for (n2 = 0; n2 < this.m_iSize; ++n2) {
                    pdVectorArray[n2].m_data[i] = this.m_store[0].m_data[n2];
                }
            }
        }
        return pdVectorArray;
    }

    public PdVector multInvMassMatrix(PdVector pdVector) {
        return this.multInvMassMatrix(pdVector, 1);
    }

    public PdVector multInvMassMatrix(PdVector pdVector, int n) {
        if (pdVector == null || pdVector.m_data.length != this.m_iSize * n) {
            PsDebug.warning((String)"Cannot multiply with inverse mass matrix. Invalid size of given vector.");
            return pdVector;
        }
        if (this.m_bLumped) {
            for (int i = 0; i < this.m_iSize; ++i) {
                if (this.m_snoe.m_data[i] == 0) continue;
                double d = this.m_stiff[i].m_data[this.getIndex(i, i)];
                if (d < 1.0E-10) {
                    PsDebug.warning((String)("Problems computing multiplication with inverse lumped mass matrix. Area of star of vertex " + i + " " + "is smaller then " + d + "."));
                    continue;
                }
                d = 1.0 / d;
                for (int j = 0; j < n; ++j) {
                    int n2 = n * i + j;
                    pdVector.m_data[n2] = pdVector.m_data[n2] * d;
                }
            }
        } else {
            if (this.m_store == null) {
                this.m_store = new PdVector[2];
            }
            if (this.m_store[0] == null) {
                this.m_store[0] = new PdVector(this.m_iSize * n);
            } else if (this.m_store[0].m_data.length != this.m_iSize * n) {
                this.m_store[0].setSize(this.m_iSize * n);
            }
            if (this.m_solver == null) {
                this.m_solver = new PnBiconjugateGradient();
            }
            this.m_solver.setDimension(n);
            int n3 = this.m_iSize * n;
            for (int i = 0; i < n3; ++i) {
                this.m_store[0].m_data[i] = pdVector.m_data[i];
            }
            double d = this.m_solver.solve(this, this.m_store[0], this.m_store[1]);
            if (d > 1.0E-10 || d < 0.0) {
                PsDebug.warning((String)("Solving linear system to compute multiplication with inverse mass matrix produced an esimated error of " + d + ". " + "Mass matrix seems to have bad condition."));
            }
        }
        return pdVector;
    }

    public static PdVector multInvMassMatrix(PgElementSet pgElementSet, PdVector pdVector, boolean bl) {
        int n;
        int n2 = pgElementSet.getNumVertices();
        if (pdVector.m_data.length != n2) {
            PsDebug.warning((String)"length of given vector does not match with the number of vertices of the given geometry.");
            return pdVector;
        }
        int n3 = pgElementSet.getNumElements();
        double[] dArray = new double[n2];
        PiVector[] piVectorArray = pgElementSet.getElements();
        for (n = 0; n < n3; ++n) {
            double d = pgElementSet.getAreaOfElement(n);
            for (int i = 0; i < piVectorArray[n].m_data.length; ++i) {
                int n4 = piVectorArray[n].m_data[i];
                dArray[n4] = dArray[n4] + d;
            }
        }
        for (n = 0; n < n2; ++n) {
            int n5 = n;
            pdVector.m_data[n5] = pdVector.m_data[n5] * (3.0 / dArray[n]);
        }
        return pdVector;
    }

    public static PdVector[] multInvMassMatrix(PgElementSet pgElementSet, PdVector[] pdVectorArray, boolean bl) {
        int n = pgElementSet.getNumVertices();
        if (pdVectorArray.length != n) {
            PsDebug.warning((String)"given array of vectors does not match with the number of vertices of the given geometry");
            return pdVectorArray;
        }
        if (bl) {
            int n2;
            int n3;
            int n4 = pgElementSet.getNumElements();
            double[] dArray = new double[n];
            PiVector[] piVectorArray = pgElementSet.getElements();
            for (n3 = 0; n3 < n4; ++n3) {
                double d = pgElementSet.getAreaOfElement(n3);
                for (n2 = 0; n2 < piVectorArray[n3].m_data.length; ++n2) {
                    int n5 = piVectorArray[n3].m_data[n2];
                    dArray[n5] = dArray[n5] + d;
                }
            }
            double d = 0.0;
            for (n3 = 0; n3 < n; ++n3) {
                d = 3.0 / dArray[n3];
                n2 = 0;
                while (n2 < pdVectorArray[n3].m_data.length) {
                    int n6 = n2++;
                    pdVectorArray[n3].m_data[n6] = pdVectorArray[n3].m_data[n6] * d;
                }
            }
        } else {
            PnMassMatrix pnMassMatrix = new PnMassMatrix(pgElementSet);
            pdVectorArray = pnMassMatrix.multInvMassMatrix(pdVectorArray);
        }
        return pdVectorArray;
    }

    public static PdMatrix[] multInvMassMatrix(PgElementSet pgElementSet, PdMatrix[] pdMatrixArray, boolean bl) {
        int n;
        int n2 = pgElementSet.getNumVertices();
        if (pdMatrixArray.length != n2) {
            PsDebug.warning((String)"given array of matrices does not match with the number of vertices of the given geometry");
            return pdMatrixArray;
        }
        int n3 = pgElementSet.getNumElements();
        double[] dArray = new double[n2];
        PiVector[] piVectorArray = pgElementSet.getElements();
        for (n = 0; n < n3; ++n) {
            double d = pgElementSet.getAreaOfElement(n);
            for (int i = 0; i < piVectorArray[n].m_data.length; ++i) {
                int n4 = piVectorArray[n].m_data[i];
                dArray[n4] = dArray[n4] + d;
            }
        }
        for (n = 0; n < n2; ++n) {
            pdMatrixArray[n].multScalar(3.0 / dArray[n]);
        }
        return pdMatrixArray;
    }

    public static PdVector getInvLumpedMassMatrix(PgElementSet pgElementSet, PdVector pdVector) {
        int n;
        int n2 = pgElementSet.getNumElements();
        int n3 = pgElementSet.getNumVertices();
        if (pdVector == null) {
            pdVector = new PdVector(n3);
        } else if (pdVector.m_data.length != n3) {
            pdVector.setSize(n3);
        }
        pdVector.setConstant(0.0);
        double[] dArray = pdVector.m_data;
        PiVector[] piVectorArray = pgElementSet.getElements();
        for (n = 0; n < n2; ++n) {
            double d = pgElementSet.getAreaOfElement(n);
            for (int i = 0; i < piVectorArray[n].m_data.length; ++i) {
                int n4 = piVectorArray[n].m_data[i];
                dArray[n4] = dArray[n4] + d;
            }
        }
        for (n = 0; n < n3; ++n) {
            dArray[n] = 3.0 / dArray[n];
        }
        return pdVector;
    }

    public static PdVector getLumpedMassMatrix(PgElementSet pgElementSet, PdVector pdVector) {
        int n;
        int n2 = pgElementSet.getNumElements();
        int n3 = pgElementSet.getNumVertices();
        if (pdVector == null) {
            pdVector = new PdVector(n3);
        } else if (pdVector.m_data.length != n3) {
            pdVector.setSize(n3);
        }
        pdVector.setConstant(0.0);
        double[] dArray = pdVector.m_data;
        PiVector[] piVectorArray = pgElementSet.getElements();
        for (n = 0; n < n2; ++n) {
            double d = pgElementSet.getAreaOfElement(n);
            for (int i = 0; i < piVectorArray[n].m_data.length; ++i) {
                int n4 = piVectorArray[n].m_data[i];
                dArray[n4] = dArray[n4] + d;
            }
        }
        double d = 0.3333333333333333;
        n = 0;
        while (n < n3) {
            int n5 = n++;
            dArray[n5] = dArray[n5] * d;
        }
        return pdVector;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

