/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jvx.numeric.PnPreconditioner;
import jvx.numeric.PnSparseMatrix;

public class PnConjugateGradientMatrix {
    protected PdVector m_p = new PdVector();
    protected PdVector m_q = new PdVector();
    protected PdVector m_r = new PdVector();
    protected int m_size;
    protected int m_iter;
    protected double m_err;
    protected int m_itol = 1;
    protected int m_itmax = 10000;
    protected double m_tol = 1.0E-10;
    protected int m_dim = 1;
    protected PnPreconditioner m_prec;

    public boolean converged() {
        this.m_err = this.getResidualNorm();
        return this.m_err < this.m_tol;
    }

    public void setPreconditioner(PnPreconditioner pnPreconditioner) {
        this.m_prec = pnPreconditioner;
    }

    public PnPreconditioner getPreconditioner() {
        return this.m_prec;
    }

    public double getActualEstimatedError() {
        return this.m_err;
    }

    public int getActualNumOfTakenIterations() {
        return this.m_iter;
    }

    public void setMaxNumIterations(int n) {
        this.m_itmax = n;
    }

    public int getMaxNumIterations() {
        return this.m_itmax;
    }

    public void setTolerance(double d) {
        this.m_tol = d;
    }

    public double getTolerance() {
        return this.m_tol;
    }

    public void setDimension(int n) {
        this.m_dim = n;
    }

    public int getDimension() {
        return this.m_dim;
    }

    public void setConvergenceTest(int n) {
        if (n > 4 || n < 1) {
            PsDebug.warning((String)"Cannot set convergence test method, desired method is unknown.");
            return;
        }
        this.m_itol = n;
    }

    public double getConvergenceTest() {
        return this.m_itol;
    }

    protected void setSize(int n) {
        this.m_size = n;
        this.m_p.setSize(n * this.m_dim);
        this.m_q.setSize(n * this.m_dim);
        this.m_r.setSize(n * this.m_dim);
    }

    public void updatePreconditioner(PnSparseMatrix pnSparseMatrix) {
        if (pnSparseMatrix == null) {
            PsDebug.warning((String)"Sparse matrix is null");
            return;
        }
        if (this.m_prec != null) {
            this.m_prec.setSparseMatrix(pnSparseMatrix);
        } else {
            this.m_prec = new PnPreconditioner();
        }
    }

    public double solve(PnSparseMatrix pnSparseMatrix, PdVector pdVector, PdVector pdVector2) {
        double d = 0.0;
        if (pnSparseMatrix == null || pdVector == null || pdVector2 == null) {
            PsDebug.warning((String)"One of the arguments is null");
            return -1.0;
        }
        if (!pnSparseMatrix.isSquare()) {
            PsDebug.warning((String)"Matrix is not square.");
            return -1.0;
        }
        int n = this.m_dim * pnSparseMatrix.m_iSize;
        if (pdVector.getSize() != n) {
            pdVector.setSize(n);
        }
        if (pdVector2.getSize() != n) {
            PsDebug.warning((String)"Dimension of b and smat does not match");
            return -1.0;
        }
        if (this.m_size != pnSparseMatrix.m_iSize) {
            this.setSize(pnSparseMatrix.m_iSize);
        }
        if (this.m_prec == null) {
            this.m_prec = new PnPreconditioner();
        }
        PnSparseMatrix.rightMultVector(pnSparseMatrix, pdVector, this.m_r, this.m_dim);
        this.m_r.sub(pdVector2, this.m_r);
        this.m_iter = 0;
        while (this.getResidualNorm() > this.m_tol && this.m_iter < this.m_itmax) {
            int n2;
            double d2;
            this.m_prec.apply(this.m_r, this.m_q, this.m_dim);
            double d3 = this.m_r.dot(this.m_q);
            if (this.m_iter == 0) {
                this.m_p.copyArray(this.m_q);
            } else {
                d2 = d3 / d;
                for (n2 = 0; n2 < n; ++n2) {
                    this.m_p.m_data[n2] = d2 * this.m_p.m_data[n2] + this.m_q.m_data[n2];
                }
            }
            if (this.m_dim == 1) {
                for (int i = 0; i < this.m_size; ++i) {
                    double d4 = 0.0;
                    int n3 = pnSparseMatrix.m_snoe.m_data[i];
                    for (int j = 0; j < n3; ++j) {
                        d4 += pnSparseMatrix.m_stiff[i].m_data[j] * this.m_p.m_data[pnSparseMatrix.m_sindx[i].m_data[j]];
                    }
                    this.m_q.m_data[i] = d4;
                }
            } else {
                PnSparseMatrix.rightMultVector(pnSparseMatrix, this.m_p, this.m_q, this.m_dim);
            }
            d2 = d3 / this.m_p.dot(this.m_q);
            for (n2 = 0; n2 < n; ++n2) {
                int n4 = n2;
                pdVector.m_data[n4] = pdVector.m_data[n4] + d2 * this.m_p.m_data[n2];
                int n5 = n2;
                this.m_r.m_data[n5] = this.m_r.m_data[n5] - d2 * this.m_q.m_data[n2];
            }
            d = d3;
            ++this.m_iter;
        }
        this.m_err = this.getResidualNorm();
        if (this.m_iter == this.m_itmax) {
            PsDebug.warning((String)("Aborted after " + this.m_itmax + " iterations."));
        }
        return this.m_err;
    }

    protected double getResidualNorm() {
        if (this.m_itol <= 3) {
            return this.m_r.length();
        }
        return this.m_r.maxAbs();
    }
}

