/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgElementSet;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;
import jvx.numeric.PnDiriEnergy;

public class PnAreaVolEnergy
extends PnDiriEnergy {
    protected int m_noe;
    protected PdVector m_origin;
    protected PdVector m_normal;
    protected PdVector[] m_v;
    protected PuDouble m_meanCurvature = new PuDouble(PsConfig.getMessage((int)54013), (PsUpdateIf)this);
    static /* synthetic */ Class class$jvx$numeric$PnAreaVolEnergy;

    public PnAreaVolEnergy() {
        if (((Object)((Object)this)).getClass() == (class$jvx$numeric$PnAreaVolEnergy == null ? (class$jvx$numeric$PnAreaVolEnergy = PnAreaVolEnergy.class$("jvx.numeric.PnAreaVolEnergy")) : class$jvx$numeric$PnAreaVolEnergy)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_meanCurvature.setDefBounds(-10.0, 10.0, 0.01, 0.1);
        this.m_meanCurvature.setDefValue(0.0);
        this.m_meanCurvature.init();
        this.m_v = null;
    }

    public boolean setSurface(PgElementSet pgElementSet, PgElementSet pgElementSet2) {
        if (pgElementSet2 == null) {
            PsDebug.warning((String)"missing surface geometry.");
            return false;
        }
        if (!super.setSurface(pgElementSet, pgElementSet2)) {
            return false;
        }
        if (this.m_surface.getDimOfElements() != 3) {
            PsDebug.warning((String)("surface=" + this.m_surface.getName() + " not triangulated"));
            PgElementSet.triangulate((PgElementSet)this.m_surface);
        }
        this.m_v = PdVector.realloc((PdVector[])this.m_v, (int)3, (int)this.m_dim);
        this.m_noe = this.m_surface.getNumElements();
        this.m_normal = new PdVector(this.m_dim);
        this.m_origin = new PdVector(this.m_dim);
        this.m_origin.setConstant(0.0);
        return true;
    }

    public boolean update(Object object) {
        if (this.m_meanCurvature == object) {
            if (this.m_surface != null) {
                this.m_surface.update(null);
            }
            return true;
        }
        return super.update(object);
    }

    public double eval(PdVector pdVector) {
        if (this.m_stiffMatrix == null) {
            PsDebug.warning((String)"missing m_stiffMatrix, call setSurface before.");
            return 0.0;
        }
        double d = super.eval(pdVector);
        PiVector[] piVectorArray = this.m_surface.getElements();
        int n = 0;
        double d2 = 0.0;
        for (int i = 0; i < this.m_noe; ++i) {
            for (int j = 0; j < 3; ++j) {
                n = this.m_dim * piVectorArray[i].getEntry(j);
                for (int k = 0; k < this.m_dim; ++k) {
                    this.m_v[j].m_data[k] = pdVector.m_data[n++];
                }
            }
            this.m_normal.normalOfPlane(this.m_v[0], this.m_v[1], this.m_v[2]);
            double d3 = -PuVectorGeom.distOfPointToPlane((PdVector)this.m_origin, (PdVector)this.m_v[0], (PdVector)this.m_normal);
            double d4 = PdVector.area((PdVector[])this.m_v);
            d2 += d4 * d3 / 3.0;
        }
        return d + 2.0 * this.m_meanCurvature.getValue() * d2;
    }

    public PdVector evalGradient(PdVector pdVector, PdVector pdVector2) {
        if (pdVector == null) {
            PsDebug.warning((String)"Missing coordinate array.");
            return null;
        }
        if ((pdVector2 = super.evalGradient(pdVector, pdVector2)) == null) {
            return null;
        }
        PiVector[] piVectorArray = this.m_surface.getElements();
        int n = 0;
        double d = 2.0 * this.m_meanCurvature.getValue() / 3.0;
        for (int i = 0; i < this.m_noe; ++i) {
            for (int j = 0; j < 3; ++j) {
                n = this.m_dim * piVectorArray[i].getEntry(j);
                for (int k = 0; k < this.m_dim; ++k) {
                    this.m_v[j].m_data[k] = pdVector.m_data[n++];
                }
            }
            this.m_normal.normalOfPlane(this.m_v[0], this.m_v[1], this.m_v[2]);
            double d2 = d * PdVector.area((PdVector[])this.m_v);
            for (int j = 0; j < 3; ++j) {
                n = this.m_dim * piVectorArray[i].getEntry(j);
                for (int k = 0; k < this.m_dim; ++k) {
                    int n2 = n++;
                    pdVector2.m_data[n2] = pdVector2.m_data[n2] + d2 * this.m_normal.m_data[k];
                }
            }
        }
        return this.constrainGradient(pdVector, pdVector2);
    }

    public PdMatrix evalHessian(PdMatrix pdMatrix) {
        if (pdMatrix == null) {
            pdMatrix = new PdMatrix();
        }
        int n = this.m_index.length;
        pdMatrix.setSize(this.m_dim * n);
        pdMatrix.setConstant(0.0);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this.m_stiffMatrix.m_snoe.m_data[this.m_index[i]]; ++j) {
                int n2 = this.m_invIndex[this.m_stiffMatrix.m_sindx[this.m_index[i]].m_data[j]];
                if (n2 == -1) continue;
                if (i != 0 || n2 == 0) {
                    // empty if block
                }
                for (int k = 0; k < this.m_dim; ++k) {
                    pdMatrix.m_data[i * this.m_dim + k][n2 * this.m_dim + k] = this.m_stiffMatrix.m_stiff[this.m_index[i]].m_data[j];
                }
            }
        }
        return pdMatrix;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

