/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.awt.Color;
import java.awt.TextComponent;
import jv.geom.PgBndPolygon;
import jv.geom.PgEdgeStar;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.number.PdColor;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PwSimplify_IP;
import jvx.project.PjWorkshop;

public class PwSimplify
extends PjWorkshop {
    protected PgElementSet m_elementSet;
    protected PwSimplify_IP m_infoPanel;
    private PiVector[] m_edgeList;
    private PiVector m_index;
    private PiVector m_location;
    private boolean[] m_isDenied;
    private int m_maxIndex;
    private int m_lastNode;
    private PdVector[] m_minVector;
    private PdVector m_minValue;
    private int m_numEdges;
    protected int m_numEl;
    private PdMatrix[] m_quadMatrix;
    private PdVector[] m_quadVector;
    private PdVector m_quadScalar;
    private PiVector[] m_edgesAtVertex;
    private PiVector[] m_edgesAtVertex2;
    private PiVector[] m_elementsAtVertex;
    private boolean m_bKeepBoundary;
    private boolean m_bKeepMarkedVertices;
    private double m_minInOut;
    private boolean m_bCheckAngles;
    private boolean m_bCheckNormals;
    private boolean m_bForceSimplify;
    private boolean m_bFlipEdges;
    private double m_maxAngle;
    private boolean m_bBigNeighbourhood;
    private boolean m_bShowNumTriangles = false;
    private PdVector[] m_vertex;
    private PiVector[] m_element;
    private PiVector[] m_neighbour;
    private PdVector[] m_elementNormal;
    private int m_numVF;
    private PgVectorField[] m_vectorField;
    private boolean m_hasVertexNormals;
    private boolean m_hasElementNormals;
    private boolean m_hasVertexTextures;
    private PdVector[] m_vertexTexture;
    private boolean m_hasElementTextures;
    private PdVector[][] m_elementTexture;
    private boolean m_hasVertexColors;
    private Color[] m_vertexColor;
    private int m_dimOfVertices;
    private int m_dimOfVectors;
    private int m_dimOfElements;
    private boolean m_hasBoundary;
    private int m_numBnd;
    private PiVector[] m_bndList;
    private int m_edgeNr;
    private int[] m_vertexIndex = new int[3];
    private double[] dLoc = new double[4];
    private int ii;
    private int jj;
    private int kk;
    private int ll;
    private int mm;
    private int[] size = new int[7];
    private int[] count = new int[3];
    private int[] m_index2 = new int[9];
    private boolean ceRemoveBnd;
    private boolean ceDd;
    private PiVector ceBndInd;
    private PiVector ceElement;
    private PiVector cnElNr = new PiVector();
    private PiVector cnOldElement;
    private PdVector cnNormal = new PdVector(0.0, 0.0, 1.0);
    private PdVector cnNor;
    private PdVector cnVertexA;
    private PdVector cnVertexB;
    private PdVector cnVertexC;
    private PdVector cnEdgeB;
    private PdVector cnEdgeC;
    private PiVector cneElement;
    private PiVector reElement;
    private PiVector reNeighbour;
    private boolean reDoubleEdge;
    private boolean reEdgeIsSaved;
    private PdMatrix cmA = new PdMatrix(3);
    private PdMatrix cmQ = new PdMatrix(3);
    private PdVector cmV = new PdVector(3);
    private PdVector cmQx = new PdVector(3);
    protected PuInteger m_targetNumber;
    public static final int PERCENT_SLIDER = 0;
    public static final int ABSOLUTE_SLIDER = 1;
    public int m_sliderType = 1;
    private int m_percentSliderValue = 80;
    private int m_absoluteSliderValue = 0;
    private PgPointSet m_labelGeom = null;
    public boolean m_bGenerateVertexMap = false;
    public PiVector m_vertexMap = new PiVector();
    public boolean m_bPrioritiseByEdgeLength = false;
    private int heapJ;
    private int heapK;
    private int heapN;
    static /* synthetic */ Class class$jvx$geom$PwSimplify;

    public PwSimplify(PgElementSet pgElementSet) {
        this();
        this.m_elementSet = pgElementSet;
    }

    public PwSimplify() {
        super(PsConfig.getMessage((int)48013));
        this.m_targetNumber = new PuInteger(PsConfig.getMessage((boolean)true, (int)54000, (String)"Target #Faces"), (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PwSimplify == null ? (class$jvx$geom$PwSimplify = PwSimplify.class$("jvx.geom.PwSimplify")) : class$jvx$geom$PwSimplify)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_bKeepBoundary = false;
        this.m_bKeepMarkedVertices = true;
        this.m_bCheckNormals = true;
        this.m_bForceSimplify = true;
        this.m_bCheckAngles = false;
        this.m_bFlipEdges = false;
        this.updateSlider();
    }

    public void setGeometry(PgElementSet pgElementSet) {
        super.setGeometry((PgGeometry)pgElementSet);
        this.m_elementSet = pgElementSet;
        this.m_bCheckNormals = this.m_elementSet.getDimOfVertices() == 3;
        this.updateSlider();
    }

    public void updateSlider() {
        if (this.m_elementSet != null) {
            int n = this.m_elementSet.getNumElements();
            this.m_absoluteSliderValue = n * this.m_percentSliderValue / 100;
            if (this.m_sliderType == 1) {
                this.m_targetNumber.setDefBounds(2, n, 1, n / 10);
                this.m_targetNumber.setDefValue(this.m_absoluteSliderValue);
            } else {
                this.m_targetNumber.setDefBounds(1, 100, 1, 10);
                this.m_targetNumber.setDefValue(this.m_percentSliderValue);
            }
            this.m_targetNumber.init();
        }
    }

    public void setSliderType(int n) {
        if (this.m_sliderType == n) {
            return;
        }
        if (n == 1) {
            this.m_sliderType = n;
            int n2 = this.m_elementSet.getNumElements();
            this.m_targetNumber.setDefBounds(2, n2, 1, n2 / 10);
            this.m_targetNumber.setDefValue(this.m_absoluteSliderValue);
            this.m_targetNumber.init();
        }
        if (n == 0) {
            this.m_sliderType = n;
            this.m_targetNumber.setDefBounds(1, 100, 1, 10);
            this.m_targetNumber.setDefValue(this.m_percentSliderValue);
            this.m_targetNumber.init();
        }
    }

    public void reset() {
        super.reset();
        if (this.m_geom == null) {
            return;
        }
        this.m_geom.copy((PsObject)this.m_geomSave);
        this.updateSlider();
    }

    public void close() {
        this.m_elementSet = null;
        this.setDisplay(null);
        super.close();
    }

    protected boolean prepare() {
        int n;
        int n2;
        if (this.m_elementSet == null) {
            return false;
        }
        this.m_numEl = this.m_elementSet.getNumElements();
        if (this.m_numEl == 0) {
            return false;
        }
        if (this.m_elementSet.getNeighbours() == null) {
            this.m_elementSet.makeNeighbour();
        }
        this.m_vertex = this.m_elementSet.getVertices();
        this.m_element = this.m_elementSet.getElements();
        this.m_neighbour = this.m_elementSet.getNeighbours();
        this.m_numVF = this.m_elementSet.getNumVectorFields();
        if (this.m_numVF > 0) {
            this.m_vectorField = new PgVectorField[this.m_numVF];
            for (n2 = 0; n2 < this.m_numVF; ++n2) {
                this.m_vectorField[n2] = this.m_elementSet.getVectorField(n2);
            }
        }
        this.m_hasVertexTextures = this.m_elementSet.hasVertexTextures();
        if (this.m_hasVertexTextures) {
            this.m_vertexTexture = this.m_elementSet.getVertexTextures();
        }
        this.m_hasElementTextures = this.m_elementSet.hasElementTextures();
        if (this.m_hasElementTextures) {
            this.m_elementTexture = this.m_elementSet.getElementTextures();
        }
        this.m_hasVertexColors = this.m_elementSet.hasVertexColors();
        if (this.m_hasVertexColors) {
            this.m_vertexColor = this.m_elementSet.getVertexColors();
        }
        this.m_hasVertexNormals = this.m_elementSet.hasVertexNormals();
        this.m_hasElementNormals = this.m_elementSet.hasElementNormals();
        if (!this.m_hasElementNormals) {
            this.m_elementSet.makeElementNormals();
        }
        this.m_elementNormal = this.m_elementSet.getElementNormals();
        if (!this.m_hasElementNormals) {
            this.m_elementSet.removeElementNormals();
        }
        this.m_dimOfVertices = this.m_elementSet.getDimOfVertices();
        this.m_dimOfVectors = this.m_elementSet.getDimOfVectors();
        this.m_dimOfElements = this.m_elementSet.getDimOfElements();
        this.m_hasBoundary = this.m_elementSet.hasBoundary();
        this.m_numBnd = this.m_elementSet.getNumBoundaries();
        if (this.m_hasBoundary) {
            this.m_bndList = new PiVector[this.m_numBnd];
            PgBndPolygon[] pgBndPolygonArray = this.m_elementSet.getBoundaries();
            for (n2 = 0; n2 < this.m_numBnd; ++n2) {
                this.m_bndList[n2] = PiVector.copyNew((PiVector)pgBndPolygonArray[n2].getVertexInd());
                this.m_bndList[n2].setSize(pgBndPolygonArray[n2].getNumVertices());
                if (!pgBndPolygonArray[n2].hasTag(2)) continue;
                this.m_bndList[n2].setTag(2);
            }
        }
        int n3 = this.m_elementSet.getNumVertices();
        this.cnNor = new PdVector(this.m_dimOfVectors);
        this.cnEdgeB = new PdVector(this.m_dimOfVertices);
        this.cnEdgeC = new PdVector(this.m_dimOfVertices);
        this.m_maxAngle = 15.0;
        PgEdgeStar[] pgEdgeStarArray = this.m_elementSet.makeEdgeStars();
        this.m_numEdges = pgEdgeStarArray.length;
        this.m_edgeList = PiVector.realloc((PiVector[])this.m_edgeList, (int)2, (int)this.m_numEdges);
        this.m_minVector = new PdVector[this.m_numEdges];
        this.m_minValue = new PdVector(this.m_numEdges);
        this.m_isDenied = new boolean[this.m_numEdges];
        this.m_quadMatrix = new PdMatrix[n3];
        this.m_quadVector = new PdVector[n3];
        this.m_quadScalar = new PdVector(n3);
        this.m_edgesAtVertex = new PiVector[n3];
        PiVector.realloc((PiVector[])this.m_edgesAtVertex, (int)n3, (int)6);
        PiVector piVector = new PiVector(n3);
        piVector.setConstant(0);
        n2 = 0;
        while (n2 < this.m_numEdges) {
            this.m_isDenied[n2] = false;
            PgEdgeStar pgEdgeStar = pgEdgeStarArray[n2];
            int n4 = pgEdgeStar.getVertexInd(0);
            int n5 = pgEdgeStar.getVertexInd(1);
            this.m_edgeList[0].m_data[n2] = n4;
            this.m_edgeList[1].m_data[n2] = n5;
            n = this.m_edgesAtVertex[n4].getSize();
            if (piVector.m_data[n4] == n) {
                this.m_edgesAtVertex[n4].setSize(2 * n);
            }
            int n6 = n4;
            int n7 = piVector.m_data[n6];
            piVector.m_data[n6] = n7 + 1;
            this.m_edgesAtVertex[n4].m_data[n7] = n2;
            n = this.m_edgesAtVertex[n5].getSize();
            if (piVector.m_data[n5] == n) {
                this.m_edgesAtVertex[n5].setSize(2 * n);
            }
            int n8 = n5;
            int n9 = piVector.m_data[n8];
            piVector.m_data[n8] = n9 + 1;
            this.m_edgesAtVertex[n5].m_data[n9] = n2++;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            this.m_edgesAtVertex[n2].setSize(piVector.m_data[n2]);
        }
        this.m_elementsAtVertex = new PiVector[n3];
        PiVector.realloc((PiVector[])this.m_elementsAtVertex, (int)n3, (int)6);
        piVector.setConstant(0);
        for (n2 = 0; n2 < this.m_numEl; ++n2) {
            int n10 = this.m_element[n2].getSize();
            for (int i = 0; i < n10; ++i) {
                int n11 = this.m_element[n2].m_data[i];
                n = this.m_elementsAtVertex[n11].getSize();
                if (piVector.m_data[n11] == n) {
                    this.m_elementsAtVertex[n11].setSize(2 * n);
                }
                int n12 = n11;
                int n13 = piVector.m_data[n12];
                piVector.m_data[n12] = n13 + 1;
                this.m_elementsAtVertex[n11].m_data[n13] = n2;
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            this.m_elementsAtVertex[n2].setSize(piVector.m_data[n2]);
        }
        if (this.m_bBigNeighbourhood) {
            this.generateEdgesAtVertex2();
        }
        this.m_elementSet.markBoundary();
        if (this.m_dimOfVertices == 3) {
            this.m_quadMatrix = PdMatrix.realloc(null, (int)n3, (int)3, (int)3);
            PdVector.realloc((PdVector[])this.m_quadVector, (int)n3, (int)3);
            for (n2 = 0; n2 < n3; ++n2) {
                this.computeQuadric(n2);
            }
        }
        PdVector.realloc((PdVector[])this.m_minVector, (int)this.m_numEdges, (int)this.m_dimOfVertices);
        for (n2 = 0; n2 < this.m_numEdges; ++n2) {
            this.computeMinimum(n2);
        }
        this.m_index = new PiVector(this.m_numEdges + 1);
        this.m_location = new PiVector(this.m_numEdges);
        this.m_maxIndex = this.m_numEdges - 1;
        this.m_lastNode = (this.m_maxIndex - 1) / 2;
        for (n2 = 0; n2 < this.m_numEdges; ++n2) {
            this.m_index.m_data[n2] = n2;
            this.m_location.m_data[n2] = n2;
        }
        this.m_index.m_data[this.m_maxIndex + 1] = -1;
        for (n2 = this.m_lastNode; n2 > -1; --n2) {
            this.checkRelation(n2);
        }
        this.m_minInOut = 2.0;
        if (this.m_bCheckAngles) {
            this.computeMinInOut();
        }
        return true;
    }

    private void computeMinInOut() {
        if (this.m_dimOfElements != 3) {
            return;
        }
        for (int i = 0; i < this.m_numEl; ++i) {
            this.dLoc[0] = PdVector.dist((PdVector)this.m_vertex[this.m_element[i].m_data[0]], (PdVector)this.m_vertex[this.m_element[i].m_data[1]]);
            this.dLoc[1] = PdVector.dist((PdVector)this.m_vertex[this.m_element[i].m_data[0]], (PdVector)this.m_vertex[this.m_element[i].m_data[2]]);
            this.dLoc[2] = PdVector.dist((PdVector)this.m_vertex[this.m_element[i].m_data[1]], (PdVector)this.m_vertex[this.m_element[i].m_data[2]]);
            if (this.dLoc[0] > 1.0E-10 && this.dLoc[1] > 1.0E-10 && this.dLoc[2] > 1.0E-10) {
                this.dLoc[3] = this.dLoc[0] > this.dLoc[1] && this.dLoc[0] > this.dLoc[2] ? (this.dLoc[1] + this.dLoc[2] - this.dLoc[0]) / this.dLoc[0] : (this.dLoc[1] > this.dLoc[2] ? (this.dLoc[0] + this.dLoc[2] - this.dLoc[1]) / this.dLoc[1] : (this.dLoc[0] + this.dLoc[1] - this.dLoc[2]) / this.dLoc[2]);
                if (!(this.dLoc[3] < this.m_minInOut)) continue;
                this.m_minInOut = this.dLoc[3];
                continue;
            }
            this.m_minInOut = 0.0;
        }
    }

    private void generateEdgesAtVertex2() {
        int n;
        int n2 = this.m_elementSet.getNumVertices();
        this.m_edgesAtVertex2 = new PiVector[n2];
        PiVector.realloc((PiVector[])this.m_edgesAtVertex2, (int)n2, (int)6);
        PiVector piVector = new PiVector(n2);
        piVector.setConstant(0);
        int n3 = -1;
        int n4 = this.m_edgeList[0].getSize();
        int[] nArray = new int[2];
        for (n = 0; n < n4; ++n) {
            int n5;
            for (n5 = 0; n5 < 2; ++n5) {
                nArray[n5] = this.m_edgeList[n5].m_data[n];
            }
            for (int i = 0; i < 2; ++i) {
                int n6 = this.m_elementsAtVertex[nArray[i]].getSize();
                for (n5 = 0; n5 < n6; ++n5) {
                    int n7 = this.m_element[this.m_elementsAtVertex[nArray[i]].m_data[n5]].getSize();
                    for (int j = 0; j < n7; ++j) {
                        n3 = this.m_element[this.m_elementsAtVertex[nArray[i]].m_data[n5]].m_data[j];
                        int n8 = this.m_edgesAtVertex2[n3].getSize();
                        boolean bl = false;
                        for (int k = 0; k < piVector.m_data[n3]; ++k) {
                            if (this.m_edgesAtVertex2[n3].m_data[k] != n) continue;
                            bl = true;
                            break;
                        }
                        if (bl) continue;
                        if (piVector.m_data[n3] == n8) {
                            this.m_edgesAtVertex2[n3].setSize(2 * n8);
                        }
                        int n9 = n3;
                        int n10 = piVector.m_data[n9];
                        piVector.m_data[n9] = n10 + 1;
                        this.m_edgesAtVertex2[n3].m_data[n10] = n;
                    }
                }
            }
        }
        for (n = 0; n < n2; ++n) {
            this.m_edgesAtVertex2[n].setSize(piVector.m_data[n]);
        }
    }

    public boolean isEnabledKeepBoundary() {
        return this.m_bKeepBoundary;
    }

    public void setEnabledKeepBoundary(boolean bl) {
        this.m_bKeepBoundary = bl;
    }

    public boolean isEnabledKeepMarkedVertices() {
        return this.m_bKeepMarkedVertices;
    }

    public void setEnabledKeepMarkedVertices(boolean bl) {
        this.m_bKeepMarkedVertices = bl;
    }

    public boolean isEnabledCheckNormals() {
        return this.m_bCheckNormals;
    }

    public void setEnabledCheckNormals(boolean bl) {
        if (this.m_elementSet.getDimOfVertices() != 3) {
            PsDebug.warning((String)"normals are disabled if dimOfVertices!=3.");
            this.m_bCheckNormals = false;
        }
        this.m_bCheckNormals = bl;
    }

    public boolean isEnabledForceSimplify() {
        return this.m_bForceSimplify;
    }

    public void setEnabledForceSimplify(boolean bl) {
        this.m_bForceSimplify = bl;
    }

    public boolean isEnabledCheckAngles() {
        return this.m_bCheckAngles;
    }

    public void setEnabledCheckAngles(boolean bl) {
        this.m_bCheckAngles = bl;
        this.m_bBigNeighbourhood = bl;
    }

    public boolean isEnabledFlipEdges() {
        return this.m_bFlipEdges;
    }

    public void setEnabledFlipEdges(boolean bl) {
        this.m_bFlipEdges = bl;
    }

    public void setDisplay(PvDisplayIf pvDisplayIf) {
        if (this.m_display != null && this.m_labelGeom != null && this.m_display.containsGeometry((PgGeometryIf)this.m_labelGeom)) {
            this.m_display.removeGeometry((PgGeometryIf)this.m_labelGeom);
        }
        super.setDisplay(pvDisplayIf);
        if (pvDisplayIf != null && this.m_labelGeom != null) {
            this.m_display.addGeometry((PgGeometryIf)this.m_labelGeom);
        }
    }

    public void showNumTriangles(boolean bl) {
        this.m_bShowNumTriangles = bl;
        if (bl) {
            if (this.m_labelGeom == null) {
                PdVector[] pdVectorArray;
                this.m_labelGeom = new PgPointSet(3);
                this.m_labelGeom.showVertices(false);
                this.m_labelGeom.setNumVertices(1);
                if (this.m_elementSet != null && (pdVectorArray = this.m_elementSet.getBounds()) != null) {
                    this.m_labelGeom.setVertex(0, pdVectorArray[0]);
                }
                if (this.m_display != null) {
                    this.m_display.addGeometry((PgGeometryIf)this.m_labelGeom);
                }
            }
            this.m_labelGeom.showName(true);
            this.m_labelGeom.setVisible(true);
        } else if (this.m_labelGeom != null) {
            this.m_labelGeom.setVisible(false);
            this.m_labelGeom.showName(false);
        }
    }

    public boolean isShowingNumTriangles() {
        return this.m_bShowNumTriangles;
    }

    private void checkRelation(int n) {
        this.heapJ = 2 * n + 1;
        this.heapK = 2 * n + 2;
        if (this.m_index.m_data[this.heapJ] == -1 || this.m_minValue.m_data[this.m_index.m_data[n]] < this.m_minValue.m_data[this.m_index.m_data[this.heapJ]]) {
            if (this.m_index.m_data[this.heapK] != -1 && this.m_minValue.m_data[this.m_index.m_data[n]] >= this.m_minValue.m_data[this.m_index.m_data[this.heapK]]) {
                this.heapN = this.m_index.m_data[this.heapK];
                this.m_index.m_data[this.heapK] = this.m_index.m_data[n];
                this.m_index.m_data[n] = this.heapN;
                this.m_location.m_data[this.m_index.m_data[n]] = n;
                this.m_location.m_data[this.m_index.m_data[this.heapK]] = this.heapK;
                if (this.heapK <= this.m_lastNode) {
                    this.checkRelation(this.heapK);
                }
            }
        } else if (this.m_index.m_data[this.heapK] == -1 || this.m_minValue.m_data[this.m_index.m_data[this.heapJ]] < this.m_minValue.m_data[this.m_index.m_data[this.heapK]]) {
            this.heapN = this.m_index.m_data[this.heapJ];
            this.m_index.m_data[this.heapJ] = this.m_index.m_data[n];
            this.m_index.m_data[n] = this.heapN;
            this.m_location.m_data[this.m_index.m_data[n]] = n;
            this.m_location.m_data[this.m_index.m_data[this.heapJ]] = this.heapJ;
            if (this.heapJ <= this.m_lastNode) {
                this.checkRelation(this.heapJ);
            }
        } else {
            this.heapN = this.m_index.m_data[this.heapK];
            this.m_index.m_data[this.heapK] = this.m_index.m_data[n];
            this.m_index.m_data[n] = this.heapN;
            this.m_location.m_data[this.m_index.m_data[n]] = n;
            this.m_location.m_data[this.m_index.m_data[this.heapK]] = this.heapK;
            if (this.heapK <= this.m_lastNode) {
                this.checkRelation(this.heapK);
            }
        }
    }

    private void valueChanged(int n) {
        if (n > 0 && this.m_minValue.m_data[this.m_index.m_data[n]] < this.m_minValue.m_data[this.m_index.m_data[(n - 1) / 2]]) {
            while (n > 0 && this.m_minValue.m_data[this.m_index.m_data[n]] < this.m_minValue.m_data[this.m_index.m_data[(n - 1) / 2]]) {
                this.heapJ = (n - 1) / 2;
                this.heapN = this.m_index.m_data[n];
                this.m_index.m_data[n] = this.m_index.m_data[this.heapJ];
                this.m_index.m_data[this.heapJ] = this.heapN;
                this.m_location.m_data[this.m_index.m_data[n]] = n;
                this.m_location.m_data[this.m_index.m_data[this.heapJ]] = this.heapJ;
                n = this.heapJ;
            }
        } else if (n <= this.m_lastNode) {
            this.checkRelation(n);
        }
    }

    private void deleteValue(int n) {
        if (n == this.m_maxIndex) {
            this.m_location.m_data[this.m_index.m_data[n]] = -1;
            this.m_index.m_data[n] = -1;
            --this.m_maxIndex;
            this.m_lastNode = (this.m_maxIndex - 1) / 2;
        } else {
            this.m_location.m_data[this.m_index.m_data[n]] = -1;
            this.m_index.m_data[n] = this.m_index.m_data[this.m_maxIndex];
            this.m_location.m_data[this.m_index.m_data[n]] = n;
            this.m_index.m_data[this.m_maxIndex] = -1;
            --this.m_maxIndex;
            this.m_lastNode = (this.m_maxIndex - 1) / 2;
            this.valueChanged(n);
        }
    }

    private void computeQuadric(int n) {
        if (this.m_dimOfVertices != 3) {
            return;
        }
        this.m_quadScalar.m_data[n] = 0.0;
        this.m_quadVector[n].setConstant(0.0);
        this.m_quadMatrix[n].setConstant(0.0);
        this.size[1] = this.m_elementsAtVertex[n].getSize();
        this.jj = 0;
        while (this.jj < this.size[1]) {
            this.m_index2[0] = this.m_elementsAtVertex[n].m_data[this.jj];
            if (!this.m_element[this.m_index2[0]].hasTag(2)) {
                this.dLoc[0] = this.m_elementSet.getAreaOfElement(this.m_index2[0]);
                this.dLoc[1] = PdVector.dot((PdVector)this.m_elementNormal[this.m_index2[0]], (PdVector)this.m_vertex[n]);
                int n2 = n;
                this.m_quadScalar.m_data[n2] = this.m_quadScalar.m_data[n2] + this.dLoc[0] * this.dLoc[1] * this.dLoc[1];
                this.kk = 0;
                while (this.kk < 3) {
                    int n3 = this.kk;
                    this.m_quadVector[n].m_data[n3] = this.m_quadVector[n].m_data[n3] + this.dLoc[0] * this.dLoc[1] * this.m_elementNormal[this.m_index2[0]].m_data[this.kk];
                    this.ll = 0;
                    while (this.ll < 3) {
                        double[] dArray = this.m_quadMatrix[n].m_data[this.kk];
                        int n4 = this.ll;
                        dArray[n4] = dArray[n4] + this.dLoc[0] * this.m_elementNormal[this.m_index2[0]].m_data[this.kk] * this.m_elementNormal[this.m_index2[0]].m_data[this.ll];
                        ++this.ll;
                    }
                    ++this.kk;
                }
            }
            ++this.jj;
        }
    }

    private void computeMinimum(int n) {
        this.m_isDenied[n] = false;
        if (this.m_dimOfVertices != 3 || this.m_bPrioritiseByEdgeLength) {
            if (this.m_vertex[this.m_edgeList[0].m_data[n]].hasTag(14) && !this.m_vertex[this.m_edgeList[1].m_data[n]].hasTag(14)) {
                this.m_minVector[n].copy(this.m_vertex[this.m_edgeList[0].m_data[n]]);
            } else if (!this.m_vertex[this.m_edgeList[0].m_data[n]].hasTag(14) && this.m_vertex[this.m_edgeList[1].m_data[n]].hasTag(14)) {
                this.m_minVector[n].copy(this.m_vertex[this.m_edgeList[1].m_data[n]]);
            } else {
                this.m_minVector[n].blend(0.5, this.m_vertex[this.m_edgeList[0].m_data[n]], 0.5, this.m_vertex[this.m_edgeList[1].m_data[n]]);
            }
            this.m_minValue.m_data[n] = PdVector.dist((PdVector)this.m_vertex[this.m_edgeList[0].m_data[n]], (PdVector)this.m_vertex[this.m_edgeList[1].m_data[n]]);
        } else {
            this.cmQ.setConstant(0.0);
            this.cmA.setConstant(0.0);
            this.cmV.setConstant(0.0);
            this.dLoc[0] = this.m_quadScalar.m_data[this.m_edgeList[0].m_data[n]] + this.m_quadScalar.m_data[this.m_edgeList[1].m_data[n]];
            this.cmQ.add(this.m_quadMatrix[this.m_edgeList[0].m_data[n]], this.m_quadMatrix[this.m_edgeList[1].m_data[n]]);
            this.cmV.add(this.m_quadVector[this.m_edgeList[0].m_data[n]], this.m_quadVector[this.m_edgeList[1].m_data[n]]);
            if (this.m_vertex[this.m_edgeList[0].m_data[n]].hasTag(14)) {
                if (!this.m_vertex[this.m_edgeList[1].m_data[n]].hasTag(14)) {
                    this.m_minVector[n].copy(this.m_vertex[this.m_edgeList[0].m_data[n]]);
                } else {
                    this.m_minVector[n].blend(0.5, this.m_vertex[this.m_edgeList[0].m_data[n]], 0.5, this.m_vertex[this.m_edgeList[1].m_data[n]]);
                }
            } else if (this.m_vertex[this.m_edgeList[1].m_data[n]].hasTag(14)) {
                this.m_minVector[n].copy(this.m_vertex[this.m_edgeList[1].m_data[n]]);
            } else if (Math.abs(this.cmQ.det()) < 1.0E-10) {
                this.cmQx.leftMultMatrix(this.cmQ, this.m_vertex[this.m_edgeList[0].m_data[n]]);
                double d = Math.abs(this.dLoc[0] - 2.0 * PdVector.dot((PdVector)this.cmV, (PdVector)this.m_vertex[this.m_edgeList[0].m_data[n]]) + PdVector.dot((PdVector)this.cmQx, (PdVector)this.m_vertex[this.m_edgeList[0].m_data[n]]));
                this.cmQx.leftMultMatrix(this.cmQ, this.m_vertex[this.m_edgeList[1].m_data[n]]);
                double d2 = Math.abs(this.dLoc[0] - 2.0 * PdVector.dot((PdVector)this.cmV, (PdVector)this.m_vertex[this.m_edgeList[1].m_data[n]]) + PdVector.dot((PdVector)this.cmQx, (PdVector)this.m_vertex[this.m_edgeList[1].m_data[n]]));
                if (d > 1.0E-10 && d2 < 1.0E-10) {
                    this.m_minVector[n].copy(this.m_vertex[this.m_edgeList[1].m_data[n]]);
                } else if (d < 1.0E-10 && d2 > 1.0E-10) {
                    this.m_minVector[n].copy(this.m_vertex[this.m_edgeList[0].m_data[n]]);
                } else if (d > 1.0E-10 && d2 > 1.0E-10) {
                    this.m_minVector[n].blend(d2 / (d + d2), this.m_vertex[this.m_edgeList[0].m_data[n]], d / (d + d2), this.m_vertex[this.m_edgeList[1].m_data[n]]);
                } else {
                    this.m_minVector[n].blend(0.5, this.m_vertex[this.m_edgeList[0].m_data[n]], 0.5, this.m_vertex[this.m_edgeList[1].m_data[n]]);
                }
            } else {
                this.cmA.invert(this.cmQ);
                this.m_minVector[n].leftMultMatrix(this.cmA, this.cmV);
            }
            this.cmQx.leftMultMatrix(this.cmQ, this.m_minVector[n]);
            this.m_minValue.m_data[n] = this.dLoc[0] - 2.0 * PdVector.dot((PdVector)this.cmV, (PdVector)this.m_minVector[n]) + PdVector.dot((PdVector)this.cmQx, (PdVector)this.m_minVector[n]);
            if (this.m_minValue.m_data[n] < 0.0) {
                int n2 = n;
                this.m_minValue.m_data[n2] = this.m_minValue.m_data[n2] * -1.0;
            }
            if (this.m_minValue.m_data[n] < 1.0E-10) {
                this.m_minValue.m_data[n] = -1.0 / (PdVector.dist((PdVector)this.m_vertex[this.m_edgeList[0].m_data[n]], (PdVector)this.m_vertex[this.m_edgeList[1].m_data[n]]) + 1.0E-10);
            }
        }
    }

    private void removeEdge() {
        if (this.m_bGenerateVertexMap) {
            this.m_vertexMap.m_data[this.m_vertexIndex[1]] = this.m_vertexIndex[0];
        }
        if (this.m_dimOfElements != -1 && this.m_dimOfElements != 3) {
            this.m_elementSet.setDimOfElements(-1);
            this.m_dimOfElements = -1;
        }
        if (this.m_vertex[this.m_vertexIndex[1]].hasTag(14)) {
            this.replaceBndVertex(this.m_vertexIndex[1], this.m_vertexIndex[0]);
        }
        if (this.m_vertex[this.m_vertexIndex[1]].hasTag(14) || this.m_vertex[this.m_vertexIndex[0]].hasTag(14)) {
            this.m_minVector[this.m_edgeNr].setTag(14);
        }
        if (this.m_hasElementTextures || this.m_hasVertexTextures || this.m_hasVertexColors || this.m_numVF > 0) {
            this.dLoc[0] = PdVector.dist((PdVector)this.m_minVector[this.m_edgeNr], (PdVector)this.m_vertex[this.m_vertexIndex[0]]);
            this.dLoc[1] = PdVector.dist((PdVector)this.m_minVector[this.m_edgeNr], (PdVector)this.m_vertex[this.m_vertexIndex[1]]);
            if (this.dLoc[0] + this.dLoc[1] > 1.0E-10) {
                this.dLoc[0] = this.dLoc[0] / (this.dLoc[0] + this.dLoc[1]);
                this.dLoc[1] = 1.0 - this.dLoc[0];
            } else {
                this.dLoc[0] = 0.5;
                this.dLoc[1] = 0.5;
            }
        }
        this.size[0] = this.m_elementsAtVertex[this.m_vertexIndex[1]].getSize();
        this.ii = 0;
        while (this.ii < this.size[0]) {
            this.m_index2[1] = this.m_elementsAtVertex[this.m_vertexIndex[1]].m_data[this.ii];
            if (!this.m_element[this.m_index2[1]].hasTag(2)) {
                this.reElement = this.m_element[this.m_index2[1]];
                this.size[1] = this.reElement.getSize();
                this.jj = 0;
                while (this.jj < this.size[1]) {
                    if (this.reElement.m_data[this.jj] == this.m_vertexIndex[1]) {
                        this.reElement.m_data[this.jj] = this.m_vertexIndex[0];
                        if (this.reElement.m_data[(this.jj + 1) % this.size[1]] == this.m_vertexIndex[0] || this.reElement.m_data[(this.jj - 1 + this.size[1]) % this.size[1]] == this.m_vertexIndex[0]) {
                            if (this.size[1] < 4) {
                                if (this.reElement.m_data[(this.jj + 1) % this.size[1]] == this.m_vertexIndex[0]) {
                                    this.m_index2[2] = this.m_neighbour[this.m_index2[1]].m_data[this.jj];
                                    this.m_index2[3] = this.m_neighbour[this.m_index2[1]].m_data[(this.jj + 1) % this.size[1]];
                                    this.m_vertexIndex[2] = this.reElement.m_data[(this.jj + 2) % this.size[1]];
                                } else {
                                    this.m_index2[2] = this.m_neighbour[this.m_index2[1]].m_data[(this.jj - 1 + this.size[1]) % this.size[1]];
                                    this.m_index2[3] = this.m_neighbour[this.m_index2[1]].m_data[this.jj];
                                    this.m_vertexIndex[2] = this.reElement.m_data[(this.jj + 1) % this.size[1]];
                                }
                                if (this.m_index2[2] != -1) {
                                    this.reNeighbour = this.m_neighbour[this.m_index2[2]];
                                    this.size[2] = this.reNeighbour.getSize();
                                    this.kk = 0;
                                    while (this.kk < this.size[2]) {
                                        if (this.reNeighbour.m_data[this.kk] == this.m_index2[1]) {
                                            this.reNeighbour.m_data[this.kk] = this.m_index2[3];
                                        }
                                        ++this.kk;
                                    }
                                }
                                if (this.m_index2[3] != -1) {
                                    this.reNeighbour = this.m_neighbour[this.m_index2[3]];
                                    this.size[2] = this.reNeighbour.getSize();
                                    this.kk = 0;
                                    while (this.kk < this.size[2]) {
                                        if (this.reNeighbour.m_data[this.kk] == this.m_index2[1]) {
                                            this.reNeighbour.m_data[this.kk] = this.m_index2[2];
                                        }
                                        ++this.kk;
                                    }
                                }
                                if (this.m_index2[2] == -1 && this.m_index2[3] == -1) {
                                    this.replaceBndVertex(this.m_vertexIndex[2], this.m_vertexIndex[0]);
                                }
                                this.m_element[this.m_index2[1]].setTag(2);
                                --this.m_numEl;
                                this.size[2] = this.m_elementsAtVertex[this.m_vertexIndex[2]].getSize();
                                this.kk = 0;
                                while (this.kk < this.size[2]) {
                                    if (this.m_elementsAtVertex[this.m_vertexIndex[2]].m_data[this.kk] == this.m_index2[1]) {
                                        this.m_index2[4] = this.kk;
                                    }
                                    ++this.kk;
                                }
                                this.kk = this.m_index2[4];
                                while (this.kk < this.size[2] - 1) {
                                    this.m_elementsAtVertex[this.m_vertexIndex[2]].m_data[this.kk] = this.m_elementsAtVertex[this.m_vertexIndex[2]].m_data[this.kk + 1];
                                    ++this.kk;
                                }
                                this.m_elementsAtVertex[this.m_vertexIndex[2]].setSize(this.size[2] - 1);
                            } else {
                                this.m_index2[4] = this.reElement.m_data[(this.jj + 1) % this.size[1]] == this.m_vertexIndex[0] ? (this.jj - 1 + this.size[1]) % this.size[1] : (this.jj - 2 + this.size[1]) % this.size[1];
                                this.reNeighbour = this.m_neighbour[this.m_index2[1]];
                                this.size[2] = this.reNeighbour.getSize();
                                this.kk = this.m_index2[4];
                                while (this.kk < this.size[2] - 1) {
                                    this.reNeighbour.m_data[this.kk] = this.reNeighbour.m_data[this.kk + 1];
                                    ++this.kk;
                                }
                                if (this.jj == 0 || this.jj == 1 && this.m_index2[4] == this.size[1] - 1) {
                                    this.mm = this.reNeighbour.m_data[0];
                                    this.kk = 0;
                                    while (this.kk < this.size[2] - 1) {
                                        this.reNeighbour.m_data[this.kk] = this.reNeighbour.m_data[this.kk + 1];
                                        ++this.kk;
                                    }
                                    this.reNeighbour.m_data[this.size[2] - 2] = this.mm;
                                }
                                this.size[2] = this.reElement.getSize();
                                this.kk = this.jj;
                                while (this.kk < this.size[2] - 1) {
                                    this.reElement.m_data[this.kk] = this.reElement.m_data[this.kk + 1];
                                    ++this.kk;
                                }
                                if (this.m_hasElementTextures) {
                                    PdVector[] pdVectorArray = this.m_elementTexture[this.m_index2[1]];
                                    PdVector[] pdVectorArray2 = new PdVector[this.size[1] - 1];
                                    if (this.reElement.m_data[(this.jj + 1) % this.size[1]] == this.m_vertexIndex[0]) {
                                        this.kk = 0;
                                        while (this.kk < this.jj) {
                                            pdVectorArray2[this.kk] = pdVectorArray[this.kk];
                                            ++this.kk;
                                        }
                                        this.kk = this.jj + 1;
                                        while (this.kk < this.size[1] - 1) {
                                            pdVectorArray2[this.kk] = pdVectorArray[this.kk + 1];
                                            ++this.kk;
                                        }
                                        pdVectorArray2[this.jj % (this.size[1] - 1)] = PdVector.blendNew((double)this.dLoc[0], (PdVector)pdVectorArray[this.jj], (double)this.dLoc[1], (PdVector)pdVectorArray[(this.jj + 1) % this.size[1]]);
                                    } else {
                                        this.kk = 0;
                                        while (this.kk < this.jj - 1) {
                                            pdVectorArray2[this.kk] = pdVectorArray[this.kk];
                                            ++this.kk;
                                        }
                                        this.kk = this.jj;
                                        while (this.kk < this.size[1] - 1) {
                                            pdVectorArray2[this.kk] = pdVectorArray[this.kk + 1];
                                            ++this.kk;
                                        }
                                        pdVectorArray2[(this.jj - 2 + this.size[1]) % (this.size[1] - 1)] = PdVector.blendNew((double)this.dLoc[0], (PdVector)pdVectorArray[this.jj], (double)this.dLoc[1], (PdVector)pdVectorArray[(this.jj - 1 + this.size[1]) % this.size[1]]);
                                    }
                                    this.m_elementTexture[this.m_index2[1]] = pdVectorArray2;
                                }
                                this.size[1] = this.size[1] - 1;
                                this.reElement.setSize(this.size[1]);
                                this.reNeighbour.setSize(this.size[1]);
                            }
                        } else {
                            this.size[2] = this.m_elementsAtVertex[this.m_vertexIndex[0]].getSize();
                            this.m_elementsAtVertex[this.m_vertexIndex[0]].setSize(this.size[2] + 1);
                            this.m_elementsAtVertex[this.m_vertexIndex[0]].m_data[this.size[2]] = this.m_index2[1];
                        }
                    }
                    ++this.jj;
                }
            }
            ++this.ii;
        }
        if (this.m_hasVertexTextures) {
            this.m_vertexTexture[this.m_vertexIndex[0]].blend(this.dLoc[1], this.m_vertexTexture[this.m_vertexIndex[0]], this.dLoc[0], this.m_vertexTexture[this.m_vertexIndex[1]]);
        }
        if (this.m_hasVertexColors) {
            this.m_vertexColor[this.m_vertexIndex[0]] = PdColor.blend((double)this.dLoc[1], (Color)this.m_vertexColor[this.m_vertexIndex[0]], (double)this.dLoc[0], (Color)this.m_vertexColor[this.m_vertexIndex[1]]);
        }
        this.ii = 0;
        while (this.ii < this.m_numVF) {
            if (this.m_vectorField[this.ii].getBasedOn() == 0) {
                this.m_vectorField[this.ii].getVector(this.m_vertexIndex[0]).blend(this.dLoc[1], this.m_vectorField[this.ii].getVector(this.m_vertexIndex[0]), this.dLoc[0], this.m_vectorField[this.ii].getVector(this.m_vertexIndex[1]));
            }
            ++this.ii;
        }
        this.m_vertex[this.m_vertexIndex[0]] = this.m_minVector[this.m_edgeNr];
        this.count[1] = 0;
        this.size[0] = this.m_elementsAtVertex[this.m_vertexIndex[0]].getSize();
        this.ii = 0;
        while (this.ii < this.size[0]) {
            if (!this.m_element[this.m_elementsAtVertex[this.m_vertexIndex[0]].m_data[this.ii]].hasTag(2)) {
                int n = this.count[1];
                this.count[1] = n + 1;
                this.m_elementsAtVertex[this.m_vertexIndex[0]].m_data[n] = this.m_elementsAtVertex[this.m_vertexIndex[0]].m_data[this.ii];
            }
            ++this.ii;
        }
        this.m_elementsAtVertex[this.m_vertexIndex[0]].setSize(this.count[1]);
        this.m_elementsAtVertex[this.m_vertexIndex[1]].setSize(0);
        this.count[1] = 0;
        this.size[0] = this.m_edgesAtVertex[this.m_vertexIndex[0]].getSize();
        this.size[1] = this.m_edgesAtVertex[this.m_vertexIndex[1]].getSize();
        this.m_edgesAtVertex[this.m_vertexIndex[0]].setSize(this.size[0] + this.size[1] - 1);
        this.ii = 0;
        while (this.ii < this.size[0]) {
            this.m_index2[7] = this.m_edgesAtVertex[this.m_vertexIndex[0]].m_data[this.ii];
            if (this.m_edgeList[1].m_data[this.m_index2[7]] == this.m_vertexIndex[1]) {
                if (this.m_location.m_data[this.m_index2[7]] != -1) {
                    this.deleteValue(this.m_location.m_data[this.m_index2[7]]);
                }
            } else {
                int n = this.count[1];
                this.count[1] = n + 1;
                this.m_edgesAtVertex[this.m_vertexIndex[0]].m_data[n] = this.m_index2[7];
            }
            ++this.ii;
        }
        this.ii = 0;
        while (this.ii < this.size[1]) {
            this.m_index2[7] = this.m_edgesAtVertex[this.m_vertexIndex[1]].m_data[this.ii];
            if (this.m_edgeList[0].m_data[this.m_index2[7]] != this.m_vertexIndex[0]) {
                if (this.m_edgeList[0].m_data[this.m_index2[7]] == this.m_vertexIndex[1]) {
                    this.m_edgeList[0].m_data[this.m_index2[7]] = this.m_vertexIndex[0];
                } else if (this.m_vertexIndex[0] > this.m_edgeList[0].m_data[this.m_index2[7]]) {
                    this.m_edgeList[1].m_data[this.m_index2[7]] = this.m_vertexIndex[0];
                } else {
                    this.m_edgeList[1].m_data[this.m_index2[7]] = this.m_edgeList[0].m_data[this.m_index2[7]];
                    this.m_edgeList[0].m_data[this.m_index2[7]] = this.m_vertexIndex[0];
                }
                this.reDoubleEdge = false;
                this.jj = 0;
                while (this.jj < this.count[1]) {
                    if (this.m_edgeList[0].m_data[this.m_index2[7]] == this.m_edgeList[0].m_data[this.m_edgesAtVertex[this.m_vertexIndex[0]].m_data[this.jj]] && this.m_edgeList[1].m_data[this.m_index2[7]] == this.m_edgeList[1].m_data[this.m_edgesAtVertex[this.m_vertexIndex[0]].m_data[this.jj]]) {
                        this.reDoubleEdge = true;
                    }
                    ++this.jj;
                }
                if (!this.reDoubleEdge) {
                    int n = this.count[1];
                    this.count[1] = n + 1;
                    this.m_edgesAtVertex[this.m_vertexIndex[0]].m_data[n] = this.m_index2[7];
                } else {
                    this.deleteValue(this.m_location.m_data[this.m_index2[7]]);
                    if (this.m_edgeList[0].m_data[this.m_index2[7]] == this.m_vertexIndex[0]) {
                        this.count[0] = 0;
                        this.size[2] = this.m_edgesAtVertex[this.m_edgeList[1].m_data[this.m_index2[7]]].getSize();
                        this.kk = 0;
                        while (this.kk < this.size[2]) {
                            if (this.m_edgesAtVertex[this.m_edgeList[1].m_data[this.m_index2[7]]].m_data[this.kk] != this.m_index2[7]) {
                                int n = this.count[0];
                                this.count[0] = n + 1;
                                this.m_edgesAtVertex[this.m_edgeList[1].m_data[this.m_index2[7]]].m_data[n] = this.m_edgesAtVertex[this.m_edgeList[1].m_data[this.m_index2[7]]].m_data[this.kk];
                            }
                            ++this.kk;
                        }
                        this.m_edgesAtVertex[this.m_edgeList[1].m_data[this.m_index2[7]]].setSize(this.size[2] - 1);
                    } else {
                        this.count[0] = 0;
                        this.size[2] = this.m_edgesAtVertex[this.m_edgeList[0].m_data[this.m_index2[7]]].getSize();
                        this.kk = 0;
                        while (this.kk < this.size[2]) {
                            if (this.m_edgesAtVertex[this.m_edgeList[0].m_data[this.m_index2[7]]].m_data[this.kk] != this.m_index2[7]) {
                                int n = this.count[0];
                                this.count[0] = n + 1;
                                this.m_edgesAtVertex[this.m_edgeList[0].m_data[this.m_index2[7]]].m_data[n] = this.m_edgesAtVertex[this.m_edgeList[0].m_data[this.m_index2[7]]].m_data[this.kk];
                            }
                            ++this.kk;
                        }
                        this.m_edgesAtVertex[this.m_edgeList[0].m_data[this.m_index2[7]]].setSize(this.size[2] - 1);
                    }
                }
            }
            ++this.ii;
        }
        this.m_edgesAtVertex[this.m_vertexIndex[0]].setSize(this.count[1]);
        this.m_edgesAtVertex[this.m_vertexIndex[1]].setSize(0);
        if (this.m_bCheckNormals || this.m_bCheckAngles) {
            this.computeQuadric(this.m_vertexIndex[0]);
            this.size[0] = this.m_edgesAtVertex[this.m_vertexIndex[0]].getSize();
            this.ii = 0;
            while (this.ii < this.size[0]) {
                if (this.m_edgeList[0].m_data[this.m_edgesAtVertex[this.m_vertexIndex[0]].m_data[this.ii]] == this.m_vertexIndex[0]) {
                    this.computeQuadric(this.m_edgeList[1].m_data[this.m_edgesAtVertex[this.m_vertexIndex[0]].m_data[this.ii]]);
                } else {
                    this.computeQuadric(this.m_edgeList[0].m_data[this.m_edgesAtVertex[this.m_vertexIndex[0]].m_data[this.ii]]);
                }
                ++this.ii;
            }
        } else if (this.m_dimOfVertices == 3) {
            this.m_quadMatrix[this.m_vertexIndex[0]].add(this.m_quadMatrix[this.m_vertexIndex[1]]);
            this.m_quadVector[this.m_vertexIndex[0]].add(this.m_quadVector[this.m_vertexIndex[1]]);
            int n = this.m_vertexIndex[0];
            this.m_quadScalar.m_data[n] = this.m_quadScalar.m_data[n] + this.m_quadScalar.m_data[this.m_vertexIndex[1]];
        }
        if (!this.m_bBigNeighbourhood) {
            this.size[0] = this.m_edgesAtVertex[this.m_vertexIndex[0]].getSize();
            this.ii = 0;
            while (this.ii < this.size[0]) {
                if (this.m_location.m_data[this.m_edgesAtVertex[this.m_vertexIndex[0]].m_data[this.ii]] != -1) {
                    this.computeMinimum(this.m_edgesAtVertex[this.m_vertexIndex[0]].m_data[this.ii]);
                    this.valueChanged(this.m_location.m_data[this.m_edgesAtVertex[this.m_vertexIndex[0]].m_data[this.ii]]);
                }
                ++this.ii;
            }
        } else {
            this.size[0] = this.m_edgesAtVertex2[this.m_vertexIndex[0]].getSize();
            this.size[1] = this.m_edgesAtVertex2[this.m_vertexIndex[1]].getSize();
            this.m_edgesAtVertex2[this.m_vertexIndex[0]].setSize(this.size[0] + this.size[1]);
            this.count[1] = 0;
            this.ii = 0;
            while (this.ii < this.size[0]) {
                this.m_index2[5] = this.m_edgesAtVertex2[this.m_vertexIndex[0]].m_data[this.ii];
                if (!(this.m_edgeList[0].m_data[this.m_index2[5]] == this.m_vertexIndex[1] && this.m_edgeList[1].m_data[this.m_index2[5]] == this.m_vertexIndex[0] || this.m_edgeList[0].m_data[this.m_index2[5]] == this.m_vertexIndex[0] && this.m_edgeList[1].m_data[this.m_index2[5]] == this.m_vertexIndex[1] || this.m_location.m_data[this.m_index2[5]] == -1)) {
                    int n = this.count[1];
                    this.count[1] = n + 1;
                    this.m_edgesAtVertex2[this.m_vertexIndex[0]].m_data[n] = this.m_index2[5];
                }
                ++this.ii;
            }
            this.ii = 0;
            while (this.ii < this.size[1]) {
                this.m_index2[5] = this.m_edgesAtVertex2[this.m_vertexIndex[1]].m_data[this.ii];
                if (!(this.m_edgeList[0].m_data[this.m_index2[5]] == this.m_vertexIndex[0] && this.m_edgeList[1].m_data[this.m_index2[5]] == this.m_vertexIndex[1] || this.m_edgeList[0].m_data[this.m_index2[5]] == this.m_vertexIndex[1] && this.m_edgeList[1].m_data[this.m_index2[5]] == this.m_vertexIndex[0])) {
                    this.reEdgeIsSaved = false;
                    this.kk = 0;
                    while (this.kk < this.count[1]) {
                        if (this.m_edgesAtVertex2[this.m_vertexIndex[0]].m_data[this.kk] == this.m_index2[5]) {
                            this.reEdgeIsSaved = true;
                            break;
                        }
                        ++this.kk;
                    }
                    if (!this.reEdgeIsSaved && this.m_location.m_data[this.m_index2[5]] != -1) {
                        int n = this.count[1];
                        this.count[1] = n + 1;
                        this.m_edgesAtVertex2[this.m_vertexIndex[0]].m_data[n] = this.m_index2[5];
                    }
                }
                ++this.ii;
            }
            this.m_edgesAtVertex2[this.m_vertexIndex[0]].setSize(this.count[1]);
            this.m_edgesAtVertex2[this.m_vertexIndex[1]].setSize(0);
            this.size[2] = this.m_edgesAtVertex2[this.m_vertexIndex[0]].getSize();
            this.ii = 0;
            while (this.ii < this.size[2]) {
                this.m_index2[5] = this.m_edgesAtVertex2[this.m_vertexIndex[0]].m_data[this.ii];
                if (this.m_location.m_data[this.m_index2[5]] != -1) {
                    this.computeMinimum(this.m_index2[5]);
                    this.valueChanged(this.m_location.m_data[this.m_index2[5]]);
                }
                ++this.ii;
            }
            this.size[2] = this.m_edgesAtVertex2[this.m_vertexIndex[0]].getSize();
            this.ii = 0;
            while (this.ii < this.size[2]) {
                this.m_index2[5] = this.m_edgesAtVertex2[this.m_vertexIndex[0]].m_data[this.ii];
                if (this.m_location.m_data[this.m_index2[5]] != -1) {
                    this.mm = 0;
                    while (this.mm < 2) {
                        this.size[3] = this.m_elementsAtVertex[this.m_edgeList[this.mm].m_data[this.m_index2[5]]].getSize();
                        this.jj = 0;
                        while (this.jj < this.size[3]) {
                            this.m_index2[1] = this.m_elementsAtVertex[this.m_edgeList[this.mm].m_data[this.m_index2[5]]].m_data[this.jj];
                            this.reElement = this.m_element[this.m_index2[1]];
                            if (!this.m_element[this.m_index2[1]].hasTag(2)) {
                                this.size[4] = this.reElement.getSize();
                                this.kk = 0;
                                while (this.kk < this.size[4]) {
                                    this.count[0] = 0;
                                    this.reEdgeIsSaved = false;
                                    this.size[5] = this.m_edgesAtVertex2[this.reElement.m_data[this.kk]].getSize();
                                    this.ll = 0;
                                    while (this.ll < this.size[5]) {
                                        this.m_index2[6] = this.m_edgesAtVertex2[this.reElement.m_data[this.kk]].m_data[this.ll];
                                        if (this.m_location.m_data[this.m_index2[6]] != -1) {
                                            int n = this.count[0];
                                            this.count[0] = n + 1;
                                            this.m_edgesAtVertex2[this.reElement.m_data[this.kk]].m_data[n] = this.m_index2[6];
                                            if (this.m_index2[5] == this.m_index2[6]) {
                                                this.reEdgeIsSaved = true;
                                            }
                                        }
                                        ++this.ll;
                                    }
                                    if (!this.reEdgeIsSaved) {
                                        this.m_edgesAtVertex2[this.reElement.m_data[this.kk]].setSize(this.count[0] + 1);
                                        this.m_edgesAtVertex2[this.reElement.m_data[this.kk]].m_data[this.count[0]] = this.m_index2[5];
                                    } else {
                                        this.m_edgesAtVertex2[this.reElement.m_data[this.kk]].setSize(this.count[0]);
                                    }
                                    ++this.kk;
                                }
                            }
                            ++this.jj;
                        }
                        ++this.mm;
                    }
                }
                ++this.ii;
            }
        }
    }

    private boolean checkNewElements() {
        if (!this.m_bCheckAngles || this.m_dimOfElements != 3) {
            return true;
        }
        this.ii = 0;
        while (this.ii < 2) {
            this.size[0] = this.m_elementsAtVertex[this.m_vertexIndex[this.ii]].getSize();
            this.jj = 0;
            while (this.jj < this.size[0]) {
                this.cneElement = this.m_element[this.m_elementsAtVertex[this.m_vertexIndex[this.ii]].m_data[this.jj]];
                if (!this.m_element[this.m_elementsAtVertex[this.m_vertexIndex[this.ii]].m_data[this.jj]].hasTag(2) && this.cneElement.m_data[0] != this.m_vertexIndex[(this.ii + 1) % 2] && this.cneElement.m_data[1] != this.m_vertexIndex[(this.ii + 1) % 2] && this.cneElement.m_data[2] != this.m_vertexIndex[(this.ii + 1) % 2]) {
                    if (this.cneElement.m_data[0] == this.m_vertexIndex[this.ii]) {
                        this.dLoc[0] = PdVector.dist((PdVector)this.m_minVector[this.m_edgeNr], (PdVector)this.m_vertex[this.cneElement.m_data[1]]);
                        this.dLoc[1] = PdVector.dist((PdVector)this.m_minVector[this.m_edgeNr], (PdVector)this.m_vertex[this.cneElement.m_data[2]]);
                        this.dLoc[2] = PdVector.dist((PdVector)this.m_vertex[this.cneElement.m_data[1]], (PdVector)this.m_vertex[this.cneElement.m_data[2]]);
                    } else if (this.cneElement.m_data[1] == this.m_vertexIndex[this.ii]) {
                        this.dLoc[0] = PdVector.dist((PdVector)this.m_vertex[this.cneElement.m_data[0]], (PdVector)this.m_minVector[this.m_edgeNr]);
                        this.dLoc[1] = PdVector.dist((PdVector)this.m_vertex[this.cneElement.m_data[0]], (PdVector)this.m_vertex[this.cneElement.m_data[2]]);
                        this.dLoc[2] = PdVector.dist((PdVector)this.m_minVector[this.m_edgeNr], (PdVector)this.m_vertex[this.cneElement.m_data[2]]);
                    } else {
                        this.dLoc[0] = PdVector.dist((PdVector)this.m_vertex[this.cneElement.m_data[0]], (PdVector)this.m_vertex[this.cneElement.m_data[1]]);
                        this.dLoc[1] = PdVector.dist((PdVector)this.m_vertex[this.cneElement.m_data[0]], (PdVector)this.m_minVector[this.m_edgeNr]);
                        this.dLoc[2] = PdVector.dist((PdVector)this.m_vertex[this.cneElement.m_data[1]], (PdVector)this.m_minVector[this.m_edgeNr]);
                    }
                    if (this.dLoc[0] > this.dLoc[1] && this.dLoc[0] > this.dLoc[2] ? (this.dLoc[1] + this.dLoc[2] - this.dLoc[0]) / this.dLoc[0] < this.m_minInOut : (this.dLoc[1] > this.dLoc[2] ? (this.dLoc[0] + this.dLoc[2] - this.dLoc[1]) / this.dLoc[1] < this.m_minInOut : (this.dLoc[0] + this.dLoc[1] - this.dLoc[2]) / this.dLoc[2] < this.m_minInOut)) {
                        return false;
                    }
                }
                ++this.jj;
            }
            ++this.ii;
        }
        return true;
    }

    private boolean checkNormalAngles(boolean bl) {
        if (!this.m_bCheckNormals) {
            return true;
        }
        this.ii = 0;
        while (this.ii < 2) {
            this.size[this.ii] = this.m_elementsAtVertex[this.m_vertexIndex[this.ii]].getSize();
            ++this.ii;
        }
        this.cnElNr.setSize(this.size[0] + this.size[1]);
        PdVector[] pdVectorArray = new PdVector[this.size[0] + this.size[1]];
        PdVector.realloc((PdVector[])pdVectorArray, (int)(this.size[0] + this.size[1]), (int)3);
        this.count[1] = 0;
        this.kk = 0;
        while (this.kk < 2) {
            this.ii = 0;
            while (this.ii < this.size[this.kk]) {
                this.cnOldElement = this.m_element[this.m_elementsAtVertex[this.m_vertexIndex[this.kk]].m_data[this.ii]];
                if (!this.m_element[this.m_elementsAtVertex[this.m_vertexIndex[this.kk]].m_data[this.ii]].hasTag(2)) {
                    this.size[2] = this.cnOldElement.getSize();
                    PdVector[] pdVectorArray2 = new PdVector[this.size[2]];
                    this.count[0] = 0;
                    this.jj = 0;
                    while (this.jj < this.size[2]) {
                        if (this.cnOldElement.m_data[this.jj] == this.m_vertexIndex[this.kk]) {
                            int n = this.count[0];
                            this.count[0] = n + 1;
                            pdVectorArray2[n] = this.m_minVector[this.m_edgeNr];
                        } else if (this.cnOldElement.m_data[this.jj] != this.m_vertexIndex[(this.kk + 1) % 2]) {
                            int n = this.count[0];
                            this.count[0] = n + 1;
                            pdVectorArray2[n] = this.m_vertex[this.cnOldElement.m_data[this.jj]];
                        }
                        ++this.jj;
                    }
                    if (this.count[0] > 2) {
                        if (this.m_dimOfVertices != 1 && this.m_dimOfVertices != 2 || this.m_dimOfVectors != 3) {
                            this.cnNormal.setConstant(0.0);
                            this.jj = 0;
                            while (this.jj < this.count[0]) {
                                this.cnVertexA = pdVectorArray2[this.jj];
                                this.cnVertexB = pdVectorArray2[(this.jj + 1) % this.count[0]];
                                this.cnVertexC = pdVectorArray2[(this.jj + 2) % this.count[0]];
                                this.cnEdgeB.sub(this.cnVertexA, this.cnVertexB);
                                this.cnEdgeC.sub(this.cnVertexC, this.cnVertexB);
                                this.cnNor.cross(this.cnEdgeC, this.cnEdgeB);
                                if (this.cnNor.normalize()) {
                                    this.cnNormal.add(this.cnNor);
                                }
                                ++this.jj;
                            }
                            this.cnNormal.normalize();
                        }
                        if (PdVector.angle((PdVector)this.cnNormal, (PdVector)this.m_elementNormal[this.m_elementsAtVertex[this.m_vertexIndex[this.kk]].m_data[this.ii]]) > this.m_maxAngle) {
                            return false;
                        }
                        this.cnElNr.m_data[this.count[1]] = this.m_elementsAtVertex[this.m_vertexIndex[this.kk]].m_data[this.ii];
                        int n = this.count[1];
                        this.count[1] = n + 1;
                        pdVectorArray[n].copy(this.cnNormal);
                    }
                }
                ++this.ii;
            }
            ++this.kk;
        }
        if (bl) {
            this.ii = 0;
            while (this.ii < this.count[1]) {
                this.m_elementNormal[this.cnElNr.m_data[this.ii]] = pdVectorArray[this.ii];
                ++this.ii;
            }
        }
        return true;
    }

    private boolean checkEdge() {
        this.count[0] = 0;
        this.size[0] = this.m_edgesAtVertex[this.m_vertexIndex[0]].getSize();
        this.size[1] = this.m_edgesAtVertex[this.m_vertexIndex[1]].getSize();
        this.ii = 0;
        while (this.ii < this.size[0]) {
            this.m_index2[0] = this.m_edgesAtVertex[this.m_vertexIndex[0]].m_data[this.ii];
            this.jj = 0;
            while (this.jj < this.size[1]) {
                this.m_index2[1] = this.m_edgesAtVertex[this.m_vertexIndex[1]].m_data[this.jj];
                if (this.m_edgeList[0].m_data[this.m_index2[0]] == this.m_vertexIndex[0]) {
                    if (this.m_edgeList[0].m_data[this.m_index2[1]] == this.m_vertexIndex[1]) {
                        if (this.m_edgeList[1].m_data[this.m_index2[0]] == this.m_edgeList[1].m_data[this.m_index2[1]]) {
                            this.count[0] = this.count[0] + 1;
                        }
                    } else if (this.m_edgeList[1].m_data[this.m_index2[0]] == this.m_edgeList[0].m_data[this.m_index2[1]]) {
                        this.count[0] = this.count[0] + 1;
                    }
                } else if (this.m_edgeList[0].m_data[this.m_index2[1]] == this.m_vertexIndex[1]) {
                    if (this.m_edgeList[0].m_data[this.m_index2[0]] == this.m_edgeList[1].m_data[this.m_index2[1]]) {
                        this.count[0] = this.count[0] + 1;
                    }
                } else if (this.m_edgeList[0].m_data[this.m_index2[0]] == this.m_edgeList[0].m_data[this.m_index2[1]]) {
                    this.count[0] = this.count[0] + 1;
                }
                ++this.jj;
            }
            ++this.ii;
        }
        if (this.count[0] > 2) {
            return true;
        }
        if (this.m_vertex[this.m_vertexIndex[0]].hasTag(14) && this.m_vertex[this.m_vertexIndex[1]].hasTag(14)) {
            this.count[0] = 0;
            this.size[2] = this.m_elementsAtVertex[this.m_vertexIndex[0]].getSize();
            this.size[3] = this.m_elementsAtVertex[this.m_vertexIndex[1]].getSize();
            this.ii = 0;
            while (this.ii < this.size[2]) {
                this.jj = 0;
                while (this.jj < this.size[3]) {
                    if (this.m_elementsAtVertex[this.m_vertexIndex[0]].m_data[this.ii] == this.m_elementsAtVertex[this.m_vertexIndex[1]].m_data[this.jj]) {
                        this.count[0] = this.count[0] + 1;
                    }
                    ++this.jj;
                }
                ++this.ii;
            }
            if (this.count[0] > 1) {
                return true;
            }
        }
        if (this.m_bKeepBoundary && (this.m_vertex[this.m_vertexIndex[0]].hasTag(14) || this.m_vertex[this.m_vertexIndex[1]].hasTag(14))) {
            return true;
        }
        if (this.m_bKeepMarkedVertices && (this.m_vertex[this.m_vertexIndex[0]].hasTag(1) || this.m_vertex[this.m_vertexIndex[1]].hasTag(1))) {
            return true;
        }
        this.ceRemoveBnd = false;
        if (this.m_vertex[this.m_vertexIndex[0]].hasTag(14) && this.m_vertex[this.m_vertexIndex[1]].hasTag(14) && this.m_hasBoundary) {
            this.ii = 0;
            while (this.ii < this.m_numBnd) {
                this.ceBndInd = this.m_bndList[this.ii];
                if (!this.ceBndInd.hasTag(2)) {
                    this.size[4] = this.m_bndList[this.ii].getSize();
                    this.ceDd = false;
                    if (this.size[4] > 1 && (this.ceBndInd.m_data[0] == this.m_vertexIndex[0] && this.ceBndInd.m_data[1] == this.m_vertexIndex[1] || this.ceBndInd.m_data[0] == this.m_vertexIndex[1] && this.ceBndInd.m_data[1] == this.m_vertexIndex[0] || this.ceBndInd.m_data[this.size[4] - 2] == this.m_vertexIndex[0] && this.ceBndInd.m_data[this.size[4] - 1] == this.m_vertexIndex[1] || this.ceBndInd.m_data[this.size[4] - 2] == this.m_vertexIndex[1] && this.ceBndInd.m_data[this.size[4] - 1] == this.m_vertexIndex[0])) {
                        this.ceDd = true;
                    }
                    if (this.ceDd) {
                        if (this.size[4] == 3 && this.ceBndInd.m_data[0] == this.ceBndInd.m_data[2]) {
                            this.m_index2[0] = -1;
                            this.m_index2[1] = -1;
                            this.ll = 0;
                            while (this.ll < this.size[2]) {
                                this.kk = 0;
                                while (this.kk < this.size[3]) {
                                    if (this.m_elementsAtVertex[this.m_vertexIndex[1]].m_data[this.kk] == this.m_elementsAtVertex[this.m_vertexIndex[0]].m_data[this.ll]) {
                                        this.ceElement = this.m_element[this.m_elementsAtVertex[this.m_vertexIndex[0]].m_data[this.ll]];
                                        this.size[5] = this.ceElement.getSize();
                                        this.mm = 0;
                                        while (this.mm < this.size[5]) {
                                            if (this.ceElement.m_data[this.mm] == this.m_vertexIndex[0] && (this.ceElement.m_data[(this.mm + 1) % this.size[5]] == this.m_vertexIndex[1] || this.ceElement.m_data[(this.mm - 1 + this.size[5]) % this.size[5]] == this.m_vertexIndex[1])) {
                                                if (this.m_index2[0] == -1) {
                                                    this.m_index2[0] = this.m_elementsAtVertex[this.m_vertexIndex[0]].m_data[this.ll];
                                                } else {
                                                    this.m_index2[1] = this.m_elementsAtVertex[this.m_vertexIndex[0]].m_data[this.ll];
                                                }
                                            }
                                            ++this.mm;
                                        }
                                    }
                                    ++this.kk;
                                }
                                ++this.ll;
                            }
                            this.kk = 0;
                            while (this.kk < 2) {
                                this.ceElement = this.m_element[this.m_index2[this.kk]];
                                this.size[5] = this.ceElement.getSize();
                                this.ll = 0;
                                while (this.ll < this.size[5]) {
                                    if (this.ceElement.m_data[this.ll] == this.m_vertexIndex[this.kk]) {
                                        if (this.ceElement.m_data[(this.ll + 1) % this.size[5]] == this.m_vertexIndex[1]) {
                                            this.m_index2[this.kk + 2] = (this.ll - 1 + this.size[5]) % this.size[5];
                                        }
                                        if (this.ceElement.m_data[(this.ll - 1 + this.size[5]) % this.size[5]] == this.m_vertexIndex[1]) {
                                            this.m_index2[this.kk + 2] = (this.ll - 2 + this.size[5]) % this.size[5];
                                        }
                                    }
                                    ++this.ll;
                                }
                                ++this.kk;
                            }
                            this.m_neighbour[this.m_index2[0]].m_data[this.m_index2[2]] = this.m_index2[1];
                            this.m_neighbour[this.m_index2[1]].m_data[this.m_index2[3]] = this.m_index2[0];
                            this.ceBndInd.m_data[1] = this.ceBndInd.m_data[0];
                            this.ceRemoveBnd = true;
                            this.ceBndInd.setTag(2);
                        } else {
                            if (this.ceRemoveBnd) {
                                this.replaceBndVertex(0, 0);
                            }
                            return true;
                        }
                    }
                }
                ++this.ii;
            }
        }
        if (this.ceRemoveBnd) {
            this.replaceBndVertex(0, 0);
        }
        return false;
    }

    private void replaceBndVertex(int n, int n2) {
        if (!this.m_hasBoundary) {
            return;
        }
        this.kk = 0;
        while (this.kk < this.m_numBnd) {
            if (!this.m_bndList[this.kk].hasTag(2)) {
                this.size[6] = this.m_bndList[this.kk].getSize();
                this.m_index2[8] = -1;
                this.count[2] = 0;
                this.ll = 0;
                while (this.ll < this.size[6]) {
                    if (this.m_bndList[this.kk].m_data[this.ll] == n) {
                        this.m_bndList[this.kk].m_data[this.ll] = n2;
                    }
                    if (this.m_bndList[this.kk].m_data[this.ll] != this.m_index2[8]) {
                        int n3 = this.count[2];
                        this.count[2] = n3 + 1;
                        this.m_bndList[this.kk].m_data[n3] = this.m_bndList[this.kk].m_data[this.ll];
                        this.m_index2[8] = this.m_bndList[this.kk].m_data[this.ll];
                    }
                    ++this.ll;
                }
                if (this.count[2] < 2) {
                    this.m_bndList[this.kk].setTag(2);
                }
                this.m_bndList[this.kk].setSize(this.count[2]);
            }
            ++this.kk;
        }
    }

    public int simplify() {
        int n = -1;
        if (this.m_sliderType == 0) {
            n = this.simplifyByFactor(1.0 * (double)this.m_targetNumber.getValue() / 100.0);
        } else if (this.m_sliderType == 1) {
            n = this.simplify(this.m_targetNumber.getValue());
        }
        this.updateSlider();
        return n;
    }

    public int simplifyByFactor(double d) {
        if (this.m_elementSet == null) {
            PsDebug.warning((String)"missing geometry");
            return -1;
        }
        if (d <= 0.0 || d > 1.0) {
            PsDebug.warning((String)("fac out of range (0,1], fac = " + d));
            return -1;
        }
        this.simplify((int)((double)this.m_elementSet.getNumElements() * d));
        return this.m_elementSet.getNumElements();
    }

    public int simplify(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = this.m_elementSet.getNumElements();
        if (n8 == n) {
            return 0;
        }
        if (!this.prepare()) {
            PsDebug.warning((String)"missing or empty geometry");
            return -1;
        }
        if (this.m_elementSet.getDimOfVertices() != 3) {
            this.m_bCheckNormals = false;
        }
        int n9 = 0;
        int n10 = 5 * this.m_edgeList[0].getSize();
        int n11 = 0;
        if (this.m_bGenerateVertexMap) {
            n7 = this.m_elementSet.getNumVertices();
            this.m_vertexMap.setSize(n7);
            for (n6 = 0; n6 < n7; ++n6) {
                this.m_vertexMap.m_data[n6] = n6;
            }
        }
        while (n < this.m_numEl && this.m_maxIndex >= 0 && n9 < n10) {
            this.m_edgeNr = this.m_index.m_data[0];
            for (n6 = 0; n6 < 2; ++n6) {
                this.m_vertexIndex[n6] = this.m_edgeList[n6].m_data[this.m_edgeNr];
            }
            if ((!this.m_bBigNeighbourhood || this.m_bBigNeighbourhood && !this.m_isDenied[this.m_edgeNr]) && !this.checkEdge() && this.checkNewElements() && this.checkNormalAngles(true)) {
                this.removeEdge();
                n10 = 5 * this.m_maxIndex;
                n9 = 0;
                if (this.m_infoPanel == null || (n7 = 100 * (this.m_targetNumber.getMax() - this.m_numEl) / (this.m_targetNumber.getMax() - this.m_targetNumber.getValue())) == n11) continue;
                ((TextComponent)this.m_infoPanel.m_tNumEl).setText(String.valueOf(this.m_numEl));
                n11 = n7;
                continue;
            }
            this.m_isDenied[this.m_index.m_data[0]] = true;
            if (this.m_minValue.m_data[this.m_index.m_data[0]] < 1.0E-10) {
                this.m_minValue.m_data[this.m_index.m_data[0]] = 1.0;
            } else {
                int n12 = this.m_index.m_data[0];
                this.m_minValue.m_data[n12] = this.m_minValue.m_data[n12] * 2.0;
            }
            this.valueChanged(0);
            if (++n9 != n10) continue;
            n7 = 1;
            for (n6 = 0; n6 <= this.m_maxIndex; ++n6) {
                if (this.m_isDenied[this.m_index.m_data[n6]]) continue;
                n7 = 0;
            }
            if (n7 == 0) {
                n9 = 0;
                continue;
            }
            if (!this.m_bForceSimplify) {
                n5 = 1;
                if (!this.m_bBigNeighbourhood) {
                    n4 = this.m_edgeList[0].getSize();
                    for (n6 = 0; n6 < n4; ++n6) {
                        if (this.m_location.m_data[n6] == -1) continue;
                        this.computeMinimum(n6);
                        this.valueChanged(this.m_location.m_data[n6]);
                    }
                    for (n6 = 0; n6 <= this.m_maxIndex; ++n6) {
                        this.m_edgeNr = this.m_index.m_data[n6];
                        for (n3 = 0; n3 < 2; ++n3) {
                            this.m_vertexIndex[n3] = this.m_edgeList[n3].m_data[this.m_edgeNr];
                        }
                        if (this.checkEdge() || !this.checkNewElements() || !this.checkNormalAngles(false)) continue;
                        this.m_isDenied[this.m_index.m_data[n6]] = false;
                        n5 = 0;
                        n9 = 0;
                    }
                }
                if (n5 == 0) continue;
                PsDebug.message((String)"Simplifying stopped before reaching given number of elements because of normal or thin triangle criterium");
                continue;
            }
            n5 = 1;
            n4 = 0;
            n2 = this.m_edgeList[0].getSize();
            for (n6 = 0; n6 < n2; ++n6) {
                if (this.m_location.m_data[n6] == -1) continue;
                this.computeMinimum(n6);
                this.valueChanged(this.m_location.m_data[n6]);
            }
            if (!this.m_bBigNeighbourhood) {
                for (n6 = 0; n6 <= this.m_maxIndex; ++n6) {
                    this.m_edgeNr = this.m_index.m_data[n6];
                    for (n3 = 0; n3 < 2; ++n3) {
                        this.m_vertexIndex[n3] = this.m_edgeList[n3].m_data[this.m_edgeNr];
                    }
                    if (this.checkEdge()) {
                        ++n4;
                        continue;
                    }
                    if (!this.checkNewElements() || !this.checkNormalAngles(false)) continue;
                    this.m_isDenied[this.m_index.m_data[n6]] = false;
                    n5 = 0;
                    n9 = 0;
                }
            } else {
                for (n6 = 0; n6 <= this.m_maxIndex; ++n6) {
                    this.m_edgeNr = this.m_index.m_data[n6];
                    for (n3 = 0; n3 < 2; ++n3) {
                        this.m_vertexIndex[n3] = this.m_edgeList[n3].m_data[this.m_edgeNr];
                    }
                    if (!this.checkEdge()) continue;
                    ++n4;
                }
            }
            if (n4 <= this.m_maxIndex) {
                if (n5 == 0) continue;
                if (this.m_maxAngle < 180.0) {
                    this.m_maxAngle += 2.5;
                }
                this.m_minInOut *= 0.9;
                n9 = 0;
                continue;
            }
            PsDebug.warning((String)"Simplifying stopped before reaching given number of elements to avoid degenerating of surface");
        }
        this.m_elementSet.setVertices(this.m_vertex);
        this.m_elementSet.setElements(this.m_element);
        this.m_elementSet.setNeighbours(this.m_neighbour);
        if (this.m_hasElementTextures) {
            this.m_elementSet.setElementTextures(this.m_elementTexture);
        }
        if (this.m_hasVertexTextures) {
            this.m_elementSet.setVertexTextures(this.m_vertexTexture);
        }
        if (this.m_hasVertexColors) {
            this.m_elementSet.setVertexColors(this.m_vertexColor);
        }
        this.m_elementSet.removeMarkedElements();
        this.m_elementSet.makeNeighbour();
        if (this.m_hasVertexNormals) {
            this.m_elementSet.makeVertexNormals();
        }
        if (this.m_hasBoundary) {
            n7 = 0;
            for (n6 = 0; n6 < this.m_numBnd; ++n6) {
                n5 = this.m_bndList[n6].getSize();
                if (this.m_bndList[n6].hasTag(2) || n5 == 3 && this.m_bndList[n6].m_data[0] == this.m_bndList[n6].m_data[2]) continue;
                ++n7;
            }
            if (n7 > 0) {
                this.m_elementSet.assureBoundary(n7);
                PgBndPolygon[] pgBndPolygonArray = this.m_elementSet.getBoundaries();
                n4 = 0;
                for (n6 = 0; n6 < this.m_numBnd; ++n6) {
                    n2 = this.m_bndList[n6].getSize();
                    if (this.m_bndList[n6].hasTag(2) || n2 == 3 && this.m_bndList[n6].m_data[0] == this.m_bndList[n6].m_data[2]) continue;
                    pgBndPolygonArray[n4].setNumVertices(n2);
                    pgBndPolygonArray[n4].getVertexInd().copy(0, this.m_bndList[n6], 0, n2);
                    if (!pgBndPolygonArray[n4].makeElementInd()) {
                        this.m_elementSet.removeBoundaries();
                        break;
                    }
                    ++n4;
                }
            } else {
                this.m_elementSet.removeBoundaries();
            }
        }
        if (this.m_bGenerateVertexMap) {
            n7 = this.m_elementSet.getNumVertices();
            for (n6 = 0; n6 < n7; ++n6) {
                if (this.m_vertexMap.m_data[n6] == n6) continue;
                while (this.m_vertexMap.m_data[this.m_vertexMap.m_data[n6]] != this.m_vertexMap.m_data[n6]) {
                    this.m_vertexMap.m_data[n6] = this.m_vertexMap.m_data[this.m_vertexMap.m_data[n6]];
                }
                this.m_elementSet.setTagVertex(n6, 2);
            }
            int n13 = this.m_elementSet.getNumElements();
            for (n6 = 0; n6 < n13; ++n6) {
                PiVector piVector = this.m_elementSet.getElement(n6);
                n2 = piVector.getSize();
                for (n3 = 0; n3 < n2; ++n3) {
                    this.m_elementSet.clearTagVertex(piVector.m_data[n3], 2);
                }
            }
            int[] nArray = this.m_elementSet.removeMarkedVertices();
            for (n6 = 0; n6 < n7; ++n6) {
                this.m_vertexMap.m_data[n6] = nArray[this.m_vertexMap.m_data[n6]];
            }
        } else {
            this.m_elementSet.removeUnusedVertices();
        }
        return this.m_elementSet.getNumElements();
    }

    public boolean update(Object object) {
        if (object == null || this.isUpdateSender()) {
            return super.update(null);
        }
        if (object == this) {
            if (this.m_bShowNumTriangles && this.m_labelGeom != null) {
                this.m_labelGeom.setName("" + this.m_elementSet.getNumElements() + " " + PsConfig.getMessage((int)54464));
            }
            this.setUpdateSender(true);
            if (this.m_labelGeom != null) {
                this.m_labelGeom.update((Object)this.m_labelGeom);
            }
            this.setUpdateSender(false);
            return super.update((Object)this);
        }
        if (object == this.m_targetNumber) {
            if (this.m_sliderType == 0) {
                if (this.m_targetNumber.getValue() == this.m_percentSliderValue) {
                    return true;
                }
                this.m_percentSliderValue = this.m_targetNumber.getValue();
                int n = this.m_elementSet.getNumElements();
                this.m_absoluteSliderValue = n * this.m_percentSliderValue / 100;
            } else if (this.m_sliderType == 1) {
                if (this.m_targetNumber.getValue() == this.m_absoluteSliderValue) {
                    return true;
                }
                this.m_absoluteSliderValue = this.m_targetNumber.getValue();
                int n = this.m_elementSet.getNumElements();
                this.m_percentSliderValue = this.m_absoluteSliderValue * 100 / n;
            }
            return true;
        }
        return super.update(object);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

