/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.awt.Color;
import jv.geom.PgBndPolygon;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.number.PdColor;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jvx.geom.PgVertexStar;
import jvx.geom.PwCleanMesh;
import jvx.geom.PwModel;
import jvx.geom.PwRivaraBisection;
import jvx.project.PjWorkshop;

public class PwRefineElementSet
extends PjWorkshop {
    public static final int REFINE_GLOBAL_INTO_FOUR = 0;
    public static final int REFINE_RIVARA = 1;
    public static final int REFINE_DOO_SABIN = 2;
    public static final int REFINE_BUTTERFLY = 3;
    public static final int REFINE_QUADRISECTION = 4;
    public static final int REFINE_CATMULL_CLARK = 5;
    public static final int REFINE_LOOP = 6;
    public static final int REFINE_SQRT3 = 7;
    public static final int REFINE_SQRT2 = 8;
    public static final int REFINE_BARYCENTRIC = 9;
    public static final int REFINE_SQRT2_QUAD = 10;
    public static final int REFINE_SQRT2_QUAD_FLAT = 11;
    public static final int REFINE_SPLIT_CENTRAL = 12;
    protected PgElementSet m_controlElementSet;
    protected PiVector m_refineSequence = new PiVector();
    protected boolean m_bShowingControl = false;
    protected int m_lastRefinement = 5;
    static /* synthetic */ Class class$jvx$geom$PwRefineElementSet;

    public PwRefineElementSet() {
        super(PsConfig.getMessage((int)48011));
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PwRefineElementSet == null ? (class$jvx$geom$PwRefineElementSet = PwRefineElementSet.class$("jvx.geom.PwRefineElementSet")) : class$jvx$geom$PwRefineElementSet)) {
            this.init();
        }
    }

    public void setGeometry(PgElementSet pgElementSet) {
        super.setGeometry((PgGeometry)pgElementSet);
        this.m_controlElementSet = (PgElementSet)pgElementSet.clone();
        this.m_controlElementSet.setName(PsConfig.getMessage((int)45042) + " " + pgElementSet.getName());
        this.m_controlElementSet.showElements(false);
        this.m_controlElementSet.showVertices(true);
        this.m_controlElementSet.setGlobalVertexSize(3.0);
        this.m_controlElementSet.setGlobalVertexColor(Color.blue);
        this.m_controlElementSet.showEdges(true);
        this.m_controlElementSet.setGlobalEdgeSize(2.0);
        this.m_controlElementSet.setGlobalEdgeColor(Color.red);
        this.m_controlElementSet.showBoundaries(false);
        this.m_controlElementSet.showTaggedElements(true);
        this.m_refineSequence.setSize(0);
    }

    public boolean update(Object object) {
        if (object == this.m_controlElementSet) {
            this.sequenceRefine();
            return super.update((Object)this);
        }
        return super.update(object);
    }

    public void reset() {
        super.reset();
        this.m_refineSequence.setSize(0);
        if (this.m_geom == null) {
            return;
        }
        this.m_geom.copy((PsObject)this.m_geomSave);
        this.m_controlElementSet.copy((PsObject)this.m_geom);
        this.m_controlElementSet.setName(PsConfig.getMessage((int)45042) + " " + this.m_geom.getName());
        this.m_controlElementSet.showElements(false);
        this.m_controlElementSet.showVertices(true);
        this.m_controlElementSet.setGlobalVertexSize(3.0);
        this.m_controlElementSet.setGlobalVertexColor(Color.blue);
        this.m_controlElementSet.showVertexColors(false);
        this.m_controlElementSet.showEdges(true);
        this.m_controlElementSet.setGlobalEdgeSize(2.0);
        this.m_controlElementSet.setGlobalEdgeColor(Color.red);
        this.m_controlElementSet.showBoundaries(false);
        this.m_controlElementSet.showTaggedElements(true);
        this.m_controlElementSet.update((Object)this.m_controlElementSet);
    }

    public boolean isShowingControlGrid() {
        return this.m_bShowingControl;
    }

    public void showControlGrid(boolean bl) {
        if (bl) {
            if (!this.m_display.containsGeometry((PgGeometryIf)this.m_controlElementSet)) {
                this.m_display.addGeometry((PgGeometryIf)this.m_controlElementSet);
            }
            this.m_display.selectGeometry((PgGeometryIf)this.m_controlElementSet);
            this.m_controlElementSet.addUpdateListener((PsUpdateIf)this);
        } else {
            if (this.m_display.containsGeometry((PgGeometryIf)this.m_controlElementSet)) {
                this.m_display.removeGeometry((PgGeometryIf)this.m_controlElementSet);
                this.m_display.selectGeometry((PgGeometryIf)this.m_geom);
            }
            if (this.m_controlElementSet != null && this.m_controlElementSet.hasUpdateListener((PsUpdateIf)this)) {
                this.m_controlElementSet.removeUpdateListener((PsUpdateIf)this);
            }
        }
        this.m_bShowingControl = bl;
    }

    public void close() {
        this.showControlGrid(false);
        this.m_controlElementSet = null;
        this.m_refineSequence.setSize(0);
        super.close();
    }

    public void undo() {
        int n = this.m_refineSequence.getSize();
        if (n == 0) {
            return;
        }
        this.m_lastRefinement = this.m_refineSequence.getLastEntry();
        this.m_refineSequence.setSize(n - 1);
        this.sequenceRefine();
    }

    private void sequenceRefine() {
        String string = this.m_controlElementSet.getName();
        this.m_controlElementSet.setName(this.m_geom.getName());
        boolean bl = this.m_controlElementSet.isShowingElements();
        this.m_controlElementSet.showElements(((PgElementSet)this.m_geom).isShowingElements());
        boolean bl2 = this.m_controlElementSet.isShowingVertices();
        this.m_controlElementSet.showVertices(((PgElementSet)this.m_geom).isShowingVertices());
        double d = this.m_controlElementSet.getGlobalVertexSize();
        this.m_controlElementSet.setGlobalVertexSize(((PgElementSet)this.m_geom).getGlobalVertexSize());
        Color color = this.m_controlElementSet.getGlobalVertexColor();
        this.m_controlElementSet.setGlobalVertexColor(((PgElementSet)this.m_geom).getGlobalVertexColor());
        boolean bl3 = this.m_controlElementSet.isShowingVertexColors();
        this.m_controlElementSet.showVertexColors(((PgElementSet)this.m_geom).isShowingVertexColors());
        boolean bl4 = this.m_controlElementSet.isShowingEdges();
        this.m_controlElementSet.showEdges(((PgElementSet)this.m_geom).isShowingEdges());
        double d2 = this.m_controlElementSet.getGlobalEdgeSize();
        this.m_controlElementSet.setGlobalEdgeSize(((PgElementSet)this.m_geom).getGlobalEdgeSize());
        Color color2 = this.m_controlElementSet.getGlobalEdgeColor();
        this.m_controlElementSet.setGlobalEdgeColor(((PgElementSet)this.m_geom).getGlobalEdgeColor());
        boolean bl5 = this.m_controlElementSet.isShowingBoundaries();
        this.m_controlElementSet.showBoundaries(((PgElementSet)this.m_geom).isShowingBoundaries());
        boolean bl6 = this.m_controlElementSet.isShowingTaggedElements();
        this.m_controlElementSet.showTaggedElements(((PgElementSet)this.m_geom).isShowingTaggedElements());
        boolean bl7 = this.m_controlElementSet.isShowingTransparency();
        this.m_controlElementSet.showTransparency(((PgElementSet)this.m_geom).isShowingTransparency());
        double d3 = this.m_controlElementSet.getTransparency();
        this.m_controlElementSet.setTransparency(((PgElementSet)this.m_geom).getTransparency());
        this.m_geom.copy((PsObject)this.m_controlElementSet);
        this.m_controlElementSet.setName(string);
        this.m_controlElementSet.showElements(bl);
        this.m_controlElementSet.showVertices(bl2);
        this.m_controlElementSet.setGlobalVertexSize(d);
        this.m_controlElementSet.setGlobalVertexColor(color);
        this.m_controlElementSet.showVertexColors(bl3);
        this.m_controlElementSet.showEdges(bl4);
        this.m_controlElementSet.setGlobalEdgeSize(d2);
        this.m_controlElementSet.setGlobalEdgeColor(color2);
        this.m_controlElementSet.showBoundaries(bl5);
        this.m_controlElementSet.showTaggedElements(bl6);
        this.m_controlElementSet.showTransparency(bl7);
        this.m_controlElementSet.setTransparency(d3);
        int n = this.m_refineSequence.getSize();
        if (n == 0) {
            return;
        }
        PiVector piVector = (PiVector)this.m_refineSequence.clone();
        this.m_refineSequence.setSize(0);
        block15: for (int i = 0; i < n; ++i) {
            int n2 = piVector.getEntry(i);
            switch (n2) {
                case 0: {
                    this.refineGlobalIntoFour();
                    continue block15;
                }
                case 1: {
                    this.refineRivara();
                    continue block15;
                }
                case 2: {
                    this.refineDooSabin();
                    continue block15;
                }
                case 3: {
                    this.refineButterfly();
                    continue block15;
                }
                case 4: {
                    this.refineQuadrisection();
                    continue block15;
                }
                case 5: {
                    this.refineCatmullClark();
                    continue block15;
                }
                case 6: {
                    this.refineLoop();
                    continue block15;
                }
                case 7: {
                    this.refineSqrt3();
                    continue block15;
                }
                case 8: {
                    this.refineSqrt2();
                    continue block15;
                }
                case 9: {
                    this.refineBarycentric();
                    continue block15;
                }
                case 10: {
                    this.refineQuadSqrt2();
                    continue block15;
                }
                case 11: {
                    this.refineQuadSqrt2Flat();
                    continue block15;
                }
                case 12: {
                    this.refineSplitCentral();
                    continue block15;
                }
                default: {
                    PsDebug.warning((String)("unknown refinement ID = " + String.valueOf(n2)));
                }
            }
        }
    }

    public void refineGlobalIntoFour() {
        this.m_refineSequence.addEntry(0);
        PgElementSet pgElementSet = (PgElementSet)this.m_geom;
        if (pgElementSet.getDimOfElements() != 3) {
            PgElementSet.triangulate((PgElementSet)pgElementSet);
        }
        if (!pgElementSet.checkNeighbour(false)) {
            pgElementSet.makeNeighbour();
        }
        pgElementSet.refineGlobalIntoFour(true);
    }

    public void refineRivara() {
        PwRivaraBisection pwRivaraBisection;
        int n;
        this.m_refineSequence.addEntry(1);
        PgElementSet pgElementSet = (PgElementSet)this.m_geom;
        if (pgElementSet.getDimOfElements() != 3) {
            PgElementSet.triangulate((PgElementSet)pgElementSet);
        }
        if (!pgElementSet.checkNeighbour(false)) {
            pgElementSet.makeNeighbour();
        }
        PiVector[] piVectorArray = pgElementSet.getElements();
        int n2 = pgElementSet.getNumElements();
        int n3 = pgElementSet.getNumVertices();
        int n4 = 0;
        for (n = 0; n < n2; ++n) {
            if (!piVectorArray[n].hasTag(1)) continue;
            ++n4;
        }
        if (n4 == 0) {
            PsDebug.warning((String)"no elements marked for refinement.");
        } else {
            int[] nArray = new int[n4];
            n4 = 0;
            for (int i = 0; i < n2; ++i) {
                if (!piVectorArray[i].hasTag(1)) continue;
                nArray[n4++] = i;
            }
            pwRivaraBisection = new PwRivaraBisection();
            pwRivaraBisection.rivaraRefinement(pgElementSet, nArray);
        }
        n = pgElementSet.getNumElements();
        for (int i = n2; i < n; ++i) {
            pwRivaraBisection = pgElementSet.getElement(i);
            PiVector piVector = pgElementSet.getNeighbour(i);
            int n5 = 0;
            for (int j = 0; j < 3; ++j) {
                if (((PiVector)pwRivaraBisection).m_data[j] < n3) continue;
                ++n5;
            }
            if (n5 == 1) {
                if (!pgElementSet.hasTagElement(piVector.m_data[1], 1)) continue;
                pgElementSet.setTagElement(i, 1);
                continue;
            }
            if (((PiVector)pwRivaraBisection).m_data[2] < n3) {
                piVector = pgElementSet.getNeighbour(piVector.m_data[2]);
                if (!pgElementSet.hasTagElement(piVector.m_data[0], 1)) continue;
                pgElementSet.setTagElement(i, 1);
                continue;
            }
            if (piVector.m_data[1] < n2) {
                if (!pgElementSet.hasTagElement(piVector.m_data[1], 1)) continue;
                pgElementSet.setTagElement(i, 1);
                continue;
            }
            if (!pgElementSet.hasTagElement(piVector.m_data[0], 1)) continue;
            pgElementSet.setTagElement(i, 1);
        }
    }

    public void refineDooSabin() {
        this.m_refineSequence.addEntry(2);
        PgElementSet pgElementSet = (PgElementSet)this.m_geom;
        pgElementSet.removeUnusedVertices();
        if (!pgElementSet.checkNeighbour(false)) {
            pgElementSet.makeNeighbour();
        }
        PwCleanMesh.splitNonManifoldVertices(pgElementSet);
        PwRefineElementSet.refineDooSabin(pgElementSet);
    }

    public void refineButterfly() {
        this.m_refineSequence.addEntry(3);
        PwRefineElementSet.refineIntoFour((PgElementSet)this.m_geom, 3);
    }

    public void refineLoop() {
        this.m_refineSequence.addEntry(6);
        PwRefineElementSet.refineIntoFour((PgElementSet)this.m_geom, 6);
    }

    public void refineBarycentric() {
        this.m_refineSequence.addEntry(9);
        PwRefineElementSet.refineBarycentric((PgElementSet)this.m_geom);
    }

    public static void refineIntoFour(PgElementSet pgElementSet, int n) {
        Object object;
        int n2;
        if (pgElementSet.getDimOfElements() != 3) {
            PgElementSet.triangulate((PgElementSet)pgElementSet);
        }
        if (!pgElementSet.checkNeighbour(false)) {
            pgElementSet.makeNeighbour();
        }
        if (n == 6) {
            pgElementSet.removeUnusedVertices();
        }
        int n3 = pgElementSet.getNumEdges();
        PdVector[] pdVectorArray = new PdVector[n3];
        PiVector[] piVectorArray = pgElementSet.getNeighbours();
        PiVector[] piVectorArray2 = pgElementSet.getElements();
        int n4 = pgElementSet.getNumVertices();
        int n5 = pgElementSet.getNumElements();
        int n6 = 0;
        boolean bl = pgElementSet.hasVertexTextures();
        PdVector[] pdVectorArray2 = null;
        if (n == 6 && bl) {
            pdVectorArray2 = new PdVector[n4 + n3];
        }
        for (n2 = n5 - 1; n2 >= 0; --n2) {
            for (int i = 0; i < 3; ++i) {
                if (piVectorArray[n2].m_data[i] >= n2) continue;
                if (n == 3) {
                    pdVectorArray[n6] = piVectorArray[n2].m_data[i] != -1 ? PwRefineElementSet.schemeButterfly(n2, i, piVectorArray[n2].m_data[i], pgElementSet.getOppVertexLocInd(n2, i), pgElementSet) : PwRefineElementSet.schemeDlg(n2, i, pgElementSet);
                } else if (n == 6) {
                    pdVectorArray[n6] = piVectorArray[n2].m_data[i] != -1 ? PdVector.blendNew((double)0.375, (PdVector)pgElementSet.getVertex(piVectorArray2[n2].m_data[(i + 1) % 3]), (double)0.375, (PdVector)pgElementSet.getVertex(piVectorArray2[n2].m_data[(i + 2) % 3]), (double)0.125, (PdVector)pgElementSet.getVertex(piVectorArray2[n2].m_data[i]), (double)0.125, (PdVector)pgElementSet.getVertex(piVectorArray2[piVectorArray[n2].m_data[i]].m_data[pgElementSet.getOppVertexLocInd(n2, i)])) : PdVector.blendNew((double)0.5, (PdVector)pgElementSet.getVertex(piVectorArray2[n2].m_data[(i + 1) % 3]), (double)0.5, (PdVector)pgElementSet.getVertex(piVectorArray2[n2].m_data[(i + 2) % 3]));
                    if (bl) {
                        pdVectorArray2[n4 + n6] = piVectorArray[n2].m_data[i] != -1 ? PdVector.blendNew((double)0.375, (PdVector)pgElementSet.getVertexTexture(piVectorArray2[n2].m_data[(i + 1) % 3]), (double)0.375, (PdVector)pgElementSet.getVertexTexture(piVectorArray2[n2].m_data[(i + 2) % 3]), (double)0.125, (PdVector)pgElementSet.getVertexTexture(piVectorArray2[n2].m_data[i]), (double)0.125, (PdVector)pgElementSet.getVertexTexture(piVectorArray2[piVectorArray[n2].m_data[i]].m_data[pgElementSet.getOppVertexLocInd(n2, i)])) : PdVector.blendNew((double)0.5, (PdVector)pgElementSet.getVertexTexture(piVectorArray2[n2].m_data[(i + 1) % 3]), (double)0.5, (PdVector)pgElementSet.getVertexTexture(piVectorArray2[n2].m_data[(i + 2) % 3]));
                    }
                } else {
                    object = piVectorArray2[n2];
                    pdVectorArray[n6] = PdVector.blendNew((double)0.5, (PdVector)pgElementSet.getVertex(object.m_data[(i + 3 - 1) % 3]), (double)0.5, (PdVector)pgElementSet.getVertex(object.m_data[(i + 1) % 3]));
                }
                ++n6;
            }
        }
        if (n == 6) {
            PgVertexStar pgVertexStar = new PgVertexStar();
            PdVector[] pdVectorArray3 = new PdVector[n4];
            object = new boolean[n4];
            for (int i = 0; i < n5; ++i) {
                int n7 = piVectorArray2[i].getSize();
                for (int j = 0; j < n7; ++j) {
                    int n8;
                    PiVector piVector;
                    int n9;
                    PgBndPolygon[] pgBndPolygonArray;
                    int n10;
                    int n11 = piVectorArray2[i].m_data[j];
                    if (object[n11]) continue;
                    object[n11] = true;
                    pgVertexStar.makeVertexStar(pgElementSet, n11, i);
                    PiVector piVector2 = pgVertexStar.getLink();
                    int n12 = pgVertexStar.getSize();
                    pdVectorArray3[n11] = (PdVector)pgElementSet.getVertex(n11).clone();
                    if (pgVertexStar.isClosed()) {
                        double d = -PuMath.sqr((double)(0.375 + 0.25 * Math.cos(Math.PI * 2 / (double)n12))) + 0.625;
                        pdVectorArray3[n11].multScalar(1.0 - d);
                        d /= (double)n12;
                        for (n10 = 0; n10 < n12; ++n10) {
                            pdVectorArray3[n11].blendBase(pdVectorArray3[n11], d, pgElementSet.getVertex(piVector2.m_data[n10]));
                        }
                    } else {
                        boolean bl2 = false;
                        if (pgElementSet.hasBoundary()) {
                            pgBndPolygonArray = pgElementSet.getBoundaries();
                            n10 = pgBndPolygonArray.length;
                            for (n9 = 0; n9 < n10; ++n9) {
                                piVector = pgBndPolygonArray[n9].getVertexInd();
                                n8 = pgBndPolygonArray[n9].getNumVertices();
                                if (piVector.m_data[0] != n11 && piVector.m_data[n8 - 1] != n11) continue;
                                bl2 = true;
                            }
                        }
                        if (!bl2) {
                            pdVectorArray3[n11].blend(0.75, pdVectorArray3[n11], 0.125, pgElementSet.getVertex(piVector2.m_data[0]), 0.125, pgElementSet.getVertex(piVector2.m_data[n12]));
                        }
                    }
                    if (!bl) continue;
                    pdVectorArray2[n11] = (PdVector)pgElementSet.getVertexTexture(n11).clone();
                    if (pgVertexStar.isClosed()) {
                        double d = -PuMath.sqr((double)(0.375 + 0.25 * Math.cos(Math.PI * 2 / (double)n12))) + 0.625;
                        pdVectorArray2[n11].multScalar(1.0 - d);
                        d /= (double)n12;
                        for (n10 = 0; n10 < n12; ++n10) {
                            pdVectorArray2[n11].blendBase(pdVectorArray2[n11], d, pgElementSet.getVertexTexture(piVector2.m_data[n10]));
                        }
                        continue;
                    }
                    boolean bl3 = false;
                    if (pgElementSet.hasBoundary()) {
                        pgBndPolygonArray = pgElementSet.getBoundaries();
                        n10 = pgBndPolygonArray.length;
                        for (n9 = 0; n9 < n10; ++n9) {
                            piVector = pgBndPolygonArray[n9].getVertexInd();
                            n8 = pgBndPolygonArray[n9].getNumVertices();
                            if (piVector.m_data[0] != n11 && piVector.m_data[n8 - 1] != n11) continue;
                            bl3 = true;
                        }
                    }
                    if (bl3) continue;
                    pdVectorArray2[n11].blend(0.75, pdVectorArray2[n11], 0.125, pgElementSet.getVertexTexture(piVector2.m_data[0]), 0.125, pgElementSet.getVertexTexture(piVector2.m_data[n12]));
                }
            }
            pgElementSet.setVertices(pdVectorArray3);
        }
        pgElementSet.refineGlobalIntoFour(false);
        if (n == 6 && bl) {
            pgElementSet.setVertexTextures(pdVectorArray2);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            pgElementSet.setVertex(n2 + n4, pdVectorArray[n2]);
        }
        if (pgElementSet.hasVertexNormals()) {
            pgElementSet.makeVertexNormals();
        }
        if (pgElementSet.hasElementNormals()) {
            pgElementSet.makeElementNormals();
        }
        if (pgElementSet.isEnabledEdges()) {
            pgElementSet.makeEdgeStars();
        }
    }

    public static void refineBarycentric(PgElementSet pgElementSet) {
        int n;
        int n2;
        int n3;
        int n4;
        PdVector pdVector;
        if (!pgElementSet.checkNeighbour(false)) {
            pgElementSet.makeNeighbour();
        }
        int n5 = pgElementSet.getNumElements();
        int n6 = pgElementSet.getNumVertices();
        int[] nArray = new int[n5];
        int n7 = 0;
        PiVector[] piVectorArray = pgElementSet.getElements();
        PiVector[] piVectorArray2 = pgElementSet.getNeighbours();
        int n8 = n6 + n5 + pgElementSet.getNumEdges();
        pgElementSet.setNumVertices(n8);
        for (int i = 0; i < n5; ++i) {
            int n9;
            Object object;
            int n10 = piVectorArray[i].getSize();
            nArray[i] = n7;
            n7 += 2 * n10;
            pgElementSet.setVertex(n6 + i, PgGeometry.getCenterOfElement(null, (PdVector[])pgElementSet.getVertices(), (int[])piVectorArray[i].m_data));
            if (pgElementSet.hasVertexColors()) {
                object = PdColor.blend((double)(1.0 / (double)n10), (Color)pgElementSet.getVertexColor(piVectorArray[i].m_data[0]), (double)(1.0 / (double)n10), (Color)pgElementSet.getVertexColor(piVectorArray[i].m_data[1]));
                for (n9 = 2; n9 < n10; ++n9) {
                    object = PdColor.blend((double)1.0, (Color)object, (double)(1.0 / (double)n10), (Color)pgElementSet.getVertexColor(piVectorArray[i].m_data[n9]));
                }
                pgElementSet.setVertexColor(n6 + i, (Color)object);
            }
            if (pgElementSet.hasVertexNormals()) {
                object = PdVector.copyNew((PdVector)pgElementSet.getVertexNormal(piVectorArray[i].m_data[0]));
                for (n9 = 1; n9 < n10; ++n9) {
                    object.add(pgElementSet.getVertexNormal(piVectorArray[i].m_data[n9]));
                }
                object.multScalar(1.0 / (double)n10);
                pgElementSet.setVertexNormal(n6 + i, object);
            }
            if (pgElementSet.hasVertexTextures()) {
                object = pgElementSet.getVertexTextures();
                PdVector pdVector2 = object[n6 + i];
                pdVector2.copy(object[piVectorArray[i].m_data[0]]);
                for (int j = 1; j < n10; ++j) {
                    pdVector2.add(object[piVectorArray[i].m_data[j]]);
                }
                pdVector2.multScalar(1.0 / (double)n10);
            }
            if (pgElementSet.getNumVectorFields() <= 0) continue;
            int n11 = pgElementSet.getNumVectorFields();
            for (int j = 0; j < n11; ++j) {
                PgVectorField pgVectorField = pgElementSet.getVectorField(j);
                if (pgVectorField.getBasedOn() != 0) continue;
                pgVectorField.setNumVectors(n6 + i + 1);
                pdVector = PdVector.copyNew((PdVector)pgVectorField.getVector(piVectorArray[i].m_data[0]));
                for (int k = 1; k < n10; ++k) {
                    pdVector.add(pgVectorField.getVector(piVectorArray[i].m_data[k]));
                }
                pdVector.multScalar(1.0 / (double)n10);
                pgVectorField.setVector(n6 + i, pdVector);
            }
        }
        PiVector[] piVectorArray3 = new PiVector[n7];
        PiVector[] piVectorArray4 = new PiVector[n7];
        Color[] colorArray = pgElementSet.getElementColors();
        Color[] colorArray2 = pgElementSet.getElementBackColors();
        PdVector[] pdVectorArray = pgElementSet.getElementNormals();
        pdVector = new PdVector[][]{};
        if (pgElementSet.hasBoundary()) {
            PgBndPolygon[] pgBndPolygonArray = pgElementSet.getBoundaries();
            n4 = pgBndPolygonArray.length;
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = pgBndPolygonArray[n3].getNumVertices();
                pgBndPolygonArray[n3].setNumVertices(2 * n2 - 1);
                PiVector piVector = pgBndPolygonArray[n3].getVertexInd();
                for (n = n2; n > 0; --n) {
                    piVector.m_data[2 * n - 2] = piVector.m_data[n - 1];
                }
            }
        }
        if (pgElementSet.hasElementTextures()) {
            pdVector = new PdVector[n7][3];
        }
        int n12 = n6 + n5;
        for (n4 = 0; n4 < n5; ++n4) {
            int n13;
            int n14;
            int n15;
            n3 = piVectorArray[n4].getSize();
            n2 = nArray[n4];
            for (n15 = 0; n15 < n3; ++n15) {
                n14 = 2 * n15;
                n = 2 * n15 + 1;
                piVectorArray3[n2 + n14] = new PiVector(3);
                piVectorArray4[n2 + n14] = new PiVector(3);
                piVectorArray3[n2 + n14].m_data[0] = n6 + n4;
                piVectorArray3[n2 + n14].m_data[1] = piVectorArray[n4].m_data[(n15 + 1) % n3];
                piVectorArray4[n2 + n14].m_data[1] = n2 + n;
                piVectorArray4[n2 + n14].m_data[2] = n2 + (n14 - 1 + 2 * n3) % (2 * n3);
                piVectorArray3[n2 + n] = new PiVector(3);
                piVectorArray4[n2 + n] = new PiVector(3);
                piVectorArray3[n2 + n].m_data[0] = n6 + n4;
                piVectorArray3[n2 + n].m_data[2] = piVectorArray[n4].m_data[(n15 + 2) % n3];
                piVectorArray4[n2 + n].m_data[1] = n2 + (n + 1) % (2 * n3);
                piVectorArray4[n2 + n].m_data[2] = n2 + n14;
            }
            for (n15 = 0; n15 < n3; ++n15) {
                int n16;
                int n17;
                PdVector pdVector3;
                if (piVectorArray2[n4].m_data[n15] >= n4) continue;
                pgElementSet.setVertex(n12, PdVector.blendNew((double)0.5, (PdVector)pgElementSet.getVertex(piVectorArray[n4].m_data[(n15 + 1) % n3]), (double)0.5, (PdVector)pgElementSet.getVertex(piVectorArray[n4].m_data[(n15 + 2) % n3])));
                if (pgElementSet.hasVertexColors()) {
                    pdVector3 = PdColor.blend((double)0.5, (Color)pgElementSet.getVertexColor(piVectorArray[n4].m_data[(n15 + 1) % n3]), (double)0.5, (Color)pgElementSet.getVertexColor(piVectorArray[n4].m_data[(n15 + 2) % n3]));
                    pgElementSet.setVertexColor(n12, (Color)pdVector3);
                }
                if (pgElementSet.hasVertexNormals()) {
                    pdVector3 = PdVector.blendNew((double)0.5, (PdVector)pgElementSet.getVertexNormal(piVectorArray[n4].m_data[(n15 + 1) % n3]), (double)0.5, (PdVector)pgElementSet.getVertexNormal(piVectorArray[n4].m_data[(n15 + 2) % n3]));
                    pgElementSet.setVertexNormal(n12, pdVector3);
                }
                if (pgElementSet.hasVertexTextures()) {
                    pdVector3 = pgElementSet.getVertexTextures();
                    pdVector3[n12] = PdVector.blendNew((double)0.5, (PdVector)pdVector3[piVectorArray[n4].m_data[(n15 + 1) % n3]], (double)0.5, (PdVector)pdVector3[piVectorArray[n4].m_data[(n15 + 2) % n3]]);
                }
                if (pgElementSet.getNumVectorFields() > 0) {
                    int n18 = pgElementSet.getNumVectorFields();
                    for (n13 = 0; n13 < n18; ++n13) {
                        PgVectorField pgVectorField = pgElementSet.getVectorField(n13);
                        if (pgVectorField.getBasedOn() != 0) continue;
                        pgVectorField.setNumVectors(n12 + 1);
                        pgVectorField.setVector(n12, PdVector.blendNew((double)0.5, (PdVector)pgVectorField.getVector(piVectorArray[n4].m_data[(n15 + 1) % n3]), (double)0.5, (PdVector)pgVectorField.getVector(piVectorArray[n4].m_data[(n15 + 2) % n3])));
                    }
                }
                n14 = 2 * n15;
                n = 2 * n15 + 1;
                piVectorArray3[n2 + n14].m_data[2] = n12;
                piVectorArray3[n2 + n].m_data[1] = n12;
                if (piVectorArray2[n4].m_data[n15] == -1) {
                    piVectorArray4[n2 + n14].m_data[0] = -1;
                    piVectorArray4[n2 + n].m_data[0] = -1;
                    if (pgElementSet.hasBoundary()) {
                        PgBndPolygon[] pgBndPolygonArray = pgElementSet.getBoundaries();
                        n13 = pgBndPolygonArray.length;
                        for (int i = 0; i < n13; ++i) {
                            n17 = pgBndPolygonArray[i].getNumVertices() / 2;
                            PiVector piVector = pgBndPolygonArray[i].getVertexInd();
                            for (n16 = 0; n16 < n17; ++n16) {
                                if ((piVector.m_data[2 * n16] != piVectorArray[n4].m_data[(n15 + 1) % n3] || piVector.m_data[2 * n16 + 2] != piVectorArray[n4].m_data[(n15 + 2) % n3]) && (piVector.m_data[2 * n16] != piVectorArray[n4].m_data[(n15 + 2) % n3] || piVector.m_data[2 * n16 + 2] != piVectorArray[n4].m_data[(n15 + 1) % n3])) continue;
                                piVector.m_data[2 * n16 + 1] = n12;
                            }
                        }
                    }
                } else {
                    int n19 = piVectorArray2[n4].m_data[n15];
                    n13 = piVectorArray[n19].getSize();
                    int n20 = pgElementSet.getOppVertexLocInd(n4, n15);
                    n17 = 2 * n20;
                    int n21 = 2 * n20 + 1;
                    n16 = nArray[n19];
                    piVectorArray3[n16 + n17].m_data[2] = n12;
                    piVectorArray3[n16 + n21].m_data[1] = n12;
                    if (piVectorArray[n4].m_data[(n15 + 1) % n3] == piVectorArray[n19].m_data[(n20 + 2) % n13]) {
                        piVectorArray4[n2 + n14].m_data[0] = n16 + n21;
                        piVectorArray4[n2 + n].m_data[0] = n16 + n17;
                        piVectorArray4[n16 + n21].m_data[0] = n2 + n14;
                        piVectorArray4[n16 + n17].m_data[0] = n2 + n;
                    } else {
                        piVectorArray4[n2 + n14].m_data[0] = n16 + n17;
                        piVectorArray4[n2 + n].m_data[0] = n16 + n21;
                        piVectorArray4[n16 + n17].m_data[0] = n2 + n14;
                        piVectorArray4[n16 + n21].m_data[0] = n2 + n;
                    }
                }
                ++n12;
            }
            if (!pgElementSet.hasElementTextures()) continue;
            PdVector[] pdVectorArray2 = pgElementSet.getElementTexture(n4);
            PdVector pdVector4 = PdVector.copyNew((PdVector)pdVectorArray2[0]);
            for (n13 = 1; n13 < n3; ++n13) {
                pdVector4.add(pdVectorArray2[n13]);
            }
            pdVector4.multScalar(1.0 / (double)n3);
            for (n13 = 0; n13 < 2 * n3; ++n13) {
                pdVector[nArray[n4] + n13][0].copy(pdVector4);
            }
            for (int i = 0; i < n3; ++i) {
                PdVector pdVector5 = PdVector.blendNew((double)0.5, (PdVector)pdVectorArray2[i], (double)0.5, (PdVector)pdVectorArray2[(i + 1) % n3]);
                pdVector[nArray[n4] + 2 * i][1].copy(pdVectorArray2[i]);
                pdVector[nArray[n4] + 2 * i][2].copy(pdVector5);
                pdVector[nArray[n4] + 2 * (i + 1)][1].copy(pdVector5);
                pdVector[nArray[n4] + 2 * (i + 1)][2].copy(pdVectorArray2[i]);
            }
        }
        pgElementSet.setNumElements(n7);
        if (pgElementSet.hasElementColors()) {
            for (n4 = n5 - 1; n4 >= 0; --n4) {
                n3 = 2 * pgElementSet.getDimOfElement(n4);
                for (n2 = 0; n2 < n3; ++n2) {
                    pgElementSet.setElementColor(nArray[n4] + n2, colorArray[n4]);
                }
            }
        }
        if (pgElementSet.hasElementBackColors()) {
            for (n4 = n5 - 1; n4 >= 0; --n4) {
                n3 = 2 * pgElementSet.getDimOfElement(n4);
                for (n2 = 0; n2 < n3; ++n2) {
                    pgElementSet.setElementBackColor(nArray[n4] + n2, colorArray2[n4]);
                }
            }
        }
        if (pgElementSet.hasElementNormals()) {
            for (n4 = n5 - 1; n4 >= 0; --n4) {
                n3 = 2 * pgElementSet.getDimOfElement(n4);
                for (n2 = 0; n2 < n3; ++n2) {
                    pgElementSet.setElementNormal(nArray[n4] + n2, pdVectorArray[n4]);
                }
            }
        }
        if (pgElementSet.getNumVectorFields() > 0) {
            n4 = pgElementSet.getNumVectorFields();
            for (n3 = 0; n3 < n4; ++n3) {
                PgVectorField pgVectorField = pgElementSet.getVectorField(n3);
                if (pgVectorField.getBasedOn() != 1) continue;
                pgVectorField.setNumVectors(n7);
                for (int i = n5 - 1; i >= 0; --i) {
                    n = 2 * pgElementSet.getElement(i).getSize();
                    for (int j = 0; j < n; ++j) {
                        pgVectorField.setVector(nArray[i] + n - 1 - j, PdVector.copyNew((PdVector)pgVectorField.getVector(i)));
                    }
                }
            }
        }
        pgElementSet.setDimOfElements(3);
        pgElementSet.setElements(piVectorArray3);
        pgElementSet.setNeighbours(piVectorArray4);
        if (pgElementSet.hasBoundary()) {
            PgBndPolygon[] pgBndPolygonArray = pgElementSet.getBoundaries();
            n3 = pgBndPolygonArray.length;
            for (int i = 0; i < n3; ++i) {
                if (pgBndPolygonArray[i].makeElementInd()) continue;
                pgElementSet.removeBoundaries();
                break;
            }
        }
        if (pgElementSet.hasElementTextures()) {
            pgElementSet.setElementTextures((PdVector[][])pdVector);
        }
        if (pgElementSet.isEnabledEdges()) {
            pgElementSet.makeEdgeStars();
        }
    }

    private static PdVector schemeButterfly(int n, int n2, int n3, int n4, PgElementSet pgElementSet) {
        double[] dArray = new double[]{-0.0625, 0.125, -0.0625, 0.5, 0.5, -0.0625, 0.125, -0.0625};
        int[] nArray = new int[8];
        PiVector piVector = pgElementSet.getElement(n);
        nArray[0] = pgElementSet.getOppVertexInd(n, (n2 + 3 - 1) % 3);
        nArray[1] = piVector.m_data[n2];
        nArray[2] = pgElementSet.getOppVertexInd(n, (n2 + 1) % 3);
        nArray[3] = piVector.m_data[(n2 + 1) % 3];
        nArray[4] = piVector.m_data[(n2 + 3 - 1) % 3];
        if (nArray[0] == -1) {
            nArray[0] = nArray[1];
        }
        if (nArray[2] == -1) {
            nArray[2] = nArray[1];
        }
        nArray[5] = pgElementSet.getOppVertexInd(n3, (n4 + 1) % 3);
        nArray[6] = pgElementSet.getElement((int)n3).m_data[n4];
        nArray[7] = pgElementSet.getOppVertexInd(n3, (n4 + 3 - 1) % 3);
        if (nArray[5] == -1) {
            nArray[5] = nArray[6];
        }
        if (nArray[7] == -1) {
            nArray[7] = nArray[6];
        }
        PdVector pdVector = new PdVector(pgElementSet.getDimOfVertices());
        for (int i = 0; i < 8; ++i) {
            pdVector.blendBase(pdVector, dArray[i], pgElementSet.getVertex(nArray[i]));
        }
        return pdVector;
    }

    private static PdVector schemeDlg(int n, int n2, PgElementSet pgElementSet) {
        int n3;
        int n4;
        PdVector pdVector;
        double[] dArray = new double[]{-0.0625, 0.5625, 0.5625, -0.0625};
        int[] nArray = new int[4];
        PiVector piVector = pgElementSet.getElement(n);
        nArray[1] = piVector.m_data[(n2 + 1) % 3];
        nArray[2] = piVector.m_data[(n2 + 3 - 1) % 3];
        boolean bl = false;
        if (pgElementSet.hasBoundary()) {
            pdVector = pgElementSet.getBoundaries();
            n4 = ((PgBndPolygon[])pdVector).length;
            for (n3 = 0; n3 < n4; ++n3) {
                PiVector piVector2 = pdVector[n3].getVertexInd();
                int n5 = pdVector[n3].getNumVertices();
                for (int i = 0; i < n5 - 1; ++i) {
                    if ((piVector2.m_data[i] != nArray[1] || piVector2.m_data[i + 1] != nArray[2]) && (piVector2.m_data[i] != nArray[2] || piVector2.m_data[i + 1] != nArray[1])) continue;
                    bl = true;
                    if (piVector2.m_data[i] == nArray[1]) {
                        nArray[0] = i > 0 ? piVector2.m_data[i - 1] : nArray[1];
                        if (i < n5 - 2) {
                            nArray[3] = piVector2.m_data[i + 2];
                            continue;
                        }
                        nArray[3] = nArray[2];
                        continue;
                    }
                    nArray[3] = i > 0 ? piVector2.m_data[i - 1] : nArray[2];
                    nArray[0] = i < n5 - 2 ? piVector2.m_data[i + 2] : nArray[1];
                }
            }
        }
        if (!bl) {
            pdVector = new PgVertexStar();
            pdVector.makeVertexStar(pgElementSet, nArray[1], n);
            PiVector piVector3 = pdVector.getLink();
            n3 = pdVector.getSize();
            nArray[0] = piVector3.m_data[0] == nArray[2] ? piVector3.m_data[n3] : piVector3.m_data[0];
            pdVector.makeVertexStar(pgElementSet, nArray[2], n);
            piVector3 = pdVector.getLink();
            n3 = pdVector.getSize();
            nArray[3] = piVector3.m_data[0] == nArray[1] ? piVector3.m_data[n3] : piVector3.m_data[0];
        }
        pdVector = new PdVector(pgElementSet.getDimOfVertices());
        for (n4 = 0; n4 < 4; ++n4) {
            pdVector.blendBase(pdVector, dArray[n4], pgElementSet.getVertex(nArray[n4]));
        }
        return pdVector;
    }

    public void refineQuadrisection() {
        this.m_refineSequence.addEntry(4);
        PwRefineElementSet.quadrisection((PgElementSet)this.m_geom, 4);
    }

    public void refineCatmullClark() {
        this.m_refineSequence.addEntry(5);
        PwRefineElementSet.quadrisection((PgElementSet)this.m_geom, 5);
    }

    public static void quadrisection(PgElementSet pgElementSet, int n) {
        if (n == 4) {
            PwRefineElementSet.quadrisection(pgElementSet, true);
        }
        if (n == 5) {
            int n2;
            int n3;
            pgElementSet.removeUnusedVertices();
            PiVector[] piVectorArray = pgElementSet.getElements();
            PiVector[] piVectorArray2 = pgElementSet.getNeighbours();
            int n4 = pgElementSet.getNumVertices();
            int n5 = pgElementSet.getNumElements();
            int n6 = n4 + n5 + pgElementSet.getNumEdges();
            PdVector[] pdVectorArray = new PdVector[n6];
            for (n3 = 0; n3 < n5; ++n3) {
                pdVectorArray[n3 + n4] = PgGeometry.getCenterOfElement(null, (PdVector[])pgElementSet.getVertices(), (int[])piVectorArray[n3].m_data);
            }
            n3 = n5 + n4;
            for (int i = 0; i < n5; ++i) {
                int n7 = piVectorArray[i].getSize();
                for (int j = 0; j < n7; ++j) {
                    n2 = piVectorArray2[i].m_data[j];
                    if (n2 >= i) continue;
                    PdVector pdVector = pgElementSet.getVertex(piVectorArray[i].m_data[(j + 1) % n7]);
                    PdVector pdVector2 = pgElementSet.getVertex(piVectorArray[i].m_data[(j + 2) % n7]);
                    pdVectorArray[n3] = n2 > -1 ? PdVector.blendNew((double)0.25, (PdVector)pdVector, (double)0.25, (PdVector)pdVector2, (double)0.25, (PdVector)pdVectorArray[n4 + i], (double)0.25, (PdVector)pdVectorArray[n4 + n2]) : PdVector.blendNew((double)0.5, (PdVector)pdVector, (double)0.5, (PdVector)pdVector2);
                    ++n3;
                }
            }
            PwRefineElementSet.quadrisection(pgElementSet, false);
            piVectorArray = pgElementSet.getElements();
            PgVertexStar pgVertexStar = new PgVertexStar();
            boolean[] blArray = new boolean[n4];
            if (pgElementSet.hasBoundary()) {
                PgBndPolygon[] pgBndPolygonArray = pgElementSet.getBoundaries();
                n2 = pgBndPolygonArray.length;
                for (int i = 0; i < n2; ++i) {
                    int n8 = pgBndPolygonArray[i].getNumVertices();
                    PiVector piVector = pgBndPolygonArray[i].getVertexInd();
                    blArray[piVector.m_data[0]] = true;
                    blArray[piVector.m_data[n8 - 1]] = true;
                }
            }
            PiVector piVector = PgVertexStar.getElementPerVertex(pgElementSet);
            for (n2 = 0; n2 < n4; ++n2) {
                pgVertexStar.makeVertexStar(pgElementSet, n2, piVector.m_data[n2]);
                PiVector piVector2 = pgVertexStar.getLink();
                pdVectorArray[n2] = pgElementSet.getVertex(n2);
                int n9 = pgVertexStar.getSize();
                if (pgVertexStar.isClosed()) {
                    double d = 2.0 / (double)n9;
                    double d2 = 1.0 / (double)n9;
                    PiVector piVector3 = pgVertexStar.getElement();
                    PiVector piVector4 = pgVertexStar.getVertexLocInd();
                    pdVectorArray[n2].multScalar(1.0 - d - d2);
                    for (int i = 0; i < n9; ++i) {
                        pdVectorArray[n2].blend(1.0, pdVectorArray[n2], d2 / (double)n9, pdVectorArray[piVectorArray[piVector3.m_data[i]].m_data[(piVector4.m_data[i] + 2) % 4]], d / (double)n9, pdVectorArray[piVector2.m_data[i]]);
                    }
                    continue;
                }
                if (blArray[n2]) continue;
                pdVectorArray[n2].blend(0.5, pdVectorArray[n2], 0.25, pdVectorArray[piVector2.m_data[0]], 0.25, pdVectorArray[piVector2.m_data[n9]]);
            }
            pgElementSet.setVertices(pdVectorArray);
        }
        if (pgElementSet.hasVertexNormals()) {
            pgElementSet.makeVertexNormals();
        }
        if (pgElementSet.hasElementNormals()) {
            pgElementSet.makeElementNormals();
        }
        if (pgElementSet.isEnabledEdges()) {
            pgElementSet.makeEdgeStars();
        }
    }

    public static void quadrisection(PgElementSet pgElementSet, boolean bl) {
        int n;
        int n2;
        int n3;
        if (!pgElementSet.checkNeighbour(false)) {
            pgElementSet.makeNeighbour();
        }
        int n4 = pgElementSet.getNumElements();
        int n5 = pgElementSet.getNumVertices();
        int[] nArray = new int[n4];
        int n6 = 0;
        PiVector[] piVectorArray = pgElementSet.getElements();
        PiVector[] piVectorArray2 = pgElementSet.getNeighbours();
        int n7 = n5 + n4 + pgElementSet.getNumEdges();
        pgElementSet.setNumVertices(n7);
        for (int i = 0; i < n4; ++i) {
            Object object;
            int n8 = piVectorArray[i].getSize();
            nArray[i] = n6;
            n6 += n8;
            if (bl) {
                pgElementSet.setVertex(n5 + i, PgGeometry.getCenterOfElement(null, (PdVector[])pgElementSet.getVertices(), (int[])piVectorArray[i].m_data));
            }
            if (pgElementSet.hasVertexColors()) {
                object = PdColor.blend((double)(1.0 / (double)n8), (Color)pgElementSet.getVertexColor(piVectorArray[i].m_data[0]), (double)(1.0 / (double)n8), (Color)pgElementSet.getVertexColor(piVectorArray[i].m_data[1]));
                for (n3 = 2; n3 < n8; ++n3) {
                    object = PdColor.blend((double)1.0, (Color)object, (double)(1.0 / (double)n8), (Color)pgElementSet.getVertexColor(piVectorArray[i].m_data[n3]));
                }
                pgElementSet.setVertexColor(n5 + i, (Color)object);
            }
            if (pgElementSet.hasVertexTextures()) {
                object = pgElementSet.getVertexTextures();
                PdVector pdVector = PdVector.copyNew((PdVector)object[piVectorArray[i].m_data[0]]);
                for (int j = 1; j < n8; ++j) {
                    pdVector.add(object[piVectorArray[i].m_data[j]]);
                }
                pdVector.multScalar(1.0 / (double)n8);
                object[n5 + i] = pdVector;
            }
            if (pgElementSet.getNumVectorFields() <= 0) continue;
            int n9 = pgElementSet.getNumVectorFields();
            for (n3 = 0; n3 < n9; ++n3) {
                PgVectorField pgVectorField = pgElementSet.getVectorField(n3);
                if (pgVectorField.getBasedOn() != 0) continue;
                pgVectorField.setNumVectors(n5 + i + 1);
                PdVector pdVector = PdVector.copyNew((PdVector)pgVectorField.getVector(piVectorArray[i].m_data[0]));
                for (n2 = 1; n2 < n8; ++n2) {
                    pdVector.add(pgVectorField.getVector(piVectorArray[i].m_data[n2]));
                }
                pdVector.multScalar(1.0 / (double)n8);
                pgVectorField.setVector(n5 + i, pdVector);
            }
        }
        PiVector[] piVectorArray3 = new PiVector[n6];
        PiVector[] piVectorArray4 = new PiVector[n6];
        PdVector[][] pdVectorArrayArray = new PdVector[][]{};
        n3 = n4 + n5;
        if (pgElementSet.hasBoundary()) {
            PgBndPolygon[] pgBndPolygonArray = pgElementSet.getBoundaries();
            int n10 = pgBndPolygonArray.length;
            for (n2 = 0; n2 < n10; ++n2) {
                int n11 = pgBndPolygonArray[n2].getNumVertices();
                pgBndPolygonArray[n2].setNumVertices(2 * n11 - 1);
                PiVector piVector = pgBndPolygonArray[n2].getVertexInd();
                for (int i = n11; i > 0; --i) {
                    piVector.m_data[2 * i - 2] = piVector.m_data[i - 1];
                }
            }
        }
        if (pgElementSet.hasElementTextures()) {
            pdVectorArrayArray = new PdVector[n6][];
        }
        for (n = 0; n < n4; ++n) {
            int n12;
            int n13;
            int n14 = piVectorArray[n].getSize();
            for (n13 = 0; n13 < n14; ++n13) {
                int n15 = nArray[n] + n13;
                piVectorArray3[n15] = new PiVector(4);
                piVectorArray4[n15] = new PiVector(4);
                piVectorArray3[n15].m_data[0] = n + n5;
                piVectorArray3[n15].m_data[2] = piVectorArray[n].m_data[n13];
                piVectorArray4[n15].m_data[2] = nArray[n] + (n13 + 1) % n14;
                piVectorArray4[n15].m_data[3] = nArray[n] + (n13 + n14 - 1) % n14;
            }
            for (n13 = 0; n13 < n14; ++n13) {
                int n16;
                if (piVectorArray2[n].m_data[n13] >= n) continue;
                if (bl) {
                    pgElementSet.setVertex(n3, PdVector.blendNew((double)0.5, (PdVector)pgElementSet.getVertex(piVectorArray[n].m_data[(n13 + 1) % n14]), (double)0.5, (PdVector)pgElementSet.getVertex(piVectorArray[n].m_data[(n13 + 2) % n14])));
                }
                if (pgElementSet.hasVertexColors()) {
                    Color color = PdColor.blend((double)0.5, (Color)pgElementSet.getVertexColor(piVectorArray[n].m_data[(n13 + 1) % n14]), (double)0.5, (Color)pgElementSet.getVertexColor(piVectorArray[n].m_data[(n13 + 2) % n14]));
                    pgElementSet.setVertexColor(n3, color);
                }
                if (pgElementSet.hasVertexTextures()) {
                    PdVector[] pdVectorArray = pgElementSet.getVertexTextures();
                    pdVectorArray[n3] = PdVector.blendNew((double)0.5, (PdVector)pdVectorArray[piVectorArray[n].m_data[(n13 + 1) % n14]], (double)0.5, (PdVector)pdVectorArray[piVectorArray[n].m_data[(n13 + 2) % n14]]);
                }
                if (pgElementSet.getNumVectorFields() > 0) {
                    int n17 = pgElementSet.getNumVectorFields();
                    for (n12 = 0; n12 < n17; ++n12) {
                        PgVectorField pgVectorField = pgElementSet.getVectorField(n12);
                        if (pgVectorField.getBasedOn() != 0) continue;
                        pgVectorField.setNumVectors(n3 + 1);
                        pgVectorField.setVector(n3, PdVector.blendNew((double)0.5, (PdVector)pgVectorField.getVector(piVectorArray[n].m_data[(n13 + 1) % n14]), (double)0.5, (PdVector)pgVectorField.getVector(piVectorArray[n].m_data[(n13 + 2) % n14])));
                    }
                }
                piVectorArray3[nArray[n] + (n13 + 1) % n14].m_data[3] = n3;
                piVectorArray3[nArray[n] + (n13 + 2) % n14].m_data[1] = n3;
                if (piVectorArray2[n].m_data[n13] == -1) {
                    piVectorArray4[nArray[n] + (n13 + 1) % n14].m_data[1] = -1;
                    piVectorArray4[nArray[n] + (n13 + 2) % n14].m_data[0] = -1;
                    if (pgElementSet.hasBoundary()) {
                        PgBndPolygon[] pgBndPolygonArray = pgElementSet.getBoundaries();
                        n12 = pgBndPolygonArray.length;
                        for (int i = 0; i < n12; ++i) {
                            n16 = pgBndPolygonArray[i].getNumVertices() / 2;
                            PiVector piVector = pgBndPolygonArray[i].getVertexInd();
                            for (int j = 0; j < n16; ++j) {
                                if ((piVector.m_data[2 * j] != piVectorArray[n].m_data[(n13 + 1) % n14] || piVector.m_data[2 * j + 2] != piVectorArray[n].m_data[(n13 + 2) % n14]) && (piVector.m_data[2 * j] != piVectorArray[n].m_data[(n13 + 2) % n14] || piVector.m_data[2 * j + 2] != piVectorArray[n].m_data[(n13 + 1) % n14])) continue;
                                piVector.m_data[2 * j + 1] = n3;
                            }
                        }
                    }
                } else {
                    int n18 = piVectorArray2[n].m_data[n13];
                    n12 = piVectorArray[n18].getSize();
                    int n19 = pgElementSet.getOppVertexLocInd(n, n13);
                    n16 = (n19 + 1) % n12;
                    int n20 = (n19 + 2) % n12;
                    piVectorArray3[nArray[n18] + n16].m_data[3] = n3;
                    piVectorArray3[nArray[n18] + n20].m_data[1] = n3;
                    if (piVectorArray[n].m_data[(n13 + 1) % n14] == piVectorArray[n18].m_data[n20]) {
                        piVectorArray4[nArray[n] + (n13 + 1) % n14].m_data[1] = nArray[n18] + n20;
                        piVectorArray4[nArray[n18] + n20].m_data[0] = nArray[n] + (n13 + 1) % n14;
                        piVectorArray4[nArray[n] + (n13 + 2) % n14].m_data[0] = nArray[n18] + n16;
                        piVectorArray4[nArray[n18] + n16].m_data[1] = nArray[n] + (n13 + 2) % n14;
                    } else {
                        piVectorArray4[nArray[n] + (n13 + 1) % n14].m_data[1] = nArray[n18] + n16;
                        piVectorArray4[nArray[n18] + n16].m_data[1] = nArray[n] + (n13 + 1) % n14;
                        piVectorArray4[nArray[n] + (n13 + 2) % n14].m_data[0] = nArray[n18] + n20;
                        piVectorArray4[nArray[n18] + n20].m_data[0] = nArray[n] + (n13 + 2) % n14;
                    }
                }
                ++n3;
            }
            if (!pgElementSet.hasElementTextures()) continue;
            PdVector[] pdVectorArray = pgElementSet.getElementTexture(n);
            PdVector pdVector = PdVector.copyNew((PdVector)pdVectorArray[0]);
            for (n12 = 1; n12 < n14; ++n12) {
                pdVector.add(pdVectorArray[n12]);
            }
            pdVector.multScalar(1.0 / (double)n14);
            for (n12 = 0; n12 < n14; ++n12) {
                pdVectorArrayArray[nArray[n] + n12] = new PdVector[4];
            }
            for (n12 = 0; n12 < n14; ++n12) {
                pdVectorArrayArray[nArray[n] + n12][0] = PdVector.copyNew((PdVector)pdVector);
                pdVectorArrayArray[nArray[n] + n12][2] = PdVector.copyNew((PdVector)pdVectorArray[n12]);
                PdVector pdVector2 = PdVector.blendNew((double)0.5, (PdVector)pdVectorArray[n12], (double)0.5, (PdVector)pdVectorArray[(n12 + 1) % n14]);
                pdVectorArrayArray[nArray[n] + n12][3] = PdVector.copyNew((PdVector)pdVector2);
                pdVectorArrayArray[nArray[n] + (n12 + 1) % n14][1] = PdVector.copyNew((PdVector)pdVector2);
            }
        }
        pgElementSet.setNumElements(n6);
        if (pgElementSet.hasElementColors()) {
            for (n = n4 - 1; n >= 0; --n) {
                int n21 = pgElementSet.getDimOfElement(n);
                for (int i = 0; i < n21; ++i) {
                    pgElementSet.setElementColor(nArray[n] + n21 - 1 - i, new Color(pgElementSet.getElementColor(n).getRGB()));
                }
            }
        }
        if (pgElementSet.hasElementBackColors()) {
            for (n = n4 - 1; n >= 0; --n) {
                int n22 = pgElementSet.getDimOfElement(n);
                for (int i = 0; i < n22; ++i) {
                    pgElementSet.setElementBackColor(nArray[n] + n22 - 1 - i, new Color(pgElementSet.getElementBackColor(n).getRGB()));
                }
            }
        }
        if (pgElementSet.getNumVectorFields() > 0) {
            n = pgElementSet.getNumVectorFields();
            for (int i = 0; i < n; ++i) {
                PgVectorField pgVectorField = pgElementSet.getVectorField(i);
                if (pgVectorField.getBasedOn() != 1) continue;
                pgVectorField.setNumVectors(n6);
                for (int j = n4 - 1; j >= 0; --j) {
                    int n23 = pgElementSet.getElement(j).getSize();
                    for (int k = 0; k < n23; ++k) {
                        pgVectorField.setVector(nArray[j] + n23 - 1 - k, PdVector.copyNew((PdVector)pgVectorField.getVector(j)));
                    }
                }
            }
        }
        pgElementSet.setDimOfElements(4);
        pgElementSet.setElements(piVectorArray3);
        pgElementSet.setNeighbours(piVectorArray4);
        if (pgElementSet.hasBoundary()) {
            PgBndPolygon[] pgBndPolygonArray = pgElementSet.getBoundaries();
            int n24 = pgBndPolygonArray.length;
            for (int i = 0; i < n24; ++i) {
                if (pgBndPolygonArray[i].makeElementInd()) continue;
                pgElementSet.removeBoundaries();
                break;
            }
        }
        if (pgElementSet.hasElementTextures()) {
            pgElementSet.setElementTextures((PdVector[][])pdVectorArrayArray);
        }
        if (pgElementSet.isEnabledEdges()) {
            pgElementSet.makeEdgeStars();
        }
    }

    public void refineSqrt3() {
        this.m_refineSequence.addEntry(7);
        PwRefineElementSet.refineSqrt3((PgElementSet)this.m_geom);
    }

    public static void refineSqrt3(PgElementSet pgElementSet) {
        int n;
        int n2;
        Object object;
        int n3;
        PiVector[] piVectorArray;
        int n4;
        int n5;
        int n6;
        int n7;
        if (pgElementSet.getDimOfElements() != 3) {
            PgElementSet.triangulate((PgElementSet)pgElementSet);
        }
        if (!pgElementSet.checkNeighbour(false)) {
            pgElementSet.makeNeighbour();
        }
        pgElementSet.removeUnusedVertices();
        pgElementSet.markBoundary();
        int n8 = pgElementSet.getNumElements();
        int n9 = pgElementSet.getNumVertices();
        PiVector[] piVectorArray2 = pgElementSet.getElements();
        PiVector[] piVectorArray3 = pgElementSet.getNeighbours();
        PiVector piVector = new PiVector(n8);
        piVector.setConstant(-1);
        int n10 = 0;
        int n11 = 0;
        boolean[] blArray = new boolean[n9];
        PdVector[] pdVectorArray = new PdVector[n9];
        boolean[] blArray2 = new boolean[n9];
        pgElementSet.markBoundary();
        if (pgElementSet.hasBoundary()) {
            PgBndPolygon[] pgBndPolygonArray = pgElementSet.getBoundaries();
            n7 = pgBndPolygonArray.length;
            for (n6 = 0; n6 < n7; ++n6) {
                n5 = pgBndPolygonArray[n6].getNumVertices();
                PiVector piVector2 = pgBndPolygonArray[n6].getVertexInd();
                blArray[piVector2.m_data[0]] = true;
                blArray[piVector2.m_data[n5 - 1]] = true;
            }
        }
        for (n4 = 0; n4 < n9; ++n4) {
            pdVectorArray[n4] = pgElementSet.hasTagVertex(n4, 14) && !blArray[n4] ? new PdVector(pgElementSet.getDimOfVertices()) : PdVector.copyNew((PdVector)pgElementSet.getVertex(n4));
        }
        for (n4 = 0; n4 < n8; ++n4) {
            int n12;
            if (piVector.m_data[n4] != -1) continue;
            if (piVectorArray3[n4].m_data[0] != -1 && piVectorArray3[n4].m_data[1] != -1 && piVectorArray3[n4].m_data[2] != -1) {
                piVector.m_data[n4] = -1;
                n11 += 3;
                continue;
            }
            if (piVectorArray3[n4].m_data[0] == -1 && piVectorArray3[n4].m_data[1] == -1 || piVectorArray3[n4].m_data[0] == -1 && piVectorArray3[n4].m_data[2] == -1 || piVectorArray3[n4].m_data[1] == -1 && piVectorArray3[n4].m_data[2] == -1) {
                piVector.m_data[n4] = -2;
                n11 += 3;
                if (piVectorArray3[n4].m_data[0] == -1) {
                    ++n10;
                    ++n11;
                }
                if (piVectorArray3[n4].m_data[1] == -1) {
                    ++n10;
                    ++n11;
                }
                if (piVectorArray3[n4].m_data[2] != -1) continue;
                ++n10;
                ++n11;
                continue;
            }
            n7 = 0;
            if (piVectorArray3[n4].m_data[1] == -1) {
                n7 = 1;
            }
            if (piVectorArray3[n4].m_data[2] == -1) {
                n7 = 2;
            }
            if (piVectorArray2[n4].m_data[(n7 + 1) % 3] < piVectorArray2[n4].m_data[(n7 + 2) % 3]) {
                n6 = piVectorArray3[n4].m_data[(n7 + 1) % 3];
                n5 = 0;
                if (piVectorArray2[n6].m_data[1] == piVectorArray2[n4].m_data[n7]) {
                    n5 = 1;
                }
                if (piVectorArray2[n6].m_data[2] == piVectorArray2[n4].m_data[n7]) {
                    n5 = 2;
                }
                n12 = pgElementSet.getOppVertexInd(n4, (n7 + 1) % 3);
                if (piVectorArray3[n6].m_data[n5] != -1 || n12 > piVectorArray2[n4].m_data[(n7 + 2) % 3] || blArray[piVectorArray2[n4].m_data[(n7 + 2) % 3]] || piVectorArray3[n6].m_data[(n5 + 2) % 3] == -1 || n7 != 0 || n5 != 0) {
                    piVector.m_data[n4] = -2;
                    n11 += 4;
                } else {
                    piVector.m_data[n4] = n6;
                    piVector.m_data[n6] = n4;
                    n11 += 3;
                    n10 -= 2;
                }
            } else {
                n6 = piVectorArray3[n4].m_data[(n7 + 2) % 3];
                n5 = 0;
                if (piVectorArray2[n6].m_data[1] == piVectorArray2[n4].m_data[n7]) {
                    n5 = 1;
                }
                if (piVectorArray2[n6].m_data[2] == piVectorArray2[n4].m_data[n7]) {
                    n5 = 2;
                }
                n12 = pgElementSet.getOppVertexInd(n4, (n7 + 2) % 3);
                if (piVectorArray3[n6].m_data[n5] != -1 || n12 > piVectorArray2[n4].m_data[(n7 + 1) % 3] || blArray[piVectorArray2[n4].m_data[(n7 + 1) % 3]] || piVectorArray3[n6].m_data[(n5 + 1) % 3] == -1 || n7 != 0 || n5 != 0) {
                    piVector.m_data[n4] = -2;
                    n11 += 4;
                } else {
                    piVector.m_data[n4] = n6;
                    piVector.m_data[n6] = n4;
                    n11 += 3;
                    n10 -= 2;
                }
            }
            ++n10;
        }
        n4 = n9 + n8 + n10;
        if (pgElementSet.hasBoundary()) {
            PgBndPolygon[] pgBndPolygonArray = pgElementSet.getBoundaries();
            n6 = pgBndPolygonArray.length;
            for (n5 = 0; n5 < n6; ++n5) {
                int n13 = pgBndPolygonArray[n5].getNumVertices();
                piVectorArray = pgBndPolygonArray[n5].getElementInd();
                n3 = n13;
                for (int i = 0; i < n13 - 1; ++i) {
                    if (piVector.m_data[piVectorArray.m_data[i]] == -2) {
                        ++n3;
                        continue;
                    }
                    if (piVector.m_data[piVectorArray.m_data[i]] <= piVectorArray.m_data[i]) continue;
                    ++n3;
                }
                pgBndPolygonArray[n5].setNumVertices(n3);
                object = pgBndPolygonArray[n5].getVertexInd();
                n2 = n3 - 1;
                ((PiVector)object).m_data[n2] = ((PiVector)object).m_data[n13 - 1];
                for (int i = n13 - 2; i >= 0; --i) {
                    if (piVector.m_data[piVectorArray.m_data[i]] == -2) {
                        ((PiVector)object).m_data[--n2] = -1;
                        ((PiVector)object).m_data[--n2] = ((PiVector)object).m_data[i];
                        continue;
                    }
                    if (piVector.m_data[piVectorArray.m_data[i]] > piVectorArray.m_data[i]) {
                        ((PiVector)object).m_data[--n2] = ((PiVector)object).m_data[i];
                        continue;
                    }
                    ((PiVector)object).m_data[--n2] = -1;
                    ((PiVector)object).m_data[--n2] = ((PiVector)object).m_data[i];
                }
            }
        }
        pgElementSet.setNumVertices(n4);
        if (pgElementSet.getNumVectorFields() > 0) {
            n7 = pgElementSet.getNumVectorFields();
            for (n6 = 0; n6 < n7; ++n6) {
                PgVectorField pgVectorField = pgElementSet.getVectorField(n6);
                if (pgVectorField.getBasedOn() == 0) {
                    pgVectorField.setNumVectors(n4);
                    continue;
                }
                if (pgVectorField.getBasedOn() != 1) continue;
                pgVectorField.setNumVectors(n11);
            }
        }
        Color[] colorArray = new Color[]{};
        Color[] colorArray2 = new Color[]{};
        if (pgElementSet.hasElementColors()) {
            colorArray = new Color[n11];
        }
        if (pgElementSet.hasElementBackColors()) {
            colorArray2 = new Color[n11];
        }
        if (pgElementSet.hasElementTextures()) {
            pgElementSet.removeTexture();
        }
        int n14 = n9;
        PiVector[] piVectorArray4 = new PiVector[n11];
        piVectorArray = new PiVector[n11];
        for (n3 = 0; n3 < n8; ++n3) {
            piVectorArray[n3] = PiVector.copyNew((PiVector)piVectorArray3[n3]);
        }
        n3 = n8;
        object = new PgVertexStar();
        for (n2 = 0; n2 < n8; ++n2) {
            int n15;
            int n16;
            int n17;
            if (piVector.m_data[n2] < 0) {
                PgVectorField pgVectorField;
                Object object2;
                PdVector pdVector = PdVector.copyNew((PdVector)pgElementSet.getVertex(piVectorArray2[n2].m_data[0]));
                pdVector.add(pgElementSet.getVertex(piVectorArray2[n2].m_data[1]));
                pdVector.add(pgElementSet.getVertex(piVectorArray2[n2].m_data[2]));
                pdVector.multScalar(0.3333333333333333);
                pgElementSet.setVertex(n14, pdVector);
                if (pgElementSet.hasVertexColors()) {
                    object2 = PdColor.blend((double)0.5, (Color)pgElementSet.getVertexColor(piVectorArray2[n2].m_data[0]), (double)0.5, (Color)pgElementSet.getVertexColor(piVectorArray2[n2].m_data[1]));
                    object2 = PdColor.blend((double)0.6666666666666666, (Color)object2, (double)0.3333333333333333, (Color)pgElementSet.getVertexColor(piVectorArray2[n2].m_data[2]));
                    pgElementSet.setVertexColor(n14, (Color)object2);
                }
                if (pgElementSet.hasVertexTextures()) {
                    object2 = pgElementSet.getVertexTextures();
                    object2[n14] = PdVector.blendNew((double)0.3333333333333333, (PdVector)object2[piVectorArray2[n2].m_data[0]], (double)0.3333333333333333, (PdVector)object2[piVectorArray2[n2].m_data[1]]);
                    object2[n14].blendBase(object2[n14], 0.3333333333333333, object2[piVectorArray2[n2].m_data[2]]);
                }
                if (pgElementSet.getNumVectorFields() > 0) {
                    int n18 = pgElementSet.getNumVectorFields();
                    for (n17 = 0; n17 < n18; ++n17) {
                        pgVectorField = pgElementSet.getVectorField(n17);
                        if (pgVectorField.getBasedOn() != 0) continue;
                        pgVectorField.setVector(n14, PdVector.blendNew((double)0.3333333333333333, (PdVector)pgVectorField.getVector(piVectorArray2[n2].m_data[0]), (double)0.3333333333333333, (PdVector)pgVectorField.getVector(piVectorArray2[n2].m_data[1]), (double)0.3333333333333333, (PdVector)pgVectorField.getVector(piVectorArray2[n2].m_data[2])));
                    }
                }
                piVectorArray4[n2] = new PiVector(n14, piVectorArray2[n2].m_data[0], piVectorArray2[n2].m_data[1]);
                piVectorArray4[n3] = new PiVector(n14, piVectorArray2[n2].m_data[1], piVectorArray2[n2].m_data[2]);
                piVectorArray[n3] = new PiVector(piVectorArray[n2].m_data[0], n3 + 1, n2);
                if (piVectorArray[n2].m_data[0] != -1) {
                    for (int i = 0; i < 3; ++i) {
                        if (piVectorArray[piVectorArray[n3].m_data[0]].m_data[i] != n2) continue;
                        piVectorArray[piVectorArray[n3].m_data[0]].m_data[i] = n3;
                    }
                }
                piVectorArray4[n3 + 1] = new PiVector(n14, piVectorArray2[n2].m_data[2], piVectorArray2[n2].m_data[0]);
                piVectorArray[n3 + 1] = new PiVector(piVectorArray[n2].m_data[1], n2, n3);
                if (piVectorArray[n2].m_data[1] != -1) {
                    for (int i = 0; i < 3; ++i) {
                        if (piVectorArray[piVectorArray[n3 + 1].m_data[0]].m_data[i] != n2) continue;
                        piVectorArray[piVectorArray[n3 + 1].m_data[0]].m_data[i] = n3 + 1;
                    }
                }
                ++n14;
                piVectorArray[n2] = new PiVector(piVectorArray[n2].m_data[2], n3, n3 + 1);
                if (pgElementSet.hasElementColors()) {
                    colorArray[n2] = pgElementSet.getElementColor(n2);
                    colorArray[n3] = pgElementSet.getElementColor(n2);
                    colorArray[n3 + 1] = pgElementSet.getElementColor(n2);
                }
                if (pgElementSet.hasElementBackColors()) {
                    colorArray2[n2] = pgElementSet.getElementBackColor(n2);
                    colorArray2[n3] = pgElementSet.getElementBackColor(n2);
                    colorArray2[n3 + 1] = pgElementSet.getElementBackColor(n2);
                }
                if (pgElementSet.getNumVectorFields() > 0) {
                    int n19 = pgElementSet.getNumVectorFields();
                    for (n17 = 0; n17 < n19; ++n17) {
                        pgVectorField = pgElementSet.getVectorField(n17);
                        if (pgVectorField.getBasedOn() != 1) continue;
                        pgVectorField.setVector(n3, PdVector.copyNew((PdVector)pgVectorField.getVector(n2)));
                        pgVectorField.setVector(n3 + 1, PdVector.copyNew((PdVector)pgVectorField.getVector(n2)));
                    }
                }
                n16 = 2;
                for (n17 = 0; n17 < 3; ++n17) {
                    Object object3;
                    int n20 = n3 + n17 - 1;
                    if (n17 == 0) {
                        n20 = n2;
                    }
                    if (piVectorArray[n20].m_data[0] != -1) continue;
                    PdVector pdVector2 = PdVector.blendNew((double)0.5, (PdVector)pgElementSet.getVertex(piVectorArray4[n20].m_data[1]), (double)0.5, (PdVector)pgElementSet.getVertex(piVectorArray4[n20].m_data[2]));
                    pgElementSet.setVertex(n14, pdVector2);
                    if (pgElementSet.hasVertexColors()) {
                        object3 = PdColor.blend((double)0.5, (Color)pgElementSet.getVertexColor(piVectorArray4[n20].m_data[1]), (double)0.5, (Color)pgElementSet.getVertexColor(piVectorArray4[n20].m_data[2]));
                        pgElementSet.setVertexColor(n14, (Color)object3);
                    }
                    if (pgElementSet.hasVertexTextures()) {
                        object3 = pgElementSet.getVertexTextures();
                        object3[n14] = PdVector.blendNew((double)0.5, (PdVector)object3[piVectorArray4[n20].m_data[1]], (double)0.5, (PdVector)object3[piVectorArray4[n20].m_data[2]]);
                    }
                    if (pgElementSet.getNumVectorFields() > 0) {
                        int n21 = pgElementSet.getNumVectorFields();
                        for (n = 0; n < n21; ++n) {
                            PgVectorField pgVectorField2 = pgElementSet.getVectorField(n);
                            if (pgVectorField2.getBasedOn() != 0) continue;
                            pgVectorField2.setVector(n14, PdVector.blendNew((double)0.5, (PdVector)pgVectorField2.getVector(piVectorArray4[n20].m_data[1]), (double)0.5, (PdVector)pgVectorField2.getVector(piVectorArray4[n20].m_data[2])));
                        }
                    }
                    if (pgElementSet.hasBoundary()) {
                        PgBndPolygon[] pgBndPolygonArray = pgElementSet.getBoundaries();
                        n = pgBndPolygonArray.length;
                        for (int i = 0; i < n; ++i) {
                            int n22 = pgBndPolygonArray[i].getNumVertices();
                            PiVector piVector3 = pgBndPolygonArray[i].getVertexInd();
                            for (int j = 0; j < n22 - 2; ++j) {
                                if ((piVector3.m_data[j] != piVectorArray4[n20].m_data[1] || piVector3.m_data[j + 2] != piVectorArray4[n20].m_data[2]) && (piVector3.m_data[j + 2] != piVectorArray4[n20].m_data[1] || piVector3.m_data[j] != piVectorArray4[n20].m_data[2])) continue;
                                piVector3.m_data[j + 1] = n14;
                            }
                        }
                    }
                    piVectorArray4[n3 + n16] = PiVector.copyNew((PiVector)piVectorArray4[n20]);
                    piVectorArray[n3 + n16] = PiVector.copyNew((PiVector)piVectorArray[n20]);
                    piVectorArray4[n3 + n16].m_data[1] = n14;
                    if (pgElementSet.hasElementColors()) {
                        colorArray[n3 + n16] = colorArray[n20];
                    }
                    if (pgElementSet.hasElementBackColors()) {
                        colorArray2[n3 + n16] = colorArray2[n20];
                    }
                    if (pgElementSet.getNumVectorFields() > 0) {
                        int n23 = pgElementSet.getNumVectorFields();
                        for (n = 0; n < n23; ++n) {
                            PgVectorField pgVectorField3 = pgElementSet.getVectorField(n);
                            if (pgVectorField3.getBasedOn() != 1) continue;
                            pgVectorField3.setVector(n3 + n16, PdVector.copyNew((PdVector)pgVectorField3.getVector(n20)));
                        }
                    }
                    piVectorArray4[n20].m_data[2] = n14;
                    piVectorArray[n3 + n16].m_data[2] = n20;
                    piVectorArray[n20].m_data[1] = n3 + n16;
                    for (int i = 0; i < 3; ++i) {
                        if (piVectorArray[piVectorArray[n3 + n16].m_data[1]].m_data[i] != n20) continue;
                        piVectorArray[piVectorArray[n3 + n16].m_data[1]].m_data[i] = n3 + n16;
                    }
                    ++n16;
                    ++n14;
                }
                n3 += n16;
                for (n17 = 0; n17 < 3; ++n17) {
                    if (blArray2[piVectorArray2[n2].m_data[n17]]) continue;
                    ((PgVertexStar)((Object)object)).makeVertexStar(pgElementSet, piVectorArray2[n2].m_data[n17], n2);
                    PiVector piVector4 = ((PgVertexStar)((Object)object)).getLink();
                    if (((PgVertexStar)((Object)object)).isClosed()) {
                        int n24 = piVector4.getSize();
                        double d = (4.0 - 2.0 * Math.cos(Math.PI * 2 / (double)n24)) / 9.0;
                        pdVectorArray[piVectorArray2[n2].m_data[n17]].multScalar(1.0 - d);
                        d /= (double)n24;
                        for (int i = 0; i < n24; ++i) {
                            pdVectorArray[piVectorArray2[n2].m_data[n17]].blendBase(pdVectorArray[piVectorArray2[n2].m_data[n17]], d, pgElementSet.getVertex(piVector4.m_data[i]));
                        }
                        blArray2[piVectorArray2[n2].m_data[n17]] = true;
                        continue;
                    }
                    if (piVector.m_data[n2] != -2 || blArray[piVectorArray2[n2].m_data[n17]]) continue;
                    if (piVectorArray3[n2].m_data[(n17 + 1) % 3] == -1) {
                        pdVectorArray[piVectorArray2[n2].m_data[n17]].blend(1.0, pdVectorArray[piVectorArray2[n2].m_data[n17]], 0.3888888888888889, pgElementSet.getVertex(piVectorArray2[n2].m_data[n17]), 0.1111111111111111, pgElementSet.getVertex(piVectorArray2[n2].m_data[(n17 + 2) % 3]));
                    }
                    if (piVectorArray3[n2].m_data[(n17 + 2) % 3] != -1) continue;
                    pdVectorArray[piVectorArray2[n2].m_data[n17]].blend(1.0, pdVectorArray[piVectorArray2[n2].m_data[n17]], 0.3888888888888889, pgElementSet.getVertex(piVectorArray2[n2].m_data[n17]), 0.1111111111111111, pgElementSet.getVertex(piVectorArray2[n2].m_data[(n17 + 1) % 3]));
                }
                continue;
            }
            if (piVector.m_data[n2] <= n2) continue;
            if (!blArray2[piVectorArray2[n2].m_data[0]]) {
                ((PgVertexStar)((Object)object)).makeVertexStar(pgElementSet, piVectorArray2[n2].m_data[0], n2);
                PiVector piVector5 = ((PgVertexStar)((Object)object)).getLink();
                n16 = piVector5.getSize();
                double d = (4.0 - 2.0 * Math.cos(Math.PI * 2 / (double)n16)) / 9.0;
                pdVectorArray[piVectorArray2[n2].m_data[0]].multScalar(1.0 - d);
                d /= (double)n16;
                for (int i = 0; i < n16; ++i) {
                    pdVectorArray[piVectorArray2[n2].m_data[0]].blendBase(pdVectorArray[piVectorArray2[n2].m_data[0]], d, pgElementSet.getVertex(piVector5.m_data[i]));
                }
                blArray2[piVectorArray2[n2].m_data[0]] = true;
            }
            piVectorArray4[n2] = PiVector.copyNew((PiVector)piVectorArray2[n2]);
            int n25 = piVectorArray2[n2].m_data[1];
            n16 = piVectorArray2[n2].m_data[2];
            if (piVectorArray2[n2].m_data[2] > piVectorArray2[n2].m_data[1]) {
                n25 = piVectorArray2[n2].m_data[2];
                n16 = piVectorArray2[n2].m_data[1];
                piVectorArray4[n2].m_data[0] = piVectorArray2[n2].m_data[2];
                piVectorArray4[n2].m_data[1] = piVectorArray2[n2].m_data[0];
                piVectorArray4[n2].m_data[2] = piVectorArray2[n2].m_data[1];
                piVectorArray[n2].m_data[0] = piVectorArray[n2].m_data[2];
                piVectorArray[n2].m_data[2] = n3;
                piVectorArray[n2].m_data[1] = -1;
            } else {
                piVectorArray4[n2].m_data[0] = piVectorArray2[n2].m_data[1];
                piVectorArray4[n2].m_data[1] = piVectorArray2[n2].m_data[2];
                piVectorArray4[n2].m_data[2] = piVectorArray2[n2].m_data[0];
                piVectorArray[n2].m_data[0] = piVectorArray[n2].m_data[1];
                piVectorArray[n2].m_data[1] = n3;
                piVectorArray[n2].m_data[2] = -1;
            }
            n17 = piVector.m_data[n2];
            piVectorArray4[n3] = PiVector.copyNew((PiVector)piVectorArray2[n17]);
            piVectorArray[n3] = PiVector.copyNew((PiVector)piVectorArray[n17]);
            if (pgElementSet.hasElementColors()) {
                colorArray[n2] = pgElementSet.getElementColor(n2);
                colorArray[n17] = pgElementSet.getElementColor(n17);
                colorArray[n3] = PdColor.blend((double)0.5, (Color)colorArray[n2], (double)0.5, (Color)colorArray[n17]);
            }
            if (pgElementSet.hasElementBackColors()) {
                colorArray2[n2] = pgElementSet.getElementBackColor(n2);
                colorArray2[n17] = pgElementSet.getElementBackColor(n17);
                colorArray2[n3] = PdColor.blend((double)0.5, (Color)colorArray2[n2], (double)0.5, (Color)colorArray2[n17]);
            }
            if (pgElementSet.getNumVectorFields() > 0) {
                n15 = pgElementSet.getNumVectorFields();
                for (int i = 0; i < n15; ++i) {
                    PgVectorField pgVectorField = pgElementSet.getVectorField(i);
                    if (pgVectorField.getBasedOn() != 1) continue;
                    pgVectorField.setVector(n3, PdVector.blendNew((double)0.5, (PdVector)pgVectorField.getVector(n2), (double)0.5, (PdVector)pgVectorField.getVector(n17)));
                }
            }
            piVectorArray4[n17] = PiVector.copyNew((PiVector)piVectorArray2[n17]);
            n15 = -1;
            if (piVectorArray2[n17].m_data[2] == n25) {
                n15 = piVectorArray2[n17].m_data[1];
                piVectorArray4[n3].m_data[1] = n14;
                piVectorArray4[n17].m_data[2] = piVectorArray4[n17].m_data[1];
                piVectorArray4[n17].m_data[1] = piVectorArray4[n17].m_data[0];
                piVectorArray4[n17].m_data[0] = n14;
                piVectorArray[n3].m_data[2] = n17;
                piVectorArray[n17].m_data[1] = piVectorArray[n17].m_data[0];
                piVectorArray[n17].m_data[0] = piVectorArray[n17].m_data[2];
                piVectorArray[n17].m_data[2] = n3;
            } else {
                n15 = piVectorArray2[n17].m_data[2];
                piVectorArray4[n3].m_data[2] = n14;
                piVectorArray4[n17].m_data[1] = piVectorArray4[n17].m_data[2];
                piVectorArray4[n17].m_data[2] = piVectorArray4[n17].m_data[0];
                piVectorArray4[n17].m_data[0] = n14;
                piVectorArray[n3].m_data[1] = n17;
                piVectorArray[n17].m_data[2] = piVectorArray[n17].m_data[0];
                piVectorArray[n17].m_data[0] = piVectorArray[n17].m_data[1];
                piVectorArray[n17].m_data[1] = n3;
            }
            if (!blArray[n16]) {
                pdVectorArray[n16].blend(1.0, pdVectorArray[n16], 0.13333333333333333, pgElementSet.getVertex(n25), 0.36666666666666664, pgElementSet.getVertex(n16));
            }
            if (!blArray[n15]) {
                pdVectorArray[n15].blend(1.0, pdVectorArray[n15], 0.13333333333333333, pgElementSet.getVertex(n25), 0.36666666666666664, pgElementSet.getVertex(n15));
            }
            if (pgElementSet.hasBoundary()) {
                PgBndPolygon[] pgBndPolygonArray = pgElementSet.getBoundaries();
                int n26 = pgBndPolygonArray.length;
                for (n = 0; n < n26; ++n) {
                    int n27 = pgBndPolygonArray[n].getNumVertices();
                    PiVector piVector6 = pgBndPolygonArray[n].getVertexInd();
                    for (int i = 0; i < n27 - 3; ++i) {
                        if (piVector6.m_data[i] == n16 && piVector6.m_data[i + 3] == n15) {
                            piVector6.m_data[i + 1] = n25;
                            piVector6.m_data[i + 2] = n14;
                            continue;
                        }
                        if (piVector6.m_data[i] != n15 || piVector6.m_data[i + 3] != n16) continue;
                        piVector6.m_data[i + 2] = n25;
                        piVector6.m_data[i + 1] = n14;
                    }
                }
            }
            PdVector pdVector = PdVector.blendNew((double)0.3333333333333333, (PdVector)pgElementSet.getVertex(n15), (double)0.6666666666666666, (PdVector)pgElementSet.getVertex(n25));
            pgElementSet.setVertex(n14, pdVector);
            if (pgElementSet.hasVertexColors()) {
                Color color = PdColor.blend((double)0.3333333333333333, (Color)pgElementSet.getVertexColor(n15), (double)0.6666666666666666, (Color)pgElementSet.getVertexColor(n25));
                pgElementSet.setVertexColor(n14, color);
            }
            if (pgElementSet.hasVertexTextures()) {
                PdVector[] pdVectorArray2 = pgElementSet.getVertexTextures();
                pdVectorArray2[n14] = PdVector.blendNew((double)0.3333333333333333, (PdVector)pdVectorArray2[n15], (double)0.6666666666666666, (PdVector)pdVectorArray2[n25]);
            }
            if (pgElementSet.getNumVectorFields() > 0) {
                int n28 = pgElementSet.getNumVectorFields();
                for (n = 0; n < n28; ++n) {
                    PgVectorField pgVectorField = pgElementSet.getVectorField(n);
                    if (pgVectorField.getBasedOn() != 0) continue;
                    pgVectorField.setVector(n14, PdVector.blendNew((double)0.3333333333333333, (PdVector)pgVectorField.getVector(n15), (double)0.6666666666666666, (PdVector)pgVectorField.getVector(n25)));
                }
            }
            pdVectorArray[n25] = PdVector.blendNew((double)0.3333333333333333, (PdVector)pgElementSet.getVertex(n16), (double)0.6666666666666666, (PdVector)pgElementSet.getVertex(n25));
            if (pgElementSet.hasVertexColors()) {
                Color color = PdColor.blend((double)0.3333333333333333, (Color)pgElementSet.getVertexColor(n16), (double)0.6666666666666666, (Color)pgElementSet.getVertexColor(n25));
                pgElementSet.setVertexColor(n25, color);
            }
            if (pgElementSet.hasVertexTextures()) {
                PdVector[] pdVectorArray3 = pgElementSet.getVertexTextures();
                pdVectorArray3[n25] = PdVector.blendNew((double)0.3333333333333333, (PdVector)pdVectorArray3[n16], (double)0.6666666666666666, (PdVector)pdVectorArray3[n25]);
            }
            if (pgElementSet.getNumVectorFields() > 0) {
                int n29 = pgElementSet.getNumVectorFields();
                for (n = 0; n < n29; ++n) {
                    PgVectorField pgVectorField = pgElementSet.getVectorField(n);
                    if (pgVectorField.getBasedOn() != 0) continue;
                    pgVectorField.setVector(n25, PdVector.blendNew((double)0.3333333333333333, (PdVector)pgVectorField.getVector(n16), (double)0.6666666666666666, (PdVector)pgVectorField.getVector(n25)));
                }
            }
            ++n14;
            ++n3;
        }
        for (n2 = 0; n2 < n11; ++n2) {
            int n30;
            int n31 = piVectorArray[n2].m_data[0];
            if (n31 <= n2) continue;
            PiVector piVector7 = PiVector.copyNew((PiVector)piVectorArray4[n2]);
            PiVector piVector8 = PiVector.copyNew((PiVector)piVectorArray4[n31]);
            PiVector piVector9 = PiVector.copyNew((PiVector)piVectorArray[n2]);
            PiVector piVector10 = PiVector.copyNew((PiVector)piVectorArray[n31]);
            if (piVector7.m_data[1] == piVector8.m_data[2]) {
                piVectorArray4[n2].m_data[0] = piVector7.m_data[2];
                piVectorArray4[n2].m_data[1] = piVector7.m_data[0];
                piVectorArray4[n2].m_data[2] = piVector8.m_data[0];
                piVectorArray4[n31].m_data[0] = piVector8.m_data[2];
                piVectorArray4[n31].m_data[1] = piVector8.m_data[0];
                piVectorArray4[n31].m_data[2] = piVector7.m_data[0];
                piVectorArray[n2].m_data[1] = piVector10.m_data[2];
                piVectorArray[n2].m_data[2] = piVector9.m_data[1];
                piVectorArray[n31].m_data[1] = piVector9.m_data[2];
                piVectorArray[n31].m_data[2] = piVector10.m_data[1];
                if (piVectorArray[n2].m_data[1] != -1) {
                    for (n30 = 0; n30 < 3; ++n30) {
                        if (piVectorArray[piVectorArray[n2].m_data[1]].m_data[n30] != n31) continue;
                        piVectorArray[piVectorArray[n2].m_data[1]].m_data[n30] = n2;
                    }
                }
                if (piVectorArray[n31].m_data[1] != -1) {
                    for (n30 = 0; n30 < 3; ++n30) {
                        if (piVectorArray[piVectorArray[n31].m_data[1]].m_data[n30] != n2) continue;
                        piVectorArray[piVectorArray[n31].m_data[1]].m_data[n30] = n31;
                    }
                }
            } else {
                piVectorArray4[n2].m_data[0] = piVector7.m_data[2];
                piVectorArray4[n2].m_data[1] = piVector7.m_data[0];
                piVectorArray4[n2].m_data[2] = piVector8.m_data[0];
                piVectorArray4[n31].m_data[0] = piVector8.m_data[1];
                piVectorArray4[n31].m_data[1] = piVector7.m_data[0];
                piVectorArray4[n31].m_data[2] = piVector8.m_data[0];
                piVectorArray[n2].m_data[1] = piVector10.m_data[1];
                piVectorArray[n2].m_data[2] = piVector9.m_data[1];
                piVectorArray[n31].m_data[1] = piVector10.m_data[2];
                piVectorArray[n31].m_data[2] = piVector9.m_data[2];
                if (piVectorArray[n2].m_data[1] != -1) {
                    for (n30 = 0; n30 < 3; ++n30) {
                        if (piVectorArray[piVectorArray[n2].m_data[1]].m_data[n30] != n31) continue;
                        piVectorArray[piVectorArray[n2].m_data[1]].m_data[n30] = n2;
                    }
                }
                if (piVectorArray[n31].m_data[2] != -1) {
                    for (n30 = 0; n30 < 3; ++n30) {
                        if (piVectorArray[piVectorArray[n31].m_data[2]].m_data[n30] != n2) continue;
                        piVectorArray[piVectorArray[n31].m_data[2]].m_data[n30] = n31;
                    }
                }
            }
            if (pgElementSet.hasElementColors()) {
                colorArray[n2] = PdColor.blend((double)0.5, (Color)colorArray[n2], (double)0.5, (Color)colorArray[n31]);
                colorArray[n31] = colorArray[n2];
            }
            if (pgElementSet.hasElementBackColors()) {
                colorArray2[n2] = PdColor.blend((double)0.5, (Color)colorArray2[n2], (double)0.5, (Color)colorArray2[n31]);
                colorArray2[n31] = colorArray2[n2];
            }
            if (pgElementSet.getNumVectorFields() <= 0) continue;
            int n32 = pgElementSet.getNumVectorFields();
            for (n = 0; n < n32; ++n) {
                PgVectorField pgVectorField = pgElementSet.getVectorField(n);
                if (pgVectorField.getBasedOn() != 1) continue;
                pgVectorField.setVector(n2, PdVector.blendNew((double)0.5, (PdVector)pgVectorField.getVector(n2), (double)0.5, (PdVector)pgVectorField.getVector(n31)));
                pgVectorField.setVector(n31, PdVector.copyNew((PdVector)pgVectorField.getVector(n2)));
            }
        }
        for (n2 = 0; n2 < n9; ++n2) {
            pgElementSet.setVertex(n2, pdVectorArray[n2]);
        }
        pgElementSet.setNumElements(n11);
        pgElementSet.setElements(piVectorArray4);
        if (pgElementSet.hasElementColors()) {
            pgElementSet.setElementColors(colorArray);
        }
        if (pgElementSet.hasElementBackColors()) {
            pgElementSet.setElementBackColors(colorArray2);
        }
        pgElementSet.setNeighbours(piVectorArray);
        if (pgElementSet.hasBoundary()) {
            PgBndPolygon[] pgBndPolygonArray = pgElementSet.getBoundaries();
            int n33 = pgBndPolygonArray.length;
            for (int i = 0; i < n33; ++i) {
                if (pgBndPolygonArray[i].makeElementInd()) continue;
                pgElementSet.removeBoundaries();
                break;
            }
        }
        if (pgElementSet.hasVertexNormals()) {
            pgElementSet.makeVertexNormals();
        }
        if (pgElementSet.hasElementNormals()) {
            pgElementSet.makeElementNormals();
        }
        if (pgElementSet.isEnabledEdges()) {
            pgElementSet.makeEdgeStars();
        }
    }

    public static void refineDooSabin(PgElementSet pgElementSet) {
        PiVector piVector;
        PiVector piVector2;
        PiVector piVector3;
        int n;
        int n2;
        PdVector[] pdVectorArray;
        int n3;
        int n4;
        PiVector[] piVectorArray;
        int n5;
        int n6;
        PgBndPolygon[] pgBndPolygonArray;
        PgVertexStar pgVertexStar = new PgVertexStar();
        int n7 = pgElementSet.getNumElements();
        int n8 = pgElementSet.getNumVertices();
        PiVector[] piVectorArray2 = pgElementSet.getElements();
        PdVector[] pdVectorArray2 = pgElementSet.getVertices();
        boolean bl = pgElementSet.hasVertexColors();
        boolean bl2 = pgElementSet.hasVertexTextures();
        boolean bl3 = pgElementSet.hasElementTextures();
        boolean bl4 = pgElementSet.hasElementColors();
        boolean bl5 = pgElementSet.hasElementBackColors();
        boolean[] blArray = new boolean[n8];
        if (pgElementSet.hasBoundary()) {
            pgBndPolygonArray = pgElementSet.getBoundaries();
            for (n6 = 0; n6 < pgBndPolygonArray.length; ++n6) {
                blArray[pgBndPolygonArray[n6].getVertexInd().m_data[0]] = true;
                blArray[pgBndPolygonArray[n6].getVertexInd().m_data[pgBndPolygonArray[n6].getNumVertices() - 1]] = true;
            }
        }
        pgBndPolygonArray = new PiVector[n8][];
        n6 = 0;
        int n9 = n7 + n8;
        for (n5 = 0; n5 < n8; ++n5) {
            if (!blArray[n5]) continue;
            ++n6;
        }
        for (n5 = 0; n5 < n7; ++n5) {
            piVectorArray = pgElementSet.getNeighbour(n5);
            int n10 = piVectorArray.getSize();
            for (n4 = 0; n4 < n10; ++n4) {
                if (piVectorArray.m_data[n4] < n5) {
                    ++n9;
                }
                if (piVectorArray.m_data[n4] != -1) continue;
                n6 += 2;
            }
            n6 += n10;
        }
        PdVector[] pdVectorArray3 = new PdVector[n6];
        piVectorArray = new PiVector[n9];
        Color[] colorArray = new Color[n9];
        if (bl4) {
            for (n4 = 0; n4 < n7; ++n4) {
                colorArray[n4] = pgElementSet.getElementColor(n4);
            }
        }
        Color[] colorArray2 = new Color[n9];
        if (bl5) {
            for (n3 = 0; n3 < n7; ++n3) {
                colorArray2[n3] = pgElementSet.getElementBackColor(n3);
            }
        }
        n3 = pgElementSet.getNumVectorFields();
        PdVector[][] pdVectorArrayArray = new PdVector[n3][];
        for (int i = 0; i < n3; ++i) {
            pdVectorArray = pgElementSet.getVectorField(i);
            if (pdVectorArray.getBasedOn() == 1) {
                pdVectorArrayArray[i] = new PdVector[n9];
                for (n2 = 0; n2 < n7; ++n2) {
                    pdVectorArrayArray[i][n2] = PdVector.copyNew((PdVector)pdVectorArray.getVector(n2));
                }
                continue;
            }
            pdVectorArrayArray[i] = new PdVector[n6];
        }
        Color[] colorArray3 = new Color[n6];
        pdVectorArray = new PdVector[n6];
        for (n2 = 0; n2 < n7; ++n2) {
            piVectorArray[n2] = new PiVector(piVectorArray2[n2].getSize());
        }
        n2 = n8;
        int n11 = n7;
        PiVector piVector4 = PgVertexStar.getElementPerVertex(pgElementSet);
        for (n = 0; n < n8; ++n) {
            int n12;
            int n13;
            int n14;
            int n15;
            int n16;
            pgVertexStar.makeVertexStar(pgElementSet, n, piVector4.m_data[n]);
            piVector3 = pgVertexStar.getElement();
            piVector2 = pgVertexStar.getLink();
            PiVector piVector5 = pgVertexStar.getVertexLocInd();
            int n17 = pgVertexStar.getSize();
            if (pgVertexStar.isClosed()) {
                piVector = new PiVector(n17);
                piVector.m_data[0] = n;
                for (n16 = 1; n16 < n17; ++n16) {
                    piVector.m_data[n16] = n2++;
                }
                n16 = 0;
                for (n15 = 0; n15 < n17; ++n15) {
                    piVectorArray[piVector3.m_data[n15]].m_data[piVector5.m_data[n15]] = piVector.m_data[n15];
                    if (piVector2.m_data[n15] <= n) continue;
                    ++n16;
                }
                pgBndPolygonArray[n] = new PiVector[n16];
                n16 = 0;
                for (n15 = 0; n15 < n17; ++n15) {
                    n14 = piVector2.m_data[n15];
                    if (n14 > n) {
                        pgBndPolygonArray[n][n16] = new PiVector(9);
                        pgBndPolygonArray[n][n16].m_data[0] = n14;
                        pgBndPolygonArray[n][n16].m_data[1] = piVector.m_data[(n17 + n15 - 1) % n17];
                        pgBndPolygonArray[n][n16].m_data[2] = piVector3.m_data[(n17 + n15 - 1) % n17];
                        pgBndPolygonArray[n][n16].m_data[3] = piVector.m_data[n15];
                        pgBndPolygonArray[n][n16].m_data[4] = piVector3.m_data[n15];
                        ++n16;
                        continue;
                    }
                    n13 = ((PgBndPolygon)pgBndPolygonArray[n14]).length;
                    for (n12 = 0; n12 < n13; ++n12) {
                        if (pgBndPolygonArray[n14][n12].m_data[0] != n) continue;
                        pgBndPolygonArray[n14][n12].m_data[5] = piVector.m_data[(n17 + n15 - 1) % n17];
                        pgBndPolygonArray[n14][n12].m_data[6] = piVector3.m_data[(n17 + n15 - 1) % n17];
                        pgBndPolygonArray[n14][n12].m_data[7] = piVector.m_data[n15];
                        pgBndPolygonArray[n14][n12].m_data[8] = piVector3.m_data[n15];
                    }
                }
            } else if (blArray[n]) {
                piVector = new PiVector(n17 + 3);
                piVector.m_data[0] = n;
                pdVectorArray3[n] = PdVector.copyNew((PdVector)pdVectorArray2[n]);
                for (n16 = 1; n16 < n17 + 3; ++n16) {
                    piVector.m_data[n16] = n2++;
                }
                for (n16 = 0; n16 < n17; ++n16) {
                    piVectorArray[piVector3.m_data[n16]].m_data[piVector5.m_data[n16]] = piVector.m_data[n16 + 2];
                }
                n16 = 0;
                for (n15 = 0; n15 < n17 + 1; ++n15) {
                    if (piVector2.m_data[n15] <= n) continue;
                    ++n16;
                }
                pgBndPolygonArray[n] = new PiVector[n16];
                n16 = 0;
                for (n15 = 0; n15 < n17 + 1; ++n15) {
                    int n18 = piVector2.m_data[n15];
                    if (n18 > n) {
                        pgBndPolygonArray[n][n16] = new PiVector(9);
                        pgBndPolygonArray[n][n16].m_data[0] = n18;
                        pgBndPolygonArray[n][n16].m_data[1] = piVector.m_data[n15 + 1];
                        pgBndPolygonArray[n][n16].m_data[2] = n15 == 0 ? -1 : piVector3.m_data[n15 - 1];
                        pgBndPolygonArray[n][n16].m_data[3] = piVector.m_data[n15 + 2];
                        pgBndPolygonArray[n][n16].m_data[4] = n15 == n17 ? -1 : piVector3.m_data[n15];
                        ++n16;
                        continue;
                    }
                    n13 = ((PgBndPolygon)pgBndPolygonArray[n18]).length;
                    for (int i = 0; i < n13; ++i) {
                        if (pgBndPolygonArray[n18][i].m_data[0] != n) continue;
                        pgBndPolygonArray[n18][i].m_data[5] = piVector.m_data[n15 + 1];
                        pgBndPolygonArray[n18][i].m_data[6] = n15 == 0 ? -1 : piVector3.m_data[n15 - 1];
                        pgBndPolygonArray[n18][i].m_data[7] = piVector.m_data[n15 + 2];
                        pgBndPolygonArray[n18][i].m_data[8] = n15 == n17 ? -1 : piVector3.m_data[n15];
                    }
                }
                if (bl2) {
                    pdVectorArray[n] = pgElementSet.getVertexTexture(n);
                }
                for (n15 = 0; n15 < n3; ++n15) {
                    PgVectorField pgVectorField = pgElementSet.getVectorField(n15);
                    if (pgVectorField.getBasedOn() != 0) continue;
                    pdVectorArrayArray[n15][n] = PdVector.copyNew((PdVector)pgVectorField.getVector(n));
                }
            } else {
                piVector = new PiVector(n17 + 2);
                piVector.m_data[0] = n;
                for (n16 = 1; n16 < n17 + 2; ++n16) {
                    piVector.m_data[n16] = n2++;
                }
                for (n16 = 0; n16 < n17; ++n16) {
                    piVectorArray[piVector3.m_data[n16]].m_data[piVector5.m_data[n16]] = piVector.m_data[n16 + 1];
                }
                n16 = 0;
                for (n15 = 0; n15 < n17 + 1; ++n15) {
                    if (piVector2.m_data[n15] <= n) continue;
                    ++n16;
                }
                pgBndPolygonArray[n] = new PiVector[n16];
                n16 = 0;
                for (n15 = 0; n15 < n17 + 1; ++n15) {
                    int n19 = piVector2.m_data[n15];
                    if (n19 > n) {
                        pgBndPolygonArray[n][n16] = new PiVector(9);
                        pgBndPolygonArray[n][n16].m_data[0] = n19;
                        pgBndPolygonArray[n][n16].m_data[1] = piVector.m_data[n15];
                        pgBndPolygonArray[n][n16].m_data[2] = n15 == 0 ? -1 : piVector3.m_data[n15 - 1];
                        pgBndPolygonArray[n][n16].m_data[3] = piVector.m_data[n15 + 1];
                        pgBndPolygonArray[n][n16].m_data[4] = n15 == n17 ? -1 : piVector3.m_data[n15];
                        ++n16;
                        continue;
                    }
                    n13 = ((PgBndPolygon)pgBndPolygonArray[n19]).length;
                    for (int i = 0; i < n13; ++i) {
                        if (pgBndPolygonArray[n19][i].m_data[0] != n) continue;
                        pgBndPolygonArray[n19][i].m_data[5] = piVector.m_data[n15];
                        pgBndPolygonArray[n19][i].m_data[6] = n15 == 0 ? -1 : piVector3.m_data[n15 - 1];
                        pgBndPolygonArray[n19][i].m_data[7] = piVector.m_data[n15 + 1];
                        pgBndPolygonArray[n19][i].m_data[8] = n15 == n17 ? -1 : piVector3.m_data[n15];
                    }
                }
            }
            piVectorArray[n11] = piVector;
            if (bl4) {
                Color color;
                n16 = 0;
                n15 = 0;
                n14 = 0;
                for (n12 = 0; n12 < n17; ++n12) {
                    Color color2 = pgElementSet.getElementColor(piVector3.m_data[n12]);
                    n16 += color2.getRed();
                    n15 += color2.getGreen();
                    n14 += color2.getBlue();
                }
                colorArray[n11] = color = new Color(n16 / n17, n15 / n17, n14 / n17);
            }
            if (bl5) {
                Color color;
                n16 = 0;
                n15 = 0;
                n14 = 0;
                for (int i = 0; i < n17; ++i) {
                    Color color3 = pgElementSet.getElementBackColor(piVector3.m_data[i]);
                    n16 += color3.getRed();
                    n15 += color3.getGreen();
                    n14 += color3.getBlue();
                }
                colorArray2[n11] = color = new Color(n16 / n17, n15 / n17, n14 / n17);
            }
            for (n16 = 0; n16 < n3; ++n16) {
                PgVectorField pgVectorField = pgElementSet.getVectorField(n16);
                if (pgVectorField.getBasedOn() != 1) continue;
                PdVector pdVector = PdVector.copyNew((PdVector)pgVectorField.getVector(piVector3.m_data[0]));
                for (n13 = 1; n13 < n17; ++n13) {
                    pdVector.add(pgVectorField.getVector(piVector3.m_data[n13]));
                }
                pdVector.multScalar(1.0 / (double)n17);
                pdVectorArrayArray[n16][n11] = pdVector;
            }
            ++n11;
        }
        for (n = 0; n < n7; ++n) {
            int n20;
            int n21;
            piVector3 = piVectorArray2[n];
            piVector2 = piVectorArray[n];
            int n22 = piVector3.getSize();
            PdVector[] pdVectorArray4 = new PdVector[n22];
            piVector = new PdVector[n22];
            PdVector pdVector = new PdVector(n22);
            pdVector.m_data[0] = ((double)n22 + 5.0) / (4.0 * (double)n22);
            for (n21 = 0; n21 < n22; ++n21) {
                pdVectorArray4[n21] = pdVectorArray2[piVector3.m_data[n21]];
                piVector[n21] = PdVector.copyNew((PdVector)pdVectorArray4[n21]);
                piVector[n21].multScalar(pdVector.m_data[0]);
                pdVectorArray3[piVector2.m_data[n21]] = piVector[n21];
            }
            for (n21 = 1; n21 < n22; ++n21) {
                pdVector.m_data[n21] = (3.0 + 2.0 * Math.cos(Math.PI * 2 * (double)n21 / (double)n22)) / (4.0 * (double)n22);
                for (int i = 0; i < n22; ++i) {
                    piVector[i].blendBase((PdVector)piVector[i], pdVector.m_data[n21], pdVectorArray4[(i + n21) % n22]);
                }
            }
            if (bl) {
                int n23;
                PdVector pdVector2 = new PdVector(n22);
                PdVector pdVector3 = new PdVector(n22);
                PdVector pdVector4 = new PdVector(n22);
                for (n23 = 0; n23 < n22; ++n23) {
                    Color color = pgElementSet.getVertexColor(piVector3.m_data[n23]);
                    double d = color.getRed();
                    double d2 = color.getGreen();
                    double d3 = color.getBlue();
                    for (int i = 0; i < n22; ++i) {
                        int n24 = i;
                        pdVector2.m_data[n24] = pdVector2.m_data[n24] + d * pdVector.m_data[(i - n23 + n22) % n22];
                        int n25 = i;
                        pdVector3.m_data[n25] = pdVector3.m_data[n25] + d2 * pdVector.m_data[(i - n23 + n22) % n22];
                        int n26 = i;
                        pdVector4.m_data[n26] = pdVector4.m_data[n26] + d3 * pdVector.m_data[(i - n23 + n22) % n22];
                    }
                }
                for (n23 = 0; n23 < n22; ++n23) {
                    colorArray3[piVector2.m_data[n23]] = new Color((int)pdVector2.m_data[n23], (int)pdVector3.m_data[n23], (int)pdVector4.m_data[n23]);
                }
            }
            for (int i = 0; i < n3; ++i) {
                int n27;
                PgVectorField pgVectorField = pgElementSet.getVectorField(i);
                if (pgVectorField.getBasedOn() != 0) continue;
                PdVector[] pdVectorArray5 = new PdVector[n22];
                PdVector[] pdVectorArray6 = new PdVector[n22];
                for (n27 = 0; n27 < n22; ++n27) {
                    pdVectorArray5[n27] = pgVectorField.getVector(piVector3.m_data[n27]);
                    pdVectorArray6[n27] = PdVector.copyNew((PdVector)pdVectorArray5[n27]);
                    pdVectorArray6[n27].multScalar(pdVector.m_data[0]);
                    pdVectorArrayArray[i][piVector2.m_data[n27]] = pdVectorArray6[n27];
                }
                for (n27 = 1; n27 < n22; ++n27) {
                    for (int j = 0; j < n22; ++j) {
                        pdVectorArray6[j].blendBase(pdVectorArray6[j], pdVector.m_data[n27], pdVectorArray5[(j + n27) % n22]);
                    }
                }
            }
            if (bl2) {
                int n28;
                PdVector[] pdVectorArray7 = new PdVector[n22];
                for (int i = 0; i < n22; ++i) {
                    pdVectorArray7[i] = pgElementSet.getVertexTextures()[piVector3.m_data[i]];
                }
                PdVector[] pdVectorArray8 = new PdVector[n22];
                for (n28 = 0; n28 < n22; ++n28) {
                    pdVectorArray8[n28] = PdVector.copyNew((PdVector)pdVectorArray7[n28]);
                    pdVectorArray8[n28].multScalar(pdVector.m_data[0]);
                    pdVectorArray[piVector2.m_data[n28]] = pdVectorArray8[n28];
                }
                for (n28 = 1; n28 < n22; ++n28) {
                    for (int i = 0; i < n22; ++i) {
                        pdVectorArray8[i].blendBase(pdVectorArray8[i], pdVector.m_data[n28], pdVectorArray7[(i + n28) % n22]);
                    }
                }
            }
            if (!bl3) continue;
            PdVector[] pdVectorArray9 = pgElementSet.getElementTexture(n);
            PdVector[] pdVectorArray10 = new PdVector[n22];
            for (n20 = 0; n20 < n22; ++n20) {
                pdVectorArray10[n20] = PdVector.copyNew((PdVector)pdVectorArray9[n20]);
                pdVectorArray10[n20].multScalar(pdVector.m_data[0]);
            }
            for (n20 = 1; n20 < n22; ++n20) {
                for (int i = 0; i < n22; ++i) {
                    pdVectorArray10[i].blendBase(pdVectorArray10[i], pdVector.m_data[n20], pdVectorArray9[(i + n20) % n22]);
                }
            }
            pgElementSet.setElementTexture(n, pdVectorArray10);
        }
        for (n = 0; n < n8; ++n) {
            int n29 = ((PgBndPolygon)pgBndPolygonArray[n]).length;
            for (int i = 0; i < n29; ++i) {
                PiVector piVector6;
                PgBndPolygon pgBndPolygon = pgBndPolygonArray[n][i];
                if (pgBndPolygon.m_data[2] == -1 || pgBndPolygon.m_data[4] == -1) {
                    piVector6 = new PiVector(2);
                    if (pgBndPolygon.m_data[2] == -1) {
                        pdVectorArray3[pgBndPolygon.m_data[1]] = PdVector.copyNew((PdVector)pdVectorArray3[pgBndPolygon.m_data[3]]);
                        piVector6.m_data[0] = pgBndPolygon.m_data[1];
                    } else {
                        pdVectorArray3[pgBndPolygon.m_data[3]] = PdVector.copyNew((PdVector)pdVectorArray3[pgBndPolygon.m_data[1]]);
                        piVector6.m_data[0] = pgBndPolygon.m_data[3];
                    }
                    if (pgBndPolygon.m_data[6] == -1) {
                        pdVectorArray3[pgBndPolygon.m_data[5]] = PdVector.copyNew((PdVector)pdVectorArray3[pgBndPolygon.m_data[7]]);
                        piVector6.m_data[1] = pgBndPolygon.m_data[5];
                    } else {
                        pdVectorArray3[pgBndPolygon.m_data[7]] = PdVector.copyNew((PdVector)pdVectorArray3[pgBndPolygon.m_data[5]]);
                        piVector6.m_data[1] = pgBndPolygon.m_data[7];
                    }
                    PdVector pdVector = pdVectorArray2[n];
                    PdVector pdVector5 = pdVectorArray2[pgBndPolygon.m_data[0]];
                    PdVector pdVector6 = new PdVector(2);
                    for (int j = 0; j < 2; ++j) {
                        pdVector6.m_data[j] = PdVector.dot((PdVector)pdVector, (PdVector)pdVectorArray3[piVector6.m_data[j]], (PdVector)pdVector5) / pdVector.sqrDist(pdVector5);
                        pdVectorArray3[piVector6.m_data[j]].blend(1.0 - pdVector6.m_data[j], pdVector, pdVector6.m_data[j], pdVector5);
                    }
                    if (bl) {
                        Color color = pgElementSet.getVertexColor(n);
                        Color color4 = pgElementSet.getVertexColor(pgBndPolygon.m_data[0]);
                        for (int j = 0; j < 2; ++j) {
                            colorArray3[piVector6.m_data[j]] = PdColor.blend((double)(1.0 - pdVector6.m_data[j]), (Color)color, (double)pdVector6.m_data[j], (Color)color4);
                        }
                    }
                    for (int j = 0; j < n3; ++j) {
                        PgVectorField pgVectorField = pgElementSet.getVectorField(j);
                        if (pgVectorField.getBasedOn() != 0) continue;
                        PdVector pdVector7 = pgVectorField.getVector(n);
                        PdVector pdVector8 = pgVectorField.getVector(pgBndPolygon.m_data[0]);
                        for (int k = 0; k < 2; ++k) {
                            pdVectorArrayArray[j][piVector6.m_data[k]] = PdVector.blendNew((double)(1.0 - pdVector6.m_data[k]), (PdVector)pdVector7, (double)pdVector6.m_data[k], (PdVector)pdVector8);
                        }
                    }
                    if (bl2) {
                        PdVector pdVector9 = pgElementSet.getVertexTextures()[n];
                        PdVector pdVector10 = pgElementSet.getVertexTextures()[pgBndPolygon.m_data[0]];
                        for (int j = 0; j < 2; ++j) {
                            pdVectorArray[piVector6.m_data[j]] = PdVector.blendNew((double)(1.0 - pdVector6.m_data[j]), (PdVector)pdVector9, (double)pdVector6.m_data[j], (PdVector)pdVector10);
                        }
                    }
                }
                piVector6 = new PiVector(4);
                piVector6.m_data[0] = pgBndPolygon.m_data[3];
                piVector6.m_data[1] = pgBndPolygon.m_data[1];
                if (pgBndPolygon.m_data[2] == pgBndPolygon.m_data[6]) {
                    piVector6.m_data[2] = pgBndPolygon.m_data[5];
                    piVector6.m_data[3] = pgBndPolygon.m_data[7];
                } else {
                    piVector6.m_data[2] = pgBndPolygon.m_data[7];
                    piVector6.m_data[3] = pgBndPolygon.m_data[5];
                }
                piVectorArray[n11] = piVector6;
                if (bl4) {
                    Color color;
                    int n30 = 0;
                    int n31 = 0;
                    int n32 = 0;
                    int n33 = 0;
                    for (int j = 0; j < 2; ++j) {
                        if (pgBndPolygon.m_data[2 + 2 * j] == -1) continue;
                        Color color5 = pgElementSet.getElementColor(pgBndPolygon.m_data[2 + 2 * j]);
                        n30 += color5.getRed();
                        n31 += color5.getGreen();
                        n32 += color5.getBlue();
                        ++n33;
                    }
                    colorArray[n11] = color = new Color(n30 / n33, n31 / n33, n32 / n33);
                }
                if (bl5) {
                    Color color;
                    int n34 = 0;
                    int n35 = 0;
                    int n36 = 0;
                    int n37 = 0;
                    for (int j = 0; j < 2; ++j) {
                        if (pgBndPolygon.m_data[2 + 2 * j] == -1) continue;
                        Color color6 = pgElementSet.getElementBackColor(pgBndPolygon.m_data[2 + 2 * j]);
                        n34 += color6.getRed();
                        n35 += color6.getGreen();
                        n36 += color6.getBlue();
                        ++n37;
                    }
                    colorArray2[n11] = color = new Color(n34 / n37, n35 / n37, n36 / n37);
                }
                for (int j = 0; j < n3; ++j) {
                    PgVectorField pgVectorField = pgElementSet.getVectorField(j);
                    if (pgVectorField.getBasedOn() != 1) continue;
                    PdVector pdVector = new PdVector(pgVectorField.getDimOfVectors());
                    int n38 = 0;
                    for (int k = 0; k < 2; ++k) {
                        if (pgBndPolygon.m_data[2 + 2 * k] == -1) continue;
                        pdVector.add(pgVectorField.getVector(pgBndPolygon.m_data[2 + 2 * k]));
                        ++n38;
                    }
                    pdVector.multScalar(1.0 / (double)n38);
                    pdVectorArrayArray[j][n11] = pdVector;
                }
                ++n11;
            }
        }
        pgElementSet.setNumVertices(n6);
        pgElementSet.setVertices(pdVectorArray3);
        pgElementSet.setNumElements(n9);
        pgElementSet.setElements(piVectorArray);
        if (bl3) {
            pgElementSet.assureElementTextures();
            PdVector[][] pdVectorArray11 = pgElementSet.getElementTextures();
            for (int i = n7; i < n9; ++i) {
                int n39 = pdVectorArray11[i].length;
                for (int j = 0; j < n39; ++j) {
                    pdVectorArray11[i][j].setConstant(0.0);
                }
            }
        }
        if (bl4) {
            for (int i = 0; i < n9; ++i) {
                pgElementSet.setElementColor(i, colorArray[i]);
            }
        }
        if (bl5) {
            for (int i = 0; i < n9; ++i) {
                pgElementSet.setElementBackColor(i, colorArray2[i]);
            }
        }
        if (bl) {
            for (int i = 0; i < n6; ++i) {
                pgElementSet.setVertexColor(i, colorArray3[i]);
            }
        }
        if (bl2) {
            pgElementSet.setVertexTextures(pdVectorArray);
        }
        for (int i = 0; i < n3; ++i) {
            PgVectorField pgVectorField = pgElementSet.getVectorField(i);
            if (pgVectorField.getBasedOn() == 1) {
                pgVectorField.setNumVectors(n9);
            } else {
                pgVectorField.setNumVectors(n6);
            }
            pgVectorField.setVectors(pdVectorArrayArray[i]);
        }
        pgElementSet.makeNeighbour();
        if (pgElementSet.hasBoundary()) {
            int n40;
            PgBndPolygon[] pgBndPolygonArray2 = pgElementSet.getBoundaries();
            for (n40 = 0; n40 < pgBndPolygonArray2.length; ++n40) {
                PiVector piVector7 = pgBndPolygonArray2[n40].getVertexInd();
                int n41 = pgBndPolygonArray2[n40].getNumVertices();
                PiVector piVector8 = new PiVector(n41 * 2);
                piVector8.m_data[0] = piVector7.m_data[0];
                piVector8.m_data[n41 * 2 - 1] = piVector7.m_data[n41 - 1];
                for (int i = 1; i < n41; ++i) {
                    int n42;
                    int n43;
                    PgBndPolygon pgBndPolygon;
                    int n44 = -1;
                    int n45 = -1;
                    int n46 = piVector7.m_data[i - 1];
                    int n47 = piVector7.m_data[i];
                    if (n46 < n47) {
                        pgBndPolygon = pgBndPolygonArray[n46];
                        n43 = ((PgBndPolygon)pgBndPolygon).length;
                        for (n42 = 0; n42 < n43; ++n42) {
                            if (pgBndPolygon[n42].m_data[0] != n47) continue;
                            n44 = pgBndPolygon[n42].m_data[2] == -1 ? pgBndPolygon[n42].m_data[1] : pgBndPolygon[n42].m_data[3];
                            n45 = pgBndPolygon[n42].m_data[6] == -1 ? pgBndPolygon[n42].m_data[5] : pgBndPolygon[n42].m_data[7];
                        }
                    } else {
                        pgBndPolygon = pgBndPolygonArray[n47];
                        n43 = ((PgBndPolygon)pgBndPolygon).length;
                        for (n42 = 0; n42 < n43; ++n42) {
                            if (pgBndPolygon[n42].m_data[0] != n46) continue;
                            n45 = pgBndPolygon[n42].m_data[2] == -1 ? pgBndPolygon[n42].m_data[1] : pgBndPolygon[n42].m_data[3];
                            n44 = pgBndPolygon[n42].m_data[6] == -1 ? pgBndPolygon[n42].m_data[5] : pgBndPolygon[n42].m_data[7];
                        }
                    }
                    piVector8.m_data[2 * i - 1] = n44;
                    piVector8.m_data[2 * i] = n45;
                }
                pgBndPolygonArray2[n40].setNumVertices(n41 * 2);
                pgBndPolygonArray2[n40].getVertexInd().copy(piVector8);
            }
            for (n40 = 0; n40 < pgBndPolygonArray2.length; ++n40) {
                if (pgBndPolygonArray2[n40].makeElementInd()) continue;
                pgElementSet.removeBoundaries();
                break;
            }
        }
        if (pgElementSet.hasElementNormals()) {
            pgElementSet.makeElementNormals();
        }
        if (pgElementSet.hasVertexNormals()) {
            pgElementSet.makeVertexNormals();
        }
        if (pgElementSet.isEnabledEdges()) {
            pgElementSet.makeEdgeStars();
        }
    }

    public void refineSqrt2() {
        this.m_refineSequence.addEntry(8);
        PwRefineElementSet.refineSqrt2((PgElementSet)this.m_geom);
    }

    public static void refineSqrt2(PgElementSet pgElementSet) {
        int n;
        int n2;
        PgBndPolygon[] pgBndPolygonArray;
        PiVector piVector;
        int n3;
        int n4;
        int n5;
        if (!pgElementSet.checkNeighbour(false)) {
            pgElementSet.makeNeighbour();
        }
        pgElementSet.removeUnusedVertices();
        int n6 = pgElementSet.getNumElements();
        int n7 = pgElementSet.getNumVertices();
        PiVector[] piVectorArray = pgElementSet.getElements();
        PiVector[] piVectorArray2 = pgElementSet.getNeighbours();
        PiVector piVector2 = new PiVector(n6);
        piVector2.setConstant(-1);
        int n8 = 0;
        int n9 = n7;
        for (n5 = 0; n5 < n6; ++n5) {
            if (piVector2.m_data[n5] != -1) continue;
            int n10 = piVectorArray2[n5].m_data[0];
            n4 = piVectorArray[n5].getSize();
            if (n10 != -1 && n4 == 3 && piVectorArray[n10].getSize() == 3 && piVectorArray2[n10].m_data[0] == n5) {
                piVector2.m_data[n5] = n10;
                piVector2.m_data[n10] = n5;
                n8 += 4;
            } else {
                n8 = n10 == -1 && n4 == 3 ? (n8 += 2) : (n8 += n4);
            }
            ++n9;
        }
        pgElementSet.markBoundary();
        pgElementSet.setNumElements(n8);
        piVectorArray = pgElementSet.getElements();
        piVectorArray2 = pgElementSet.getNeighbours();
        pgElementSet.setNumVertices(n9);
        n5 = pgElementSet.hasElementTextures() ? 1 : 0;
        PdVector[][] pdVectorArrayArray = new PdVector[n8][];
        if (n5 != 0) {
            for (n4 = 0; n4 < n6; ++n4) {
                pdVectorArrayArray[n4] = PdVector.copyNew((PdVector[])pgElementSet.getElementTextures()[n4]);
            }
        }
        if (pgElementSet.getNumVectorFields() > 0) {
            n4 = pgElementSet.getNumVectorFields();
            for (n3 = 0; n3 < n4; ++n3) {
                piVector = pgElementSet.getVectorField(n3);
                if (piVector.getBasedOn() == 0) {
                    piVector.setNumVectors(n9);
                }
                if (piVector.getBasedOn() != 1) continue;
                piVector.setNumVectors(n8);
            }
        }
        n4 = n6;
        n3 = n7;
        piVector = new PiVector(n7);
        boolean[] blArray = new boolean[n7];
        if (pgElementSet.hasBoundary()) {
            pgBndPolygonArray = pgElementSet.getBoundaries();
            n2 = pgBndPolygonArray.length;
            for (n = 0; n < n2; ++n) {
                PiVector piVector3 = pgBndPolygonArray[n].getVertexInd();
                int n11 = pgBndPolygonArray[n].getNumVertices();
                blArray[piVector3.m_data[0]] = true;
                blArray[piVector3.m_data[n11 - 1]] = true;
            }
        }
        pgBndPolygonArray = PdVector.realloc(null, (int)n7, (int)pgElementSet.getDimOfVertices());
        for (n2 = 0; n2 < n6; ++n2) {
            int n12;
            PdVector pdVector;
            int n13;
            PgVectorField pgVectorField;
            PdVector pdVector2;
            PiVector piVector4;
            PiVector piVector5;
            n = piVector2.m_data[n2];
            if (n > n2) {
                int n14;
                PdVector pdVector3;
                PdVector pdVector4 = PdVector.blendNew((double)0.25, (PdVector)pgElementSet.getVertex(piVectorArray[n2].m_data[0]), (double)0.25, (PdVector)pgElementSet.getVertex(piVectorArray[n].m_data[0]), (double)0.25, (PdVector)pgElementSet.getVertex(piVectorArray[n2].m_data[1]), (double)0.25, (PdVector)pgElementSet.getVertex(piVectorArray[n2].m_data[2]));
                pgElementSet.setVertex(n3, pdVector4);
                if (pgElementSet.hasVertexColors()) {
                    Color color = PdColor.blend((double)0.25, (Color)pgElementSet.getVertexColor(piVectorArray[n2].m_data[0]), (double)0.25, (Color)pgElementSet.getVertexColor(piVectorArray[n].m_data[0]));
                    PdColor.blend((double)1.0, (Color)color, (double)0.25, (Color)pgElementSet.getVertexColor(piVectorArray[n2].m_data[1]));
                    PdColor.blend((double)1.0, (Color)color, (double)0.25, (Color)pgElementSet.getVertexColor(piVectorArray[n2].m_data[2]));
                    pgElementSet.setVertexColor(n3, color);
                }
                if (pgElementSet.hasVertexTextures()) {
                    PdVector[] pdVectorArray = pgElementSet.getVertexTextures();
                    pdVectorArray[n3] = PdVector.blendNew((double)0.25, (PdVector)pdVectorArray[piVectorArray[n2].m_data[0]], (double)0.25, (PdVector)pdVectorArray[piVectorArray[n].m_data[0]], (double)0.25, (PdVector)pdVectorArray[piVectorArray[n2].m_data[1]], (double)0.25, (PdVector)pdVectorArray[piVectorArray[n2].m_data[2]]);
                }
                if (pgElementSet.getNumVectorFields() > 0) {
                    int n15 = pgElementSet.getNumVectorFields();
                    for (int i = 0; i < n15; ++i) {
                        piVector5 = pgElementSet.getVectorField(i);
                        if (piVector5.getBasedOn() != 0) continue;
                        pdVector3 = PdVector.blendNew((double)0.25, (PdVector)piVector5.getVector(piVectorArray[n2].m_data[0]), (double)0.25, (PdVector)piVector5.getVector(piVectorArray[n].m_data[0]), (double)0.25, (PdVector)piVector5.getVector(piVectorArray[n2].m_data[1]), (double)0.25, (PdVector)piVector5.getVector(piVectorArray[n2].m_data[2]));
                        piVector5.setVector(n3, pdVector3);
                    }
                }
                PiVector piVector6 = new PiVector(n3, piVectorArray[n2].m_data[2], piVectorArray[n2].m_data[0]);
                piVector4 = new PiVector(n3, piVectorArray[n2].m_data[0], piVectorArray[n2].m_data[1]);
                piVector5 = new PiVector(n3, piVectorArray[n].m_data[2], piVectorArray[n].m_data[0]);
                pdVector3 = new PiVector(n3, piVectorArray[n].m_data[0], piVectorArray[n].m_data[1]);
                PiVector piVector7 = new PiVector(piVectorArray2[n2].m_data[1], n4, n4 + 1);
                pdVector2 = new PiVector(piVectorArray2[n2].m_data[2], n, n2);
                PiVector piVector8 = new PiVector(piVectorArray2[n].m_data[1], n4 + 1, n4);
                pgVectorField = new PiVector(piVectorArray2[n].m_data[2], n2, n);
                if (pgElementSet.hasElementColors()) {
                    pgElementSet.setElementColor(n4, pgElementSet.getElementColor(n2));
                    pgElementSet.setElementColor(n4 + 1, pgElementSet.getElementColor(n));
                }
                if (pgElementSet.hasElementBackColors()) {
                    pgElementSet.setElementBackColor(n4, pgElementSet.getElementBackColor(n2));
                    pgElementSet.setElementBackColor(n4 + 1, pgElementSet.getElementBackColor(n));
                }
                if (pgElementSet.hasElementTextures()) {
                    PdVector pdVector5 = PdVector.blendNew((double)0.5, (PdVector)pdVectorArrayArray[n2][1], (double)0.5, (PdVector)pdVectorArrayArray[n2][2]);
                    pdVectorArrayArray[n4] = new PdVector[3];
                    pdVectorArrayArray[n4][0] = PdVector.copyNew((PdVector)pdVector5);
                    pdVectorArrayArray[n4][1] = PdVector.copyNew((PdVector)pdVectorArrayArray[n2][0]);
                    pdVectorArrayArray[n4][2] = pdVectorArrayArray[n2][1];
                    pdVectorArrayArray[n2][1] = pdVectorArrayArray[n2][2];
                    pdVectorArrayArray[n2][2] = pdVectorArrayArray[n2][0];
                    pdVectorArrayArray[n2][0] = pdVector5;
                    pdVector5 = PdVector.blendNew((double)0.5, (PdVector)pdVectorArrayArray[n][1], (double)0.5, (PdVector)pdVectorArrayArray[n][2]);
                    pdVectorArrayArray[n4 + 1] = new PdVector[3];
                    pdVectorArrayArray[n4 + 1][0] = PdVector.copyNew((PdVector)pdVector5);
                    pdVectorArrayArray[n4 + 1][1] = PdVector.copyNew((PdVector)pdVectorArrayArray[n][0]);
                    pdVectorArrayArray[n4 + 1][2] = pdVectorArrayArray[n][1];
                    pdVectorArrayArray[n][1] = pdVectorArrayArray[n][2];
                    pdVectorArrayArray[n][2] = pdVectorArrayArray[n][0];
                    pdVectorArrayArray[n][0] = pdVector5;
                }
                if (pgElementSet.getNumVectorFields() > 0) {
                    int n16 = pgElementSet.getNumVectorFields();
                    for (n14 = 0; n14 < n16; ++n14) {
                        PgVectorField pgVectorField2 = pgElementSet.getVectorField(n14);
                        if (pgVectorField2.getBasedOn() != 1) continue;
                        pgVectorField2.setVector(n4, PdVector.copyNew((PdVector)pgVectorField2.getVector(n2)));
                        pgVectorField2.setVector(n4 + 1, PdVector.copyNew((PdVector)pgVectorField2.getVector(n)));
                    }
                }
                if (piVectorArray[n2].m_data[1] == piVectorArray[n].m_data[1]) {
                    piVector7.m_data[2] = n;
                    pdVector2.m_data[1] = n4 + 1;
                    piVector8.m_data[2] = n2;
                    pgVectorField.m_data[2] = n4 + 1;
                }
                if ((n13 = pdVector2.m_data[0]) != -1) {
                    n14 = piVectorArray2[n13].getSize();
                    for (int i = 0; i < n14; ++i) {
                        if (piVectorArray2[n13].m_data[i] != n2) continue;
                        piVectorArray2[n13].m_data[i] = n4;
                    }
                }
                if ((n13 = pgVectorField.m_data[0]) != -1) {
                    n14 = piVectorArray2[n13].getSize();
                    for (int i = 0; i < n14; ++i) {
                        if (piVectorArray2[n13].m_data[i] != n) continue;
                        piVectorArray2[n13].m_data[i] = n4 + 1;
                    }
                }
                piVectorArray[n2] = piVector6;
                piVectorArray2[n2] = piVector7;
                piVectorArray[n4] = piVector4;
                piVectorArray2[n4] = pdVector2;
                piVectorArray[n] = piVector5;
                piVectorArray2[n] = piVector8;
                piVectorArray[n4 + 1] = pdVector3;
                piVectorArray2[n4 + 1] = pgVectorField;
                n4 += 2;
                ++n3;
                continue;
            }
            if (piVector2.m_data[n2] != -1) continue;
            int n17 = piVectorArray[n2].getSize();
            if (n17 == 3 && piVectorArray2[n2].m_data[0] == -1) {
                int n18;
                pdVector = PdVector.blendNew((double)0.5, (PdVector)pgElementSet.getVertex(piVectorArray[n2].m_data[1]), (double)0.5, (PdVector)pgElementSet.getVertex(piVectorArray[n2].m_data[2]));
                pgElementSet.setVertex(n3, pdVector);
                if (pgElementSet.hasVertexColors()) {
                    pgElementSet.setVertexColor(n3, PdColor.blend((double)0.5, (Color)pgElementSet.getVertexColor(piVectorArray[n2].m_data[1]), (double)0.5, (Color)pgElementSet.getVertexColor(piVectorArray[n2].m_data[2])));
                }
                if (pgElementSet.hasVertexTextures()) {
                    piVector4 = pgElementSet.getVertexTextures();
                    piVector4[n3] = PdVector.blendNew((double)0.5, (PdVector)piVector4[piVectorArray[n2].m_data[1]], (double)0.5, (PdVector)piVector4[piVectorArray[n2].m_data[2]]);
                }
                if (pgElementSet.getNumVectorFields() > 0) {
                    int n19 = pgElementSet.getNumVectorFields();
                    for (int i = 0; i < n19; ++i) {
                        PgVectorField pgVectorField3 = pgElementSet.getVectorField(i);
                        if (pgVectorField3.getBasedOn() != 0) continue;
                        pgVectorField3.setVector(n3, PdVector.blendNew((double)0.5, (PdVector)pgVectorField3.getVector(piVectorArray[n2].m_data[1]), (double)0.5, (PdVector)pgVectorField3.getVector(piVectorArray[n2].m_data[2])));
                    }
                }
                piVector4 = new PiVector(n3, piVectorArray[n2].m_data[2], piVectorArray[n2].m_data[0]);
                piVector5 = new PiVector(n3, piVectorArray[n2].m_data[0], piVectorArray[n2].m_data[1]);
                PiVector piVector9 = new PiVector(piVectorArray2[n2].m_data[1], n4, -1);
                PiVector piVector10 = new PiVector(piVectorArray2[n2].m_data[2], -1, n2);
                if (pgElementSet.hasElementColors()) {
                    pgElementSet.setElementColor(n4, pgElementSet.getElementColor(n2));
                }
                if (pgElementSet.hasElementBackColors()) {
                    pgElementSet.setElementBackColor(n4, pgElementSet.getElementBackColor(n2));
                }
                if (pgElementSet.hasElementTextures()) {
                    pdVector2 = PdVector.blendNew((double)0.5, (PdVector)pdVectorArrayArray[n2][1], (double)0.5, (PdVector)pdVectorArrayArray[n2][2]);
                    pdVectorArrayArray[n4] = new PdVector[3];
                    pdVectorArrayArray[n4][0] = PdVector.copyNew((PdVector)pdVector2);
                    pdVectorArrayArray[n4][1] = PdVector.copyNew((PdVector)pdVectorArrayArray[n2][0]);
                    pdVectorArrayArray[n4][2] = pdVectorArrayArray[n2][1];
                    pdVectorArrayArray[n2][1] = pdVectorArrayArray[n2][2];
                    pdVectorArrayArray[n2][2] = pdVectorArrayArray[n2][0];
                    pdVectorArrayArray[n2][0] = pdVector2;
                }
                if (pgElementSet.getNumVectorFields() > 0) {
                    int n20 = pgElementSet.getNumVectorFields();
                    for (int i = 0; i < n20; ++i) {
                        pgVectorField = pgElementSet.getVectorField(i);
                        if (pgVectorField.getBasedOn() != 1) continue;
                        pgVectorField.setVector(n4, PdVector.copyNew((PdVector)pgVectorField.getVector(n2)));
                    }
                }
                if ((n18 = piVectorArray2[n2].m_data[2]) != -1) {
                    int n21 = piVectorArray2[n18].getSize();
                    for (int i = 0; i < n21; ++i) {
                        if (piVectorArray2[n18].m_data[i] != n2) continue;
                        piVectorArray2[n18].m_data[i] = n4;
                    }
                }
                if (pgElementSet.hasBoundary()) {
                    PgBndPolygon[] pgBndPolygonArray2 = pgElementSet.getBoundaries();
                    int n22 = pgBndPolygonArray2.length;
                    for (n13 = 0; n13 < n22; ++n13) {
                        int n23;
                        PiVector piVector11 = pgBndPolygonArray2[n13].getVertexInd();
                        int n24 = pgBndPolygonArray2[n13].getNumVertices();
                        int n25 = -1;
                        for (n23 = 0; n23 < n24 - 1; ++n23) {
                            if ((piVector11.m_data[n23] != piVectorArray[n2].m_data[1] || piVector11.m_data[n23 + 1] != piVectorArray[n2].m_data[2]) && (piVector11.m_data[n23] != piVectorArray[n2].m_data[2] || piVector11.m_data[n23 + 1] != piVectorArray[n2].m_data[1])) continue;
                            n25 = n23 + 1;
                        }
                        if (n25 == -1) continue;
                        pgBndPolygonArray2[n13].setNumVertices(n24 + 1);
                        for (n23 = n24; n23 > n25; --n23) {
                            piVector11.m_data[n23] = piVector11.m_data[n23 - 1];
                        }
                        piVector11.m_data[n25] = n3;
                    }
                }
                piVectorArray[n2] = piVector4;
                piVectorArray2[n2] = piVector9;
                piVectorArray[n4] = piVector5;
                piVectorArray2[n4] = piVector10;
                ++n4;
                ++n3;
                continue;
            }
            pdVector = PdVector.blendNew((double)1.0, (PdVector)pgElementSet.getVertex(piVectorArray[n2].m_data[0]), (double)1.0, (PdVector)pgElementSet.getVertex(piVectorArray[n2].m_data[1]));
            for (int i = 2; i < n17; ++i) {
                pdVector.add(pgElementSet.getVertex(piVectorArray[n2].m_data[i]));
            }
            pdVector.multScalar(1.0 / (double)n17);
            if (pgElementSet.hasVertexColors()) {
                Color color = PdColor.blend((double)(1.0 / (double)n17), (Color)pgElementSet.getVertexColor(piVectorArray[n2].m_data[0]), (double)(1.0 / (double)n17), (Color)pgElementSet.getVertexColor(piVectorArray[n2].m_data[1]));
                for (int i = 2; i < n17; ++i) {
                    color = PdColor.blend((double)1.0, (Color)color, (double)(1.0 / (double)n17), (Color)pgElementSet.getVertexColor(piVectorArray[n2].m_data[i]));
                }
                pgElementSet.setVertexColor(n3, color);
            }
            if (pgElementSet.hasVertexTextures()) {
                PdVector[] pdVectorArray = pgElementSet.getVertexTextures();
                pdVectorArray[n3] = PdVector.blendNew((double)1.0, (PdVector)pdVectorArray[piVectorArray[n2].m_data[0]], (double)1.0, (PdVector)pdVectorArray[piVectorArray[n2].m_data[1]]);
                for (int i = 2; i < n17; ++i) {
                    pdVectorArray[n3].add(pdVectorArray[piVectorArray[n2].m_data[i]]);
                }
                pdVectorArray[n3].multScalar(1.0 / (double)n17);
            }
            if (pgElementSet.getNumVectorFields() > 0) {
                int n26 = pgElementSet.getNumVectorFields();
                for (int i = 0; i < n26; ++i) {
                    PgVectorField pgVectorField4 = pgElementSet.getVectorField(i);
                    if (pgVectorField4.getBasedOn() != 0) continue;
                    PdVector pdVector6 = PdVector.blendNew((double)1.0, (PdVector)pgVectorField4.getVector(piVectorArray[n2].m_data[0]), (double)1.0, (PdVector)pgVectorField4.getVector(piVectorArray[n2].m_data[1]));
                    for (int j = 2; j < n17; ++j) {
                        pdVector6.add(pgVectorField4.getVector(piVectorArray[n2].m_data[j]));
                    }
                    pdVector6.multScalar(1.0 / (double)n17);
                    pgVectorField4.setVector(n3, pdVector6);
                }
            }
            pgElementSet.setVertex(n3, pdVector);
            piVector4 = new PiVector[n17];
            piVector5 = new PiVector[n17];
            for (n12 = 0; n12 < n17; ++n12) {
                piVector4[n12] = new PiVector(n3, piVectorArray[n2].m_data[n12], piVectorArray[n2].m_data[(n12 + 1) % n17]);
                piVector5[n12] = new PiVector(piVectorArray2[n2].m_data[(n12 + n17 - 1) % n17], n4 + n12, n4 + (n17 + n12 - 2) % n17);
            }
            for (n12 = 0; n12 < n17 - 1; ++n12) {
                int n27 = piVectorArray2[n2].m_data[n12];
                if (n27 == -1) continue;
                int n28 = piVectorArray2[n27].getSize();
                for (int i = 0; i < n28; ++i) {
                    if (piVectorArray2[n27].m_data[i] != n2) continue;
                    piVectorArray2[n27].m_data[i] = n4 + n12;
                }
            }
            piVector5[1].m_data[2] = n2;
            piVector5[n17 - 1].m_data[1] = n2;
            piVectorArray[n2] = piVector4[0];
            piVectorArray2[n2] = piVector5[0];
            for (n12 = 1; n12 < n17; ++n12) {
                piVectorArray[n4 - 1 + n12] = piVector4[n12];
                piVectorArray2[n4 - 1 + n12] = piVector5[n12];
                if (pgElementSet.hasElementColors()) {
                    pgElementSet.setElementColor(n4 - 1 + n12, pgElementSet.getElementColor(n2));
                }
                if (!pgElementSet.hasElementBackColors()) continue;
                pgElementSet.setElementBackColor(n4 - 1 + n12, pgElementSet.getElementBackColor(n2));
            }
            if (pgElementSet.hasElementTextures()) {
                int n29;
                PdVector pdVector7 = PdVector.blendNew((double)1.0, (PdVector)pdVectorArrayArray[n2][0], (double)1.0, (PdVector)pdVectorArrayArray[n2][1]);
                for (int i = 2; i < n17; ++i) {
                    pdVector7.add(pdVectorArrayArray[n2][i]);
                }
                pdVector7.multScalar(1.0 / (double)n17);
                PdVector[][] pdVectorArrayArray2 = new PdVector[n17][];
                for (n29 = 0; n29 < n17; ++n29) {
                    pdVectorArrayArray2[n29] = new PdVector[3];
                    pdVectorArrayArray2[n29][0] = PdVector.copyNew((PdVector)pdVector7);
                    pdVectorArrayArray2[n29][1] = PdVector.copyNew((PdVector)pdVectorArrayArray[n2][n29]);
                    pdVectorArrayArray2[n29][2] = PdVector.copyNew((PdVector)pdVectorArrayArray[n2][(n29 + 1) % n17]);
                }
                pdVectorArrayArray[n2] = pdVectorArrayArray2[0];
                for (n29 = 1; n29 < n17; ++n29) {
                    pdVectorArrayArray[n4 - 1 + n29] = pdVectorArrayArray2[n29];
                }
            }
            if (pgElementSet.getNumVectorFields() > 0) {
                int n30 = pgElementSet.getNumVectorFields();
                for (int i = 0; i < n30; ++i) {
                    PgVectorField pgVectorField5 = pgElementSet.getVectorField(i);
                    if (pgVectorField5.getBasedOn() != 1) continue;
                    for (int j = 1; j < n17; ++j) {
                        pgVectorField5.setVector(n4 - 1 + j, PdVector.copyNew((PdVector)pgVectorField5.getVector(n2)));
                    }
                }
            }
            n4 += n17 - 1;
            ++n3;
        }
        pgElementSet.setDimOfElements(3);
        if (n5 != 0) {
            pgElementSet.assureElementTextures();
            pgElementSet.setElementTextures((PdVector[][])pdVectorArrayArray);
        }
        for (n2 = 0; n2 < n8; ++n2) {
            PiVector piVector12 = pgElementSet.getElement(n2);
            if (pgElementSet.getNeighbour((int)n2).m_data[0] >= n2) continue;
            pgBndPolygonArray[piVector12.m_data[1]].add(pgElementSet.getVertex(piVector12.m_data[2]));
            int n31 = piVector12.m_data[1];
            piVector.m_data[n31] = piVector.m_data[n31] + 1;
            pgBndPolygonArray[piVector12.m_data[2]].add(pgElementSet.getVertex(piVector12.m_data[1]));
            int n32 = piVector12.m_data[2];
            piVector.m_data[n32] = piVector.m_data[n32] + 1;
        }
        for (n2 = 0; n2 < n7; ++n2) {
            if (pgElementSet.hasTagVertex(n2, 14)) continue;
            pgBndPolygonArray[n2].multScalar(1.0 / (double)piVector.m_data[n2]);
            PdVector pdVector = PdVector.blendNew((double)0.5, (PdVector)pgElementSet.getVertex(n2), (double)0.5, (PdVector)pgBndPolygonArray[n2]);
            pgElementSet.setVertex(n2, pdVector);
        }
        if (pgElementSet.hasBoundary()) {
            PgBndPolygon[] pgBndPolygonArray3 = pgElementSet.getBoundaries();
            n = pgBndPolygonArray3.length;
            for (int i = 0; i < n; ++i) {
                if (pgBndPolygonArray3[i].makeElementInd()) continue;
                pgElementSet.removeBoundaries();
                break;
            }
        }
        if (pgElementSet.hasVertexNormals()) {
            pgElementSet.makeVertexNormals();
        }
        if (pgElementSet.hasElementNormals()) {
            pgElementSet.makeElementNormals();
        }
        if (pgElementSet.isEnabledEdges()) {
            pgElementSet.makeEdgeStars();
        }
    }

    public void refineQuadSqrt2() {
        this.m_refineSequence.addEntry(10);
        PwRefineElementSet.refineQuadSqrt2((PgElementSet)this.m_geom);
    }

    public void refineQuadSqrt2Flat() {
        this.m_refineSequence.addEntry(11);
        PwRefineElementSet.refineQuadSqrt2Flat((PgElementSet)this.m_geom);
    }

    public static void refineQuadSqrt2Flat(PgElementSet pgElementSet) {
        PwRefineElementSet.refineQuadSqrt2(pgElementSet, 11);
    }

    public static void refineQuadSqrt2(PgElementSet pgElementSet) {
        PwRefineElementSet.refineQuadSqrt2(pgElementSet, 10);
    }

    public static void refineQuadSqrt2(PgElementSet pgElementSet, int n) {
        int n2;
        int n3;
        int n4;
        Object[] objectArray;
        PgVectorField pgVectorField;
        int n5;
        int n6;
        int n7;
        if (!pgElementSet.checkNeighbour(false)) {
            pgElementSet.makeNeighbour();
        }
        pgElementSet.removeUnusedVertices();
        int n8 = pgElementSet.getNumElements();
        int n9 = pgElementSet.getNumVertices();
        PiVector[] piVectorArray = pgElementSet.getElements();
        PiVector[] piVectorArray2 = pgElementSet.getNeighbours();
        int n10 = 0;
        int n11 = n9 + n8;
        boolean[] blArray = new boolean[n8];
        for (n7 = 0; n7 < n8; ++n7) {
            blArray[n7] = false;
            n6 = piVectorArray[n7].getSize();
            int n12 = 0;
            for (n5 = 0; n5 < n6; ++n5) {
                if (piVectorArray2[n7].m_data[n5] < n7) {
                    ++n10;
                }
                if (piVectorArray2[n7].m_data[n5] >= 0) continue;
                ++n12;
            }
            if (n6 != 3 || n12 != true) continue;
            blArray[n7] = true;
            --n10;
        }
        pgElementSet.markBoundary();
        pgElementSet.setNumElements(n10);
        piVectorArray = pgElementSet.getElements();
        piVectorArray2 = pgElementSet.getNeighbours();
        pgElementSet.setNumVertices(n11);
        n7 = pgElementSet.hasElementTextures() ? 1 : 0;
        if (n7 != 0) {
            pgElementSet.removeTexture();
        }
        n6 = pgElementSet.getNumVectorFields();
        PgVectorField[] pgVectorFieldArray = new PgVectorField[n6];
        if (n6 > 0) {
            for (n5 = 0; n5 < n6; ++n5) {
                pgVectorField = pgElementSet.getVectorField(n5);
                if (pgVectorField.getBasedOn() == 0) {
                    pgVectorField.setNumVectors(n11);
                }
                if (pgVectorField.getBasedOn() != 1) continue;
                pgVectorFieldArray[n5] = new PgVectorField(pgVectorField.getDimOfVectors());
                pgVectorFieldArray[n5].copy((PsObject)pgVectorField);
                pgVectorFieldArray[n5].setGeometry((PgPointSet)pgElementSet);
                pgVectorFieldArray[n5].setNumVectors(n10);
                pgVectorFieldArray[n5].setBasedOn(1);
            }
        }
        n5 = 0;
        pgVectorField = new PiVector[n10];
        PiVector piVector = new PiVector(n9);
        boolean[] blArray2 = new boolean[n9];
        if (pgElementSet.hasBoundary()) {
            objectArray = pgElementSet.getBoundaries();
            int n13 = objectArray.length;
            for (int i = 0; i < n13; ++i) {
                PiVector piVector2 = objectArray[i].getVertexInd();
                n4 = objectArray[i].getNumVertices();
                blArray2[piVector2.m_data[0]] = true;
                blArray2[piVector2.m_data[n4 - 1]] = true;
            }
        }
        objectArray = pgElementSet.hasElementColors() ? new Color[n10] : new Color[]{};
        Color[] colorArray = pgElementSet.hasElementBackColors() ? new Color[n10] : new Color[]{};
        PdVector[] pdVectorArray = PdVector.realloc(null, (int)n9, (int)pgElementSet.getDimOfVertices());
        for (n3 = 0; n3 < n8; ++n3) {
            int n14;
            n4 = piVectorArray[n3].getSize();
            if (blArray[n3]) {
                for (n2 = 0; n2 < n4; ++n2) {
                    PdVector[] pdVectorArray2;
                    if (piVectorArray2[n3].m_data[n2] >= 0) continue;
                    PdVector pdVector = PdVector.blendNew((double)0.5, (PdVector)pgElementSet.getVertex(piVectorArray[n3].m_data[(n2 + 1) % n4]), (double)0.5, (PdVector)pgElementSet.getVertex(piVectorArray[n3].m_data[(n2 + 2) % n4]));
                    pgElementSet.setVertex(n9 + n3, pdVector);
                    if (pgElementSet.hasVertexColors()) {
                        pgElementSet.setVertexColor(n9 + n3, PdColor.blend((double)0.5, (Color)pgElementSet.getVertexColor(piVectorArray[n3].m_data[(n2 + 1) % n4]), (double)0.5, (Color)pgElementSet.getVertexColor(piVectorArray[n3].m_data[(n2 + 2) % n4])));
                    }
                    if (pgElementSet.hasVertexTextures()) {
                        pdVectorArray2 = pgElementSet.getVertexTextures();
                        pdVectorArray2[n9 + n3] = PdVector.blendNew((double)0.5, (PdVector)pdVectorArray2[piVectorArray[n3].m_data[(n2 + 1) % n4]], (double)0.5, (PdVector)pdVectorArray2[piVectorArray[n3].m_data[(n2 + 2) % n4]]);
                    }
                    if (pgElementSet.getNumVectorFields() > 0) {
                        for (int i = 0; i < n6; ++i) {
                            PgVectorField pgVectorField2 = pgElementSet.getVectorField(i);
                            if (pgVectorField2.getBasedOn() != 0) continue;
                            pgVectorField2.setVector(n9 + n3, PdVector.blendNew((double)0.5, (PdVector)pgVectorField2.getVector(piVectorArray[n3].m_data[(n2 + 1) % n4]), (double)0.5, (PdVector)pgVectorField2.getVector(piVectorArray[n3].m_data[(n2 + 2) % n4])));
                        }
                    }
                    if (pgElementSet.hasBoundary()) {
                        pdVectorArray2 = pgElementSet.getBoundaries();
                        int n15 = pdVectorArray2.length;
                        for (n14 = 0; n14 < n15; ++n14) {
                            int n16;
                            PiVector piVector3 = pdVectorArray2[n14].getVertexInd();
                            int n17 = pdVectorArray2[n14].getNumVertices();
                            int n18 = -1;
                            for (n16 = 0; n16 < n17 - 1; ++n16) {
                                if ((piVector3.m_data[n16] != piVectorArray[n3].m_data[(n2 + 1) % n4] || piVector3.m_data[n16 + 1] != piVectorArray[n3].m_data[(n2 + 2) % n4]) && (piVector3.m_data[n16] != piVectorArray[n3].m_data[(n2 + 2) % n4] || piVector3.m_data[n16 + 1] != piVectorArray[n3].m_data[(n2 + 1) % n4])) continue;
                                n18 = n16 + 1;
                            }
                            if (n18 == -1) continue;
                            pdVectorArray2[n14].setNumVertices(n17 + 1);
                            for (n16 = n17; n16 > n18; --n16) {
                                piVector3.m_data[n16] = piVector3.m_data[n16 - 1];
                            }
                            piVector3.m_data[n18] = n9 + n3;
                        }
                    }
                    break;
                }
            } else {
                PdVector pdVector = PdVector.blendNew((double)1.0, (PdVector)pgElementSet.getVertex(piVectorArray[n3].m_data[0]), (double)1.0, (PdVector)pgElementSet.getVertex(piVectorArray[n3].m_data[1]));
                for (int i = 2; i < n4; ++i) {
                    pdVector.add(pgElementSet.getVertex(piVectorArray[n3].m_data[i]));
                }
                pdVector.multScalar(1.0 / (double)n4);
                if (pgElementSet.hasVertexColors()) {
                    Color color = PdColor.blend((double)(1.0 / (double)n4), (Color)pgElementSet.getVertexColor(piVectorArray[n3].m_data[0]), (double)(1.0 / (double)n4), (Color)pgElementSet.getVertexColor(piVectorArray[n3].m_data[1]));
                    for (int i = 2; i < n4; ++i) {
                        color = PdColor.blend((double)1.0, (Color)color, (double)(1.0 / (double)n4), (Color)pgElementSet.getVertexColor(piVectorArray[n3].m_data[i]));
                    }
                    pgElementSet.setVertexColor(n9 + n3, color);
                }
                if (pgElementSet.hasVertexTextures()) {
                    PdVector[] pdVectorArray3 = pgElementSet.getVertexTextures();
                    pdVectorArray3[n9 + n3] = PdVector.blendNew((double)1.0, (PdVector)pdVectorArray3[piVectorArray[n3].m_data[0]], (double)1.0, (PdVector)pdVectorArray3[piVectorArray[n3].m_data[1]]);
                    for (int i = 2; i < n4; ++i) {
                        pdVectorArray3[n9 + n3].add(pdVectorArray3[piVectorArray[n3].m_data[i]]);
                    }
                    pdVectorArray3[n9 + n3].multScalar(1.0 / (double)n4);
                }
                if (pgElementSet.getNumVectorFields() > 0) {
                    for (int i = 0; i < n6; ++i) {
                        PgVectorField pgVectorField3 = pgElementSet.getVectorField(i);
                        if (pgVectorField3.getBasedOn() != 0) continue;
                        PdVector pdVector2 = PdVector.blendNew((double)1.0, (PdVector)pgVectorField3.getVector(piVectorArray[n3].m_data[0]), (double)1.0, (PdVector)pgVectorField3.getVector(piVectorArray[n3].m_data[1]));
                        for (n14 = 2; n14 < n4; ++n14) {
                            pdVector2.add(pgVectorField3.getVector(piVectorArray[n3].m_data[n14]));
                        }
                        pdVector2.multScalar(1.0 / (double)n4);
                        pgVectorField3.setVector(n9 + n3, pdVector2);
                    }
                }
                pgElementSet.setVertex(n9 + n3, pdVector);
            }
            for (n2 = 0; n2 < n4; ++n2) {
                int n19 = piVectorArray2[n3].m_data[n2];
                if (n19 < 0 && !blArray[n3]) {
                    pgVectorField[n5] = new PiVector(n9 + n3, piVectorArray[n3].m_data[(n2 + 1) % n4], piVectorArray[n3].m_data[(n2 + 2) % n4]);
                    for (int i = 0; i < n6; ++i) {
                        PgVectorField pgVectorField4 = pgElementSet.getVectorField(i);
                        if (pgVectorField4.getBasedOn() != 1) continue;
                        pgVectorFieldArray[i].setVector(n5, pgVectorField4.getVector(n3));
                    }
                    if (pgElementSet.hasElementColors()) {
                        objectArray[n5] = pgElementSet.getElementColor(n3);
                    }
                    if (pgElementSet.hasElementBackColors()) {
                        colorArray[n5] = pgElementSet.getElementBackColor(n3);
                    }
                    ++n5;
                } else if (n19 > n3) {
                    pgVectorField[n5] = new PiVector(n9 + n3, piVectorArray[n3].m_data[(n2 + 1) % n4], n9 + n19, piVectorArray[n3].m_data[(n2 + 2) % n4]);
                    for (int i = 0; i < n6; ++i) {
                        PgVectorField pgVectorField5 = pgElementSet.getVectorField(i);
                        if (pgVectorField5.getBasedOn() != 1) continue;
                        pgVectorFieldArray[i].setVector(n5, PdVector.blendNew((double)0.5, (PdVector)pgVectorField5.getVector(n3), (double)0.5, (PdVector)pgVectorField5.getVector(n19)));
                    }
                    if (pgElementSet.hasElementColors()) {
                        objectArray[n5] = PdColor.blend((double)0.5, (Color)pgElementSet.getElementColor(n3), (double)0.5, (Color)pgElementSet.getElementColor(n19));
                    }
                    if (pgElementSet.hasElementBackColors()) {
                        colorArray[n5] = PdColor.blend((double)0.5, (Color)pgElementSet.getElementBackColor(n3), (double)0.5, (Color)pgElementSet.getElementBackColor(n19));
                    }
                    ++n5;
                }
                pdVectorArray[piVectorArray[n3].m_data[(n2 + 1) % n4]].add(pgElementSet.getVertex(piVectorArray[n3].m_data[(n2 + 2) % n4]));
                int n20 = piVectorArray[n3].m_data[(n2 + 1) % n4];
                piVector.m_data[n20] = piVector.m_data[n20] + 1;
                pdVectorArray[piVectorArray[n3].m_data[(n2 + 2) % n4]].add(pgElementSet.getVertex(piVectorArray[n3].m_data[(n2 + 1) % n4]));
                int n21 = piVectorArray[n3].m_data[(n2 + 2) % n4];
                piVector.m_data[n21] = piVector.m_data[n21] + 1;
            }
        }
        pgElementSet.setElements((PiVector[])pgVectorField);
        if (pgElementSet.hasElementColors()) {
            pgElementSet.setElementColors((Color[])objectArray);
        }
        if (pgElementSet.hasElementBackColors()) {
            pgElementSet.setElementBackColors(colorArray);
        }
        for (n3 = 0; n3 < n6; ++n3) {
            PgVectorField pgVectorField6 = pgElementSet.getVectorField(n3);
            if (pgVectorField6.getBasedOn() != 1) continue;
            pgVectorField6.copy((PsObject)pgVectorFieldArray[n3]);
        }
        pgElementSet.assureDimOfElements();
        pgElementSet.makeNeighbour();
        if (n == 10) {
            for (n3 = 0; n3 < n9; ++n3) {
                if (pgElementSet.hasTagVertex(n3, 14)) continue;
                pdVectorArray[n3].multScalar(1.0 / (double)piVector.m_data[n3]);
                PdVector pdVector = PdVector.blendNew((double)0.5, (PdVector)pgElementSet.getVertex(n3), (double)0.5, (PdVector)pdVectorArray[n3]);
                pgElementSet.setVertex(n3, pdVector);
            }
        }
        if (pgElementSet.hasBoundary()) {
            PgBndPolygon[] pgBndPolygonArray = pgElementSet.getBoundaries();
            int n22 = pgBndPolygonArray.length;
            for (n2 = 0; n2 < n22; ++n2) {
                if (pgBndPolygonArray[n2].makeElementInd()) continue;
                pgElementSet.removeBoundaries();
                break;
            }
        }
        if (pgElementSet.hasVertexNormals()) {
            pgElementSet.makeVertexNormals();
        }
        if (pgElementSet.hasElementNormals()) {
            pgElementSet.makeElementNormals();
        }
        if (pgElementSet.isEnabledEdges()) {
            pgElementSet.makeEdgeStars();
        }
    }

    public static void refineSplitCentral(PgElementSet pgElementSet) {
        PwModel.stellate(pgElementSet, 0.0);
    }

    public void refineSplitCentral() {
        this.m_refineSequence.addEntry(12);
        PwModel.stellate((PgElementSet)this.m_geom, 0.0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

