/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.awt.Color;
import jv.function.PuFunction;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.number.PdColor;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.vecmath.PdBary;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.numeric.PnRootFinder;
import jvx.project.PjWorkshop;

public class PwClip
extends PjWorkshop {
    protected PgElementSet m_geom;
    protected PuFunction m_function = new PuFunction(3, 1);
    protected PuDouble m_level;
    protected String m_defaultFunction = "u*u+v*v+w*w";
    protected boolean m_bPositive;
    static /* synthetic */ Class class$jvx$geom$PwClip;

    public PwClip() {
        super(PsConfig.getMessage((int)48006));
        this.m_function.setVariables(new String[]{"u", "v", "w"});
        this.m_function.setParent((PsUpdateIf)this);
        this.m_function.setName(PsConfig.getMessage((int)45005));
        this.m_level = new PuDouble(PsConfig.getMessage((int)54059), (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PwClip == null ? (class$jvx$geom$PwClip = PwClip.class$("jvx.geom.PwClip")) : class$jvx$geom$PwClip)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_function.setExpression(this.m_defaultFunction);
        this.m_level.setDefBounds(0.0, 10.0, 0.1, 1.0);
        this.m_level.setDefValue(1.0);
        this.m_level.init();
        if (this.m_geom != null) {
            this.computeBounds();
        }
    }

    public void setGeometry(PgGeometry pgGeometry) {
        super.setGeometry(pgGeometry);
        this.m_geom = (PgElementSet)pgGeometry;
        if (this.m_geomSave == null) {
            this.m_geomSave = (PgGeometry)this.m_geom.clone();
        }
        int n = this.m_geom.getDimOfVertices();
        this.m_function.setNumVariables(n);
        if (n == 4) {
            this.m_function.setVariables(new String[]{"u0", "u1", "u2", "u3"});
            this.setFunction("u0*u0+u1*u1+u2*u2+u3*u3");
        } else if (n == 3) {
            this.m_function.setVariables(new String[]{"u", "v", "w"});
            this.setFunction("u*u+v*v+w*w");
        } else if (n == 2) {
            this.m_function.setVariables(new String[]{"u", "v"});
            this.setFunction("u*u+v*v");
        } else if (n == 1) {
            this.m_function.setVariables(new String[]{"u"});
            this.setFunction("u");
        } else {
            PsDebug.warning((String)("void dimension of geometry, dim = " + String.valueOf(n)));
            return;
        }
    }

    public String getFunction() {
        if (this.m_function.getNumFunctions() == 0) {
            return null;
        }
        return this.m_function.getExpression();
    }

    public void setFunction(String string) {
        this.m_defaultFunction = new String(string);
        this.m_function.setExpression(this.m_defaultFunction);
        this.computeBounds();
    }

    public double getLevel() {
        return this.m_level.getValue();
    }

    public void setLevel(double d) {
        this.m_level.setValue(d);
    }

    public void setEnabledPositive(boolean bl) {
        this.m_bPositive = bl;
    }

    public boolean isEnabledPositive() {
        return this.m_bPositive;
    }

    public boolean update(Object object) {
        if (object == this) {
            this.clipAtFunction();
            return super.update((Object)this);
        }
        if (object == this.m_level) {
            this.clipAtFunction();
            return super.update((Object)this);
        }
        if (object == this.m_function) {
            this.computeBounds();
            this.clipAtFunction();
            return super.update((Object)this);
        }
        return super.update(object);
    }

    private void computeBounds() {
        double d = (this.m_level.getValue() - this.m_level.getMin()) / (this.m_level.getMax() - this.m_level.getMin());
        if (this.m_geom == null) {
            return;
        }
        int n = ((PgPointSet)this.m_geomSave).getNumVertices();
        if (n < 1) {
            return;
        }
        double d2 = Double.MAX_VALUE;
        double d3 = Double.NEGATIVE_INFINITY;
        PdVector[] pdVectorArray = ((PgPointSet)this.m_geomSave).getVertices();
        for (int i = 0; i < n; ++i) {
            double d4 = this.m_function.eval(0, pdVectorArray[i].m_data);
            if (d4 < d2) {
                d2 = d4;
            }
            if (!(d4 > d3)) continue;
            d3 = d4;
        }
        if (d3 - d2 < 1.0E-10) {
            d3 += 1.0;
            d2 -= 1.0;
        }
        this.m_level.setBounds(d2, d3, (d3 - d2) / 100.0, (d3 - d2) / 10.0);
        this.m_level.setValue(d2 + d * (d3 - d2));
    }

    public void clipAtFunction() {
        this.clipAtFunction(this.m_level.getValue());
    }

    public void clipAtFunction(double d) {
        int n;
        int n2;
        Object object;
        int n3;
        int n4;
        int n5;
        PgElementSet pgElementSet = (PgElementSet)this.m_geomSave;
        int n6 = pgElementSet.getDimOfVertices();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        PiVector[] piVectorArray = pgElementSet.getElements();
        PiVector[] piVectorArray2 = pgElementSet.getNeighbours();
        PdVector[][] pdVectorArray2 = pgElementSet.getElementTextures();
        if (this.m_geom == null) {
            this.m_geom = new PgElementSet(n6);
        }
        this.m_geom.copy((PsObject)pgElementSet);
        int n7 = pgElementSet.getNumElements();
        int n8 = pgElementSet.getNumVertices();
        int[][] nArrayArray = new int[n7][];
        for (n5 = 0; n5 < n7; ++n5) {
            n4 = piVectorArray[n5].getSize();
            nArrayArray[n5] = new int[n4];
        }
        n5 = 0;
        for (n4 = 0; n4 < n7; ++n4) {
            n3 = piVectorArray[n4].getSize();
            for (int i = 0; i < n3; ++i) {
                if (piVectorArray2[n4].m_data[i] > n4) continue;
                nArrayArray[n4][i] = n5++;
                if (piVectorArray2[n4].m_data[i] == -1) continue;
                int n9 = piVectorArray2[n4].m_data[i];
                int n10 = pgElementSet.getOppVertexLocInd(n4, i);
                nArrayArray[n9][n10] = nArrayArray[n4][i];
            }
        }
        n4 = -1;
        n3 = 0;
        int[] nArray = new int[n5];
        PdVector[] pdVectorArray3 = new PdVector[n5];
        Color[] colorArray = null;
        if (this.m_geom.hasVertexColors()) {
            colorArray = new Color[n5];
        }
        PdVector[] pdVectorArray4 = null;
        if (this.m_geom.hasVertexNormals()) {
            pdVectorArray4 = new PdVector[n5];
        }
        PdVector[] pdVectorArray5 = null;
        if (this.m_geom.hasVertexTextures()) {
            pdVectorArray5 = new PdVector[n5];
        }
        PdVector[] pdVectorArray6 = null;
        boolean bl = this.m_geom.hasElementTextures();
        PdVector[][] pdVectorArray7 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        int n11 = this.m_geom.getNumVectorFields();
        if (n11 > 0) {
            pdVectorArray7 = new PdVector[n11][];
            for (int i = 0; i < n11; ++i) {
                object = this.m_geom.getVectorField(i);
                if (object.getBasedOn() == 1) {
                    bl2 = true;
                    continue;
                }
                if (object.getBasedOn() != 0) continue;
                bl3 = true;
                pdVectorArray7[i] = new PdVector[n5];
            }
        }
        PdBary pdBary = new PdBary(2);
        object = new double[1];
        PiVector piVector = new PiVector();
        for (n2 = 0; n2 < n8; ++n2) {
            this.m_function.eval(object, this.m_geom.getVertex((int)n2).m_data);
            if (!(object[0] < d && this.m_bPositive) && (!(object[0] > d) || this.m_bPositive)) continue;
            this.m_geom.setTagVertex(n2, 2);
        }
        for (n2 = 0; n2 < n7; ++n2) {
            int n12;
            int n13;
            PiVector piVector2 = piVectorArray[n2];
            n = piVector2.getSize();
            if (piVector.getSize() < 2 * n) {
                piVector.setSize(2 * n);
            }
            if (bl) {
                pdVectorArray6 = PdVector.realloc(pdVectorArray6, (int)(2 * n), (int)this.m_geom.getDimOfTextures());
            }
            int n14 = 0;
            for (int i = 0; i < n; ++i) {
                PgVectorField pgVectorField;
                int n15;
                n4 = nArrayArray[n2][i];
                n13 = piVector2.getEntry(i);
                n12 = (n + i - 1) % n;
                int n16 = (i + 1) % n;
                int n17 = piVector2.getEntry(n12);
                int n18 = piVector2.getEntry(n16);
                PdVector pdVector = pdVectorArray[n13];
                if (!this.m_geom.hasTagVertex(n13, 2)) {
                    if (bl) {
                        pdVectorArray6[n14].copyArray(pdVectorArray2[n2][i]);
                    }
                    piVector.setEntry(n14, n13);
                    ++n14;
                    continue;
                }
                this.m_geom.getVertex(n13).setTag(2);
                PdVector pdVector2 = pgElementSet.getVertex(n17);
                PdVector pdVector3 = pgElementSet.getVertex(n18);
                if (!this.m_geom.hasTagVertex(n17, 2)) {
                    n4 = nArrayArray[n2][(n + i - 2) % n];
                    if (pdVectorArray3[n4] == null) {
                        pdVectorArray3[n4] = new PdVector(n6);
                        nArray[n4] = n8 + n3;
                        ++n3;
                        pdVectorArray3[n4].set(PnRootFinder.findValue(this.m_function, pdVector2.m_data, pdVector.m_data, d));
                        PdBary.getBary((PdBary)pdBary, (PdVector)pdVectorArray3[n4], (PdVector)pdVector, (PdVector)pdVector2);
                        if (colorArray != null) {
                            colorArray[n4] = PdColor.blend((double)pdBary.m_data[0], (Color)this.m_geom.getVertexColor(n13), (double)pdBary.m_data[1], (Color)this.m_geom.getVertexColor(n17));
                        }
                        if (pdVectorArray4 != null) {
                            pdVectorArray4[n4] = PdVector.blendNew((double)pdBary.m_data[0], (PdVector)this.m_geom.getVertexNormal(n13), (double)pdBary.m_data[1], (PdVector)this.m_geom.getVertexNormal(n17));
                        }
                        if (pdVectorArray5 != null) {
                            pdVectorArray5[n4] = PdVector.blendNew((double)pdBary.m_data[0], (PdVector)this.m_geom.getVertexTexture(n13), (double)pdBary.m_data[1], (PdVector)this.m_geom.getVertexTexture(n17));
                        }
                        if (bl3) {
                            for (n15 = 0; n15 < n11; ++n15) {
                                pgVectorField = this.m_geom.getVectorField(n15);
                                if (pgVectorField.getBasedOn() != 0) continue;
                                pdVectorArray7[n15][n4] = PdVector.blendNew((double)pdBary.m_data[0], (PdVector)pgVectorField.getVector(n13), (double)pdBary.m_data[1], (PdVector)pgVectorField.getVector(n17));
                            }
                        }
                    }
                    if (bl) {
                        PdBary.getBary((PdBary)pdBary, (PdVector)pdVectorArray3[n4], (PdVector)pdVector, (PdVector)pdVector2);
                        pdVectorArray6[n14] = PdVector.blendNew((double)pdBary.m_data[0], (PdVector)pdVectorArray2[n2][i], (double)pdBary.m_data[1], (PdVector)pdVectorArray2[n2][n12]);
                    }
                    piVector.setEntry(n14, nArray[n4]);
                    ++n14;
                }
                if (this.m_geom.hasTagVertex(n18, 2)) continue;
                n4 = nArrayArray[n2][(n + i - 1) % n];
                if (pdVectorArray3[n4] == null) {
                    pdVectorArray3[n4] = new PdVector(n6);
                    nArray[n4] = n8 + n3;
                    ++n3;
                    pdVectorArray3[n4].set(PnRootFinder.findValue(this.m_function, pdVector3.m_data, pdVector.m_data, d));
                    PdBary.getBary((PdBary)pdBary, (PdVector)pdVectorArray3[n4], (PdVector)pdVector, (PdVector)pdVector3);
                    if (colorArray != null) {
                        colorArray[n4] = PdColor.blend((double)pdBary.m_data[0], (Color)this.m_geom.getVertexColor(n13), (double)pdBary.m_data[1], (Color)this.m_geom.getVertexColor(n18));
                    }
                    if (pdVectorArray4 != null) {
                        pdVectorArray4[n4] = PdVector.blendNew((double)pdBary.m_data[0], (PdVector)this.m_geom.getVertexNormal(n13), (double)pdBary.m_data[1], (PdVector)this.m_geom.getVertexNormal(n18));
                    }
                    if (pdVectorArray5 != null) {
                        pdVectorArray5[n4] = PdVector.blendNew((double)pdBary.m_data[0], (PdVector)this.m_geom.getVertexTexture(n13), (double)pdBary.m_data[1], (PdVector)this.m_geom.getVertexTexture(n18));
                    }
                    if (bl3) {
                        for (n15 = 0; n15 < n11; ++n15) {
                            pgVectorField = this.m_geom.getVectorField(n15);
                            if (pgVectorField.getBasedOn() != 0) continue;
                            pdVectorArray7[n15][n4] = PdVector.blendNew((double)pdBary.m_data[0], (PdVector)pgVectorField.getVector(n13), (double)pdBary.m_data[1], (PdVector)pgVectorField.getVector(n18));
                        }
                    }
                }
                if (bl) {
                    PdBary.getBary((PdBary)pdBary, (PdVector)pdVectorArray3[n4], (PdVector)pdVector, (PdVector)pdVector3);
                    pdVectorArray6[n14] = PdVector.blendNew((double)pdBary.m_data[0], (PdVector)pdVectorArray2[n2][i], (double)pdBary.m_data[1], (PdVector)pdVectorArray2[n2][n16]);
                }
                piVector.setEntry(n14, nArray[n4]);
                ++n14;
            }
            if (n14 < 3) {
                this.m_geom.getElement(n2).setTag(2);
                continue;
            }
            PiVector piVector3 = this.m_geom.getElement(n2);
            if (piVector3.getSize() != n14) {
                this.m_geom.setDimOfElement(n2, n14);
            }
            for (n13 = 0; n13 < n14; ++n13) {
                piVector3.setEntry(n13, piVector.getEntry(n13));
            }
            if (!bl) continue;
            PdVector[][] pdVectorArray8 = this.m_geom.getElementTextures();
            for (n12 = 0; n12 < n14; ++n12) {
                pdVectorArray8[n2][n12].copyArray(pdVectorArray6[n12]);
            }
        }
        this.m_geom.setNumVertices(n8 + n3);
        for (n2 = 0; n2 < n5; ++n2) {
            if (pdVectorArray3[n2] == null) continue;
            int n19 = nArray[n2];
            this.m_geom.setVertex(n19, pdVectorArray3[n2]);
            if (colorArray != null) {
                this.m_geom.setVertexColor(n19, colorArray[n2]);
            }
            if (pdVectorArray4 != null) {
                this.m_geom.setVertexNormal(n19, pdVectorArray4[n2]);
            }
            if (pdVectorArray5 == null) continue;
            this.m_geom.setVertexTexture(n19, pdVectorArray5[n2]);
        }
        if (bl2 || bl3) {
            for (n2 = 0; n2 < n11; ++n2) {
                PgVectorField pgVectorField = this.m_geom.getVectorField(n2);
                if (pgVectorField.getBasedOn() == 1) {
                    pgVectorField.setNumVectors(this.m_geom.getNumElements());
                    continue;
                }
                pgVectorField.setNumVectors(this.m_geom.getNumVertices());
            }
            for (n2 = 0; n2 < n5; ++n2) {
                if (pdVectorArray3[n2] == null) continue;
                int n20 = nArray[n2];
                for (n = 0; n < n11; ++n) {
                    PgVectorField pgVectorField = this.m_geom.getVectorField(n);
                    if (pgVectorField.getBasedOn() != 0) continue;
                    pgVectorField.setVector(n20, pdVectorArray7[n][n2]);
                }
            }
        }
        this.m_geom.removeMarkedElements();
        this.m_geom.removeUnusedVertices();
        this.m_geom.makeNeighbour();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

