/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.awt.Color;
import java.util.Random;
import java.util.Vector;
import jv.geom.PgBndPolygon;
import jv.geom.PgEdgeStar;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.geom.PgPolygonSet;
import jv.geom.PgVectorField;
import jv.geom.PuCleanMesh;
import jv.number.PdColor;
import jv.number.PuBoolean;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.vecmath.P_Vector;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgVertexStar;
import jvx.geom.PwBoundary;
import jvx.geom.PwIdentify;
import jvx.geom.PwParameterLines;
import jvx.project.PjWorkshop;

public class PwCleanMesh
extends PjWorkshop {
    protected PgElementSet m_geom = null;
    protected PuBoolean m_mergeVisible = new PuBoolean("Merge visible");
    protected PuBoolean m_identifyVertices = new PuBoolean("Identify nearby vertices");
    protected PuBoolean m_triangulate = new PuBoolean("Triangulate");
    protected PuBoolean m_removeDegeneratedElements = new PuBoolean("Remove (combinatorically) degenerated elements");
    protected PuBoolean m_removeDuplicateElements = new PuBoolean("Remove duplicate elements");
    protected PuBoolean m_removeUnusedVertices = new PuBoolean("Remove unused vertices");
    protected PuBoolean m_makeManifold = new PuBoolean("Make manifold");
    protected PuBoolean m_removeOverlaps = new PuBoolean("Remove overlaps");
    protected PuBoolean m_splitToComponents = new PuBoolean("Split into connected components");
    protected PuInteger m_removeSmallComponents;
    static /* synthetic */ Class class$jvx$geom$PwCleanMesh;

    public PwCleanMesh(String string) {
        super(string);
        this.m_splitToComponents.addUpdateListener((PsUpdateIf)this);
        this.m_removeSmallComponents = new PuInteger(" ");
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PwCleanMesh == null ? (class$jvx$geom$PwCleanMesh = PwCleanMesh.class$("jvx.geom.PwCleanMesh")) : class$jvx$geom$PwCleanMesh)) {
            this.init();
        }
    }

    public PwCleanMesh(String string, PgElementSet pgElementSet) {
        this(string);
        this.setGeometry((PgGeometry)pgElementSet);
    }

    public void init() {
        super.init();
        this.m_mergeVisible.setDefState(false);
        this.m_mergeVisible.init();
        this.m_identifyVertices.setDefState(true);
        this.m_identifyVertices.init();
        this.m_triangulate.setDefState(true);
        this.m_triangulate.init();
        this.m_removeDegeneratedElements.setDefState(true);
        this.m_removeDegeneratedElements.init();
        this.m_removeDuplicateElements.setDefState(true);
        this.m_removeDuplicateElements.init();
        this.m_removeUnusedVertices.setDefState(true);
        this.m_removeUnusedVertices.init();
        this.m_makeManifold.setDefState(true);
        this.m_makeManifold.init();
        this.m_removeOverlaps.setDefState(false);
        this.m_removeOverlaps.init();
        this.m_splitToComponents.setDefState(true);
        this.m_splitToComponents.init();
        this.m_removeSmallComponents.setDefBounds(0, 10, 1, 1);
        this.m_removeSmallComponents.setDefValue(0);
        this.m_removeSmallComponents.init();
    }

    public void setGeometry(PgGeometry pgGeometry) {
        if (pgGeometry == null || !(pgGeometry instanceof PgElementSet)) {
            PsDebug.warning((String)"Geom is not an PgElementSet.");
            return;
        }
        super.setGeometry(pgGeometry);
        this.m_geom = (PgElementSet)pgGeometry;
    }

    public void setDisplay(PvDisplayIf pvDisplayIf) {
        super.setDisplay(pvDisplayIf);
    }

    public void reset() {
        super.reset();
        if (this.m_geom == null || this.m_geomSave == null) {
            return;
        }
        this.m_geom.copy((PsObject)this.m_geomSave);
        this.update((Object)this);
    }

    public boolean update(Object object) {
        if (object == this.m_splitToComponents) {
            this.m_removeSmallComponents.setEnabled(this.m_splitToComponents.getState());
            return true;
        }
        return super.update(object);
    }

    public String getName() {
        return "MeshCleaner workshop";
    }

    public void start() {
        int n;
        if (this.m_mergeVisible.getState()) {
            PgGeometryIf[] pgGeometryIfArray = this.m_display.getGeometries();
            int n2 = pgGeometryIfArray.length;
            for (n = 0; n < n2; ++n) {
                if (!pgGeometryIfArray[n].isVisible() || pgGeometryIfArray[n] == this.m_geom) continue;
                this.m_geom.merge(pgGeometryIfArray[n]);
                this.m_display.removeGeometry(pgGeometryIfArray[n]);
            }
        }
        PwCleanMesh.cleanMesh(this.m_geom, this.m_identifyVertices.getState(), this.m_triangulate.getState(), this.m_removeDegeneratedElements.getState(), this.m_removeDuplicateElements.getState(), this.m_removeUnusedVertices.getState(), this.m_makeManifold.getState(), this.m_removeOverlaps.getState());
        if (this.m_splitToComponents.getState()) {
            int n3 = this.m_removeSmallComponents.getValue();
            PgElementSet[] pgElementSetArray = PwCleanMesh.splitIntoComponents(this.m_geom);
            this.m_display.removeGeometry((PgGeometryIf)this.m_geom);
            n = pgElementSetArray.length;
            for (int i = 0; i < n; ++i) {
                if (pgElementSetArray[i].getNumElements() < n3) continue;
                this.m_display.addGeometry((PgGeometryIf)pgElementSetArray[i]);
            }
        }
        this.m_display.update((Object)this.m_display);
        this.m_geom.update((Object)this.m_geom);
    }

    public static void cleanMesh(PgElementSet pgElementSet, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        if (bl) {
            PuCleanMesh.identifyVertices((PgGeometry)pgElementSet);
        }
        if (bl2) {
            PgElementSet.triangulate((PgElementSet)pgElementSet);
        }
        if (bl3) {
            PuCleanMesh.removeDegenerateElements((PgElementSet)pgElementSet);
        }
        if (bl4) {
            PwCleanMesh.identifyEqualElements(pgElementSet);
        }
        if (bl5) {
            pgElementSet.removeUnusedVertices();
        }
        if (bl6) {
            PwCleanMesh.makeManifold(pgElementSet);
        }
        if (bl7) {
            PsDebug.warning((String)"Remove overlaps is not implemented yet");
        }
    }

    public static int markFlatEdges(PgElementSet pgElementSet, double d) {
        return PwIdentify.markFlatEdges(pgElementSet, d);
    }

    public static int identifyFlatEdges(PgElementSet pgElementSet, double d) {
        return PwIdentify.identifyFlatEdges(pgElementSet, d);
    }

    public static int identifyFlatRegions(PgElementSet pgElementSet, double d) {
        return PwIdentify.identifyFlatRegions(pgElementSet, d);
    }

    public static int markFlatRegions(PgElementSet pgElementSet, double d) {
        return PwIdentify.markFlatRegions(pgElementSet, d);
    }

    public static int identifyVertices(PgPointSet pgPointSet, double d) {
        return PuCleanMesh.identifyVertices((PgPointSet)pgPointSet, (double)d);
    }

    public void markVertices(double d) {
        PwCleanMesh.markVertices((PgPointSet)this.m_geom, d);
    }

    public static void markVertices(PgPointSet pgPointSet, double d) {
        PwIdentify.markVertices(pgPointSet, d);
    }

    public void removeMarks() {
        PwCleanMesh.removeMarks((PgGeometry)this.m_geom);
    }

    public static void removeMarks(PgGeometry pgGeometry) {
        PwIdentify.removeMarks(pgGeometry);
    }

    public static void removeDegenerateElements(PgElementSet pgElementSet) {
        PuCleanMesh.removeDegenerateElements((PgElementSet)pgElementSet);
    }

    public static boolean isDegenerated(PgElementSet pgElementSet) {
        if (pgElementSet == null) {
            return false;
        }
        PiVector[] piVectorArray = pgElementSet.getElements();
        PiVector[] piVectorArray2 = pgElementSet.getNeighbours();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        int n = pgElementSet.getNumElements();
        for (int i = 0; i < n; ++i) {
            int n2 = piVectorArray[i].getSize();
            if (n2 < 3) {
                return true;
            }
            int[] nArray = piVectorArray[i].m_data;
            for (int j = 0; j < n2; ++j) {
                if (piVectorArray2[i].m_data[(j + n2 - 1) % n2] >= i || !(PdVector.dist((PdVector)pdVectorArray[nArray[j]], (PdVector)pdVectorArray[nArray[(j + 1) % n2]]) < 1.0E-10)) continue;
                return true;
            }
        }
        return false;
    }

    public static void collapseEdges(PgElementSet pgElementSet, double d) {
        if (pgElementSet == null) {
            return;
        }
        double d2 = d * d;
        PiVector[] piVectorArray = pgElementSet.getElements();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        PgVertexStar pgVertexStar = new PgVertexStar();
        int n = pgElementSet.getNumElements();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            int n2 = piVectorArray[i].getSize();
            for (int j = 0; j < n2; ++j) {
                int n3 = piVectorArray[i].m_data[j];
                int n4 = piVectorArray[i].m_data[(j + 1) % n2];
                if (n3 == n4 || !(PdVector.sqrDist((PdVector)pdVectorArray[n3], (PdVector)pdVectorArray[n4]) < d2)) continue;
                bl = true;
                pgElementSet.setTagVertex(n4, 2);
                pgVertexStar.makeVertexStar(pgElementSet, n4, i);
                PiVector piVector = pgVertexStar.getElement();
                int n5 = piVector.getSize();
                for (int k = 0; k < n5; ++k) {
                    piVectorArray[piVector.m_data[k]].changeValue(n4, n3);
                }
            }
        }
        if (bl) {
            pgElementSet.removeMarkedVertices();
            PuCleanMesh.removeDegenerateElements((PgElementSet)pgElementSet);
        }
    }

    public static int[] identifyEqualElements(PgElementSet pgElementSet) {
        int n;
        int n2;
        int n3;
        if (pgElementSet == null) {
            return null;
        }
        PiVector[] piVectorArray = pgElementSet.getElements();
        int n4 = pgElementSet.getNumVertices();
        int n5 = pgElementSet.getNumElements();
        PiVector[] piVectorArray2 = new PiVector[n4];
        int n6 = 0;
        while (n6 < n5) {
            n3 = piVectorArray[n6].getSize();
            n2 = piVectorArray[n6].m_data[0];
            for (n = 1; n < n3; ++n) {
                if (piVectorArray[n6].m_data[n] >= n2) continue;
                n2 = piVectorArray[n6].m_data[n];
            }
            if (piVectorArray2[n2] == null) {
                piVectorArray2[n2] = new PiVector(0);
            }
            n = piVectorArray2[n2].getSize();
            piVectorArray2[n2].setSize(n + 1);
            piVectorArray2[n2].m_data[n] = n6++;
        }
        for (n6 = 0; n6 < n4; ++n6) {
            if (piVectorArray2[n6] == null) continue;
            n3 = piVectorArray2[n6].getSize();
            for (n2 = 0; n2 < n3 - 1; ++n2) {
                n = piVectorArray2[n6].m_data[n2];
                if (pgElementSet.hasTagElement(n, 2)) continue;
                for (int i = n2 + 1; i < n3; ++i) {
                    int n7;
                    int n8;
                    int n9 = piVectorArray2[n6].m_data[i];
                    if (pgElementSet.hasTagElement(n9, 2)) continue;
                    PiVector piVector = piVectorArray[n];
                    PiVector piVector2 = piVectorArray[n9];
                    int n10 = piVector.getSize();
                    if (n10 != piVector2.getSize()) continue;
                    int n11 = -1;
                    int n12 = -1;
                    for (n8 = 0; n8 < n10; ++n8) {
                        if (piVector.m_data[n8] == n6) {
                            n11 = n8;
                        }
                        if (piVector2.m_data[n8] != n6) continue;
                        n12 = n8;
                    }
                    n8 = 1;
                    for (n7 = 1; n7 < n10; ++n7) {
                        if (piVector.m_data[(n7 + n11) % n10] == piVector2.m_data[(n7 + n12) % n10]) continue;
                        n8 = 0;
                        break;
                    }
                    if (n8 == 0) {
                        n8 = 1;
                        for (n7 = 1; n7 < n10; ++n7) {
                            if (piVector.m_data[(n7 + n11) % n10] == piVector2.m_data[(n12 + n10 - n7) % n10]) continue;
                            n8 = 0;
                            break;
                        }
                    }
                    if (n8 == 0) continue;
                    pgElementSet.setTagElement(n9, 2);
                }
            }
        }
        int[] nArray = pgElementSet.removeMarkedElements();
        pgElementSet.makeNeighbour();
        return nArray;
    }

    public static void orientate(PgElementSet pgElementSet) {
        PwCleanMesh.makeOrientation(pgElementSet);
    }

    public static boolean makeOrientation(PgElementSet pgElementSet) {
        int n = pgElementSet.getNumElements();
        if (n < 2) {
            return true;
        }
        PiVector[] piVectorArray = pgElementSet.getNeighbours();
        if (piVectorArray == null) {
            return false;
        }
        PiVector[] piVectorArray2 = pgElementSet.getElements();
        PiVector[] piVectorArray3 = null;
        PgEdgeStar[] pgEdgeStarArray = null;
        if (pgElementSet.isEnabledEdges()) {
            piVectorArray3 = pgElementSet.getElementEdges();
            pgEdgeStarArray = pgElementSet.getEdgeStars();
        }
        PdVector[] pdVectorArray = null;
        if (pgElementSet.hasElementNormals()) {
            pdVectorArray = pgElementSet.getElementNormals();
        }
        PdVector[][] pdVectorArray2 = null;
        if (pgElementSet.hasElementTextures()) {
            pdVectorArray2 = pgElementSet.getElementTextures();
        }
        int[] nArray = new int[n];
        boolean[] blArray = new boolean[n];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n - 1) {
            blArray[n4] = true;
            nArray[n2] = n4;
            ++n2;
            while (n3 < n2) {
                int n5 = nArray[n3];
                PiVector piVector = piVectorArray2[n5];
                int n6 = piVector.getSize();
                for (int i = 0; i < n6; ++i) {
                    int n7 = piVectorArray[n5].m_data[i];
                    if (n7 == -1 || blArray[n7]) continue;
                    int n8 = piVector.m_data[(i + 1) % n6];
                    int n9 = piVector.m_data[(i + 2) % n6];
                    PiVector piVector2 = piVectorArray2[n7];
                    int n10 = piVector2.getSize();
                    int n11 = piVector2.getIndexOf(n8);
                    if (piVector2.m_data[(n11 + 1) % n10] == n9) {
                        piVectorArray2[n7].invert();
                        piVectorArray[n7].invert();
                        piVectorArray[n7].shift(-3);
                        if (piVectorArray3 != null) {
                            piVectorArray3[n7].invert();
                            piVectorArray3[n7].shift(-3);
                        }
                        if (pgEdgeStarArray != null) {
                            for (int j = 0; j < n10; ++j) {
                                int n12;
                                int n13;
                                PgEdgeStar pgEdgeStar = pgEdgeStarArray[piVectorArray3[n7].m_data[j]];
                                for (n13 = 0; n13 < pgEdgeStar.getValence() && pgEdgeStar.getElementInd(n13) != n7; ++n13) {
                                }
                                int n14 = pgEdgeStar.getNeighbourLocInd()[n13];
                                pgEdgeStar.getNeighbourLocInd()[n13] = n12 = (2 * n10 - 1 - n14 - 3) % n10;
                            }
                        }
                        if (pdVectorArray != null) {
                            pdVectorArray[n7].multScalar(-1.0);
                        }
                        if (pdVectorArray2 != null) {
                            P_Vector.invert((Object[])pdVectorArray2[n7], (int)n10);
                        }
                    }
                    blArray[n7] = true;
                    nArray[n2] = n7;
                    ++n2;
                }
                ++n3;
            }
            while (blArray[n4] && n4 < n - 1) {
                ++n4;
            }
        }
        if (pgElementSet.hasVertexNormals()) {
            pgElementSet.makeVertexNormals();
        }
        return true;
    }

    public static boolean isOrientatable(PgElementSet pgElementSet) {
        int n;
        int n2 = pgElementSet.getNumElements();
        if (n2 < 2) {
            return true;
        }
        PiVector[] piVectorArray = pgElementSet.getNeighbours();
        if (piVectorArray == null) {
            return false;
        }
        PiVector[] piVectorArray2 = pgElementSet.getElements();
        boolean[] blArray = new boolean[n2];
        boolean[] blArray2 = new boolean[n2];
        int[] nArray = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray[n] = -1;
        }
        nArray[0] = 0;
        blArray[0] = true;
        blArray2[0] = true;
        int n3 = 0;
        int n4 = 1;
        for (n = 0; n < n2 - 1; ++n) {
            int n5;
            int n6 = nArray[n];
            if (n6 == -1) {
                for (n5 = n3; n5 < n2; ++n5) {
                    if (blArray[n5]) continue;
                    n3 = n5 + 1;
                    nArray[n] = n5;
                    ++n4;
                    n6 = n5;
                    blArray2[n5] = true;
                    blArray[n5] = true;
                    break;
                }
            }
            n5 = piVectorArray2[n6].getSize();
            for (int i = 0; i < n5; ++i) {
                int n7;
                int n8 = piVectorArray[n6].m_data[i];
                if (n8 == -1) continue;
                int n9 = pgElementSet.getOppVertexLocInd(n6, i);
                boolean bl = piVectorArray2[n6].m_data[(i + 1) % n5] == piVectorArray2[n8].m_data[(n9 + 2) % (n7 = piVectorArray2[n8].getSize())] && piVectorArray2[n6].m_data[(i + 2) % n5] == piVectorArray2[n8].m_data[(n9 + 1) % n7];
                if (blArray[n8]) {
                    if (bl == (blArray2[n6] == blArray2[n8])) continue;
                    return false;
                }
                nArray[n4] = n8;
                blArray[n8] = true;
                ++n4;
                blArray2[n8] = bl ? blArray2[n6] : !blArray2[n6];
            }
        }
        return true;
    }

    public static int getNumComponents(PgElementSet pgElementSet) {
        return PwCleanMesh.computeConnectivityComponents(pgElementSet, null);
    }

    public static int computeConnectivityComponents(PgElementSet pgElementSet, PiVector piVector) {
        int n;
        int n2 = pgElementSet.getNumElements();
        if (piVector != null && piVector.getSize() < n2) {
            piVector.setSize(n2);
        }
        if (n2 <= 1) {
            if (piVector != null && n2 == 1) {
                piVector.setEntry(0, 0);
            }
            return n2;
        }
        PiVector[] piVectorArray = pgElementSet.getNeighbours();
        if (piVectorArray == null) {
            if (piVector != null) {
                for (int i = 0; i < n2; ++i) {
                    piVector.m_data[i] = i;
                }
            }
            return n2;
        }
        int[] nArray = new int[n2];
        boolean[] blArray = new boolean[n2];
        for (n = 0; n < n2; ++n) {
            blArray[n] = false;
        }
        n = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            if (piVector != null) {
                piVector.m_data[n5] = n4;
            }
            blArray[n5] = true;
            nArray[n] = n5;
            ++n;
            while (n3 < n) {
                int n6 = nArray[n3];
                int n7 = pgElementSet.getDimOfElement(n6);
                PiVector piVector2 = piVectorArray[n6];
                for (int i = 0; i < n7; ++i) {
                    int n8 = piVector2.m_data[i];
                    if (n8 == -1 || blArray[n8]) continue;
                    if (piVector != null) {
                        piVector.m_data[n8] = n4;
                    }
                    blArray[n8] = true;
                    nArray[n] = n8;
                    ++n;
                }
                ++n3;
            }
            ++n4;
            while (n5 < n2 && blArray[n5]) {
                ++n5;
            }
        }
        return n4;
    }

    public static PgElementSet splitBySelection(PgElementSet pgElementSet) {
        int n = pgElementSet.getNumElements();
        PiVector piVector = new PiVector(n);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!pgElementSet.hasTagElement(i, 1)) continue;
            pgElementSet.setTagElement(i, 2);
            piVector.setEntry(n2, i);
            ++n2;
        }
        piVector.setSize(n2);
        PgElementSet pgElementSet2 = new PgElementSet(pgElementSet.getDimOfVertices());
        pgElementSet2.setName(pgElementSet.getName() + "-s");
        pgElementSet2.copySelect((PsObject)pgElementSet, piVector);
        for (int i = 0; i < n2; ++i) {
            pgElementSet2.clearTagElement(i, 1);
            pgElementSet2.clearTagElement(i, 2);
        }
        pgElementSet.removeMarkedElements();
        return pgElementSet2;
    }

    public static PgElementSet[] splitIntoComponents(PgElementSet pgElementSet) {
        int n = pgElementSet.getNumElements();
        PiVector piVector = new PiVector(n);
        int n2 = PwCleanMesh.computeConnectivityComponents(pgElementSet, piVector);
        PgElementSet[] pgElementSetArray = new PgElementSet[n2];
        if (n2 == 1) {
            pgElementSetArray[0] = pgElementSet;
            return pgElementSetArray;
        }
        int[] nArray = new int[n2];
        for (int i = 0; i < n; ++i) {
            int n3 = piVector.getEntry(i);
            nArray[n3] = nArray[n3] + 1;
        }
        PiVector piVector2 = new PiVector();
        for (int i = 0; i < n2; ++i) {
            pgElementSetArray[i] = new PgElementSet(pgElementSet.getDimOfVertices());
            pgElementSetArray[i].setName(pgElementSet.getName() + " " + PsConfig.getMessage((int)45003) + " " + i);
            int n4 = nArray[i];
            piVector2.setSize(n4);
            int n5 = 0;
            for (int j = 0; j < n; ++j) {
                if (piVector.m_data[j] != i) continue;
                piVector2.setEntry(n5, j);
                ++n5;
            }
            pgElementSetArray[i].copySelect((PsObject)pgElementSet, piVector2);
        }
        return pgElementSetArray;
    }

    public static void joinPolygons(PgPolygonSet pgPolygonSet) {
        int n;
        int n2;
        int n3;
        int n4;
        PiVector piVector;
        int n5;
        int n6;
        int n7;
        Object object;
        int n8;
        int n9 = pgPolygonSet.getNumVertices();
        int n10 = pgPolygonSet.getNumPolygons();
        PiVector[] piVectorArray = PiVector.realloc(null, (int)n9, (int)0);
        Color[][] colorArrayArray = new Color[n9][];
        if (pgPolygonSet.hasPolygonColors()) {
            for (n8 = 0; n8 < n9; ++n8) {
                colorArrayArray[n8] = new Color[0];
            }
        }
        for (n8 = 0; n8 < n10; ++n8) {
            object = pgPolygonSet.getPolygon(n8);
            n7 = object.getSize();
            for (int i = 1; i < n7; ++i) {
                n6 = ((PiVector)object).m_data[i - 1];
                n5 = ((PiVector)object).m_data[i];
                if (n6 == n5) continue;
                PiVector piVector2 = piVectorArray[n6];
                piVector = piVectorArray[n5];
                n4 = 0;
                int n11 = piVector2.getSize();
                n3 = piVector.getSize();
                for (n2 = 0; n2 < n11; ++n2) {
                    if (piVector2.m_data[n2] != n5) continue;
                    n4 = 1;
                }
                if (n4 != 0) continue;
                piVector2.setSize(n11 + 1);
                piVector2.m_data[n11] = n5;
                piVector.setSize(n3 + 1);
                piVector.m_data[n3] = n6;
                if (!pgPolygonSet.hasPolygonColors()) continue;
                colorArrayArray[n6] = PdColor.realloc((Color[])colorArrayArray[n6], (int)(n11 + 1));
                colorArrayArray[n5] = PdColor.realloc((Color[])colorArrayArray[n5], (int)(n3 + 1));
                colorArrayArray[n6][n11] = pgPolygonSet.getPolygonColor(n8);
                colorArrayArray[n5][n3] = pgPolygonSet.getPolygonColor(n8);
            }
        }
        Vector<PiVector> vector = new Vector<PiVector>();
        object = new Vector();
        for (n7 = 0; n7 < n9; ++n7) {
            PiVector piVector3 = piVectorArray[n7];
            n6 = piVector3.getSize();
            if ((n6 == 2 || n6 == 0) && !pgPolygonSet.hasTagVertex(n7, 1)) continue;
            for (n5 = 0; n5 < n6; ++n5) {
                if (piVector3.m_data[n5] == -1) continue;
                int n12 = piVector3.m_data[n5];
                piVector = new PiVector(n7, n12);
                if (pgPolygonSet.hasPolygonColors()) {
                    ((Vector)object).addElement(colorArrayArray[n7][n5]);
                }
                n4 = 2;
                PiVector piVector4 = piVectorArray[n12];
                piVector3.m_data[n5] = -1;
                n3 = piVector4.getSize();
                for (n2 = 0; n2 < n3; ++n2) {
                    if (piVector4.m_data[n2] != n7) continue;
                    piVector4.m_data[n2] = -1;
                }
                while (n3 == 2 && !pgPolygonSet.hasTagVertex(n12, 1)) {
                    n2 = n12;
                    piVector.setSize(n4 + 1);
                    if (piVector4.m_data[0] == -1) {
                        n12 = piVector4.m_data[1];
                        piVector4.m_data[1] = -1;
                    } else {
                        n12 = piVector4.m_data[0];
                        piVector4.m_data[0] = -1;
                    }
                    piVector.m_data[n4] = n12;
                    ++n4;
                    piVector4 = piVectorArray[n12];
                    n3 = piVector4.getSize();
                    for (n = 0; n < n3; ++n) {
                        if (piVector4.m_data[n] != n2) continue;
                        piVector4.m_data[n] = -1;
                    }
                }
                vector.addElement(piVector);
            }
        }
        for (n7 = 0; n7 < n9; ++n7) {
            PiVector piVector5 = piVectorArray[n7];
            n6 = piVector5.getSize();
            if (n6 != 2) continue;
            for (n5 = 0; n5 < n6; ++n5) {
                if (piVector5.m_data[n5] == -1) continue;
                int n13 = piVector5.m_data[n5];
                piVector = new PiVector(n7, n13);
                if (pgPolygonSet.hasPolygonColors()) {
                    ((Vector)object).addElement(colorArrayArray[n7][n5]);
                }
                n4 = 2;
                PiVector piVector6 = piVectorArray[n13];
                piVector5.m_data[n5] = -1;
                n3 = piVector6.getSize();
                for (n2 = 0; n2 < n3; ++n2) {
                    if (piVector6.m_data[n2] != n7) continue;
                    piVector6.m_data[n2] = -1;
                }
                while (n13 != n7) {
                    n2 = n13;
                    piVector.setSize(n4 + 1);
                    if (piVector6.m_data[0] == -1) {
                        n13 = piVector6.m_data[1];
                        piVector6.m_data[1] = -1;
                    } else {
                        n13 = piVector6.m_data[0];
                        piVector6.m_data[0] = -1;
                    }
                    piVector.m_data[n4] = n13;
                    ++n4;
                    piVector6 = piVectorArray[n13];
                    n3 = piVector6.getSize();
                    for (n = 0; n < n3; ++n) {
                        if (piVector6.m_data[n] != n2) continue;
                        piVector6.m_data[n] = -1;
                    }
                }
                vector.addElement(piVector);
            }
        }
        n10 = vector.size();
        pgPolygonSet.setNumPolygons(n10);
        pgPolygonSet.removeMarkedPolygons();
        for (n7 = 0; n7 < n10; ++n7) {
            pgPolygonSet.setPolygon(n7, (PiVector)vector.elementAt(n7));
        }
        if (pgPolygonSet.hasPolygonColors()) {
            for (n7 = 0; n7 < n10; ++n7) {
                pgPolygonSet.setPolygonColor(n7, (Color)((Vector)object).elementAt(n7));
            }
        }
    }

    public static int getNumNonManifoldVertices(PgElementSet pgElementSet) {
        int n;
        int n2;
        int n3 = pgElementSet.getNumElements();
        int n4 = pgElementSet.getNumVertices();
        PgVertexStar pgVertexStar = new PgVertexStar();
        PiVector piVector = new PiVector(n4);
        PiVector[] piVectorArray = pgElementSet.getElements();
        for (int i = 0; i < n3; ++i) {
            n2 = piVectorArray[i].getSize();
            for (n = 0; n < n2; ++n) {
                int n5 = piVectorArray[i].m_data[n];
                piVector.m_data[n5] = piVector.m_data[n5] + 1;
            }
        }
        boolean[] blArray = new boolean[n4];
        n2 = 0;
        for (n = 0; n < n3; ++n) {
            int n6 = piVectorArray[n].getSize();
            for (int i = 0; i < n6; ++i) {
                int n7 = piVectorArray[n].m_data[i];
                if (blArray[n7]) continue;
                pgVertexStar.makeVertexStar(pgElementSet, n7, n);
                PiVector piVector2 = pgVertexStar.getElement();
                if (piVector2.getSize() < piVector.m_data[n7]) {
                    ++n2;
                }
                blArray[n7] = true;
            }
        }
        return n2;
    }

    public static void makeManifold(PgElementSet pgElementSet) {
        PuCleanMesh.removeDegenerateElements((PgElementSet)pgElementSet);
        PwCleanMesh.removeNonManifoldEdges(pgElementSet);
        pgElementSet.makeNeighbour();
        PwCleanMesh.splitNonManifoldVertices(pgElementSet);
        PwCleanMesh.removeNeighbourhoodDegenerations(pgElementSet);
    }

    public static PiVector splitNonManifoldVertices(PgElementSet pgElementSet) {
        int n;
        int n2;
        int n3 = pgElementSet.getNumElements();
        int n4 = pgElementSet.getNumVertices();
        PgVertexStar pgVertexStar = new PgVertexStar();
        PiVector piVector = new PiVector(n4);
        PiVector[] piVectorArray = pgElementSet.getElements();
        for (int i = 0; i < n3; ++i) {
            n2 = piVectorArray[i].getSize();
            for (int j = 0; j < n2; ++j) {
                int n5 = piVectorArray[i].m_data[j];
                piVector.m_data[n5] = piVector.m_data[n5] + 1;
            }
        }
        boolean[] blArray = new boolean[n4];
        n2 = n4;
        PiVector piVector2 = new PiVector(n4);
        for (n = 0; n < n4; ++n) {
            piVector2.m_data[n] = n;
        }
        for (n = 0; n < n3; ++n) {
            int n6 = piVectorArray[n].getSize();
            for (int i = 0; i < n6; ++i) {
                int n7 = piVectorArray[n].m_data[i];
                if (n7 >= n2 || blArray[n7]) continue;
                pgVertexStar.makeVertexStar(pgElementSet, n7, n);
                PiVector piVector3 = pgVertexStar.getElement();
                int n8 = piVector3.getSize();
                if (n8 < piVector.m_data[n7]) {
                    int n9;
                    int n10;
                    for (n10 = 0; n10 < n8; ++n10) {
                        PiVector piVector4 = piVectorArray[piVector3.m_data[n10]];
                        int n11 = piVector4.getSize();
                        for (n9 = 0; n9 < n11; ++n9) {
                            if (piVector4.m_data[n9] != n7) continue;
                            piVector4.m_data[n9] = n4;
                        }
                    }
                    int n12 = n7;
                    piVector.m_data[n12] = piVector.m_data[n12] - n8;
                    pgElementSet.addVertex(PdVector.copyNew((PdVector)pgElementSet.getVertex(n7)));
                    piVector2.addEntry(n7);
                    if (pgElementSet.hasVertexNormals()) {
                        pgElementSet.setVertexNormal(n4, PdVector.copyNew((PdVector)pgElementSet.getVertexNormal(n7)));
                    }
                    if (pgElementSet.hasVertexColors()) {
                        pgElementSet.setVertexColor(n4, pgElementSet.getVertexColor(n7));
                    }
                    if (pgElementSet.hasVertexTextures()) {
                        pgElementSet.getVertexTextures()[n4] = PdVector.copyNew((PdVector)pgElementSet.getVertexTextures()[n7]);
                    }
                    if (pgElementSet.getNumVectorFields() > 0) {
                        n10 = pgElementSet.getNumVectorFields();
                        for (int j = 0; j < n10; ++j) {
                            PgVectorField pgVectorField = pgElementSet.getVectorField(j);
                            if (pgVectorField.getBasedOn() != 0) continue;
                            pgVectorField.setNumVectors(n4 + 1);
                            pgVectorField.setVector(n4, PdVector.copyNew((PdVector)pgVectorField.getVector(n7)));
                        }
                    }
                    if (!pgVertexStar.isClosed() && pgElementSet.hasBoundary()) {
                        PgBndPolygon[] pgBndPolygonArray = pgElementSet.getBoundaries();
                        int n13 = pgElementSet.getNumBoundaries();
                        int n14 = piVector3.m_data[0];
                        n9 = piVector3.m_data[n8 - 1];
                        for (int j = 0; j < n13; ++j) {
                            int n15 = pgBndPolygonArray[j].getNumVertices();
                            PiVector piVector5 = pgBndPolygonArray[j].getElementInd();
                            PiVector piVector6 = pgBndPolygonArray[j].getVertexInd();
                            for (int k = 0; k < n15 - 1; ++k) {
                                if (piVector5.m_data[k] != n14 && piVector5.m_data[k] != n9) continue;
                                if (piVector6.m_data[k] == n7) {
                                    piVector6.m_data[k] = n4;
                                }
                                if (piVector6.m_data[k + 1] != n7) continue;
                                piVector6.m_data[k + 1] = n4;
                            }
                        }
                    }
                    ++n4;
                    --i;
                    continue;
                }
                if (n7 >= n2) continue;
                blArray[n7] = true;
            }
        }
        return piVector2;
    }

    public void markBoundaryEndPoints() {
        PwCleanMesh.markBoundaryEndPoints(this.m_geom);
    }

    public static void markBoundaryEndPoints(PgElementSet pgElementSet) {
        int n = pgElementSet.getNumVertices();
        for (int i = 0; i < n; ++i) {
            pgElementSet.clearTagVertex(i, 1);
        }
        if (!pgElementSet.hasBoundary()) {
            return;
        }
        PgBndPolygon[] pgBndPolygonArray = pgElementSet.getBoundaries();
        int n2 = pgBndPolygonArray.length;
        for (int i = 0; i < n2; ++i) {
            PiVector piVector = pgBndPolygonArray[i].getVertexInd();
            int n3 = pgBndPolygonArray[i].getNumVertices();
            if (n3 <= 0) continue;
            pgElementSet.setTagVertex(piVector.m_data[0], 1);
            pgElementSet.setTagVertex(piVector.m_data[n3 - 1], 1);
        }
    }

    public void markCornerVertices(double d) {
        PwCleanMesh.markCornerVertices(this.m_geom, d);
    }

    public static void markCornerVertices(PgElementSet pgElementSet, double d) {
        int n;
        PdVector pdVector = new PdVector(pgElementSet.getNumVertices());
        int n2 = pgElementSet.getNumVertices();
        boolean[] blArray = new boolean[n2];
        int n3 = pgElementSet.getNumElements();
        for (n = 0; n < n3; ++n) {
            PiVector piVector = pgElementSet.getElement(n);
            PiVector piVector2 = pgElementSet.getNeighbour(n);
            int n4 = piVector.getSize();
            for (int i = 0; i < n4; ++i) {
                PdVector pdVector2 = pgElementSet.getVertex(piVector.m_data[i]);
                PdVector pdVector3 = pgElementSet.getVertex(piVector.m_data[(i + 1) % n4]);
                PdVector pdVector4 = pgElementSet.getVertex(piVector.m_data[(i + 2) % n4]);
                int n5 = piVector.m_data[(i + 1) % n4];
                pdVector.m_data[n5] = pdVector.m_data[n5] + PdVector.angle((PdVector)pdVector3, (PdVector)pdVector2, (PdVector)pdVector4);
                if (piVector2.m_data[i] != -1) continue;
                blArray[piVector.m_data[(i + 1) % n4]] = true;
                blArray[piVector.m_data[(i + 2) % n4]] = true;
            }
        }
        for (n = 0; n < n2; ++n) {
            if (!blArray[n] || !(pdVector.m_data[n] < d) && !(360.0 - pdVector.m_data[n] < d)) continue;
            pgElementSet.setTagVertex(n, 1);
        }
    }

    public static boolean hasPlanarElements(PgElementSet pgElementSet, double d) {
        if (pgElementSet.getDimOfElements() == 3) {
            return true;
        }
        if (pgElementSet.getDimOfVertices() <= 2) {
            return true;
        }
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        PiVector[] piVectorArray = pgElementSet.getElements();
        PdVector pdVector = new PdVector(3);
        if (!pgElementSet.hasElementNormals()) {
            pgElementSet.makeElementNormals();
        }
        PdVector[] pdVectorArray2 = pgElementSet.getElementNormals();
        int n = pgElementSet.getNumElements();
        for (int i = 0; i < n; ++i) {
            int n2 = piVectorArray[i].getSize();
            if (n2 <= 3) continue;
            for (int j = 1; j < n2 - 1; ++j) {
                pdVector.sub(pdVectorArray[piVectorArray[i].m_data[j]], pdVectorArray[piVectorArray[i].m_data[0]]);
                pdVector.normalize();
                if (!(Math.abs(pdVector.dot(pdVectorArray2[i])) > d)) continue;
                return false;
            }
        }
        return true;
    }

    public static PgPolygonSet getParameterLines(PgElementSet pgElementSet) {
        return PwParameterLines.getParameterLines(pgElementSet);
    }

    public static void refineParameterLines(PgElementSet pgElementSet, int n) {
        PwParameterLines.refineParameterLines(pgElementSet, n);
    }

    public static void cutAlongPolygonSet(PgElementSet pgElementSet, PgPolygonSet pgPolygonSet) {
        int n;
        int n2;
        int n3;
        PiVector piVector;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        PgBndPolygon[] pgBndPolygonArray;
        int n10;
        PiVector[] piVectorArray;
        int n11;
        if (pgElementSet == null || pgPolygonSet == null) {
            PsDebug.warning((String)PsConfig.getMessage((int)65000));
            return;
        }
        int n12 = pgPolygonSet.getNumPolygons();
        if (n12 == 0) {
            return;
        }
        PgPolygonSet pgPolygonSet2 = (PgPolygonSet)pgPolygonSet.clone();
        int n13 = 0;
        int n14 = 0;
        Vector<PdVector> vector = new Vector<PdVector>();
        boolean bl = pgElementSet.hasVertexColors();
        Vector<Color> vector2 = new Vector<Color>();
        boolean bl2 = pgElementSet.hasVertexNormals();
        Vector<Object> vector3 = new Vector<Object>();
        boolean bl3 = pgElementSet.hasVertexTextures();
        Vector<PdVector> vector4 = new Vector<PdVector>();
        int n15 = pgElementSet.getNumVectorFields();
        Vector[] vectorArray = new Vector[n15];
        boolean[] blArray = new boolean[n15];
        for (n11 = 0; n11 < n15; ++n11) {
            boolean bl4 = blArray[n11] = pgElementSet.getVectorField(n11).getBasedOn() == 0;
            if (!blArray[n11]) continue;
            vectorArray[n11] = new Vector();
        }
        n11 = pgElementSet.getNumElements();
        int n16 = pgElementSet.getNumVertices();
        PiVector[] piVectorArray2 = pgElementSet.getElements();
        PiVector piVector2 = new PiVector(n16);
        for (int i = 0; i < n12; ++i) {
            piVectorArray = pgPolygonSet2.getPolygon(i);
            int n17 = piVectorArray.getSize();
            for (int j = 1; j < n17; ++j) {
                int n18 = piVectorArray.m_data[j - 1];
                piVector2.m_data[n18] = piVector2.m_data[n18] + 1;
                int n19 = piVectorArray.m_data[j];
                piVector2.m_data[n19] = piVector2.m_data[n19] + 1;
            }
        }
        PgVertexStar pgVertexStar = new PgVertexStar();
        piVectorArray = new PiVector[n16];
        boolean[] blArray2 = new boolean[n16];
        boolean[] blArray3 = new boolean[n16];
        for (int i = 0; i < n11; ++i) {
            n10 = piVectorArray2[i].getSize();
            for (int j = 0; j < n10; ++j) {
                if (blArray3[piVectorArray2[i].m_data[j]]) continue;
                blArray3[piVectorArray2[i].m_data[j]] = true;
                if (piVector2.m_data[piVectorArray2[i].m_data[j]] <= 0) continue;
                pgVertexStar.makeVertexStar(pgElementSet, piVectorArray2[i].m_data[j], i);
                piVectorArray[piVectorArray2[i].m_data[j]] = PiVector.copyNew((PiVector)pgVertexStar.getElement());
                blArray2[piVectorArray2[i].m_data[j]] = pgVertexStar.isClosed();
            }
        }
        PiVector[] piVectorArray3 = pgElementSet.getNeighbours();
        for (n10 = 0; n10 < n12; ++n10) {
            int n20;
            int n21;
            PiVector piVector3 = pgPolygonSet2.getPolygon(n10);
            pgBndPolygonArray = PiVector.copyNew((PiVector)piVector3);
            n9 = piVector3.getSize();
            if (n9 > 2) {
                n8 = piVector3.m_data[0];
                n21 = piVector3.m_data[0];
                n7 = piVector3.m_data[1];
                n20 = piVector3.m_data[2];
                for (int i = 1; i < n9 - 1; ++i) {
                    int n22;
                    int n23;
                    PiVector piVector4;
                    PiVector piVector5 = piVectorArray[n7];
                    n6 = piVector5.getSize();
                    boolean[] blArray4 = new boolean[n6];
                    n5 = -1;
                    int n24 = -1;
                    for (int j = 0; j < n6; ++j) {
                        PiVector piVector6 = piVectorArray2[piVector5.m_data[j]];
                        int n25 = piVector6.getSize();
                        for (n4 = 0; n4 < n25; ++n4) {
                            if (piVector6.m_data[n4] != n21) continue;
                            n5 = j;
                            n24 = n4;
                        }
                    }
                    piVector = piVectorArray2[piVector5.m_data[n5]];
                    n3 = piVector.getSize();
                    PiVector piVector7 = piVectorArray3[piVector5.m_data[n5]];
                    n4 = piVector.m_data[(n24 - 1 + n3) % n3] == n7 ? (piVector5.m_data[(n5 + 1) % n6] == piVector7.m_data[(n24 - 2 + n3) % n3] ? (n5 + 1) % n6 : (n5 - 1 + n6) % n6) : (piVector5.m_data[(n5 + 1) % n6] == piVector7.m_data[(n24 - 1 + n3) % n3] ? (n5 + 1) % n6 : (n5 - 1 + n6) % n6);
                    boolean bl5 = false;
                    while (!bl5 && n21 != n20) {
                        blArray4[n5] = true;
                        piVector = piVectorArray2[piVector5.m_data[n5]];
                        piVector7 = piVectorArray3[piVector5.m_data[n5]];
                        n3 = piVector.getSize();
                        for (n2 = 0; n2 < n3; ++n2) {
                            if (piVector.m_data[n2] != n21) continue;
                            n24 = n2;
                        }
                        if (piVector.m_data[(n24 - 1 + n3) % n3] == n7) {
                            if (piVector5.m_data[(n5 + 1) % n6] == piVector7.m_data[(n24 - 3 + n3) % n3]) {
                                n5 = (n5 + 1) % n6;
                            } else if (piVector5.m_data[(n5 - 1 + n6) % n6] == piVector7.m_data[(n24 - 3 + n3) % n3]) {
                                n5 = (n5 - 1 + n6) % n6;
                            } else {
                                bl5 = true;
                            }
                            n21 = piVector.m_data[(n24 - 2 + n3) % n3];
                            continue;
                        }
                        if (piVector5.m_data[(n5 + 1) % n6] == piVector7.m_data[n24]) {
                            n5 = (n5 + 1) % n6;
                        } else if (piVector5.m_data[(n5 - 1 + n6) % n6] == piVector7.m_data[n24]) {
                            n5 = (n5 - 1 + n6) % n6;
                        } else {
                            bl5 = true;
                        }
                        n21 = piVector.m_data[(n24 + 2) % n3];
                    }
                    n2 = 0;
                    while (n2 == 0 && n8 != n20) {
                        blArray4[n4] = false;
                        piVector4 = piVectorArray2[piVector5.m_data[n4]];
                        piVector7 = piVectorArray3[piVector5.m_data[n4]];
                        n3 = piVector4.getSize();
                        for (n23 = 0; n23 < n3; ++n23) {
                            if (piVector4.m_data[n23] != n8) continue;
                            n24 = n23;
                        }
                        if (piVector4.m_data[(n24 - 1 + n3) % n3] == n7) {
                            if (piVector5.m_data[(n4 + 1) % n6] == piVector7.m_data[(n24 - 3 + n3) % n3]) {
                                n4 = (n4 + 1) % n6;
                            } else if (piVector5.m_data[(n4 - 1 + n6) % n6] == piVector7.m_data[(n24 - 3 + n3) % n3]) {
                                n4 = (n4 - 1 + n6) % n6;
                            } else {
                                n2 = 1;
                            }
                            n8 = piVector4.m_data[(n24 - 2 + n3) % n3];
                            continue;
                        }
                        if (piVector5.m_data[(n4 + 1) % n6] == piVector7.m_data[n24]) {
                            n4 = (n4 + 1) % n6;
                        } else if (piVector5.m_data[(n4 - 1 + n6) % n6] == piVector7.m_data[n24]) {
                            n4 = (n4 - 1 + n6) % n6;
                        } else {
                            n2 = 1;
                        }
                        n8 = piVector4.m_data[(n24 + 2) % n3];
                    }
                    if (n2 != 0) {
                        while (!bl5) {
                            blArray4[n5] = false;
                            piVector = piVectorArray2[piVector5.m_data[n5]];
                            piVector7 = piVectorArray3[piVector5.m_data[n5]];
                            n3 = piVector.getSize();
                            for (int j = 0; j < n3; ++j) {
                                if (piVector.m_data[j] != n21) continue;
                                n24 = j;
                            }
                            if (piVector.m_data[(n24 - 1 + n3) % n3] == n7) {
                                if (piVector5.m_data[(n5 + 1) % n6] == piVector7.m_data[(n24 - 3 + n3) % n3]) {
                                    n5 = (n5 + 1) % n6;
                                } else if (piVector5.m_data[(n5 - 1 + n6) % n6] == piVector7.m_data[(n24 - 3 + n3) % n3]) {
                                    n5 = (n5 - 1 + n6) % n6;
                                } else {
                                    bl5 = true;
                                }
                                n21 = piVector.m_data[(n24 - 2 + n3) % n3];
                                continue;
                            }
                            if (piVector5.m_data[(n5 + 1) % n6] == piVector7.m_data[n24]) {
                                n5 = (n5 + 1) % n6;
                            } else if (piVector5.m_data[(n5 - 1 + n6) % n6] == piVector7.m_data[n24]) {
                                n5 = (n5 - 1 + n6) % n6;
                            } else {
                                bl5 = true;
                            }
                            n21 = piVector.m_data[(n24 + 2) % n3];
                        }
                    } else if (bl5) {
                        while (n2 == 0) {
                            blArray4[n4] = true;
                            piVector4 = piVectorArray2[piVector5.m_data[n4]];
                            piVector7 = piVectorArray3[piVector5.m_data[n4]];
                            n3 = piVector4.getSize();
                            for (n23 = 0; n23 < n3; ++n23) {
                                if (piVector4.m_data[n23] != n8) continue;
                                n24 = n23;
                            }
                            if (piVector4.m_data[(n24 - 1 + n3) % n3] == n7) {
                                if (piVector5.m_data[(n4 + 1) % n6] == piVector7.m_data[(n24 - 3 + n3) % n3]) {
                                    n4 = (n4 + 1) % n6;
                                } else if (piVector5.m_data[(n4 - 1 + n6) % n6] == piVector7.m_data[(n24 - 3 + n3) % n3]) {
                                    n4 = (n4 - 1 + n6) % n6;
                                } else {
                                    n2 = 1;
                                }
                                n8 = piVector4.m_data[(n24 - 2 + n3) % n3];
                                continue;
                            }
                            if (piVector5.m_data[(n4 + 1) % n6] == piVector7.m_data[n24]) {
                                n4 = (n4 + 1) % n6;
                            } else if (piVector5.m_data[(n4 - 1 + n6) % n6] == piVector7.m_data[n24]) {
                                n4 = (n4 - 1 + n6) % n6;
                            } else {
                                n2 = 1;
                            }
                            n8 = piVector4.m_data[(n24 + 2) % n3];
                        }
                    }
                    int n26 = piVector3.m_data[i];
                    n23 = n16 + n13;
                    ++n13;
                    vector.addElement(PdVector.copyNew((PdVector)pgElementSet.getVertex(n26)));
                    if (bl) {
                        vector2.addElement(pgElementSet.getVertexColor(n26));
                    }
                    if (bl2) {
                        vector3.addElement(pgElementSet.getVertexNormal(n26).clone());
                    }
                    if (bl3) {
                        vector4.addElement(PdVector.copyNew((PdVector)pgElementSet.getVertexTexture(n26)));
                    }
                    for (n22 = 0; n22 < n15; ++n22) {
                        if (!blArray[n22]) continue;
                        vectorArray[n22].addElement(PdVector.copyNew((PdVector)pgElementSet.getVectorField(n22).getVector(n26)));
                    }
                    pgBndPolygonArray.m_data[i] = n23;
                    piVector2.m_data[n7] = 0;
                    for (n22 = 0; n22 < n6; ++n22) {
                        if (!blArray4[n22]) continue;
                        piVectorArray2[piVector5.m_data[n22]].changeValue(n7, n23);
                    }
                    n7 = n20;
                    if (i < n9 - 2) {
                        n20 = piVector3.m_data[i + 2];
                    }
                    n8 = n26;
                    n21 = n23;
                }
            }
            if (pgBndPolygonArray.getSize() != 2 || !pgElementSet.hasTagVertex(pgBndPolygonArray.m_data[0], 14) || !pgElementSet.hasTagVertex(pgBndPolygonArray.m_data[1], 14)) {
                pgPolygonSet2.setNumPolygons(n12 + n14 + 1);
                pgPolygonSet2.setPolygon(n12 + n14, (PiVector)pgBndPolygonArray);
                ++n14;
                continue;
            }
            PiVector piVector8 = piVectorArray[pgBndPolygonArray.m_data[0]];
            n21 = piVector8.getSize();
            n7 = 0;
            for (n20 = 0; n20 < n21; ++n20) {
                PiVector piVector9 = piVectorArray2[piVector8.m_data[n20]];
                int n27 = piVector9.getSize();
                for (n6 = 0; n6 < n27; ++n6) {
                    if (piVector9.m_data[n6] != pgBndPolygonArray.m_data[1]) continue;
                    ++n7;
                }
            }
            if (n7 != 2) continue;
            pgPolygonSet2.setNumPolygons(n12 + n14 + 1);
            pgPolygonSet2.setPolygon(n12 + n14, (PiVector)pgBndPolygonArray);
            ++n14;
        }
        n10 = pgPolygonSet2.getNumPolygons();
        PiVector[] piVectorArray4 = pgPolygonSet2.getPolygons();
        if (pgElementSet.hasBoundary()) {
            pgBndPolygonArray = pgElementSet.getBoundaries();
            n9 = pgBndPolygonArray.length;
            for (n8 = 0; n8 < n9; ++n8) {
                PiVector piVector10 = pgBndPolygonArray[n8].getVertexInd();
                n7 = piVector10.getSize();
                pgElementSet.setTagVertex(piVector10.m_data[0], 1);
                pgElementSet.setTagVertex(piVector10.m_data[n7 - 1], 1);
            }
        }
        pgElementSet.setNumVertices(n16 + n13);
        for (n = 0; n < n13; ++n) {
            pgElementSet.setVertex(n16 + n, (PdVector)vector.elementAt(n));
        }
        for (n = 0; n < n16; ++n) {
            boolean bl6;
            int n28;
            n9 = piVector2.m_data[n];
            if (n9 <= 0) continue;
            PiVector piVector11 = piVectorArray[n];
            int n29 = piVector11.getSize();
            PiVector piVector12 = new PiVector(n29);
            PiVector piVector13 = new PiVector(2 * n29);
            piVector13.setConstant(-1);
            boolean[] blArray5 = new boolean[n10];
            boolean[] blArray6 = new boolean[n10];
            for (n6 = 0; n6 < n29; ++n6) {
                PiVector piVector14 = piVectorArray2[piVector11.m_data[n6]];
                n5 = piVector14.getSize();
                for (int i = 0; i < n5; ++i) {
                    if (piVector14.m_data[i] != n) continue;
                    boolean bl7 = false;
                    n3 = 0;
                    piVector12.m_data[n6] = i;
                    for (n28 = 0; n28 < n10; ++n28) {
                        if (!blArray5[n28] && piVectorArray4[n28].m_data[0] == n) {
                            if (!bl7 && piVector14.m_data[(i - 1 + n5) % n5] == piVectorArray4[n28].m_data[1]) {
                                blArray5[n28] = true;
                                piVector13.m_data[2 * n6] = 2 * n28;
                                bl7 = true;
                            } else if (n3 == 0 && piVector14.m_data[(i + 1) % n5] == piVectorArray4[n28].m_data[1]) {
                                blArray5[n28] = true;
                                piVector13.m_data[2 * n6 + 1] = 2 * n28;
                                n3 = 1;
                            }
                        }
                        if (blArray6[n28] || piVectorArray4[n28].m_data[(n4 = piVectorArray4[n28].getSize() - 2) + 1] != n) continue;
                        if (!bl7 && piVector14.m_data[(i - 1 + n5) % n5] == piVectorArray4[n28].m_data[n4]) {
                            blArray6[n28] = true;
                            piVector13.m_data[2 * n6] = 2 * n28 + 1;
                            bl7 = true;
                            continue;
                        }
                        if (n3 != 0 || piVector14.m_data[(i + 1) % n5] != piVectorArray4[n28].m_data[n4]) continue;
                        blArray6[n28] = true;
                        piVector13.m_data[2 * n6 + 1] = 2 * n28 + 1;
                        n3 = 1;
                    }
                }
            }
            n6 = 0;
            if (blArray2[n]) {
                PiVector piVector15;
                int n30;
                PiVector piVector16;
                while ((piVector13.m_data[2 * n6] == -1 || piVector13.m_data[2 * n6 + 1] == -1) && (piVector13.m_data[2 * n6] == -1 || piVector16.m_data[(piVector12.m_data[n6] + 1) % (n30 = (piVector16 = piVectorArray2[piVector11.m_data[n6]]).getSize())] != piVector15.m_data[(piVector12.m_data[(n6 + 1) % n29] + 1) % (n3 = (piVector15 = piVectorArray2[piVector11.m_data[(n6 + 1) % n29]]).getSize())] && piVector16.m_data[(piVector12.m_data[n6] + 1) % n30] != piVector15.m_data[(piVector12.m_data[(n6 + 1) % n29] - 1 + n3) % n3]) && (piVector13.m_data[2 * n6 + 1] == -1 || piVector16.m_data[(piVector12.m_data[n6] - 1 + (n30 = (piVector16 = piVectorArray2[piVector11.m_data[n6]]).getSize())) % n30] != piVector15.m_data[(piVector12.m_data[(n6 + 1) % n29] + 1) % (n3 = (piVector15 = piVectorArray2[piVector11.m_data[(n6 + 1) % n29]]).getSize())] && piVector16.m_data[(piVector12.m_data[n6] - 1 + n30) % n30] != piVector15.m_data[(piVector12.m_data[(n6 + 1) % n29] - 1 + n3) % n3])) {
                    ++n6;
                }
                bl6 = true;
            } else {
                PiVector piVector17 = piVectorArray3[piVector11.m_data[0]];
                int n31 = piVector17.getSize();
                bl6 = piVector17.m_data[(piVector12.m_data[0] - 1 + n31) % n31] == -1 ? piVector13.m_data[1] != -1 : piVector13.m_data[0] != -1;
                n6 = 0;
            }
            n5 = 0;
            PiVector piVector18 = new PiVector(n29);
            for (int i = 0; i < n29; ++i) {
                n3 = (i + n6) % n29;
                piVector18.m_data[n3] = n5++;
                if (bl6) {
                    if (piVector13.m_data[2 * n3] != -1 && piVector13.m_data[2 * n3 + 1] != -1) continue;
                    bl6 = false;
                    continue;
                }
                if (piVector13.m_data[2 * n3] == -1 && piVector13.m_data[2 * n3 + 1] == -1) continue;
                bl6 = true;
                ++n5;
            }
            if (!blArray2[n]) {
                PiVector piVector19 = piVectorArray3[piVector11.m_data[n29 - 1]];
                n3 = piVector19.getSize();
                if (piVector19.m_data[(piVector12.m_data[n29 - 1] - 1 + n3) % n3] == -1) {
                    if (piVector13.m_data[2 * n29 - 1] == -1 && piVector19.m_data[(piVector12.m_data[0] - 2 + n3) % n3] != -1) {
                        ++n5;
                    }
                } else if (piVector13.m_data[2 * n29 - 2] == -1) {
                    ++n5;
                }
                if (n5 == 0) {
                    n5 = 1;
                }
            }
            piVector = new PiVector(n5);
            piVector.m_data[0] = n;
            for (n3 = 1; n3 < n5; ++n3) {
                piVector.m_data[n3] = pgElementSet.addVertex(PdVector.copyNew((PdVector)pgElementSet.getVertex(n)));
                ++n13;
                if (bl) {
                    vector2.addElement(pgElementSet.getVertexColor(n));
                }
                if (bl2) {
                    vector3.addElement(pgElementSet.getVertexNormal(n).clone());
                }
                if (bl3) {
                    vector4.addElement(PdVector.copyNew((PdVector)pgElementSet.getVertexTexture(n)));
                }
                for (n28 = 0; n28 < n15; ++n28) {
                    if (!blArray[n28]) continue;
                    vectorArray[n28].addElement(PdVector.copyNew((PdVector)pgElementSet.getVectorField(n28).getVector(n)));
                }
            }
            if (!pgElementSet.hasTagVertex(n, 14) || n5 != 1) {
                for (n3 = 0; n3 < n5; ++n3) {
                    pgElementSet.setTagVertex(piVector.m_data[n3], 1);
                }
            }
            for (n3 = 0; n3 < n29; ++n3) {
                PiVector piVector20;
                piVectorArray2[piVector11.m_data[n3]].m_data[piVector12.m_data[n3]] = n28 = piVector.m_data[piVector18.m_data[n3]];
                if (piVector13.m_data[2 * n3] != -1) {
                    n4 = piVector13.m_data[2 * n3];
                    piVector20 = pgPolygonSet2.getPolygon(n4 / 2);
                    n2 = piVector20.getSize();
                    if (n4 % 2 == 0) {
                        piVector20.m_data[0] = n28;
                    } else {
                        piVector20.m_data[n2 - 1] = n28;
                    }
                }
                if (piVector13.m_data[2 * n3 + 1] == -1) continue;
                n4 = piVector13.m_data[2 * n3 + 1];
                piVector20 = pgPolygonSet2.getPolygon(n4 / 2);
                n2 = piVector20.getSize();
                if (n4 % 2 == 0) {
                    piVector20.m_data[0] = n28;
                    continue;
                }
                piVector20.m_data[n2 - 1] = n28;
            }
        }
        for (n = 0; n < n13; ++n) {
            if (bl) {
                pgElementSet.setVertexColor(n16 + n, (Color)vector2.elementAt(n));
            }
            if (bl2) {
                pgElementSet.setVertexNormal(n16 + n, (PdVector)vector3.elementAt(n));
            }
            if (!bl3) continue;
            pgElementSet.setVertexTexture(n16 + n, (PdVector)vector4.elementAt(n));
        }
        for (n = 0; n < n15; ++n) {
            if (!blArray[n]) continue;
            pgElementSet.getVectorField(n).setNumVectors(n13 + n16);
            for (n9 = 0; n9 < n13; ++n9) {
                pgElementSet.getVectorField(n).setVector(n16 + n9, (PdVector)vectorArray[n].elementAt(n9));
            }
        }
        pgElementSet.setElements(piVectorArray2);
        pgElementSet.makeNeighbour();
        if (pgElementSet.hasBoundary()) {
            pgElementSet.removeBoundaries();
        }
        PwBoundary.makeBoundary(pgElementSet);
        n16 = pgElementSet.getNumVertices();
        for (n = 0; n < n16; ++n) {
            pgElementSet.clearTagVertex(n, 1);
        }
    }

    public static void closeHoles(PgElementSet pgElementSet) {
        int n;
        int n2;
        int n3;
        PgBndPolygon[] pgBndPolygonArray;
        if (!pgElementSet.checkNeighbour(false)) {
            pgElementSet.makeNeighbour();
        }
        if ((pgBndPolygonArray = pgElementSet.getBoundaries()) == null) {
            PwBoundary.makeBoundary(pgElementSet);
            pgBndPolygonArray = pgElementSet.getBoundaries();
        }
        PgPolygonSet pgPolygonSet = new PgPolygonSet();
        pgPolygonSet.setNumVertices(pgElementSet.getNumVertices());
        pgPolygonSet.setVertices(pgElementSet.getVertices());
        int n4 = pgBndPolygonArray.length;
        if (n4 == 0) {
            return;
        }
        pgPolygonSet.setNumPolygons(n4);
        for (int i = 0; i < n4; ++i) {
            pgPolygonSet.setPolygon(i, pgBndPolygonArray[i].getVertexInd());
        }
        PwCleanMesh.joinPolygons(pgPolygonSet);
        PiVector[] piVectorArray = pgPolygonSet.triangulate();
        int n5 = piVectorArray.length;
        int n6 = pgElementSet.getNumElements();
        pgElementSet.setNumElements(n6 + n5);
        if (pgElementSet.getDimOfElements() != 3) {
            pgElementSet.setDimOfElements(-1);
        }
        for (int i = 0; i < n5; ++i) {
            pgElementSet.setElement(n6 + i, piVectorArray[i]);
        }
        pgElementSet.removeBoundaries();
        PiVector[] piVectorArray2 = new PiVector[n6 + n5];
        for (n3 = 0; n3 < n6; ++n3) {
            piVectorArray2[n3] = pgElementSet.getNeighbour(n3);
        }
        for (n3 = n6; n3 < n6 + n5; ++n3) {
            piVectorArray2[n3] = new PiVector(-1, -1, -1);
        }
        pgElementSet.setNeighbours(piVectorArray2);
        PgEdgeStar[] pgEdgeStarArray = pgElementSet.makeEdgeStars();
        for (n2 = 0; n2 < pgEdgeStarArray.length; ++n2) {
            int[] nArray = pgEdgeStarArray[n2].getElementInd();
            if (nArray == null) continue;
            int n7 = pgEdgeStarArray[n2].getValence();
            if (n7 == 1) {
                pgElementSet.getNeighbour(nArray[0]).setEntry(pgEdgeStarArray[n2].getNeighbourLocInd(0), -1);
                continue;
            }
            if (n7 == 2) {
                pgElementSet.getNeighbour(nArray[0]).setEntry(pgEdgeStarArray[n2].getNeighbourLocInd(0), nArray[1]);
                pgElementSet.getNeighbour(nArray[1]).setEntry(pgEdgeStarArray[n2].getNeighbourLocInd(1), nArray[0]);
                continue;
            }
            if (n7 <= 2) continue;
            n = -1;
            for (int i = 0; i < n7; ++i) {
                if (pgElementSet.getNeighbour((int)nArray[i]).m_data[pgEdgeStarArray[n2].getNeighbourLocInd(i)] != -1) continue;
                if (n == -1) {
                    n = i;
                    continue;
                }
                pgElementSet.getNeighbour(nArray[n]).setEntry(pgEdgeStarArray[n2].getNeighbourLocInd(n), nArray[i]);
                pgElementSet.getNeighbour(nArray[i]).setEntry(pgEdgeStarArray[n2].getNeighbourLocInd(i), nArray[n]);
                n = -1;
            }
            if (n == -1) continue;
            pgElementSet.getNeighbour(nArray[n]).setEntry(pgEdgeStarArray[n2].getNeighbourLocInd(n), -1);
        }
        for (n2 = n6; n2 < n6 + n5; ++n2) {
            pgElementSet.setTagElement(n2, 1);
        }
        n2 = 1;
        while (n2 != 0) {
            n2 = 0;
            block8: for (int i = n6; i < n6 + n5; ++i) {
                if (!pgElementSet.hasTagElement(i, 1)) continue;
                PiVector piVector = pgElementSet.getNeighbour(i);
                for (n = 0; n < 3; ++n) {
                    if ((piVector.m_data[n] == -1 || pgElementSet.hasTagElement(piVector.m_data[n], 1)) && (piVector.m_data[n] >= n6 || piVector.m_data[n] == -1)) continue;
                    PiVector piVector2 = pgElementSet.getElement(i);
                    PiVector piVector3 = pgElementSet.getElement(piVector.m_data[n]);
                    int n8 = piVector3.getSize();
                    if (piVector2.m_data[(n + 1) % 3] == piVector3.m_data[(pgElementSet.getOppVertexLocInd(i, n) + 1) % n8]) {
                        int n9 = piVector2.m_data[2];
                        piVector2.m_data[2] = piVector2.m_data[1];
                        piVector2.m_data[1] = n9;
                        n9 = piVector.m_data[2];
                        piVector.m_data[2] = piVector.m_data[1];
                        piVector.m_data[1] = n9;
                    }
                    pgElementSet.clearTagElement(i, 1);
                    n2 = 1;
                    continue block8;
                }
            }
        }
        if (pgElementSet.hasVertexNormals()) {
            pgElementSet.makeVertexNormals();
        }
        if (pgElementSet.hasElementNormals()) {
            pgElementSet.makeElementNormals();
        }
    }

    public static int getNumNonManifoldEdges(PgElementSet pgElementSet) {
        PgEdgeStar[] pgEdgeStarArray = pgElementSet.makeEdgeStars();
        int n = pgEdgeStarArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (pgEdgeStarArray[i].getValence() <= 2) continue;
            ++n2;
        }
        return n2;
    }

    public static void removeNonManifoldEdges(PgElementSet pgElementSet) {
        int n;
        PiVector piVector;
        int n2;
        int n3;
        int n4;
        Object object;
        int n5;
        int n6;
        int n7;
        PgEdgeStar[] pgEdgeStarArray = pgElementSet.makeEdgeStars();
        int n8 = pgEdgeStarArray.length;
        if (pgElementSet.isEnabledEdges()) {
            n8 = pgElementSet.getNumEdgeStars();
        }
        int n9 = n7 = pgElementSet.getNumVertices();
        boolean bl = pgElementSet.getNeighbours() != null;
        boolean bl2 = pgElementSet.hasElementTextures();
        boolean bl3 = pgElementSet.hasVertexTextures();
        boolean bl4 = pgElementSet.hasVertexColors();
        int n10 = pgElementSet.getNumVectorFields();
        for (n6 = 0; n6 < n8; ++n6) {
            int n11;
            n5 = pgEdgeStarArray[n6].getValence();
            if (n5 < 3) continue;
            object = new int[n5];
            int[] nArray = new int[n5];
            n4 = 0;
            for (n3 = 0; n3 < n5; ++n3) {
                object[n3] = -1;
            }
            for (n3 = 0; n3 < n5; ++n3) {
                if (object[n3] != -1) continue;
                nArray[n3] = -1;
                n2 = pgEdgeStarArray[n6].getElementInd(n3);
                piVector = pgElementSet.getElement(n2);
                int n12 = piVector.getSize();
                for (n = 0; n < n12; ++n) {
                    if ((piVector.m_data[(n + 1) % n12] != pgEdgeStarArray[n6].getVertexInd(0) || piVector.m_data[(n + 2) % n12] != pgEdgeStarArray[n6].getVertexInd(1)) && (piVector.m_data[(n + 1) % n12] != pgEdgeStarArray[n6].getVertexInd(1) || piVector.m_data[(n + 2) % n12] != pgEdgeStarArray[n6].getVertexInd(0))) continue;
                    nArray[n3] = n;
                    break;
                }
                if (bl) {
                    int n13;
                    n = -1;
                    if (nArray[n3] != -1) {
                        n = pgElementSet.getNeighbour((int)n2).m_data[nArray[n3]];
                    } else {
                        PsDebug.warning((String)"RemoveNonManifoldEdges error: Local Index not found!");
                    }
                    int n14 = -1;
                    if (n != -1) {
                        PiVector piVector2 = pgElementSet.getElement(n);
                        n13 = piVector2.getSize();
                        for (n11 = 0; n11 < n13; ++n11) {
                            if ((piVector2.m_data[(n11 + 1) % n13] != pgEdgeStarArray[n6].getVertexInd(0) || piVector2.m_data[(n11 + 2) % n13] != pgEdgeStarArray[n6].getVertexInd(1)) && (piVector2.m_data[(n11 + 1) % n13] != pgEdgeStarArray[n6].getVertexInd(1) || piVector2.m_data[(n11 + 2) % n13] != pgEdgeStarArray[n6].getVertexInd(0))) continue;
                            n14 = n11;
                            break;
                        }
                    }
                    if (n != -1 && n14 != -1 && pgElementSet.getNeighbour((int)n).m_data[n14] == n2) {
                        int n15 = -1;
                        for (n13 = 0; n13 < n5; ++n13) {
                            if (pgEdgeStarArray[n6].getElementInd(n13) != n) continue;
                            n15 = n13;
                        }
                        object[n15] = n7 + n4;
                        nArray[n15] = n14;
                    } else {
                        pgElementSet.getNeighbour((int)n2).m_data[nArray[n3]] = -1;
                    }
                }
                object[n3] = n7 + n4;
                ++n4;
            }
            pgElementSet.setNumVertices(n7 + n4);
            for (n3 = 0; n3 < n4; ++n3) {
                pgElementSet.setVertex(n7 + n3, PdVector.blendNew((double)0.5, (PdVector)pgElementSet.getVertex(pgEdgeStarArray[n6].getVertexInd(0)), (double)0.5, (PdVector)pgElementSet.getVertex(pgEdgeStarArray[n6].getVertexInd(1))));
                if (bl4) {
                    pgElementSet.setVertexColor(n7 + n3, PdColor.blend((double)0.5, (Color)pgElementSet.getVertexColor(pgEdgeStarArray[n6].getVertexInd(0)), (double)0.5, (Color)pgElementSet.getVertexColor(pgEdgeStarArray[n6].getVertexInd(1))));
                }
                if (bl3) {
                    pgElementSet.setVertexTexture(n7 + n3, PdVector.blendNew((double)0.5, (PdVector)pgElementSet.getVertexTexture(pgEdgeStarArray[n6].getVertexInd(0)), (double)0.5, (PdVector)pgElementSet.getVertexTexture(pgEdgeStarArray[n6].getVertexInd(1))));
                }
                for (n2 = 0; n2 < n10; ++n2) {
                    if (pgElementSet.getVectorField(n2).getBasedOn() != 0) continue;
                    pgElementSet.getVectorField(n2).setVector(n7 + n3, PdVector.blendNew((double)0.5, (PdVector)pgElementSet.getVectorField(n2).getVector(pgEdgeStarArray[n6].getVertexInd(0)), (double)0.5, (PdVector)pgElementSet.getVectorField(n2).getVector(pgEdgeStarArray[n6].getVertexInd(1))));
                }
            }
            for (n3 = 0; n3 < n5; ++n3) {
                n2 = pgEdgeStarArray[n6].getElementInd(n3);
                piVector = pgElementSet.getElement(n2);
                PiVector piVector3 = null;
                if (bl) {
                    piVector3 = PiVector.copyNew((PiVector)pgElementSet.getNeighbour(n2));
                }
                n = piVector.getSize();
                PiVector piVector4 = new PiVector(n + 1);
                piVector4.m_data[(nArray[n3] + 2) % (n + 1)] = object[n3];
                for (int i = 0; i < n; ++i) {
                    piVector4.m_data[(nArray[n3] + 3 + i) % (n + 1)] = piVector.m_data[(nArray[n3] + 2 + i) % n];
                }
                pgElementSet.setElement(n2, piVector4);
                if (piVector3 != null) {
                    PiVector piVector5 = new PiVector(n + 1);
                    piVector5.m_data[nArray[n3]] = piVector3.m_data[nArray[n3]];
                    for (int i = 0; i < n; ++i) {
                        piVector5.m_data[(nArray[n3] + 1 + i) % (n + 1)] = piVector3.m_data[(nArray[n3] + i) % n];
                    }
                    pgElementSet.setNeighbour(n2, piVector5);
                }
                if (!bl2) continue;
                PdVector[] pdVectorArray = pgElementSet.getElementTexture(n2);
                PdVector[] pdVectorArray2 = new PdVector[n + 1];
                pdVectorArray2[(nArray[n3] + 2) % (n + 1)] = PdVector.blendNew((double)0.5, (PdVector)pdVectorArray[(nArray[n3] + 1) % n], (double)0.5, (PdVector)pdVectorArray[(nArray[n3] + 2) % n]);
                for (n11 = 0; n11 < n; ++n11) {
                    pdVectorArray2[(nArray[n3] + 3 + n11) % (n + 1)] = pdVectorArray[(nArray[n3] + 2 + n11) % n];
                }
                pgElementSet.setElementTexture(n2, pdVectorArray2);
            }
            n7 += n4;
        }
        if (n7 == n9) {
            return;
        }
        n6 = pgElementSet.getNumElements();
        for (n5 = 0; n5 < n6; ++n5) {
            object = pgElementSet.getElement(n5);
            int n16 = object.getSize();
            n4 = 0;
            n3 = -1;
            for (n2 = 0; n2 < n16; ++n2) {
                if (object.m_data[n2] < n9) continue;
                ++n4;
                n3 = n2;
            }
            if (n4 == 0) continue;
            if (n4 > 1) {
                PwCleanMesh.centralSplit(pgElementSet, n5);
                continue;
            }
            n2 = -1;
            if (bl) {
                n2 = pgElementSet.getNeighbour((int)n5).m_data[(n3 + n16 - 1) % n16];
            }
            if (n2 == -1) continue;
            n4 = 0;
            piVector = pgElementSet.getElement(n2);
            int n17 = piVector.getSize();
            n = -1;
            for (int i = 0; i < n17; ++i) {
                if (piVector.m_data[i] < n9) continue;
                ++n4;
                n = i;
            }
            if (n4 > 1 || object.m_data[(n3 + n16 / 2) % n16] != piVector.m_data[(n + n17 / 2) % n17]) continue;
            PwCleanMesh.centralSplit(pgElementSet, n5);
        }
        for (n5 = 0; n5 < n6; ++n5) {
            object = pgElementSet.getElement(n5);
            int n18 = object.getSize();
            n4 = -1;
            for (n3 = 0; n3 < n18; ++n3) {
                if (object.m_data[n3] < n9) continue;
                n4 = n3;
            }
            if (n4 == -1 || n18 == 3) continue;
            PwCleanMesh.splitElement(pgElementSet, n5, n4, (n4 + n18 / 2) % n18);
        }
        pgElementSet.assureDimOfElements();
    }

    public static int removeNeighbourhoodDegenerations(PgElementSet pgElementSet) {
        return PwCleanMesh.removeNeighbourhoodDegenerations(pgElementSet, true);
    }

    public static int getNumNeighbourhoodDegenerations(PgElementSet pgElementSet) {
        return PwCleanMesh.removeNeighbourhoodDegenerations(pgElementSet, false);
    }

    private static int removeNeighbourhoodDegenerations(PgElementSet pgElementSet, boolean bl) {
        int n;
        if (pgElementSet.getNeighbours() == null) {
            return 0;
        }
        PgVertexStar pgVertexStar = new PgVertexStar();
        int n2 = pgElementSet.getNumVertices();
        int n3 = pgElementSet.getNumElements();
        boolean[] blArray = new boolean[n2];
        boolean[] blArray2 = new boolean[n3];
        for (n = 0; n < n3; ++n) {
            PiVector piVector = pgElementSet.getElement(n);
            int n4 = piVector.getSize();
            for (int i = 0; i < n4; ++i) {
                if (blArray[piVector.m_data[i]]) continue;
                int n5 = piVector.m_data[i];
                pgVertexStar.makeVertexStar(pgElementSet, n5, n);
                int n6 = pgVertexStar.getSize();
                if (n6 == 1) continue;
                PiVector piVector2 = pgVertexStar.getElement();
                for (int j = 0; j < n6 - 1; ++j) {
                    PiVector piVector3 = pgElementSet.getElement(piVector2.m_data[j]);
                    int n7 = piVector3.getSize();
                    for (int k = j + 1; k < n6; ++k) {
                        PiVector piVector4 = pgElementSet.getElement(piVector2.m_data[k]);
                        int n8 = piVector4.getSize();
                        int n9 = 1;
                        if (k - j == 1 || pgVertexStar.isClosed() && j == 0 && k == n6 - 1) {
                            ++n9;
                        }
                        for (int i2 = 0; i2 < n7; ++i2) {
                            for (int i3 = 0; i3 < n8; ++i3) {
                                if (piVector3.m_data[i2] != piVector4.m_data[i3]) continue;
                                --n9;
                            }
                        }
                        if (n9 == 0) continue;
                        blArray2[piVector2.m_data[j]] = true;
                        blArray2[piVector2.m_data[k]] = true;
                    }
                }
                blArray[n5] = true;
            }
        }
        n = 0;
        for (int i = 0; i < n3; ++i) {
            if (!blArray2[i]) continue;
            ++n;
            if (!bl) continue;
            PwCleanMesh.centralSplit(pgElementSet, i);
        }
        if (bl) {
            pgElementSet.assureDimOfElements();
        }
        return n;
    }

    public static void splitElementsByVertexSelection(PgElementSet pgElementSet) {
        if (pgElementSet.getDimOfElements() == 3) {
            return;
        }
        int n = pgElementSet.getNumElements();
        block0: for (int i = 0; i < n; ++i) {
            PiVector piVector = pgElementSet.getElement(i);
            int n2 = piVector.getSize();
            if (n2 < 4) continue;
            boolean bl = false;
            for (int j = 0; j < n2 - 2; ++j) {
                if (!pgElementSet.hasTagVertex(piVector.m_data[j], 1)) continue;
                for (int k = j + 2; k < n2; ++k) {
                    if (!pgElementSet.hasTagVertex(piVector.m_data[k], 1) || j == 0 && k == n2 - 1) continue;
                    PwCleanMesh.splitElement(pgElementSet, i, j, k, false);
                    bl = true;
                    break;
                }
                if (bl) continue block0;
            }
        }
        pgElementSet.assureDimOfElements();
    }

    public static void splitElement(PgElementSet pgElementSet, int n, int n2, int n3) {
        PwCleanMesh.splitElement(pgElementSet, n, n2, n3, false);
    }

    public static void splitElement(PgElementSet pgElementSet, int n, int n2, int n3, boolean bl) {
        int n4;
        int n5;
        int n6 = pgElementSet.getNumElements();
        boolean bl2 = pgElementSet.getNeighbours() != null;
        PiVector piVector = pgElementSet.getElement(n);
        int n7 = piVector.getSize();
        if (n2 < 0 || n2 >= n7 || n3 < 0 || n3 >= n7) {
            PsDebug.warning((String)"Cut index out of range");
            return;
        }
        if (Math.abs(n2 - n3) <= 1 || Math.abs(n2 - n3) == n7 - 1) {
            return;
        }
        PiVector[] piVectorArray = new PiVector[2];
        PiVector piVector2 = null;
        if (bl2) {
            piVector2 = PiVector.copyNew((PiVector)pgElementSet.getNeighbour(n));
        }
        PdVector[] pdVectorArray = null;
        if (pgElementSet.hasElementTextures()) {
            pdVectorArray = PdVector.copyNew((PdVector[])pgElementSet.getElementTexture(n));
        }
        int[] nArray = new int[]{(n3 - n2 + n7) % n7 + 1, (n2 - n3 + n7) % n7 + 1};
        for (n5 = 0; n5 < 2; ++n5) {
            piVectorArray[n5] = new PiVector(nArray[n5]);
        }
        for (n5 = 0; n5 < nArray[0]; ++n5) {
            piVectorArray[0].m_data[n5] = piVector.m_data[(n2 + n5) % n7];
        }
        for (n5 = 0; n5 < nArray[1]; ++n5) {
            piVectorArray[1].m_data[n5] = piVector.m_data[(n3 + n5) % n7];
        }
        pgElementSet.setElement(n, piVectorArray[0]);
        pgElementSet.setNumElements(n6 + 1);
        pgElementSet.setElement(n6, piVectorArray[1]);
        if (piVector2 != null) {
            PiVector[] piVectorArray2 = new PiVector[2];
            for (n4 = 0; n4 < 2; ++n4) {
                piVectorArray2[n4] = new PiVector(nArray[n4]);
            }
            for (n4 = 0; n4 < nArray[0] - 1; ++n4) {
                piVectorArray2[0].m_data[(n4 + nArray[0] - 1) % nArray[0]] = piVector2.m_data[(n2 + (n4 - 1) + n7) % n7];
            }
            piVectorArray2[0].m_data[nArray[0] - 2] = bl ? -1 : n6;
            for (n4 = 0; n4 < nArray[1] - 1; ++n4) {
                piVectorArray2[1].m_data[(n4 + nArray[1] - 1) % nArray[1]] = piVector2.m_data[(n3 + (n4 - 1) + n7) % n7];
                if (piVector2.m_data[(n3 + (n4 - 1) + n7) % n7] == -1) continue;
                PiVector piVector3 = pgElementSet.getNeighbour(piVector2.m_data[(n3 + (n4 - 1) + n7) % n7]);
                PiVector piVector4 = pgElementSet.getElement(piVector2.m_data[(n3 + (n4 - 1) + n7) % n7]);
                int n8 = piVector4.getSize();
                for (int i = 0; i < n8; ++i) {
                    if (piVector3.m_data[i] != n || (piVector4.m_data[(i + 1) % n8] != piVectorArray[1].m_data[n4] || piVector4.m_data[(i + 2) % n8] != piVectorArray[1].m_data[n4 + 1]) && (piVector4.m_data[(i + 1) % n8] != piVectorArray[1].m_data[n4 + 1] || piVector4.m_data[(i + 2) % n8] != piVectorArray[1].m_data[n4])) continue;
                    piVector3.m_data[i] = n6;
                }
            }
            piVectorArray2[1].m_data[nArray[1] - 2] = bl ? -1 : n;
            pgElementSet.setNeighbour(n, piVectorArray2[0]);
            pgElementSet.setNeighbour(n6, piVectorArray2[1]);
        }
        for (int i = 0; i < pgElementSet.getNumVectorFields(); ++i) {
            PgVectorField pgVectorField = pgElementSet.getVectorField(i);
            if (pgVectorField.getBasedOn() != 1) continue;
            pgVectorField.setVector(n6, PdVector.copyNew((PdVector)pgVectorField.getVector(n)));
        }
        if (pgElementSet.hasElementColors()) {
            pgElementSet.setElementColor(n6, pgElementSet.getElementColor(n));
        }
        if (pgElementSet.hasElementBackColors()) {
            pgElementSet.setElementBackColor(n6, pgElementSet.getElementBackColor(n));
        }
        if (pdVectorArray != null) {
            PdVector[][] pdVectorArrayArray = new PdVector[2][];
            for (n4 = 0; n4 < 2; ++n4) {
                pdVectorArrayArray[n4] = new PdVector[nArray[n4]];
            }
            for (n4 = 0; n4 < nArray[0]; ++n4) {
                pdVectorArrayArray[0][n4] = pdVectorArray[(n2 + n4) % n7];
            }
            for (n4 = 0; n4 < nArray[1]; ++n4) {
                pdVectorArrayArray[1][n4] = PdVector.copyNew((PdVector)pdVectorArray[(n3 + n4) % n7]);
            }
            pgElementSet.setElementTexture(n, pdVectorArrayArray[0]);
            pgElementSet.setElementTexture(n6, pdVectorArrayArray[1]);
        }
        if (pgElementSet.hasElementNormals()) {
            pgElementSet.setElementNormal(n6, PdVector.copyNew((PdVector)pgElementSet.getElementNormal(n)));
        }
    }

    public static void centralSplitSelectedElements(PgElementSet pgElementSet) {
        int n = pgElementSet.getNumElements();
        for (int i = 0; i < n; ++i) {
            if (!pgElementSet.hasTagElement(i, 1)) continue;
            PwCleanMesh.centralSplit(pgElementSet, i);
        }
        if (pgElementSet.hasElementNormals()) {
            pgElementSet.makeElementNormals();
        }
        if (pgElementSet.hasVertexNormals()) {
            pgElementSet.makeVertexNormals();
        }
        pgElementSet.assureDimOfElements();
    }

    public static void centralSplit(PgElementSet pgElementSet, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        boolean bl;
        int n10 = pgElementSet.getNumElements();
        if (n > n10 - 1) {
            return;
        }
        int n11 = pgElementSet.getNumVertices();
        PiVector piVector = pgElementSet.getElement(n);
        PiVector piVector2 = null;
        boolean bl2 = bl = pgElementSet.getNeighbours() != null;
        if (bl) {
            piVector2 = PiVector.copyNew((PiVector)pgElementSet.getNeighbour(n));
        }
        PdVector[] pdVectorArray = null;
        if (pgElementSet.hasElementTextures()) {
            pdVectorArray = PdVector.copyNew((PdVector[])pgElementSet.getElementTexture(n));
        }
        if ((n9 = piVector.getSize()) < 3) {
            return;
        }
        PiVector[] piVectorArray = new PiVector[n9];
        PdVector pdVector = PdVector.copyNew((PdVector)pgElementSet.getVertex(piVector.m_data[0]));
        for (n8 = 1; n8 < n9; ++n8) {
            pdVector.add(pgElementSet.getVertex(piVector.m_data[n8]));
        }
        pdVector.multScalar(1.0 / (double)n9);
        pgElementSet.addVertex(pdVector);
        if (pgElementSet.hasVertexColors()) {
            n8 = 0;
            n7 = 0;
            n6 = 0;
            for (n5 = 0; n5 < n9; ++n5) {
                n4 = pgElementSet.getVertexColor(piVector.m_data[n5]).getRGB();
                n8 += n4 >> 16 & 0xFF;
                n7 += n4 >> 8 & 0xFF;
                n6 += n4 & 0xFF;
            }
            pgElementSet.setVertexColor(n11, new Color(n8 / n9, n7 / n9, n6 / n9));
        }
        if (pgElementSet.hasVertexTextures()) {
            PdVector pdVector2 = PdVector.copyNew((PdVector)pgElementSet.getVertexTexture(piVector.m_data[0]));
            for (n7 = 1; n7 < n9; ++n7) {
                pdVector2.add(pgElementSet.getVertexTexture(piVector.m_data[n7]));
            }
            pdVector2.multScalar(1.0 / (double)n9);
            pgElementSet.setVertexTexture(n11, pdVector2);
        }
        for (n3 = 0; n3 < n9; ++n3) {
            piVectorArray[n3] = new PiVector(n11, piVector.m_data[n3], piVector.m_data[(n3 + 1) % n9]);
        }
        pgElementSet.setElement(n, piVectorArray[0]);
        pgElementSet.setNumElements(n10 + n9 - 1);
        for (n3 = 1; n3 < n9; ++n3) {
            pgElementSet.setElement(n10 + n3 - 1, piVectorArray[n3]);
        }
        if (piVector2 != null) {
            PiVector[] piVectorArray2 = PiVector.realloc(null, (int)n9, (int)3);
            piVectorArray2[0].set(piVector2.m_data[n9 - 1], n10, n10 + n9 - 2);
            piVectorArray2[1].set(piVector2.m_data[0], n10 + 1, n);
            piVectorArray2[n9 - 1].set(piVector2.m_data[n9 - 2], n, n10 + n9 - 3);
            for (n7 = 2; n7 < n9 - 1; ++n7) {
                piVectorArray2[n7].set(piVector2.m_data[(n7 + n9 - 1) % n9], n10 + n7, n10 + n7 - 2);
            }
            pgElementSet.setNeighbour(n, piVectorArray2[0]);
            for (n7 = 1; n7 < n9; ++n7) {
                pgElementSet.setNeighbour(n10 + n7 - 1, piVectorArray2[n7]);
                if (piVector2.m_data[(n7 + n9 - 1) % n9] == -1) continue;
                PiVector piVector3 = pgElementSet.getElement(piVector2.m_data[(n7 + n9 - 1) % n9]);
                PiVector piVector4 = pgElementSet.getNeighbour(piVector2.m_data[(n7 + n9 - 1) % n9]);
                n4 = piVector3.getSize();
                for (int i = 0; i < n4; ++i) {
                    if (piVector4.m_data[i] != n || (piVector3.m_data[(i + 1) % n4] != piVectorArray[n7].m_data[1] || piVector3.m_data[(i + 2) % n4] != piVectorArray[n7].m_data[2]) && (piVector3.m_data[(i + 1) % n4] != piVectorArray[n7].m_data[2] || piVector3.m_data[(i + 2) % n4] != piVectorArray[n7].m_data[1])) continue;
                    piVector4.m_data[i] = n10 + n7 - 1;
                }
            }
        }
        for (n2 = 0; n2 < pgElementSet.getNumVectorFields(); ++n2) {
            PgVectorField pgVectorField = pgElementSet.getVectorField(n2);
            if (pgVectorField.getBasedOn() == 0) {
                PdVector pdVector3 = PdVector.copyNew((PdVector)pgVectorField.getVector(piVector.m_data[0]));
                for (n5 = 1; n5 < n9; ++n5) {
                    pdVector3.add(pgVectorField.getVector(piVector.m_data[n5]));
                }
                pdVector3.multScalar(1.0 / (double)n9);
                pgVectorField.setVector(n11, pdVector3);
            }
            if (pgVectorField.getBasedOn() != 1) continue;
            for (n6 = 1; n6 < n9; ++n6) {
                pgVectorField.setVector(n10 + n6 - 1, PdVector.copyNew((PdVector)pgVectorField.getVector(n)));
            }
        }
        if (pgElementSet.hasElementColors()) {
            for (n2 = 1; n2 < n9; ++n2) {
                pgElementSet.setElementColor(n10 + n2 - 1, pgElementSet.getElementColor(n));
            }
        }
        if (pgElementSet.hasElementBackColors()) {
            for (n2 = 1; n2 < n9; ++n2) {
                pgElementSet.setElementBackColor(n10 + n2 - 1, pgElementSet.getElementBackColor(n));
            }
        }
        if (pdVectorArray != null) {
            PdVector[][] pdVectorArray2 = PdVector.alloc((int)n9, (int)3, (int)pgElementSet.getDimOfTextures());
            PdVector pdVector4 = new PdVector(pgElementSet.getDimOfTextures());
            for (n6 = 0; n6 < n9; ++n6) {
                pdVector4.add(pdVectorArray[n6]);
            }
            pdVector4.multScalar(1.0 / (double)n9);
            for (n6 = 0; n6 < n9; ++n6) {
                pdVectorArray2[n6][0].copy(pdVector4);
                pdVectorArray2[n6][1].copy(pdVectorArray[n6]);
                pdVectorArray2[n6][2].copy(pdVectorArray[(n6 + 1) % n9]);
            }
            pgElementSet.setElementTexture(n, pdVectorArray2[0]);
            for (n6 = 1; n6 < n9; ++n6) {
                pgElementSet.setElementTexture(n10 + n6 - 1, pdVectorArray2[n6]);
            }
        }
    }

    public static boolean checkManifold(PgElementSet pgElementSet, boolean bl) {
        int n = PuCleanMesh.getNumDegenerateElements((PgElementSet)pgElementSet);
        if (bl && n > 0) {
            PsDebug.message((String)("Degenerate Elements: " + n));
        }
        int n2 = PwCleanMesh.getNumNonManifoldEdges(pgElementSet);
        if (bl && n2 > 0) {
            PsDebug.message((String)("Non-Manifold edges: " + n2));
        }
        boolean bl2 = pgElementSet.checkNeighbour(false);
        int n3 = 0;
        int n4 = 0;
        if (bl && !bl2) {
            PsDebug.message((String)"Neighbourhood information is not correct.");
        } else {
            n4 = PwCleanMesh.getNumNonManifoldVertices(pgElementSet);
            if (bl && n4 > 0) {
                PsDebug.message((String)("Non-Manifold Vertices: " + n4));
            }
            n3 = PwCleanMesh.getNumNeighbourhoodDegenerations(pgElementSet);
            if (bl && n3 > 0) {
                PsDebug.message((String)("Bad Neighbourhood Situations: " + n3));
            }
        }
        if (bl && bl2 && n + n2 + n4 + n3 == 0) {
            PsDebug.message((String)"Geometry is manifold.");
        }
        return bl2 && n + n2 + n4 + n3 == 0;
    }

    public static boolean removeHangingNodes(PgElementSet pgElementSet) {
        double d = 5.0;
        boolean bl = true;
        return PwCleanMesh.removeHangingNodes(pgElementSet, d, bl);
    }

    public static boolean removeHangingNodes(PgElementSet pgElementSet, double d, boolean bl) {
        double d2 = Math.cos(d / 180.0 * Math.PI);
        if (!pgElementSet.checkNeighbour(false)) {
            pgElementSet.makeNeighbour();
        }
        PgVertexStar pgVertexStar = new PgVertexStar();
        int n = pgElementSet.getNumElements();
        boolean bl2 = false;
        block0: for (int i = 0; i < n; ++i) {
            PiVector piVector = pgElementSet.getNeighbour(i);
            int n2 = piVector.getSize();
            for (int j = 0; j < n2; ++j) {
                int n3;
                int n4;
                int n5;
                int n6;
                int n7;
                int n8;
                int n9;
                PiVector piVector2;
                if (piVector.m_data[j] != -1 && piVector.m_data[(j + 1) % n2] != -1) continue;
                PiVector piVector3 = pgElementSet.getElement(i);
                int n10 = piVector3.m_data[(j + 2) % n2];
                pgVertexStar.makeVertexStar(pgElementSet, n10, i);
                int n11 = pgVertexStar.getSize();
                PiVector piVector4 = pgVertexStar.getLink();
                int n12 = piVector4.getSize();
                if (n12 < 2) continue;
                int n13 = piVector4.m_data[0];
                int n14 = piVector4.m_data[n12 - 1];
                if (n13 == n14) {
                    int n15 = pgVertexStar.getElement().m_data[0];
                    if (n15 == i) {
                        n15 = pgVertexStar.getElement().m_data[n11 - 1];
                    }
                    piVector2 = pgElementSet.getElement(n15);
                    int n16 = piVector2.getSize();
                    int n17 = -1;
                    for (int k = 0; k < n16; ++k) {
                        if ((piVector2.m_data[(k + 1) % n16] != n10 || piVector2.m_data[(k + 2) % n16] != n13) && (piVector2.m_data[(k + 2) % n16] != n10 || piVector2.m_data[(k + 1) % n16] != n13)) continue;
                        n17 = k;
                        break;
                    }
                    pgElementSet.getNeighbour((int)n15).m_data[n17] = i;
                    if (piVector3.m_data[(j + 1) % n2] == n13) {
                        piVector.m_data[j] = n15;
                        continue;
                    }
                    piVector.m_data[(j + 1) % n2] = n15;
                    continue;
                }
                PdVector pdVector = PdVector.subNew((PdVector)pgElementSet.getVertex(n13), (PdVector)pgElementSet.getVertex(n10));
                piVector2 = PdVector.subNew((PdVector)pgElementSet.getVertex(n14), (PdVector)pgElementSet.getVertex(n10));
                double d3 = pdVector.sqrLength();
                double d4 = piVector2.sqrLength();
                pdVector.normalize();
                piVector2.normalize();
                if (!(PdVector.dot((PdVector)pdVector, (PdVector)piVector2) > d2)) continue;
                bl2 = true;
                if (d3 < d4) {
                    n9 = pgVertexStar.getElement().m_data[n11 - 1];
                    n8 = pgVertexStar.getElement().m_data[0];
                    n7 = n13;
                    n6 = n14;
                } else {
                    n9 = pgVertexStar.getElement().m_data[0];
                    n8 = pgVertexStar.getElement().m_data[n11 - 1];
                    n7 = n14;
                    n6 = n13;
                }
                PiVector piVector5 = pgElementSet.getElement(n9);
                PiVector piVector6 = pgElementSet.getNeighbour(n9);
                int n18 = piVector5.getSize();
                PiVector piVector7 = new PiVector(n18 + 1);
                PiVector piVector8 = new PiVector(n18 + 1);
                int n19 = -1;
                for (n5 = 0; n5 < n18; ++n5) {
                    if ((piVector5.m_data[n5 % n18] != n10 || piVector5.m_data[(n5 + 1) % n18] != n6) && (piVector5.m_data[(n5 + 1) % n18] != n10 || piVector5.m_data[n5 % n18] != n6)) continue;
                    n19 = n5;
                    break;
                }
                for (n5 = 0; n5 < n18; ++n5) {
                    if (n5 <= n19) {
                        piVector7.m_data[n5] = piVector5.m_data[n5];
                    } else {
                        piVector7.m_data[n5 + 1] = piVector5.m_data[n5];
                    }
                    if (n5 < n19) {
                        piVector8.m_data[n5] = piVector6.m_data[n5];
                        continue;
                    }
                    piVector8.m_data[n5 + 1] = piVector6.m_data[n5];
                }
                piVector7.m_data[n19 + 1] = n7;
                piVector8.m_data[n19] = piVector6.m_data[(n19 + n18 - 1) % n18];
                if (pgElementSet.hasElementTextures()) {
                    PdVector[] pdVectorArray = new PdVector[n18 + 1];
                    for (n4 = 0; n4 < n18; ++n4) {
                        if (n4 <= n19) {
                            pdVectorArray[n4] = pgElementSet.getElementTexture(n9)[n4];
                            continue;
                        }
                        pdVectorArray[n4 + 1] = pgElementSet.getElementTexture(n9)[n4];
                    }
                    pdVectorArray[n19] = PdVector.blendNew((double)0.5, (PdVector)pgElementSet.getElementTexture(n9)[n19], (double)0.5, (PdVector)pgElementSet.getElementTexture(n9)[(n19 + 1) % n18]);
                    pgElementSet.setElement(n9, piVector7);
                    pgElementSet.setNeighbour(n9, piVector8);
                    pgElementSet.setElementTexture(n9, pdVectorArray);
                } else {
                    pgElementSet.setElement(n9, piVector7);
                    pgElementSet.setNeighbour(n9, piVector8);
                }
                if (bl) {
                    PwCleanMesh.splitElement(pgElementSet, n9, n19 + 1, (n19 + 1 + (n18 + 1) / 2) % (n18 + 1));
                }
                PiVector piVector9 = pgElementSet.getElement(n8);
                n4 = piVector9.getSize();
                for (n3 = 0; n3 < n4; ++n3) {
                    if ((piVector9.m_data[(n3 + 1) % n4] != n10 || piVector9.m_data[(n3 + 2) % n4] != n7) && (piVector9.m_data[(n3 + 2) % n4] != n10 || piVector9.m_data[(n3 + 1) % n4] != n7)) continue;
                    n19 = n3;
                    break;
                }
                piVector5 = pgElementSet.getElement(n9);
                n18 = piVector5.getSize();
                for (n3 = 0; n3 < n18; ++n3) {
                    if ((piVector5.m_data[(n3 + 1) % n18] != n10 || piVector5.m_data[(n3 + 2) % n18] != n7) && (piVector5.m_data[(n3 + 2) % n18] != n10 || piVector5.m_data[(n3 + 1) % n18] != n7)) continue;
                    pgElementSet.getNeighbour((int)n8).m_data[n19] = n9;
                    pgElementSet.getNeighbour((int)n9).m_data[n3] = n8;
                    break;
                }
                if (bl) {
                    piVector5 = pgElementSet.getElement(n);
                    n18 = piVector5.getSize();
                    for (n3 = 0; n3 < n18; ++n3) {
                        if ((piVector5.m_data[(n3 + 1) % n18] != n10 || piVector5.m_data[(n3 + 2) % n18] != n7) && (piVector5.m_data[(n3 + 2) % n18] != n10 || piVector5.m_data[(n3 + 1) % n18] != n7)) continue;
                        pgElementSet.getNeighbour((int)n8).m_data[n19] = n;
                        pgElementSet.getNeighbour((int)n).m_data[n3] = n8;
                        break;
                    }
                }
                --i;
                if (!bl) continue block0;
                ++n;
                continue block0;
            }
        }
        pgElementSet.assureDimOfElements();
        return bl2;
    }

    public static void collapseEdgesBetweenSelectedElements(PgElementSet pgElementSet) {
        if (!pgElementSet.checkNeighbour(false)) {
            PsDebug.warning((String)"Correct neighbourhood is missing");
            return;
        }
        int n = pgElementSet.getNumElements();
        block0: for (int i = 0; i < n; ++i) {
            if (pgElementSet.hasTagElement(i, 2) || !pgElementSet.hasTagElement(i, 1)) continue;
            PiVector piVector = pgElementSet.getNeighbour(i);
            int n2 = piVector.getSize();
            for (int j = 0; j < n2; ++j) {
                int n3 = piVector.m_data[j];
                if (n3 < 0 || !pgElementSet.hasTagElement(n3, 1)) continue;
                PwCleanMesh.collapseEdge(pgElementSet, i, j, false);
                pgElementSet.clearTagElement(i, 1);
                pgElementSet.clearTagElement(n3, 1);
                continue block0;
            }
        }
        pgElementSet.removeMarkedElements();
        pgElementSet.assureDimOfElements();
    }

    public static int collapseEdge(PgElementSet pgElementSet, int n, int n2) {
        return PwCleanMesh.collapseEdge(pgElementSet, n, n2, true);
    }

    protected static int collapseEdge(PgElementSet pgElementSet, int n, int n2, boolean bl) {
        int[] nArray;
        int[] nArray2;
        PiVector[] piVectorArray;
        PiVector[] piVectorArray2;
        int n3;
        PiVector piVector;
        int[] nArray3;
        if (pgElementSet == null) {
            return -1;
        }
        int n4 = pgElementSet.getNumElements();
        if (n < 0 || n >= n4) {
            return -1;
        }
        if (pgElementSet.getNeighbours() == null) {
            return -1;
        }
        PiVector piVector2 = pgElementSet.getNeighbour(n);
        int n5 = -1;
        int n6 = piVector2.m_data[n2];
        if (n6 != -1) {
            n5 = pgElementSet.getOppVertexLocInd(n, n2);
        }
        if (pgElementSet.hasTagVertex((nArray3 = new int[]{piVector.m_data[(n2 + 1) % (n3 = (piVector = pgElementSet.getElement(n)).getSize())], piVector.m_data[(n2 + 2) % n3]})[1], 1) && !pgElementSet.hasTagVertex(nArray3[0], 1)) {
            int n7 = nArray3[0];
            nArray3[0] = nArray3[1];
            nArray3[1] = n7;
        } else if (pgElementSet.hasTagVertex(nArray3[1], 1) || !pgElementSet.hasTagVertex(nArray3[0], 1)) {
            pgElementSet.getVertex(nArray3[0]).add(pgElementSet.getVertex(nArray3[1]));
            pgElementSet.getVertex(nArray3[0]).multScalar(0.5);
        }
        PgVertexStar pgVertexStar = new PgVertexStar();
        pgVertexStar.makeVertexStar(pgElementSet, nArray3[1], n);
        int n8 = pgVertexStar.getSize();
        for (int i = 0; i < n8; ++i) {
            piVector = pgElementSet.getElement(pgVertexStar.getElement().m_data[i]);
            n3 = piVector.getSize();
            for (int j = 0; j < n3; ++j) {
                if (piVector.m_data[j] != nArray3[1]) continue;
                piVector.m_data[j] = nArray3[0];
            }
        }
        if (bl) {
            pgElementSet.setTagVertex(nArray3[1], 2);
        }
        if (n6 == -1) {
            piVectorArray2 = new PiVector[1];
            piVectorArray = new PiVector[1];
            nArray2 = new int[1];
            nArray = new int[1];
        } else {
            piVectorArray2 = new PiVector[2];
            piVectorArray = new PiVector[2];
            nArray2 = new int[2];
            nArray = new int[2];
        }
        piVectorArray2[0] = pgElementSet.getElement(n);
        piVectorArray[0] = pgElementSet.getNeighbour(n);
        nArray2[0] = n;
        nArray[0] = n2;
        if (n6 != -1) {
            piVectorArray2[1] = pgElementSet.getElement(n6);
            piVectorArray[1] = pgElementSet.getNeighbour(n6);
            nArray2[1] = n6;
            nArray[1] = n5;
        }
        for (int i = 0; i < piVectorArray2.length; ++i) {
            PiVector piVector3;
            n3 = piVectorArray2[i].getSize();
            if (n3 == 3) {
                int n9;
                if (piVectorArray[i].m_data[(nArray[i] + 1) % n3] != -1) {
                    piVector3 = pgElementSet.getNeighbour(piVectorArray[i].m_data[(nArray[i] + 1) % n3]);
                    n9 = pgElementSet.getOppVertexLocInd(nArray2[i], (nArray[i] + 1) % n3);
                    piVector3.m_data[n9] = piVectorArray[i].m_data[(nArray[i] + 2) % n3];
                }
                if (piVectorArray[i].m_data[(nArray[i] + 2) % n3] != -1) {
                    piVector3 = pgElementSet.getNeighbour(piVectorArray[i].m_data[(nArray[i] + 2) % n3]);
                    n9 = pgElementSet.getOppVertexLocInd(nArray2[i], (nArray[i] + 2) % n3);
                    piVector3.m_data[n9] = piVectorArray[i].m_data[(nArray[i] + 1) % n3];
                }
                pgElementSet.setTagElement(nArray2[i], 2);
                continue;
            }
            piVector3 = new PiVector(n3 - 1);
            PiVector piVector4 = new PiVector(n3 - 1);
            PdVector[] pdVectorArray = new PdVector[n3 - 1];
            int n10 = 0;
            if (pgElementSet.hasElementTextures()) {
                pgElementSet.getElementTexture(nArray2[i])[(nArray[i] + 2) % n3].add(pgElementSet.getElementTexture(nArray2[i])[(nArray[i] + 1) % n3]);
                pgElementSet.getElementTexture(nArray2[i])[(nArray[i] + 2) % n3].multScalar(0.5);
                pgElementSet.getElementTexture(nArray2[i])[(nArray[i] + 1) % n3].copy(pgElementSet.getElementTexture(nArray2[i])[(nArray[i] + 2) % n3]);
            }
            for (int j = 0; j < n3; ++j) {
                if (piVectorArray2[i].m_data[(j + 1) % n3] == nArray3[0] && piVectorArray2[i].m_data[(j + 2) % n3] == nArray3[0]) continue;
                piVector4.m_data[n10] = piVectorArray[i].m_data[j];
                piVector3.m_data[(n10 + 1) % (n3 - 1)] = piVectorArray2[i].m_data[(j + 1) % n3];
                if (pgElementSet.hasElementTextures()) {
                    pdVectorArray[(n10 + 1) % (n3 - 1)] = pgElementSet.getElementTexture(nArray2[i])[(j + 1) % n3];
                }
                ++n10;
            }
            pgElementSet.setElement(nArray2[i], piVector3);
            pgElementSet.setNeighbour(nArray2[i], piVector4);
            if (pgElementSet.hasElementTextures()) {
                pgElementSet.setElementTexture(nArray2[i], pdVectorArray);
            }
            if (pgElementSet.getDimOfElements() == -1) continue;
            pgElementSet.setDimOfElements(-1);
        }
        if (bl) {
            pgElementSet.removeMarkedElements();
            pgElementSet.removeMarkedVertices();
            if (pgElementSet.getDimOfElements() != 3) {
                pgElementSet.assureDimOfElements();
            }
        }
        return nArray3[0];
    }

    public static void computeElementNormal(PgElementSet pgElementSet, int n) {
        pgElementSet.setElementNormal(n, PwCleanMesh.computeElementNormal(pgElementSet.getElementVertices(n)));
    }

    public static PdVector computeElementNormal(PdVector[] pdVectorArray) {
        if (pdVectorArray == null) {
            return null;
        }
        int n = pdVectorArray.length;
        if (n < 3) {
            return null;
        }
        PdVector pdVector = new PdVector(3);
        pdVector.setConstant(0.0);
        PdVector pdVector2 = new PdVector(3);
        PdVector pdVector3 = new PdVector(3);
        PdVector pdVector4 = new PdVector(3);
        for (int i = 0; i < n; ++i) {
            pdVector2.sub(pdVectorArray[i], pdVectorArray[(i + 1) % n]);
            pdVector3.sub(pdVectorArray[(i + 2) % n], pdVectorArray[(i + 1) % n]);
            pdVector4.cross(pdVector3, pdVector2);
            if (!pdVector4.normalize()) continue;
            pdVector.add(pdVector4);
        }
        pdVector.normalize();
        return pdVector;
    }

    public static void splitCurvedPolygons(PgPolygonSet pgPolygonSet, double d) {
        int n = pgPolygonSet.getNumPolygons();
        PdVector pdVector = new PdVector(pgPolygonSet.getDimOfVertices());
        PdVector pdVector2 = new PdVector(pgPolygonSet.getDimOfVertices());
        int n2 = 0;
        while (n2 < n) {
            PiVector piVector = pgPolygonSet.getPolygon(n2);
            int n3 = piVector.getSize();
            double d2 = 0.0;
            PdVector pdVector3 = pgPolygonSet.getVertex(piVector.m_data[0]);
            PdVector pdVector4 = pgPolygonSet.getVertex(piVector.m_data[n3 - 1]);
            PdVector pdVector5 = PdVector.subNew((PdVector)pdVector4, (PdVector)pdVector3);
            double d3 = pdVector5.length();
            pdVector5.normalize();
            int n4 = 0;
            for (int i = 1; i < n3 - 1; ++i) {
                double d4;
                pdVector.sub(pgPolygonSet.getVertex(piVector.m_data[i]), pdVector3);
                pdVector2.copy(pdVector5);
                double d5 = PdVector.dot((PdVector)pdVector5, (PdVector)pdVector);
                if (d5 < 0.0) {
                    d4 = PdVector.dist((PdVector)pdVector3, (PdVector)pgPolygonSet.getVertex(piVector.m_data[i]));
                } else if (d5 > d3) {
                    d4 = PdVector.dist((PdVector)pdVector4, (PdVector)pgPolygonSet.getVertex(piVector.m_data[i]));
                } else {
                    pdVector2.multScalar(-d5);
                    pdVector.add(pdVector2);
                    d4 = pdVector.length();
                }
                if (!(d4 > d2)) continue;
                d2 = d4;
                n4 = i;
            }
            if (d2 > d * d3) {
                PiVector piVector2 = new PiVector(n3 - n4);
                for (int i = 0; i < n3 - n4; ++i) {
                    piVector2.m_data[i] = piVector.m_data[i + n4];
                }
                pgPolygonSet.addPolygon(piVector2);
                if (pgPolygonSet.hasPolygonColors()) {
                    pgPolygonSet.setPolygonColor(n, pgPolygonSet.getPolygonColor(n2));
                }
                if (pgPolygonSet.hasPolygonNormals()) {
                    pgPolygonSet.setPolygonNormal(n, (PdVector)pgPolygonSet.getPolygonNormal(n2).clone());
                }
                if (pgPolygonSet.hasPolygonSizes()) {
                    pgPolygonSet.setPolygonSize(n, pgPolygonSet.getPolygonSize(n2));
                }
                piVector.setSize(n4 + 1);
                ++n;
                continue;
            }
            ++n2;
        }
    }

    public static void flipEdgesBetweenSelectedElements(PgElementSet pgElementSet) {
        if (!pgElementSet.checkNeighbour(false)) {
            PsDebug.warning((String)"Correct neighbourhood is missing");
            return;
        }
        int n = pgElementSet.getNumElements();
        PgVertexStar pgVertexStar = new PgVertexStar();
        block0: for (int i = 0; i < n; ++i) {
            if (!pgElementSet.hasTagElement(i, 1)) continue;
            PiVector piVector = pgElementSet.getNeighbour(i);
            int n2 = piVector.getSize();
            for (int j = 0; j < n2; ++j) {
                int n3 = piVector.m_data[j];
                if (n3 < 0 || !pgElementSet.hasTagElement(n3, 1)) continue;
                PiVector piVector2 = pgElementSet.getElement(i);
                pgVertexStar.makeVertexStar(pgElementSet, piVector2.m_data[(j + 1) % n2], i);
                if (pgVertexStar.isClosed() && pgVertexStar.getSize() < 4) continue;
                pgVertexStar.makeVertexStar(pgElementSet, piVector2.m_data[(j + 2) % n2], i);
                if (pgVertexStar.isClosed() && pgVertexStar.getSize() < 4 || piVector2.m_data[j] == pgElementSet.getOppVertexInd(i, j)) continue;
                PwCleanMesh.flipEdge(pgElementSet, i, j);
                pgElementSet.clearTagElement(i, 1);
                pgElementSet.clearTagElement(n3, 1);
                continue block0;
            }
        }
    }

    public static void flipEdge(PgElementSet pgElementSet, int n, int n2) {
        int n3;
        PiVector piVector = pgElementSet.getNeighbour(n);
        if (piVector == null) {
            return;
        }
        int n4 = piVector.m_data[n2];
        if (n4 == -1) {
            return;
        }
        PiVector piVector2 = pgElementSet.getElement(n);
        int n5 = piVector2.getSize();
        PiVector piVector3 = pgElementSet.getElement(n4);
        int n6 = piVector3.getSize();
        int n7 = pgElementSet.getOppVertexLocInd(n, n2);
        boolean bl = true;
        if (piVector3.m_data[(n7 + 1) % n6] == piVector2.m_data[(n2 + 1) % n5]) {
            bl = false;
        }
        if ((n3 = piVector.m_data[(n2 + n5 - 1) % n5]) != -1) {
            pgElementSet.getNeighbour(n3).setEntry(pgElementSet.getOppVertexLocInd(n, (n2 + n5 - 1) % n5), n4);
        }
        PiVector piVector4 = pgElementSet.getNeighbour(n4);
        piVector4.m_data[n7] = piVector.m_data[(n2 + n5 - 1) % n5];
        piVector.m_data[(n2 + n5 - 1) % n5] = n4;
        if (bl) {
            piVector2.m_data[(n2 + 1) % n5] = piVector3.m_data[n7];
            n3 = piVector4.m_data[(n7 + n6 - 1) % n6];
            if (n3 != -1) {
                pgElementSet.getNeighbour(n3).setEntry(pgElementSet.getOppVertexLocInd(n4, (n7 + n6 - 1) % n6), n);
            }
            piVector.m_data[n2] = piVector4.m_data[(n7 + n6 - 1) % n6];
            piVector4.m_data[(n7 + n6 - 1) % n6] = n;
            piVector3.m_data[(n7 + 1) % n6] = piVector2.m_data[n2];
        } else {
            piVector2.m_data[(n2 + 1) % n5] = piVector3.m_data[(n7 + 3) % n6];
            n3 = piVector4.m_data[(n7 + 1) % n6];
            if (n3 != -1) {
                pgElementSet.getNeighbour(n3).setEntry(pgElementSet.getOppVertexLocInd(n4, (n7 + 1) % n6), n);
            }
            piVector.m_data[n2] = piVector4.m_data[(n7 + 1) % n6];
            piVector4.m_data[(n7 + 1) % n6] = n;
            piVector3.m_data[(n7 + 2) % n6] = piVector2.m_data[n2];
        }
        if (pgElementSet.hasElementNormals()) {
            PwCleanMesh.computeElementNormal(pgElementSet, n);
            PwCleanMesh.computeElementNormal(pgElementSet, n4);
        }
    }

    public static void mergeSelectedElements(PgElementSet pgElementSet) {
        if (!pgElementSet.checkNeighbour(false)) {
            PsDebug.warning((String)"Correct neighbourhood is missing");
            return;
        }
        int n = pgElementSet.getNumElements();
        PgVertexStar pgVertexStar = new PgVertexStar();
        block0: for (int i = 0; i < n; ++i) {
            if (!pgElementSet.hasTagElement(i, 1)) continue;
            PiVector piVector = pgElementSet.getNeighbour(i);
            int n2 = piVector.getSize();
            for (int j = 0; j < n2; ++j) {
                int n3 = piVector.m_data[j];
                if (n3 < 0 || !pgElementSet.hasTagElement(n3, 1)) continue;
                PiVector piVector2 = pgElementSet.getElement(i);
                pgVertexStar.makeVertexStar(pgElementSet, piVector2.m_data[(j + 1) % n2], i);
                if (pgVertexStar.isClosed() && pgVertexStar.getSize() < 3) continue;
                pgVertexStar.makeVertexStar(pgElementSet, piVector2.m_data[(j + 2) % n2], i);
                if (pgVertexStar.isClosed() && pgVertexStar.getSize() < 3) continue;
                PwCleanMesh.joinElements(pgElementSet, i, j);
                pgElementSet.clearTagElement(i, 1);
                pgElementSet.clearTagElement(n3, 1);
                continue block0;
            }
        }
        pgElementSet.removeMarkedElements();
        pgElementSet.assureDimOfElements();
    }

    public static void joinElements(PgElementSet pgElementSet, int n, int n2) {
        PiVector piVector = pgElementSet.getNeighbour(n);
        if (piVector == null) {
            return;
        }
        int n3 = piVector.m_data[n2];
        if (n3 < 0) {
            return;
        }
        PiVector piVector2 = pgElementSet.getElement(n);
        int n4 = piVector2.getSize();
        int n5 = pgElementSet.getOppVertexLocInd(n, n2);
        boolean bl = true;
        PiVector piVector3 = pgElementSet.getElement(n3);
        int n6 = piVector3.getSize();
        if (piVector2.m_data[(n2 + 1) % n4] == piVector3.m_data[(n5 + 1) % n6]) {
            bl = false;
        }
        int n7 = n4 + n6 - 2;
        PiVector piVector4 = new PiVector(n7);
        PiVector piVector5 = new PiVector(n7);
        for (int i = 0; i < n4 - 1; ++i) {
            piVector4.m_data[i] = piVector2.m_data[(n2 + 2 + i) % n4];
            piVector5.m_data[(i + n7 - 1) % n7] = piVector.m_data[(n2 + 1 + i) % n4];
        }
        PiVector piVector6 = pgElementSet.getNeighbour(n3);
        if (bl) {
            for (int i = 0; i < n6 - 1; ++i) {
                int n8;
                piVector4.m_data[n4 - 1 + i] = piVector3.m_data[(n5 + 2 + i) % n6];
                piVector5.m_data[(n4 - 1 + i + n7 - 1) % n7] = n8 = piVector6.m_data[(n5 + 1 + i) % n6];
                if (n8 <= -1) continue;
                int n9 = pgElementSet.getOppVertexLocInd(n3, (n5 + 1 + i) % n6);
                pgElementSet.getNeighbour(n8).setEntry(n9, n);
            }
        } else {
            for (int i = 0; i < n6 - 1; ++i) {
                int n10;
                piVector4.m_data[n4 - 1 + i] = piVector3.m_data[(n5 + 1 - i + n6) % n6];
                piVector5.m_data[(n4 - 1 + i + n7 - 1) % n7] = n10 = piVector6.m_data[(n5 - 1 - i + n6) % n6];
                if (n10 <= -1) continue;
                int n11 = pgElementSet.getOppVertexLocInd(n3, (n5 - 1 - i + n6) % n6);
                pgElementSet.getNeighbour(n10).setEntry(n11, n);
            }
        }
        pgElementSet.setElement(n, piVector4);
        pgElementSet.setNeighbour(n, piVector5);
        pgElementSet.setTagElement(n3, 2);
    }

    public static void flipOrientationSelectedElements(PgElementSet pgElementSet) {
        int n = pgElementSet.getNumElements();
        for (int i = 0; i < n; ++i) {
            if (!pgElementSet.hasTagElement(i, 1)) continue;
            PwCleanMesh.flipOrientationOfElement(pgElementSet, i);
            pgElementSet.clearTagElement(i, 1);
        }
        if (pgElementSet.hasVertexNormals()) {
            pgElementSet.makeVertexNormals();
        }
    }

    public static void flipOrientationOfElement(PgElementSet pgElementSet, int n) {
        PiVector piVector = pgElementSet.getElement(n);
        piVector.invert();
        PiVector piVector2 = pgElementSet.getNeighbour(n);
        piVector2.invert();
        piVector2.shift(-3);
        int n2 = piVector.getSize();
        if (pgElementSet.isEnabledEdges()) {
            PiVector piVector3 = pgElementSet.getElementEdges()[n];
            PgEdgeStar[] pgEdgeStarArray = pgElementSet.getEdgeStars();
            piVector3.invert();
            piVector3.shift(-3);
            for (int i = 0; i < n2; ++i) {
                int n3;
                int n4;
                PgEdgeStar pgEdgeStar = pgEdgeStarArray[piVector3.m_data[i]];
                for (n4 = 0; n4 < pgEdgeStar.getValence() && pgEdgeStar.getElementInd(n4) != n; ++n4) {
                }
                int n5 = pgEdgeStar.getNeighbourLocInd()[n4];
                pgEdgeStar.getNeighbourLocInd()[n4] = n3 = (2 * n2 - 1 - n5 - 3) % n2;
            }
        }
        if (pgElementSet.hasElementNormals()) {
            pgElementSet.getElementNormal(n).multScalar(-1.0);
        }
        if (pgElementSet.hasElementTextures()) {
            P_Vector.invert((Object[])pgElementSet.getElementTexture(n), (int)n2);
        }
    }

    public static void rotateStarsSelectedVertices(PgElementSet pgElementSet) {
        int n = pgElementSet.getNumElements();
        block0: for (int i = 0; i < n; ++i) {
            PiVector piVector = pgElementSet.getElement(i);
            int n2 = piVector.getSize();
            for (int j = 0; j < n2; ++j) {
                if (!pgElementSet.hasTagVertex(piVector.m_data[j], 1)) continue;
                PwCleanMesh.rotateStar(pgElementSet, piVector.m_data[j], i);
                pgElementSet.clearTagVertex(piVector.m_data[j], 1);
                continue block0;
            }
        }
    }

    public static void rotateStar(PgElementSet pgElementSet, int n, int n2) {
        int n3;
        PiVector piVector;
        int n4;
        PgVertexStar pgVertexStar = new PgVertexStar();
        pgVertexStar.makeVertexStar(pgElementSet, n, n2);
        if (!pgVertexStar.isClosed()) {
            PsDebug.warning((String)"Rotate star is only defined for interior vertices.");
            return;
        }
        int n5 = pgVertexStar.getSize();
        PiVector piVector2 = pgVertexStar.getElement();
        PiVector piVector3 = pgVertexStar.getVertexLocInd();
        int n6 = 0;
        for (int i = 0; i < n5; ++i) {
            n6 += pgElementSet.getElement(piVector2.m_data[i]).getSize() - 2;
        }
        PiVector piVector4 = new PiVector(n6);
        PiVector piVector5 = new PiVector(n6);
        PiVector piVector6 = new PiVector(n6);
        PiVector piVector7 = new PiVector(n6);
        PiVector[] piVectorArray = new PiVector[n5];
        PiVector[] piVectorArray2 = new PiVector[n5];
        int n7 = 0;
        PgVertexStar pgVertexStar2 = new PgVertexStar();
        block1: for (n4 = 0; n4 < n5; ++n4) {
            piVector = pgElementSet.getElement(piVector2.m_data[n4]);
            int n8 = piVector.getSize();
            piVectorArray[n4] = new PiVector(n8);
            piVectorArray2[n4] = new PiVector(n8);
            if (n4 == 0 || piVector.m_data[(piVector3.m_data[n4] + 1) % n8] == piVector7.m_data[n7]) {
                pgVertexStar2.makeVertexStar(pgElementSet, piVector.m_data[(piVector3.m_data[n4] + 1) % n8], piVector2.m_data[n4]);
                if (pgVertexStar2.isClosed() && pgVertexStar2.getSize() < 3) {
                    PsDebug.warning((String)"Rotating star would generate a self-neighbouring element.");
                    return;
                }
                for (n3 = 0; n3 < n8 - 1; ++n3) {
                    piVector7.m_data[n7 % n6] = piVector.m_data[(piVector3.m_data[n4] + 1 + n3) % n8];
                    piVectorArray[n4].m_data[(piVector3.m_data[n4] + 1 + n3) % n8] = n7 % n6;
                    if (n3 == n8 - 2) continue block1;
                    piVector4.m_data[n7] = piVector2.m_data[n4];
                    piVectorArray2[n4].m_data[(piVector3.m_data[n4] + n3) % n8] = n7;
                    piVector5.m_data[n7] = pgElementSet.getNeighbour((int)piVector2.m_data[n4]).m_data[(piVector3.m_data[n4] + n3) % n8];
                    piVector6.m_data[n7] = piVector5.m_data[n7] < 0 ? -1 : pgElementSet.getOppVertexLocInd(piVector2.m_data[n4], (piVector3.m_data[n4] + n3) % n8);
                    ++n7;
                }
                continue;
            }
            pgVertexStar2.makeVertexStar(pgElementSet, piVector.m_data[(piVector3.m_data[n4] + n8 - 1) % n8], piVector2.m_data[n4]);
            if (pgVertexStar2.isClosed() && pgVertexStar2.getSize() < 3) {
                PsDebug.warning((String)"Rotating star would generate a self-neighbouring element.");
                return;
            }
            for (n3 = 0; n3 < n8 - 1; ++n3) {
                piVector7.m_data[n7 % n6] = piVector.m_data[(piVector3.m_data[n4] + n8 - 1 - n3) % n8];
                piVectorArray[n4].m_data[(piVector3.m_data[n4] + n8 - 1 - n3) % n8] = n7 % n6;
                if (n3 == n8 - 2) continue block1;
                piVector4.m_data[n7] = piVector2.m_data[n4];
                piVectorArray2[n4].m_data[(piVector3.m_data[n4] + n8 - 3 - n3) % n8] = n7;
                piVector5.m_data[n7] = pgElementSet.getNeighbour((int)piVector2.m_data[n4]).m_data[(piVector3.m_data[n4] + n8 - 3 - n3) % n8];
                piVector6.m_data[n7] = piVector5.m_data[n7] < 0 ? -1 : pgElementSet.getOppVertexLocInd(piVector2.m_data[n4], (piVector3.m_data[n4] + n8 - 3 - n3) % n8);
                ++n7;
            }
        }
        block4: for (n4 = 0; n4 < n5; ++n4) {
            piVector = pgElementSet.getElement(piVector2.m_data[n4]);
            PiVector piVector8 = pgElementSet.getNeighbour(piVector2.m_data[n4]);
            n3 = piVector.getSize();
            for (int i = 0; i < n3 - 1; ++i) {
                piVector.m_data[(piVector3.m_data[n4] + 1 + i) % n3] = piVector7.m_data[(piVectorArray[n4].m_data[(piVector3.m_data[n4] + 1 + i) % n3] + 1) % n6];
                if (i == n3 - 2) continue block4;
                piVector8.m_data[(piVector3.m_data[n4] + i) % n3] = piVector5.m_data[(piVectorArray2[n4].m_data[(piVector3.m_data[n4] + i) % n3] + 1) % n6];
            }
        }
        for (n4 = 0; n4 < n6; ++n4) {
            if (piVector5.m_data[n4] < 0) continue;
            piVector = pgElementSet.getNeighbour(piVector5.m_data[n4]);
            piVector.m_data[piVector6.m_data[n4]] = piVector4.m_data[(n4 + n6 - 1) % n6];
        }
    }

    public static void removeSelectedVerticesAndFill(PgElementSet pgElementSet) {
        int n = pgElementSet.getNumElements();
        block0: for (int i = 0; i < n; ++i) {
            if (pgElementSet.hasTagElement(i, 2)) continue;
            PiVector piVector = pgElementSet.getElement(i);
            int n2 = piVector.getSize();
            for (int j = 0; j < n2; ++j) {
                if (pgElementSet.hasTagVertex(piVector.m_data[j], 2) || !pgElementSet.hasTagVertex(piVector.m_data[j], 1)) continue;
                PwCleanMesh.removeVertexAndFill(pgElementSet, piVector.m_data[j], i);
                continue block0;
            }
        }
        pgElementSet.removeMarkedElements();
        pgElementSet.removeMarkedVertices();
        pgElementSet.assureDimOfElements();
    }

    public static void removeVertexAndFill(PgElementSet pgElementSet, int n, int n2) {
        PgVertexStar pgVertexStar = new PgVertexStar();
        pgVertexStar.makeVertexStar(pgElementSet, n, n2);
        int n3 = pgVertexStar.getSize();
        int n4 = pgElementSet.getNumElements();
        PiVector piVector = pgVertexStar.getLink();
        int n5 = piVector.getSize();
        PiVector piVector2 = new PiVector(n5);
        if (!pgVertexStar.isClosed()) {
            piVector2.m_data[n5 - 2] = -1;
        }
        for (int i = 0; i < n3; ++i) {
            n2 = pgVertexStar.getElement().m_data[i];
            int n6 = pgVertexStar.getVertexLocInd().m_data[i];
            PiVector piVector3 = pgElementSet.getElement(n2);
            int n7 = piVector3.getSize();
            if (n7 < 4) {
                int n8;
                piVector2.m_data[(i + n5 - 1) % n5] = n8 = pgElementSet.getNeighbour((int)n2).m_data[n6];
                if (n8 != -1) {
                    pgElementSet.getNeighbour((int)n8).m_data[pgElementSet.getOppVertexLocInd((int)n2, (int)n6)] = n4;
                }
                pgElementSet.setTagElement(n2, 2);
                continue;
            }
            pgElementSet.setDimOfElements(-1);
            piVector2.m_data[(i + n5 - 1) % n5] = n2;
            PiVector piVector4 = pgElementSet.getNeighbour(n2);
            PiVector piVector5 = new PiVector(n7 - 1);
            PiVector piVector6 = new PiVector(n7 - 1);
            for (int j = 0; j < n7 - 1; ++j) {
                piVector5.m_data[j] = piVector3.m_data[(n6 + 1 + j) % n7];
                piVector6.m_data[(j + n7 - 2) % (n7 - 1)] = piVector4.m_data[(n6 + j) % n7];
            }
            piVector6.m_data[n7 - 3] = n4;
            pgElementSet.setElement(n2, piVector5);
            pgElementSet.setNeighbour(n2, piVector6);
        }
        pgElementSet.setTagVertex(n, 2);
        pgElementSet.addElement(piVector);
        pgElementSet.setNeighbour(n4, piVector2);
        pgElementSet.assureDimOfElements();
    }

    public static void identifyMarkedVertices(PgElementSet pgElementSet) {
        int n;
        int n2 = pgElementSet.getNumVertices();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (!pgElementSet.hasTagVertex(i, 1)) continue;
            ++n3;
        }
        if (n3 < 2) {
            return;
        }
        int[] nArray = new int[n3];
        n3 = 0;
        for (n = 0; n < n2; ++n) {
            if (!pgElementSet.hasTagVertex(n, 1)) continue;
            nArray[n3] = n;
            if (++n3 == 1) {
                pgElementSet.clearTagVertex(n, 1);
                continue;
            }
            pgElementSet.getVertex(nArray[0]).add(pgElementSet.getVertex(n));
            pgElementSet.setTagVertex(n, 2);
        }
        pgElementSet.getVertex(nArray[0]).multScalar(1.0 / (double)n3);
        n = pgElementSet.getNumElements();
        for (int i = 0; i < n; ++i) {
            PiVector piVector = pgElementSet.getElement(i);
            int n4 = piVector.getSize();
            for (int j = 0; j < n4; ++j) {
                for (int k = 1; k < n3; ++k) {
                    if (piVector.m_data[j] != nArray[k]) continue;
                    piVector.m_data[j] = nArray[0];
                }
            }
        }
        pgElementSet.removeMarkedVertices();
    }

    public static void scrambleElements(PgElementSet pgElementSet) {
        int n = -1;
        PiVector piVector = new PiVector();
        PiVector piVector2 = new PiVector();
        PiVector piVector3 = new PiVector();
        Random random = new Random();
        int n2 = 0;
        int n3 = pgElementSet.getNumElements();
        for (int i = 0; i < n3; ++i) {
            int n4;
            piVector2 = pgElementSet.getElement(i);
            piVector = pgElementSet.getNeighbour(i);
            n2 = piVector2.getSize();
            n = Math.abs(random.nextInt()) % (2 * n2);
            if (n == 0) continue;
            if (n < n2) {
                piVector3.setSize(n2);
                piVector3.copy(piVector2);
                for (n4 = 0; n4 < n2; ++n4) {
                    piVector2.m_data[n4] = piVector3.m_data[(n4 + n) % n2];
                }
                piVector3.copy(piVector);
                for (n4 = 0; n4 < n2; ++n4) {
                    piVector.m_data[n4] = piVector3.m_data[(n4 + n) % n2];
                }
                continue;
            }
            n -= n2;
            piVector3.setSize(n2);
            piVector3.copy(piVector2);
            for (n4 = 0; n4 < n2; ++n4) {
                piVector2.m_data[n2 - 1 - n4] = piVector3.m_data[(n4 + n) % n2];
            }
            piVector3.copy(piVector);
            for (n4 = 0; n4 < n2; ++n4) {
                piVector.m_data[n2 - 1 - n4] = piVector3.m_data[(n4 + n + n2 - 3) % n2];
            }
        }
        pgElementSet.makeElementNormals();
        pgElementSet.makeVertexNormals();
    }

    public static void removeSmallAngles(PgElementSet pgElementSet, double d, boolean bl) {
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"Geometry not triangulated.");
            return;
        }
        int n = pgElementSet.getNumElements();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        block0: for (int i = 0; i < n; ++i) {
            int n2;
            if (pgElementSet.hasTagElement(i, 2)) continue;
            PiVector piVector = pgElementSet.getElement(i);
            double[] dArray = new double[3];
            PdVector.angle((double[])dArray, (PdVector[])new PdVector[]{pdVectorArray[piVector.m_data[0]], pdVectorArray[piVector.m_data[1]], pdVectorArray[piVector.m_data[2]]});
            for (n2 = 0; n2 < 3; ++n2) {
                if (!(dArray[n2] > Math.PI - d)) continue;
                PwCleanMesh.flipEdge(pgElementSet, i, n2);
                continue block0;
            }
            for (n2 = 0; n2 < 3; ++n2) {
                if (!(dArray[n2] < d)) continue;
                PwCleanMesh.collapseEdge(pgElementSet, i, n2, false);
                continue block0;
            }
        }
        if (!bl) {
            return;
        }
        pgElementSet.removeMarkedElements();
        pgElementSet.removeUnusedVertices();
    }

    public static void resamplePolygon(PgPolygon pgPolygon, int n) {
        int n2 = pgPolygon.getNumVertices();
        if (n2 < 2) {
            PsDebug.warning((String)"Polygon is too short for resampling.");
            return;
        }
        boolean bl = pgPolygon.isClosed();
        double d = pgPolygon.getLength();
        PdVector[] pdVectorArray = new PdVector[n];
        double d2 = 0.0;
        double d3 = d;
        int n3 = n;
        if (bl) {
            d3 /= (double)n;
        } else {
            d3 /= (double)(n - 1);
            pdVectorArray[n - 1] = PdVector.copyNew((PdVector)pgPolygon.getVertex(n2 - 1));
            --n3;
        }
        int n4 = 0;
        pdVectorArray[0] = PdVector.copyNew((PdVector)pgPolygon.getVertex(0));
        int n5 = 1;
        double d4 = PdVector.dist((PdVector)pgPolygon.getVertex(1), (PdVector)pgPolygon.getVertex(0));
        while (n5 < n3) {
            if ((double)n5 * d3 > d2 + d4) {
                d2 += d4;
                d4 = PdVector.dist((PdVector)pgPolygon.getVertex((++n4 + 1) % n2), (PdVector)pgPolygon.getVertex(n4));
                continue;
            }
            pdVectorArray[n5] = PdVector.blendNew((double)((d2 + d4 - (double)n5 * d3) / d4), (PdVector)pgPolygon.getVertex(n4), (double)(((double)n5 * d3 - d2) / d4), (PdVector)pgPolygon.getVertex((n4 + 1) % n2));
            ++n5;
        }
        pgPolygon.setNumVertices(n);
        pgPolygon.setVertices(pdVectorArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

