/*
 * Decompiled with CFR 0.152.
 */
package jvx.cellular;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Date;
import java.util.Random;
import jv.anim.PsAnimation;
import jv.geom.PgElementSet;
import jv.object.PsConfig;
import jv.object.PsObject;
import jv.project.PgGeometry;
import jv.project.PvDisplayIf;
import jv.project.PvPickEvent;
import jv.vecmath.PiVector;
import jvx.cellular.PnCellOperator;
import jvx.geom.PwExplode;
import jvx.thirdParty.acmeGui.GuiUtils;
import jvx.thirdParty.acmeGui.OkDialog;

public class PnMinesweeper
extends PnCellOperator
implements KeyListener {
    protected int m_numMines;
    protected int m_numOpen;
    protected PiVector m_minedNeighbours;
    protected boolean m_bShift = false;
    protected boolean[] m_bMines;
    protected Random m_random = new Random();
    protected boolean m_bFirstPick;
    protected boolean m_bExploding;
    protected long m_startTime;
    protected long m_endTime;
    protected String[] m_origElNames;
    protected boolean m_bShowIndices;
    private int m_origDisplayMode;
    protected boolean m_bRunning = false;
    static /* synthetic */ Class class$jvx$cellular$PnMinesweeper;

    public PnMinesweeper() {
        if (this.getClass() == (class$jvx$cellular$PnMinesweeper == null ? (class$jvx$cellular$PnMinesweeper = PnMinesweeper.class$("jvx.cellular.PnMinesweeper")) : class$jvx$cellular$PnMinesweeper)) {
            this.init();
        }
    }

    public PnMinesweeper(PgElementSet pgElementSet) {
        this();
        this.setGeometry(pgElementSet);
        this.reset();
    }

    public void init() {
        super.init();
        this.m_bFirstPick = true;
        this.m_bExploding = false;
    }

    public boolean update(Object object) {
        if (object == this.m_geom) {
            if (this.isUpdateSender()) {
                return true;
            }
            if (this.isModal()) {
                return true;
            }
            this.setGeometry(this.m_geom);
            this.reset();
            return true;
        }
        return super.update(object);
    }

    public void setGeometry(PgElementSet pgElementSet) {
        super.setGeometry(pgElementSet);
        this.m_bShowIndices = this.m_geom.isShowingIndices();
        int n = this.m_geom.getNumElements();
        this.m_origElNames = new String[n];
        for (int i = 0; i < n; ++i) {
            this.m_origElNames[i] = this.m_geom.getElement(i).getName();
        }
        this.setOutputType(1);
    }

    public void close() {
        this.m_display.removeKeyListener((KeyListener)this);
        this.m_display.setMajorMode(this.m_origDisplayMode);
        super.close();
    }

    public void reset() {
        int n;
        super.reset();
        if (this.m_geom == null) {
            return;
        }
        this.m_geom.assureElementColors();
        this.m_geom.showElementColors(true);
        this.m_geom.showIndices(true);
        int n2 = this.m_geom.getNumElements();
        for (n = 0; n < n2; ++n) {
            this.m_geom.getElement(n).setName("");
        }
        this.m_bMines = new boolean[n2];
        for (n = 0; n < n2; ++n) {
            this.m_bMines[n] = false;
        }
        this.m_numStates = 3;
        this.m_color = new Color[3];
        this.m_color[0] = new Color(255, 255, 255);
        this.m_color[1] = new Color(255, 0, 0);
        this.m_color[2] = new Color(107, 157, 255);
        this.setColors();
        this.update(this);
    }

    public void setExplodeDisplay(PvDisplayIf pvDisplayIf) {
        this.setDisplay(pvDisplayIf);
    }

    public void setDisplay(PvDisplayIf pvDisplayIf) {
        super.setDisplay(pvDisplayIf);
        pvDisplayIf.addKeyListener((KeyListener)this);
        this.m_origDisplayMode = pvDisplayIf.getMajorMode();
        pvDisplayIf.setMajorMode(6);
    }

    public void setMines(int n) {
        int n2;
        int n3 = 0;
        int n4 = this.m_geom.getNumElements();
        this.m_numMines = n4 >= 5 ? n4 / 5 : (n4 > 1 ? 1 : 0);
        this.m_numOpen = 0;
        int n5 = this.m_infCell[n].getSize();
        while (n3 < this.m_numMines) {
            n2 = Math.abs(this.m_random.nextInt()) % n4;
            boolean bl = this.m_infCell[n].contains(n2);
            if (n5 + n3 >= n4 && n2 != n) {
                bl = false;
            }
            if (this.m_bMines[n2] || bl) continue;
            this.m_bMines[n2] = true;
            ++n3;
        }
        this.m_minedNeighbours = new PiVector(n4);
        for (n2 = 0; n2 < n4; ++n2) {
            this.m_minedNeighbours.m_data[n2] = 0;
            n5 = this.m_infCell[n2].getSize();
            for (int i = 1; i < n5; ++i) {
                int n6 = this.m_infCell[n2].m_data[i];
                if (n6 <= -1 || !this.m_bMines[n6]) continue;
                int n7 = n2;
                this.m_minedNeighbours.m_data[n7] = this.m_minedNeighbours.m_data[n7] + 1;
            }
        }
        this.m_startTime = new Date().getTime();
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (16 == keyEvent.getKeyCode()) {
            this.m_bShift = true;
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (16 == keyEvent.getKeyCode()) {
            this.m_bShift = false;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void pickInitial(PvPickEvent pvPickEvent) {
        int n;
        if (this.m_bExploding) {
            return;
        }
        int n2 = pvPickEvent.getElementInd();
        if (n2 != -1) {
            if (this.m_bShift) {
                if (!this.m_bFirstPick) {
                    if (this.m_markI.m_data[n2] == 0) {
                        this.markElement(n2, 1);
                        this.setColors();
                        this.update(this);
                    } else if (this.m_markI.m_data[n2] == 1) {
                        this.markElement(n2, 0);
                        this.setColors();
                        this.update(this);
                    }
                }
            } else if (this.m_markI.m_data[n2] == 0) {
                if (!this.m_bMines[n2]) {
                    this.markElement(n2, 2);
                    if (this.m_bFirstPick) {
                        this.setMines(n2);
                        this.m_bFirstPick = false;
                    }
                    ++this.m_numOpen;
                    this.m_geom.getElement(n2).setName(String.valueOf(this.m_minedNeighbours.m_data[n2]));
                    if (this.m_minedNeighbours.m_data[n2] == 0) {
                        this.openNeighbours(n2);
                    }
                    this.setColors();
                    this.update(this);
                } else {
                    this.explode();
                }
            } else if (this.m_markI.m_data[n2] == 2) {
                n = 0;
                boolean bl = false;
                for (int i = 1; i < this.m_infCell[n2].getSize(); ++i) {
                    boolean bl2 = false;
                    if (this.m_infCell[n2].m_data[i] <= -1) continue;
                    if (this.m_markI.m_data[this.m_infCell[n2].m_data[i]] == 1) {
                        ++n;
                        bl2 = true;
                    }
                    if (!this.m_bMines[this.m_infCell[n2].m_data[i]] || bl2) continue;
                    bl = true;
                }
                if (n == this.m_minedNeighbours.m_data[n2]) {
                    if (!bl) {
                        this.openNeighbours(n2);
                    } else {
                        this.explode();
                    }
                }
                this.setColors();
                this.update(this);
            }
        }
        if (this.m_numOpen + this.m_numMines == this.m_geom.getNumElements()) {
            this.m_endTime = new Date().getTime();
            n = (int)((this.m_endTime - this.m_startTime) / 1000L);
            Frame frame = PsConfig.getFrame();
            OkDialog okDialog = new OkDialog(frame, GuiUtils.noticeIcon(frame), PsConfig.getMessage((int)58019) + " " + this.m_numMines + " " + PsConfig.getMessage((int)58020) + " " + this.m_geom.getNumElements() + " " + PsConfig.getMessage((int)58021) + " " + n + " " + PsConfig.getMessage((int)58022));
            ((Component)okDialog).setVisible(true);
            okDialog.toFront();
            this.reset();
        }
    }

    protected void openNeighbours(int n) {
        int n2 = this.m_infCell[n].getSize();
        for (int i = 1; i < n2; ++i) {
            if (this.m_infCell[n].m_data[i] <= -1 || this.m_markI.m_data[this.m_infCell[n].m_data[i]] != 0) continue;
            this.markElement(this.m_infCell[n].m_data[i], 2);
            this.m_geom.getElement(this.m_infCell[n].m_data[i]).setName(String.valueOf(this.m_minedNeighbours.m_data[this.m_infCell[n].m_data[i]]));
            ++this.m_numOpen;
            if (this.m_minedNeighbours.m_data[this.m_infCell[n].m_data[i]] != 0) continue;
            this.openNeighbours(this.m_infCell[n].m_data[i]);
        }
    }

    protected void explode() {
        if (this.m_bRunning) {
            return;
        }
        Thread thread = new Thread((Runnable)this, "JavaView: Explode");
        this.m_bRunning = true;
        thread.start();
    }

    public void run() {
        PwExplode pwExplode = new PwExplode();
        pwExplode.setGeometry((PgGeometry)this.m_geom);
        pwExplode.setDisplay(this.getDisplay());
        pwExplode.reset();
        PsAnimation psAnimation = pwExplode.getAnimation();
        psAnimation.setModal(true);
        this.m_bExploding = true;
        psAnimation.start();
        this.m_bExploding = false;
        this.m_geom.copy((PsObject)this.m_geomSave);
        this.reset();
        this.m_bRunning = false;
    }

    public void restoreColors() {
        super.restoreColors();
        int n = this.m_geom.getNumElements();
        if (n == this.m_origElNames.length) {
            for (int i = 0; i < n; ++i) {
                this.m_geom.getElement(i).setName(this.m_origElNames[i]);
            }
        }
        this.m_geom.showIndices(this.m_bShowIndices);
    }

    public void start() {
    }

    public void stop() {
        this.m_bRunning = false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

