/*
 * Decompiled with CFR 0.152.
 */
package vgp.vector.translation;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.geom.PgVectorField;
import jv.loader.PjImportModel;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvPickEvent;
import jv.vecmath.PdBary;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgPolygonOnElementSet;
import jvx.geom.PwBary;
import jvx.geom.PwGeodesic;

public class PjTranslation
extends PjProject
implements ActionListener {
    protected PjImportModel m_import;
    protected String m_defFileName = "models/primitive/Cube.byu";
    protected String m_fileName;
    protected PgElementSet m_geom;
    protected PgPolygonOnElementSet m_poly;
    protected PgPolygonOnElementSet m_addPoly;
    protected PgPointSet m_normalBase;
    protected PgVectorField m_normalVec;
    protected PuDouble m_position;
    protected PuDouble m_angle;
    protected boolean m_bShowBackside;
    protected boolean m_bShowField;
    static /* synthetic */ Class class$vgp$vector$translation$PjTranslation;

    public PjTranslation() {
        super("Parallel Translation");
        this.setFileName(PsConfig.getCodeBase() + this.m_defFileName);
        this.m_import = new PjImportModel();
        this.m_import.setTypeOfInfoPanel(1);
        this.m_import.addActionListener((ActionListener)this);
        this.m_geom = new PgElementSet(3);
        this.m_geom.setDimOfElements(3);
        this.m_geom.computeTorus(15, 15, 2.0, 1.0);
        this.m_geom.setName("Torus");
        this.m_poly = new PgPolygonOnElementSet(this.m_geom);
        this.m_poly.setName("Polygon on Surface");
        this.m_addPoly = new PgPolygonOnElementSet(this.m_geom);
        this.m_normalBase = new PgPointSet(3);
        this.m_normalBase.setName("Normal Vector");
        this.m_normalVec = new PgVectorField(3);
        this.m_normalVec.setGeometry(this.m_normalBase);
        this.m_normalBase.addVectorField(this.m_normalVec);
        this.m_position = new PuDouble("Position", (PsUpdateIf)this);
        this.m_angle = new PuDouble("Angle", (PsUpdateIf)this);
        if (this.getClass() == (class$vgp$vector$translation$PjTranslation == null ? (class$vgp$vector$translation$PjTranslation = PjTranslation.class$("vgp.vector.translation.PjTranslation")) : class$vgp$vector$translation$PjTranslation)) {
            this.init();
        }
    }

    public void init() {
        this.m_bShowBackside = false;
        this.m_bShowField = false;
        this.m_geom.showBackface(this.m_bShowBackside);
        this.m_geom.showElements(this.m_bShowField);
        this.m_poly.setNumVertices(0);
        this.m_poly.update((Object)this.m_poly);
        this.m_normalBase.setNumVertices(0);
        this.m_normalBase.update((Object)this.m_normalBase);
        this.m_addPoly.setNumVertices(0);
        this.m_position.setDefBounds(0.0, 10.0, 0.1, 1.0);
        this.m_position.setDefValue(0.0);
        this.m_position.init();
        this.m_angle.setDefBounds(-180.0, 180.0, 1.0, 10.0);
        this.m_angle.setDefValue(0.0);
        this.m_angle.init();
    }

    public void reset() {
        this.init();
    }

    public void start() {
        super.start();
        this.load();
        this.addGeometry((PgGeometryIf)this.m_geom);
        this.addGeometry((PgGeometryIf)this.m_poly);
        this.addGeometry((PgGeometryIf)this.m_normalBase);
        this.selectGeometry((PgGeometryIf)this.m_geom);
        this.getDisplay().setMajorMode(6);
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public void setFileName(String string) {
        if (string == null) {
            return;
        }
        this.m_fileName = string;
        this.m_defFileName = string;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_import) {
            PgGeometryIf pgGeometryIf = this.m_import.getGeometry(0);
            if (pgGeometryIf == null || !(pgGeometryIf instanceof PgElementSet)) {
                PsDebug.warning((String)"missing geometry, or not of type PgElementSet");
                return;
            }
            this.setGeometry((PgElementSet)pgGeometryIf);
        }
    }

    public boolean load() {
        boolean bl = this.m_import.load(this.m_fileName);
        if (!bl) {
            return false;
        }
        PgGeometryIf pgGeometryIf = this.m_import.getGeometry(0);
        if (pgGeometryIf == null || !(pgGeometryIf instanceof PgElementSet)) {
            PsDebug.warning((String)"missing geometry, or not of type PgElementSet");
            return false;
        }
        this.setGeometry((PgElementSet)pgGeometryIf);
        return true;
    }

    public void setGeometry(PgElementSet pgElementSet) {
        this.m_geom.copy((PsObject)pgElementSet);
        this.m_geom.setName(pgElementSet.getName());
        if (this.m_geom.getDimOfElements() != 3) {
            PgElementSet.triangulate((PgElementSet)this.m_geom);
        }
        if (!this.m_geom.hasElementNormals()) {
            this.m_geom.makeElementNormals();
        }
        this.m_geom.showBackface(this.m_bShowBackside);
        this.m_geom.showElements(this.m_bShowField);
        this.m_geom.update((Object)this.m_geom);
        this.fitDisplays();
        this.reset();
    }

    public boolean update(Object object) {
        if (object == this) {
            return super.update((Object)this);
        }
        if (object == this.m_position || object == this.m_angle) {
            if (this.m_poly.getNumVertices() == 0) {
                return true;
            }
            PdBary pdBary = new PdBary(3);
            PdBaryDir pdBaryDir = new PdBaryDir(3);
            PdBaryDir pdBaryDir2 = new PdBaryDir(3);
            PwBary.rotateInElement((PgElementSet)this.m_geom, (int)this.m_poly.getVertexElemInd(0), (PdBaryDir)new PdBaryDir(0.2, -0.2, 0.0), (double)(this.m_angle.getValue() / 180.0 * Math.PI), (PdBaryDir)pdBaryDir2, (boolean)false);
            int n = PjTranslation.translate(this.m_poly, this.m_position.getValue(), pdBaryDir2, pdBary, pdBaryDir);
            PiVector piVector = this.m_geom.getElement(n);
            PdVector[] pdVectorArray = this.m_geom.getVertices();
            PdVector pdVector = pdBary.getVertex(null, pdVectorArray[piVector.getEntry(0)], pdVectorArray[piVector.getEntry(1)], pdVectorArray[piVector.getEntry(2)]);
            this.m_normalBase.setNumVertices(1);
            this.m_normalBase.setVertex(0, pdVector);
            PdVector pdVector2 = new PdVector(3);
            PdBaryDir.getVector((PdVector)pdVector2, (PdBaryDir)pdBaryDir, (PdVector)pdVectorArray[piVector.getEntry(0)], (PdVector)pdVectorArray[piVector.getEntry(1)], (PdVector)pdVectorArray[piVector.getEntry(2)]);
            this.m_normalVec.setVector(0, pdVector2);
            this.m_normalVec.update((Object)this.m_normalVec);
            return super.update(null);
        }
        return super.update(object);
    }

    public void dragInitial(PvPickEvent pvPickEvent) {
        if (pvPickEvent.getGeometry() != this.m_geom || pvPickEvent.getElementInd() == -1) {
            return;
        }
        int n = this.m_poly.getNumVertices();
        this.m_addPoly = PwGeodesic.getShortest((PgElementSet)this.m_geom, (PdBary)this.m_poly.getVertexBary(n - 1), (int)this.m_poly.getVertexElemInd(n - 1), (PdBary)pvPickEvent.getBary(), (int)pvPickEvent.getElementInd(), null, (PgPolygonOnElementSet)this.m_addPoly);
        if (this.m_addPoly == null || this.m_addPoly.getNumVertices() == 0) {
            return;
        }
        if (n > 0 && n + 10 > this.m_poly.getMaxNumVertices()) {
            this.m_poly.setMaxNumVertices(2 * n);
        }
        this.m_poly.merge((PgGeometryIf)this.m_addPoly);
        this.m_poly.update((Object)this.m_poly);
        this.m_position.setBounds(0.0, this.m_poly.getLength(), 0.01, 0.1);
        this.m_position.update((Object)this.m_position);
    }

    public void pickInitial(PvPickEvent pvPickEvent) {
        if (pvPickEvent.getGeometry() != this.m_geom || pvPickEvent.getElementInd() == -1) {
            return;
        }
        if (this.m_poly.getNumVertices() == 0) {
            this.m_poly.setNumVertices(1);
            this.m_poly.setVertexBary(0, pvPickEvent.getElementInd(), pvPickEvent.getBary());
            this.m_poly.update((Object)this.m_poly);
        } else {
            this.dragInitial(pvPickEvent);
        }
    }

    public static int translate(PgPolygonOnElementSet pgPolygonOnElementSet, double d, PdBaryDir pdBaryDir, PdBary pdBary, PdBaryDir pdBaryDir2) {
        double d2 = pgPolygonOnElementSet.getLength();
        if (d < 0.0) {
            d = 0.0;
        } else if (d > d2) {
            d = d2;
        }
        if (d < 1.0E-9) {
            pdBaryDir2.copy(pdBaryDir);
            pdBary.copy(pgPolygonOnElementSet.getVertexBary(0));
            return pgPolygonOnElementSet.getVertexElemInd(0);
        }
        PgPolygon pgPolygon = new PgPolygon(3);
        PgElementSet pgElementSet = pgPolygonOnElementSet.getGeometry();
        int n = pgPolygonOnElementSet.getNumVertices();
        int n2 = 0;
        do {
            pgPolygonOnElementSet.getPolygon(pgPolygon);
            pgPolygon.setNumVertices(++n2 + 1);
        } while (pgPolygon.getLength() + 1.0E-10 < d && n2 + 1 < n);
        int n3 = pgPolygonOnElementSet.getVertexElemInd(--n2);
        PdBary pdBary2 = new PdBary(3);
        pdBary2.copy(pgPolygonOnElementSet.getVertexBary(n2 + 1));
        int n4 = pgPolygonOnElementSet.getVertexElemInd(n2 + 1);
        PdBaryDir pdBaryDir3 = PjTranslation.getDiff(pgElementSet, pgPolygonOnElementSet.getVertexBary(n2), n3, pdBary2, n4);
        double d3 = PwBary.norm((PgElementSet)pgElementSet, (int)n3, (PdBaryDir)pdBaryDir3, (boolean)false);
        pdBaryDir3.multScalar(1.0 / d3);
        pdBaryDir3.multScalar(d3 - (pgPolygon.getLength() - d));
        for (int i = 0; i < 3; ++i) {
            pdBary.setEntry(i, pdBaryDir3.m_data[i] + pgPolygonOnElementSet.getVertexBary(n2).getEntry(i));
        }
        PdBaryDir pdBaryDir4 = new PdBaryDir(3);
        int n5 = 0;
        do {
            pdBaryDir4.copy(PjTranslation.getDiff(pgElementSet, pgPolygonOnElementSet.getVertexBary(n5), pgPolygonOnElementSet.getVertexElemInd(n5), pgPolygonOnElementSet.getVertexBary(n5 + 1), pgPolygonOnElementSet.getVertexElemInd(n5 + 1)));
        } while (PwBary.norm((PgElementSet)pgElementSet, (int)pgPolygonOnElementSet.getVertexElemInd(++n5 - 1), (PdBaryDir)pdBaryDir4, (boolean)false) < 1.0000000000000001E-11);
        double d4 = PwBary.getOrientedAngle((PgElementSet)pgElementSet, (int)pgPolygonOnElementSet.getVertexElemInd(0), (PdBaryDir)pdBaryDir4, (PdBaryDir)pdBaryDir, (boolean)false);
        PdBaryDir pdBaryDir5 = new PdBaryDir(3);
        PdBary[] pdBaryArray = pgPolygonOnElementSet.getVertexBary();
        for (int i = 1; i <= n2; ++i) {
            double d5;
            PdBary pdBary3 = pdBaryArray[i];
            pdBaryDir3.copy(PjTranslation.getDiff(pgElementSet, pdBaryArray[i], pgPolygonOnElementSet.getVertexElemInd(i), pdBaryArray[i + 1], pgPolygonOnElementSet.getVertexElemInd(i + 1)));
            if (PwBary.norm((PgElementSet)pgElementSet, (int)pgPolygonOnElementSet.getVertexElemInd(i), (PdBaryDir)pdBaryDir3, (boolean)false) < 1.0000000000000001E-11) continue;
            int n6 = PwBary.liesOnEdge((PdBary)pdBary3);
            if (n6 != -1) {
                pdBaryDir5 = PjTranslation.getPositiveEdge(pdBaryDir5, n6);
                d5 = PwBary.getOrientedAngle((PgElementSet)pgElementSet, (int)pgPolygonOnElementSet.getVertexElemInd(i), (PdBaryDir)pdBaryDir5, (PdBaryDir)pdBaryDir3, (boolean)false);
                pdBaryDir5 = PjTranslation.getPositiveEdge(pdBaryDir5, pgElementSet.getOppVertexLocInd(pgPolygonOnElementSet.getVertexElemInd(i), n6));
                double d6 = PwBary.getOrientedAngle((PgElementSet)pgElementSet, (int)pgPolygonOnElementSet.getVertexElemInd(i - 1), (PdBaryDir)pdBaryDir4, (PdBaryDir)pdBaryDir5, (boolean)false);
                d4 += d5 + d6 - Math.PI;
            } else {
                n6 = PwBary.liesOnVertex((PdBary)pdBary3);
                if (n6 == -1) {
                    d5 = PwBary.getOrientedAngle((PgElementSet)pgElementSet, (int)pgPolygonOnElementSet.getVertexElemInd(i), (PdBaryDir)pdBaryDir3, (PdBaryDir)pdBaryDir4, (boolean)false);
                    d4 += d5;
                }
            }
            pdBaryDir4.copy(pdBaryDir3);
        }
        PwBary.rotateInElement((PgElementSet)pgElementSet, (int)n3, (PdBaryDir)pdBaryDir3, (double)d4, (PdBaryDir)pdBaryDir2, (boolean)false);
        pdBaryDir2.multScalar(PwBary.norm((PgElementSet)pgElementSet, (int)pgPolygonOnElementSet.getVertexElemInd(0), (PdBaryDir)pdBaryDir, (boolean)false) / PwBary.norm((PgElementSet)pgElementSet, (int)n3, (PdBaryDir)pdBaryDir2, (boolean)false));
        return n3;
    }

    private static PdBaryDir getDiff(PgElementSet pgElementSet, PdBary pdBary, int n, PdBary pdBary2, int n2) {
        int n3;
        PdBary pdBary3 = new PdBary(3);
        int n4 = PwBary.liesOnEdge((PdBary)pdBary2);
        if (n4 != -1) {
            n3 = pgElementSet.getOppVertexLocInd(n2, n4);
            pdBary3.setEntry(n3, pdBary2.getEntry(n4));
            pdBary3.setEntry((n3 + 1) % 3, pdBary2.getEntry((n4 + 2) % 3));
            pdBary3.setEntry((n3 + 2) % 3, pdBary2.getEntry((n4 + 1) % 3));
            pdBary3.setElementInd(pdBary.getElementInd());
        } else {
            n4 = PwBary.liesOnVertex((PdBary)pdBary2);
            if (n4 != -1) {
                n3 = pgElementSet.getElement(n2).getEntry(n4);
                int n5 = 0;
                for (n5 = 0; n5 < 3 && pgElementSet.getElement(n).getEntry(n5) != n3; ++n5) {
                }
                for (int i = 0; i < 3; ++i) {
                    pdBary3.setEntry(i, 0.0);
                }
                pdBary3.setEntry(n5, 1.0);
                pdBary3.setElementInd(pdBary.getElementInd());
            } else {
                pdBary3.copy(pdBary2);
            }
        }
        PdBaryDir pdBaryDir = new PdBaryDir(3);
        pdBaryDir.sub(pdBary3, pdBary);
        return pdBaryDir;
    }

    private static PdBaryDir getPositiveEdge(PdBaryDir pdBaryDir, int n) {
        if (pdBaryDir == null) {
            pdBaryDir = new PdBaryDir(3);
        }
        pdBaryDir.m_data[n] = 0.0;
        pdBaryDir.m_data[(n + 1) % 3] = -1.0;
        pdBaryDir.m_data[(n + 2) % 3] = 1.0;
        return pdBaryDir;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

