/*
 * Decompiled with CFR 0.152.
 */
package vgp.vector.rungeKutta;

import java.awt.Button;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.MemoryImageSource;
import java.util.Date;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgTexture;
import jv.geom.PgVectorField;
import jv.loader.PjImportModel;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvPickEvent;
import jv.vecmath.PdBary;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgPolygonOnElementSet;
import jvx.geom.PwBary;
import jvx.numeric.PnGeodesicRK;
import jvx.numeric.PnLIC;
import jvx.numeric.PnTranslationRK;
import jvx.numeric.PnVertexRK;

public class PjRungeKutta
extends PjProject
implements Runnable,
ActionListener {
    public static final int PROJECTION = 1;
    public static final int GEODESIC = 2;
    public static final int GEODESIC2 = 3;
    public static final int GEODESIC3 = 4;
    protected int m_method;
    private static String m_defFileName = "models/byu/Brezel_480.byu";
    protected String m_fileName;
    protected PjImportModel m_import;
    protected PgElementSet m_geom;
    protected PgPolygonOnElementSet m_poly;
    protected PuDouble m_length;
    protected PuInteger m_discr;
    protected PdBaryDir[][] m_altvec;
    protected PuInteger m_LICSize;
    protected PdBaryDir[] m_origvec;
    protected int[] m_origelem;
    protected int[] m_origlocvertind;
    protected int m_elemInd;
    protected PdBary m_bary;
    protected PgVectorField m_vec;
    protected boolean m_bFast;
    protected PnGeodesicRK m_ode;
    protected double m_time;
    protected Thread m_thread;
    protected boolean m_bRunning;
    protected boolean m_bRedraw;
    protected Button m_bLicCalc;
    static /* synthetic */ Class class$vgp$vector$rungeKutta$PjRungeKutta;

    public PjRungeKutta() {
        super("Geodesic Runge-Kutta");
        this.setFileName(PsConfig.getCodeBase() + m_defFileName);
        this.m_import = new PjImportModel();
        this.m_import.setTypeOfInfoPanel(0);
        this.m_import.addActionListener((ActionListener)this);
        this.m_length = new PuDouble("Length", (PsUpdateIf)this);
        this.m_discr = new PuInteger("Discr", (PsUpdateIf)this);
        this.m_geom = new PgElementSet(3);
        this.m_geom.setDimOfElements(3);
        this.m_geom.setName("Base Surface");
        this.m_vec = new PgVectorField(3);
        this.m_vec.setName("Vector Field");
        this.m_vec.setGeometry((PgPointSet)this.m_geom);
        this.m_poly = new PgPolygonOnElementSet(3);
        this.m_poly.setName("Integral Curve");
        this.m_poly.setGeometry(this.m_geom);
        this.m_bary = new PdBary(1.0, 0.0, 0.0);
        this.m_LICSize = new PuInteger("Lic image size", null);
        if (this.getClass() == (class$vgp$vector$rungeKutta$PjRungeKutta == null ? (class$vgp$vector$rungeKutta$PjRungeKutta = PjRungeKutta.class$("vgp.vector.rungeKutta.PjRungeKutta")) : class$vgp$vector$rungeKutta$PjRungeKutta)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_method = 1;
        this.m_length.setDefBounds(0.05, 10.0, 0.5, 1.0);
        this.m_length.setDefValue(1.0);
        this.m_length.init();
        this.m_discr.setDefBounds(2, 100, 5, 10);
        this.m_discr.setDefValue(20);
        this.m_discr.init();
        this.m_LICSize.setDefBounds(10, 500, 10, 50);
        this.m_LICSize.setDefValue(130);
        this.m_LICSize.init();
        this.m_time = 0.0;
        this.m_bFast = false;
        this.m_bRunning = false;
        this.m_bRedraw = true;
    }

    public void start() {
        super.start();
        this.addGeometry((PgGeometryIf)this.m_geom);
        this.addGeometry((PgGeometryIf)this.m_poly);
        this.selectGeometry((PgGeometryIf)this.m_geom);
        this.load();
        this.getDisplay().setMajorMode(6);
    }

    public boolean update(Object object) {
        if (this.isUpdateSender()) {
            return true;
        }
        if (object == this) {
            this.computeIntegralCurve(this.m_elemInd, this.m_bary, this.m_length.getValue(), this.m_discr.getValue());
            this.setUpdateSender(true);
            this.m_poly.update((Object)this.m_poly);
            this.setUpdateSender(false);
            return super.update(null);
        }
        if (object == this.m_geom) {
            return super.update(null);
        }
        if (object == this.m_length || object == this.m_discr) {
            return this.update(this);
        }
        return super.update(object);
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public void setFileName(String string) {
        if (string == null) {
            return;
        }
        this.m_fileName = string;
        m_defFileName = string;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_import) {
            PgGeometryIf pgGeometryIf = this.m_import.getGeometry(0);
            if (pgGeometryIf == null || !(pgGeometryIf instanceof PgElementSet)) {
                PsDebug.warning((String)"missing geometry, or not of type PgElementSet");
                return;
            }
            this.setGeometry((PgElementSet)pgGeometryIf);
        }
    }

    public boolean load() {
        boolean bl = this.m_import.load(this.m_fileName);
        if (!bl) {
            return false;
        }
        PgGeometryIf pgGeometryIf = this.m_import.getGeometry(0);
        if (pgGeometryIf == null || !(pgGeometryIf instanceof PgElementSet)) {
            PsDebug.warning((String)"missing geometry, or not of type PgElementSet");
            return false;
        }
        return this.setGeometry((PgElementSet)pgGeometryIf);
    }

    public boolean setGeometry(PgElementSet pgElementSet) {
        if (this.isRunning()) {
            this.stopLIC();
        }
        if (pgElementSet.getDimOfElements() != 3 && !PgElementSet.triangulate((PgElementSet)pgElementSet)) {
            return false;
        }
        this.m_geom.copy((PsObject)pgElementSet);
        this.m_geom.showVertices(false);
        this.m_geom.removeAllVectorFields();
        this.m_geom.addVectorField(this.m_vec);
        this.m_vec.setGeometry((PgPointSet)this.m_geom);
        this.computeRandomVectorField();
        this.calculateRepresentations();
        this.m_geom.update((Object)this.m_geom);
        this.m_poly.setNumVertices(0);
        this.m_poly.update((Object)this.m_poly);
        this.fitDisplays();
        return true;
    }

    public void setMethod(int n) {
        this.m_method = n;
        this.calculateRepresentations();
    }

    public void pickInitial(PvPickEvent pvPickEvent) {
        if (pvPickEvent.getElementInd() < 0) {
            return;
        }
        int n = pvPickEvent.getBary().getSize();
        if (n != 3) {
            PsDebug.warning((String)("void barycentric dimension, dim=" + n));
            return;
        }
        this.m_bary.copy(pvPickEvent.getBary());
        this.m_elemInd = pvPickEvent.getElementInd();
        this.update(this);
    }

    public boolean isEnabledFast() {
        return this.m_bFast;
    }

    public void setEnabledFast(boolean bl) {
        this.m_bFast = bl;
    }

    public double getTime() {
        return this.m_time;
    }

    public boolean isRunning() {
        return this.m_bRunning;
    }

    public void startLIC() {
        if (this.m_bRunning) {
            return;
        }
        this.m_bRunning = true;
        this.m_thread = new Thread((Runnable)this, "JavaView: LIC Computation");
        this.m_thread.setPriority(5);
        this.m_thread.start();
    }

    public void stopLIC() {
        if (!this.m_bRunning) {
            return;
        }
        this.m_thread = null;
    }

    public void run() {
        PnTranslationRK pnTranslationRK;
        PgElementSet pgElementSet = this.m_geom;
        pgElementSet.showElements(true);
        pgElementSet.showElementTexture(true);
        if (this.m_method == 4) {
            pnTranslationRK = new PnTranslationRK(pgElementSet);
            pnTranslationRK.setVectorField(this.m_origelem, this.m_origvec, this.m_origlocvertind);
        } else {
            pnTranslationRK = new PnVertexRK(pgElementSet);
            ((PnVertexRK)pnTranslationRK).setVectorField(this.m_altvec);
        }
        pnTranslationRK.setFirstOrder(this.m_bFast);
        PgTexture pgTexture = new PgTexture();
        Frame frame = PsConfig.getFrame();
        PnLIC pnLIC = new PnLIC(pgElementSet, this.m_LICSize.getValue(), (PnGeodesicRK)pnTranslationRK);
        int n = pnLIC.getTextureWidth();
        int n2 = pnLIC.getTextureHeight();
        int[] nArray = new int[n * n2];
        long l = new Date().getTime();
        int n3 = pgElementSet.getNumElements();
        for (int i = 0; i < n3; ++i) {
            if (this.m_bLicCalc != null) {
                this.m_bLicCalc.setLabel("LIC " + i * 100 / n3 + "%");
            }
            pnLIC.makeElement(i);
            if (this.m_bRedraw) {
                pnLIC.getPixArray(nArray);
                pgTexture.setImage(frame.createImage(new MemoryImageSource(n, n2, nArray, 0, n)));
                pgElementSet.setTexture(pgTexture);
                pgElementSet.update((Object)pgElementSet);
            }
            if (this.m_thread == null) break;
        }
        if (!this.m_bRedraw) {
            pnLIC.getPixArray(nArray);
            pgTexture.setImage(frame.createImage(new MemoryImageSource(n, n2, nArray, 0, n)));
            pgElementSet.setTexture(pgTexture);
            pgElementSet.update((Object)pgElementSet);
        }
        if (this.m_bLicCalc != null) {
            this.m_bLicCalc.setLabel("Calculate Lic");
        }
        this.m_time = new Date().getTime() - l;
        System.gc();
        this.update(null);
        this.m_bRunning = false;
    }

    public void computeRandomVectorField() {
        if (this.m_geom == null) {
            PsDebug.warning((String)"missing geometry.");
            return;
        }
        this.m_origvec = new PdBaryDir[this.m_geom.getNumVertices()];
        this.m_origelem = new int[this.m_geom.getNumVertices()];
        this.m_origlocvertind = new int[this.m_geom.getNumVertices()];
        PdVector pdVector = new PdVector(3);
        PiVector[] piVectorArray = this.m_geom.getElements();
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        int n = this.m_geom.getNumVertices();
        int n2 = this.m_geom.getNumElements();
        for (int i = 0; i < n; ++i) {
            int n3;
            int n4;
            this.m_origvec[i] = new PdBaryDir(3);
            boolean bl = false;
            int n5 = 0;
            block1: for (n4 = 0; !bl && n4 < n2; ++n4) {
                for (n3 = 0; n3 < 3; ++n3) {
                    if (piVectorArray[n4].m_data[n3] != i) continue;
                    n5 = n3;
                    bl = true;
                    continue block1;
                }
            }
            if (!bl) continue;
            this.m_origelem[i] = --n4;
            this.m_origlocvertind[i] = n5;
            this.m_origvec[i].m_data[(n5 + 1) % 3] = (Math.random() + (i == 9 ? 0.3 : 0.0)) / (double)(i == 3 || i == 14 ? 2 : 1);
            this.m_origvec[i].m_data[(n5 + 2) % 3] = (Math.random() + (i == 9 ? 0.3 : 0.0)) / (i == 3 ? 0.5 : 1.0) / (double)(i == 14 ? 2 : 1);
            this.m_origvec[i].m_data[n5] = -(this.m_origvec[i].m_data[(n5 + 1) % 3] + this.m_origvec[i].m_data[(n5 + 2) % 3]);
            for (n3 = 0; n3 < 3; ++n3) {
                pdVector.m_data[n3] = 0.0;
                for (int j = 0; j < 3; ++j) {
                    int n6 = n3;
                    pdVector.m_data[n6] = pdVector.m_data[n6] + this.m_origvec[i].m_data[j] * pdVectorArray[piVectorArray[n4].m_data[j]].m_data[n3];
                }
            }
            this.m_vec.setVector(i, pdVector);
        }
    }

    public void calculateRepresentations() {
        if (this.m_geom == null) {
            PsDebug.warning((String)"No valid geometry");
            return;
        }
        if (this.m_method == 4) {
            this.m_ode = new PnTranslationRK(this.m_geom);
            ((PnTranslationRK)this.m_ode).setVectorField(this.m_origelem, this.m_origvec, this.m_origlocvertind);
            return;
        }
        if (this.m_geom.getNumElements() < 1) {
            return;
        }
        this.m_altvec = new PdBaryDir[this.m_geom.getNumElements()][3];
        PiVector piVector = new PiVector();
        PiVector piVector2 = new PiVector();
        for (int i = 0; i < this.m_geom.getNumVertices(); ++i) {
            PdBaryDir[] pdBaryDirArray = this.m_method == 2 ? PwBary.getGeodRepresentation((PgElementSet)this.m_geom, (int)this.m_origelem[i], (PdBaryDir)this.m_origvec[i], (int)this.m_origlocvertind[i], (PiVector)piVector, (PiVector)piVector2) : (this.m_method == 3 ? PwBary.getTransRepresentation((PgElementSet)this.m_geom, (int)this.m_origelem[i], (PdBaryDir)this.m_origvec[i], (int)this.m_origlocvertind[i], (PiVector)piVector, (PiVector)piVector2) : PwBary.getProjRepresentation((PgElementSet)this.m_geom, (int)this.m_origelem[i], (PdBaryDir)this.m_origvec[i], (int)this.m_origlocvertind[i], (PiVector)piVector, (PiVector)piVector2));
            int n = piVector.getSize();
            for (int j = 0; j < n; ++j) {
                this.m_altvec[piVector.m_data[j]][piVector2.m_data[j]] = pdBaryDirArray[j];
            }
        }
        this.m_ode = new PnVertexRK(this.m_geom);
        ((PnVertexRK)this.m_ode).setVectorField(this.m_altvec);
    }

    public void computeIntegralCurve(int n, PdBary pdBary, double d, int n2) {
        if (this.m_geom == null) {
            PsDebug.warning((String)"missing geometry");
            return;
        }
        this.m_ode.setFirstOrder(this.m_bFast);
        this.m_ode.solve(this.m_poly, n, pdBary, this.m_length.getValue() / (double)n2, n2);
        this.m_poly.computeVertices();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

