/*
 * Decompiled with CFR 0.152.
 */
package vgp.surface.common;

import jv.function.PuFunction;
import jv.number.PuDouble;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;
import vgp.surface.common.PgSurfaceDescr;

public class PgSurface_Sphere
extends PgSurfaceDescr {
    private double m_defRadius = 1.0;
    private double m_defX = 0.0;
    private double m_defY = 0.0;
    private double m_defZ = 0.0;
    protected PuDouble m_radius;
    protected PuDouble m_x;
    protected PuDouble m_y;
    protected PuDouble m_z;
    static /* synthetic */ Class class$vgp$surface$common$PgSurface_Sphere;

    public PgSurface_Sphere() {
        this.setName("Sphere");
        this.m_function = new PuFunction(2, 3);
        this.m_radius = new PuDouble("Sphere Radius", (PsUpdateIf)this);
        this.m_x = new PuDouble("Center (x)", (PsUpdateIf)this);
        this.m_y = new PuDouble("Center (y)", (PsUpdateIf)this);
        this.m_z = new PuDouble("Center (z)", (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$vgp$surface$common$PgSurface_Sphere == null ? (class$vgp$surface$common$PgSurface_Sphere = PgSurface_Sphere.class$("vgp.surface.common.PgSurface_Sphere")) : class$vgp$surface$common$PgSurface_Sphere)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.setSize(-1.5707963267948966, -1.5707963267948966, 4.71238898038469, 1.5707963267948966);
        this.setDiscr(17, 17);
        this.m_radius.setDefBounds(0.0, 20.0, 0.02, 0.2);
        this.m_radius.setDefValue(this.m_defRadius);
        this.m_radius.init();
        this.addParameter((PsObject)this.m_radius);
        this.m_x.setDefBounds(-20.0, 20.0, 0.02, 0.2);
        this.m_x.setDefValue(this.m_defX);
        this.m_x.init();
        this.addParameter((PsObject)this.m_x);
        this.m_y.setDefBounds(-20.0, 20.0, 0.02, 0.2);
        this.m_y.setDefValue(this.m_defY);
        this.m_y.init();
        this.addParameter((PsObject)this.m_y);
        this.m_z.setDefBounds(-20.0, 20.0, 0.02, 0.2);
        this.m_z.setDefValue(this.m_defZ);
        this.m_z.init();
        this.addParameter((PsObject)this.m_z);
        this.m_function.setName("Coordinate Functions");
        this.m_function.setExpression(0, "r*cos(v)*cos(u)+x");
        this.m_function.setExpression(1, "r*cos(v)*sin(u)+y");
        this.m_function.setExpression(2, "r*sin(v)+z");
        this.m_function.addParameter("r", this.m_radius.getValue());
        this.m_function.addParameter("x", this.m_x.getValue());
        this.m_function.addParameter("y", this.m_y.getValue());
        this.m_function.addParameter("z", this.m_z.getValue());
        this.setFunction(this.m_function);
        this.useFunctionExpression(true);
    }

    public boolean update(Object object) {
        if (object == this.m_radius) {
            this.m_function.setParameter("r", this.m_radius.getValue());
            return super.update(null);
        }
        if (object == this.m_x) {
            this.m_function.setParameter("x", this.m_x.getValue());
            return super.update(null);
        }
        if (object == this.m_y) {
            this.m_function.setParameter("y", this.m_y.getValue());
            return super.update(null);
        }
        if (object == this.m_z) {
            this.m_function.setParameter("z", this.m_z.getValue());
            return super.update(null);
        }
        return super.update(object);
    }

    public boolean isUPeriodic() {
        return this.getUMax() - this.getUMin() >= Math.PI * 2;
    }

    public boolean calc_f(PdVector pdVector, double d, double d2) {
        double d3 = this.m_radius.getValue();
        pdVector.set(d3 * Math.cos(d2) * Math.cos(d) + this.m_x.getValue(), d3 * Math.cos(d2) * Math.sin(d) + this.m_y.getValue(), d3 * Math.sin(d2) + this.m_z.getValue());
        return true;
    }

    protected PdVector calc_df_dU(double d, double d2) {
        PdVector pdVector = new PdVector(3);
        double d3 = this.m_radius.getValue();
        pdVector.set(-d3 * Math.sin(d) * Math.cos(d2), d3 * Math.cos(d) * Math.cos(d2), 0.0);
        return pdVector;
    }

    protected PdVector calc_df_dV(double d, double d2) {
        PdVector pdVector = new PdVector(3);
        double d3 = this.m_radius.getValue();
        pdVector.set(-d3 * Math.cos(d) * Math.sin(d2), -d3 * Math.sin(d) * Math.sin(d2), d3 * Math.cos(d2));
        return pdVector;
    }

    protected PdVector calc_ddf_dUdU(double d, double d2) {
        PdVector pdVector = new PdVector(3);
        double d3 = this.m_radius.getValue();
        pdVector.set(-d3 * Math.cos(d) * Math.cos(d2), -d3 * Math.sin(d) * Math.cos(d2), 0.0);
        return pdVector;
    }

    protected PdVector calc_ddf_dVdV(double d, double d2) {
        PdVector pdVector = new PdVector(3);
        double d3 = this.m_radius.getValue();
        pdVector.set(-d3 * Math.cos(d) * Math.cos(d2), -d3 * Math.sin(d) * Math.cos(d2), -d3 * Math.sin(d2));
        return pdVector;
    }

    protected PdVector calc_ddf_dUdV(double d, double d2) {
        PdVector pdVector = new PdVector(3);
        double d3 = this.m_radius.getValue();
        pdVector.set(d3 * Math.sin(d) * Math.sin(d2), -d3 * Math.cos(d) * Math.sin(d2), 0.0);
        return pdVector;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

